/*
 * Instance API
 *
 * # Introduction  ## Endpoints  Scaleway instance API can be reach on  - `https://api.scaleway.com/instance/v1/zones/fr-par-1` - `https://api.scaleway.com/instance/v1/zones/fr-par-2` - `https://api.scaleway.com/instance/v1/zones/nl-ams-1` - `https://api.scaleway.com/instance/v1/zones/pl-waw-1`  Older endpoints are still reachable but should not be used for new projects  - `https://cp-par1.scaleway.com` - `https://cp-ams1.scaleway.com`  <Example>  The following code is an example request to retrieve detailed information about a volume:  ``` % curl -H 'X-Auth-Token: xxxxxxxx-xxxx-xxxxx-xxxx-xxxxxxxxxxxxx' -H 'Content-Type: application/json' https://api.scaleway.com/instance/v1/zones/fr-par-1/volumes/f929fe39-63f8-4be8-a80e-1e9c8ae22a76 -i  HTTP/1.1 200 OK Server: nginx Date: Thu, 22 May 2014 07:55:00 GMT Content-Type: application/json Content-Length: 1345 Connection: keep-alive Strict-Transport-Security: max-age=86400  {   \"volumes\": [     {       \"export_uri\": null,       \"id\": \"f929fe39-63f8-4be8-a80e-1e9c8ae22a76\",       \"name\": \"volume-0-1\",       \"organization\": \"000a115d-2852-4b0a-9ce8-47f1134ba95a\",       \"server\": null,       \"size\": 10000000000,       \"volume_type\": \"l_ssd\"     },     {       \"export_uri\": null,       \"id\": \"0facb6b5-b117-441a-81c1-f28b1d723779\",       \"name\": \"volume-0-2\",       \"organization\": \"000a115d-2852-4b0a-9ce8-47f1134ba95a\",       \"server\": null,       \"size\": 20000000000,       \"volume_type\": \"l_ssd\"     }   ] } ```  </Example>  ## Pagination  Most of listing requests receive a paginated response.  **Paginated request**  Requests against paginated endpoints accept two `query` arguments:  - `page`, a positive integer to choose the page to return. - `per_page`, an positive integer lower or equal to 100 to select the number of   items to return. The default value is `50`.  Paginated endpoints usually also accept filters to search and sort results. These filters are documented along each endpoint documentation.  **Paginated response**  ```bash % curl -H 'X-Auth-Token: <token>' 'https://api.scaleway.com/instance/v1/zones/fr-par-1/images/?page=2&per_page=10' -i HTTP/1.0 200 OK [...] X-Total-Count: 209 [...] ```  The `X-Total-Count` header contains the total number of items for the resource.
 *
 * The version of the OpenAPI document: v1
 *
 * Generated by: https://openapi-generator.tech
 */

/// ScalewayK8sV1ClusterAutoscalerConfig : The autoscaler config for the cluster

#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScalewayK8sV1ClusterAutoscalerConfig {
    /// Disable the cluster autoscaler
    #[serde(
        rename = "scale_down_disabled",
        skip_serializing_if = "Option::is_none"
    )]
    pub scale_down_disabled: Option<bool>,
    /// How long after scale up that scale down evaluation resumes
    #[serde(
        rename = "scale_down_delay_after_add",
        skip_serializing_if = "Option::is_none"
    )]
    pub scale_down_delay_after_add: Option<String>,
    /// Type of resource estimator to be used in scale up
    #[serde(rename = "estimator", skip_serializing_if = "Option::is_none")]
    pub estimator: Option<Estimator>,
    /// Type of node group expander to be used in scale up
    #[serde(rename = "expander", skip_serializing_if = "Option::is_none")]
    pub expander: Option<Expander>,
    /// Ignore DaemonSet pods when calculating resource utilization for scaling down
    #[serde(
        rename = "ignore_daemonsets_utilization",
        skip_serializing_if = "Option::is_none"
    )]
    pub ignore_daemonsets_utilization: Option<bool>,
    /// Detect similar node groups and balance the number of nodes between them
    #[serde(
        rename = "balance_similar_node_groups",
        skip_serializing_if = "Option::is_none"
    )]
    pub balance_similar_node_groups: Option<bool>,
    /// Pods with priority below cutoff will be expendable. They can be killed without any consideration during scale down and they don't cause scale up. Pods with null priority (PodPriority disabled) are non expendable.
    #[serde(
        rename = "expendable_pods_priority_cutoff",
        skip_serializing_if = "Option::is_none"
    )]
    pub expendable_pods_priority_cutoff: Option<f32>,
    /// How long a node should be unneeded before it is eligible for scale down
    #[serde(
        rename = "scale_down_unneeded_time",
        skip_serializing_if = "Option::is_none"
    )]
    pub scale_down_unneeded_time: Option<String>,
    /// Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
    #[serde(
        rename = "scale_down_utilization_threshold",
        skip_serializing_if = "Option::is_none"
    )]
    pub scale_down_utilization_threshold: Option<f32>,
    /// Maximum number of seconds the cluster autoscaler waits for pod termination when trying to scale down a node
    #[serde(
        rename = "max_graceful_termination_sec",
        skip_serializing_if = "Option::is_none"
    )]
    pub max_graceful_termination_sec: Option<f32>,
}

impl ScalewayK8sV1ClusterAutoscalerConfig {
    /// The autoscaler config for the cluster
    pub fn new() -> ScalewayK8sV1ClusterAutoscalerConfig {
        ScalewayK8sV1ClusterAutoscalerConfig {
            scale_down_disabled: None,
            scale_down_delay_after_add: None,
            estimator: None,
            expander: None,
            ignore_daemonsets_utilization: None,
            balance_similar_node_groups: None,
            expendable_pods_priority_cutoff: None,
            scale_down_unneeded_time: None,
            scale_down_utilization_threshold: None,
            max_graceful_termination_sec: None,
        }
    }
}

/// Type of resource estimator to be used in scale up
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Estimator {
    #[serde(rename = "unknown_estimator")]
    UnknownEstimator,
    #[serde(rename = "binpacking")]
    Binpacking,
}
/// Type of node group expander to be used in scale up
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Expander {
    #[serde(rename = "unknown_expander")]
    UnknownExpander,
    #[serde(rename = "random")]
    Random,
    #[serde(rename = "most_pods")]
    MostPods,
    #[serde(rename = "least_waste")]
    LeastWaste,
    #[serde(rename = "priority")]
    Priority,
    #[serde(rename = "price")]
    Price,
}
