/*
 * Instance API
 *
 * # Introduction  ## Endpoints  Scaleway instance API can be reach on  - `https://api.scaleway.com/instance/v1/zones/fr-par-1` - `https://api.scaleway.com/instance/v1/zones/fr-par-2` - `https://api.scaleway.com/instance/v1/zones/nl-ams-1` - `https://api.scaleway.com/instance/v1/zones/pl-waw-1`  Older endpoints are still reachable but should not be used for new projects  - `https://cp-par1.scaleway.com` - `https://cp-ams1.scaleway.com`  <Example>  The following code is an example request to retrieve detailed information about a volume:  ``` % curl -H 'X-Auth-Token: xxxxxxxx-xxxx-xxxxx-xxxx-xxxxxxxxxxxxx' -H 'Content-Type: application/json' https://api.scaleway.com/instance/v1/zones/fr-par-1/volumes/f929fe39-63f8-4be8-a80e-1e9c8ae22a76 -i  HTTP/1.1 200 OK Server: nginx Date: Thu, 22 May 2014 07:55:00 GMT Content-Type: application/json Content-Length: 1345 Connection: keep-alive Strict-Transport-Security: max-age=86400  {   \"volumes\": [     {       \"export_uri\": null,       \"id\": \"f929fe39-63f8-4be8-a80e-1e9c8ae22a76\",       \"name\": \"volume-0-1\",       \"organization\": \"000a115d-2852-4b0a-9ce8-47f1134ba95a\",       \"server\": null,       \"size\": 10000000000,       \"volume_type\": \"l_ssd\"     },     {       \"export_uri\": null,       \"id\": \"0facb6b5-b117-441a-81c1-f28b1d723779\",       \"name\": \"volume-0-2\",       \"organization\": \"000a115d-2852-4b0a-9ce8-47f1134ba95a\",       \"server\": null,       \"size\": 20000000000,       \"volume_type\": \"l_ssd\"     }   ] } ```  </Example>  ## Pagination  Most of listing requests receive a paginated response.  **Paginated request**  Requests against paginated endpoints accept two `query` arguments:  - `page`, a positive integer to choose the page to return. - `per_page`, an positive integer lower or equal to 100 to select the number of   items to return. The default value is `50`.  Paginated endpoints usually also accept filters to search and sort results. These filters are documented along each endpoint documentation.  **Paginated response**  ```bash % curl -H 'X-Auth-Token: <token>' 'https://api.scaleway.com/instance/v1/zones/fr-par-1/images/?page=2&per_page=10' -i HTTP/1.0 200 OK [...] X-Total-Count: 209 [...] ```  The `X-Total-Count` header contains the total number of items for the resource.
 *
 * The version of the OpenAPI document: v1
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScalewayInstanceV1Server {
    /// The server unique ID
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// The server name
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// The server organization ID
    #[serde(rename = "organization", skip_serializing_if = "Option::is_none")]
    pub organization: Option<String>,
    /// The server project ID
    #[serde(rename = "project", skip_serializing_if = "Option::is_none")]
    pub project: Option<String>,
    /// Provide as list of allowed actions on the server
    #[serde(rename = "allowed_actions", skip_serializing_if = "Option::is_none")]
    pub allowed_actions: Option<Vec<crate::models::ScalewayInstanceV1ServerAction>>,
    /// The server associated tags
    #[serde(rename = "tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<String>>,
    /// The server commercial type (eg. GP1-M)
    #[serde(rename = "commercial_type", skip_serializing_if = "Option::is_none")]
    pub commercial_type: Option<String>,
    /// The server creation date
    #[serde(rename = "creation_date", skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<String>,
    /// True if a dynamic IP is required
    #[serde(
        rename = "dynamic_ip_required",
        skip_serializing_if = "Option::is_none"
    )]
    pub dynamic_ip_required: Option<bool>,
    /// True if IPv6 is enabled
    #[serde(rename = "enable_ipv6", skip_serializing_if = "Option::is_none")]
    pub enable_ipv6: Option<bool>,
    /// The server host name
    #[serde(rename = "hostname", skip_serializing_if = "Option::is_none")]
    pub hostname: Option<String>,
    #[serde(rename = "image", skip_serializing_if = "Option::is_none")]
    pub image: Option<Box<crate::models::ScalewayInstanceV1ServerImage>>,
    /// The server protection option is activated
    #[serde(rename = "protected", skip_serializing_if = "Option::is_none")]
    pub protected: Option<bool>,
    /// The server private IP address
    #[serde(rename = "private_ip", skip_serializing_if = "Option::is_none")]
    pub private_ip: Option<String>,
    #[serde(rename = "public_ip", skip_serializing_if = "Option::is_none")]
    pub public_ip: Option<Box<crate::models::ScalewayInstanceV1ServerPublicIp>>,
    /// The server modification date
    #[serde(rename = "modification_date", skip_serializing_if = "Option::is_none")]
    pub modification_date: Option<String>,
    /// The server state
    #[serde(rename = "state", skip_serializing_if = "Option::is_none")]
    pub state: Option<State>,
    #[serde(rename = "location", skip_serializing_if = "Option::is_none")]
    pub location: Option<Box<crate::models::ScalewayInstanceV1ServerLocation>>,
    #[serde(rename = "ipv6", skip_serializing_if = "Option::is_none")]
    pub ipv6: Option<Box<crate::models::ScalewayInstanceV1ServerIpv6>>,
    #[serde(rename = "bootscript", skip_serializing_if = "Option::is_none")]
    pub bootscript: Option<Box<crate::models::ScalewayInstanceV1ServerBootscript>>,
    /// The server boot type
    #[serde(rename = "boot_type", skip_serializing_if = "Option::is_none")]
    pub boot_type: Option<BootType>,
    /// The server volumes
    #[serde(rename = "volumes", skip_serializing_if = "Option::is_none")]
    pub volumes: Option<::std::collections::HashMap<String, serde_json::Value>>,
    #[serde(rename = "security_group", skip_serializing_if = "Option::is_none")]
    pub security_group: Option<Box<crate::models::ScalewayInstanceV1ServerSecurityGroup>>,
    /// The server planned maintenances
    #[serde(rename = "maintenances", skip_serializing_if = "Option::is_none")]
    pub maintenances: Option<Vec<serde_json::Value>>,
    /// The server state_detail
    #[serde(rename = "state_detail", skip_serializing_if = "Option::is_none")]
    pub state_detail: Option<String>,
    /// The server arch
    #[serde(rename = "arch", skip_serializing_if = "Option::is_none")]
    pub arch: Option<Arch>,
    #[serde(rename = "placement_group", skip_serializing_if = "Option::is_none")]
    pub placement_group: Option<Box<crate::models::ScalewayInstanceV1ServerPlacementGroup>>,
    /// The server private NICs
    #[serde(rename = "private_nics", skip_serializing_if = "Option::is_none")]
    pub private_nics: Option<Vec<crate::models::ScalewayInstanceV1PrivateNic>>,
    /// The zone in which is the server
    #[serde(rename = "zone", skip_serializing_if = "Option::is_none")]
    pub zone: Option<String>,
}

impl ScalewayInstanceV1Server {
    pub fn new() -> ScalewayInstanceV1Server {
        ScalewayInstanceV1Server {
            id: None,
            name: None,
            organization: None,
            project: None,
            allowed_actions: None,
            tags: None,
            commercial_type: None,
            creation_date: None,
            dynamic_ip_required: None,
            enable_ipv6: None,
            hostname: None,
            image: None,
            protected: None,
            private_ip: None,
            public_ip: None,
            modification_date: None,
            state: None,
            location: None,
            ipv6: None,
            bootscript: None,
            boot_type: None,
            volumes: None,
            security_group: None,
            maintenances: None,
            state_detail: None,
            arch: None,
            placement_group: None,
            private_nics: None,
            zone: None,
        }
    }
}

/// The server state
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum State {
    #[serde(rename = "running")]
    Running,
    #[serde(rename = "stopped")]
    Stopped,
    #[serde(rename = "stopped in place")]
    StoppedInPlace,
    #[serde(rename = "starting")]
    Starting,
    #[serde(rename = "stopping")]
    Stopping,
    #[serde(rename = "locked")]
    Locked,
}
/// The server boot type
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum BootType {
    #[serde(rename = "local")]
    Local,
    #[serde(rename = "bootscript")]
    Bootscript,
    #[serde(rename = "rescue")]
    Rescue,
}
/// The server arch
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Arch {
    #[serde(rename = "x86_64")]
    X8664,
    #[serde(rename = "arm")]
    Arm,
}
