pub mod default_toml;
pub mod error;
pub mod group_reader;
pub mod toml_editor;
pub mod version_getter;

pub fn add_groups(
    toml: &mut toml_editor::Config,
    groups: &std::collections::HashMap<String, Vec<group_reader::Dependency>>,
    group_names: &[String],
    ask: bool,
    verbose: bool,
    use_tilde_version: bool,
) -> Result<(), error::Error> {
    for group_name in group_names {
        match groups.get(group_name) {
            Some(group) => {
                for dependency in group {
                    toml.add_dependency(ask, verbose, use_tilde_version, dependency);
                }
            }
            None => return Err(error::Error::GroupNotFound(group_name.to_string())),
        }
    }

    Ok(())
}
