# Rust API client for sbanken

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)


## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 2.0
- Package version: 0.0.1-alpha.2
- Build package: `org.openapitools.codegen.languages.RustClientCodegen`

## Installation

Put the package under your project folder in a directory named `sbanken` and add the following to `Cargo.toml` under `[dependencies]`:

```
sbanken = { path = "./sbanken" }
```

## Documentation for API Endpoints

All URIs are relative to *https://https://publicapi.sbanken.no/apibeta*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountsApi* | [**accounts_list**](docs/AccountsApi.md#accounts_list) | **GET** /api/v2/Accounts | Lists the accounts.
*AccountsApi* | [**accounts_read**](docs/AccountsApi.md#accounts_read) | **GET** /api/v2/Accounts/{accountId} | Reads an account
*CardsApi* | [**cards_list**](docs/CardsApi.md#cards_list) | **GET** /api/v2/Cards | Lists the cards.
*CustomersApi* | [**customers_read**](docs/CustomersApi.md#customers_read) | **GET** /api/v2/Customers | Get customer data
*EfakturaApi* | [**efaktura_list**](docs/EfakturaApi.md#efaktura_list) | **GET** /api/v2/Efaktura | List eFakturas.
*EfakturaApi* | [**efaktura_list_new**](docs/EfakturaApi.md#efaktura_list_new) | **GET** /api/v2/Efaktura/new | List eFakturas that have not yet been processed by the customer. These are considered \"new\".
*EfakturaApi* | [**efaktura_pay**](docs/EfakturaApi.md#efaktura_pay) | **POST** /api/v2/Efaktura | Pay an eFaktura.
*EfakturaApi* | [**efaktura_read**](docs/EfakturaApi.md#efaktura_read) | **GET** /api/v2/Efaktura/{eFakturaId} | Read an eFaktura.
*MailboxApi* | [**mailbox_count_archive_message**](docs/MailboxApi.md#mailbox_count_archive_message) | **GET** /api/v2/Mailbox/archive/count | Count the number of messages in your archive
*MailboxApi* | [**mailbox_count_inbox_message**](docs/MailboxApi.md#mailbox_count_inbox_message) | **GET** /api/v2/Mailbox/inbox/count | Count the number of messages in your inbox
*MailboxApi* | [**mailbox_delete_archive**](docs/MailboxApi.md#mailbox_delete_archive) | **DELETE** /api/v2/Mailbox/archive/{id} | Delete a message from your archive
*MailboxApi* | [**mailbox_delete_inbox**](docs/MailboxApi.md#mailbox_delete_inbox) | **DELETE** /api/v2/Mailbox/inbox/{id} | Delete a message from your inbox
*MailboxApi* | [**mailbox_list_archive**](docs/MailboxApi.md#mailbox_list_archive) | **GET** /api/v2/Mailbox/archive | List the messages in your archive
*MailboxApi* | [**mailbox_list_inbox**](docs/MailboxApi.md#mailbox_list_inbox) | **GET** /api/v2/Mailbox/inbox | List the messages in your inbox
*MailboxApi* | [**mailbox_move_to_archive**](docs/MailboxApi.md#mailbox_move_to_archive) | **PUT** /api/v2/Mailbox/inbox/{id}/move | Move a message from your inbox to your archive
*MailboxApi* | [**mailbox_move_to_inbox**](docs/MailboxApi.md#mailbox_move_to_inbox) | **PUT** /api/v2/Mailbox/archive/{id}/move | Move a message from your archive to your inbox 
*MailboxApi* | [**mailbox_read_archive**](docs/MailboxApi.md#mailbox_read_archive) | **GET** /api/v2/Mailbox/archive/{id} | Read a message from your archive.
*MailboxApi* | [**mailbox_read_archive_attachment**](docs/MailboxApi.md#mailbox_read_archive_attachment) | **GET** /api/v2/Mailbox/archive/{messageId}/attachment/{attachmentId} | Read the attachment of an archive message.
*MailboxApi* | [**mailbox_read_inbox**](docs/MailboxApi.md#mailbox_read_inbox) | **GET** /api/v2/Mailbox/inbox/{id} | Read a message from your inbox
*MailboxApi* | [**mailbox_read_inbox_attachment**](docs/MailboxApi.md#mailbox_read_inbox_attachment) | **GET** /api/v2/Mailbox/inbox/{messageId}/attachment/{attachmentId} | Read the attachment of an inbox message.
*MailboxApi* | [**mailbox_set_read_status_archive**](docs/MailboxApi.md#mailbox_set_read_status_archive) | **PUT** /api/v2/Mailbox/archive/{id}/readstatus | Sets the read/unread status of a message in your archive to the indicated value
*MailboxApi* | [**mailbox_set_read_status_inbox**](docs/MailboxApi.md#mailbox_set_read_status_inbox) | **PUT** /api/v2/Mailbox/inbox/{id}/readstatus | Sets the read/unread status of a message in your inbox to the indicated value
*PaymentsApi* | [**payments_list**](docs/PaymentsApi.md#payments_list) | **GET** /api/v2/Payments/{accountId} | List the payments. These payments are awaiting processing. Payments are processed on the due date.
*PaymentsApi* | [**payments_read**](docs/PaymentsApi.md#payments_read) | **GET** /api/v2/Payments/{accountId}/{paymentId} | Read a payment.
*StandingOrdersApi* | [**standing_orders_list_standing_orders**](docs/StandingOrdersApi.md#standing_orders_list_standing_orders) | **GET** /api/v2/StandingOrders/{accountId} | Lists the standing orders for repeated transfers and payments.
*TransactionsApi* | [**transactions_list**](docs/TransactionsApi.md#transactions_list) | **GET** /api/v2/Transactions/{accountId} | Get Transactions
*TransactionsApi* | [**transactions_list_archive**](docs/TransactionsApi.md#transactions_list_archive) | **GET** /api/v2/Transactions/archive/{accountId} | Get Archived Transactions (Norwegian: bokført) with transactionId
*TransfersApi* | [**transfers_create**](docs/TransfersApi.md#transfers_create) | **POST** /api/v2/Transfers | This operation executes a transfer between two accounts.


## Documentation For Models

 - [Account](docs/Account.md)
 - [Address](docs/Address.md)
 - [ArchiveTransaction](docs/ArchiveTransaction.md)
 - [Card](docs/Card.md)
 - [CardDetails](docs/CardDetails.md)
 - [CardStatus](docs/CardStatus.md)
 - [Category](docs/Category.md)
 - [Customer](docs/Customer.md)
 - [EFaktura](docs/EFaktura.md)
 - [EFakturaPayRequest](docs/EFakturaPayRequest.md)
 - [EFakturaSimple](docs/EFakturaSimple.md)
 - [ListResultOfAccount](docs/ListResultOfAccount.md)
 - [ListResultOfArchiveTransaction](docs/ListResultOfArchiveTransaction.md)
 - [ListResultOfCard](docs/ListResultOfCard.md)
 - [ListResultOfEFaktura](docs/ListResultOfEFaktura.md)
 - [ListResultOfEFakturaSimple](docs/ListResultOfEFakturaSimple.md)
 - [ListResultOfMessageListItem](docs/ListResultOfMessageListItem.md)
 - [ListResultOfPayment](docs/ListResultOfPayment.md)
 - [ListResultOfStandingOrder](docs/ListResultOfStandingOrder.md)
 - [ListResultOfTransaction](docs/ListResultOfTransaction.md)
 - [MailboxAttachment](docs/MailboxAttachment.md)
 - [MessageItem](docs/MessageItem.md)
 - [MessageListItem](docs/MessageListItem.md)
 - [NewStatusType](docs/NewStatusType.md)
 - [Payment](docs/Payment.md)
 - [PhoneNumber](docs/PhoneNumber.md)
 - [ProductCode](docs/ProductCode.md)
 - [ReservationType](docs/ReservationType.md)
 - [SetReadStatusRequest](docs/SetReadStatusRequest.md)
 - [SourceType](docs/SourceType.md)
 - [StandingOrder](docs/StandingOrder.md)
 - [StandingOrderFrequency](docs/StandingOrderFrequency.md)
 - [StandingOrderType](docs/StandingOrderType.md)
 - [Status](docs/Status.md)
 - [Transaction](docs/Transaction.md)
 - [TransactionDetail](docs/TransactionDetail.md)
 - [TransferCreateRequest](docs/TransferCreateRequest.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author



