#[macro_export]
macro_rules! unwrap_return {
    ($obj:ident { $ret:expr }) => (
        if let Err(_) = $obj {
            return $ret;
        } let $obj = $obj.unwrap();
    );

    ($obj:ident: $typ:ty { $ret:expr }) => (
        if let Err(_) = $obj {
            return $ret;
        } let $obj: $typ = $obj.unwrap();
    );

    (code = $cod:ident, $obj:ident: $typ:ty { $ret:expr }) => (
        if let Err($cod) = $obj {
            return $ret;
        } let $obj: $typ = $obj.unwrap();
    );

    (code = $cod:ident, $obj:ident { $ret:expr }) => (
        if let Err($cod) = $obj {
            return $ret;
        } let $obj = $obj.unwrap();
    );
}
