pub fn diesel_connect() -> Res<PgConnection> {
    dotenv::dotenv()?;

    let database_url = std::env::var("DATABASE_URL")?;
    Ok(PgConnection::establish(&database_url)?)
}

pub type PgPool = r2d2::Pool<r2d2::ConnectionManager<PgConnection>>;

pub fn diesel_pool_connect() -> Res<PgPool> {
    dotenv::dotenv()?;

    Ok(r2d2::Pool::builder().build(
        r2d2::ConnectionManager::<PgConnection>::new(std::env::var("DATABASE_URL")?)
    )?)
}
