#[macro_export]
macro_rules! tera_ctx {
    ($($key:expr => $val:expr),*) => {
        {
            let mut keys = Vec::new();
            let mut vals = Vec::new();

            $(
                keys.push($key);
                vals.push($val);
            )*

            saw::TeraContext(keys, vals)
        }
    }
}

pub fn TeraContext<S: Clone + Into<String>, T: serde::ser::Serialize> (
    keys: Vec<S>,
    vals: Vec<T>
) -> Context {
    if keys.len() != vals.len() {
        panic!("the number of keys does not match the number of values");
    }

    let mut ctx = Context::new();

    for i in 0..keys.len() {
        ctx.insert(keys[i].clone(), &vals[i]);
    } ctx
}
