pub struct Argument<T> where T: std::str::FromStr {
    arg: T,
}

impl<T: std::str::FromStr> Argument<T> {
    /// create a new argument with default argument value
    pub fn new(arg: T) -> Argument<T> {
        Argument { arg }
    }

    /// load an argument from a `str`
    /// # Arguments
    /// `arg_str`: the str to parse
    ///
    /// # Returns
    /// This function returns a `Result` that is an Error variant if parsing `arg_str` failed
    pub fn load_arg(&mut self, arg_str: &str) -> Result<(), T::Err>{
        if let Ok(n) = arg_str.parse::<T>() {
            self.arg = n;
            return Ok(());
        } else if let Err(e) = arg_str.parse::<T>() {
            return Err(e);
        }
        Ok(())
    }
}
