//! Foreign function interface for C part of implementation
//! (including C bindings for Lua)

pub use auto::*;
pub use ext::*;

/// Automatically generated FFI
mod auto {
    #![allow(warnings)]
    include!(concat!(env!("OUT_DIR"), "/ffi_cmach.rs"));
}

/// Manual extensions to FFI
mod ext {
    #![allow(dead_code)]
    #![allow(missing_docs)]

    use super::auto;
    use std::os::raw::*;

    pub unsafe fn lua_pop(l: *mut auto::lua_State, n: c_int) {
        auto::lua_settop(l, -n - 1);
    }

    pub unsafe fn lua_tointeger(l: *mut auto::lua_State, index: c_int) -> auto::lua_Integer {
        auto::lua_tointegerx(l, index, 0 as *mut _)
    }

    pub unsafe fn lua_tonumber(l: *mut auto::lua_State, index: c_int) -> auto::lua_Number {
        auto::lua_tonumberx(l, index, 0 as *mut _)
    }

    pub unsafe fn lua_pcall(
        l: *mut auto::lua_State,
        nargs: c_int,
        nresults: c_int,
        msgh: c_int,
    ) -> c_int {
        auto::lua_pcallk(l, nargs, nresults, msgh, 0, None)
    }

    pub unsafe fn lua_pushcfunction(l: *mut auto::lua_State, func: auto::lua_CFunction) {
        auto::lua_pushcclosure(l, func, 0);
    }
}
