pub struct List<K, V> {
    l: CowPage,
    k: core::marker::PhantomData<K>,
    v: core::marker::PhantomData<V>,
}

/// Create a database with an arbitrary page implementation.
pub fn create<T: AllocPage, K: ?Sized, V: ?Sized>(txn: &mut T) -> Result<List<K, V>, T::Error> {
    let mut page = txn.alloc_page()?;
    P::init(&mut page);
    Ok(Db_ {
        db: page.0.offset,
        k: core::marker::PhantomData,
        v: core::marker::PhantomData,
        p: core::marker::PhantomData,
    })
}
