// Implementation of multiplication function for cortex M4
//
// The code is derived from the register-allocating code generator
// for performance and correctness reasons. Do not edit by hand!
// 
// Author: bjoern haase bjoern.m.haase@web.de 
//
// License: CC0 1.0 (http://creativecommons.org/publicdomain/zero/1.0/legalcode)
//
// Code is now tested on various target and on QEmu testsuites.

#include "attributesForCortexM4.inc"

	.code	16
	
	.file	"cortex_m4_mpy_fe25519.S"
	
	.text
	.align	2

// ****************************************************
// Implementation of 256x256 bit bit multiply with partial reduction.
// uses packed non-redundant representation.
// 
// 
// implements the interface
//
// void
// fe25519_mul_asm (fe25519 *pResult, const fe25519 *pVal1, const fe25519 *pVal2);
//	
// in:
//    r0 == ptr to Result word
//    r1, r2 == prts to values to multiply
//
// Reduces modulo such that the result fits in 256 bits, i.e. not necessarily fully
// reduced!

	.global	fe25519_mul_asm
	.type	fe25519_mul_asm, %function
fe25519_mul_asm:
// ######################
// ASM fe25519 MPY and reduce for M4:
// ######################
 // START: fe25519 multiplication for M4 (MPY + partial reduce)
 // r0 = result ptr, r1,r2 = operand ptr.
    .syntax unified
    push {r0,r1,r2,r4,r5,r6,r7,r8,r9,r10,r11,r12,r14}
   .syntax divided
    add SP,#-32
    .syntax unified
    ldr r0,[r2,#0]
    .syntax divided
    .syntax unified
    ldr r3,[r2,#4]
    .syntax divided
    .syntax unified
    ldr r4,[r2,#8]
    .syntax divided
    .syntax unified
    ldr r5,[r2,#12]
    .syntax divided
    .syntax unified
    ldr r6,[r2,#16]
    .syntax divided
    .syntax unified
    ldr r7,[r1,#0]
    .syntax divided
    .syntax unified
    umull r8,r9,r7,r3
   .syntax divided
    .syntax unified
    umull r10,r11,r7,r0
   .syntax divided
    .syntax unified
    str r10,[SP,#0]
   .syntax divided
    .syntax unified
    eor r10,r10
   .syntax divided
    .syntax unified
    umull r12,r14,r10,r10
   .syntax divided
    .syntax unified
    umlal r9,r10,r7,r4
   .syntax divided
    .syntax unified
    umlal r10,r12,r7,r5
   .syntax divided
    .syntax unified
    umlal r12,r14,r7,r6
   .syntax divided
    .syntax unified
    ldr r7,[r1,#4]
    .syntax divided
    .syntax unified
    umaal r8,r11,r7,r0
   .syntax divided
    .syntax unified
    umaal r9,r11,r7,r3
   .syntax divided
    .syntax unified
    umaal r10,r11,r7,r4
   .syntax divided
    .syntax unified
    umaal r11,r12,r7,r5
   .syntax divided
    .syntax unified
    str r8,[SP,#4]
   .syntax divided
    .syntax unified
    eor r8,r8
   .syntax divided
    .syntax unified
    umaal r12,r14,r7,r6
   .syntax divided
    .syntax unified
    ldr r7,[r1,#8]
    .syntax divided
    .syntax unified
    umlal r9,r8,r7,r0
   .syntax divided
    .syntax unified
    umaal r8,r10,r7,r3
   .syntax divided
    .syntax unified
    umaal r10,r11,r7,r4
   .syntax divided
    .syntax unified
    umaal r11,r12,r7,r5
   .syntax divided
    .syntax unified
    str r9,[SP,#8]
   .syntax divided
    .syntax unified
    eor r9,r9
   .syntax divided
    .syntax unified
    umaal r12,r14,r7,r6
   .syntax divided
    .syntax unified
    ldr r7,[r1,#12]
    .syntax divided
    .syntax unified
    umlal r8,r9,r7,r0
   .syntax divided
    .syntax unified
    umaal r9,r10,r7,r3
   .syntax divided
    .syntax unified
    umaal r10,r11,r7,r4
   .syntax divided
    .syntax unified
    umaal r11,r12,r7,r5
   .syntax divided
    .syntax unified
    str r8,[SP,#12]
   .syntax divided
    .syntax unified
    eor r8,r8
   .syntax divided
    .syntax unified
    umaal r12,r14,r7,r6
   .syntax divided
    .syntax unified
    ldr r7,[r1,#16]
    .syntax divided
    .syntax unified
    umlal r9,r8,r7,r0
   .syntax divided
    .syntax unified
    umaal r8,r10,r7,r3
   .syntax divided
    .syntax unified
    umaal r10,r11,r7,r4
   .syntax divided
    .syntax unified
    umaal r11,r12,r7,r5
   .syntax divided
    .syntax unified
    str r9,[SP,#16]
   .syntax divided
    .syntax unified
    eor r9,r9
   .syntax divided
    .syntax unified
    umaal r12,r14,r7,r6
   .syntax divided
    .syntax unified
    ldr r2,[r1,#20]
    .syntax divided
    .syntax unified
    umlal r8,r9,r2,r0
   .syntax divided
    .syntax unified
    umaal r9,r10,r2,r3
   .syntax divided
    .syntax unified
    umaal r10,r11,r2,r4
   .syntax divided
    .syntax unified
    ldr r2,[r1,#24]
    .syntax divided
    .syntax unified
    eor r7,r7
   .syntax divided
    .syntax unified
    umlal r9,r7,r2,r0
   .syntax divided
    .syntax unified
    umaal r7,r10,r2,r3
   .syntax divided
    .syntax unified
    umaal r10,r11,r2,r4
   .syntax divided
    .syntax unified
    ldr r2,[r1,#28]
    .syntax divided
    .syntax unified
    umaal r10,r12,r2,r3
   .syntax divided
    .syntax unified
    umaal r11,r12,r2,r4
   .syntax divided
    ldr r0,[SP,#40]
    .syntax unified
    ldr r3,[r0,#20]
    .syntax divided
    .syntax unified
    ldr r4,[r0,#24]
    .syntax divided
    .syntax unified
    ldr r5,[r1,#0]
    .syntax divided
    .syntax unified
    eor r6,r6
   .syntax divided
    .syntax unified
    umlal r8,r6,r5,r3
   .syntax divided
    .syntax unified
    umaal r6,r9,r5,r4
   .syntax divided
    .syntax unified
    str r8,[SP,#20]
   .syntax divided
    .syntax unified
    ldr r8,[r0,#28]
    .syntax divided
    .syntax unified
    umaal r7,r9,r5,r8
   .syntax divided
    .syntax unified
    ldr r5,[r1,#4]
    .syntax divided
    .syntax unified
    eor r2,r2
   .syntax divided
    .syntax unified
    umlal r6,r2,r5,r3
   .syntax divided
    .syntax unified
    str r6,[SP,#24]
   .syntax divided
    .syntax unified
    umaal r2,r7,r5,r4
   .syntax divided
    .syntax unified
    umaal r7,r9,r5,r8
   .syntax divided
    .syntax unified
    ldr r5,[r1,#8]
    .syntax divided
    .syntax unified
    eor r6,r6
   .syntax divided
    .syntax unified
    umlal r2,r6,r5,r3
   .syntax divided
    .syntax unified
    umaal r6,r7,r5,r4
   .syntax divided
    .syntax unified
    umaal r7,r9,r5,r8
   .syntax divided
    .syntax unified
    ldr r5,[r1,#12]
    .syntax divided
    .syntax unified
    umaal r6,r10,r5,r3
   .syntax divided
    .syntax unified
    umaal r7,r10,r5,r4
   .syntax divided
    .syntax unified
    umaal r9,r10,r5,r8
   .syntax divided
    .syntax unified
    ldr r5,[r1,#16]
    .syntax divided
    .syntax unified
    umaal r7,r11,r5,r3
   .syntax divided
    .syntax unified
    umaal r9,r11,r5,r4
   .syntax divided
    .syntax unified
    umaal r10,r11,r5,r8
   .syntax divided
    .syntax unified
    ldr r5,[r1,#28]
    .syntax divided
    .syntax unified
    ldr r3,[r0,#0]
    .syntax divided
    .syntax unified
    eor r4,r4
   .syntax divided
    .syntax unified
    umlal r2,r4,r5,r3
   .syntax divided
    .syntax unified
    str r2,[SP,#28]
   .syntax divided
    .syntax unified
    ldr r2,[r1,#24]
    .syntax divided
    .syntax unified
    ldr r3,[r1,#20]
    .syntax divided
    .syntax unified
    ldr r1,[r0,#12]
    .syntax divided
    .syntax unified
    umaal r4,r6,r3,r1
   .syntax divided
    .syntax unified
    umaal r6,r7,r2,r1
   .syntax divided
    .syntax unified
    umaal r7,r9,r5,r1
   .syntax divided
    .syntax unified
    ldr r1,[r0,#16]
    .syntax divided
    .syntax unified
    umaal r6,r14,r3,r1
   .syntax divided
    .syntax unified
    umaal r7,r12,r2,r1
   .syntax divided
    .syntax unified
    umaal r9,r10,r5,r1
   .syntax divided
    .syntax unified
    ldr r1,[r0,#20]
    .syntax divided
    .syntax unified
    umaal r7,r14,r3,r1
   .syntax divided
    .syntax unified
    umaal r9,r12,r2,r1
   .syntax divided
    .syntax unified
    umaal r10,r11,r5,r1
   .syntax divided
    .syntax unified
    ldr r1,[r0,#24]
    .syntax divided
    .syntax unified
    umaal r9,r14,r3,r1
   .syntax divided
    .syntax unified
    umaal r10,r12,r2,r1
   .syntax divided
    .syntax unified
    umaal r11,r12,r5,r1
   .syntax divided
    .syntax unified
    umaal r10,r14,r3,r8
   .syntax divided
    .syntax unified
    umaal r11,r14,r2,r8
   .syntax divided
    .syntax unified
    umaal r12,r14,r5,r8
   .syntax divided
    .syntax unified
    ldr r0,[SP,#28]
   .syntax divided
    .syntax unified
    ldr r1,[SP,#0]
   .syntax divided
    .syntax unified
    ldr r2,[SP,#4]
   .syntax divided
    .syntax unified
    mov r3,#38
    .syntax divided
    .syntax unified
    eor r5,r5
   .syntax divided
    .syntax unified
    umlal r0,r5,r14,r3
   .syntax divided
    .syntax unified
    mov r8,#19
    .syntax divided
    .syntax unified
    lsr r14,r0,#31
    .syntax divided
    .syntax unified
    mul r8,r14
    .syntax divided
    .syntax unified
    lsl r0,r0,#1
    .syntax divided
    .syntax unified
    lsr r0,r0,#1
    .syntax divided
    .syntax unified
    umaal r1,r8,r4,r3
   .syntax divided
    .syntax unified
    eor r4,r4
   .syntax divided
    .syntax unified
    umlal r1,r4,r5,r3
   .syntax divided
    .syntax unified
    .syntax unified
    add r2,r4
    .syntax divided
   .syntax divided
    .syntax unified
    umaal r2,r8,r6,r3
   .syntax divided
    .syntax unified
    ldr r4,[SP,#8]
   .syntax divided
    .syntax unified
    ldr r5,[SP,#12]
   .syntax divided
    .syntax unified
    ldr r6,[SP,#16]
   .syntax divided
    .syntax unified
    ldr r14,[SP,#20]
   .syntax divided
    .syntax unified
    umaal r4,r8,r7,r3
   .syntax divided
    .syntax unified
    umaal r5,r8,r9,r3
   .syntax divided
    .syntax unified
    umaal r6,r8,r10,r3
   .syntax divided
    .syntax unified
    umaal r8,r14,r11,r3
   .syntax divided
    .syntax unified
    ldr r7,[SP,#24]
   .syntax divided
    .syntax unified
    ldr r9,[SP,#32]
   .syntax divided
    .syntax unified
    umaal r7,r14,r12,r3
   .syntax divided
    .syntax unified
    .syntax unified
    add r0,r14
    .syntax divided
   .syntax divided
    .syntax unified
    str r0,[r9,#28]
    .syntax divided
    .syntax unified
    str r7,[r9,#24]
    .syntax divided
    .syntax unified
    str r8,[r9,#20]
    .syntax divided
    .syntax unified
    str r6,[r9,#16]
    .syntax divided
    .syntax unified
    str r5,[r9,#12]
    .syntax divided
    .syntax unified
    str r4,[r9,#8]
    .syntax divided
    .syntax unified
    str r2,[r9,#4]
    .syntax divided
    .syntax unified
    str r1,[r9,#0]
    .syntax divided
    add SP,#44
   .syntax unified
    pop {r4,r5,r6,r7,r8,r9,r10,r11,r12,r15}
   .syntax divided

	.size	fe25519_mul_asm, .-fe25519_mul_asm
	
