// The different interpreters could be generated. A lot of code duplication here.
// This is mostly for testing, expect slowness :)

#define Opcode_Plane          0 // vec4
#define Opcode_Sphere         1 // center: vec3, radius: f32
#define Opcode_Capsule        2 // p0: vec3, p1: vec3, radius: f32
#define Opcode_TaperedCapsule 3 // p0: vec3, p1: vec3, radius: f32
#define Opcode_Material       4 // rgb: vec3

// Combinators:
#define Opcode_Union           5
#define Opcode_UnionSmooth     6
#define Opcode_Subtract        7
#define Opcode_SubtractSmooth  8
#define Opcode_Intersect       9
#define Opcode_IntersectSmooth 10

// Transforms:
#define Opcode_PushTranslation 11
#define Opcode_PushRotation    12
#define Opcode_PopTransform    13
#define Opcode_PushScale       14
#define Opcode_PopScale        15

#define Opcode_End 16

#define Opcode_RoundedBox      17
#define Opcode_BiconvexLens    18
#define Opcode_RoundedCylinder 19
#define Opcode_Torus           20
#define Opcode_TorusSector     21
#define Opcode_Cone            22

float sd_interpret(vec3 pos) {
    uint sp = 0;
    uint cp = SDF_CONSTANTS_OFFSET;
    uint pc = SDF_PROGRAM_OFFSET;

    float stack[8];

    uint transform_sp = 0;
    vec3 transform_stack[8];

    vec3 current_position = pos;

    while (true) {
        uint opcode = SDF_PROGRAM[pc++].x;

        switch (opcode) {
            case Opcode_Plane: {
                vec4 plane = SDF_CONSTANTS[cp];
                cp++;
                stack[sp] = sd_plane(current_position, plane);
                sp += 1;
            } break;

            case Opcode_Sphere: {
                vec4 center_radius = SDF_CONSTANTS[cp];
                cp++;
                stack[sp] = sd_sphere(current_position, center_radius.xyz, center_radius.w);
                sp += 1;
            } break;

            case Opcode_Capsule: {
                vec4 p0 = SDF_CONSTANTS[cp];
                cp++;
                vec4 p1_radius = SDF_CONSTANTS[cp];
                cp++;
                stack[sp] = sd_capsule(current_position, p0.xyz, p1_radius.xyz, p1_radius.w);
                sp += 1;
            } break;

            case Opcode_RoundedCylinder: {
                vec4 radius_height_rounding = SDF_CONSTANTS[cp];
                cp++;
                stack[sp] = sd_rounded_cylinder(current_position,
                                                radius_height_rounding.x,
                                                radius_height_rounding.y,
                                                radius_height_rounding.z);
                sp += 1;
            } break;

            case Opcode_TaperedCapsule: {
                vec4 p0_r0 = SDF_CONSTANTS[cp];
                cp++;
                vec4 p1_r1 = SDF_CONSTANTS[cp];
                cp++;
                stack[sp] =
                    sd_tapered_capsule(current_position, p0_r0.xyz, p1_r1.xyz, p0_r0.w, p1_r1.w);
                sp += 1;
            } break;

            case Opcode_Cone: {
                vec4 q = SDF_CONSTANTS[cp];
                cp++;
                stack[sp] = sd_cone(current_position, q.x, q.y);
                sp += 1;
            } break;

            case Opcode_RoundedBox: {
                vec4 half_size_radius = SDF_CONSTANTS[cp];
                cp++;
                stack[sp] =
                    sd_rounded_box(current_position, half_size_radius.xyz, half_size_radius.w);
                sp += 1;
            } break;

            case Opcode_Torus: {
                vec4 params = SDF_CONSTANTS[cp];
                cp++;
                stack[sp] = sd_torus(current_position, params[0], params[1]);
                sp += 1;
            } break;

            case Opcode_TorusSector: {
                vec4 params = SDF_CONSTANTS[cp];
                cp++;
                stack[sp] = sd_torus_sector(
                    current_position, params[0], params[1], vec2(params[2], params[3]));
                sp += 1;
            } break;

            case Opcode_BiconvexLens: {
                vec4 lower_upper_chord = SDF_CONSTANTS[cp];
                cp++;
                stack[sp] = sd_biconvex_lens(current_position,
                                             lower_upper_chord.x,
                                             lower_upper_chord.y,
                                             lower_upper_chord.z);
                sp += 1;
            } break;

            case Opcode_Material: {
                cp++;
            } break;

            // Combinators:
            case Opcode_Union: {
                sp -= 1;
                stack[sp - 1] = sd_op_union(stack[sp], stack[sp - 1]);
            } break;

            case Opcode_UnionSmooth: {
                vec4 s = SDF_CONSTANTS[cp];
                cp++;
                sp -= 1;
                stack[sp - 1] = sd_op_union_smooth(stack[sp], stack[sp - 1], s.x);
            } break;

            case Opcode_Subtract: {
                sp -= 1;
                stack[sp - 1] = sd_op_subtract(stack[sp], stack[sp - 1]);
            } break;

            case Opcode_SubtractSmooth: {
                vec4 s = SDF_CONSTANTS[cp];
                cp++;
                sp -= 1;
                stack[sp - 1] = sd_op_subtract_smooth(stack[sp], stack[sp - 1], s.x);
            } break;

            case Opcode_Intersect: {
                sp -= 1;
                stack[sp - 1] = sd_op_intersect(stack[sp], stack[sp - 1]);
            } break;

            case Opcode_IntersectSmooth: {
                vec4 s = SDF_CONSTANTS[cp];
                cp++;
                sp -= 1;
                stack[sp - 1] = sd_op_intersect_smooth(stack[sp], stack[sp - 1], s.x);
            } break;

                // Transforms:
            case Opcode_PushTranslation: {
                transform_stack[transform_sp] = current_position;
                transform_sp += 1;

                vec4 translation = SDF_CONSTANTS[cp];
                cp++;

                current_position += translation.xyz;
            } break;

            case Opcode_PushRotation: {
                transform_stack[transform_sp] = current_position;
                transform_sp += 1;

                vec4 rot = SDF_CONSTANTS[cp];
                cp++;

                current_position = mul_quat(rot, current_position);
            } break;

            case Opcode_PopTransform: {
                transform_sp -= 1;
                current_position = transform_stack[transform_sp];
            } break;

            case Opcode_PushScale: {
                transform_stack[transform_sp] = current_position;
                transform_sp += 1;

                vec4 scale = SDF_CONSTANTS[cp];
                cp++;

                current_position *= scale.x;
            } break;

            case Opcode_PopScale: {
                transform_sp -= 1;
                current_position = transform_stack[transform_sp];

                vec4 inv_scale = SDF_CONSTANTS[cp];
                cp++;

                stack[sp - 1] *= inv_scale.x;
            } break;

            default:
            case Opcode_End: {
                return stack[sp - 1];
            }
        }
    }

    // return vec4(0.0);
    return 0.0;
}

vec4 sdrgb_interpret(vec3 pos) {
    uint sp = 0;
    uint cp = SDF_CONSTANTS_OFFSET;
    uint pc = SDF_PROGRAM_OFFSET;

    vec4 stack[8];

    uint transform_sp = 0;
    vec3 transform_stack[8];

    vec3 current_position = pos;

    while (true) {
        uint opcode = SDF_PROGRAM[pc++].x;

        switch (opcode) {
            case Opcode_Plane: {
                vec4 plane = SDF_CONSTANTS[cp];
                cp++;
                stack[sp] = sdrgb_plane(current_position, plane);
                sp += 1;
            } break;

            case Opcode_Sphere: {
                vec4 center_radius = SDF_CONSTANTS[cp];
                cp++;
                stack[sp] = sdrgb_sphere(current_position, center_radius.xyz, center_radius.w);
                sp += 1;
            } break;

            case Opcode_Capsule: {
                vec4 p0 = SDF_CONSTANTS[cp];
                cp++;
                vec4 p1_radius = SDF_CONSTANTS[cp];
                cp++;
                stack[sp] = sdrgb_capsule(current_position, p0.xyz, p1_radius.xyz, p1_radius.w);
                sp += 1;
            } break;

            case Opcode_RoundedCylinder: {
                vec4 radius_height_rounding = SDF_CONSTANTS[cp];
                cp++;
                stack[sp] = sdrgb_rounded_cylinder(current_position,
                                                   radius_height_rounding.x,
                                                   radius_height_rounding.y,
                                                   radius_height_rounding.z);
                sp += 1;
            } break;

            case Opcode_TaperedCapsule: {
                vec4 p0_r0 = SDF_CONSTANTS[cp];
                cp++;
                vec4 p1_r1 = SDF_CONSTANTS[cp];
                cp++;
                stack[sp] =
                    sdrgb_tapered_capsule(current_position, p0_r0.xyz, p1_r1.xyz, p0_r0.w, p1_r1.w);
                sp += 1;
            } break;

            case Opcode_Cone: {
                vec4 q = SDF_CONSTANTS[cp];
                cp++;
                stack[sp] = sdrgb_cone(current_position, q.x, q.y);
                sp += 1;
            } break;

            case Opcode_RoundedBox: {
                vec4 half_size_radius = SDF_CONSTANTS[cp];
                cp++;

                stack[sp] =
                    sdrgb_rounded_box(current_position, half_size_radius.xyz, half_size_radius.w);
                sp += 1;
            } break;

            case Opcode_Torus: {
                vec4 params = SDF_CONSTANTS[cp];
                cp++;
                stack[sp] = sdrgb_torus(current_position, params[0], params[1]);
                sp += 1;
            } break;

            case Opcode_TorusSector: {
                vec4 params = SDF_CONSTANTS[cp];
                cp++;
                stack[sp] = sdrgb_torus_sector(
                    current_position, params[0], params[1], vec2(params[2], params[3]));
                sp += 1;
            } break;

            case Opcode_BiconvexLens: {
                vec4 lower_upper_chord = SDF_CONSTANTS[cp];
                cp++;

                stack[sp] = sdrgb_biconvex_lens(current_position,
                                                lower_upper_chord.x,
                                                lower_upper_chord.y,
                                                lower_upper_chord.z);
                sp += 1;
            } break;

            case Opcode_Material: {
                vec4 rgb = SDF_CONSTANTS[cp];
                cp++;
                stack[sp - 1].rgb = rgb.rgb;
            } break;

            // Combinators:
            case Opcode_Union: {
                sp -= 1;
                stack[sp - 1] = sdrgb_op_union(stack[sp], stack[sp - 1]);
            } break;

            case Opcode_UnionSmooth: {
                vec4 s = SDF_CONSTANTS[cp];
                cp++;
                sp -= 1;
                stack[sp - 1] = sdrgb_op_union_smooth(stack[sp], stack[sp - 1], s.x);
            } break;

            case Opcode_Subtract: {
                sp -= 1;
                stack[sp - 1] = sdrgb_op_subtract(stack[sp], stack[sp - 1]);
            } break;

            case Opcode_SubtractSmooth: {
                vec4 s = SDF_CONSTANTS[cp];
                cp++;
                sp -= 1;
                stack[sp - 1] = sdrgb_op_subtract_smooth(stack[sp], stack[sp - 1], s.x);
            } break;

            case Opcode_Intersect: {
                sp -= 1;
                stack[sp - 1] = sdrgb_op_intersect(stack[sp], stack[sp - 1]);
            } break;

            case Opcode_IntersectSmooth:

            {
                vec4 s = SDF_CONSTANTS[cp];
                cp++;
                sp -= 1;
                stack[sp - 1] = sdrgb_op_intersect_smooth(stack[sp], stack[sp - 1], s.x);
            } break;

                // Transforms:
            case Opcode_PushTranslation: {
                transform_stack[transform_sp] = current_position;
                transform_sp += 1;

                vec4 translation = SDF_CONSTANTS[cp];
                cp++;

                current_position += translation.xyz;
            } break;

            case Opcode_PushRotation: {
                transform_stack[transform_sp] = current_position;
                transform_sp += 1;

                vec4 rot = SDF_CONSTANTS[cp];
                cp++;

                current_position = mul_quat(rot, current_position);
            } break;

            case Opcode_PopTransform: {
                transform_sp -= 1;
                current_position = transform_stack[transform_sp];
            } break;

            case Opcode_PushScale: {
                transform_stack[transform_sp] = current_position;
                transform_sp += 1;

                vec4 scale = SDF_CONSTANTS[cp];
                cp++;

                current_position *= scale.x;
            } break;

            case Opcode_PopScale: {
                transform_sp -= 1;
                current_position = transform_stack[transform_sp];

                vec4 inv_scale = SDF_CONSTANTS[cp];
                cp++;

                stack[sp - 1].w *= inv_scale.x;
            } break;

            default:
            case Opcode_End: {
                return stack[sp - 1];
            }
        }
    }

    return vec4(0.0);
}
