use criterion::{criterion_group, criterion_main, Criterion};

pub fn criterion_benchmark(c: &mut Criterion) {
    let mut graph = saft::Graph::default();
    let root = graph.example(&Default::default());

    let mesh_options = saft::MeshOptions {
        mean_resolution: 128.0,
        max_resolution: 128.0,
        min_resolution: 8.0,
    };
    let mesh = saft::mesh_from_sdf(&graph, root, mesh_options).unwrap();
    eprintln!(
        "{:.1}k vertices and {:.1}k triangles",
        mesh.positions.len() as f32 * 1e-3,
        (mesh.indices.len() / 3) as f32 * 1e-3
    );

    c.bench_function("mesh_from_sdf", |b| {
        b.iter(|| saft::mesh_from_sdf(&graph, root, mesh_options));
    });
}

criterion_group!(
    name = benches;
    config = Criterion::default().sample_size(10);
    targets = criterion_benchmark
);
criterion_main!(benches);
