use std::io::Read;
use std::net::SocketAddr;

async fn start_server() -> SocketAddr {
    let listener = safina::net::TcpListener::bind(&SocketAddr::from(([127, 0, 0, 1], 0))).unwrap();
    let local_addr = listener.inner().local_addr().unwrap();
    safina::executor::spawn(async move {
        loop {
            let (mut tcp_stream, _remote_addr) = listener.accept().await.unwrap();
            tcp_stream.write_all(b"response1").await.unwrap();
        }
    });
    local_addr
}

#[test]
fn tcp_server() {
    safina::timer::start_timer_thread();
    let executor = safina::executor::Executor::default();
    let addr = executor.block_on(start_server());
    let mut tcp_stream = std::net::TcpStream::connect(addr).unwrap();
    let mut buf = String::new();
    tcp_stream.read_to_string(&mut buf).unwrap();
    assert_eq!("response1", buf);
}
