# safina-select

[![crates.io version](https://img.shields.io/crates/v/safina-select.svg)](https://crates.io/crates/safina-select)
[![license: Apache 2.0](https://gitlab.com/leonhard-llc/safina-rs/-/raw/main/license-apache-2.0.svg)](http://www.apache.org/licenses/LICENSE-2.0)
[![unsafe forbidden](https://gitlab.com/leonhard-llc/safina-rs/-/raw/main/unsafe-forbidden-success.svg)](https://github.com/rust-secure-code/safety-dance/)
[![pipeline status](https://gitlab.com/leonhard-llc/safina-rs/badges/main/pipeline.svg)](https://gitlab.com/leonhard-llc/safina-rs/-/pipelines)

This is a Rust library for awaiting multiple futures
and getting the value of the first one that completes.

It is part of [`safina`](https://crates.io/crates/safina), a safe async runtime.

## Features
- `forbid(unsafe_code)`
- Depends only on `std`
- Good test coverage (96%)
- Works with [`safina-executor`](https://crates.io/crates/safina-executor)
  or any async executor

## Limitations
- Can await 2-5 futures.  Nest them if you need more.

## Examples
```rust
use safina_async_test::async_test;
use safina_select::{select_ab, OptionAb};
let conn = match select_ab(make_new(addr.clone()), get_from_pool(addr.clone())).await {
    OptionAb::A(result) => result?,
    OptionAb::B(result) => result?,
};
// When both futures return the same type, you can use `take`:
let conn = select_ab(make_new(addr.clone()), get_from_pool(addr.clone())).await.take()?;
```
```rust
use safina_async_test::async_test;
use safina_select::{select_ab, OptionAb};
safina_timer::start_timer_thread();
let data = match select_ab(read_data(), safina_timer::sleep_until(deadline)).await {
    OptionAb::A(result) => Ok(result?),
    OptionAb::B(()) => Err("timeout"),
};
```

## Documentation
<https://docs.rs/safina-select>

## TO DO - Alternatives
- [`tokio::select`](https://docs.rs/tokio/latest/tokio/macro.select.html)
  - very popular
  - Fast
  - internally incredibly complicated
  - full of `unsafe`
- [`futures::select`](https://docs.rs/futures/latest/futures/macro.select.html)
  - very popular
  - proc macro, very complicated
  - contains a little `unsafe` code

## Changelog
- V0.1.4 - Update docs.
- v0.1.3 - Rename `OptionAB` to `OptionAb`, etc.
- v0.1.2 - Satisfy pedantic clippy
- v0.1.1 - Add badges to readme.  Rename `safina` package to `safina-executor`.
- v0.1.0 - First published version

## TO DO

## Release Process
1. Edit `Cargo.toml` and bump version number.
1. Run `./release.sh`

License: Apache-2.0
