{{#include ../links.md}}

# Usage

Using `safer_ffi` is pretty simple, provided one knows [how C compilation
works][c-compilation].

## TL,DR

### `Cargo.toml`

```toml
[lib]
crate-type = ["staticlib"]

[dependencies]
safer-ffi = { version = "...", features = ["proc_macros"] }

[features]
c-headers = ["safer-ffi/headers"]
```

### `src/lib.rs`

```rust,noplaypen
use ::safer_ffi::prelude::*;

#[ffi_export]
fn add (x: i32, y: i32) -> i32
{
    x.wrapping_add(y)
}

#[::safer_ffi::cfg_headers]
#[test]
fn generate_headers () -> ::std::io::Result<()>
{
    ::safer_ffi::headers::builder()
        .to_file("filename.h")?
        .generate()
}
```

  - And run:

    ```bash
    cargo test --features c-headers -- generate_headers --nocapture
    ```

    to generate the headers.
