{{#include ../links.md}}

![safer-ffi-banner]

# Introduction

> `safer_ffi` is a rust framework to generate a foreign function interface (or FFI) easily and safely.

This framework is primarily used to annotate rust functions and types to
generate C headers without polluting your rust code with
`unsafe`.

It's inspired by [`#[wasm_bindgen]`][wasm_bindgen]. It's mainly expose Rust to C
over the FFI (allowing C code calling into Rust code). However, it does have some
usages for C to Rust over the FFI (callbacks or `extern { ... }`
headers).

This chart shows the comparison of traditional FFI types vs ones using `safer_ffi`.

{{#include ../repr_c-types.md}}

## Rust documentation

Link to [<i class="fa fa-cubes" aria-hidden="true"></i> the `rustdoc`-generated API documentation <i class="fa fa-cubes" aria-hidden="true"></i>][Rust documentation].

## Prerequisites

  - Minimum Supported Rust Version: `1.43.0`

## Getting started

See [the next chapter][quickstart] or [the chapter on _Detailed Usage_][usage].

{{#include ../disclaimer.md}}
