{{#include ../links.md}}

# The `ReprC` trait

  - [API Documentation][`ReprC`]

`ReprC` is the core trait around `safer_ffi`'s design.

  - Feel free to [look at the appendix to understand why and
    how][how-does-safer_ffi-work].

Indeed,

> a function can only be marked [`#[ffi_export]`][ffi_export] if its parameters
  and returned value are all `ReprC`.

### When is a type `ReprC`?

A type is `ReprC`:

  - when it is a primitive type with a C layout (integer types, floating point
    types, ~~`char`~~, `bool`, non-zero-sized arrays, and
    [`extern "C"` callbacks][callbacks]),

<details><summary>Function pointers do not support lifetimes yet</summary>

<span class="warning">

Due to a type-system limitation, function pointers that use lifetimes
are not `ReprC` yet. Only function pointers with a non-generic
signature can be made `ReprC`, but this requires defining a newtype
wrapper. A convenience macro is planned to be added to automate that step.

</span>

</details>

  - when it is [a specialy-crafted type exported from the `safer_ffi` crate](
    ../motivation/repr-c-forall.md),

  - or **when it is a custom type that is `#[derive_ReprC]`-annotated**.


## `#[derive_ReprC]`

<span id="derive-reprc"></span>

You can (safely) make a custom type be `ReprC` by adding the `#[derive_ReprC]`
attribute on it.

<details><summary>Supported types</summary>

Currently, the supported types for the attribute are:

  - a (non-zero-sized) `#[repr(C)]` struct having only `ReprC` fields.

    - or a `#[repr(transparent)]` tuple struct wrapper around a `ReprC` type.

  - a field-less `#[repr({integer})]` `enum` (A "C-like" `enum`).

  - an arbitrary type that you will only use through (pointer) indirection.

    This leads to the "opaque object" pattern, based on an undefined / forward
    declaration: `typedef struct MyOpaque MyOpaque_t;`

    ```rust,noplaypen
    use ::safer_ffi::prelude::*;

    #[derive_ReprC]
    #[ReprC::opaque]
    struct MyOpaque {
        /* anything goes here */
    }
    ```

<div class="warning">

The following are not yet implemented

</div>

  - a `#[repr(C)]` `union`.

  - Some kind of `#[repr(to_be_determined)]` `enum` which would be allowed to
    have fields (thus leading to `repr_c::Option` and `repr_c::Result` types,
    which ought to get rid of any need to use out-parameters).

</details>
