
# Sponsorship

**SafeCloset** is developed by [Denys Séguret](https://twitter.com/DenysSeguret), also known as [Canop](https://github.com/Canop) or [dystroy](https://dystroy.org).

**SafeCloset** is free for everybody, and everbody's welcome to ask for advice or new features. But if you *want* to help me find time to improve it, and to develop [other free programs](https://dystroy.org), consider [sponsoring me](https://github.com/sponsors/Canop). There's absolutely no moral obligation to do so, though.

# Chat

The best place to chat about safecloset, to talk about features or bugs, is the Miaou chat.

* [Rust & SafeCloset room on Miaou](https://miaou.dystroy.org/3490?rust)
* [French Programers room on Miaou](https://miaou.dystroy.org/3)

# Issues

We use [GitHub's issue manager](https://github.com/Canop/safecloset/issues).

Before posting a new issue, check your problem hasn't already been raised and in case of doubt **please come first discuss it on the chat**.

# Independant security audit

None has been done yet.
I'd welcome help on this topic.

# Storage format

The storage format is described to ensure it's possible to replace SafeCloset with another software if needed.

The closet file is a [MessagePack](https://msgpack.org/index.html) encoded structure `Closet` with the following fields:

* `salt`: a string
* `drawers`: an array of `ClosedDrawer`

The MessagePack serialization preserves field names and allows future additions.

An instance of `ClosedDrawer` is a structure with the following fields:

* `id`: a byte array
* `nonce`: a byte array
* `content`: a byte array

The `content` is the AES-GCM-SIV encryption of the serializied drawer with the included `nonce`.
The key used for this encryption is a 256 bits Argon2 hash of the password with the closet's salt.

The serialized drawer is a MessagePack encoded structure with the following fields:

* `id`: a byte array
* `entries`: an array of `Entry`
* `settings`: an instance of `DrawerSettings`
* `closet`: a deeper closet, containing drawers, etc.
* `garbage`: a random byte array

Instances of `Entry` contain the following fields:

* `name`: a string
* `value`: a string

Instances of `DrawerSettings` contain for now just one optional field:

* `hide_values`: a boolean
