use crate::{display::UriRefDisplay, ParseUriError};
use safe_uri::Uri;
use std::fmt;

/// An extended [`Uri`], which implements [`Display`](std::fmt::Display) and more.
#[derive(Debug, Clone, PartialEq, Eq, Hash)]
pub struct ExtUri<'a>(pub Uri<'a>);

impl<'a> ExtUri<'a> {
    pub fn parse(s: &'a str) -> Result<Self, ParseUriError> {
        crate::parse_uri(s).map(Self)
    }

    pub fn parse_static(s: &'static str) -> Result<Self, ParseUriError> {
        crate::parse_static_uri(s).map(Self)
    }
}

impl fmt::Display for ExtUri<'_> {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(f, "{}", UriRefDisplay::from(&self.0))
    }
}
