use crate::{display::UriRefDisplay, ParseUriError};
use safe_uri::UriRef;
use std::fmt;

/// An extended [`UriRef`], which implements [`Display`](std::fmt::Display) and more.
#[derive(Debug, Clone, PartialEq, Eq, Hash)]
pub struct ExtUriRef<'a>(pub UriRef<'a>);

impl<'a> ExtUriRef<'a> {
    pub fn parse(s: &'a str) -> Result<Self, ParseUriError> {
        crate::parse_uri_ref(s).map(Self)
    }

    pub fn parse_static(s: &'static str) -> Result<Self, ParseUriError> {
        crate::parse_static_uri_ref(s).map(Self)
    }
}

impl fmt::Display for ExtUriRef<'_> {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(f, "{}", UriRefDisplay::from(&self.0))
    }
}
