// This file is automatically generated.

use super::is_valid_byte;
use crate::{
    percent_encoded::PercentEncoded,
    validation::{InvalidByte, InvalidComponent, InvalidPercentEncodedByte},
};

pub(crate) const fn validate(bytes: &[u8]) -> Result<(), InvalidComponent> {
    let mut index = 0;
    while index < bytes.len() {
        let byte = bytes[index];
        if byte == b'%' {
            match PercentEncoded::from_bytes_at_index(bytes, index) {
                Err(e) => return Err(InvalidComponent::PercentEncoded(e)),
                Ok(encoded) => {
                    if is_valid_byte(encoded.byte) {
                        return Err(InvalidComponent::PercentEncodedByte(
                            InvalidPercentEncodedByte { byte: encoded.byte },
                        ));
                    } else {
                        index += PercentEncoded::BYTES_LENGTH
                    }
                }
            }
        } else if is_valid_byte(byte) {
            index += 1;
        } else {
            return Err(InvalidComponent::Byte(InvalidByte { byte }));
        }
    }
    Ok(())
}
