// Copyright 2021 MaidSafe.net limited.
//
// This SAFE Network Software is licensed to you under The General Public License (GPL), version 3.
// Unless required by applicable law or agreed to in writing, the SAFE Network Software distributed
// under the GPL Licence is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. Please review the Licences for the specific language governing
// permissions and limitations relating to use of the SAFE Network Software.

use super::agreement::SectionAuth;
use crate::messaging::SectionAuthorityProvider;
use serde::{Deserialize, Serialize};
use xor_name::PrefixMap;

/// Container for storing information about other sections in the network.
#[derive(Clone, Debug, PartialEq, Eq, Serialize, Deserialize)]
pub struct Network {
    /// Other sections: maps section prefixes to their latest signed section authority providers.
    pub sections: PrefixMap<SectionAuth<SectionAuthorityProvider>>,
}
