//! This file is automatically generated.
use boar_::BoasStr;

#[derive(Debug, Clone, PartialEq, Eq, Hash)]
pub(super) enum MethodKind<'a> {
    Get,
    Put,
    Post,
    Delete,
    Options,
    Head,
    Trace,
    Connect,
    Patch,
    Extension(BoasStr<'a>),
}

impl MethodKind<'_> {
    pub(super) fn standard(s: &str) -> Option<Self> {
        match s {
            "GET" => Some(Self::Get),
            "PUT" => Some(Self::Put),
            "POST" => Some(Self::Post),
            "DELETE" => Some(Self::Delete),
            "OPTIONS" => Some(Self::Options),
            "HEAD" => Some(Self::Head),
            "TRACE" => Some(Self::Trace),
            "CONNECT" => Some(Self::Connect),
            "PATCH" => Some(Self::Patch),
            _ => None,
        }
    }

    pub(super) fn into_static(self) -> MethodKind<'static> {
        match self {
            Self::Get => MethodKind::Get,
            Self::Put => MethodKind::Put,
            Self::Post => MethodKind::Post,
            Self::Delete => MethodKind::Delete,
            Self::Options => MethodKind::Options,
            Self::Head => MethodKind::Head,
            Self::Trace => MethodKind::Trace,
            Self::Connect => MethodKind::Connect,
            Self::Patch => MethodKind::Patch,
            Self::Extension(x) => MethodKind::Extension(x.into_static()),
        }
    }

    pub(super) fn to_borrowed(&self) -> MethodKind {
        match self {
            Self::Get => MethodKind::Get,
            Self::Put => MethodKind::Put,
            Self::Post => MethodKind::Post,
            Self::Delete => MethodKind::Delete,
            Self::Options => MethodKind::Options,
            Self::Head => MethodKind::Head,
            Self::Trace => MethodKind::Trace,
            Self::Connect => MethodKind::Connect,
            Self::Patch => MethodKind::Patch,
            Self::Extension(x) => MethodKind::Extension(x.to_borrowed()),
        }
    }
}

impl MethodKind<'_> {
    pub(super) fn as_str(&self) -> &str {
        match self {
            Self::Get => "GET",
            Self::Put => "PUT",
            Self::Post => "POST",
            Self::Delete => "DELETE",
            Self::Options => "OPTIONS",
            Self::Head => "HEAD",
            Self::Trace => "TRACE",
            Self::Connect => "CONNECT",
            Self::Patch => "PATCH",
            Self::Extension(s) => s,
        }
    }
}
