use std::{error::Error, fmt};

#[derive(Debug, Clone)]
#[non_exhaustive]
pub struct InvalidMethod {
    pub byte: u8,
    pub index: usize,
}

impl fmt::Display for InvalidMethod {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(
            f,
            "Method has invalid char {:?} at index {}.",
            char::from(self.byte),
            self.index
        )
    }
}

impl Error for InvalidMethod {}
