use crate::HeaderValue;
use std::{iter::FusedIterator, slice, vec};

#[derive(Debug, Clone)]
pub struct IntoIter<'a> {
    pub(super) first: Option<HeaderValue<'a>>,
    pub(super) remaining: vec::IntoIter<HeaderValue<'a>>,
}

impl<'a> Iterator for IntoIter<'a> {
    type Item = HeaderValue<'a>;

    fn next(&mut self) -> Option<HeaderValue<'a>> {
        self.first.take().or_else(|| self.remaining.next())
    }

    fn size_hint(&self) -> (usize, Option<usize>) {
        if self.first.is_some() {
            let length = self.remaining.len() + 1;
            (length, Some(length))
        } else {
            self.remaining.size_hint()
        }
    }
}

impl DoubleEndedIterator for IntoIter<'_> {
    fn next_back(&mut self) -> Option<Self::Item> {
        self.remaining.next_back().or_else(|| self.first.take())
    }
}

impl ExactSizeIterator for IntoIter<'_> {}

impl FusedIterator for IntoIter<'_> {}

#[derive(Debug, Clone)]
pub struct Iter<'r, 'a> {
    pub(super) first: Option<&'r HeaderValue<'a>>,
    pub(super) remaining: slice::Iter<'r, HeaderValue<'a>>,
}

impl<'r, 'a> Iterator for Iter<'r, 'a> {
    type Item = &'r HeaderValue<'a>;

    fn next(&mut self) -> Option<Self::Item> {
        self.first.take().or_else(|| self.remaining.next())
    }

    fn size_hint(&self) -> (usize, Option<usize>) {
        if self.first.is_some() {
            let length = self.remaining.len() + 1;
            (length, Some(length))
        } else {
            self.remaining.size_hint()
        }
    }
}

impl DoubleEndedIterator for Iter<'_, '_> {
    fn next_back(&mut self) -> Option<Self::Item> {
        self.remaining.next_back().or_else(|| self.first.take())
    }
}

impl ExactSizeIterator for Iter<'_, '_> {}

impl FusedIterator for Iter<'_, '_> {}

#[derive(Debug)]
pub struct IterMut<'r, 'a> {
    pub(super) first: Option<&'r mut HeaderValue<'a>>,
    pub(super) remaining: slice::IterMut<'r, HeaderValue<'a>>,
}

impl<'r, 'a> Iterator for IterMut<'r, 'a> {
    type Item = &'r mut HeaderValue<'a>;

    fn next(&mut self) -> Option<Self::Item> {
        self.first.take().or_else(|| self.remaining.next())
    }

    fn size_hint(&self) -> (usize, Option<usize>) {
        if self.first.is_some() {
            let length = self.remaining.len() + 1;
            (length, Some(length))
        } else {
            self.remaining.size_hint()
        }
    }
}

impl DoubleEndedIterator for IterMut<'_, '_> {
    fn next_back(&mut self) -> Option<Self::Item> {
        self.remaining.next_back().or_else(|| self.first.take())
    }
}

impl ExactSizeIterator for IterMut<'_, '_> {}

impl FusedIterator for IterMut<'_, '_> {}
