use crate::{HeaderName, HeaderValues};
use std::{collections::hash_map, iter::FusedIterator};

#[derive(Debug)]
pub struct Drain<'map, 'a>(pub(super) hash_map::Drain<'map, HeaderName<'a>, HeaderValues<'a>>);

impl<'map, 'a> Iterator for Drain<'map, 'a> {
    type Item = (HeaderName<'a>, HeaderValues<'a>);

    fn next(&mut self) -> Option<Self::Item> {
        self.0.next()
    }

    fn size_hint(&self) -> (usize, Option<usize>) {
        self.0.size_hint()
    }
}

impl ExactSizeIterator for Drain<'_, '_> {}

impl FusedIterator for Drain<'_, '_> {}

#[derive(Debug)]
pub struct IntoIter<'a>(pub(super) hash_map::IntoIter<HeaderName<'a>, HeaderValues<'a>>);

impl<'a> Iterator for IntoIter<'a> {
    type Item = (HeaderName<'a>, HeaderValues<'a>);

    fn next(&mut self) -> Option<Self::Item> {
        self.0.next()
    }

    fn size_hint(&self) -> (usize, Option<usize>) {
        self.0.size_hint()
    }
}

impl ExactSizeIterator for IntoIter<'_> {}

impl FusedIterator for IntoIter<'_> {}

#[derive(Debug)]
pub struct IntoKeys<'a>(pub(super) hash_map::IntoKeys<HeaderName<'a>, HeaderValues<'a>>);

impl<'a> Iterator for IntoKeys<'a> {
    type Item = HeaderName<'a>;

    fn next(&mut self) -> Option<Self::Item> {
        self.0.next()
    }

    fn size_hint(&self) -> (usize, Option<usize>) {
        self.0.size_hint()
    }
}

impl ExactSizeIterator for IntoKeys<'_> {}

impl FusedIterator for IntoKeys<'_> {}

#[derive(Debug)]
pub struct IntoValues<'a>(pub(super) hash_map::IntoValues<HeaderName<'a>, HeaderValues<'a>>);

impl<'a> Iterator for IntoValues<'a> {
    type Item = HeaderValues<'a>;

    fn next(&mut self) -> Option<Self::Item> {
        self.0.next()
    }

    fn size_hint(&self) -> (usize, Option<usize>) {
        self.0.size_hint()
    }
}

impl ExactSizeIterator for IntoValues<'_> {}

impl FusedIterator for IntoValues<'_> {}

#[derive(Debug, Clone)]
pub struct Iter<'map, 'a>(pub(super) hash_map::Iter<'map, HeaderName<'a>, HeaderValues<'a>>);

impl<'map, 'a> Iterator for Iter<'map, 'a> {
    type Item = (&'map HeaderName<'a>, &'map HeaderValues<'a>);

    fn next(&mut self) -> Option<Self::Item> {
        self.0.next()
    }

    fn size_hint(&self) -> (usize, Option<usize>) {
        self.0.size_hint()
    }
}

impl ExactSizeIterator for Iter<'_, '_> {}

impl FusedIterator for Iter<'_, '_> {}

#[derive(Debug)]
pub struct IterMut<'map, 'a>(pub(super) hash_map::IterMut<'map, HeaderName<'a>, HeaderValues<'a>>);

impl<'map, 'a> Iterator for IterMut<'map, 'a> {
    type Item = (&'map HeaderName<'a>, &'map mut HeaderValues<'a>);

    fn next(&mut self) -> Option<Self::Item> {
        self.0.next()
    }

    fn size_hint(&self) -> (usize, Option<usize>) {
        self.0.size_hint()
    }
}

impl ExactSizeIterator for IterMut<'_, '_> {}

impl FusedIterator for IterMut<'_, '_> {}

#[derive(Debug, Clone)]
pub struct Keys<'map, 'a>(pub(super) hash_map::Keys<'map, HeaderName<'a>, HeaderValues<'a>>);

impl<'map, 'a> Iterator for Keys<'map, 'a> {
    type Item = &'map HeaderName<'a>;

    fn next(&mut self) -> Option<Self::Item> {
        self.0.next()
    }

    fn size_hint(&self) -> (usize, Option<usize>) {
        self.0.size_hint()
    }
}

impl ExactSizeIterator for Keys<'_, '_> {}

impl FusedIterator for Keys<'_, '_> {}

#[derive(Debug, Clone)]
pub struct Values<'map, 'a>(pub(super) hash_map::Values<'map, HeaderName<'a>, HeaderValues<'a>>);

impl<'map, 'a> Iterator for Values<'map, 'a> {
    type Item = &'map HeaderValues<'a>;

    fn next(&mut self) -> Option<Self::Item> {
        self.0.next()
    }

    fn size_hint(&self) -> (usize, Option<usize>) {
        self.0.size_hint()
    }
}

impl ExactSizeIterator for Values<'_, '_> {}

impl FusedIterator for Values<'_, '_> {}

#[derive(Debug)]
pub struct ValuesMut<'map, 'a>(
    pub(super) hash_map::ValuesMut<'map, HeaderName<'a>, HeaderValues<'a>>,
);

impl<'map, 'a> Iterator for ValuesMut<'map, 'a> {
    type Item = &'map mut HeaderValues<'a>;

    fn next(&mut self) -> Option<Self::Item> {
        self.0.next()
    }

    fn size_hint(&self) -> (usize, Option<usize>) {
        self.0.size_hint()
    }
}

impl ExactSizeIterator for ValuesMut<'_, '_> {}

impl FusedIterator for ValuesMut<'_, '_> {}
