use std::{error::Error, fmt};

#[derive(Debug, Clone)]
#[non_exhaustive]
pub struct InvalidStatusCode {
    pub(super) code: u16,
}

impl fmt::Display for InvalidStatusCode {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(
            f,
            "{} is an invalid StatusCode. The valid range is 100-599",
            self.code
        )
    }
}

impl Error for InvalidStatusCode {}
