use safe_uri::Uri;

use crate::{method::Method, version::Version};

#[derive(Debug, Clone, PartialEq, Eq, Hash, Default)]
pub struct RequestLine<'a> {
    pub method: Method<'a>,
    pub uri: Uri<'a>,
    pub version: Version,
    #[doc(hidden)]
    pub __private: (),
}

impl<'a> RequestLine<'a> {
    pub fn new() -> Self {
        Self::default()
    }

    pub fn from_uri(uri: Uri<'a>) -> Self {
        Self {
            method: Method::default(),
            uri,
            version: Version::latest(),
            __private: (),
        }
    }
}

impl<'a> From<Uri<'a>> for RequestLine<'a> {
    #[inline]
    fn from(uri: Uri<'a>) -> Self {
        Self::from_uri(uri)
    }
}
