use super::{HeaderName, HeaderValue, HeaderValues};
use boar::Boa;
use std::{borrow::Borrow, collections::HashMap, hash::Hash};

/// **B**orrowed, **O**wned or **A**rc [`HeaderMap`]
pub type BoaHeaderMap<'a> = Boa<'a, HeaderMap<'a>>;

pub type HeaderMap<'a> = HashMap<HeaderName<'a>, HeaderValues<'a>>;

pub trait HeaderMapExt<'a>: private::Sealed {
    fn get_first<Q: ?Sized>(&self, k: &Q) -> Option<&HeaderValue>
    where
        HeaderName<'a>: Borrow<Q>,
        Q: Hash + Eq;
}

impl<'a> HeaderMapExt<'a> for HeaderMap<'a> {
    fn get_first<Q: ?Sized>(&self, k: &Q) -> Option<&HeaderValue>
    where
        HeaderName<'a>: Borrow<Q>,
        Q: Hash + Eq,
    {
        self.get(k).map(|h| h.first())
    }
}

mod private {
    pub trait Sealed {}

    impl Sealed for super::BoaHeaderMap<'_> {}

    impl Sealed for super::HeaderMap<'_> {}
}
