use crate::{status::StatusCode, version::Version};

#[derive(Debug, Clone, Copy, PartialEq, Eq, Hash, Default)]
#[non_exhaustive]
pub struct ResponseLine {
    pub version: Version,
    pub status_code: StatusCode,
}

impl ResponseLine {
    pub fn new() -> Self {
        Self::default()
    }

    const fn from_status_code(status_code: StatusCode) -> Self {
        Self {
            version: Version::latest(),
            status_code,
        }
    }
}

impl From<StatusCode> for ResponseLine {
    #[inline]
    fn from(status_code: StatusCode) -> Self {
        Self::from_status_code(status_code)
    }
}
