use std::{error::Error, fmt};

#[derive(Debug, Clone)]
#[cfg_attr(test, derive(PartialEq))]
#[non_exhaustive]
pub struct InvalidHeaderValue {
    pub byte: u8,
    pub index: usize,
}

impl fmt::Display for InvalidHeaderValue {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(
            f,
            "Header value has invalid char {:?} at index {}.",
            char::from(self.byte),
            self.index
        )
    }
}

impl Error for InvalidHeaderValue {}
