use proc_macro::TokenStream;
use quote::quote;
use syn::parse_macro_input;
mod util;
use syn::{ExprCall, ItemFn, ItemMod};

/// execute a function after the test is done even if the test failled
#[proc_macro_attribute]
pub fn after(_metadata: TokenStream, input: TokenStream) -> TokenStream {
    let mut function = parse_macro_input!(input as ItemFn);
    let args = parse_macro_input!(_metadata as ExprCall);

    util::add_fn_after(&mut function, &args)
}

/// execute a function before the test start
#[proc_macro_attribute]
pub fn before(_metadata: TokenStream, input: TokenStream) -> TokenStream {
    let mut function = parse_macro_input!(input as ItemFn);
    let args = parse_macro_input!(_metadata as ExprCall);

    util::add_fn_before(&mut function, &args)
}

/// for each test of a module execute the function before the test start
#[proc_macro_attribute]
pub fn before_each(_metadata: TokenStream, input: TokenStream) -> TokenStream {
    let mut test_mod = parse_macro_input!(input as ItemMod);
    let args = parse_macro_input!(_metadata as ExprCall);
    util::add_fn_before_each(&mut test_mod, &args);
    TokenStream::from(quote! {
        #test_mod
    })
}

/// for each test of a module execute the function after the test end even if the test failled
#[proc_macro_attribute]
pub fn after_each(_metadata: TokenStream, input: TokenStream) -> TokenStream {
    let mut test_mod = parse_macro_input!(input as ItemMod);
    let args = parse_macro_input!(_metadata as ExprCall);
    util::add_fn_after_each(&mut test_mod, &args);
    TokenStream::from(quote! {
        #test_mod
    })
}
