# s_test_fixture

s_test_fixture or simple test fixture is a macro library to implement test fixture with no hassle.


# Usage
It's probably a better idea to had this crate to the dev-dependencies.

Their is four macros: `before`, `after`, `before_each`, `after_each`. The function pass as argument must return nothing.

`before` and `after` are simply added before the test function

```rust
#[cfg(test)]
mod tests {
    use s_fixture::{after, before};
    #[test]
    #[before(function_to_run(2))]
    fn simple_test_before() {
        let a = 2;
        something();
        assert_eq!(a,2);
        println!("ending");

    }
    
    fn something(){}

    fn function_to_run(i:i32){
        println!("I did {} thing(s)",i);
    }
}
```
will return 

```
I did 2 thing(s)
ending
```
```rust
#[cfg(test)]
mod tests {
    use s_fixture::{after, before};
    #[test]
    #[after(function_to_run(66))]
    fn branch_test_after_second() -> Result<(), ()> {
        println!("before");
        let i = -55;
        something();
        if i == 0 {
            something();
            Ok(())
        } else if i == 2 {
            something();
            return Ok(());
        } else {
            panic!("oh no!")
            Ok(())
        }
    }
    
    fn something(){}

    fn function_to_run(i:i32){
        println!("I did {} thing(s)",i);
    }
}

```
will return
```
before
{panic statement}
I did 66 thing(s)
```

`before_each` and `after_each` behave in a similar matter and stack with `before` and `after` macro. It has to be noted that the scope of the 
function pass as argument matter. It has to consider the scope of the test module.

```rust
use s_fixture::{before_each,after, before};

#[cfg(test)]
#[before_each(function_to_run(78))]
mod tests {
    use super::*;
    #[test]
    #[before(function_to_run(2))]
    fn simple_test_before() {
        let a = 2;
        something();
        assert_eq!(a,2);
        println!("ending");

    }
    
    fn something(){}

    fn function_to_run(i:i32){
        println!("I did {} thing(s)",i);
    }
}
```
will return
```
I did 2 thing(s)
I did 78 thing(s)
ending
```
The macros are pretty easy to use but examples can be found in the test folder of the source code.

# Test
run 
`cargo test -- --test-threads 1`