[![Latest Version]][crates.io] ![License]

# S3 Stream Backup

Store data streams on S3 keeping a number of lates backups.

Features:

* Backup standard input data to timestamped S3 objects.
* Keep constant number of backups.
* List and restore backups to standard output.

# Example usage

Note: You need to set up AWS credentials and default region using `~/.aws/credentials` and `~/.aws/config` files or use enviornment variables (`AWS_DEFAULT_REGION`, `AWS_ACCESS_KEY_ID`, `AWS_SECRET_ACCESS_KEY`) or use instance profile (on EC2). Consulte AWS documentation for details.

```sh
# backup PostgreSQL to S3
su - postgres -c pg_dumpall | xz | s3sb -v mybucket backups/postgress make 2 xz

# restore from S3 backup
s3sb -v mybucket backups/postgress restore | xz -d | su - postgres -c psql
```

[crates.io]: https://crates.io/crates/s3sb
[Latest Version]: https://img.shields.io/crates/v/s3sb.svg
[License]: https://img.shields.io/crates/l/s3sb.svg
