//! `s3d` is an S3 daemon for the Edge written in Rust
//! - https://s3d.rs
//! - https://github.com/s3d-rs/s3d

pub mod api;
pub mod layers;

use crate::api::HttpServer;
use crate::api::ResultOrAnyErr;
use clap::{AppSettings, Clap};

#[derive(Clap, Debug)]
#[clap(about = "`s3d` is an S3 daemon for the Edge written in Rust.")]
#[clap(setting = AppSettings::ColoredHelp)]
struct CLI {
    /// Sets a custom config file
    #[clap(short, long)]
    config: Option<String>,

    /// Verbosity level, can be used multiple times
    #[clap(short, long, parse(from_occurrences))]
    verbose: i32,

    /// Cli command
    #[clap(subcommand)]
    cmd: Cmd,
}

#[derive(Clap, Debug)]
enum Cmd {
    Run(RunCmd),
}

#[derive(Clap, Debug)]
struct RunCmd {
    #[clap(short)]
    debug: bool,
}

#[tokio::main]
pub async fn main() -> ResultOrAnyErr<()> {
    let cli: CLI = CLI::parse();

    if cli.verbose > 0 {
        println!("[VERBOSE] CLI options: {:?}", cli);
    }

    match cli.cmd {
        Cmd::Run(c) => Ok(HttpServer::run().await?),
    }
}
