#[derive(Debug, Clone)]
pub struct ApiError {
    pub status_code: hyper::StatusCode,
    pub code: String,
    pub msg: String,
    pub resource: String,
    pub request_id: String,
}

impl std::error::Error for ApiError {}

impl std::fmt::Display for ApiError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "{:?}", self)
    }
}

impl ApiError {
    pub fn from(kind: ApiErrors) -> ApiError {
        match kind {
            ApiErrors::BadRequest => ApiError {
                status_code: hyper::StatusCode::BAD_REQUEST,
                code: "BadRequest".to_owned(),
                msg: "".to_owned(),
                resource: "".to_owned(),
                request_id: "".to_owned(),
            },
            ApiErrors::BucketAlreadyExists => ApiError {
                status_code: hyper::StatusCode::CONFLICT,
                code: "BucketAlreadyExists".to_owned(),
                msg: "".to_owned(),
                resource: "".to_owned(),
                request_id: "".to_owned(),
            },
            ApiErrors::NoSuchBucket => ApiError {
                status_code: hyper::StatusCode::NOT_FOUND,
                code: "NoSuchBucket".to_owned(),
                msg: "".to_owned(),
                resource: "".to_owned(),
                request_id: "".to_owned(),
            },
            ApiErrors::NoSuchKey => ApiError {
                status_code: hyper::StatusCode::NOT_FOUND,
                code: "NoSuchKey".to_owned(),
                msg: "".to_owned(),
                resource: "".to_owned(),
                request_id: "".to_owned(),
            },
            _ => ApiError {
                status_code: hyper::StatusCode::INTERNAL_SERVER_ERROR,
                code: "InternalError".to_owned(),
                msg: "".to_owned(),
                resource: "".to_owned(),
                request_id: "".to_owned(),
            },
        }
    }
}

#[derive(Debug, Clone)]
pub enum ApiErrors {
    BadRequest,
    BucketAlreadyExists,
    NoSuchBucket,
    NoSuchKey,
    InternalError,
}
