/* automatically generated by rust-bindgen 0.58.1 */


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0


#![allow(unused_imports, non_camel_case_types)]

use libc::{iovec, FILE};


extern "C" {
    #[doc = " Returns the address of the thread-local `s2n_errno` variable"]
    #[doc = ""]
    #[doc = " This function can be used instead of trying to resolve `s2n_errno` directly"]
    #[doc = " in runtimes where thread-local variables may not be easily accessible."]
    pub fn s2n_errno_location() -> *mut ::libc::c_int;
}
pub mod s2n_error_type {
    pub type Type = ::libc::c_uint;
    pub const OK: Type = 0;
    pub const IO: Type = 1;
    pub const CLOSED: Type = 2;
    pub const BLOCKED: Type = 3;
    pub const ALERT: Type = 4;
    pub const PROTO: Type = 5;
    pub const INTERNAL: Type = 6;
    pub const USAGE: Type = 7;
}
extern "C" {
    pub fn s2n_error_get_type(error: ::libc::c_int) -> ::libc::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_config {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_connection {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Prevents S2N from calling `OPENSSL_crypto_init`/`OPENSSL_cleanup`/`EVP_cleanup` on OpenSSL versions"]
    #[doc = " prior to 1.1.x. This allows applications or languages that also init OpenSSL to interoperate"]
    #[doc = " with S2N."]
    pub fn s2n_crypto_disable_init() -> ::libc::c_int;
}
extern "C" {
    #[doc = " Prevents S2N from installing an atexit handler, which allows safe shutdown of S2N from within a"]
    #[doc = " re-entrant shared library"]
    pub fn s2n_disable_atexit() -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_get_openssl_version() -> ::libc::c_ulong;
}
extern "C" {
    pub fn s2n_init() -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_cleanup() -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_new() -> *mut s2n_config;
}
extern "C" {
    pub fn s2n_config_free(config: *mut s2n_config) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_free_dhparams(config: *mut s2n_config) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_free_cert_chain_and_key(config: *mut s2n_config) -> ::libc::c_int;
}
pub type s2n_clock_time_nanoseconds = ::core::option::Option<
    unsafe extern "C" fn(arg1: *mut ::libc::c_void, arg2: *mut u64) -> ::libc::c_int,
>;
pub type s2n_cache_retrieve_callback = ::core::option::Option<
    unsafe extern "C" fn(
        conn: *mut s2n_connection,
        arg1: *mut ::libc::c_void,
        key: *const ::libc::c_void,
        key_size: u64,
        value: *mut ::libc::c_void,
        value_size: *mut u64,
    ) -> ::libc::c_int,
>;
pub type s2n_cache_store_callback = ::core::option::Option<
    unsafe extern "C" fn(
        conn: *mut s2n_connection,
        arg1: *mut ::libc::c_void,
        ttl_in_seconds: u64,
        key: *const ::libc::c_void,
        key_size: u64,
        value: *const ::libc::c_void,
        value_size: u64,
    ) -> ::libc::c_int,
>;
pub type s2n_cache_delete_callback = ::core::option::Option<
    unsafe extern "C" fn(
        conn: *mut s2n_connection,
        arg1: *mut ::libc::c_void,
        key: *const ::libc::c_void,
        key_size: u64,
    ) -> ::libc::c_int,
>;
extern "C" {
    pub fn s2n_config_set_wall_clock(
        config: *mut s2n_config,
        clock_fn: s2n_clock_time_nanoseconds,
        ctx: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_set_monotonic_clock(
        config: *mut s2n_config,
        clock_fn: s2n_clock_time_nanoseconds,
        ctx: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_strerror(error: ::libc::c_int, lang: *const ::libc::c_char)
        -> *const ::libc::c_char;
}
extern "C" {
    pub fn s2n_strerror_debug(
        error: ::libc::c_int,
        lang: *const ::libc::c_char,
    ) -> *const ::libc::c_char;
}
extern "C" {
    pub fn s2n_strerror_name(error: ::libc::c_int) -> *const ::libc::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_stacktrace {
    _unused: [u8; 0],
}
extern "C" {
    pub fn s2n_stack_traces_enabled() -> bool;
}
extern "C" {
    pub fn s2n_stack_traces_enabled_set(newval: bool) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_calculate_stacktrace() -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_print_stacktrace(fptr: *mut FILE) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_free_stacktrace() -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_get_stacktrace(trace: *mut s2n_stacktrace) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_set_cache_store_callback(
        config: *mut s2n_config,
        cache_store_callback: s2n_cache_store_callback,
        data: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_set_cache_retrieve_callback(
        config: *mut s2n_config,
        cache_retrieve_callback: s2n_cache_retrieve_callback,
        data: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_set_cache_delete_callback(
        config: *mut s2n_config,
        cache_delete_callback: s2n_cache_delete_callback,
        data: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
pub type s2n_mem_init_callback = ::core::option::Option<unsafe extern "C" fn() -> ::libc::c_int>;
pub type s2n_mem_cleanup_callback = ::core::option::Option<unsafe extern "C" fn() -> ::libc::c_int>;
pub type s2n_mem_malloc_callback = ::core::option::Option<
    unsafe extern "C" fn(
        ptr: *mut *mut ::libc::c_void,
        requested: u32,
        allocated: *mut u32,
    ) -> ::libc::c_int,
>;
pub type s2n_mem_free_callback = ::core::option::Option<
    unsafe extern "C" fn(ptr: *mut ::libc::c_void, size: u32) -> ::libc::c_int,
>;
extern "C" {
    pub fn s2n_mem_set_callbacks(
        mem_init_callback: s2n_mem_init_callback,
        mem_cleanup_callback: s2n_mem_cleanup_callback,
        mem_malloc_callback: s2n_mem_malloc_callback,
        mem_free_callback: s2n_mem_free_callback,
    ) -> ::libc::c_int;
}
pub type s2n_rand_init_callback = ::core::option::Option<unsafe extern "C" fn() -> ::libc::c_int>;
pub type s2n_rand_cleanup_callback =
    ::core::option::Option<unsafe extern "C" fn() -> ::libc::c_int>;
pub type s2n_rand_seed_callback = ::core::option::Option<
    unsafe extern "C" fn(data: *mut ::libc::c_void, size: u32) -> ::libc::c_int,
>;
pub type s2n_rand_mix_callback = ::core::option::Option<
    unsafe extern "C" fn(data: *mut ::libc::c_void, size: u32) -> ::libc::c_int,
>;
extern "C" {
    pub fn s2n_rand_set_callbacks(
        rand_init_callback: s2n_rand_init_callback,
        rand_cleanup_callback: s2n_rand_cleanup_callback,
        rand_seed_callback: s2n_rand_seed_callback,
        rand_mix_callback: s2n_rand_mix_callback,
    ) -> ::libc::c_int;
}
pub mod s2n_tls_extension_type {
    pub type Type = ::libc::c_uint;
    pub const SERVER_NAME: Type = 0;
    pub const MAX_FRAG_LEN: Type = 1;
    pub const OCSP_STAPLING: Type = 5;
    pub const SUPPORTED_GROUPS: Type = 10;
    pub const EC_POINT_FORMATS: Type = 11;
    pub const SIGNATURE_ALGORITHMS: Type = 13;
    pub const ALPN: Type = 16;
    pub const CERTIFICATE_TRANSPARENCY: Type = 18;
    pub const RENEGOTIATION_INFO: Type = 65281;
}
pub mod s2n_max_frag_len {
    pub type Type = ::libc::c_uint;
    pub const LEN_512: Type = 1;
    pub const LEN_1024: Type = 2;
    pub const LEN_2048: Type = 3;
    pub const LEN_4096: Type = 4;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_cert {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_cert_chain_and_key {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_pkey {
    _unused: [u8; 0],
}
pub type s2n_cert_public_key = s2n_pkey;
pub type s2n_cert_private_key = s2n_pkey;
extern "C" {
    pub fn s2n_cert_chain_and_key_new() -> *mut s2n_cert_chain_and_key;
}
extern "C" {
    pub fn s2n_cert_chain_and_key_load_pem(
        chain_and_key: *mut s2n_cert_chain_and_key,
        chain_pem: *const ::libc::c_char,
        private_key_pem: *const ::libc::c_char,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_cert_chain_and_key_load_pem_bytes(
        chain_and_key: *mut s2n_cert_chain_and_key,
        chain_pem: *mut u8,
        chain_pem_len: u32,
        private_key_pem: *mut u8,
        private_key_pem_len: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_cert_chain_and_key_load_public_pem_bytes(
        chain_and_key: *mut s2n_cert_chain_and_key,
        chain_pem: *mut u8,
        chain_pem_len: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_cert_chain_and_key_free(cert_and_key: *mut s2n_cert_chain_and_key) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_cert_chain_and_key_set_ctx(
        cert_and_key: *mut s2n_cert_chain_and_key,
        ctx: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_cert_chain_and_key_get_ctx(
        cert_and_key: *mut s2n_cert_chain_and_key,
    ) -> *mut ::libc::c_void;
}
extern "C" {
    pub fn s2n_cert_chain_and_key_get_private_key(
        cert_and_key: *mut s2n_cert_chain_and_key,
    ) -> *mut s2n_cert_private_key;
}
pub type s2n_cert_tiebreak_callback = ::core::option::Option<
    unsafe extern "C" fn(
        cert1: *mut s2n_cert_chain_and_key,
        cert2: *mut s2n_cert_chain_and_key,
        name: *mut u8,
        name_len: u32,
    ) -> *mut s2n_cert_chain_and_key,
>;
extern "C" {
    pub fn s2n_config_set_cert_tiebreak_callback(
        config: *mut s2n_config,
        cert_tiebreak_cb: s2n_cert_tiebreak_callback,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_add_cert_chain_and_key(
        config: *mut s2n_config,
        cert_chain_pem: *const ::libc::c_char,
        private_key_pem: *const ::libc::c_char,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_add_cert_chain_and_key_to_store(
        config: *mut s2n_config,
        cert_key_pair: *mut s2n_cert_chain_and_key,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_set_cert_chain_and_key_defaults(
        config: *mut s2n_config,
        cert_key_pairs: *mut *mut s2n_cert_chain_and_key,
        num_cert_key_pairs: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_set_verification_ca_location(
        config: *mut s2n_config,
        ca_pem_filename: *const ::libc::c_char,
        ca_dir: *const ::libc::c_char,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_add_pem_to_trust_store(
        config: *mut s2n_config,
        pem: *const ::libc::c_char,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Clear the trust store."]
    #[doc = ""]
    #[doc = " Note that the trust store will be initialized with the common locations for"]
    #[doc = " the host operating system by default. To completely override those locations,"]
    #[doc = " call this before functions like `s2n_config_set_verification_ca_location()`"]
    #[doc = " or `s2n_config_add_pem_to_trust_store()`"]
    #[doc = ""]
    #[doc = " @param config The configuration object being updated"]
    #[doc = ""]
    #[doc = " @return 0 on success and -1 on error"]
    pub fn s2n_config_wipe_trust_store(config: *mut s2n_config) -> ::libc::c_int;
}
pub type s2n_verify_host_fn = ::core::option::Option<
    unsafe extern "C" fn(
        host_name: *const ::libc::c_char,
        host_name_len: usize,
        data: *mut ::libc::c_void,
    ) -> u8,
>;
extern "C" {
    pub fn s2n_config_set_verify_host_callback(
        config: *mut s2n_config,
        arg1: s2n_verify_host_fn,
        data: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_set_check_stapled_ocsp_response(
        config: *mut s2n_config,
        check_ocsp: u8,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_disable_x509_verification(config: *mut s2n_config) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_set_max_cert_chain_depth(
        config: *mut s2n_config,
        max_depth: u16,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_add_dhparams(
        config: *mut s2n_config,
        dhparams_pem: *const ::libc::c_char,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_set_cipher_preferences(
        config: *mut s2n_config,
        version: *const ::libc::c_char,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Appends the provided application protocol to the preference list"]
    #[doc = ""]
    #[doc = " The data provided in `protocol` parameter will be copied into an internal buffer"]
    #[doc = ""]
    #[doc = " @param config The configuration object being updated"]
    #[doc = " @param protocol A pointer to a byte array value"]
    #[doc = " @param protocol_len The length of bytes that should be read from `protocol`. Note: this value cannot be 0, otherwise an error will be returned."]
    pub fn s2n_config_append_protocol_preference(
        config: *mut s2n_config,
        protocol: *const u8,
        protocol_len: u8,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_set_protocol_preferences(
        config: *mut s2n_config,
        protocols: *const *const ::libc::c_char,
        protocol_count: ::libc::c_int,
    ) -> ::libc::c_int;
}
pub mod s2n_status_request_type {
    pub type Type = ::libc::c_uint;
    pub const NONE: Type = 0;
    pub const OCSP: Type = 1;
}
extern "C" {
    pub fn s2n_config_set_status_request_type(
        config: *mut s2n_config,
        type_: s2n_status_request_type::Type,
    ) -> ::libc::c_int;
}
pub mod s2n_ct_support_level {
    pub type Type = ::libc::c_uint;
    pub const NONE: Type = 0;
    pub const REQUEST: Type = 1;
}
extern "C" {
    pub fn s2n_config_set_ct_support_level(
        config: *mut s2n_config,
        level: s2n_ct_support_level::Type,
    ) -> ::libc::c_int;
}
pub mod s2n_alert_behavior {
    pub type Type = ::libc::c_uint;
    pub const FAIL_ON_WARNINGS: Type = 0;
    pub const IGNORE_WARNINGS: Type = 1;
}
extern "C" {
    pub fn s2n_config_set_alert_behavior(
        config: *mut s2n_config,
        alert_behavior: s2n_alert_behavior::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_set_extension_data(
        config: *mut s2n_config,
        type_: s2n_tls_extension_type::Type,
        data: *const u8,
        length: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_send_max_fragment_length(
        config: *mut s2n_config,
        mfl_code: s2n_max_frag_len::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_accept_max_fragment_length(config: *mut s2n_config) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_set_session_state_lifetime(
        config: *mut s2n_config,
        lifetime_in_secs: u64,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_set_session_tickets_onoff(
        config: *mut s2n_config,
        enabled: u8,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_set_session_cache_onoff(
        config: *mut s2n_config,
        enabled: u8,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_set_ticket_encrypt_decrypt_key_lifetime(
        config: *mut s2n_config,
        lifetime_in_secs: u64,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_set_ticket_decrypt_key_lifetime(
        config: *mut s2n_config,
        lifetime_in_secs: u64,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_add_ticket_crypto_key(
        config: *mut s2n_config,
        name: *const u8,
        name_len: u32,
        key: *mut u8,
        key_len: u32,
        intro_time_in_seconds_from_epoch: u64,
    ) -> ::libc::c_int;
}
pub mod s2n_mode {
    pub type Type = ::libc::c_uint;
    pub const SERVER: Type = 0;
    pub const CLIENT: Type = 1;
}
extern "C" {
    pub fn s2n_connection_new(mode: s2n_mode::Type) -> *mut s2n_connection;
}
extern "C" {
    pub fn s2n_connection_set_config(
        conn: *mut s2n_connection,
        config: *mut s2n_config,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_set_ctx(
        conn: *mut s2n_connection,
        ctx: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_get_ctx(conn: *mut s2n_connection) -> *mut ::libc::c_void;
}
pub type s2n_client_hello_fn = ::core::option::Option<
    unsafe extern "C" fn(conn: *mut s2n_connection, ctx: *mut ::libc::c_void) -> ::libc::c_int,
>;
pub mod s2n_client_hello_cb_mode {
    pub type Type = ::libc::c_uint;
    pub const BLOCKING: Type = 0;
    pub const NONBLOCKING: Type = 1;
}
extern "C" {
    pub fn s2n_config_set_client_hello_cb(
        config: *mut s2n_config,
        client_hello_callback: s2n_client_hello_fn,
        ctx: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_set_client_hello_cb_mode(
        config: *mut s2n_config,
        cb_mode: s2n_client_hello_cb_mode::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_client_hello_cb_done(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_server_name_extension_used(conn: *mut s2n_connection) -> ::libc::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_client_hello {
    _unused: [u8; 0],
}
extern "C" {
    pub fn s2n_connection_get_client_hello(conn: *mut s2n_connection) -> *mut s2n_client_hello;
}
extern "C" {
    pub fn s2n_client_hello_get_raw_message_length(ch: *mut s2n_client_hello) -> isize;
}
extern "C" {
    pub fn s2n_client_hello_get_raw_message(
        ch: *mut s2n_client_hello,
        out: *mut u8,
        max_length: u32,
    ) -> isize;
}
extern "C" {
    pub fn s2n_client_hello_get_cipher_suites_length(ch: *mut s2n_client_hello) -> isize;
}
extern "C" {
    pub fn s2n_client_hello_get_cipher_suites(
        ch: *mut s2n_client_hello,
        out: *mut u8,
        max_length: u32,
    ) -> isize;
}
extern "C" {
    pub fn s2n_client_hello_get_extensions_length(ch: *mut s2n_client_hello) -> isize;
}
extern "C" {
    pub fn s2n_client_hello_get_extensions(
        ch: *mut s2n_client_hello,
        out: *mut u8,
        max_length: u32,
    ) -> isize;
}
extern "C" {
    pub fn s2n_client_hello_get_extension_length(
        ch: *mut s2n_client_hello,
        extension_type: s2n_tls_extension_type::Type,
    ) -> isize;
}
extern "C" {
    pub fn s2n_client_hello_get_extension_by_id(
        ch: *mut s2n_client_hello,
        extension_type: s2n_tls_extension_type::Type,
        out: *mut u8,
        max_length: u32,
    ) -> isize;
}
extern "C" {
    #[doc = " Used to check if a particular extension exists in the client hello."]
    #[doc = ""]
    #[doc = " @param ch A pointer to the client hello object"]
    #[doc = " @param extension_iana The iana value of the extension"]
    #[doc = " @param exists A pointer that will be set to whether or not the extension exists"]
    pub fn s2n_client_hello_has_extension(
        ch: *mut s2n_client_hello,
        extension_iana: u16,
        exists: *mut bool,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_client_hello_get_session_id_length(
        ch: *mut s2n_client_hello,
        out_length: *mut u32,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_client_hello_get_session_id(
        ch: *mut s2n_client_hello,
        out: *mut u8,
        out_length: *mut u32,
        max_length: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_set_fd(conn: *mut s2n_connection, fd: ::libc::c_int) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_set_read_fd(
        conn: *mut s2n_connection,
        readfd: ::libc::c_int,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_set_write_fd(
        conn: *mut s2n_connection,
        writefd: ::libc::c_int,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Gets the assigned file descriptor for the read channel of an s2n connection."]
    #[doc = ""]
    #[doc = " @param conn A pointer to the s2n connection"]
    #[doc = " @param readfd pointer to place the used file descriptor."]
    pub fn s2n_connection_get_read_fd(
        conn: *mut s2n_connection,
        readfd: *mut ::libc::c_int,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Gets the assigned file descriptor for the write channel of an s2n connection."]
    #[doc = ""]
    #[doc = " @param conn A pointer to the s2n connection"]
    #[doc = " @param writefd pointer to place the used file descriptor."]
    pub fn s2n_connection_get_write_fd(
        conn: *mut s2n_connection,
        writefd: *mut ::libc::c_int,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_use_corked_io(conn: *mut s2n_connection) -> ::libc::c_int;
}
pub type s2n_recv_fn = ::core::option::Option<
    unsafe extern "C" fn(io_context: *mut ::libc::c_void, buf: *mut u8, len: u32) -> ::libc::c_int,
>;
pub type s2n_send_fn = ::core::option::Option<
    unsafe extern "C" fn(
        io_context: *mut ::libc::c_void,
        buf: *const u8,
        len: u32,
    ) -> ::libc::c_int,
>;
extern "C" {
    pub fn s2n_connection_set_recv_ctx(
        conn: *mut s2n_connection,
        ctx: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_set_send_ctx(
        conn: *mut s2n_connection,
        ctx: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_set_recv_cb(
        conn: *mut s2n_connection,
        recv: s2n_recv_fn,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_set_send_cb(
        conn: *mut s2n_connection,
        send: s2n_send_fn,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_prefer_throughput(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_prefer_low_latency(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_set_dynamic_record_threshold(
        conn: *mut s2n_connection,
        resize_threshold: u32,
        timeout_threshold: u16,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_set_verify_host_callback(
        config: *mut s2n_connection,
        host_fn: s2n_verify_host_fn,
        data: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
pub mod s2n_blinding {
    pub type Type = ::libc::c_uint;
    pub const BUILT_IN_BLINDING: Type = 0;
    pub const SELF_SERVICE_BLINDING: Type = 1;
}
extern "C" {
    pub fn s2n_connection_set_blinding(
        conn: *mut s2n_connection,
        blinding: s2n_blinding::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_get_delay(conn: *mut s2n_connection) -> u64;
}
extern "C" {
    pub fn s2n_connection_set_cipher_preferences(
        conn: *mut s2n_connection,
        version: *const ::libc::c_char,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Appends the provided application protocol to the preference list"]
    #[doc = ""]
    #[doc = " The data provided in `protocol` parameter will be copied into an internal buffer"]
    #[doc = ""]
    #[doc = " @param conn The connection object being updated"]
    #[doc = " @param protocol A pointer to a slice of bytes"]
    #[doc = " @param protocol_len The length of bytes that should be read from `protocol`. Note: this value cannot be 0, otherwise an error will be returned."]
    pub fn s2n_connection_append_protocol_preference(
        conn: *mut s2n_connection,
        protocol: *const u8,
        protocol_len: u8,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_set_protocol_preferences(
        conn: *mut s2n_connection,
        protocols: *const *const ::libc::c_char,
        protocol_count: ::libc::c_int,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_set_server_name(
        conn: *mut s2n_connection,
        server_name: *const ::libc::c_char,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_get_server_name(conn: *mut s2n_connection) -> *const ::libc::c_char;
}
extern "C" {
    pub fn s2n_get_application_protocol(conn: *mut s2n_connection) -> *const ::libc::c_char;
}
extern "C" {
    pub fn s2n_connection_get_ocsp_response(
        conn: *mut s2n_connection,
        length: *mut u32,
    ) -> *const u8;
}
extern "C" {
    pub fn s2n_connection_get_sct_list(conn: *mut s2n_connection, length: *mut u32) -> *const u8;
}
pub mod s2n_blocked_status {
    pub type Type = ::libc::c_uint;
    pub const NOT_BLOCKED: Type = 0;
    pub const BLOCKED_ON_READ: Type = 1;
    pub const BLOCKED_ON_WRITE: Type = 2;
    pub const BLOCKED_ON_APPLICATION_INPUT: Type = 3;
    pub const BLOCKED_ON_EARLY_DATA: Type = 4;
}
extern "C" {
    pub fn s2n_negotiate(
        conn: *mut s2n_connection,
        blocked: *mut s2n_blocked_status::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_send(
        conn: *mut s2n_connection,
        buf: *const ::libc::c_void,
        size: isize,
        blocked: *mut s2n_blocked_status::Type,
    ) -> isize;
}
extern "C" {
    pub fn s2n_sendv(
        conn: *mut s2n_connection,
        bufs: *const iovec,
        count: isize,
        blocked: *mut s2n_blocked_status::Type,
    ) -> isize;
}
extern "C" {
    pub fn s2n_sendv_with_offset(
        conn: *mut s2n_connection,
        bufs: *const iovec,
        count: isize,
        offs: isize,
        blocked: *mut s2n_blocked_status::Type,
    ) -> isize;
}
extern "C" {
    pub fn s2n_recv(
        conn: *mut s2n_connection,
        buf: *mut ::libc::c_void,
        size: isize,
        blocked: *mut s2n_blocked_status::Type,
    ) -> isize;
}
extern "C" {
    pub fn s2n_peek(conn: *mut s2n_connection) -> u32;
}
extern "C" {
    pub fn s2n_connection_free_handshake(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_release_buffers(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_wipe(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_free(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_shutdown(
        conn: *mut s2n_connection,
        blocked: *mut s2n_blocked_status::Type,
    ) -> ::libc::c_int;
}
pub mod s2n_cert_auth_type {
    pub type Type = ::libc::c_uint;
    pub const NONE: Type = 0;
    pub const REQUIRED: Type = 1;
    pub const OPTIONAL: Type = 2;
}
extern "C" {
    pub fn s2n_config_get_client_auth_type(
        config: *mut s2n_config,
        client_auth_type: *mut s2n_cert_auth_type::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_set_client_auth_type(
        config: *mut s2n_config,
        client_auth_type: s2n_cert_auth_type::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_get_client_auth_type(
        conn: *mut s2n_connection,
        client_auth_type: *mut s2n_cert_auth_type::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_set_client_auth_type(
        conn: *mut s2n_connection,
        client_auth_type: s2n_cert_auth_type::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_get_client_cert_chain(
        conn: *mut s2n_connection,
        der_cert_chain_out: *mut *mut u8,
        cert_chain_len: *mut u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the initial number of session tickets to send after a >=TLS1.3 handshake. The default value is one ticket."]
    #[doc = ""]
    #[doc = " @param config A pointer to the config object."]
    #[doc = " @param num The number of session tickets that will be sent."]
    pub fn s2n_config_set_initial_ticket_count(config: *mut s2n_config, num: u8) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Increases the number of session tickets to send after a >=TLS1.3 handshake."]
    #[doc = ""]
    #[doc = " @param conn A pointer to the connection object."]
    #[doc = " @param num The number of additional session tickets to send."]
    pub fn s2n_connection_add_new_tickets_to_send(
        conn: *mut s2n_connection,
        num: u8,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the number of session tickets issued by the server."]
    #[doc = ""]
    #[doc = " In TLS1.3, this number can be up to the limit configured by s2n_config_set_initial_ticket_count"]
    #[doc = " and s2n_connection_add_new_tickets_to_send. In earlier versions of TLS, this number will be either 0 or 1."]
    #[doc = ""]
    #[doc = " This method only works for server connections."]
    #[doc = ""]
    #[doc = " @param conn A pointer to the connection object."]
    #[doc = " @param num The number of additional session tickets sent."]
    pub fn s2n_connection_get_tickets_sent(
        conn: *mut s2n_connection,
        num: *mut u16,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the keying material lifetime for >=TLS1.3 session tickets so that one session doesn't get re-used ad infinitum."]
    #[doc = " The default value is one week."]
    #[doc = ""]
    #[doc = " @param conn A pointer to the connection object."]
    #[doc = " @param lifetime_in_secs Lifetime of keying material in seconds."]
    pub fn s2n_connection_set_server_keying_material_lifetime(
        conn: *mut s2n_connection,
        lifetime_in_secs: u32,
    ) -> ::libc::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_session_ticket {
    _unused: [u8; 0],
}
#[doc = " Callback function for receiving a session ticket."]
#[doc = ""]
#[doc = " # Safety"]
#[doc = ""]
#[doc = " `ctx` is a void pointer and the caller is responsible for ensuring it is cast to the correct type."]
#[doc = " `ticket` is valid only within the scope of this callback."]
#[doc = ""]
#[doc = " @param conn A pointer to the connection object."]
#[doc = " @param ctx Context for the session ticket callback function."]
#[doc = " @param ticket Pointer to the received session ticket object."]
pub type s2n_session_ticket_fn = ::core::option::Option<
    unsafe extern "C" fn(
        conn: *mut s2n_connection,
        ctx: *mut ::libc::c_void,
        ticket: *mut s2n_session_ticket,
    ) -> ::libc::c_int,
>;
extern "C" {
    #[doc = " Sets a session ticket callback to be called when a client receives a new session ticket."]
    #[doc = ""]
    #[doc = " # Safety"]
    #[doc = ""]
    #[doc = " `callback` MUST cast `ctx` into the same type of pointer that was originally created."]
    #[doc = " `ctx` MUST be valid for the lifetime of the config, or until a different context is set."]
    #[doc = ""]
    #[doc = " @param config A pointer to the config object."]
    #[doc = " @param callback The function that should be called when the callback is triggered."]
    #[doc = " @param ctx The context to be passed when the callback is called."]
    pub fn s2n_config_set_session_ticket_cb(
        config: *mut s2n_config,
        callback: s2n_session_ticket_fn,
        ctx: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Gets the length of the session ticket from a session ticket object."]
    #[doc = ""]
    #[doc = " @param ticket Pointer to the session ticket object."]
    #[doc = " @param data_len Pointer to be set to the length of the session ticket on success."]
    pub fn s2n_session_ticket_get_data_len(
        ticket: *mut s2n_session_ticket,
        data_len: *mut usize,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Gets the session ticket data from a session ticket object."]
    #[doc = ""]
    #[doc = " # Safety"]
    #[doc = " The entire session ticket will be copied into `data` on success. Therefore, `data` MUST have enough"]
    #[doc = " memory to store the session ticket data."]
    #[doc = ""]
    #[doc = " @param ticket Pointer to the session ticket object."]
    #[doc = " @param max_data_len Maximum length of data that can be written to the 'data' pointer."]
    #[doc = " @param data Pointer to where the session ticket data will be stored."]
    pub fn s2n_session_ticket_get_data(
        ticket: *mut s2n_session_ticket,
        max_data_len: usize,
        data: *mut u8,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Gets the lifetime in seconds of the session ticket from a session ticket object."]
    #[doc = ""]
    #[doc = " @param ticket Pointer to the session ticket object."]
    #[doc = " @param session_lifetime Pointer to a variable where the lifetime of the session ticket will be stored."]
    pub fn s2n_session_ticket_get_lifetime(
        ticket: *mut s2n_session_ticket,
        session_lifetime: *mut u32,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_set_session(
        conn: *mut s2n_connection,
        session: *const u8,
        length: usize,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_get_session(
        conn: *mut s2n_connection,
        session: *mut u8,
        max_length: usize,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_get_session_ticket_lifetime_hint(
        conn: *mut s2n_connection,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_get_session_length(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_get_session_id_length(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_get_session_id(
        conn: *mut s2n_connection,
        session_id: *mut u8,
        max_length: usize,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_is_session_resumed(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_is_ocsp_stapled(conn: *mut s2n_connection) -> ::libc::c_int;
}
pub mod s2n_tls_signature_algorithm {
    pub type Type = ::libc::c_uint;
    pub const ANONYMOUS: Type = 0;
    pub const RSA: Type = 1;
    pub const ECDSA: Type = 3;
    pub const RSA_PSS_RSAE: Type = 224;
    pub const RSA_PSS_PSS: Type = 225;
}
pub mod s2n_tls_hash_algorithm {
    pub type Type = ::libc::c_uint;
    pub const NONE: Type = 0;
    pub const MD5: Type = 1;
    pub const SHA1: Type = 2;
    pub const SHA224: Type = 3;
    pub const SHA256: Type = 4;
    pub const SHA384: Type = 5;
    pub const SHA512: Type = 6;
    pub const MD5_SHA1: Type = 224;
}
extern "C" {
    pub fn s2n_connection_get_selected_signature_algorithm(
        conn: *mut s2n_connection,
        chosen_alg: *mut s2n_tls_signature_algorithm::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_get_selected_digest_algorithm(
        conn: *mut s2n_connection,
        chosen_alg: *mut s2n_tls_hash_algorithm::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_get_selected_client_cert_signature_algorithm(
        conn: *mut s2n_connection,
        chosen_alg: *mut s2n_tls_signature_algorithm::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_get_selected_client_cert_digest_algorithm(
        conn: *mut s2n_connection,
        chosen_alg: *mut s2n_tls_hash_algorithm::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_get_selected_cert(
        conn: *mut s2n_connection,
    ) -> *mut s2n_cert_chain_and_key;
}
extern "C" {
    #[doc = " Returns the length of the s2n certificate chain `chain_and_key`."]
    #[doc = ""]
    #[doc = " @param chain_and_key A pointer to the s2n_cert_chain_and_key object being read."]
    #[doc = " @param cert_length This return value represents the length of the s2n certificate chain `chain_and_key`."]
    pub fn s2n_cert_chain_get_length(
        chain_and_key: *const s2n_cert_chain_and_key,
        cert_length: *mut u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the certificate `out_cert` present at the index `cert_idx` of the certificate chain `chain_and_key`."]
    #[doc = ""]
    #[doc = " Note that the index of the leaf certificate is zero. If the certificate chain `chain_and_key` is NULL or the"]
    #[doc = " certificate index value is not in the acceptable range for the input certificate chain, an error is returned."]
    #[doc = ""]
    #[doc = " # Safety"]
    #[doc = ""]
    #[doc = " There is no memory allocation required for `out_cert` buffer prior to calling the `s2n_cert_chain_get_cert` API."]
    #[doc = " The `out_cert` will contain the pointer to the s2n_cert initialized within the input s2n_cert_chain_and_key `chain_and_key`."]
    #[doc = " The pointer to the output s2n certificate `out_cert` is valid until `chain_and_key` is freed up."]
    #[doc = " If a caller wishes to persist the `out_cert` beyond the lifetime of `chain_and_key`, the contents would need to be"]
    #[doc = " copied prior to freeing `chain_and_key`."]
    #[doc = ""]
    #[doc = " @param chain_and_key A pointer to the s2n_cert_chain_and_key object being read."]
    #[doc = " @param out_cert A pointer to the output s2n_cert `out_cert` present at the index `cert_idx` of the certificate chain `chain_and_key`."]
    #[doc = " @param cert_idx The certificate index for the requested certificate within the s2n certificate chain."]
    pub fn s2n_cert_chain_get_cert(
        chain_and_key: *const s2n_cert_chain_and_key,
        out_cert: *mut *mut s2n_cert,
        cert_idx: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the s2n certificate in DER format along with its length."]
    #[doc = ""]
    #[doc = " The API gets the s2n certificate `cert` in DER format. The certificate is returned in the `out_cert_der` buffer."]
    #[doc = " Here, `cert_len` represents the length of the certificate."]
    #[doc = ""]
    #[doc = " A caller can use certificate parsing tools such as the ones provided by OpenSSL to parse the DER encoded certificate chain returned."]
    #[doc = ""]
    #[doc = " # Safety"]
    #[doc = ""]
    #[doc = " The memory for the `out_cert_der` buffer is allocated and owned by s2n-tls."]
    #[doc = " Since the size of the certificate can potentially be very large, a pointer to internal connection data is returned instead of"]
    #[doc = " copying the contents into a caller-provided buffer."]
    #[doc = ""]
    #[doc = " The pointer to the output buffer `out_cert_der` is valid only while the connection exists."]
    #[doc = " The `s2n_connection_free` API frees the memory associated with the out_cert_der buffer and after the `s2n_connection_wipe` API is"]
    #[doc = " called the memory pointed by out_cert_der is invalid."]
    #[doc = ""]
    #[doc = " If a caller wishes to persist the `out_cert_der` beyond the lifetime of the connection, the contents would need to be"]
    #[doc = " copied prior to the connection termination."]
    #[doc = ""]
    #[doc = " @param cert A pointer to the s2n_cert object being read."]
    #[doc = " @param out_cert_der A pointer to the output buffer which will hold the s2n certificate `cert` in DER format."]
    #[doc = " @param cert_length This return value represents the length of the certificate."]
    pub fn s2n_cert_get_der(
        cert: *const s2n_cert,
        out_cert_der: *mut *const u8,
        cert_length: *mut u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the validated peer certificate chain as a `s2n_cert_chain_and_key` opaque object."]
    #[doc = ""]
    #[doc = " The `s2n_cert_chain_and_key` parameter must be allocated by the caller using the `s2n_cert_chain_and_key_new` API"]
    #[doc = " prior to this function call and must be empty. To free the memory associated with the `s2n_cert_chain_and_key` object use the"]
    #[doc = " `s2n_cert_chain_and_key_free` API."]
    #[doc = ""]
    #[doc = " @param conn A pointer to the s2n_connection object being read."]
    #[doc = " @param s2n_cert_chain_and_key The returned validated peer certificate chain `cert_chain` retrieved from the s2n connection."]
    pub fn s2n_connection_get_peer_cert_chain(
        conn: *const s2n_connection,
        cert_chain: *mut s2n_cert_chain_and_key,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the length of the DER encoded extension value of the ASN.1 X.509 certificate extension."]
    #[doc = ""]
    #[doc = " @param cert A pointer to the s2n_cert object being read."]
    #[doc = " @param oid A null-terminated cstring that contains the OID of the X.509 certificate extension to be read."]
    #[doc = " @param ext_value_len This return value contains the length of DER encoded extension value of the ASN.1 X.509 certificate extension."]
    pub fn s2n_cert_get_x509_extension_value_length(
        cert: *mut s2n_cert,
        oid: *const u8,
        ext_value_len: *mut u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the DER encoding of an ASN.1 X.509 certificate extension value, it's length and a boolean critical."]
    #[doc = ""]
    #[doc = " @param cert A pointer to the s2n_cert object being read."]
    #[doc = " @param oid A null-terminated cstring that contains the OID of the X.509 certificate extension to be read."]
    #[doc = " @param ext_value A pointer to the output buffer which will hold the DER encoding of an ASN.1 X.509 certificate extension value returned."]
    #[doc = " @param ext_value_len  This value is both an input and output parameter and represents the length of the output buffer `ext_value`."]
    #[doc = " When used as an input parameter, the caller must use this parameter to convey the maximum length of `ext_value`."]
    #[doc = " When used as an output parameter, `ext_value_len` holds the actual length of the DER encoding of the ASN.1 X.509 certificate extension value returned."]
    #[doc = " @param critical This return value contains the boolean value for `critical`."]
    pub fn s2n_cert_get_x509_extension_value(
        cert: *mut s2n_cert,
        oid: *const u8,
        ext_value: *mut u8,
        ext_value_len: *mut u32,
        critical: *mut bool,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the UTF8 String length of the ASN.1 X.509 certificate extension data."]
    #[doc = ""]
    #[doc = " @param extension_data A pointer to the DER encoded ASN.1 X.509 certificate extension value being read."]
    #[doc = " @param extension_len represents the length of the input buffer `extension_data`."]
    #[doc = " @param utf8_str_len This return value contains the UTF8 String length of the ASN.1 X.509 certificate extension data."]
    pub fn s2n_cert_get_utf8_string_from_extension_data_length(
        extension_data: *const u8,
        extension_len: u32,
        utf8_str_len: *mut u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the UTF8 String representation of the DER encoded ASN.1 X.509 certificate extension data."]
    #[doc = ""]
    #[doc = " @param extension_data A pointer to the DER encoded ASN.1 X.509 certificate extension value being read."]
    #[doc = " @param extension_len represents the length of the input buffer `extension_data`."]
    #[doc = " @param out_data A pointer to the output buffer which will hold the UTF8 String representation of the DER encoded ASN.1 X.509"]
    #[doc = " certificate extension data returned."]
    #[doc = " @param out_len This value is both an input and output parameter and represents the length of the output buffer `out_data`."]
    #[doc = " When used as an input parameter, the caller must use this parameter to convey the maximum length of `out_data`."]
    #[doc = " When used as an output parameter, `out_len` holds the actual length of UTF8 String returned."]
    pub fn s2n_cert_get_utf8_string_from_extension_data(
        extension_data: *const u8,
        extension_len: u32,
        out_data: *mut u8,
        out_len: *mut u32,
    ) -> ::libc::c_int;
}
pub mod s2n_psk_hmac {
    pub type Type = ::libc::c_uint;
    pub const SHA256: Type = 0;
    pub const SHA384: Type = 1;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_psk {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Creates a new s2n external pre-shared key (PSK) object with `S2N_PSK_HMAC_SHA256` as the default"]
    #[doc = " PSK hash algorithm. An external PSK is a key established outside of TLS using a secure mutually agreed upon mechanism."]
    #[doc = ""]
    #[doc = " Use `s2n_psk_free` to free the memory allocated to the s2n external PSK object created by this API."]
    #[doc = ""]
    #[doc = " @return struct s2n_psk* Returns a pointer to the newly created external PSK object."]
    pub fn s2n_external_psk_new() -> *mut s2n_psk;
}
extern "C" {
    #[doc = " Frees the memory associated with the external PSK object."]
    #[doc = ""]
    #[doc = " @param psk Pointer to the PSK object to be freed."]
    pub fn s2n_psk_free(psk: *mut *mut s2n_psk) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the identity for a given external PSK object."]
    #[doc = " The identity is a unique identifier for the pre-shared secret."]
    #[doc = " It is a non-secret value represented by raw bytes."]
    #[doc = ""]
    #[doc = " # Safety"]
    #[doc = ""]
    #[doc = " The identity is transmitted over the network unencrypted and is a non-secret value."]
    #[doc = " Do not include confidential information in the identity."]
    #[doc = ""]
    #[doc = " Note that the identity is copied into s2n-tls memory and the caller is responsible for"]
    #[doc = " freeing the memory associated with the identity input."]
    #[doc = ""]
    #[doc = " @param psk A pointer to a PSK object to be updated with the identity."]
    #[doc = " @param identity The identity in raw bytes format to be copied."]
    #[doc = " @param identity_size The length of the PSK identity being set."]
    pub fn s2n_psk_set_identity(
        psk: *mut s2n_psk,
        identity: *const u8,
        identity_size: u16,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the out-of-band/externally provisioned secret for a given external PSK object."]
    #[doc = ""]
    #[doc = " # Safety"]
    #[doc = ""]
    #[doc = " Note that the secret is copied into s2n-tls memory and the caller is responsible for"]
    #[doc = " freeing the memory associated with the `secret` input."]
    #[doc = ""]
    #[doc = " Deriving a shared secret from a password or other low-entropy source"]
    #[doc = " is not secure and is subject to dictionary attacks."]
    #[doc = " See https://tools.ietf.org/rfc/rfc8446#section-2.2 for more information."]
    #[doc = ""]
    #[doc = " @param psk A pointer to a PSK object to be updated with the secret."]
    #[doc = " @param secret The secret in raw bytes format to be copied."]
    #[doc = " @param secret_size The length of the pre-shared secret being set."]
    pub fn s2n_psk_set_secret(
        psk: *mut s2n_psk,
        secret: *const u8,
        secret_size: u16,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the hash algorithm for a given external PSK object. The supported PSK hash"]
    #[doc = " algorithms are as listed in the enum `s2n_psk_hmac` above."]
    #[doc = ""]
    #[doc = " @param psk A pointer to the external PSK object to be updated with the PSK hash algorithm."]
    #[doc = " @param hmac The PSK hash algorithm being set."]
    pub fn s2n_psk_set_hmac(psk: *mut s2n_psk, hmac: s2n_psk_hmac::Type) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Appends a PSK object to the list of PSKs supported by the s2n connection."]
    #[doc = " If a PSK with a duplicate identity is found, an error is returned and the PSK is not added to the list."]
    #[doc = " Note that a copy of `psk` is stored on the connection. The user is still responsible for freeing the"]
    #[doc = " memory associated with `psk`."]
    #[doc = ""]
    #[doc = " @param conn A pointer to the s2n_connection object that contains the list of PSKs supported."]
    #[doc = " @param psk A pointer to the `s2n_psk` object to be appended to the list of PSKs on the s2n connection."]
    pub fn s2n_connection_append_psk(conn: *mut s2n_connection, psk: *mut s2n_psk)
        -> ::libc::c_int;
}
pub mod s2n_psk_mode {
    #[doc = " The list of PSK modes supported by s2n-tls for TLS versions >= TLS1.3."]
    #[doc = " Currently s2n-tls supports two modes - `S2N_PSK_MODE_RESUMPTION`, which represents the PSKs established"]
    #[doc = " using the previous connection via session resumption, and `S2N_PSK_MODE_EXTERNAL`, which represents PSKs"]
    #[doc = " established out-of-band/externally using a secure mutually agreed upon mechanism."]
    pub type Type = ::libc::c_uint;
    pub const RESUMPTION: Type = 0;
    pub const EXTERNAL: Type = 1;
}
extern "C" {
    #[doc = " Sets the PSK mode on the s2n config object."]
    #[doc = " The supported PSK modes are listed in the enum `s2n_psk_mode` above."]
    #[doc = ""]
    #[doc = " @param config A pointer to the s2n_config object being updated."]
    #[doc = " @param mode The PSK mode to be set."]
    pub fn s2n_config_set_psk_mode(
        config: *mut s2n_config,
        mode: s2n_psk_mode::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the PSK mode on the s2n connection object."]
    #[doc = " The supported PSK modes are listed in the enum `s2n_psk_mode` above."]
    #[doc = " This API overrides the PSK mode set on config for this connection."]
    #[doc = ""]
    #[doc = " @param conn A pointer to the s2n_connection object being updated."]
    #[doc = " @param mode The PSK mode to be set."]
    pub fn s2n_connection_set_psk_mode(
        conn: *mut s2n_connection,
        mode: s2n_psk_mode::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Gets the negotiated PSK identity length from the s2n connection object. The negotiated PSK"]
    #[doc = " refers to the chosen PSK by the server to be used for the connection."]
    #[doc = ""]
    #[doc = " This API can be used to determine if the negotiated PSK exists. If negotiated PSK exists a"]
    #[doc = " call to this API returns a value greater than zero. If the negotiated PSK does not exist, the"]
    #[doc = " value `0` is returned."]
    #[doc = ""]
    #[doc = " @param conn A pointer to the s2n_connection object that successfully negotiated a PSK connection."]
    #[doc = " @param identity_length The length of the negotiated PSK identity."]
    pub fn s2n_connection_get_negotiated_psk_identity_length(
        conn: *mut s2n_connection,
        identity_length: *mut u16,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Gets the negotiated PSK identity from the s2n connection object."]
    #[doc = " If the negotiated PSK does not exist, the PSK identity will not be obtained and no error will be returned."]
    #[doc = " Prior to this API call, use `s2n_connection_get_negotiated_psk_identity_length` to determine if a"]
    #[doc = " negotiated PSK exists or not."]
    #[doc = ""]
    #[doc = " # Safety"]
    #[doc = ""]
    #[doc = " The negotiated PSK identity will be copied into the identity buffer on success."]
    #[doc = " Therefore, the identity buffer must have enough memory to fit the identity length."]
    #[doc = ""]
    #[doc = " @param conn A pointer to the s2n_connection object."]
    #[doc = " @param identity The negotiated PSK identity obtained from the s2n_connection object."]
    #[doc = " @param max_identity_length The maximum length for the PSK identity. If the negotiated psk_identity length is"]
    #[doc = " greater than this `max_identity_length` value an error will be returned."]
    pub fn s2n_connection_get_negotiated_psk_identity(
        conn: *mut s2n_connection,
        identity: *mut u8,
        max_identity_length: u16,
    ) -> ::libc::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_offered_psk {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Creates a new s2n offered PSK object."]
    #[doc = " An offered PSK object represents a single PSK sent by the client."]
    #[doc = ""]
    #[doc = " # Safety"]
    #[doc = ""]
    #[doc = " Use `s2n_offered_psk_free` to free the memory allocated to the s2n offered PSK object created by this API."]
    #[doc = ""]
    #[doc = " @return struct s2n_offered_psk* Returns a pointer to the newly created offered PSK object."]
    pub fn s2n_offered_psk_new() -> *mut s2n_offered_psk;
}
extern "C" {
    #[doc = " Frees the memory associated with the `s2n_offered_psk` object."]
    #[doc = ""]
    #[doc = " @param psk A pointer to the `s2n_offered_psk` object to be freed."]
    pub fn s2n_offered_psk_free(psk: *mut *mut s2n_offered_psk) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Gets the PSK identity and PSK identity length for a given offered PSK object."]
    #[doc = ""]
    #[doc = " @param psk A pointer to the offered PSK object being read."]
    #[doc = " @param identity The PSK identity being obtained."]
    #[doc = " @param size The length of the PSK identity being obtained."]
    pub fn s2n_offered_psk_get_identity(
        psk: *mut s2n_offered_psk,
        identity: *mut *mut u8,
        size: *mut u16,
    ) -> ::libc::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_offered_psk_list {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Checks whether the offered PSK list has an offered psk object next in line in the list."]
    #[doc = " An offered PSK list contains all the PSKs offered by the client for the server to select."]
    #[doc = ""]
    #[doc = " # Safety"]
    #[doc = ""]
    #[doc = " This API returns a pointer to the s2n-tls internal memory with limited lifetime."]
    #[doc = " After the completion of `s2n_psk_selection_callback` this pointer is invalid."]
    #[doc = ""]
    #[doc = " @param psk_list A pointer to the offered PSK list being read."]
    #[doc = " @return bool A boolean value representing whether an offered psk object is present next in line in the offered PSK list."]
    pub fn s2n_offered_psk_list_has_next(psk_list: *mut s2n_offered_psk_list) -> bool;
}
extern "C" {
    #[doc = " Obtains the next offered PSK object from the list of offered PSKs. Use `s2n_offered_psk_list_has_next`"]
    #[doc = " prior to this API call to ensure we have not reached the end of the list."]
    #[doc = ""]
    #[doc = " @param psk_list A pointer to the offered PSK list being read."]
    #[doc = " @param psk A pointer to the next offered PSK object being obtained."]
    pub fn s2n_offered_psk_list_next(
        psk_list: *mut s2n_offered_psk_list,
        psk: *mut s2n_offered_psk,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the offered PSK list to its original read state."]
    #[doc = ""]
    #[doc = " When `s2n_offered_psk_list_reread` is called, `s2n_offered_psk_list_next` will return the first PSK"]
    #[doc = " in the offered PSK list."]
    #[doc = ""]
    #[doc = " @param psk_list A pointer to the offered PSK list being reread."]
    pub fn s2n_offered_psk_list_reread(psk_list: *mut s2n_offered_psk_list) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Chooses a PSK from the offered PSK list to be used for the connection."]
    #[doc = " This API matches the PSK identity received from the client against the server's known PSK identities"]
    #[doc = " list, in order to choose the PSK to be used for the connection. If the PSK identity sent from the client"]
    #[doc = " is NULL, no PSK is chosen for the connection. If the client offered PSK identity has no matching PSK identity"]
    #[doc = " with the server, an error will be returned. Use this API along with the `s2n_psk_selection_callback` callback"]
    #[doc = " to select a PSK identity."]
    #[doc = ""]
    #[doc = " @param psk_list A pointer to the server's known PSK list used to compare for a matching PSK with the client."]
    #[doc = " @param psk A pointer to the client's PSK object used to compare with the server's known PSK identities."]
    pub fn s2n_offered_psk_list_choose_psk(
        psk_list: *mut s2n_offered_psk_list,
        psk: *mut s2n_offered_psk,
    ) -> ::libc::c_int;
}
#[doc = " Callback function to select a PSK from a list of offered PSKs."]
#[doc = " Use this callback to implement custom PSK selection logic. The s2n-tls default PSK selection logic"]
#[doc = " chooses the first matching PSK from the list of offered PSKs sent by the client."]
#[doc = ""]
#[doc = " # Safety"]
#[doc = ""]
#[doc = " `context` is a void pointer and the caller is responsible for ensuring it is cast to the correct type."]
#[doc = " After the completion of this callback, the pointer to `psk_list` is invalid."]
#[doc = ""]
#[doc = " @param conn A pointer to the s2n_connection object."]
#[doc = " @param context A pointer to a context for the caller to pass state to the callback, if needed."]
#[doc = " @param psk_list A pointer to the offered PSK list being read."]
pub type s2n_psk_selection_callback = ::core::option::Option<
    unsafe extern "C" fn(
        conn: *mut s2n_connection,
        context: *mut ::libc::c_void,
        psk_list: *mut s2n_offered_psk_list,
    ) -> ::libc::c_int,
>;
extern "C" {
    #[doc = " Sets the callback to select the matching PSK."]
    #[doc = " If this callback is not set s2n-tls uses a default PSK selection logic that selects the first matching"]
    #[doc = " server PSK."]
    #[doc = ""]
    #[doc = " @param config A pointer to the s2n_config object."]
    #[doc = " @param cb The function that should be called when the callback is triggered."]
    #[doc = " @param context A pointer to a context for the caller to pass state to the callback, if needed."]
    pub fn s2n_config_set_psk_selection_callback(
        config: *mut s2n_config,
        cb: s2n_psk_selection_callback,
        context: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_get_wire_bytes_in(conn: *mut s2n_connection) -> u64;
}
extern "C" {
    pub fn s2n_connection_get_wire_bytes_out(conn: *mut s2n_connection) -> u64;
}
extern "C" {
    pub fn s2n_connection_get_client_protocol_version(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_get_server_protocol_version(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_get_actual_protocol_version(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_get_client_hello_version(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_client_cert_used(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_get_cipher(conn: *mut s2n_connection) -> *const ::libc::c_char;
}
extern "C" {
    #[doc = " Returns the IANA value for the connection's negotiated cipher suite."]
    #[doc = ""]
    #[doc = " The value is returned in the form of `first,second`, in order to closely match"]
    #[doc = " the values defined in the [IANA Registry](https://www.iana.org/assignments/tls-parameters/tls-parameters.xhtml#table-tls-parameters-4)."]
    #[doc = " For example if the connection's negotiated cipher suite is `TLS_AES_128_GCM_SHA256`,"]
    #[doc = " which is registered as `0x13,0x01`, then `first = 0x13` and `second = 0x01`."]
    #[doc = ""]
    #[doc = " This method will only succeed after the cipher suite has been negotiated with the peer."]
    #[doc = ""]
    #[doc = " @param conn A pointer to the connection being read"]
    #[doc = " @param first A pointer to a single byte, which will be updated with the first byte in the registered IANA value."]
    #[doc = " @param second A pointer to a single byte, which will be updated with the second byte in the registered IANA value."]
    #[doc = " @return A POSIX error signal. If an error was returned, the values contained in `first` and `second` should be considered invalid."]
    pub fn s2n_connection_get_cipher_iana_value(
        conn: *mut s2n_connection,
        first: *mut u8,
        second: *mut u8,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_is_valid_for_cipher_preferences(
        conn: *mut s2n_connection,
        version: *const ::libc::c_char,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_get_curve(conn: *mut s2n_connection) -> *const ::libc::c_char;
}
extern "C" {
    pub fn s2n_connection_get_kem_name(conn: *mut s2n_connection) -> *const ::libc::c_char;
}
extern "C" {
    pub fn s2n_connection_get_kem_group_name(conn: *mut s2n_connection) -> *const ::libc::c_char;
}
extern "C" {
    pub fn s2n_connection_get_alert(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_connection_get_handshake_type_name(
        conn: *mut s2n_connection,
    ) -> *const ::libc::c_char;
}
extern "C" {
    pub fn s2n_connection_get_last_message_name(conn: *mut s2n_connection)
        -> *const ::libc::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_async_pkey_op {
    _unused: [u8; 0],
}
pub mod s2n_async_pkey_validation_mode {
    pub type Type = ::libc::c_uint;
    pub const FAST: Type = 0;
    pub const STRICT: Type = 1;
}
pub mod s2n_async_pkey_op_type {
    pub type Type = ::libc::c_uint;
    pub const DECRYPT: Type = 0;
    pub const SIGN: Type = 1;
}
#[doc = " Callback function for handling private key operations"]
#[doc = ""]
#[doc = " Invoked every time an operation requiring the private key is encountered"]
#[doc = " during the handshake."]
#[doc = ""]
#[doc = " # Safety"]
#[doc = " * `op` is owned by the application and MUST be freed."]
#[doc = ""]
#[doc = " @param conn Connection which triggered the callback"]
#[doc = " @param op An opaque object representing the private key operation"]
pub type s2n_async_pkey_fn = ::core::option::Option<
    unsafe extern "C" fn(conn: *mut s2n_connection, op: *mut s2n_async_pkey_op) -> ::libc::c_int,
>;
extern "C" {
    #[doc = " Sets up the callback to invoke when private key operations occur."]
    #[doc = ""]
    #[doc = " @param config Config to set the callback"]
    #[doc = " @param fn The function that should be called for each private key operation"]
    pub fn s2n_config_set_async_pkey_callback(
        config: *mut s2n_config,
        fn_: s2n_async_pkey_fn,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Performs a private key operation using the given private key."]
    #[doc = ""]
    #[doc = " # Safety"]
    #[doc = " * Can only be called once. Any subsequent calls will produce a `S2N_ERR_T_USAGE` error."]
    #[doc = " * Safe to call from inside s2n_async_pkey_fn"]
    #[doc = " * Safe to call from a different thread, as long as no other thread is operating on `op`."]
    #[doc = ""]
    #[doc = " @param op An opaque object representing the private key operation"]
    #[doc = " @param s2n_cert_private_key The private key used for the operation. It can be extracted from"]
    #[doc = " `conn` through the `s2n_connection_get_selected_cert` and `s2n_cert_chain_and_key_get_key` calls"]
    pub fn s2n_async_pkey_op_perform(
        op: *mut s2n_async_pkey_op,
        key: *mut s2n_cert_private_key,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Finalizes a private key operation and unblocks the connection."]
    #[doc = ""]
    #[doc = " # Safety"]
    #[doc = " * `conn` must match the connection that originally triggered the callback."]
    #[doc = " * Must be called after the operation is performed."]
    #[doc = " * Can only be called once. Any subsequent calls will produce a `S2N_ERR_T_USAGE` error."]
    #[doc = " * Safe to call from inside s2n_async_pkey_fn"]
    #[doc = " * Safe to call from a different thread, as long as no other thread is operating on `op`."]
    #[doc = ""]
    #[doc = " @param op An opaque object representing the private key operation"]
    #[doc = " @param conn The connection associated with the operation that should be unblocked"]
    pub fn s2n_async_pkey_op_apply(
        op: *mut s2n_async_pkey_op,
        conn: *mut s2n_connection,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Frees the opaque structure representing a private key operation."]
    #[doc = ""]
    #[doc = " # Safety"]
    #[doc = " * MUST be called for every operation passed to s2n_async_pkey_fn"]
    #[doc = " * Safe to call before or after the connection that created the operation is freed"]
    #[doc = ""]
    #[doc = " @param op An opaque object representing the private key operation"]
    pub fn s2n_async_pkey_op_free(op: *mut s2n_async_pkey_op) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Configures whether or not s2n-tls will perform potentially expensive validation of"]
    #[doc = " the results of a private key operation."]
    #[doc = ""]
    #[doc = " @param config Config to set the validation mode for"]
    #[doc = " @param mode What level of validation to perform"]
    pub fn s2n_config_set_async_pkey_validation_mode(
        config: *mut s2n_config,
        mode: s2n_async_pkey_validation_mode::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the type of the private key operation."]
    #[doc = ""]
    #[doc = " @param op An opaque object representing the private key operation"]
    #[doc = " @param type A pointer to be set to the type"]
    pub fn s2n_async_pkey_op_get_op_type(
        op: *mut s2n_async_pkey_op,
        type_: *mut s2n_async_pkey_op_type::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the size of the input to the private key operation."]
    #[doc = ""]
    #[doc = " @param op An opaque object representing the private key operation"]
    #[doc = " @param data_len A pointer to be set to the size"]
    pub fn s2n_async_pkey_op_get_input_size(
        op: *mut s2n_async_pkey_op,
        data_len: *mut u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the input to the private key operation."]
    #[doc = ""]
    #[doc = " When signing, the input is the digest to sign."]
    #[doc = " When decrypting, the input is the data to decrypt."]
    #[doc = ""]
    #[doc = " # Safety"]
    #[doc = " * `data` must be sufficiently large to contain the input."]
    #[doc = "   `s2n_async_pkey_op_get_input_size` can be called to determine how much memory is required."]
    #[doc = " * s2n-tls does not take ownership of `data`."]
    #[doc = "   The application still owns the memory and must free it if necessary."]
    #[doc = ""]
    #[doc = " @param op An opaque object representing the private key operation"]
    #[doc = " @param data A pointer to a buffer to copy the input into"]
    #[doc = " @param data_len The maximum size of the `data` buffer"]
    pub fn s2n_async_pkey_op_get_input(
        op: *mut s2n_async_pkey_op,
        data: *mut u8,
        data_len: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the output of the private key operation."]
    #[doc = ""]
    #[doc = " # Safety"]
    #[doc = " * s2n-tls does not take ownership of `data`."]
    #[doc = "   The application still owns the memory and must free it if necessary."]
    #[doc = ""]
    #[doc = " @param op An opaque object representing the private key operation"]
    #[doc = " @param data A pointer to a buffer containing the output"]
    #[doc = " @param data_len The size of the `data` buffer"]
    pub fn s2n_async_pkey_op_set_output(
        op: *mut s2n_async_pkey_op,
        data: *const u8,
        data_len: u32,
    ) -> ::libc::c_int;
}
#[doc = " Callback function for handling key log events"]
#[doc = ""]
#[doc = " THIS SHOULD BE USED FOR DEBUGGING PURPOSES ONLY!"]
#[doc = ""]
#[doc = " Each log line is formatted with the"]
#[doc = " [NSS Key Log Format](https://developer.mozilla.org/en-US/docs/Mozilla/Projects/NSS/Key_Log_Format)"]
#[doc = " without a newline."]
#[doc = ""]
#[doc = " # Safety"]
#[doc = ""]
#[doc = " * `ctx` MUST be cast into the same type of pointer that was originally created"]
#[doc = " * `logline` bytes MUST be copied or discarded before this function returns"]
#[doc = ""]
#[doc = " @param ctx Context for the callback"]
#[doc = " @param conn Connection for which the log line is being emitted"]
#[doc = " @param logline Pointer to the log line data"]
#[doc = " @param len Length of the log line data"]
pub type s2n_key_log_fn = ::core::option::Option<
    unsafe extern "C" fn(
        ctx: *mut ::libc::c_void,
        conn: *mut s2n_connection,
        logline: *mut u8,
        len: usize,
    ) -> ::libc::c_int,
>;
extern "C" {
    #[doc = " Sets a key logging callback on the provided config"]
    #[doc = ""]
    #[doc = " THIS SHOULD BE USED FOR DEBUGGING PURPOSES ONLY!"]
    #[doc = ""]
    #[doc = " Setting this function enables configurations to emit secrets in the"]
    #[doc = " [NSS Key Log Format](https://developer.mozilla.org/en-US/docs/Mozilla/Projects/NSS/Key_Log_Format)"]
    #[doc = ""]
    #[doc = " # Safety"]
    #[doc = ""]
    #[doc = " * `callback` MUST cast `ctx` into the same type of pointer that was originally created"]
    #[doc = " * `ctx` MUST live for at least as long as it is set on the config"]
    #[doc = ""]
    #[doc = " @param config Config to set the callback"]
    #[doc = " @param callback The function that should be called for each secret log entry"]
    #[doc = " @param ctx The context to be passed when the callback is called"]
    pub fn s2n_config_set_key_log_cb(
        config: *mut s2n_config,
        callback: s2n_key_log_fn,
        ctx: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn s2n_config_enable_cert_req_dss_legacy_compat(config: *mut s2n_config) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the maximum bytes of early data the server will accept."]
    #[doc = ""]
    #[doc = " The default maximum is 0. If the maximum is 0, the server rejects all early data requests."]
    #[doc = " The config maximum can be overridden by the connection maximum or the maximum on an external pre-shared key."]
    #[doc = ""]
    #[doc = " @param config A pointer to the config"]
    #[doc = " @param max_early_data_size The maximum early data that the server will accept"]
    #[doc = " @return A POSIX error signal. If successful, the maximum early data size was updated."]
    pub fn s2n_config_set_server_max_early_data_size(
        config: *mut s2n_config,
        max_early_data_size: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the maximum bytes of early data the server will accept."]
    #[doc = ""]
    #[doc = " The default maximum is 0. If the maximum is 0, the server rejects all early data requests."]
    #[doc = " The connection maximum can be overridden by the maximum on an external pre-shared key."]
    #[doc = ""]
    #[doc = " @param conn A pointer to the connection"]
    #[doc = " @param max_early_data_size The maximum early data the server will accept"]
    #[doc = " @return A POSIX error signal. If successful, the maximum early data size was updated."]
    pub fn s2n_connection_set_server_max_early_data_size(
        conn: *mut s2n_connection,
        max_early_data_size: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the user context associated with early data on a server."]
    #[doc = ""]
    #[doc = " This context is passed to the `s2n_early_data_cb` callback to help decide whether to accept or reject early data."]
    #[doc = ""]
    #[doc = " Unlike most contexts, the early data context is a byte buffer instead of a void pointer."]
    #[doc = " This is because we need to serialize the context into session tickets."]
    #[doc = ""]
    #[doc = " This API is intended for use with session resumption, and will not affect pre-shared keys."]
    #[doc = ""]
    #[doc = " @param conn A pointer to the connection"]
    #[doc = " @param context A pointer to the user context data. This data will be copied."]
    #[doc = " @param context_size The size of the data to read from the `context` pointer."]
    #[doc = " @return A POSIX error signal. If successful, the context was updated."]
    pub fn s2n_connection_set_server_early_data_context(
        conn: *mut s2n_connection,
        context: *const u8,
        context_size: u16,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Configures a particular pre-shared key to allow early data."]
    #[doc = ""]
    #[doc = " `max_early_data_size` must be set to the maximum early data accepted by the server."]
    #[doc = ""]
    #[doc = " In order to use early data, the cipher suite set on the pre-shared key must match the cipher suite"]
    #[doc = " ultimately negotiated by the TLS handshake. Additionally, the cipher suite must have the same"]
    #[doc = " hmac algorithm as the pre-shared key."]
    #[doc = ""]
    #[doc = " @param psk A pointer to the pre-shared key, created with `s2n_external_psk_new`."]
    #[doc = " @param max_early_data_size The maximum early data that can be sent or received using this key."]
    #[doc = " @param cipher_suite_first_byte The first byte in the registered IANA value of the associated cipher suite."]
    #[doc = " @param cipher_suite_second_byte The second byte in the registered IANA value of the associated cipher suite."]
    #[doc = " @return A POSIX error signal. If successful, `psk` was updated."]
    pub fn s2n_psk_configure_early_data(
        psk: *mut s2n_psk,
        max_early_data_size: u32,
        cipher_suite_first_byte: u8,
        cipher_suite_second_byte: u8,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the optional `application_protocol` associated with the given pre-shared key."]
    #[doc = ""]
    #[doc = " In order to use early data, the `application_protocol` set on the pre-shared key must match"]
    #[doc = " the `application_protocol` ultimately negotiated by the TLS handshake."]
    #[doc = ""]
    #[doc = " @param psk A pointer to the pre-shared key, created with `s2n_external_psk_new`."]
    #[doc = " @param application_protocol A pointer to the associated application protocol data. This data will be copied."]
    #[doc = " @param size The size of the data to read from the `application_protocol` pointer."]
    #[doc = " @return A POSIX error signal. If successful, the application protocol was set."]
    pub fn s2n_psk_set_application_protocol(
        psk: *mut s2n_psk,
        application_protocol: *const u8,
        size: u8,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the optional user early data context associated with the given pre-shared key."]
    #[doc = ""]
    #[doc = " The early data context is passed to the `s2n_early_data_cb` callback to help decide whether"]
    #[doc = " to accept or reject early data."]
    #[doc = ""]
    #[doc = " @param psk A pointer to the pre-shared key, created with `s2n_external_psk_new`."]
    #[doc = " @param context A pointer to the associated user context data. This data will be copied."]
    #[doc = " @param size The size of the data to read from the `context` pointer."]
    #[doc = " @return A POSIX error signal. If successful, the context was set."]
    pub fn s2n_psk_set_early_data_context(
        psk: *mut s2n_psk,
        context: *const u8,
        size: u16,
    ) -> ::libc::c_int;
}
pub mod s2n_early_data_status_t {
    pub type Type = ::libc::c_uint;
    pub const OK: Type = 0;
    pub const NOT_REQUESTED: Type = 1;
    pub const REJECTED: Type = 2;
    pub const END: Type = 3;
}
extern "C" {
    #[doc = " Reports the current state of early data for a connection."]
    #[doc = ""]
    #[doc = " See `s2n_early_data_status_t` for all possible states."]
    #[doc = ""]
    #[doc = " @param conn A pointer to the connection"]
    #[doc = " @param status A pointer which will be set to the current early data status"]
    #[doc = " @return A POSIX error signal."]
    pub fn s2n_connection_get_early_data_status(
        conn: *mut s2n_connection,
        status: *mut s2n_early_data_status_t::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Reports the remaining size of the early data allowed by a connection."]
    #[doc = ""]
    #[doc = " If early data was rejected or not requested, the remaining early data size is 0."]
    #[doc = " Otherwise, the remaining early data size is the maximum early data allowed by the connection,"]
    #[doc = " minus the early data sent or received so far."]
    #[doc = ""]
    #[doc = " @param conn A pointer to the connection"]
    #[doc = " @param allowed_early_data_size A pointer which will be set to the remaining early data currently allowed by `conn`"]
    #[doc = " @return A POSIX error signal."]
    pub fn s2n_connection_get_remaining_early_data_size(
        conn: *mut s2n_connection,
        allowed_early_data_size: *mut u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Reports the maximum size of the early data allowed by a connection."]
    #[doc = ""]
    #[doc = " This is the maximum amount of early data that can ever be sent and received for a connection."]
    #[doc = " It is not affected by the actual status of the early data, so can be non-zero even if early data"]
    #[doc = " is rejected or not requested."]
    #[doc = ""]
    #[doc = " @param conn A pointer to the connection"]
    #[doc = " @param max_early_data_size A pointer which will be set to the maximum early data allowed by `conn`"]
    #[doc = " @return A POSIX error signal."]
    pub fn s2n_connection_get_max_early_data_size(
        conn: *mut s2n_connection,
        max_early_data_size: *mut u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Called by the client to begin negotiation and send early data."]
    #[doc = ""]
    #[doc = " See https://github.com/aws/s2n-tls/blob/main/docs/USAGE-GUIDE.md#using-early-data--0rtt"]
    #[doc = " for usage and examples. DO NOT USE unless you have considered the security issues and"]
    #[doc = " implemented mitigation for anti-replay attacks."]
    #[doc = ""]
    #[doc = " @param conn A pointer to the connection"]
    #[doc = " @param data A pointer to the early data to be sent"]
    #[doc = " @param data_len The size of the early data to send"]
    #[doc = " @param data_sent A pointer which will be set to the size of the early data sent"]
    #[doc = " @param blocked A pointer which will be set to the blocked status, as in `s2n_negotiate`."]
    #[doc = " @return A POSIX error signal. The error should be handled as in `s2n_negotiate`."]
    pub fn s2n_send_early_data(
        conn: *mut s2n_connection,
        data: *const u8,
        data_len: isize,
        data_sent: *mut isize,
        blocked: *mut s2n_blocked_status::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Called by the server to begin negotiation and accept any early data the client sends."]
    #[doc = ""]
    #[doc = " See https://github.com/aws/s2n-tls/blob/main/docs/USAGE-GUIDE.md#using-early-data--0rtt"]
    #[doc = " for usage and examples. DO NOT USE unless you have considered the security issues and"]
    #[doc = " implemented mitigation for anti-replay attacks."]
    #[doc = ""]
    #[doc = " @param conn A pointer to the connection"]
    #[doc = " @param data A pointer to a buffer to store the early data received"]
    #[doc = " @param max_data_len The size of the early data buffer"]
    #[doc = " @param data_received A pointer which will be set to the size of the early data received"]
    #[doc = " @param blocked A pointer which will be set to the blocked status, as in `s2n_negotiate`."]
    #[doc = " @return A POSIX error signal. The error should be handled as in `s2n_negotiate`."]
    pub fn s2n_recv_early_data(
        conn: *mut s2n_connection,
        data: *mut u8,
        max_data_len: isize,
        data_received: *mut isize,
        blocked: *mut s2n_blocked_status::Type,
    ) -> ::libc::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_offered_early_data {
    _unused: [u8; 0],
}
#[doc = " A callback which can be implemented to accept or reject early data."]
#[doc = ""]
#[doc = " This callback is triggered only after the server has determined early data is otherwise acceptable according"]
#[doc = " to the TLS early data specification. Implementations therefore only need to cover application-specific checks,"]
#[doc = " not the standard TLS early data validation."]
#[doc = ""]
#[doc = " This callback can be synchronous or asynchronous. For asynchronous behavior, return success without"]
#[doc = " calling `s2n_offered_early_data_reject` or `s2n_offered_early_data_accept`. `early_data` will"]
#[doc = " still be a valid reference, and the connection will block until `s2n_offered_early_data_reject` or"]
#[doc = " `s2n_offered_early_data_accept` is called."]
#[doc = ""]
#[doc = " @param conn A pointer to the connection"]
#[doc = " @param early_data A pointer which can be used to access information about the proposed early data"]
#[doc = "                   and then accept or reject it."]
#[doc = " @return A POSIX error signal. If unsuccessful, the connection will be closed with an error."]
pub type s2n_early_data_cb = ::core::option::Option<
    unsafe extern "C" fn(
        conn: *mut s2n_connection,
        early_data: *mut s2n_offered_early_data,
    ) -> ::libc::c_int,
>;
extern "C" {
    #[doc = " Set a callback to accept or reject early data."]
    #[doc = ""]
    #[doc = " @param conn A pointer to the connection"]
    #[doc = " @param cb A pointer to the implementation of the callback."]
    #[doc = " @return A POSIX error signal. If successful, the callback was set."]
    pub fn s2n_config_set_early_data_cb(
        config: *mut s2n_config,
        cb: s2n_early_data_cb,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Get the length of the early data context set by the user."]
    #[doc = ""]
    #[doc = " @param early_data A pointer to the early data information"]
    #[doc = " @param context_len The length of the user context"]
    #[doc = " @return A POSIX error signal."]
    pub fn s2n_offered_early_data_get_context_length(
        early_data: *mut s2n_offered_early_data,
        context_len: *mut u16,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Get the early data context set by the user."]
    #[doc = ""]
    #[doc = " @param early_data A pointer to the early data information"]
    #[doc = " @param context A byte buffer to copy the user context into"]
    #[doc = " @param max_len The size of `context`. Must be >= to the result of `s2n_offered_early_data_get_context_length`."]
    #[doc = " @return A POSIX error signal."]
    pub fn s2n_offered_early_data_get_context(
        early_data: *mut s2n_offered_early_data,
        context: *mut u8,
        max_len: u16,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Reject early data offered by the client."]
    #[doc = ""]
    #[doc = " @param early_data A pointer to the early data information"]
    #[doc = " @return A POSIX error signal. If success, the client's early data will be rejected."]
    pub fn s2n_offered_early_data_reject(early_data: *mut s2n_offered_early_data) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Accept early data offered by the client."]
    #[doc = ""]
    #[doc = " @param early_data A pointer to the early data information"]
    #[doc = " @return A POSIX error signal. If success, the client's early data will be accepted."]
    pub fn s2n_offered_early_data_accept(early_data: *mut s2n_offered_early_data) -> ::libc::c_int;
}
