extern crate structopt;
use structopt::StructOpt;
extern crate colored;
use colored::*;
use failure::ResultExt;
use exitfailure::ExitFailure;
use std::io::{self, Read};

#[derive(StructOpt)]
struct Options {
    #[structopt(default_value = "meow!")]
    /// What does the cat say?
    message: String,

    #[structopt(short = "d", long = "dead")]
    /// Make the cat apear dead
    dead: bool,

    #[structopt(short = "f", long = "file", parse(from_os_str))]
    /// Load the cat picture from file
    catfile: Option<std::path::PathBuf>,

    #[structopt(short = "i", long="stdin")]
    /// Read the message from stdin instead of argument
    stdin: bool,

    #[structopt(short="r", long="ryn")]
    ///Little secret inside of garbage
    rayan: bool,
}


fn main() -> Result<(), ExitFailure> {
    let options = Options::from_args(); // [2]
    let soul = if options.dead {"X"} else {"O"};
    let mut message = String::new();
    if options.rayan {println!("Hello Master!")};
    if options.stdin{
        io::stdin().read_to_string(&mut message)?;
    }else{
        message = options.message
    }
    if message.to_lowercase() == "woof"{
        eprintln!("A cat can't bark like a dog!");
        panic!();
    }
    println!("{}|{}", soul, message.bright_yellow()
             .underline().on_purple());
    match &options.catfile {
        Some (path) => {
            let cat_template = std::fs::read_to_string(path)
                .with_context(|_| format!("could not read file {:?}", path))?;

            let cat_picture = cat_template.replace("{eye}", soul);
            println!("{}", &cat_picture);
        },
        None => {
            println!("-----------------");
        }
    }
    Ok(())
}
