use clap::{Arg, App, SubCommand};

fn main() {
    let matches = App::new("rwarchivefs")
        .version("0.1")
        .author("Taylor C. Richberger <taywee@gmx.com>")
        .about("Mounts an archive filesystem")
        .arg(Arg::with_name("ARCHIVE")
            .help("The rwa archive file")
            .required(true)
            .index(1))
        .arg(Arg::with_name("MOUNTPOINT")
            .help("The destination mount point")
            .required(true)
            .index(2))
        .get_matches();
}
