//! Sequence utilities

/// Generate a linearlly spaced set of points between start and stop
pub fn linspace(start: f64, stop: f64, num: i32) -> Vec<f64> {
    let step = (stop - start) / f64::from(num - 1);
    (0..num)
        .map(|i| f64::from(i).mul_add(step, start))
        .collect()
}

#[cfg(test)]
mod tests {
    use super::*;

    const TOL: f64 = 1E-8;

    #[test]
    fn test_linspace() {
        let expected: Vec<f64> = vec![
            1.0,
            1.183_673_47,
            1.367_346_94,
            1.551_020_41,
            1.734_693_88,
            1.918_367_35,
            2.102_040_82,
            2.285_714_29,
            2.469_387_76,
            2.653_061_22,
            2.836_734_69,
            3.020_408_16,
            3.204_081_63,
            3.387_755_1,
            3.571_428_57,
            3.755_102_04,
            3.938_775_51,
            4.122_448_98,
            4.306_122_45,
            4.489_795_92,
            4.673_469_39,
            4.857_142_86,
            5.040_816_33,
            5.224_489_8,
            5.408_163_27,
            5.591_836_73,
            5.775_510_2,
            5.959_183_67,
            6.142_857_14,
            6.326_530_61,
            6.510_204_08,
            6.693_877_55,
            6.877_551_02,
            7.061_224_49,
            7.244_897_96,
            7.428_571_43,
            7.612_244_9,
            7.795_918_37,
            7.979_591_84,
            8.163_265_31,
            8.346_938_78,
            8.530_612_24,
            8.714_285_71,
            8.897_959_18,
            9.081_632_65,
            9.265_306_12,
            9.448_979_59,
            9.632_653_06,
            9.816_326_53,
            10.0,
        ];

        assert::close(expected, linspace(1.0, 10.0, 50), TOL);
    }
}
