#[derive(Debug, Copy, Clone)]
pub(crate) struct Instruction {
    pub(crate) instruction_kind: InstructionKind,
    pub(crate) keep: bool,
    pub(crate) r#return: bool,
    pub(crate) short: bool,
}

#[derive(Debug, Copy, Clone)]
pub(crate) enum InstructionKind {
    Break,
    Literal,
    NoOperation,
    Pop,
    Duplicate,
    Swap,
    Over,
    Rotate,
    Equal,
    NotEqual,
    GreaterThan,
    LesserThan,
    Jump,
    JumpCondition,
    JumpStash,
    Stash,
    LoadZeroPage,
    StoreZeroPage,
    LoadRelative,
    StoreRelative,
    LoadAbsolute,
    StoreAbsolute,
    DeviceIn,
    DeviceOut,
    Add,
    Subtract,
    Multiply,
    Divide,
    And,
    Or,
    ExclusiveOr,
    Shift,
}
