# Ruvolt
`ruvolt` is an API library to interact with [Revolt Chat](https://revolt.chat) APIs and create bots.

## Getting started

### Installation
To use `ruvolt` we need [ruvolt](https://github.com/Arthur-Damasceno/ruvolt), [async-trait](https://github.com/dtolnay/async-trait) and an asynchronous runtime, let's use the [tokio](https://github.com/tokio-rs/tokio).
Add this to your `Cargo.toml` *dependencies* section and run `cargo build` to compile dependencies.

```toml
ruvolt = "*"
async-trait = "*"
tokio = { version = "*", features = ["macros", "rt-multi-thread"] }
```

### Example - Ping/Pong bot

```rust
use {
    async_trait::async_trait,
    ruvolt::{models::Message, Client, Context, EventHandler, Result},
    std::env,
};

struct Handler;

#[async_trait]
impl EventHandler for Handler {
    async fn message(&self, cx: Context, msg: Message) {
        let content = msg.content.to_string();

        if content == "!ping" {
            msg.reply(&cx, "Pong!", true).await.ok();
        }
    }
}

#[tokio::main]
async fn main() -> Result {
    let token = env::var("TOKEN").unwrap();
    let mut client = Client::new(Handler, token).await?;

    client.listen().await
}
```

### Documentation

#### Rust docs
A documentation generated by [rustdoc](https://doc.rust-lang.org/rustdoc/what-is-rustdoc.html), you can find [here](https://docs.rs/ruvolt).

#### Examples
 - [A more complex Ping/Pong bot](examples/ping_pong.rs)
 - [A counter bot](examples/counter.rs)

## License
This project is under the [MIT](LICENSE) license.
