# Rustyvibes

A Rust CLI that makes mechanical keyboard sound effects on every key press

https://user-images.githubusercontent.com/61944452/135816568-400c5053-8a60-4af2-b43e-e5f15d7b3d74.mp4


# Installation

### macOS:

```
brew install kb24x7/rustyvibes/rustyvibes
```

### Windows / Linux:

```
cargo install rustyvibes
```

# Usage

```
rustyvibes <soundpack_path>
```

### Download Soundpacks: [Here](https://drive.google.com/file/d/1LQEQ9aOVQAs_wgVecXkjaA9K4LXnCdp_/view?usp=sharing)

---

### Mechvibes vs. Rustyvibes

How does Rustyvibes compare to its competitors like Mechvibes? Mechvibes uses Electron and Chromium which is very resource intensive. Rustyvibes on the other hand is made with Rust and can be upto 10x-100x more resource efficient.

Mechvibes Soundpacks: [Here](https://docs.google.com/spreadsheets/d/1PimUN_Qn3CWqfn-93YdVW8OWy8nzpz3w3me41S8S494/edit#gid=0)

Certain custom soundpacks may not work with Rustyvibes, you can use [this tool](https://github.com/kb24x7/packfixer-rustyvibes) to fix those


---


### Privacy and Permissions

Rustyvibes is a fully open-sourced project and never uses any network activity at all. macOS by default will ask you for input monitoring permissions when you start the app for the first time, if you were unable to enable it the first time, you'll need to add your default terminal you're using in the allowed input monitoring apps

![image](https://user-images.githubusercontent.com/61944452/135572648-4358c459-aa06-42e5-a347-ea4feced4efe.png)




## Contribute to this project

[![buymeacoffee](https://user-images.githubusercontent.com/61944452/135130205-4ae387f7-fb32-482e-931c-1b393588872f.png)](https://www.buymeacoffee.com/kb24x7)
