// WARNING: this file was generated by ../scripts/gen-shaping-tests.py

mod shaping_impl;
use shaping_impl::shape;

#[test]
fn aat_morx_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/MORXTwentyeight.ttf",
            "\u{0041}\u{0078}\u{0045}\u{0079}\u{0044}\u{0079}\u{0079}",
            "",
        ),
        "A_E_D=0+1394|\
         x=0+529|\
         y=0+510|\
         y=5+510|\
         y=6+510"
    );
}

#[test]
fn aat_trak_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/TRAK.ttf",
            "\u{0041}\u{0042}\u{0043}",
            "",
        ),
        "A.alt=0+1000|\
         B=1+1000|\
         C.alt=2+1000"
    );
}

#[test]
fn aat_trak_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/TRAK.ttf",
            "\u{0041}\u{0042}\u{0043}",
            "--font-ptem=.5",
        ),
        "A.alt=0@100,0+1200|\
         B=1@100,0+1200|\
         C.alt=2@100,0+1200"
    );
}

#[test]
fn aat_trak_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/TRAK.ttf",
            "\u{0041}\u{0042}\u{0043}",
            "--font-ptem=1",
        ),
        "A.alt=0@100,0+1200|\
         B=1@100,0+1200|\
         C.alt=2@100,0+1200"
    );
}

#[test]
fn aat_trak_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/TRAK.ttf",
            "\u{0041}\u{0042}\u{0043}",
            "--font-ptem=2",
        ),
        "A.alt=0@100,0+1200|\
         B=1@100,0+1200|\
         C.alt=2@100,0+1200"
    );
}

#[test]
fn aat_trak_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/TRAK.ttf",
            "\u{0041}\u{0042}\u{0043}",
            "--font-ptem=9",
        ),
        "A.alt=0@30,0+1060|\
         B=1@30,0+1060|\
         C.alt=2@30,0+1060"
    );
}

#[test]
fn aat_trak_006() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/TRAK.ttf",
            "\u{0041}\u{0042}\u{0043}",
            "--font-ptem=24",
        ),
        "A.alt=0@-7,0+986|\
         B=1@-7,0+986|\
         C.alt=2@-7,0+986"
    );
}

#[test]
fn aat_trak_007() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/TRAK.ttf",
            "\u{0041}\u{0042}\u{0043}",
            "--font-ptem=72",
        ),
        "A.alt=0@-35,0+929|\
         B=1@-35,0+929|\
         C.alt=2@-35,0+929"
    );
}

#[test]
fn aat_trak_008() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/TRAK.ttf",
            "\u{0041}\u{0042}\u{0043}",
            "--font-ptem=144",
        ),
        "A.alt=0@-78,0+843|\
         B=1@-78,0+843|\
         C.alt=2@-78,0+843"
    );
}

#[test]
fn aat_trak_009() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/TRAK.ttf",
            "\u{0041}\u{0042}\u{0043}",
            "--font-ptem=144",
        ),
        "A.alt=0@-78,0+843|\
         B=1@-78,0+843|\
         C.alt=2@-78,0+843"
    );
}

#[test]
fn aat_trak_010() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/TRAK.ttf",
            "\u{0041}\u{0042}\u{0043}",
            "--font-ptem=144 --features=-trak",
        ),
        "A.alt=0+1000|\
         B=1+1000|\
         C.alt=2+1000"
    );
}

#[test]
fn aat_trak_011() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/TRAK.ttf",
            "\u{0041}\u{0042}\u{0043}\u{0041}\u{0042}\u{0043}",
            "--font-ptem=144 --features=-trak[1;3]",
        ),
        "A.alt=0@-78,0+843|\
         B=1+1000|\
         C.alt=2+1000|\
         A.alt=3@-78,0+843|\
         B=4@-78,0+843|\
         C.alt=5@-78,0+843"
    );
}

#[test]
fn arabic_feature_order_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/813c2f8e5512187fd982417a7fb4286728e6f4a8.ttf",
            "\u{1820}\u{180B}",
            "",
        ),
        "uni2048.E81A=0+1550"
    );
}

#[test]
fn arabic_feature_order_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/8a9fea2a7384f2116e5b84a9b31f83be7850ce21.ttf",
            "\u{1820}\u{180B}",
            "",
        ),
        "uni2048.E81A=0+1550"
    );
}

#[test]
fn arabic_feature_order_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a919b33197965846f21074b24e30250d67277bce.ttf",
            "\u{0644}\u{0644}\u{0647}",
            "",
        ),
        "Lellah=0+1503"
    );
}

#[test]
fn arabic_feature_order_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/bf39b0e91ef9807f15a9e283a21a14a209fd2cfc.ttf",
            "\u{0644}\u{064E}\u{0670}\u{0653}\u{0626}",
            "",
        ),
        "afii57414.zz04=4+1202|\
         uni0670_uni0653=0@50,350+0|\
         afii57454=0@550,1425+0|\
         afii57444.calt=0+1065"
    );
}

#[test]
fn arabic_like_joining_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/5dfad7735c6a67085f1b90d4d497e32907db4c78.ttf",
            "\u{1E922}\u{1E923}\u{1E924}\u{1E925}\u{1E926}\u{1E927}\u{1E928}\u{1E929}\u{1E92A}\u{1E92B}\
             \u{1E92C}\u{1E92D}\u{1E92E}\u{1E92F}\u{1E930}\u{1E931}\u{1E932}\u{1E933}\u{1E934}\u{1E935}\
             \u{1E936}\u{1E937}\u{1E938}\u{1E939}\u{1E93A}\u{1E93B}\u{1E93C}\u{1E93D}\u{1E93E}\u{1E93F}\
             \u{1E940}\u{1E941}\u{1E942}\u{1E943}",
            "",
        ),
        "sha_adlam.fina=33+711|\
         kpo_adlam.medi=32+573|\
         zal_adlam.medi=31+773|\
         gbe_adlam.medi=30+594|\
         kha_adlam.medi=29+686|\
         va_adlam.medi=28+621|\
         nha_adlam.medi=27+587|\
         tu_adlam.medi=26+772|\
         nya_adlam.medi=25+577|\
         ga_adlam.medi=24+552|\
         qaaf_adlam.medi=23+694|\
         ha_adlam.medi=22+600|\
         chi_adlam.medi=21+662|\
         jiim_adlam.medi=20+781|\
         u_adlam.medi=19+678|\
         ya_adlam.medi=18+553|\
         kaf_adlam.medi=17+808|\
         nun_adlam.medi=16+561|\
         waw_adlam.medi=15+651|\
         yhe_adlam.medi=14+674|\
         dha_adlam.medi=13+674|\
         o_adlam.medi=12+640|\
         i_adlam.medi=11+657|\
         fa_adlam.medi=10+590|\
         e_adlam.medi=9+628|\
         ra_adlam.medi=8+599|\
         bhe_adlam.medi=7+594|\
         pe_adlam.medi=6+492|\
         sinnyiiyhe_adlam.medi=5+777|\
         ba_adlam.medi=4+655|\
         miim_adlam.medi=3+525|\
         laam_adlam.medi=2+554|\
         daali_adlam.medi=1+600|\
         alif_adlam.init=0+597"
    );
}

#[test]
fn arabic_mark_attach_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/641ca9d7808b01cafa9a666c13811c9b56eb9c52.ttf",
            "\u{064A}\u{0633}\u{06E1}\u{200D}\u{0654}\u{064E}\u{0644}",
            "",
        ),
        "afii57444.zz04=6+1091|\
         afii57454=1@75,925+0|\
         uni0654=1+0|\
         space=1+0|\
         uni06E1=1@950,1115+0|\
         afii57427.zz03_calt=1+1847|\
         afii57450.zz21=0+345"
    );
}

#[test]
fn arabic_mark_order_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/94a5d6fb15a27521fba9ea4aee9cb39b2d03322a.ttf",
            "\u{064A}\u{064E}\u{0670}\u{0653}\u{0640}\u{0654}\u{064E}\u{0627}",
            "",
        ),
        "afii57415.zz04=7+481|\
         afii57454=4@25,975+0|\
         uni0654=4@-50,50+0|\
         afii57440=4+650|\
         uni0670_uni0653=0@75,400+0|\
         afii57454=0@750,1125+0|\
         afii57450.calt=0+1331"
    );
}

#[test]
fn arabic_mark_order_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/24b8d24d00ae86f49791b746da4c9d3f717a51a8.ttf",
            "\u{0628}\u{0618}\u{0619}\u{064E}\u{064F}\u{0654}\u{0658}\u{0653}\u{0654}\u{0651}\
             \u{0656}\u{0651}\u{065C}\u{0655}\u{0650}",
            "",
        ),
        "uni0653.small=0@266,2508+0|\
         uni0654=0@308,2151+0|\
         uni0655=0@518,-1544+0|\
         uni065C=0@501,-1453+0|\
         uni0656=0@573,-659+0|\
         uni0650=0@500,133+0|\
         uni0619=0@300,1807+0|\
         uni0618=0@357,1674+0|\
         uni0651064E=0@387,1178+0|\
         uni0651=0@402,764+0|\
         uni0658=0@424,404+0|\
         uni0654064F=0@540,-435+0|\
         uni0628=0+1352"
    );
}

#[test]
fn arabic_mark_order_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/21b7fb9c1eeae260473809fbc1fe330f66a507cd.ttf",
            "\u{0649}\u{0655}\u{034F}\u{0650}",
            "",
        ),
        "uni0650.small2=0@727,-774+0|\
         space=0+0|\
         uni0655=0@727,-209+0|\
         uni0649=0+1566"
    );
}

#[test]
fn arabic_mark_order_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/21b7fb9c1eeae260473809fbc1fe330f66a507cd.ttf",
            "\u{0649}\u{0655}\u{0650}",
            "",
        ),
        "uni0650.small2=0@727,-774+0|\
         uni0655=0@727,-209+0|\
         uni0649=0+1566"
    );
}

#[test]
fn arabic_mark_order_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/21b7fb9c1eeae260473809fbc1fe330f66a507cd.ttf",
            "\u{0649}\u{0650}\u{0655}",
            "",
        ),
        "uni0650.small2=0@727,-774+0|\
         uni0655=0@727,-209+0|\
         uni0649=0+1566"
    );
}

#[test]
fn arabic_mark_order_006() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/21b7fb9c1eeae260473809fbc1fe330f66a507cd.ttf",
            "\u{0649}\u{0650}\u{034F}\u{0655}",
            "",
        ),
        "uni0655=0+0|\
         space=0+0|\
         uni0650=0@166,0+0|\
         uni0649=0+1566"
    );
}

#[test]
fn arabic_stch_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d9b8bc10985f24796826c29f7ccba3d0ae11ec02.ttf",
            "\u{0718}\u{070F}\u{0718}\u{0718}\u{002E}",
            "--no-glyph-names",
        ),
        "1=4+168|\
         3=3+502|\
         3=2+502|\
         4=1@-1004,0+0|\
         5=1@-876,0+0|\
         5=1@-799,0+0|\
         5=1@-722,0+0|\
         5=1@-645,0+0|\
         4=1@-566,0+0|\
         5=1@-438,0+0|\
         5=1@-361,0+0|\
         5=1@-284,0+0|\
         5=1@-207,0+0|\
         4=1@-128,0+0|\
         3=0+502"
    );
}

#[test]
fn automatic_fractions_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/15dfc433a135a658b9f4b1a861b5cdd9658ccbb9.ttf",
            "\u{0031}\u{0032}\u{0033}\u{2044}\u{0034}\u{0035}\u{0036}",
            "",
        ),
        "one.numr=0+600|\
         two.numr=1+600|\
         three.numr=2+600|\
         fraction=3+252|\
         four.small=4+600|\
         five.small=5+600|\
         six.small=6+600"
    );
}

#[test]
fn automatic_fractions_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/15dfc433a135a658b9f4b1a861b5cdd9658ccbb9.ttf",
            "\u{0031}\u{0032}\u{0033}\u{2044}\u{0034}\u{0035}\u{0036}",
            "--direction=l --script=arab",
        ),
        "one.numr=0+600|\
         two.numr=1+600|\
         three.numr=2+600|\
         fraction=3+252|\
         four.small=4+600|\
         five.small=5+600|\
         six.small=6+600"
    );
}

#[test]
fn automatic_fractions_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/15dfc433a135a658b9f4b1a861b5cdd9658ccbb9.ttf",
            "\u{0661}\u{0662}\u{0663}\u{2044}\u{0664}\u{0665}\u{0666}",
            "--direction=l",
        ),
        "uni0661.numr=0+600|\
         uni0662.numr=1+600|\
         uni0663.numr=2+600|\
         fraction=3+252|\
         uni0664.small=4+600|\
         uni0665.small=5+600|\
         uni0666.small=6+600"
    );
}

#[test]
fn cluster_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4fac3929fc3332834e93673780ec0fe94342d193.ttf",
            "\u{0078}\u{030A}\u{0058}\u{030A}",
            "--cluster-level=2",
        ),
        "gid2=0+1083|\
         gid3=1@-1132,-8+0|\
         gid1=2+1200|\
         gid3=3@-1190,349+0"
    );
}

#[test]
fn cluster_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/43ef465752be9af900745f72fe29cb853a1401a5.ttf",
            "\u{05D4}\u{05B7}\u{05E9}\u{05BC}\u{05C1}\u{05B8}\u{05DE}\u{05B4}\u{05DD}",
            "--cluster-level=1",
        ),
        "uni05DD=8+1359|\
         uni05B4=7@111,0+0|\
         uni05DE=6+1391|\
         uni05B8=5+0|\
         uni05BC=3+0|\
         uni05C1=3+0|\
         uni05E9=2+1451|\
         uni05B7=1@28,0+0|\
         uni05D4=0+1338"
    );
}

#[test]
fn collections_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/TTC.ttc",
            "\u{2026}\u{0020}\u{002E}",
            "--face-index=0",
        ),
        "ellipsis=0+723|\
         space=1+250|\
         period=2+241"
    );
}

#[test]
fn collections_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/TTC.ttc",
            "\u{2026}\u{0020}\u{002E}",
            "--face-index=1",
        ),
        "ellipsis=0+723|\
         space=1+250|\
         period=2+241"
    );
}

#[test]
fn color_fonts_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/ee39587d13b2afa5499cc79e45780aa79293bbd4.ttf",
            "\u{1F42F}",
            "--show-extents",
        ),
        "gid1=0+2963<0,2179,2963,-2789>"
    );
}

#[test]
fn color_fonts_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/fcbaa518d3cce441ed37ae3b1fed6a19e9b54efd.ttf",
            "\u{1F600}",
            "--show-extents",
        ),
        "gid4=0+2550<0,1898,2555,-2405>"
    );
}

#[test]
fn context_matching_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4cce528e99f600ed9c25a2b69e32eb94a03b4ae8.ttf",
            "\u{1A48}\u{1A58}\u{1A25}\u{1A48}\u{1A58}\u{1A25}\u{1A6E}\u{1A63}",
            "",
        ),
        "uni1A48=0+1212|\
         uni1A25=0+1912|\
         uni1A58=0+0|\
         uni1A48=3+1212|\
         uni1A6E=3+0|\
         uni1A25=3+1912|\
         uni1A58=3+0|\
         uni1A63=3+1212"
    );
}

#[test]
fn context_matching_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d629e7fedc0b350222d7987345fe61613fa3929a.ttf",
            "\u{0915}\u{093F}\u{0915}\u{093F}",
            "",
        ),
        "ivowelsign03deva=0+530|\
         kadeva=0+1561|\
         ivowelsign03deva=2+530|\
         kadeva=2+1561"
    );
}

#[test]
fn context_matching_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/f499fbc23865022234775c43503bba2e63978fe1.ttf",
            "\u{09B0}\u{09CD}\u{09A5}\u{09CD}\u{09AF}\u{09C0}",
            "",
        ),
        "gid1=0+1320|\
         gid13=0+523|\
         gid18=0+545"
    );
}

#[test]
fn cursive_positioning_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/c4e48b0886ef460f532fb49f00047ec92c432ec0.ttf",
            "\u{0643}\u{0645}\u{0645}\u{062B}\u{0644}",
            "",
        ),
        "gid8=4+738|\
         gid5=3@441,1197+0|\
         gid6=3@0,432+405|\
         gid9=2@0,477+452|\
         gid9=1@0,977+452|\
         gid10=0@20,1577+207"
    );
}

#[test]
fn cursive_positioning_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/298c9e1d955f10f6f72c6915c3c6ff9bf9695cec.ttf",
            "\u{0643}\u{0645}\u{0645}\u{062B}\u{0644}",
            "",
        ),
        "gid8=4+738|\
         gid5=3@441,1197+0|\
         gid6=3@0,432+405|\
         gid9=2@0,477+500|\
         gid9=1@0,577+452|\
         gid10=0@20,1177+207"
    );
}

#[test]
fn cursive_positioning_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/07f054357ff8638bac3711b422a1e31180bba863.ttf",
            "\u{0606}\u{06E1}",
            "--no-glyph-names",
        ),
        "2=0@40,502+0|\
         1=0+1000"
    );
}

#[test]
fn cursive_positioning_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/9fc3e6960b3520e5304033ef5fd540285f72f14d.ttf",
            "\u{16F0A}\u{16F57}\u{16F8F}",
            "",
        ),
        "u16F0A=0+422|\
         u16F57=0@0,209+338|\
         u16F8F=0+0"
    );
}

#[test]
fn default_ignorables_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/051d92f8bc6ff724511b296c27623f824de256e9.ttf",
            "\u{0075}\u{0361}\u{034F}\u{0301}\u{0069}",
            "",
        ),
        "gid2=0+1266|\
         gid7=0@-617,442+0|\
         gid5=0@-7,0+0|\
         gid1=4+528"
    );
}

#[test]
fn default_ignorables_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/bf962d3202883a820aed019d9b5c1838c2ff69c6.ttf",
            "\u{0020}\u{06CC}\u{064E}\u{034F}\u{0651}",
            "",
        ),
        "uni0651=1+0|\
         space=1+0|\
         uni064E=1@236,-432+0|\
         uni06CC=1+1266|\
         space=0+452"
    );
}

#[test]
fn emoji_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/53374c7ca3657be37efde7ed02ae34229a56ae1f.ttf",
            "\u{1F3F4}\u{E0055}\u{E0053}\u{E0064}\u{E0065}\u{E007F}",
            "",
        ),
        "u1F3F4=0+2126|\
         space=0+0|\
         space=0+0|\
         space=0+0|\
         space=0+0|\
         space=0+0"
    );
}

#[test]
fn emoji_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/53374c7ca3657be37efde7ed02ae34229a56ae1f.ttf",
            "\u{1F3F4}\u{E0064}\u{E0065}\u{E007F}",
            "",
        ),
        "de=0+3200"
    );
}

#[test]
fn emoji_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3cf6f8ac6d647473a43a3100e7494b202b2cfafe.ttf",
            "\u{1F481}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}",
            "--direction=l",
        ),
        "gid7=0+2550"
    );
}

#[test]
fn emoji_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3cf6f8ac6d647473a43a3100e7494b202b2cfafe.ttf",
            "\u{1F481}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}",
            "--direction=r",
        ),
        "gid7=0+2550"
    );
}

#[test]
fn emoji_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/8d9c4b193808b8bde94389ba7831c1fc6f9e794e.ttf",
            "\u{1F3F4}\u{E0067}\u{E0062}\u{E0077}\u{E006C}\u{E0073}\u{E007F}",
            "",
        ),
        ".notdef=0+1229|\
         space=0+0|\
         space=0+0|\
         space=0+0|\
         space=0+0|\
         space=0+0|\
         space=0+0"
    );
}

#[test]
fn fallback_positioning_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/8228d035fcd65d62ec9728fb34f42c63be93a5d3.ttf",
            "\u{0078}\u{0301}\u{0058}\u{0301}",
            "",
        ),
        "x=0+1030|\
         acutecomb=0@-19,-27+0|\
         X=2+1295|\
         acutecomb=2@-151,320+0"
    );
}

#[test]
fn fallback_positioning_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/856ff9562451293cbeff6f396d4e3877c4f0a436.ttf",
            "\u{0061}\u{035C}\u{0062}",
            "",
        ),
        "uni0061=0+512|\
         uni035C=0@0,-128+0|\
         uni0062=2+512"
    );
}

#[test]
fn hangul_jamo_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/757ebd573617a24aa9dfbf0b885c54875c6fe06b.ttf",
            "\u{115F}\u{11A2}",
            "",
        ),
        "gid3=0+920|\
         gid4=0+0"
    );
}

#[test]
fn hangul_jamo_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/7e14e7883ed152baa158b80e207b66114c823a8b.ttf",
            "\u{11A2}",
            "",
        ),
        "gid1=0+920"
    );
}

#[test]
fn hyphens_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c04a16f32a39c26c851b7fc014d2e8d298ba2b8.ttf",
            "\u{2010}",
            "",
        ),
        "gid1=0+739"
    );
}

#[test]
fn hyphens_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c04a16f32a39c26c851b7fc014d2e8d298ba2b8.ttf",
            "\u{2011}",
            "",
        ),
        "gid1=0+739"
    );
}

#[test]
fn indic_consonant_with_stacker_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a014549f766436cf55b2ceb40e462038938ee899.ttf",
            "\u{0CF1}\u{0C95}",
            "--no-glyph-names",
        ),
        "2=0+1129|\
         3=1+358"
    );
}

#[test]
fn indic_consonant_with_stacker_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/55c88ebbe938680b08f92c3de20713183e0c7481.ttf",
            "\u{0CF2}\u{0CAA}",
            "--no-glyph-names",
        ),
        "2=0+1539|\
         3=1+245"
    );
}

#[test]
fn indic_consonant_with_stacker_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/341421e629668b1a1242245d39238ca48432d35d.ttf",
            "\u{0CF1}",
            "--no-glyph-names",
        ),
        "1=0+1129"
    );
}

#[test]
fn indic_consonant_with_stacker_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/663aef6b019dbf45ffd74089e2b5f2496ceceb18.ttf",
            "\u{0CF2}",
            "--no-glyph-names",
        ),
        "1=0+1539"
    );
}

#[test]
fn indic_init_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1a3d8f381387dd29be1e897e4b5100ac8b4829e1.ttf",
            "\u{09AC}\u{09C7}\u{09AC}\u{09C7}",
            "--no-glyph-names",
        ),
        "3=0+273|\
         1=0+460|\
         2=2+307|\
         1=2+460"
    );
}

#[test]
fn indic_joiner_candrabindu_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/5028afb650b1bb718ed2131e872fbcce57828fff.ttf",
            "\u{0B13}\u{200D}\u{0B01}",
            "",
        ),
        "omorya=0+1450"
    );
}

#[test]
fn indic_joiner_candrabindu_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/5028afb650b1bb718ed2131e872fbcce57828fff.ttf",
            "\u{0B13}\u{200C}\u{0B01}",
            "",
        ),
        "oorya=0+1309|\
         space=1+0|\
         candrabinduorya=1+0"
    );
}

#[test]
fn indic_joiners_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/f443753e8ffe8e8aae606cfba158e00334b6efb1.ttf",
            "\u{179A}\u{1784}\u{17D2}\u{179F}\u{200C}\u{17CA}\u{17B8}\u{0020}",
            "",
        ),
        "uni179a=0+775|\
         uni1784=1+1550|\
         uni179f.sub=1+775|\
         space=4+0|\
         uni17ca=4+0|\
         uni17b8=4@0,300+0|\
         space=7+600"
    );
}

#[test]
fn indic_joiners_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/f443753e8ffe8e8aae606cfba158e00334b6efb1.ttf",
            "\u{179A}\u{1784}\u{17D2}\u{179F}\u{17CA}\u{17B8}",
            "",
        ),
        "uni179a=0+775|\
         uni1784=1+1550|\
         uni179f.sub=1+775|\
         uni17bb=1@-75,-700+0|\
         uni17b8=1+0"
    );
}

#[test]
fn indic_joiners_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/8116e5d8fedfbec74e45dc350d2416d810bed8c4.ttf",
            "\u{091F}\u{094D}\u{200C}\u{092F}\u{093F}",
            "",
        ),
        "uni091F=0+876|\
         uni094D=0@4,0+0|\
         space=2+0|\
         uni093F.750=3+397|\
         uni092F=3+924"
    );
}

#[test]
fn indic_joiners_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/8116e5d8fedfbec74e45dc350d2416d810bed8c4.ttf",
            "\u{091F}\u{094D}\u{200D}\u{092F}\u{093F}",
            "",
        ),
        "uni093F=0+398|\
         uni091F=0+876|\
         uni094D=0@4,0+0|\
         space=0+0|\
         uni092F=0+924"
    );
}

#[test]
fn indic_joiners_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/8116e5d8fedfbec74e45dc350d2416d810bed8c4.ttf",
            "\u{091F}\u{094D}\u{200D}\u{091F}\u{094D}\u{200C}\u{091F}\u{094D}\u{200D}\u{092F}\
             \u{093F}",
            "",
        ),
        "uni091F=0+876|\
         uni094D=0@4,0+0|\
         space=0+0|\
         uni091F=3+876|\
         uni094D=3@4,0+0|\
         space=5+0|\
         uni093F=6+398|\
         uni091F=6+876|\
         uni094D=6@4,0+0|\
         space=6+0|\
         uni092F=6+924"
    );
}

#[test]
fn indic_joiners_006() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/8116e5d8fedfbec74e45dc350d2416d810bed8c4.ttf",
            "\u{091F}\u{094D}\u{200D}\u{091F}\u{094D}\u{200D}\u{091F}\u{094D}\u{200D}\u{092F}\
             \u{093F}",
            "",
        ),
        "uni093F=0+398|\
         uni091F=0+876|\
         uni094D=0@4,0+0|\
         space=0+0|\
         uni091F=0+876|\
         uni094D=0@4,0+0|\
         space=0+0|\
         uni091F=0+876|\
         uni094D=0@4,0+0|\
         space=0+0|\
         uni092F=0+924"
    );
}

#[test]
fn indic_old_spec_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/57a9d9f83020155cbb1d2be1f43d82388cbecc88.ttf",
            "\u{0C9A}\u{0CCD}\u{0C9A}\u{0CCD}",
            "",
        ),
        "U0C9A_U0CCD.haln=0+1066|\
         U0C9A_0CCD.blwf=0+0"
    );
}

#[test]
fn indic_old_spec_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/270b89df543a7e48e206a2d830c0e10e5265c630.ttf",
            "\u{0D38}\u{0D4D}\u{0D31}\u{0D4D}\u{0D31}\u{0D4D}",
            "",
        ),
        "glyph201=0+1183|\
         U0D4D=0+0"
    );
}

#[test]
fn indic_old_spec_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b722a7d09e60421f3efbc706ad348ab47b88567b.ttf",
            "\u{091F}\u{094D}\u{0930}\u{094D}\u{0020}",
            "",
        ),
        "Tra=0+550|\
         virAma=0@-73,-110+0|\
         space=4+500"
    );
}

#[test]
fn indic_old_spec_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b722a7d09e60421f3efbc706ad348ab47b88567b.ttf",
            "\u{091F}\u{094D}\u{0930}\u{0942}",
            "",
        ),
        "Tra=0+550|\
         UT=0@42,-150+0"
    );
}

#[test]
fn indic_pref_blocking_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/226bc2deab3846f1a682085f70c67d0421014144.ttf",
            "\u{0D2F}\u{0D4D}\u{0D30}\u{0D46}",
            "",
        ),
        "evowelsignmlym=0+1465|\
         rapostmlym=0+499|\
         yamlym=0+2120"
    );
}

#[test]
fn indic_pref_blocking_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/e207635780b42f898d58654b65098763e340f5c7.ttf",
            "\u{0D2F}\u{0D4D}\u{0D30}\u{0D46}",
            "",
        ),
        "yamlym=0+2120|\
         viramamlym=0+0|\
         evowelsignmlym=0+1465|\
         ramlym=0+1507"
    );
}

#[test]
fn indic_script_extensions_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3493e92eaded2661cadde752a39f9d58b11f0326.ttf",
            "\u{0BA4}\u{0BC6}\u{1133C}\u{0BAA}\u{1133C}\u{0BC6}\u{1133C}",
            "",
        ),
        "u0BC6=0+2093|\
         u1133C=0+0|\
         u0BA4=0+1863|\
         u0BC6=3+2093|\
         u1133C=3+0|\
         u0BAA=3+1706|\
         u1133C=3+0"
    );
}

#[test]
fn indic_script_extensions_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b151cfcdaa77585d77f17a42158e0873fc8e2633.ttf",
            "\u{0BAA}\u{11301}\u{11303}",
            "--no-glyph-names",
        ),
        "1=0+535|\
         2=0+0|\
         3=0+310"
    );
}

#[test]
fn indic_special_cases_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3cae6bfe5b57c07ba81ddbd54c02fe4f3a1e3bf6.ttf",
            "\u{0CB0}\u{0CCD}\u{0C95}",
            "",
        ),
        "gid1=0+1176|\
         gid5=0+1161"
    );
}

#[test]
fn indic_special_cases_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3cae6bfe5b57c07ba81ddbd54c02fe4f3a1e3bf6.ttf",
            "\u{0CB0}\u{200D}\u{0CCD}\u{0C95}",
            "",
        ),
        "gid2=0+1334|\
         gid6=0+358"
    );
}

#[test]
fn indic_special_cases_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3cae6bfe5b57c07ba81ddbd54c02fe4f3a1e3bf6.ttf",
            "\u{0CB0}\u{0CCD}\u{200D}\u{0C95}",
            "",
        ),
        "gid2=0+1334|\
         gid6=0+358"
    );
}

#[test]
fn indic_syllable_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/54674a3111d209fb6be0ed31745314b7a8d2c244.ttf",
            "\u{0BA4}\u{0BCD}\u{00B3}",
            "",
        ),
        "taprehalftamil=0+1509|\
         uni00B3=2+674"
    );
}

#[test]
fn indic_syllable_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3d0b77a2360aa6faa1385aaa510509ab70dfbeff.ttf",
            "\u{0CF1}",
            "",
        ),
        "gid1=0+1129"
    );
}

#[test]
fn indic_syllable_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3d0b77a2360aa6faa1385aaa510509ab70dfbeff.ttf",
            "\u{0CF2}",
            "",
        ),
        "gid2=0+1539"
    );
}

#[test]
fn indic_syllable_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/87f85d17d26f1fe9ad28d7365101958edaefb967.ttf",
            "\u{0980}\u{0981}",
            "",
        ),
        "anjibeng=0+520|\
         candrabindubeng=0+0"
    );
}

#[test]
fn indic_syllable_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85fe0be440c64ac77699e21c2f1bd933a919167e.ttf",
            "\u{0A15}\u{0A51}\u{0A47}",
            "",
        ),
        "kaguru=0+1273|\
         udaatguru=0@75,0+0|\
         eematraguru=0@-40,0+0"
    );
}

#[test]
fn indic_syllable_006() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1735326da89f0818cd8c51a0600e9789812c0f94.ttf",
            "\u{0A51}",
            "",
        ),
        "uni25CC=0+1044|\
         udaatguru=0+0"
    );
}

#[test]
fn indic_syllable_007() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1735326da89f0818cd8c51a0600e9789812c0f94.ttf",
            "\u{25CC}\u{0A51}",
            "",
        ),
        "uni25CC=0+1044|\
         udaatguru=0+0"
    );
}

#[test]
fn indic_syllable_008() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/81c368a33816fb20e9f647e8f24e2180f4720263.ttf",
            "\u{0C80}\u{0C82}",
            "--no-glyph-names",
        ),
        "1=0+502|\
         2=0+502"
    );
}

#[test]
fn indic_syllable_009() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/f75c4b05a0a4d67c1a808081ae3d74a9c66509e8.ttf",
            "\u{0A20}\u{0A75}\u{0A47}",
            "",
        ),
        "tthaguru=0+1352|\
         yakashguru=0@-90,0+0|\
         eematraguru=0@-411,0+0"
    );
}

#[test]
fn indic_syllable_010() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/f75c4b05a0a4d67c1a808081ae3d74a9c66509e8.ttf",
            "\u{0A20}\u{0A75}\u{0A42}",
            "",
        ),
        "tthaguru=0+1352|\
         yakashuuguru=0+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1a5face3fcbd929d228235c2f72bbd6f8eb37424.ttf",
            "\u{0904}\u{0020}\u{0905}\u{0946}",
            "",
        ),
        "ashortdeva=0+764|\
         space=1+260|\
         adeva=2+764|\
         uni25CC=2+510|\
         eshortvowelsigndeva=2+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1a5face3fcbd929d228235c2f72bbd6f8eb37424.ttf",
            "\u{0906}\u{0020}\u{0905}\u{093E}",
            "",
        ),
        "aadeva=0+1023|\
         space=1+260|\
         adeva=2+764|\
         uni25CC=2+510|\
         aavowelsigndeva=2+259"
    );
}

#[test]
fn indic_vowel_letter_spoofing_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1a5face3fcbd929d228235c2f72bbd6f8eb37424.ttf",
            "\u{0908}\u{0020}\u{0930}\u{094D}\u{0907}",
            "",
        ),
        "iideva=0+491|\
         space=1+260|\
         uni25CC=2+510|\
         rephdeva=2+0|\
         ideva=2+491"
    );
}

#[test]
fn indic_vowel_letter_spoofing_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1a5face3fcbd929d228235c2f72bbd6f8eb37424.ttf",
            "\u{090A}\u{0020}\u{0909}\u{0941}",
            "",
        ),
        "uudeva=0+765|\
         space=1+260|\
         udeva=2+548|\
         uni25CC=2+510|\
         uvowelsigndeva=2+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1a5face3fcbd929d228235c2f72bbd6f8eb37424.ttf",
            "\u{090D}\u{0020}\u{090F}\u{0945}",
            "",
        ),
        "ecandradeva=0+553|\
         space=1+260|\
         edeva=2+553|\
         uni25CC=2+510|\
         ecandravowelsigndeva=2+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_006() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1a5face3fcbd929d228235c2f72bbd6f8eb37424.ttf",
            "\u{090E}\u{0020}\u{090F}\u{0946}",
            "",
        ),
        "eshortdeva=0+553|\
         space=1+260|\
         edeva=2+553|\
         uni25CC=2+510|\
         eshortvowelsigndeva=2+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_007() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1a5face3fcbd929d228235c2f72bbd6f8eb37424.ttf",
            "\u{0910}\u{0020}\u{090F}\u{0947}",
            "",
        ),
        "aideva=0+553|\
         space=1+260|\
         edeva=2+553|\
         uni25CC=2+510|\
         evowelsigndeva=2+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_008() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1a5face3fcbd929d228235c2f72bbd6f8eb37424.ttf",
            "\u{0911}\u{0020}\u{0905}\u{0949}\u{0020}\u{0906}\u{0945}",
            "",
        ),
        "ocandradeva=0+1023|\
         space=1+260|\
         adeva=2+764|\
         uni25CC=2+510|\
         ocandravowelsigndeva=2+259|\
         space=4+260|\
         aadeva=5+1023|\
         uni25CC=5+510|\
         ecandravowelsigndeva=5+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_009() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1a5face3fcbd929d228235c2f72bbd6f8eb37424.ttf",
            "\u{0912}\u{0020}\u{0905}\u{094A}\u{0020}\u{0906}\u{0946}",
            "",
        ),
        "oshortdeva=0+1023|\
         space=1+260|\
         adeva=2+764|\
         uni25CC=2+510|\
         oshortvowelsigndeva=2+259|\
         space=4+260|\
         aadeva=5+1023|\
         uni25CC=5+510|\
         eshortvowelsigndeva=5+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_010() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1a5face3fcbd929d228235c2f72bbd6f8eb37424.ttf",
            "\u{0913}\u{0020}\u{0905}\u{094B}\u{0020}\u{0906}\u{0947}",
            "",
        ),
        "odeva=0+1023|\
         space=1+260|\
         adeva=2+764|\
         uni25CC=2+510|\
         ovowelsigndeva=2+259|\
         space=4+260|\
         aadeva=5+1023|\
         uni25CC=5+510|\
         evowelsigndeva=5+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_011() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1a5face3fcbd929d228235c2f72bbd6f8eb37424.ttf",
            "\u{0914}\u{0020}\u{0905}\u{094C}\u{0020}\u{0906}\u{0948}",
            "",
        ),
        "audeva=0+1023|\
         space=1+260|\
         adeva=2+764|\
         uni25CC=2+510|\
         auvowelsigndeva=2+259|\
         space=4+260|\
         aadeva=5+1023|\
         uni25CC=5+510|\
         aivowelsigndeva=5+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_012() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1a5face3fcbd929d228235c2f72bbd6f8eb37424.ttf",
            "\u{0972}\u{0020}\u{0905}\u{0945}",
            "",
        ),
        "acandradeva=0+764|\
         space=1+260|\
         adeva=2+764|\
         uni25CC=2+510|\
         ecandravowelsigndeva=2+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_013() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1a5face3fcbd929d228235c2f72bbd6f8eb37424.ttf",
            "\u{0973}\u{0020}\u{0905}\u{093A}",
            "",
        ),
        "oedeva=0+764|\
         space=1+260|\
         adeva=2+764|\
         uni25CC=2+510|\
         oevowelsigndeva=2+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_014() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1a5face3fcbd929d228235c2f72bbd6f8eb37424.ttf",
            "\u{0974}\u{0020}\u{0905}\u{093B}\u{0020}\u{0906}\u{093A}",
            "",
        ),
        "ooedeva=0+1023|\
         space=1+260|\
         adeva=2+764|\
         uni25CC=2+510|\
         ooevowelsigndeva=2+259|\
         space=4+260|\
         aadeva=5+1023|\
         uni25CC=5+510|\
         oevowelsigndeva=5+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_015() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1a5face3fcbd929d228235c2f72bbd6f8eb37424.ttf",
            "\u{0975}\u{0020}\u{0905}\u{094F}",
            "",
        ),
        "awdeva=0+1023|\
         space=1+260|\
         adeva=2+764|\
         uni25CC=2+510|\
         awvowelsigndeva=2+259"
    );
}

#[test]
fn indic_vowel_letter_spoofing_016() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1a5face3fcbd929d228235c2f72bbd6f8eb37424.ttf",
            "\u{0976}\u{0020}\u{0905}\u{0956}",
            "",
        ),
        "uedeva=0+764|\
         space=1+260|\
         adeva=2+764|\
         uni25CC=2+510|\
         uevowelsigndeva=2@50,0+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_017() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1a5face3fcbd929d228235c2f72bbd6f8eb37424.ttf",
            "\u{0977}\u{0020}\u{0905}\u{0957}",
            "",
        ),
        "uuedeva=0+764|\
         space=1+260|\
         adeva=2+764|\
         uni25CC=2+510|\
         uuevowelsigndeva=2@50,0+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_018() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/881642af1667ae30a54e58de8be904566d00508f.ttf",
            "\u{0986}\u{0020}\u{0985}\u{09BE}",
            "",
        ),
        "aabeng=0+1158|\
         space=1+260|\
         abeng=2+893|\
         uni25CC=2+510|\
         aavowelsignbeng=2+266"
    );
}

#[test]
fn indic_vowel_letter_spoofing_019() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/881642af1667ae30a54e58de8be904566d00508f.ttf",
            "\u{09E0}\u{0020}\u{098B}\u{09C3}",
            "",
        ),
        "rrvocalicbeng=0+853|\
         space=1+260|\
         rvocalicbeng=2+853|\
         uni25CC=2+510|\
         rvocalicvowelsignbeng=2+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_020() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/881642af1667ae30a54e58de8be904566d00508f.ttf",
            "\u{09E1}\u{0020}\u{098C}\u{09E2}",
            "",
        ),
        "llvocalicbeng=0+639|\
         space=1+260|\
         lvocalicbeng=2+639|\
         uni25CC=2+510|\
         lvocalicvowelsignbeng=2+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_021() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/604026ae5aaca83c49cd8416909d71ba3e1c1194.ttf",
            "\u{0A06}\u{0020}\u{0A05}\u{0A3E}",
            "",
        ),
        "aaguru=0+2001|\
         space=1+532|\
         aguru=2+1520|\
         uni25CC=2+1044|\
         aamatraguru=2+481"
    );
}

#[test]
fn indic_vowel_letter_spoofing_022() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/604026ae5aaca83c49cd8416909d71ba3e1c1194.ttf",
            "\u{0A07}\u{0020}\u{0A72}\u{0A3F}",
            "",
        ),
        "iguru=0+1671|\
         space=1+532|\
         iriguru=2+1141|\
         imatraguru=2+530|\
         uni25CC=2+1044"
    );
}

#[test]
fn indic_vowel_letter_spoofing_023() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/604026ae5aaca83c49cd8416909d71ba3e1c1194.ttf",
            "\u{0A08}\u{0020}\u{0A72}\u{0A40}",
            "",
        ),
        "iiguru=0+1671|\
         space=1+532|\
         iriguru=2+1141|\
         uni25CC=2+1044|\
         iimatraguru=2+530"
    );
}

#[test]
fn indic_vowel_letter_spoofing_024() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/604026ae5aaca83c49cd8416909d71ba3e1c1194.ttf",
            "\u{0A09}\u{0020}\u{0A73}\u{0A41}",
            "",
        ),
        "uguru=0+1356|\
         space=1+532|\
         uraguru=2+1356|\
         uni25CC=2+1044|\
         umatraguru=2@102,0+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_025() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/604026ae5aaca83c49cd8416909d71ba3e1c1194.ttf",
            "\u{0A0A}\u{0020}\u{0A73}\u{0A42}",
            "",
        ),
        "uuguru=0+1356|\
         space=1+532|\
         uraguru=2+1356|\
         uni25CC=2+1044|\
         uumatraguru=2@102,0+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_026() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/604026ae5aaca83c49cd8416909d71ba3e1c1194.ttf",
            "\u{0A0F}\u{0020}\u{0A72}\u{0A47}",
            "",
        ),
        "eeguru=0+1141|\
         space=1+532|\
         iriguru=2+1141|\
         uni25CC=2+1044|\
         eematraguru=2+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_027() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/604026ae5aaca83c49cd8416909d71ba3e1c1194.ttf",
            "\u{0A10}\u{0020}\u{0A05}\u{0A48}",
            "",
        ),
        "aiguru=0+1520|\
         space=1+532|\
         aguru=2+1520|\
         uni25CC=2+1044|\
         aimatraguru=2+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_028() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/604026ae5aaca83c49cd8416909d71ba3e1c1194.ttf",
            "\u{0A13}\u{0020}\u{0A73}\u{0A4B}",
            "",
        ),
        "ooguru=0+1356|\
         space=1+532|\
         uraguru=2+1356|\
         uni25CC=2+1044|\
         oomatraguru=2+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_029() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/604026ae5aaca83c49cd8416909d71ba3e1c1194.ttf",
            "\u{0A14}\u{0020}\u{0A05}\u{0A4C}",
            "",
        ),
        "auguru=0+1520|\
         space=1+532|\
         aguru=2+1520|\
         uni25CC=2+1044|\
         aumatraguru=2+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_030() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/738d9f3b8c2dfd03875bf35a61d28fd78faf17c8.ttf",
            "\u{0A86}\u{0020}\u{0A85}\u{0ABE}",
            "",
        ),
        "gid3=0+2351|\
         gid1=1+612|\
         gid2=2+1808|\
         gid17=2+1044|\
         gid10=2+543"
    );
}

#[test]
fn indic_vowel_letter_spoofing_031() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/738d9f3b8c2dfd03875bf35a61d28fd78faf17c8.ttf",
            "\u{0A8D}\u{0020}\u{0A85}\u{0AC5}",
            "",
        ),
        "gid4=0+1808|\
         gid1=1+612|\
         gid2=2+1808|\
         gid17=2+1044|\
         gid11=2+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_032() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/738d9f3b8c2dfd03875bf35a61d28fd78faf17c8.ttf",
            "\u{0A8F}\u{0020}\u{0A85}\u{0AC7}",
            "",
        ),
        "gid5=0+1808|\
         gid1=1+612|\
         gid2=2+1808|\
         gid17=2+1044|\
         gid12=2+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_033() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/738d9f3b8c2dfd03875bf35a61d28fd78faf17c8.ttf",
            "\u{0A90}\u{0020}\u{0A85}\u{0AC8}",
            "",
        ),
        "gid6=0+1808|\
         gid1=1+612|\
         gid2=2+1808|\
         gid17=2+1044|\
         gid13=2+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_034() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/738d9f3b8c2dfd03875bf35a61d28fd78faf17c8.ttf",
            "\u{0A91}\u{0020}\u{0A85}\u{0AC9}",
            "",
        ),
        "gid7=0+2351|\
         gid1=1+612|\
         gid2=2+1808|\
         gid17=2+1044|\
         gid14=2+543"
    );
}

#[test]
fn indic_vowel_letter_spoofing_035() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/738d9f3b8c2dfd03875bf35a61d28fd78faf17c8.ttf",
            "\u{0A93}\u{0020}\u{0A85}\u{0ACB}\u{0020}\u{0A85}\u{0ABE}\u{0AC5}",
            "",
        ),
        "gid8=0+2351|\
         gid1=1+612|\
         gid2=2+1808|\
         gid17=2+1044|\
         gid15=2+543|\
         gid1=4+612|\
         gid2=5+1808|\
         gid17=5+1044|\
         gid11=5+0|\
         gid10=5+543"
    );
}

#[test]
fn indic_vowel_letter_spoofing_036() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/738d9f3b8c2dfd03875bf35a61d28fd78faf17c8.ttf",
            "\u{0A94}\u{0020}\u{0A85}\u{0ACC}\u{0020}\u{0A85}\u{0ABE}\u{0AC8}",
            "",
        ),
        "gid9=0+2351|\
         gid1=1+612|\
         gid2=2+1808|\
         gid17=2+1044|\
         gid16=2+543|\
         gid1=4+612|\
         gid2=5+1808|\
         gid17=5+1044|\
         gid13=5+0|\
         gid10=5+543"
    );
}

#[test]
fn indic_vowel_letter_spoofing_037() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/738d9f3b8c2dfd03875bf35a61d28fd78faf17c8.ttf",
            "\u{0AC9}\u{0020}\u{0AC5}\u{0ABE}",
            "",
        ),
        "gid17=0+1044|\
         gid14=0+543|\
         gid1=1+612|\
         gid17=1+1044|\
         gid11=1+0|\
         gid17=1+1044|\
         gid10=1+543"
    );
}

#[test]
fn indic_vowel_letter_spoofing_038() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2c25beb56d9c556622d56b0b5d02b4670c034f89.ttf",
            "\u{0B06}\u{0020}\u{0B05}\u{0B3E}",
            "",
        ),
        "aaorya=0+1681|\
         space=1+881|\
         aorya=2+1284|\
         uni25CC=2+1044|\
         aavowelsignorya=2+387"
    );
}

#[test]
fn indic_vowel_letter_spoofing_039() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2c25beb56d9c556622d56b0b5d02b4670c034f89.ttf",
            "\u{0B10}\u{0020}\u{0B0F}\u{0B57}",
            "",
        ),
        "aiorya=0+1681|\
         space=1+881|\
         eorya=2+1315|\
         uni25CC=2+1044|\
         aulengthmarkorya=2+387"
    );
}

#[test]
fn indic_vowel_letter_spoofing_040() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2c25beb56d9c556622d56b0b5d02b4670c034f89.ttf",
            "\u{0B14}\u{0020}\u{0B13}\u{0B57}",
            "",
        ),
        "auorya=0+1679|\
         space=1+881|\
         oorya=2+1309|\
         uni25CC=2+1044|\
         aulengthmarkorya=2+387"
    );
}

#[test]
fn indic_vowel_letter_spoofing_041() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/03e3f463c3a985bc42096620cc415342818454fb.ttf",
            "\u{0C13}\u{0020}\u{0C12}\u{0C55}",
            "",
        ),
        "gid3=0+1497|\
         gid1=1+580|\
         gid2=2+1497|\
         gid13=2+1184|\
         gid12=2+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_042() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/03e3f463c3a985bc42096620cc415342818454fb.ttf",
            "\u{0C14}\u{0020}\u{0C12}\u{0C4C}",
            "",
        ),
        "gid4=0+1497|\
         gid1=1+580|\
         gid2=2+1497|\
         gid13=2+1184|\
         gid11=2+634"
    );
}

#[test]
fn indic_vowel_letter_spoofing_043() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/03e3f463c3a985bc42096620cc415342818454fb.ttf",
            "\u{0C40}\u{0020}\u{0C3F}\u{0C55}",
            "",
        ),
        "gid13=0+1184|\
         gid6=0+0|\
         gid1=1+580|\
         gid13=1+1184|\
         gid5=1+0|\
         gid13=1+1184|\
         gid12=1+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_044() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/03e3f463c3a985bc42096620cc415342818454fb.ttf",
            "\u{0C47}\u{0020}\u{0C46}\u{0C55}",
            "",
        ),
        "gid13=0+1184|\
         gid8=0+0|\
         gid1=1+580|\
         gid13=1+1184|\
         gid7=1+0|\
         gid13=1+1184|\
         gid12=1+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_045() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/03e3f463c3a985bc42096620cc415342818454fb.ttf",
            "\u{0C4B}\u{0020}\u{0C4A}\u{0C55}",
            "",
        ),
        "gid13=0+1184|\
         gid10=0+634|\
         gid1=1+580|\
         gid13=1+1184|\
         gid9=1+634|\
         gid13=1+1184|\
         gid12=1+0"
    );
}

#[test]
fn indic_vowel_letter_spoofing_046() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/7d18685e1529e4ceaad5b6095dfab2f9789e5bce.ttf",
            "\u{0C8A}\u{0020}\u{0C89}\u{0CBE}",
            "",
        ),
        "gid3=0+3269|\
         gid1=1+590|\
         gid2=2+2502|\
         gid10=2+1184|\
         gid7=2+919"
    );
}

#[test]
fn indic_vowel_letter_spoofing_047() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/7d18685e1529e4ceaad5b6095dfab2f9789e5bce.ttf",
            "\u{0C94}\u{0020}\u{0C92}\u{0CCC}",
            "",
        ),
        "gid6=0+1596|\
         gid1=1+590|\
         gid5=2+1590|\
         gid10=2+1184|\
         gid8=2+880"
    );
}

#[test]
fn indic_vowel_letter_spoofing_048() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/7d18685e1529e4ceaad5b6095dfab2f9789e5bce.ttf",
            "\u{0CE0}\u{0020}\u{0C8B}\u{0CBE}",
            "",
        ),
        "gid9=0+3214|\
         gid1=1+590|\
         gid4=2+2440|\
         gid10=2+1184|\
         gid7=2+919"
    );
}

#[test]
fn indic_vowel_letter_spoofing_049() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/af85624080af5627fb050f570d148a62f04fda74.ttf",
            "\u{0D08}\u{0020}\u{0D07}\u{0D57}",
            "",
        ),
        "gid3=0+3574|\
         gid1=1+632|\
         gid2=2+2019|\
         gid14=2+1184|\
         gid13=2+1555"
    );
}

#[test]
fn indic_vowel_letter_spoofing_050() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/af85624080af5627fb050f570d148a62f04fda74.ttf",
            "\u{0D0A}\u{0020}\u{0D09}\u{0D57}",
            "",
        ),
        "gid5=0+2972|\
         gid1=1+632|\
         gid4=2+1417|\
         gid14=2+1184|\
         gid13=2+1555"
    );
}

#[test]
fn indic_vowel_letter_spoofing_051() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/af85624080af5627fb050f570d148a62f04fda74.ttf",
            "\u{0D10}\u{0020}\u{0D0E}\u{0D46}",
            "",
        ),
        "gid7=0+4073|\
         gid1=1+632|\
         gid6=2+2608|\
         gid12=2+1465|\
         gid14=2+1184"
    );
}

#[test]
fn indic_vowel_letter_spoofing_052() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/af85624080af5627fb050f570d148a62f04fda74.ttf",
            "\u{0D13}\u{0020}\u{0D12}\u{0D3E}",
            "",
        ),
        "gid9=0+2557|\
         gid1=1+632|\
         gid8=2+1524|\
         gid14=2+1184|\
         gid11=2+1033"
    );
}

#[test]
fn indic_vowel_letter_spoofing_053() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/af85624080af5627fb050f570d148a62f04fda74.ttf",
            "\u{0D14}\u{0020}\u{0D12}\u{0D57}",
            "",
        ),
        "gid10=0+3073|\
         gid1=1+632|\
         gid8=2+1524|\
         gid14=2+1184|\
         gid13=2+1555"
    );
}

#[test]
fn kern_format2_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/e39391c77a6321c2ac7a2d644de0396470cd4bfe.ttf",
            "\u{0061}\u{0062}\u{0063}\u{0064}\u{0065}\u{0066}\u{0067}\u{0068}\u{0069}\u{006A}\
             \u{006B}\u{006C}\u{006D}\u{006E}\u{006F}\u{0070}",
            "",
        ),
        "a=0+626|\
         b=1+672|\
         c=2+564|\
         d=3@-15,0+657|\
         e=4+621|\
         f=5+403|\
         g=6@-10,0+662|\
         h=7+666|\
         i=8+316|\
         j=9+316|\
         k=10+591|\
         l=11+316|\
         m=12+1021|\
         n=13+666|\
         o=14+644|\
         p=15+672"
    );
}

#[test]
fn kern_format2_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/e39391c77a6321c2ac7a2d644de0396470cd4bfe.ttf",
            "\u{0063}\u{006B}\u{0063}\u{006B}\u{0063}\u{006B}",
            "",
        ),
        "c=0+579|\
         k=1+591|\
         c=2+579|\
         k=3+591|\
         c=4+579|\
         k=5+591"
    );
}

#[test]
fn kern_format2_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/e39391c77a6321c2ac7a2d644de0396470cd4bfe.ttf",
            "\u{0041}\u{0056}",
            "",
        ),
        "A=0+701|\
         V=1@-40,0+703"
    );
}

#[test]
fn khmer_mark_order_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17CA}\u{17BE}\u{1794}",
            "",
        ),
        "uni17C1=0+288|\
         uni179F=0+928|\
         uni17BB=0@-6,-26+0|\
         uni17B8=0@-32,-29+0|\
         uni1794=3+635"
    );
}

#[test]
fn khmer_mark_order_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17C9}\u{17BE}\u{17BB}\u{1794}",
            "",
        ),
        "uni17C1=0+288|\
         uni179F=0+928|\
         uni17C9=0@-32,-29+0|\
         uni17B8=0@-32,237+0|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni1794=4+635"
    );
}

#[test]
fn khmer_mark_order_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17C9}\u{17C1}\u{17B8}\u{17BB}\u{1794}",
            "",
        ),
        "uni17C1=0+288|\
         uni179F=0+928|\
         uni17C9=0@-32,-29+0|\
         uni17B8=0@-32,237+0|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni1794=5+635"
    );
}

#[test]
fn khmer_mark_order_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17C9}\u{17B8}\u{17C1}\u{17BB}\u{1794}",
            "",
        ),
        "uni179F=0+928|\
         uni17C9=0@-32,-29+0|\
         uni17B8=0@-32,237+0|\
         uni17C1=0+288|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni1794=5+635"
    );
}

#[test]
fn khmer_mark_order_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17C9}\u{17BE}\u{17BB}\u{17BB}\u{1794}",
            "",
        ),
        "uni17C1=0+288|\
         uni179F=0+928|\
         uni17C9=0@-32,-29+0|\
         uni17B8=0@-32,237+0|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni1794=5+635"
    );
}

#[test]
fn khmer_mark_order_006() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17C9}\u{17C1}\u{17B8}\u{17BB}\u{17BB}\u{1794}",
            "",
        ),
        "uni17C1=0+288|\
         uni179F=0+928|\
         uni17C9=0@-32,-29+0|\
         uni17B8=0@-32,237+0|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni1794=6+635"
    );
}

#[test]
fn khmer_mark_order_007() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17C9}\u{17B8}\u{17C1}\u{17BB}\u{17BB}\u{1794}",
            "",
        ),
        "uni179F=0+928|\
         uni17C9=0@-32,-29+0|\
         uni17B8=0@-32,237+0|\
         uni17C1=0+288|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni1794=6+635"
    );
}

#[test]
fn khmer_mark_order_008() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17CA}\u{17BE}\u{17BB}\u{1794}",
            "",
        ),
        "uni17C1=0+288|\
         uni179F=0+928|\
         uni17BB=0@-6,-26+0|\
         uni17B8=0@-32,-29+0|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni1794=4+635"
    );
}

#[test]
fn khmer_mark_order_009() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17CA}\u{17C1}\u{17B8}\u{17BB}\u{1794}",
            "",
        ),
        "uni17C1=0+288|\
         uni179F=0+928|\
         uni17BB=0@-6,-26+0|\
         uni17B8=0@-32,-29+0|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni1794=5+635"
    );
}

#[test]
fn khmer_mark_order_010() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17CA}\u{17B8}\u{17C1}\u{17BB}\u{1794}",
            "",
        ),
        "uni179F=0+928|\
         uni17BB=0@-6,-26+0|\
         uni17B8=0@-32,-29+0|\
         uni17C1=0+288|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni1794=5+635"
    );
}

#[test]
fn khmer_mark_order_011() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17CA}\u{17BE}\u{17BB}\u{17BB}\u{1794}",
            "",
        ),
        "uni17C1=0+288|\
         uni179F=0+928|\
         uni17BB=0@-6,-26+0|\
         uni17B8=0@-32,-29+0|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni1794=5+635"
    );
}

#[test]
fn khmer_mark_order_012() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17CA}\u{17C1}\u{17B8}\u{17BB}\u{17BB}\u{1794}",
            "",
        ),
        "uni17C1=0+288|\
         uni179F=0+928|\
         uni17BB=0@-6,-26+0|\
         uni17B8=0@-32,-29+0|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni1794=6+635"
    );
}

#[test]
fn khmer_mark_order_013() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17CA}\u{17B8}\u{17C1}\u{17BB}\u{17BB}\u{1794}",
            "",
        ),
        "uni179F=0+928|\
         uni17BB=0@-6,-26+0|\
         uni17B8=0@-32,-29+0|\
         uni17C1=0+288|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni1794=6+635"
    );
}

#[test]
fn khmer_mark_order_014() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17C9}\u{17BE}\u{17B8}\u{1794}",
            "",
        ),
        "uni17C1=0+288|\
         uni179F=0+928|\
         uni17C9=0@-32,-29+0|\
         uni17B8=0@-32,237+0|\
         uni25CC=0+635|\
         uni17B8=0@-20,-84+0|\
         uni1794=4+635"
    );
}

#[test]
fn khmer_mark_order_015() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17C9}\u{17B8}\u{17BE}\u{1794}",
            "",
        ),
        "uni179F=0+928|\
         uni17C9=0@-32,-29+0|\
         uni17B8=0@-32,237+0|\
         uni17C1=0+288|\
         uni25CC=0+635|\
         uni17B8=0@-20,-84+0|\
         uni1794=4+635"
    );
}

#[test]
fn khmer_mark_order_016() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17C9}\u{17BE}\u{17B8}\u{17BB}\u{1794}",
            "",
        ),
        "uni17C1=0+288|\
         uni179F=0+928|\
         uni17C9=0@-32,-29+0|\
         uni17B8=0@-32,237+0|\
         uni25CC=0+635|\
         uni17B8=0@-20,-84+0|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni1794=5+635"
    );
}

#[test]
fn khmer_mark_order_017() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17C9}\u{17B8}\u{17BE}\u{17BB}\u{1794}",
            "",
        ),
        "uni179F=0+928|\
         uni17C9=0@-32,-29+0|\
         uni17B8=0@-32,237+0|\
         uni17C1=0+288|\
         uni25CC=0+635|\
         uni17B8=0@-20,-84+0|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni1794=5+635"
    );
}

#[test]
fn khmer_mark_order_018() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17CA}\u{17BE}\u{17B8}\u{1794}",
            "",
        ),
        "uni17C1=0+288|\
         uni179F=0+928|\
         uni17BB=0@-6,-26+0|\
         uni17B8=0@-32,-29+0|\
         uni25CC=0+635|\
         uni17B8=0@-20,-84+0|\
         uni1794=4+635"
    );
}

#[test]
fn khmer_mark_order_019() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17CA}\u{17B8}\u{17BE}\u{1794}",
            "",
        ),
        "uni179F=0+928|\
         uni17BB=0@-6,-26+0|\
         uni17B8=0@-32,-29+0|\
         uni17C1=0+288|\
         uni25CC=0+635|\
         uni17B8=0@-20,-84+0|\
         uni1794=4+635"
    );
}

#[test]
fn khmer_mark_order_020() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17CA}\u{17BE}\u{17B8}\u{17BB}\u{1794}",
            "",
        ),
        "uni17C1=0+288|\
         uni179F=0+928|\
         uni17BB=0@-6,-26+0|\
         uni17B8=0@-32,-29+0|\
         uni25CC=0+635|\
         uni17B8=0@-20,-84+0|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni1794=5+635"
    );
}

#[test]
fn khmer_mark_order_021() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17CA}\u{17B8}\u{17BE}\u{17BB}\u{1794}",
            "",
        ),
        "uni179F=0+928|\
         uni17BB=0@-6,-26+0|\
         uni17B8=0@-32,-29+0|\
         uni17C1=0+288|\
         uni25CC=0+635|\
         uni17B8=0@-20,-84+0|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni1794=5+635"
    );
}

#[test]
fn khmer_mark_order_022() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17BE}\u{17B8}\u{17BB}\u{1794}",
            "",
        ),
        "uni17C1=0+288|\
         uni179F=0+928|\
         uni17B8=0@-32,-29+0|\
         uni25CC=0+635|\
         uni17B8=0@-20,-84+0|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni1794=4+635"
    );
}

#[test]
fn khmer_mark_order_023() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17BE}\u{17BB}\u{17B8}\u{1794}",
            "",
        ),
        "uni17C1=0+288|\
         uni179F=0+928|\
         uni17B8=0@-32,-29+0|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni17B8=0@-20,-84+0|\
         uni1794=4+635"
    );
}

#[test]
fn khmer_mark_order_024() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17B8}\u{17BE}\u{17BB}\u{1794}",
            "",
        ),
        "uni179F=0+928|\
         uni17B8=0@-32,-29+0|\
         uni17C1=0+288|\
         uni25CC=0+635|\
         uni17B8=0@-20,-84+0|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni1794=4+635"
    );
}

#[test]
fn khmer_mark_order_025() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/b6031119874ae9ff1dd65383a335e361c0962220.ttf",
            "\u{179F}\u{17B8}\u{17BB}\u{17BE}\u{1794}",
            "",
        ),
        "uni179F=0+928|\
         uni17B8=0@-32,-29+0|\
         uni25CC=0+635|\
         uni17BB=0@-20,-26+0|\
         uni17C1=0+288|\
         uni25CC=0+635|\
         uni17B8=0@-20,-84+0|\
         uni1794=4+635"
    );
}

#[test]
fn khmer_misc_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1781}\u{17D2}\u{1798}\u{17C2}",
            "",
        ),
        "uni17C2=0+288|\
         uni1781=0+635|\
         uni17D21798=0@22,-26+0"
    );
}

#[test]
fn khmer_misc_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1787}\u{17B6}",
            "",
        ),
        "uni178717B6=0+923"
    );
}

#[test]
fn khmer_misc_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1790}\u{17D2}\u{1784}\u{17C3}",
            "",
        ),
        "uni17C3=0+288|\
         uni1790=0+635|\
         uni17D21784=0@-1,-26+0"
    );
}

#[test]
fn khmer_misc_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1798}\u{17B6}",
            "",
        ),
        "uni179817B6=0+923"
    );
}

#[test]
fn khmer_misc_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1798}\u{17D2}\u{1796}\u{17BB}",
            "",
        ),
        "uni1798=0+635|\
         uni17D21796=0@-1,-26+0|\
         uni17BB=0@-22,-296+0"
    );
}

#[test]
fn khmer_misc_006() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179A}",
            "",
        ),
        "uni179A=0+288"
    );
}

#[test]
fn khmer_misc_007() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179A}\u{17B8}",
            "",
        ),
        "uni179A=0+288|\
         uni17B8.r=0@76,-29+0"
    );
}

#[test]
fn khmer_misc_008() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179A}\u{17CD}",
            "",
        ),
        "uni179A=0+288|\
         uni17CD.r=0@18,-29+0"
    );
}

#[test]
fn khmer_misc_009() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179F}\u{17C5}",
            "",
        ),
        "uni17C1=0+288|\
         uni179F17C5=0+1216"
    );
}

#[test]
fn khmer_misc_010() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179A}\u{17D2}\u{17A5}",
            "",
        ),
        "uni179A=0+288|\
         uni17D2=0+0|\
         uni17A5=2+635"
    );
}

#[test]
fn khmer_misc_011() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1784}\u{17B9}\u{17D2}\u{1788}",
            "",
        ),
        "uni1784=0+635|\
         uni17B9=0@-46,30+0|\
         uni17D21788=0+234"
    );
}

#[test]
fn khmer_misc_012() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1784}\u{17D2}\u{1788}\u{17B9}",
            "",
        ),
        "uni1784=0+635|\
         uni17D21788=0+234|\
         uni17B9=0@8,30+0"
    );
}

#[test]
fn khmer_misc_013() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1784}\u{17D2}\u{1782}\u{17D2}\u{179A}",
            "",
        ),
        "uni17D2179A.low=0+287|\
         uni1784=0+635|\
         uni17D21782=0@0,-26+0"
    );
}

#[test]
fn khmer_misc_014() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1784}\u{17D2}\u{179A}\u{17D2}\u{1782}",
            "",
        ),
        "uni17D2179A.low=0+287|\
         uni1784=0+635|\
         uni17D21782=0@0,-26+0"
    );
}

#[test]
fn khmer_misc_015() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1798}\u{17C9}\u{17D2}\u{179B}\u{17C1}\u{17C7}",
            "",
        ),
        "uni17C1=0+288|\
         uni1798=0+635|\
         uni17C9=0@-46,-29+0|\
         uni17D2179B=0@-1,-26+0|\
         uni17C7=0+386"
    );
}

#[test]
fn khmer_misc_016() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1798}\u{200C}\u{17C9}\u{17D2}\u{179B}\u{17C1}\u{17C7}",
            "",
        ),
        "uni17C1=0+288|\
         uni1798=0+635|\
         space=0+0|\
         uni17C9=0@-46,-29+0|\
         uni17D2179B=0@-1,-26+0|\
         uni17C7=0+386"
    );
}

#[test]
fn khmer_misc_017() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1794}\u{17CA}\u{17D0}",
            "",
        ),
        "uni1794=0+635|\
         uni17CA=0@-46,-29+0|\
         uni17D0=0@-46,113+0"
    );
}

#[test]
fn khmer_misc_018() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1793}\u{17C2}\u{17CE}",
            "",
        ),
        "uni17C2=0+288|\
         uni1793=0+635|\
         uni17CE=0@-36,-29+0"
    );
}

#[test]
fn khmer_misc_019() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1780}\u{17C1}\u{17D2}\u{179A}",
            "",
        ),
        "uni17D2179A=0+287|\
         uni17C1=0+288|\
         uni1780=0+636"
    );
}

#[test]
fn khmer_misc_020() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1780}\u{17C0}\u{17D2}\u{179A}",
            "",
        ),
        "uni17D2179A=0+287|\
         uni17C1=0+288|\
         uni1780=0+636|\
         uni17C0.right1=0+288"
    );
}

#[test]
fn khmer_misc_021() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1780}\u{17C4}\u{17D2}\u{179A}",
            "",
        ),
        "uni17D2179A=0+287|\
         uni17C1=0+288|\
         uni178017B6=0+924"
    );
}

#[test]
fn khmer_misc_022() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1780}\u{17C5}\u{17D2}\u{179A}",
            "",
        ),
        "uni17D2179A=0+287|\
         uni17C1=0+288|\
         uni178017C5=0+924"
    );
}

#[test]
fn khmer_misc_023() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1796}\u{17D1}\u{17B6}",
            "",
        ),
        "uni179617B6=0+923|\
         uni17D1=0@-311,-19+0"
    );
}

#[test]
fn khmer_misc_024() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1780}\u{1793}\u{17D2}\u{178F}\u{17D2}\u{179A}\u{17B6}\u{1780}\u{17CB}",
            "",
        ),
        "uni1780=0+636|\
         uni17D2179A.low=1+287|\
         uni179317B6=1+924|\
         uni17D2178F=1@-290,-26+0|\
         uni1780=7+636|\
         uni17CB=7@-23,-29+0"
    );
}

#[test]
fn khmer_misc_025() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1780}\u{1793}\u{17D2}\u{179A}\u{17D2}\u{179F}\u{17B7}\u{1780}\u{17CB}",
            "",
        ),
        "uni1780=0+636|\
         uni17D2179A=1+287|\
         uni1793=1+635|\
         uni17D2179F=1+302|\
         uni17B7=1@-4,30+0|\
         uni1780=7+636|\
         uni17CB=7@-23,-29+0"
    );
}

#[test]
fn khmer_misc_026() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1780}\u{1793}\u{17D2}\u{179A}\u{17D2}\u{179F}\u{17B8}\u{1780}\u{17CB}",
            "",
        ),
        "uni1780=0+636|\
         uni17D2179A=1+287|\
         uni1793=1+635|\
         uni17D2179F=1+302|\
         uni17B8=1@-4,30+0|\
         uni1780=7+636|\
         uni17CB=7@-23,-29+0"
    );
}

#[test]
fn khmer_misc_027() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1780}\u{17D2}\u{179F}\u{17B6}\u{1793}\u{17D2}\u{178F}",
            "",
        ),
        "uni1780=0+636|\
         uni17D2179F17B6=0+584|\
         uni1793=4+635|\
         uni17D2178F=4@-1,-26+0"
    );
}

#[test]
fn khmer_misc_028() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1780}\u{17D2}\u{179F}\u{17B7}\u{1793}\u{17D2}\u{178F}",
            "",
        ),
        "uni1780=0+636|\
         uni17D2179F=0+302|\
         uni17B7=0@-4,30+0|\
         uni1793=4+635|\
         uni17D2178F=4@-1,-26+0"
    );
}

#[test]
fn khmer_misc_029() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1780}\u{17D2}\u{179F}\u{17B8}\u{1793}\u{17D2}\u{178F}",
            "",
        ),
        "uni1780=0+636|\
         uni17D2179F=0+302|\
         uni17B8=0@-4,30+0|\
         uni1793=4+635|\
         uni17D2178F=4@-1,-26+0"
    );
}

#[test]
fn khmer_misc_030() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1780}\u{17D2}\u{179F}\u{17B9}\u{1793}\u{17D2}\u{178F}",
            "",
        ),
        "uni1780=0+636|\
         uni17D2179F=0+302|\
         uni17B9=0@-4,30+0|\
         uni1793=4+635|\
         uni17D2178F=4@-1,-26+0"
    );
}

#[test]
fn khmer_misc_031() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1780}\u{17D2}\u{179F}\u{17BA}\u{1793}\u{17D2}\u{178F}",
            "",
        ),
        "uni1780=0+636|\
         uni17D2179F=0+302|\
         uni17BA=0@-4,30+0|\
         uni1793=4+635|\
         uni17D2178F=4@-1,-26+0"
    );
}

#[test]
fn khmer_misc_032() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1780}\u{17D2}\u{179F}\u{17BB}\u{1793}\u{17D2}\u{178F}",
            "",
        ),
        "uni1780=0+636|\
         uni17D2179F=0+302|\
         uni17BB=0@1,-260+0|\
         uni1793=4+635|\
         uni17D2178F=4@-1,-26+0"
    );
}

#[test]
fn khmer_misc_033() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1780}\u{17D2}\u{179F}\u{17BC}\u{1793}\u{17D2}\u{178F}",
            "",
        ),
        "uni1780=0+636|\
         uni17D2179F=0+302|\
         uni17BC=0@1,-260+0|\
         uni1793=4+635|\
         uni17D2178F=4@-1,-26+0"
    );
}

#[test]
fn khmer_misc_034() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1780}\u{17D2}\u{179F}\u{17BD}\u{1793}\u{17D2}\u{178F}",
            "",
        ),
        "uni1780=0+636|\
         uni17D2179F=0+302|\
         uni17BD=0@1,-260+0|\
         uni1793=4+635|\
         uni17D2178F=4@-1,-26+0"
    );
}

#[test]
fn khmer_misc_035() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1780}\u{17D2}\u{179F}\u{17BF}\u{1793}\u{17D2}\u{178F}",
            "",
        ),
        "uni17C1=0+288|\
         uni1780=0+636|\
         uni17D2179F=0+302|\
         uni17BF.right2=0+288|\
         uni1793=4+635|\
         uni17D2178F=4@-1,-26+0"
    );
}

#[test]
fn khmer_misc_036() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1783}\u{17D2}\u{179B}\u{17D2}\u{179F}\u{17B6}\u{17C6}",
            "",
        ),
        "uni1783=0+928|\
         uni17D2179B=0@15,-26+0|\
         uni17D2179F17B6.low=0+584|\
         uni17C6=0@39,-29+0"
    );
}

#[test]
fn khmer_misc_037() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1783}\u{17D2}\u{179B}\u{17D2}\u{179F}\u{17B7}\u{17C7}",
            "",
        ),
        "uni1783=0+928|\
         uni17D2179B=0@15,-26+0|\
         uni17D2179F.low=0+302|\
         uni17B7=0@-4,30+0|\
         uni17C7=0+386"
    );
}

#[test]
fn khmer_misc_038() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1783}\u{17D2}\u{179B}\u{17D2}\u{179F}\u{17BB}\u{17C6}",
            "",
        ),
        "uni1783=0+928|\
         uni17D2179B=0@15,-26+0|\
         uni17D2179F.low=0+302|\
         uni17BB=0+0|\
         uni17C6=0@-4,30+0"
    );
}

#[test]
fn khmer_misc_039() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1783}\u{17D2}\u{179B}\u{17D2}\u{179F}\u{17BB}\u{17C7}",
            "",
        ),
        "uni1783=0+928|\
         uni17D2179B=0@15,-26+0|\
         uni17D2179F.low=0+302|\
         uni17BB=0+0|\
         uni17C7=0+386"
    );
}

#[test]
fn khmer_misc_040() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1783}\u{17D2}\u{179B}\u{17D2}\u{179F}\u{17C1}\u{17C7}",
            "",
        ),
        "uni17C1=0+288|\
         uni1783=0+928|\
         uni17D2179B=0@15,-26+0|\
         uni17D2179F.low=0+302|\
         uni17C7=0+386"
    );
}

#[test]
fn khmer_misc_041() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1783}\u{17D2}\u{179B}\u{17D2}\u{179F}\u{17C4}\u{17C7}",
            "",
        ),
        "uni17C1=0+288|\
         uni1783=0+928|\
         uni17D2179B=0@15,-26+0|\
         uni17D2179F17B6.low=0+584|\
         uni17C7=0+386"
    );
}

#[test]
fn khmer_misc_042() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1783}\u{17D2}\u{179B}\u{17D2}\u{179F}\u{17C6}",
            "",
        ),
        "uni1783=0+928|\
         uni17D2179B=0@15,-26+0|\
         uni17D2179F.low=0+302|\
         uni17C6=0@-4,30+0"
    );
}

#[test]
fn khmer_misc_043() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1783}\u{17D2}\u{179B}\u{17D2}\u{179F}\u{17C7}",
            "",
        ),
        "uni1783=0+928|\
         uni17D2179B=0@15,-26+0|\
         uni17D2179F.low=0+302|\
         uni17C7=0+386"
    );
}

#[test]
fn khmer_misc_044() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1789}\u{17BC}",
            "",
        ),
        "uni1789=0+952|\
         uni17BC=0@-173,-260+0"
    );
}

#[test]
fn khmer_misc_045() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1789}\u{17D2}\u{1789}",
            "",
        ),
        "uni1789.a=0+952|\
         uni17D21789.a=0@19,-22+0"
    );
}

#[test]
fn khmer_misc_046() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1789}\u{17D2}\u{1789}\u{17BB}",
            "",
        ),
        "uni1789.a=0+952|\
         uni17D21789.a=0@19,-22+0|\
         uni17BB=0@-160,-296+0"
    );
}

#[test]
fn khmer_misc_047() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1789}\u{17D2}\u{1789}\u{17BC}",
            "",
        ),
        "uni1789.a=0+952|\
         uni17D21789.a=0@19,-22+0|\
         uni17BC=0@-160,-296+0"
    );
}

#[test]
fn khmer_misc_048() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1789}\u{17D2}\u{1789}\u{17BD}",
            "",
        ),
        "uni1789.a=0+952|\
         uni17D21789.a=0@19,-22+0|\
         uni17BD=0@-160,-296+0"
    );
}

#[test]
fn khmer_misc_049() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{178F}\u{17D2}\u{179A}\u{17D2}\u{179F}\u{17C0}",
            "",
        ),
        "uni17C1=0+288|\
         uni17D2179A=0+287|\
         uni178F=0+635|\
         uni17D2179F=0+302|\
         uni17C0.right2=0+288"
    );
}

#[test]
fn khmer_misc_050() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{178F}\u{17D2}\u{179A}\u{17D2}\u{179F}\u{17C1}",
            "",
        ),
        "uni17C1=0+288|\
         uni17D2179A=0+287|\
         uni178F=0+635|\
         uni17D2179F=0+302"
    );
}

#[test]
fn khmer_misc_051() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{178F}\u{17D2}\u{179A}\u{17D2}\u{179F}\u{17C2}",
            "",
        ),
        "uni17C2=0+288|\
         uni17D2179A=0+287|\
         uni178F=0+635|\
         uni17D2179F=0+302"
    );
}

#[test]
fn khmer_misc_052() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{178F}\u{17D2}\u{179A}\u{17D2}\u{179F}\u{17C3}",
            "",
        ),
        "uni17C3=0+288|\
         uni17D2179A=0+287|\
         uni178F=0+635|\
         uni17D2179F=0+302"
    );
}

#[test]
fn khmer_misc_053() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{178F}\u{17D2}\u{179A}\u{17D2}\u{179F}\u{17C4}",
            "",
        ),
        "uni17C1=0+288|\
         uni17D2179A=0+287|\
         uni178F=0+635|\
         uni17D2179F17B6=0+584"
    );
}

#[test]
fn khmer_misc_054() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{178F}\u{17D2}\u{179A}\u{17D2}\u{179F}\u{17C5}",
            "",
        ),
        "uni17C1=0+288|\
         uni17D2179A=0+287|\
         uni178F=0+635|\
         uni17D2179F17C5=0+584"
    );
}

#[test]
fn khmer_misc_055() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1792}\u{17D2}\u{179B}\u{17BB}\u{17C6}\u{1780}\u{17CB}",
            "",
        ),
        "uni1792=0+635|\
         uni17D2179B=0@-2,-26+0|\
         uni17BB=0@-19,-296+0|\
         uni17C6=0@-46,-29+0|\
         uni1780=5+636|\
         uni17CB=5@-23,-29+0"
    );
}

#[test]
fn khmer_misc_056() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1792}\u{17D2}\u{179B}\u{17C4}\u{1780}\u{17CB}",
            "",
        ),
        "uni17C1=0+288|\
         uni179217B6=0+923|\
         uni17D2179B=0@-290,-26+0|\
         uni1780=4+636|\
         uni17CB=4@-23,-29+0"
    );
}

#[test]
fn khmer_misc_057() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1792}\u{17D2}\u{179B}\u{17C5}\u{1780}\u{17CB}",
            "",
        ),
        "uni17C1=0+288|\
         uni179217C5=0+923|\
         uni17D2179B=0@-290,-26+0|\
         uni1780=4+636|\
         uni17CB=4@-23,-29+0"
    );
}

#[test]
fn khmer_misc_058() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1792}\u{17D2}\u{179B}\u{17C6}\u{1780}\u{17CB}",
            "",
        ),
        "uni1792=0+635|\
         uni17D2179B=0@-2,-26+0|\
         uni17C6=0@-46,-29+0|\
         uni1780=4+636|\
         uni17CB=4@-23,-29+0"
    );
}

#[test]
fn khmer_misc_059() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1798}\u{17D2}\u{178F}\u{17D2}\u{179B}\u{17C9}\u{17B6}",
            "",
        ),
        "uni179817B6=0+923|\
         uni17D2178F=0@-289,-26+0|\
         uni17D2179B=0@-289,-296+0|\
         uni17C9=0@-334,-29+0"
    );
}

#[test]
fn khmer_misc_060() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1798}\u{17D2}\u{178F}\u{17D2}\u{179B}\u{17C9}\u{17BB}",
            "",
        ),
        "uni1798=0+635|\
         uni17D2178F=0@-1,-26+0|\
         uni17D2179B=0@-1,-296+0|\
         uni17C9=0@-46,-29+0|\
         uni17BB=0@-18,-566+0"
    );
}

#[test]
fn khmer_misc_061() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1798}\u{17D2}\u{178F}\u{17D2}\u{179B}\u{17C9}\u{17BF}",
            "",
        ),
        "uni17C1=0+288|\
         uni1798=0+635|\
         uni17D2178F=0@-1,-26+0|\
         uni17D2179B=0@-1,-296+0|\
         uni17C9=0@-46,-29+0|\
         uni17BF.right1=0+288"
    );
}

#[test]
fn khmer_misc_062() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1798}\u{17D2}\u{178F}\u{17D2}\u{179B}\u{17C9}\u{17C0}",
            "",
        ),
        "uni17C1=0+288|\
         uni1798=0+635|\
         uni17D2178F=0@-1,-26+0|\
         uni17D2179B=0@-1,-296+0|\
         uni17C9=0@-46,-29+0|\
         uni17C0.right1=0+288"
    );
}

#[test]
fn khmer_misc_063() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{1799}\u{17D2}\u{1799}\u{17BE}\u{17A0}\u{17D2}\u{179C}\u{17D2}\u{179B}\u{17C3}",
            "",
        ),
        "uni17C1=0+288|\
         uni1799=0+953|\
         uni17D21799=0+298|\
         uni17B8=0@1,30+0|\
         uni17C3=4+288|\
         uni17A0=4+928|\
         uni17D2179C=4@20,-26+0|\
         uni17D2179B=4@19,-296+0"
    );
}

#[test]
fn khmer_misc_064() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179A}\u{17D2}\u{179A}",
            "",
        ),
        "uni17D2179A=0+287|\
         uni179A=0+288"
    );
}

#[test]
fn khmer_misc_065() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179F}\u{17B6}\u{179F}\u{17D2}\u{178F}\u{17D2}\u{179A}\u{1783}\u{17D2}\u{1788}\
             \u{1784}\u{17B6}",
            "",
        ),
        "uni179F17B6=0+1216|\
         uni17D2179A=2+287|\
         uni179F=2+928|\
         uni17D2178F=2@14,-26+0|\
         uni1783=7+928|\
         uni17D21788=7+234|\
         uni178417B6=10+923"
    );
}

#[test]
fn khmer_misc_066() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179F}\u{17B6}\u{179F}\u{17D2}\u{178F}\u{17D2}\u{179A}\u{1783}\u{17D2}\u{1788}\
             \u{1784}\u{17B7}",
            "",
        ),
        "uni179F17B6=0+1216|\
         uni17D2179A=2+287|\
         uni179F=2+928|\
         uni17D2178F=2@14,-26+0|\
         uni1783=7+928|\
         uni17D21788=7+234|\
         uni1784=10+635|\
         uni17B7=10@-46,30+0"
    );
}

#[test]
fn khmer_misc_067() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179F}\u{17B6}\u{179F}\u{17D2}\u{178F}\u{17D2}\u{179A}\u{1783}\u{17D2}\u{1788}\
             \u{1784}\u{17B8}",
            "",
        ),
        "uni179F17B6=0+1216|\
         uni17D2179A=2+287|\
         uni179F=2+928|\
         uni17D2178F=2@14,-26+0|\
         uni1783=7+928|\
         uni17D21788=7+234|\
         uni1784=10+635|\
         uni17B8=10@-46,30+0"
    );
}

#[test]
fn khmer_misc_068() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179F}\u{17D2}\u{178F}\u{17D2}\u{179A}\u{17B8}\u{179C}\u{17D0}\u{1781}\u{17D2}\
             \u{1789}\u{17D2}\u{179F}\u{17B6}",
            "",
        ),
        "uni17D2179A=0+287|\
         uni179F=0+928|\
         uni17D2178F=0@14,-26+0|\
         uni17B8=0@-32,-29+0|\
         uni179C=6+326|\
         uni17D0=6@139,40+0|\
         uni1781=8+635|\
         uni17D21789=8@-4,-26+0|\
         uni17D2179F17B6.low=8+584"
    );
}

#[test]
fn khmer_misc_069() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179F}\u{17D2}\u{179A}\u{17D2}\u{178F}\u{17B6}",
            "",
        ),
        "uni17D2179A=0+287|\
         uni179F17B6=0+1216|\
         uni17D2178F=0@-274,-26+0"
    );
}

#[test]
fn khmer_misc_070() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179F}\u{17D2}\u{179A}\u{17D2}\u{178F}\u{17B7}",
            "",
        ),
        "uni17D2179A=0+287|\
         uni179F=0+928|\
         uni17D2178F=0@14,-26+0|\
         uni17B7=0@-32,-29+0"
    );
}

#[test]
fn khmer_misc_071() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179F}\u{17D2}\u{179A}\u{17D2}\u{178F}\u{17B8}",
            "",
        ),
        "uni17D2179A=0+287|\
         uni179F=0+928|\
         uni17D2178F=0@14,-26+0|\
         uni17B8=0@-32,-29+0"
    );
}

#[test]
fn khmer_misc_072() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179F}\u{17D2}\u{179A}\u{17D2}\u{178F}\u{17B9}",
            "",
        ),
        "uni17D2179A=0+287|\
         uni179F=0+928|\
         uni17D2178F=0@14,-26+0|\
         uni17B9=0@-32,-29+0"
    );
}

#[test]
fn khmer_misc_073() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179F}\u{17D2}\u{179A}\u{17D2}\u{178F}\u{17BA}",
            "",
        ),
        "uni17D2179A=0+287|\
         uni179F=0+928|\
         uni17D2178F=0@14,-26+0|\
         uni17BA=0@-32,-29+0"
    );
}

#[test]
fn khmer_misc_074() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179F}\u{17D2}\u{179A}\u{17D2}\u{178F}\u{17BB}",
            "",
        ),
        "uni17D2179A=0+287|\
         uni179F=0+928|\
         uni17D2178F=0@14,-26+0|\
         uni17BB=0@-6,-296+0"
    );
}

#[test]
fn khmer_misc_075() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179F}\u{17D2}\u{179A}\u{17D2}\u{178F}\u{17BC}",
            "",
        ),
        "uni17D2179A=0+287|\
         uni179F=0+928|\
         uni17D2178F=0@14,-26+0|\
         uni17BC=0@-6,-296+0"
    );
}

#[test]
fn khmer_misc_076() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179F}\u{17D2}\u{179A}\u{17D2}\u{178F}\u{17BD}",
            "",
        ),
        "uni17D2179A=0+287|\
         uni179F=0+928|\
         uni17D2178F=0@14,-26+0|\
         uni17BD=0@-6,-296+0"
    );
}

#[test]
fn khmer_misc_077() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179F}\u{17D2}\u{179A}\u{17D2}\u{178F}\u{17BE}",
            "",
        ),
        "uni17C1=0+288|\
         uni17D2179A=0+287|\
         uni179F=0+928|\
         uni17D2178F=0@14,-26+0|\
         uni17B8=0@-32,-29+0"
    );
}

#[test]
fn khmer_misc_078() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179F}\u{17D2}\u{179A}\u{17D2}\u{178F}\u{17BF}",
            "",
        ),
        "uni17C1=0+288|\
         uni17D2179A=0+287|\
         uni179F=0+928|\
         uni17D2178F=0@14,-26+0|\
         uni17BF.right2=0+288"
    );
}

#[test]
fn khmer_misc_079() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179F}\u{17D2}\u{179A}\u{17D2}\u{178F}\u{17CA}\u{17BF}",
            "",
        ),
        "uni17C1=0+288|\
         uni17D2179A=0+287|\
         uni179F=0+928|\
         uni17D2178F=0@14,-26+0|\
         uni17CA=0@-32,-29+0|\
         uni17BF.right1=0+288"
    );
}

#[test]
fn khmer_misc_080() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179F}\u{17D2}\u{179A}\u{17D2}\u{178F}\u{17CA}\u{17C0}",
            "",
        ),
        "uni17C1=0+288|\
         uni17D2179A=0+287|\
         uni179F=0+928|\
         uni17D2178F=0@14,-26+0|\
         uni17CA=0@-32,-29+0|\
         uni17C0.right1.high=0+288"
    );
}

#[test]
fn khmer_misc_081() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179F}\u{17D2}\u{179A}\u{17D2}\u{178F}\u{17CA}\u{17C1}",
            "",
        ),
        "uni17C1=0+288|\
         uni17D2179A=0+287|\
         uni179F=0+928|\
         uni17D2178F=0@14,-26+0|\
         uni17CA=0@-32,-29+0"
    );
}

#[test]
fn khmer_misc_082() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179F}\u{17D2}\u{179A}\u{17D2}\u{178F}\u{17CA}\u{17C2}",
            "",
        ),
        "uni17C2=0+288|\
         uni17D2179A=0+287|\
         uni179F=0+928|\
         uni17D2178F=0@14,-26+0|\
         uni17CA=0@-32,-29+0"
    );
}

#[test]
fn khmer_misc_083() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179F}\u{17D2}\u{179A}\u{17D2}\u{178F}\u{17CA}\u{17C3}",
            "",
        ),
        "uni17C3=0+288|\
         uni17D2179A=0+287|\
         uni179F=0+928|\
         uni17D2178F=0@14,-26+0|\
         uni17CA=0@-32,-29+0"
    );
}

#[test]
fn khmer_misc_084() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{179F}\u{17D2}\u{179A}\u{17D2}\u{178F}\u{17CA}\u{17C6}",
            "",
        ),
        "uni17D2179A=0+287|\
         uni179F=0+928|\
         uni17D2178F=0@14,-26+0|\
         uni17CA=0@-32,-29+0|\
         uni17C6=0@-32,113+0"
    );
}

#[test]
fn khmer_misc_085() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{17A0}\u{17D2}\u{1782}\u{17D2}\u{179F}\u{17CA}\u{17BE}",
            "",
        ),
        "uni17C1=0+288|\
         uni17A0=0+928|\
         uni17D21782=0@20,-26+0|\
         uni17D2179F.low=0+302|\
         uni17BB=0+0|\
         uni17B8=0@-4,30+0"
    );
}

#[test]
fn khmer_misc_086() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{17A0}\u{17D2}\u{1782}\u{17D2}\u{179F}\u{17CA}\u{17BF}",
            "",
        ),
        "uni17C1=0+288|\
         uni17A0=0+928|\
         uni17D21782=0@20,-26+0|\
         uni17D2179F.low=0+302|\
         uni17CA=0@-4,30+0|\
         uni17BF.right1=0+288"
    );
}

#[test]
fn khmer_misc_087() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{17A0}\u{17D2}\u{1782}\u{17D2}\u{179F}\u{17CA}\u{17C0}",
            "",
        ),
        "uni17C1=0+288|\
         uni17A0=0+928|\
         uni17D21782=0@20,-26+0|\
         uni17D2179F.low=0+302|\
         uni17CA=0@-4,30+0|\
         uni17C0.right1.high=0+288"
    );
}

#[test]
fn khmer_misc_088() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{17A0}\u{17D2}\u{179A}\u{17D2}\u{179C}\u{1784}\u{17D2}\u{1780}",
            "",
        ),
        "uni17D2179A=0+287|\
         uni17A0=0+928|\
         uni17D2179C=0@20,-26+0|\
         uni1784=5+635|\
         uni17D21780=5@0,-26+0"
    );
}

#[test]
fn khmer_misc_089() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3998336402905b8be8301ef7f47cf7e050cbb1bd.ttf",
            "\u{17A0}\u{17D2}\u{179A}\u{17D2}\u{179C}\u{17B6}\u{17C6}\u{1784}",
            "",
        ),
        "uni17D2179A=0+287|\
         uni17A017B6=0+1216|\
         uni17D2179C=0@-268,-26+0|\
         uni17C6=0@47,-29+0|\
         uni1784=7+635"
    );
}

#[test]
fn khmer_misc_090() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/ad01ab2ea1cb1a4d3a2783e2675112ef11ae6404.ttf",
            "\u{17D2}\u{17D2}",
            "",
        ),
        "uni25CC=0+635|\
         uni17D2=0+0|\
         uni25CC=0+635|\
         uni17D2=0+0"
    );
}

#[test]
fn language_tags_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/6991b13ce889466be6de3f66e891de2bc0f117ee.ttf",
            "\u{004A}",
            "--language=fa",
        ),
        "gid2=0+1000"
    );
}

#[test]
fn language_tags_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/6991b13ce889466be6de3f66e891de2bc0f117ee.ttf",
            "\u{004A}",
            "--language=ja",
        ),
        "gid2=0+1000"
    );
}

#[test]
fn language_tags_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/6991b13ce889466be6de3f66e891de2bc0f117ee.ttf",
            "\u{004A}",
            "--language=zh",
        ),
        "gid4=0+1000"
    );
}

#[test]
fn language_tags_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/6991b13ce889466be6de3f66e891de2bc0f117ee.ttf",
            "\u{004A}",
            "--language=zh-cn",
        ),
        "gid4=0+1000"
    );
}

#[test]
fn language_tags_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/6991b13ce889466be6de3f66e891de2bc0f117ee.ttf",
            "\u{004A}",
            "--language=zh-sg",
        ),
        "gid4=0+1000"
    );
}

#[test]
fn language_tags_006() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/6991b13ce889466be6de3f66e891de2bc0f117ee.ttf",
            "\u{004A}",
            "--language=zh-tw",
        ),
        "gid5=0+1000"
    );
}

#[test]
fn language_tags_007() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/6991b13ce889466be6de3f66e891de2bc0f117ee.ttf",
            "\u{004A}",
            "--language=zh-hans",
        ),
        "gid4=0+1000"
    );
}

#[test]
fn language_tags_008() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/6991b13ce889466be6de3f66e891de2bc0f117ee.ttf",
            "\u{004A}",
            "--language=zh-hant",
        ),
        "gid5=0+1000"
    );
}

#[test]
fn language_tags_009() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/6991b13ce889466be6de3f66e891de2bc0f117ee.ttf",
            "\u{004A}",
            "--language=zh-hant-hk",
        ),
        "gid6=0+1000"
    );
}

#[test]
fn language_tags_010() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/6991b13ce889466be6de3f66e891de2bc0f117ee.ttf",
            "\u{004A}",
            "--language=zh-HK",
        ),
        "gid6=0+1000"
    );
}

#[test]
fn language_tags_011() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/6991b13ce889466be6de3f66e891de2bc0f117ee.ttf",
            "\u{004A}",
            "--language=zh-mo",
        ),
        "gid6=0+1000"
    );
}

#[test]
fn language_tags_012() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/6991b13ce889466be6de3f66e891de2bc0f117ee.ttf",
            "\u{004A}",
            "--language=zh-Hant-mo",
        ),
        "gid6=0+1000"
    );
}

#[test]
fn language_tags_013() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d3129450fafe5e5c98cfc25a4e71809b1b4d2855.ttf",
            "\u{007C}",
            "--language=dv --no-glyph-names",
        ),
        "2=0+156"
    );
}

#[test]
fn ligature_id_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0020}\u{0995}\u{09CD}\u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         space=3+213|\
         u0995_u09B0_u09CD.blwf.vatu=4+643|\
         u0995_u09CD.half_u09B2.pres=7+602"
    );
}

#[test]
fn ligature_id_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0020}\u{0995}\u{09CD}\u{09B0}\
             \u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         space=6+213|\
         u0995_u09B0_u09CD.blwf.vatu=7+643|\
         u0995_u09CD.half_u09B2.pres=10+602"
    );
}

#[test]
fn ligature_id_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0020}\
             \u{0995}\u{09CD}\u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         space=9+213|\
         u0995_u09B0_u09CD.blwf.vatu=10+643|\
         u0995_u09CD.half_u09B2.pres=13+602"
    );
}

#[test]
fn ligature_id_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0020}\u{0995}\u{09CD}\u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         space=12+213|\
         u0995_u09B0_u09CD.blwf.vatu=13+643|\
         u0995_u09CD.half_u09B2.pres=16+602"
    );
}

#[test]
fn ligature_id_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0020}\u{0995}\u{09CD}\u{09B0}\u{0995}\
             \u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         space=15+213|\
         u0995_u09B0_u09CD.blwf.vatu=16+643|\
         u0995_u09CD.half_u09B2.pres=19+602"
    );
}

#[test]
fn ligature_id_006() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0020}\u{0995}\
             \u{09CD}\u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         space=18+213|\
         u0995_u09B0_u09CD.blwf.vatu=19+643|\
         u0995_u09CD.half_u09B2.pres=22+602"
    );
}

#[test]
fn ligature_id_007() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0020}\u{0995}\u{09CD}\u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         space=21+213|\
         u0995_u09B0_u09CD.blwf.vatu=22+643|\
         u0995_u09CD.half_u09B2.pres=25+602"
    );
}

#[test]
fn ligature_id_008() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0020}\u{0995}\u{09CD}\u{09B0}\u{0995}\u{09CD}\
             \u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         space=24+213|\
         u0995_u09B0_u09CD.blwf.vatu=25+643|\
         u0995_u09CD.half_u09B2.pres=28+602"
    );
}

#[test]
fn ligature_id_009() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0020}\u{0995}\u{09CD}\
             \u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         space=27+213|\
         u0995_u09B0_u09CD.blwf.vatu=28+643|\
         u0995_u09CD.half_u09B2.pres=31+602"
    );
}

#[test]
fn ligature_id_010() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0020}\u{0995}\u{09CD}\u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         space=30+213|\
         u0995_u09B0_u09CD.blwf.vatu=31+643|\
         u0995_u09CD.half_u09B2.pres=34+602"
    );
}

#[test]
fn ligature_id_011() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0020}\u{0995}\u{09CD}\u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         space=33+213|\
         u0995_u09B0_u09CD.blwf.vatu=34+643|\
         u0995_u09CD.half_u09B2.pres=37+602"
    );
}

#[test]
fn ligature_id_012() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0020}\u{0995}\u{09CD}\u{09B0}\
             \u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         space=36+213|\
         u0995_u09B0_u09CD.blwf.vatu=37+643|\
         u0995_u09CD.half_u09B2.pres=40+602"
    );
}

#[test]
fn ligature_id_013() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0020}\
             \u{0995}\u{09CD}\u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         space=39+213|\
         u0995_u09B0_u09CD.blwf.vatu=40+643|\
         u0995_u09CD.half_u09B2.pres=43+602"
    );
}

#[test]
fn ligature_id_014() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0020}\u{0995}\u{09CD}\u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         u0995_u09CD.half_u0995.pres=39+566|\
         space=42+213|\
         u0995_u09B0_u09CD.blwf.vatu=43+643|\
         u0995_u09CD.half_u09B2.pres=46+602"
    );
}

#[test]
fn ligature_id_015() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0020}\u{0995}\u{09CD}\u{09B0}\u{0995}\
             \u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         u0995_u09CD.half_u0995.pres=39+566|\
         u0995_u09CD.half_u0995.pres=42+566|\
         space=45+213|\
         u0995_u09B0_u09CD.blwf.vatu=46+643|\
         u0995_u09CD.half_u09B2.pres=49+602"
    );
}

#[test]
fn ligature_id_016() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0020}\u{0995}\
             \u{09CD}\u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         u0995_u09CD.half_u0995.pres=39+566|\
         u0995_u09CD.half_u0995.pres=42+566|\
         u0995_u09CD.half_u0995.pres=45+566|\
         space=48+213|\
         u0995_u09B0_u09CD.blwf.vatu=49+643|\
         u0995_u09CD.half_u09B2.pres=52+602"
    );
}

#[test]
fn ligature_id_017() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0020}\u{0995}\u{09CD}\u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         u0995_u09CD.half_u0995.pres=39+566|\
         u0995_u09CD.half_u0995.pres=42+566|\
         u0995_u09CD.half_u0995.pres=45+566|\
         u0995_u09CD.half_u0995.pres=48+566|\
         space=51+213|\
         u0995_u09B0_u09CD.blwf.vatu=52+643|\
         u0995_u09CD.half_u09B2.pres=55+602"
    );
}

#[test]
fn ligature_id_018() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0020}\u{0995}\u{09CD}\u{09B0}\u{0995}\u{09CD}\
             \u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         u0995_u09CD.half_u0995.pres=39+566|\
         u0995_u09CD.half_u0995.pres=42+566|\
         u0995_u09CD.half_u0995.pres=45+566|\
         u0995_u09CD.half_u0995.pres=48+566|\
         u0995_u09CD.half_u0995.pres=51+566|\
         space=54+213|\
         u0995_u09B0_u09CD.blwf.vatu=55+643|\
         u0995_u09CD.half_u09B2.pres=58+602"
    );
}

#[test]
fn ligature_id_019() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0020}\u{0995}\u{09CD}\
             \u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         u0995_u09CD.half_u0995.pres=39+566|\
         u0995_u09CD.half_u0995.pres=42+566|\
         u0995_u09CD.half_u0995.pres=45+566|\
         u0995_u09CD.half_u0995.pres=48+566|\
         u0995_u09CD.half_u0995.pres=51+566|\
         u0995_u09CD.half_u0995.pres=54+566|\
         space=57+213|\
         u0995_u09B0_u09CD.blwf.vatu=58+643|\
         u0995_u09CD.half_u09B2.pres=61+602"
    );
}

#[test]
fn ligature_id_020() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0020}\u{0995}\u{09CD}\u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         u0995_u09CD.half_u0995.pres=39+566|\
         u0995_u09CD.half_u0995.pres=42+566|\
         u0995_u09CD.half_u0995.pres=45+566|\
         u0995_u09CD.half_u0995.pres=48+566|\
         u0995_u09CD.half_u0995.pres=51+566|\
         u0995_u09CD.half_u0995.pres=54+566|\
         u0995_u09CD.half_u0995.pres=57+566|\
         space=60+213|\
         u0995_u09B0_u09CD.blwf.vatu=61+643|\
         u0995_u09CD.half_u09B2.pres=64+602"
    );
}

#[test]
fn ligature_id_021() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0020}\u{0995}\u{09CD}\u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         u0995_u09CD.half_u0995.pres=39+566|\
         u0995_u09CD.half_u0995.pres=42+566|\
         u0995_u09CD.half_u0995.pres=45+566|\
         u0995_u09CD.half_u0995.pres=48+566|\
         u0995_u09CD.half_u0995.pres=51+566|\
         u0995_u09CD.half_u0995.pres=54+566|\
         u0995_u09CD.half_u0995.pres=57+566|\
         u0995_u09CD.half_u0995.pres=60+566|\
         space=63+213|\
         u0995_u09B0_u09CD.blwf.vatu=64+643|\
         u0995_u09CD.half_u09B2.pres=67+602"
    );
}

#[test]
fn ligature_id_022() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0020}\u{0995}\u{09CD}\u{09B0}\
             \u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         u0995_u09CD.half_u0995.pres=39+566|\
         u0995_u09CD.half_u0995.pres=42+566|\
         u0995_u09CD.half_u0995.pres=45+566|\
         u0995_u09CD.half_u0995.pres=48+566|\
         u0995_u09CD.half_u0995.pres=51+566|\
         u0995_u09CD.half_u0995.pres=54+566|\
         u0995_u09CD.half_u0995.pres=57+566|\
         u0995_u09CD.half_u0995.pres=60+566|\
         u0995_u09CD.half_u0995.pres=63+566|\
         space=66+213|\
         u0995_u09B0_u09CD.blwf.vatu=67+643|\
         u0995_u09CD.half_u09B2.pres=70+602"
    );
}

#[test]
fn ligature_id_023() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0020}\
             \u{0995}\u{09CD}\u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         u0995_u09CD.half_u0995.pres=39+566|\
         u0995_u09CD.half_u0995.pres=42+566|\
         u0995_u09CD.half_u0995.pres=45+566|\
         u0995_u09CD.half_u0995.pres=48+566|\
         u0995_u09CD.half_u0995.pres=51+566|\
         u0995_u09CD.half_u0995.pres=54+566|\
         u0995_u09CD.half_u0995.pres=57+566|\
         u0995_u09CD.half_u0995.pres=60+566|\
         u0995_u09CD.half_u0995.pres=63+566|\
         u0995_u09CD.half_u0995.pres=66+566|\
         space=69+213|\
         u0995_u09B0_u09CD.blwf.vatu=70+643|\
         u0995_u09CD.half_u09B2.pres=73+602"
    );
}

#[test]
fn ligature_id_024() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0020}\u{0995}\u{09CD}\u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         u0995_u09CD.half_u0995.pres=39+566|\
         u0995_u09CD.half_u0995.pres=42+566|\
         u0995_u09CD.half_u0995.pres=45+566|\
         u0995_u09CD.half_u0995.pres=48+566|\
         u0995_u09CD.half_u0995.pres=51+566|\
         u0995_u09CD.half_u0995.pres=54+566|\
         u0995_u09CD.half_u0995.pres=57+566|\
         u0995_u09CD.half_u0995.pres=60+566|\
         u0995_u09CD.half_u0995.pres=63+566|\
         u0995_u09CD.half_u0995.pres=66+566|\
         u0995_u09CD.half_u0995.pres=69+566|\
         space=72+213|\
         u0995_u09B0_u09CD.blwf.vatu=73+643|\
         u0995_u09CD.half_u09B2.pres=76+602"
    );
}

#[test]
fn ligature_id_025() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0020}\u{0995}\u{09CD}\u{09B0}\u{0995}\
             \u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         u0995_u09CD.half_u0995.pres=39+566|\
         u0995_u09CD.half_u0995.pres=42+566|\
         u0995_u09CD.half_u0995.pres=45+566|\
         u0995_u09CD.half_u0995.pres=48+566|\
         u0995_u09CD.half_u0995.pres=51+566|\
         u0995_u09CD.half_u0995.pres=54+566|\
         u0995_u09CD.half_u0995.pres=57+566|\
         u0995_u09CD.half_u0995.pres=60+566|\
         u0995_u09CD.half_u0995.pres=63+566|\
         u0995_u09CD.half_u0995.pres=66+566|\
         u0995_u09CD.half_u0995.pres=69+566|\
         u0995_u09CD.half_u0995.pres=72+566|\
         space=75+213|\
         u0995_u09B0_u09CD.blwf.vatu=76+643|\
         u0995_u09CD.half_u09B2.pres=79+602"
    );
}

#[test]
fn ligature_id_026() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0020}\u{0995}\
             \u{09CD}\u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         u0995_u09CD.half_u0995.pres=39+566|\
         u0995_u09CD.half_u0995.pres=42+566|\
         u0995_u09CD.half_u0995.pres=45+566|\
         u0995_u09CD.half_u0995.pres=48+566|\
         u0995_u09CD.half_u0995.pres=51+566|\
         u0995_u09CD.half_u0995.pres=54+566|\
         u0995_u09CD.half_u0995.pres=57+566|\
         u0995_u09CD.half_u0995.pres=60+566|\
         u0995_u09CD.half_u0995.pres=63+566|\
         u0995_u09CD.half_u0995.pres=66+566|\
         u0995_u09CD.half_u0995.pres=69+566|\
         u0995_u09CD.half_u0995.pres=72+566|\
         u0995_u09CD.half_u0995.pres=75+566|\
         space=78+213|\
         u0995_u09B0_u09CD.blwf.vatu=79+643|\
         u0995_u09CD.half_u09B2.pres=82+602"
    );
}

#[test]
fn ligature_id_027() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0020}\u{0995}\u{09CD}\u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         u0995_u09CD.half_u0995.pres=39+566|\
         u0995_u09CD.half_u0995.pres=42+566|\
         u0995_u09CD.half_u0995.pres=45+566|\
         u0995_u09CD.half_u0995.pres=48+566|\
         u0995_u09CD.half_u0995.pres=51+566|\
         u0995_u09CD.half_u0995.pres=54+566|\
         u0995_u09CD.half_u0995.pres=57+566|\
         u0995_u09CD.half_u0995.pres=60+566|\
         u0995_u09CD.half_u0995.pres=63+566|\
         u0995_u09CD.half_u0995.pres=66+566|\
         u0995_u09CD.half_u0995.pres=69+566|\
         u0995_u09CD.half_u0995.pres=72+566|\
         u0995_u09CD.half_u0995.pres=75+566|\
         u0995_u09CD.half_u0995.pres=78+566|\
         space=81+213|\
         u0995_u09B0_u09CD.blwf.vatu=82+643|\
         u0995_u09CD.half_u09B2.pres=85+602"
    );
}

#[test]
fn ligature_id_028() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0020}\u{0995}\u{09CD}\u{09B0}\u{0995}\u{09CD}\
             \u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         u0995_u09CD.half_u0995.pres=39+566|\
         u0995_u09CD.half_u0995.pres=42+566|\
         u0995_u09CD.half_u0995.pres=45+566|\
         u0995_u09CD.half_u0995.pres=48+566|\
         u0995_u09CD.half_u0995.pres=51+566|\
         u0995_u09CD.half_u0995.pres=54+566|\
         u0995_u09CD.half_u0995.pres=57+566|\
         u0995_u09CD.half_u0995.pres=60+566|\
         u0995_u09CD.half_u0995.pres=63+566|\
         u0995_u09CD.half_u0995.pres=66+566|\
         u0995_u09CD.half_u0995.pres=69+566|\
         u0995_u09CD.half_u0995.pres=72+566|\
         u0995_u09CD.half_u0995.pres=75+566|\
         u0995_u09CD.half_u0995.pres=78+566|\
         u0995_u09CD.half_u0995.pres=81+566|\
         space=84+213|\
         u0995_u09B0_u09CD.blwf.vatu=85+643|\
         u0995_u09CD.half_u09B2.pres=88+602"
    );
}

#[test]
fn ligature_id_029() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0020}\u{0995}\u{09CD}\
             \u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         u0995_u09CD.half_u0995.pres=39+566|\
         u0995_u09CD.half_u0995.pres=42+566|\
         u0995_u09CD.half_u0995.pres=45+566|\
         u0995_u09CD.half_u0995.pres=48+566|\
         u0995_u09CD.half_u0995.pres=51+566|\
         u0995_u09CD.half_u0995.pres=54+566|\
         u0995_u09CD.half_u0995.pres=57+566|\
         u0995_u09CD.half_u0995.pres=60+566|\
         u0995_u09CD.half_u0995.pres=63+566|\
         u0995_u09CD.half_u0995.pres=66+566|\
         u0995_u09CD.half_u0995.pres=69+566|\
         u0995_u09CD.half_u0995.pres=72+566|\
         u0995_u09CD.half_u0995.pres=75+566|\
         u0995_u09CD.half_u0995.pres=78+566|\
         u0995_u09CD.half_u0995.pres=81+566|\
         u0995_u09CD.half_u0995.pres=84+566|\
         space=87+213|\
         u0995_u09B0_u09CD.blwf.vatu=88+643|\
         u0995_u09CD.half_u09B2.pres=91+602"
    );
}

#[test]
fn ligature_id_030() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0020}\u{0995}\u{09CD}\u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         u0995_u09CD.half_u0995.pres=39+566|\
         u0995_u09CD.half_u0995.pres=42+566|\
         u0995_u09CD.half_u0995.pres=45+566|\
         u0995_u09CD.half_u0995.pres=48+566|\
         u0995_u09CD.half_u0995.pres=51+566|\
         u0995_u09CD.half_u0995.pres=54+566|\
         u0995_u09CD.half_u0995.pres=57+566|\
         u0995_u09CD.half_u0995.pres=60+566|\
         u0995_u09CD.half_u0995.pres=63+566|\
         u0995_u09CD.half_u0995.pres=66+566|\
         u0995_u09CD.half_u0995.pres=69+566|\
         u0995_u09CD.half_u0995.pres=72+566|\
         u0995_u09CD.half_u0995.pres=75+566|\
         u0995_u09CD.half_u0995.pres=78+566|\
         u0995_u09CD.half_u0995.pres=81+566|\
         u0995_u09CD.half_u0995.pres=84+566|\
         u0995_u09CD.half_u0995.pres=87+566|\
         space=90+213|\
         u0995_u09B0_u09CD.blwf.vatu=91+643|\
         u0995_u09CD.half_u09B2.pres=94+602"
    );
}

#[test]
fn ligature_id_031() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0020}\u{0995}\u{09CD}\u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         u0995_u09CD.half_u0995.pres=39+566|\
         u0995_u09CD.half_u0995.pres=42+566|\
         u0995_u09CD.half_u0995.pres=45+566|\
         u0995_u09CD.half_u0995.pres=48+566|\
         u0995_u09CD.half_u0995.pres=51+566|\
         u0995_u09CD.half_u0995.pres=54+566|\
         u0995_u09CD.half_u0995.pres=57+566|\
         u0995_u09CD.half_u0995.pres=60+566|\
         u0995_u09CD.half_u0995.pres=63+566|\
         u0995_u09CD.half_u0995.pres=66+566|\
         u0995_u09CD.half_u0995.pres=69+566|\
         u0995_u09CD.half_u0995.pres=72+566|\
         u0995_u09CD.half_u0995.pres=75+566|\
         u0995_u09CD.half_u0995.pres=78+566|\
         u0995_u09CD.half_u0995.pres=81+566|\
         u0995_u09CD.half_u0995.pres=84+566|\
         u0995_u09CD.half_u0995.pres=87+566|\
         u0995_u09CD.half_u0995.pres=90+566|\
         space=93+213|\
         u0995_u09B0_u09CD.blwf.vatu=94+643|\
         u0995_u09CD.half_u09B2.pres=97+602"
    );
}

#[test]
fn ligature_id_032() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0020}\u{0995}\u{09CD}\u{09B0}\
             \u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         u0995_u09CD.half_u0995.pres=39+566|\
         u0995_u09CD.half_u0995.pres=42+566|\
         u0995_u09CD.half_u0995.pres=45+566|\
         u0995_u09CD.half_u0995.pres=48+566|\
         u0995_u09CD.half_u0995.pres=51+566|\
         u0995_u09CD.half_u0995.pres=54+566|\
         u0995_u09CD.half_u0995.pres=57+566|\
         u0995_u09CD.half_u0995.pres=60+566|\
         u0995_u09CD.half_u0995.pres=63+566|\
         u0995_u09CD.half_u0995.pres=66+566|\
         u0995_u09CD.half_u0995.pres=69+566|\
         u0995_u09CD.half_u0995.pres=72+566|\
         u0995_u09CD.half_u0995.pres=75+566|\
         u0995_u09CD.half_u0995.pres=78+566|\
         u0995_u09CD.half_u0995.pres=81+566|\
         u0995_u09CD.half_u0995.pres=84+566|\
         u0995_u09CD.half_u0995.pres=87+566|\
         u0995_u09CD.half_u0995.pres=90+566|\
         u0995_u09CD.half_u0995.pres=93+566|\
         space=96+213|\
         u0995_u09B0_u09CD.blwf.vatu=97+643|\
         u0995_u09CD.half_u09B2.pres=100+602"
    );
}

#[test]
fn ligature_id_033() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0020}\
             \u{0995}\u{09CD}\u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         u0995_u09CD.half_u0995.pres=39+566|\
         u0995_u09CD.half_u0995.pres=42+566|\
         u0995_u09CD.half_u0995.pres=45+566|\
         u0995_u09CD.half_u0995.pres=48+566|\
         u0995_u09CD.half_u0995.pres=51+566|\
         u0995_u09CD.half_u0995.pres=54+566|\
         u0995_u09CD.half_u0995.pres=57+566|\
         u0995_u09CD.half_u0995.pres=60+566|\
         u0995_u09CD.half_u0995.pres=63+566|\
         u0995_u09CD.half_u0995.pres=66+566|\
         u0995_u09CD.half_u0995.pres=69+566|\
         u0995_u09CD.half_u0995.pres=72+566|\
         u0995_u09CD.half_u0995.pres=75+566|\
         u0995_u09CD.half_u0995.pres=78+566|\
         u0995_u09CD.half_u0995.pres=81+566|\
         u0995_u09CD.half_u0995.pres=84+566|\
         u0995_u09CD.half_u0995.pres=87+566|\
         u0995_u09CD.half_u0995.pres=90+566|\
         u0995_u09CD.half_u0995.pres=93+566|\
         u0995_u09CD.half_u0995.pres=96+566|\
         space=99+213|\
         u0995_u09B0_u09CD.blwf.vatu=100+643|\
         u0995_u09CD.half_u09B2.pres=103+602"
    );
}

#[test]
fn ligature_id_034() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0020}\u{0995}\u{09CD}\u{09B0}\u{0995}\u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         u0995_u09CD.half_u0995.pres=39+566|\
         u0995_u09CD.half_u0995.pres=42+566|\
         u0995_u09CD.half_u0995.pres=45+566|\
         u0995_u09CD.half_u0995.pres=48+566|\
         u0995_u09CD.half_u0995.pres=51+566|\
         u0995_u09CD.half_u0995.pres=54+566|\
         u0995_u09CD.half_u0995.pres=57+566|\
         u0995_u09CD.half_u0995.pres=60+566|\
         u0995_u09CD.half_u0995.pres=63+566|\
         u0995_u09CD.half_u0995.pres=66+566|\
         u0995_u09CD.half_u0995.pres=69+566|\
         u0995_u09CD.half_u0995.pres=72+566|\
         u0995_u09CD.half_u0995.pres=75+566|\
         u0995_u09CD.half_u0995.pres=78+566|\
         u0995_u09CD.half_u0995.pres=81+566|\
         u0995_u09CD.half_u0995.pres=84+566|\
         u0995_u09CD.half_u0995.pres=87+566|\
         u0995_u09CD.half_u0995.pres=90+566|\
         u0995_u09CD.half_u0995.pres=93+566|\
         u0995_u09CD.half_u0995.pres=96+566|\
         u0995_u09CD.half_u0995.pres=99+566|\
         space=102+213|\
         u0995_u09B0_u09CD.blwf.vatu=103+643|\
         u0995_u09CD.half_u09B2.pres=106+602"
    );
}

#[test]
fn ligature_id_035() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2fb74c1b2aa173262734c1f616148f1648cfd6.ttf",
            "\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\
             \u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\
             \u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0995}\
             \u{09CD}\u{0995}\u{0995}\u{09CD}\u{0995}\u{0020}\u{0995}\u{09CD}\u{09B0}\u{0995}\
             \u{09CD}\u{09B2}",
            "",
        ),
        "u0995_u09CD.half_u0995.pres=0+566|\
         u0995_u09CD.half_u0995.pres=3+566|\
         u0995_u09CD.half_u0995.pres=6+566|\
         u0995_u09CD.half_u0995.pres=9+566|\
         u0995_u09CD.half_u0995.pres=12+566|\
         u0995_u09CD.half_u0995.pres=15+566|\
         u0995_u09CD.half_u0995.pres=18+566|\
         u0995_u09CD.half_u0995.pres=21+566|\
         u0995_u09CD.half_u0995.pres=24+566|\
         u0995_u09CD.half_u0995.pres=27+566|\
         u0995_u09CD.half_u0995.pres=30+566|\
         u0995_u09CD.half_u0995.pres=33+566|\
         u0995_u09CD.half_u0995.pres=36+566|\
         u0995_u09CD.half_u0995.pres=39+566|\
         u0995_u09CD.half_u0995.pres=42+566|\
         u0995_u09CD.half_u0995.pres=45+566|\
         u0995_u09CD.half_u0995.pres=48+566|\
         u0995_u09CD.half_u0995.pres=51+566|\
         u0995_u09CD.half_u0995.pres=54+566|\
         u0995_u09CD.half_u0995.pres=57+566|\
         u0995_u09CD.half_u0995.pres=60+566|\
         u0995_u09CD.half_u0995.pres=63+566|\
         u0995_u09CD.half_u0995.pres=66+566|\
         u0995_u09CD.half_u0995.pres=69+566|\
         u0995_u09CD.half_u0995.pres=72+566|\
         u0995_u09CD.half_u0995.pres=75+566|\
         u0995_u09CD.half_u0995.pres=78+566|\
         u0995_u09CD.half_u0995.pres=81+566|\
         u0995_u09CD.half_u0995.pres=84+566|\
         u0995_u09CD.half_u0995.pres=87+566|\
         u0995_u09CD.half_u0995.pres=90+566|\
         u0995_u09CD.half_u0995.pres=93+566|\
         u0995_u09CD.half_u0995.pres=96+566|\
         u0995_u09CD.half_u0995.pres=99+566|\
         u0995_u09CD.half_u0995.pres=102+566|\
         space=105+213|\
         u0995_u09B0_u09CD.blwf.vatu=106+643|\
         u0995_u09CD.half_u09B2.pres=109+602"
    );
}

#[test]
fn ligature_id_036() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a6c76d1bafde4a0b1026ebcc932d2e5c6fd02442.ttf",
            "\u{1004}\u{103A}\u{1039}\u{101B}\u{103D}\u{102D}",
            "",
        ),
        "uni101B103D=0+450|\
         uni1004103A1039102D=0@-50,0+0"
    );
}

#[test]
fn mark_attachment_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/98b7887cff91f722b92a8ff800120954606354f9.ttf",
            "\u{100F}\u{103C}\u{102F}\u{1036}",
            "",
        ),
        "uni103C102F=0+150|\
         uni100F=0+550|\
         uni1036=0@-150,0+0"
    );
}

#[test]
fn mark_filtering_sets_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/f22416c692720a7d46fadf4af99f4c9e094f00b9.ttf",
            "\u{062A}\u{062E}\u{062A}\u{0629}",
            "",
        ),
        "glyph837=3@299,1170+0|\
         uni06C1.1=3+502|\
         glyph837=2@149,690+0|\
         uni0628.8=2+532|\
         glyph836=1@-51,1259+0|\
         glyph514=1+196|\
         glyph837=0@655,1751+0|\
         glyph112=0@0,-358+905"
    );
}

#[test]
fn mark_filtering_sets_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/f22416c692720a7d46fadf4af99f4c9e094f00b9.ttf",
            "\u{062A}\u{062E}\u{0646}\u{0629}",
            "",
        ),
        "glyph837=3@299,1170+0|\
         uni06C1.1=3+502|\
         glyph836=2@149,690+0|\
         uni0628.8=2+532|\
         glyph836=1@-51,1259+0|\
         glyph514=1+196|\
         glyph837=0@655,1751+0|\
         glyph112=0@0,-358+905"
    );
}

#[test]
fn mark_filtering_sets_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/f22416c692720a7d46fadf4af99f4c9e094f00b9.ttf",
            "\u{062A}\u{062E}\u{0626}\u{0629}",
            "",
        ),
        "glyph837=3@299,1170+0|\
         uni06C1.1=3+502|\
         glyph847=2@149,690+0|\
         uni0628.8=2+532|\
         glyph836=1@-51,1259+0|\
         glyph514=1+196|\
         glyph837=0@655,1751+0|\
         glyph112=0@0,-358+905"
    );
}

#[test]
fn mark_filtering_sets_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/f22416c692720a7d46fadf4af99f4c9e094f00b9.ttf",
            "\u{062A}\u{062E}\u{062B}\u{0629}",
            "",
        ),
        "glyph837=3@299,1520+0|\
         uni06C1.1=3+502|\
         glyph838=2@149,690+0|\
         uni0628.8=2+532|\
         glyph836=1@-51,1259+0|\
         glyph514=1+196|\
         glyph837=0@655,1751+0|\
         glyph112=0@0,-358+905"
    );
}

#[test]
fn mark_filtering_sets_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/f22416c692720a7d46fadf4af99f4c9e094f00b9.ttf",
            "\u{062A}\u{062E}\u{0679}\u{0629}",
            "",
        ),
        "glyph837=3@299,1520+0|\
         uni06C1.1=3+502|\
         glyph842=2@149,690+0|\
         uni0628.8=2+532|\
         glyph836=1@-51,1259+0|\
         glyph514=1+196|\
         glyph837=0@655,1751+0|\
         glyph112=0@0,-358+905"
    );
}

#[test]
fn mongolian_variation_selector_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/37033cc5cf37bb223d7355153016b6ccece93b28.ttf",
            "\u{1826}\u{180B}\u{1826}",
            "",
        ),
        "uni1826.E85E_ue.init1=0+599|\
         uni1826.E856_ue.fina=2+750"
    );
}

#[test]
fn mongolian_variation_selector_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/ef86fe710cfea877bbe0dbb6946a1f88d0661031.ttf",
            "\u{1820}\u{180B}",
            "",
        ),
        "uni1820.E821_a.isol1=0+1199"
    );
}

#[test]
fn mongolian_variation_selector_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a34a7b00f22ffb5fd7eef6933b81c7e71bc2cdfb.ttf",
            "\u{180A}\u{1868}\u{180A}\u{1868}\u{180B}\u{180A}\u{1868}\u{180C}\u{180A}\u{1868}\
             \u{180D}\u{180A}",
            "",
        ),
        "gid1=0+268|\
         gid10=1+778|\
         gid1=2+268|\
         gid9=3+575|\
         gid1=5+268|\
         gid10=6+778|\
         gid1=8+268|\
         gid8=9+575|\
         gid1=11+268"
    );
}

#[test]
fn mongolian_variation_selector_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4d4206e30b2dbf1c1ef492a8eae1c9e7829ebad8.ttf",
            "\u{183A}\u{1823}\u{182E}\u{182B}\u{1822}\u{1826}\u{180B}\u{1832}\u{180B}\u{1827}\
             \u{1837}",
            "",
        ),
        "uni183A1823.E971_ko.init=0+950|\
         uni182E.E904_m.medi=2+400|\
         uni182B1822.E8A6_pi.medi=3+1150|\
         uni1826.E854_ue.medi1=5+1100|\
         uni1832.E916_t.medi1=7+1000|\
         uni1827.E85C_ee.medi=9+750|\
         uni1837.E931_r.fina=10+750"
    );
}

#[test]
fn mongolian_variation_selector_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4d4206e30b2dbf1c1ef492a8eae1c9e7829ebad8.ttf",
            "\u{182D}\u{182D}\u{180B}",
            "",
        ),
        "uni182D.E8E2_g.init=0+1000|\
         uni182D.E8E8_g.fina1=1+1250"
    );
}

#[test]
fn mongolian_variation_selector_006() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4d4206e30b2dbf1c1ef492a8eae1c9e7829ebad8.ttf",
            "\u{182D}\u{180C}",
            "",
        ),
        "uni182D.EA1B_g.isol2=0+1000"
    );
}

#[test]
fn mongolian_variation_selector_007() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4d4206e30b2dbf1c1ef492a8eae1c9e7829ebad8.ttf",
            "\u{182D}\u{180D}\u{200D}",
            "",
        ),
        "uni182D.EA1E_g.init3=0+650|\
         space=0+0"
    );
}

#[test]
fn mongolian_variation_selector_008() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4d4206e30b2dbf1c1ef492a8eae1c9e7829ebad8.ttf",
            "\u{182D}\u{200D}\u{182D}\u{180B}\u{200D}",
            "",
        ),
        "uni182D.E8E2_g.init=0+1000|\
         space=0+0|\
         uni182D.E8E5_g.medi1=2+800|\
         space=2+0"
    );
}

#[test]
fn mongolian_variation_selector_009() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4d4206e30b2dbf1c1ef492a8eae1c9e7829ebad8.ttf",
            "\u{182D}\u{180C}\u{200D}",
            "",
        ),
        "uni182D.EA1D_g.init2=0+950|\
         space=0+0"
    );
}

#[test]
fn mongolian_variation_selector_010() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4d4206e30b2dbf1c1ef492a8eae1c9e7829ebad8.ttf",
            "\u{182D}\u{180D}\u{200D}",
            "",
        ),
        "uni182D.EA1E_g.init3=0+650|\
         space=0+0"
    );
}

#[test]
fn mongolian_variation_selector_011() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4d4206e30b2dbf1c1ef492a8eae1c9e7829ebad8.ttf",
            "\u{200D}\u{182D}\u{200D}\u{200D}\u{182D}\u{180B}\u{200D}",
            "",
        ),
        "space=0+0|\
         uni182D.E8E4_g.medi=1+800|\
         space=1+0|\
         space=1+0|\
         uni182D.E8E5_g.medi1=4+800|\
         space=4+0"
    );
}

#[test]
fn mongolian_variation_selector_012() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4d4206e30b2dbf1c1ef492a8eae1c9e7829ebad8.ttf",
            "\u{200D}\u{182D}\u{180C}\u{200D}",
            "",
        ),
        "space=0+0|\
         uni182D.E8E6_g.medi2=1+650|\
         space=1+0"
    );
}

#[test]
fn mongolian_variation_selector_013() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4d4206e30b2dbf1c1ef492a8eae1c9e7829ebad8.ttf",
            "\u{200D}\u{182D}\u{180D}\u{200D}",
            "",
        ),
        "space=0+0|\
         uni182D.E8E6_g.medi2=1+650|\
         space=1+0"
    );
}

#[test]
fn mongolian_variation_selector_014() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4d4206e30b2dbf1c1ef492a8eae1c9e7829ebad8.ttf",
            "\u{200D}\u{182D}\u{200D}\u{182D}\u{180B}",
            "",
        ),
        "space=0+0|\
         uni182D.E8E4_g.medi=1+800|\
         space=1+0|\
         uni182D.E8E8_g.fina1=3+1250"
    );
}

#[test]
fn mongolian_variation_selector_015() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4d4206e30b2dbf1c1ef492a8eae1c9e7829ebad8.ttf",
            "\u{200D}\u{182D}\u{180C}",
            "",
        ),
        "space=0+0|\
         uni182D.E8E9_g.fina2=1+1050"
    );
}

#[test]
fn mongolian_variation_selector_016() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4d4206e30b2dbf1c1ef492a8eae1c9e7829ebad8.ttf",
            "\u{1820}\u{200C}\u{182D}\u{1820}\u{1837}",
            "",
        ),
        "uni1820.E820_a.isol=0+1550|\
         space=1+0|\
         uni182D.E8E2_g.init=2+1000|\
         uni1820.E823_a.medi=3+400|\
         uni1837.E931_r.fina=4+750"
    );
}

#[test]
fn mongolian_variation_selector_017() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4d4206e30b2dbf1c1ef492a8eae1c9e7829ebad8.ttf",
            "\u{1830}\u{1824}\u{1837}\u{200D}\u{200D}\u{182D}\u{1820}\u{200D}",
            "",
        ),
        "uni1830.E90B_s.init=0+850|\
         uni1824.E844_u.medi=1+600|\
         uni1837.E930_r.medi=2+600|\
         space=2+0|\
         space=2+0|\
         uni182D.E8E5_g.medi1=5+800|\
         uni1820.E823_a.medi=6+400|\
         space=6+0"
    );
}

#[test]
fn mongolian_variation_selector_018() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4d4206e30b2dbf1c1ef492a8eae1c9e7829ebad8.ttf",
            "\u{200D}\u{182D}\u{1824}\u{182F}\u{1822}",
            "",
        ),
        "space=0+0|\
         uni182D.E8E5_g.medi1=1+800|\
         uni1824.E844_u.medi=2+600|\
         uni182F.E908_l.medi=3+400|\
         uni1822.E837_i.fina=4+600"
    );
}

#[test]
fn mongolian_variation_selector_019() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4d4206e30b2dbf1c1ef492a8eae1c9e7829ebad8.ttf",
            "\u{182A}\u{1820}\u{1822}\u{182D}\u{180E}\u{1820}\u{202F}\u{1836}\u{1822}\u{1828}",
            "",
        ),
        "uni182A1820.E875_ba.init=0+1000|\
         uni1822.E836_i.medi2=2+1000|\
         uni182D.E8E8_g.fina1=3+1250|\
         space=4+0|\
         uni1820.E827_a.fina2=5+600|\
         uni202F.nobreak=6+500|\
         uni1836.E92B_y.init1=7+500|\
         uni1822.E834_i.medi=8+500|\
         uni1828.E866_n.fina=9+850"
    );
}

#[test]
fn myanmar_syllable_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/af3086380b743099c54a3b11b96766039ea62fcd.ttf",
            "\u{101D}\u{FE00}\u{1031}\u{FE00}\u{1031}\u{FE00}",
            "--no-glyph-names",
        ),
        "6=0+465|\
         6=0+465|\
         5=0+502"
    );
}

#[test]
fn myanmar_zawgyi_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/ab14b4eb9d7a67e293f51d30d719add06c9d6e06.ttf",
            "\u{1000}\u{103A}\u{1004}\u{1037}\u{1039}\u{1041}",
            "--script=Qaag",
        ),
        "Ka=0+2217|\
         Ya-Semivowel=0+286|\
         Nga=2+1247|\
         Dot Below=2+0|\
         Virama-Killer=2+0|\
         One-Myanmar=5+1247"
    );
}

#[test]
fn none_directional_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/73e84dac2fc6a2d1bc9250d1414353661088937d.ttf",
            "\u{10300}\u{10301}",
            "",
        ),
        "u10300=0+1470|\
         u10301=1+1284"
    );
}

#[test]
fn none_directional_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/73e84dac2fc6a2d1bc9250d1414353661088937d.ttf",
            "\u{10300}\u{10301}",
            "--direction=ltr",
        ),
        "u10300=0+1470|\
         u10301=1+1284"
    );
}

#[test]
fn none_directional_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/73e84dac2fc6a2d1bc9250d1414353661088937d.ttf",
            "\u{10300}\u{10301}",
            "--direction=rtl",
        ),
        "u10301_r=1+1284|\
         u10300_r=0+1470"
    );
}

#[test]
fn positioning_features_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/53a91c20e33a596f2be17fb68b382d6b7eb85d5c.ttf",
            "\u{0041}\u{0056}",
            "",
        ),
        "A=0+625|\
         V=1+675"
    );
}

#[test]
fn positioning_features_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/f79eb71df4e4c9c273b67b89a06e5ff9e3c1f834.ttf",
            "\u{006D}\u{0315}",
            "",
        ),
        "m=0+945|\
         uni0315=0@32,-178+0"
    );
}

#[test]
fn positioning_features_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/ea3f63620511b2097200d23774ffef197e829e69.ttf",
            "\u{0079}\u{0325}",
            "",
        ),
        "y=0+565|\
         uni0325=0@-422,-240+0"
    );
}

#[test]
fn rand_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/5bb74492f5e0ffa1fbb72e4c881be035120b6513.ttf",
            "\u{0054}\u{0055}\u{0056}",
            "--no-glyph-names --features=-rand",
        ),
        "1=0+560|\
         2=1+602|\
         3=2+602"
    );
}

#[test]
fn rand_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/5bb74492f5e0ffa1fbb72e4c881be035120b6513.ttf",
            "\u{0054}\u{0055}\u{0056}",
            "--no-glyph-names --features=rand=2",
        ),
        "5=0+560|\
         8=1+602|\
         11=2+602"
    );
}

#[test]
fn rand_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/5bb74492f5e0ffa1fbb72e4c881be035120b6513.ttf",
            "\u{0054}\u{0055}\u{0056}\u{0054}\u{0055}\u{0056}\u{0054}\u{0055}\u{0056}\u{0054}\
             \u{0055}\u{0056}",
            "--no-glyph-names",
        ),
        "5=0+560|\
         7=1+602|\
         10=2+602|\
         4=3+560|\
         7=4+602|\
         10=5+602|\
         6=6+560|\
         9=7+602|\
         10=8+602|\
         5=9+560|\
         8=10+602|\
         12=11+602"
    );
}

#[test]
fn reverse_sub_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a706511c65fb278fda87eaf2180ca6684a80f423.ttf",
            "\u{0041}\u{0020}\u{0041}\u{0042}",
            "",
        ),
        "A.alt1=0+1000|\
         space=1+1000|\
         A.alt1=2+1000|\
         B=3+1000"
    );
}

#[test]
fn rotation_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2681c1c72d6484ed3410417f521b1b819b4e2392.ttf",
            "\u{3008}",
            "--no-clusters --no-positions --direction=l",
        ),
        "uni3008"
    );
}

#[test]
fn rotation_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2681c1c72d6484ed3410417f521b1b819b4e2392.ttf",
            "\u{3008}",
            "--no-clusters --no-positions --direction=r",
        ),
        "uni3009"
    );
}

#[test]
fn rotation_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2681c1c72d6484ed3410417f521b1b819b4e2392.ttf",
            "\u{3008}",
            "--no-clusters --no-positions --direction=t",
        ),
        "uniFE3F"
    );
}

#[test]
fn rotation_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2681c1c72d6484ed3410417f521b1b819b4e2392.ttf",
            "\u{3008}",
            "--no-clusters --no-positions --direction=b",
        ),
        "uniFE40"
    );
}

#[test]
fn simple_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/49c9f7485c1392fa09a1b801bc2ffea79275f22e.ttf",
            "\u{0056}\u{0041}\u{0042}\u{0045}\u{0061}\u{0062}\u{0063}\u{0064}",
            "",
        ),
        "V=0+1142|\
         A=1+1295|\
         B=2+1295|\
         E=3+1123|\
         a=4+1126|\
         b=5+1164|\
         c=6+1072|\
         d=7+1164"
    );
}

#[test]
fn sinhala_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/5af5361ed4d1e8305780b100e1730cb09132f8d1.ttf",
            "\u{0DBB}\u{0DCA}\u{200D}\u{0DBA}\u{0DCA}\u{200D}\u{0DBA}",
            "",
        ),
        "gid8=0+1343|\
         gid4=0+1130"
    );
}

#[test]
fn spaces_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{0020}",
            "",
        ),
        "gid1=0+560"
    );
}

#[test]
fn spaces_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{00A0}",
            "",
        ),
        "gid1=0+560"
    );
}

#[test]
fn spaces_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{1680}",
            "",
        ),
        "gid0=0+692"
    );
}

#[test]
fn spaces_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{2000}",
            "",
        ),
        "gid1=0+1024"
    );
}

#[test]
fn spaces_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{2001}",
            "",
        ),
        "gid1=0+2048"
    );
}

#[test]
fn spaces_006() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{2002}",
            "",
        ),
        "gid1=0+1024"
    );
}

#[test]
fn spaces_007() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{2003}",
            "",
        ),
        "gid1=0+2048"
    );
}

#[test]
fn spaces_008() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{2004}",
            "",
        ),
        "gid1=0+683"
    );
}

#[test]
fn spaces_009() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{2005}",
            "",
        ),
        "gid1=0+512"
    );
}

#[test]
fn spaces_010() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{2006}",
            "",
        ),
        "gid1=0+341"
    );
}

#[test]
fn spaces_011() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{2007}",
            "",
        ),
        "gid1=0+560"
    );
}

#[test]
fn spaces_012() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{2008}",
            "",
        ),
        "gid1=0+560"
    );
}

#[test]
fn spaces_013() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{2009}",
            "",
        ),
        "gid1=0+410"
    );
}

#[test]
fn spaces_014() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{200A}",
            "",
        ),
        "gid1=0+128"
    );
}

#[test]
fn spaces_015() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{202F}",
            "",
        ),
        "gid1=0+280"
    );
}

#[test]
fn spaces_016() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{205F}",
            "",
        ),
        "gid1=0+455"
    );
}

#[test]
fn spaces_017() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{3000}",
            "",
        ),
        "gid1=0+2048"
    );
}

#[test]
fn spaces_018() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{0020}",
            "--direction=ttb",
        ),
        "gid1=0@-280,0+0,-2048"
    );
}

#[test]
fn spaces_019() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{00A0}",
            "--direction=ttb",
        ),
        "gid1=0@-280,0+0,-2048"
    );
}

#[test]
fn spaces_020() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{1680}",
            "--direction=ttb",
        ),
        "gid0=0@-346,0+0,-2048"
    );
}

#[test]
fn spaces_021() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{2000}",
            "--direction=ttb",
        ),
        "gid1=0@-280,0+0,-1024"
    );
}

#[test]
fn spaces_022() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{2001}",
            "--direction=ttb",
        ),
        "gid1=0@-280,0+0,-2048"
    );
}

#[test]
fn spaces_023() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{2002}",
            "--direction=ttb",
        ),
        "gid1=0@-280,0+0,-1024"
    );
}

#[test]
fn spaces_024() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{2003}",
            "--direction=ttb",
        ),
        "gid1=0@-280,0+0,-2048"
    );
}

#[test]
fn spaces_025() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{2004}",
            "--direction=ttb",
        ),
        "gid1=0@-280,0+0,-683"
    );
}

#[test]
fn spaces_026() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{2005}",
            "--direction=ttb",
        ),
        "gid1=0@-280,0+0,-512"
    );
}

#[test]
fn spaces_027() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{2006}",
            "--direction=ttb",
        ),
        "gid1=0@-280,0+0,-341"
    );
}

#[test]
fn spaces_028() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{2007}",
            "--direction=ttb",
        ),
        "gid1=0@-280,0+0,-2048"
    );
}

#[test]
fn spaces_029() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{2008}",
            "--direction=ttb",
        ),
        "gid1=0@-280,0+0,-2048"
    );
}

#[test]
fn spaces_030() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{2009}",
            "--direction=ttb",
        ),
        "gid1=0@-280,0+0,-410"
    );
}

#[test]
fn spaces_031() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{200A}",
            "--direction=ttb",
        ),
        "gid1=0@-280,0+0,-128"
    );
}

#[test]
fn spaces_032() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{202F}",
            "--direction=ttb",
        ),
        "gid1=0@-280,0+0,-1024"
    );
}

#[test]
fn spaces_033() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{205F}",
            "--direction=ttb",
        ),
        "gid1=0@-280,0+0,-455"
    );
}

#[test]
fn spaces_034() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1c2c3fc37b2d4c3cb2ef726c6cdaaabd4b7f3eb9.ttf",
            "\u{3000}",
            "--direction=ttb",
        ),
        "gid1=0@-280,0+0,-2048"
    );
}

#[test]
fn tibetan_contractions_1_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{FEFF}\u{0F40}\u{0F72}\u{0F72}\u{0F0B}\u{0F66}\u{0FAD}\u{0F7C}\u{0F7C}\u{0F0B}",
            "",
        ),
        "uni0F40=0+680|\
         uni0F720F72=0+0|\
         uni0F0B=4+190|\
         uni0F660FAD=5+680|\
         uni0F7D=5+0|\
         uni0F0B=9+190"
    );
}

#[test]
fn tibetan_contractions_1_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F40}\u{0F74}\u{0F72}\u{0F66}\u{0F0B}",
            "",
        ),
        "uni0F400F740F72=0+680|\
         uni0F66=3+680|\
         uni0F0B=4+190"
    );
}

#[test]
fn tibetan_contractions_1_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F40}\u{0F74}\u{0F7A}\u{0F53}\u{0F0B}",
            "",
        ),
        "uni0F400F74=0+680|\
         uni0F7A=0+0|\
         uni0F53=3+590|\
         uni0F0B=4@-30,0+160"
    );
}

#[test]
fn tibetan_contractions_1_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F40}\u{0F74}\u{0F7C}\u{0F56}\u{0F39}\u{0F0B}",
            "",
        ),
        "uni0F400F74=0+680|\
         uni0F7C=0+0|\
         uni0F56=3+610|\
         uni0F39=3+0|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_1_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F40}\u{0F74}\u{0F72}\u{0F42}\u{0F66}\u{0F0B}",
            "",
        ),
        "uni0F400F740F72=0+680|\
         uni0F42=3+680|\
         uni0F66=4+680|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_1_006() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F40}\u{0F74}\u{0F7A}\u{0F66}\u{0F0B}",
            "",
        ),
        "uni0F400F74=0+680|\
         uni0F7A=0+0|\
         uni0F66=3+680|\
         uni0F0B=4+190"
    );
}

#[test]
fn tibetan_contractions_1_007() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F40}\u{0FB3}\u{0F74}\u{0F7A}\u{0F56}\u{0F66}\u{0F0B}",
            "",
        ),
        "uni0F400FB30F740F7A=0+660|\
         uni0F56=4+610|\
         uni0F66=5+680|\
         uni0F0B=6+190"
    );
}

#[test]
fn tibetan_contractions_1_008() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F40}\u{0FB3}\u{0F74}\u{0F7C}\u{0F42}\u{0F0B}",
            "",
        ),
        "uni0F400FB30F74=0+660|\
         uni0F7C=0+0|\
         uni0F42=4+680|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_1_009() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F51}\u{0F40}\u{0F7C}\u{0F7C}\u{0F42}\u{0F0B}",
            "",
        ),
        "uni0F51=0+600|\
         uni0F400F7D=1+680|\
         uni0F42=4+680|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_1_010() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F51}\u{0F40}\u{0F7C}\u{0F7C}\u{0F62}\u{0F0B}",
            "",
        ),
        "uni0F51=0+600|\
         uni0F400F7D=1+680|\
         uni0F62=4+620|\
         uni0F0B=5@-65,0+130"
    );
}

#[test]
fn tibetan_contractions_1_011() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F51}\u{0F40}\u{0FB1}\u{0F7C}\u{0F72}\u{0F62}\u{0F0B}",
            "",
        ),
        "uni0F51=0+600|\
         uni0F400FB10F7C0F72=1+660|\
         uni0F62=5+620|\
         uni0F0B=6@-65,0+130"
    );
}

#[test]
fn tibetan_contractions_1_012() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F66}\u{0F90}\u{0FB1}\u{0F74}\u{0F7A}\u{0F0B}",
            "",
        ),
        "uni0F660F900FB10F74=0+680|\
         uni0F7A=0+0|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_1_013() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F56}\u{0F66}\u{0F90}\u{0FB1}\u{0F7A}\u{0F7A}\u{0F51}\u{0F0B}",
            "",
        ),
        "uni0F56=0+610|\
         uni0F660F900FB1=1+660|\
         uni0F7B=1+0|\
         uni0F51=6+600|\
         uni0F0B=7@-70,0+106"
    );
}

#[test]
fn tibetan_contractions_1_014() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F56}\u{0F66}\u{0F90}\u{0FB1}\u{0F7A}\u{0F7A}\u{0F7A}\u{0F51}\u{0F0B}",
            "",
        ),
        "uni0F56=0+610|\
         uni0F660F900FB1=1+660|\
         uni0F7B0F7A=1+0|\
         uni0F51=7+600|\
         uni0F0B=8@-70,0+106"
    );
}

#[test]
fn tibetan_contractions_1_015() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F41}\u{0F58}\u{0F66}\u{0F74}\u{0F7E}\u{0F0B}",
            "",
        ),
        "uni0F41=0+660|\
         uni0F58=1+660|\
         uni0F660F740F7E=2+680|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_1_016() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F41}\u{0F74}\u{0F7C}\u{0F66}\u{0F39}\u{0F0B}",
            "",
        ),
        "uni0F410F74=0+680|\
         uni0F7C=0+0|\
         uni0F66=3+680|\
         uni0F39=3+0|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_1_017() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F41}\u{0FB1}\u{0F74}\u{0F7C}\u{0F42}\u{0F0B}",
            "",
        ),
        "uni0F410FB10F74=0+670|\
         uni0F7C=0+0|\
         uni0F42=4+680|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_1_018() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F41}\u{0FB2}\u{0F74}\u{0F7A}\u{0F51}\u{0F0B}",
            "",
        ),
        "uni0F410FB20F74=0+660|\
         uni0F7A=0+0|\
         uni0F51=4+600|\
         uni0F0B=5@-70,0+106"
    );
}

#[test]
fn tibetan_contractions_1_019() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F41}\u{0FB2}\u{0F74}\u{0F72}\u{0F44}\u{0F0B}",
            "",
        ),
        "uni0F410FB20F74=0+660|\
         uni0F72=0+0|\
         uni0F44=4+560|\
         uni0F0B=5@-20,0+110"
    );
}

#[test]
fn tibetan_contractions_1_020() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F41}\u{0FB2}\u{0F74}\u{0F7C}\u{0F51}\u{0F0B}",
            "",
        ),
        "uni0F410FB20F74=0+660|\
         uni0F7C=0+0|\
         uni0F51=4+600|\
         uni0F0B=5@-70,0+106"
    );
}

#[test]
fn tibetan_contractions_1_021() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F41}\u{0FB2}\u{0F74}\u{0F7E}\u{0F51}\u{0F0B}",
            "",
        ),
        "uni0F410FB20F740F7E=0+660|\
         uni0F51=4+600|\
         uni0F0B=5@-70,0+106"
    );
}

#[test]
fn tibetan_contractions_1_022() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F58}\u{0F41}\u{0FB1}\u{0F7A}\u{0F7A}\u{0F7A}\u{0F53}\u{0F0B}",
            "",
        ),
        "uni0F58=0+660|\
         uni0F410FB1=1+680|\
         uni0F7B0F7A=1+0|\
         uni0F53=6+590|\
         uni0F0B=7@-30,0+160"
    );
}

#[test]
fn tibetan_contractions_1_023() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F60}\u{0F41}\u{0F7C}\u{0F7C}\u{0F62}\u{0F0B}",
            "",
        ),
        "uni0F60=0+600|\
         uni0F410F7D=1+660|\
         uni0F62=4+620|\
         uni0F0B=5@-65,0+130"
    );
}

#[test]
fn tibetan_contractions_1_024() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F42}\u{0F74}\u{0F7C}\u{0F42}\u{0F0B}",
            "",
        ),
        "uni0F420F74=0+680|\
         uni0F7C=0+0|\
         uni0F42=3+680|\
         uni0F0B=4+190"
    );
}

#[test]
fn tibetan_contractions_1_025() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F42}\u{0FB1}\u{0F74}\u{0F72}\u{0F42}\u{0F0B}",
            "",
        ),
        "uni0F420FB10F74=0+700|\
         uni0F72=0+0|\
         uni0F42=4+680|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_1_026() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F42}\u{0FB2}\u{0F74}\u{0F72}\u{0F53}\u{0F0B}",
            "",
        ),
        "uni0F420FB20F74=0+680|\
         uni0F72=0+0|\
         uni0F53=4+590|\
         uni0F0B=5@-30,0+160"
    );
}

#[test]
fn tibetan_contractions_1_027() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F42}\u{0FB2}\u{0F74}\u{0F72}\u{0F0B}",
            "",
        ),
        "uni0F420FB20F74=0+680|\
         uni0F72=0+0|\
         uni0F0B=4+190"
    );
}

#[test]
fn tibetan_contractions_1_028() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F42}\u{0FB2}\u{0F74}\u{0F7C}\u{0F53}\u{0F0B}",
            "",
        ),
        "uni0F420FB20F74=0+680|\
         uni0F7C=0+0|\
         uni0F53=4+590|\
         uni0F0B=5@-30,0+160"
    );
}

#[test]
fn tibetan_contractions_1_029() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F42}\u{0FB2}\u{0F74}\u{0F7C}\u{0F56}\u{0F0B}",
            "",
        ),
        "uni0F420FB20F74=0+680|\
         uni0F7C=0+0|\
         uni0F56=4+610|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_1_030() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F42}\u{0FB2}\u{0F7C}\u{0F72}\u{0F53}\u{0F0B}",
            "",
        ),
        "uni0F420FB2=0+680|\
         uni0F7C0F72=0+0|\
         uni0F53=4+590|\
         uni0F0B=5@-30,0+160"
    );
}

#[test]
fn tibetan_contractions_1_031() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F42}\u{0FB2}\u{0F7C}\u{0F7A}\u{0F62}\u{0F0B}",
            "",
        ),
        "uni0F420FB2=0+680|\
         uni0F7C0F7A=0+0|\
         uni0F62=4+620|\
         uni0F0B=5@-65,0+130"
    );
}

#[test]
fn tibetan_contractions_1_032() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F51}\u{0F42}\u{0F74}\u{0F72}\u{0F42}\u{0F0B}",
            "",
        ),
        "uni0F51=0+600|\
         uni0F420F740F72=1+680|\
         uni0F42=4+680|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_1_033() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F51}\u{0F42}\u{0F74}\u{0F7A}\u{0F53}\u{0F0B}",
            "",
        ),
        "uni0F51=0+600|\
         uni0F420F74=1+680|\
         uni0F7A=1+0|\
         uni0F53=4+590|\
         uni0F0B=5@-30,0+160"
    );
}

#[test]
fn tibetan_contractions_1_034() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F51}\u{0F42}\u{0F74}\u{0F7A}\u{0F42}\u{0F66}\u{0F0B}",
            "",
        ),
        "uni0F51=0+600|\
         uni0F420F74=1+680|\
         uni0F7A=1+0|\
         uni0F42=4+680|\
         uni0F66=5+680|\
         uni0F0B=6+190"
    );
}

#[test]
fn tibetan_contractions_1_035() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F51}\u{0F42}\u{0FB3}\u{0F7C}\u{0F7A}\u{0F44}\u{0F0B}",
            "",
        ),
        "uni0F51=0+600|\
         uni0F420FB3=1+680|\
         uni0F7C0F7A=1+0|\
         uni0F44=5+560|\
         uni0F0B=6@-20,0+110"
    );
}

#[test]
fn tibetan_contractions_1_036() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F58}\u{0F42}\u{0F7C}\u{0F7C}\u{0F53}\u{0F0B}",
            "",
        ),
        "uni0F58=0+660|\
         uni0F420F7D=1+680|\
         uni0F53=4+590|\
         uni0F0B=5@-30,0+160"
    );
}

#[test]
fn tibetan_contractions_1_037() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F44}\u{0F74}\u{0F72}\u{0F42}\u{0F0B}",
            "",
        ),
        "uni0F440F74=0+610|\
         uni0F72=0+0|\
         uni0F42=3+680|\
         uni0F0B=4+190"
    );
}

#[test]
fn tibetan_contractions_1_038() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F51}\u{0F42}\u{0FB2}\u{0F74}\u{0F7C}\u{0F56}\u{0F0B}",
            "",
        ),
        "uni0F51=0+600|\
         uni0F420FB20F74=1+680|\
         uni0F7C=1+0|\
         uni0F56=5+610|\
         uni0F0B=6+190"
    );
}

#[test]
fn tibetan_contractions_1_039() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F56}\u{0F45}\u{0F74}\u{0F72}\u{0F42}\u{0F0B}",
            "",
        ),
        "uni0F56=0+610|\
         uni0F450F740F72=1+630|\
         uni0F42=4+680|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_1_040() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F56}\u{0F45}\u{0F74}\u{0F72}\u{0F66}\u{0F0B}",
            "",
        ),
        "uni0F56=0+610|\
         uni0F450F740F72=1+630|\
         uni0F66=4+680|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_1_041() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F56}\u{0F45}\u{0FB2}\u{0F74}\u{0F42}\u{0F0B}",
            "",
        ),
        "uni0F56=0+610|\
         uni0F450FB20F74=1+640|\
         uni0F42=4+680|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_1_042() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F56}\u{0F45}\u{0F74}\u{0F72}\u{0F0B}",
            "",
        ),
        "uni0F56=0+610|\
         uni0F450F740F72=1+630|\
         uni0F0B=4+190"
    );
}

#[test]
fn tibetan_contractions_1_043() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F56}\u{0F45}\u{0F74}\u{0F7E}\u{0F0B}",
            "",
        ),
        "uni0F56=0+610|\
         uni0F450F740F7E=1+630|\
         uni0F0B=4+190"
    );
}

#[test]
fn tibetan_contractions_1_044() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F46}\u{0F74}\u{0F72}\u{0F63}\u{0F0B}",
            "",
        ),
        "uni0F460F74=0+650|\
         uni0F72=0+0|\
         uni0F63=3+700|\
         uni0F0B=4+190"
    );
}

#[test]
fn tibetan_contractions_1_045() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F46}\u{0F74}\u{0F7C}\u{0F51}\u{0F0B}",
            "",
        ),
        "uni0F460F74=0+650|\
         uni0F7C=0+0|\
         uni0F51=3+600|\
         uni0F0B=4@-70,0+106"
    );
}

#[test]
fn tibetan_contractions_1_046() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F46}\u{0F74}\u{0F7C}\u{0F51}\u{0F0B}",
            "",
        ),
        "uni0F460F74=0+650|\
         uni0F7C=0+0|\
         uni0F51=3+600|\
         uni0F0B=4@-70,0+106"
    );
}

#[test]
fn tibetan_contractions_1_047() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F46}\u{0F74}\u{0F7E}\u{0F51}\u{0F0B}",
            "",
        ),
        "uni0F460F740F7E=0+650|\
         uni0F51=3+600|\
         uni0F0B=4@-70,0+106"
    );
}

#[test]
fn tibetan_contractions_1_048() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F46}\u{0F39}\u{0F74}\u{0F7C}\u{0F51}\u{0F0B}",
            "",
        ),
        "uni0F46=0+620|\
         uni0F39=0+0|\
         uni0F74=0+0|\
         uni0F7C=0+0|\
         uni0F51=4+600|\
         uni0F0B=5@-70,0+106"
    );
}

#[test]
fn tibetan_contractions_1_049() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F46}\u{0FB2}\u{0F74}\u{0F72}\u{0F53}\u{0F0B}",
            "",
        ),
        "uni0F460FB20F740F72=0+660|\
         uni0F53=4+590|\
         uni0F0B=5@-30,0+160"
    );
}

#[test]
fn tibetan_contractions_1_050() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F46}\u{0FB2}\u{0F74}\u{0F7C}\u{0F63}\u{0F0B}",
            "",
        ),
        "uni0F460FB20F74=0+660|\
         uni0F7C=0+0|\
         uni0F63=4+700|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_1_051() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F58}\u{0F46}\u{0F7C}\u{0F7A}\u{0F53}\u{0F0B}",
            "",
        ),
        "uni0F58=0+660|\
         uni0F46=1+620|\
         uni0F7C0F7A=1+0|\
         uni0F53=4+590|\
         uni0F0B=5@-30,0+160"
    );
}

#[test]
fn tibetan_contractions_1_052() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F60}\u{0F46}\u{0FB1}\u{0F7C}\u{0F72}\u{0F62}\u{0F0B}",
            "",
        ),
        "uni0F60=0+600|\
         uni0F460FB10F7C0F72=1+660|\
         uni0F62=5+620|\
         uni0F0B=6@-65,0+130"
    );
}

#[test]
fn tibetan_contractions_1_053() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F47}\u{0F7C}\u{0F7C}\u{0F0B}",
            "",
        ),
        "uni0F470F7D=0+570|\
         uni0F0B=3+190"
    );
}

#[test]
fn tibetan_contractions_1_054() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F62}\u{0F97}\u{0F74}\u{0F7A}\u{0F53}\u{0F39}\u{0F0B}",
            "",
        ),
        "uni0F620F970F74=0+600|\
         uni0F7A=0+0|\
         uni0F53=4+590|\
         uni0F39=4+0|\
         uni0F0B=6+190"
    );
}

#[test]
fn tibetan_contractions_1_055() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F49}\u{0F74}\u{0F72}\u{0F0B}",
            "",
        ),
        "uni0F490F74=0+580|\
         uni0F72=0+0|\
         uni0F0B=3+190"
    );
}

#[test]
fn tibetan_contractions_1_056() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F49}\u{0F74}\u{0F72}\u{0F44}\u{0F0B}",
            "",
        ),
        "uni0F490F74=0+580|\
         uni0F72=0+0|\
         uni0F44=3+560|\
         uni0F0B=4@-20,0+110"
    );
}

#[test]
fn tibetan_contractions_1_057() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F58}\u{0F49}\u{0F72}\u{0F7E}\u{0F51}\u{0F0B}",
            "",
        ),
        "uni0F58=0+660|\
         uni0F49=1+580|\
         uni0F720F7E=1+0|\
         uni0F51=4+600|\
         uni0F0B=5@-70,0+106"
    );
}

#[test]
fn tibetan_contractions_1_058() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F42}\u{0F4F}\u{0F74}\u{0F72}\u{0F42}\u{0F0B}",
            "",
        ),
        "uni0F42=0+680|\
         uni0F4F0F740F72=1+600|\
         uni0F42=4+680|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_1_059() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F56}\u{0F4F}\u{0F44}\u{0F7C}\u{0F7E}\u{0F66}\u{0F0B}",
            "",
        ),
        "uni0F56=0+610|\
         uni0F4F=1+560|\
         uni0F44=2+560|\
         uni0F7C0F7E=2+0|\
         uni0F66=5+680|\
         uni0F0B=6+190"
    );
}

#[test]
fn tibetan_contractions_1_060() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a02a7f0ad42c2922cb37ad1358c9df4eb81f1bca.ttf",
            "\u{0F50}\u{0F39}\u{0F74}\u{0F7A}\u{0F4A}\u{0F0B}",
            "",
        ),
        "uni0F50=0+600|\
         uni0F39=0+0|\
         uni0F74=0+0|\
         uni0F7A=0+0|\
         uni0F4A=4+590|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_2_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F50}\u{0F74}\u{0F72}\u{0F53}\u{0F0B}",
            "",
        ),
        "uni0F500F74=0+600|\
         uni0F72=0+0|\
         uni0F53=3+590|\
         uni0F0B=4@-30,0+160"
    );
}

#[test]
fn tibetan_contractions_2_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F58}\u{0F50}\u{0F74}\u{0F7C}\u{0F44}\u{0F0B}",
            "",
        ),
        "uni0F58=0+660|\
         uni0F500F74=1+600|\
         uni0F7C=1+0|\
         uni0F44=4+560|\
         uni0F0B=5@-20,0+110"
    );
}

#[test]
fn tibetan_contractions_2_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F58}\u{0F50}\u{0F7C}\u{0F7A}\u{0F44}\u{0F0B}",
            "",
        ),
        "uni0F58=0+660|\
         uni0F50=1+600|\
         uni0F7C0F7A=1+0|\
         uni0F44=4+560|\
         uni0F0B=5@-20,0+110"
    );
}

#[test]
fn tibetan_contractions_2_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F58}\u{0F50}\u{0F7C}\u{0F72}\u{0F66}\u{0F0B}",
            "",
        ),
        "uni0F58=0+660|\
         uni0F50=1+600|\
         uni0F7C0F72=1+0|\
         uni0F66=4+680|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_2_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F51}\u{0F74}\u{0F62}\u{0FB2}\u{0F7C}\u{0F51}\u{0F0B}",
            "",
        ),
        "uni0F510F74=0+600|\
         uni0F620FB2=2+600|\
         uni0F7C=2+0|\
         uni0F51=5+600|\
         uni0F0B=6@-70,0+106"
    );
}

#[test]
fn tibetan_contractions_2_006() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F51}\u{0FB2}\u{0F74}\u{0F72}\u{0F42}\u{0F0B}",
            "",
        ),
        "uni0F510FB20F74=0+600|\
         uni0F72=0+0|\
         uni0F42=4+680|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_2_007() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F42}\u{0F51}\u{0F74}\u{0F7A}\u{0F53}\u{0F0B}",
            "",
        ),
        "uni0F42=0+680|\
         uni0F510F740F7A=1+600|\
         uni0F53=4+590|\
         uni0F0B=5@-30,0+160"
    );
}

#[test]
fn tibetan_contractions_2_008() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F56}\u{0F51}\u{0F7B}\u{0F42}\u{0F66}\u{0F0B}",
            "",
        ),
        "uni0F56=0+610|\
         uni0F510F7B=1+579|\
         uni0F42=3+680|\
         uni0F66=4+680|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_2_009() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F60}\u{0F51}\u{0F74}\u{0F7A}\u{0F51}\u{0F0B}",
            "",
        ),
        "uni0F60=0+600|\
         uni0F510F740F7A=1+600|\
         uni0F51=4+600|\
         uni0F0B=5@-70,0+106"
    );
}

#[test]
fn tibetan_contractions_2_010() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F62}\u{0FA1}\u{0F7C}\u{0F7A}\u{0F0B}",
            "",
        ),
        "uni0F620FA10F7C0F7A=0+580|\
         uni0F0B=4+190"
    );
}

#[test]
fn tibetan_contractions_2_011() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F66}\u{0FA1}\u{0F74}\u{0F72}\u{0F56}\u{0F0B}",
            "",
        ),
        "uni0F660FA10F74=0+680|\
         uni0F72=0+0|\
         uni0F56=4+610|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_2_012() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F53}\u{0F74}\u{0F7C}\u{0F42}\u{0F66}\u{0F0B}",
            "",
        ),
        "uni0F530F74=0+600|\
         uni0F7C=0+0|\
         uni0F42=3+680|\
         uni0F66=4+680|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_2_013() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F53}\u{0F74}\u{0F7C}\u{0F62}\u{0F0B}",
            "",
        ),
        "uni0F530F74=0+600|\
         uni0F7C=0+0|\
         uni0F62=3+620|\
         uni0F0B=4@-65,0+130"
    );
}

#[test]
fn tibetan_contractions_2_014() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F42}\u{0F53}\u{0FB1}\u{0F7C}\u{0F7E}\u{0F62}\u{0F0B}",
            "",
        ),
        "uni0F42=0+680|\
         uni0F530FB1=1+600|\
         uni0F7C0F7E=1+0|\
         uni0F62=5+620|\
         uni0F0B=6@-65,0+130"
    );
}

#[test]
fn tibetan_contractions_2_015() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F51}\u{0F54}\u{0F74}\u{0F7C}\u{0F42}\u{0F66}\u{0F0B}",
            "",
        ),
        "uni0F51=0+600|\
         uni0F540F74=1+610|\
         uni0F7C=1+0|\
         uni0F42=4+680|\
         uni0F66=5+680|\
         uni0F0B=6+190"
    );
}

#[test]
fn tibetan_contractions_2_016() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F56}\u{0FB1}\u{0F74}\u{0F7E}\u{0F56}\u{0F0B}",
            "",
        ),
        "uni0F560FB10F74=0+620|\
         uni0F7E=0+0|\
         uni0F56=4+610|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_2_017() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F56}\u{0FB3}\u{0F74}\u{0F7C}\u{0F53}\u{0F0B}",
            "",
        ),
        "uni0F560FB30F74=0+650|\
         uni0F7C=0+0|\
         uni0F53=4+590|\
         uni0F0B=5@-30,0+160"
    );
}

#[test]
fn tibetan_contractions_2_018() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F56}\u{0FB3}\u{0F7C}\u{0F7C}\u{0F53}\u{0F0B}",
            "",
        ),
        "uni0F560FB3=0+650|\
         uni0F7D=0+0|\
         uni0F53=4+590|\
         uni0F0B=5@-30,0+160"
    );
}

#[test]
fn tibetan_contractions_2_019() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F51}\u{0F56}\u{0F74}\u{0F7C}\u{0F51}\u{0F0B}",
            "",
        ),
        "uni0F51=0+600|\
         uni0F560F74=1+610|\
         uni0F7C=1+0|\
         uni0F51=4+600|\
         uni0F0B=5@-70,0+106"
    );
}

#[test]
fn tibetan_contractions_2_020() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F51}\u{0F56}\u{0F74}\u{0F7C}\u{0F56}\u{0F66}\u{0F0B}",
            "",
        ),
        "uni0F51=0+600|\
         uni0F560F74=1+610|\
         uni0F7C=1+0|\
         uni0F56=4+610|\
         uni0F66=5+680|\
         uni0F0B=6+190"
    );
}

#[test]
fn tibetan_contractions_2_021() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F58}\u{0F74}\u{0F7A}\u{0F42}\u{0F66}\u{0F0B}",
            "",
        ),
        "uni0F580F74=0+680|\
         uni0F7A=0+0|\
         uni0F42=3+680|\
         uni0F66=4+680|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_2_022() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F58}\u{0F74}\u{0F72}\u{0F42}\u{0F0B}",
            "",
        ),
        "uni0F580F74=0+680|\
         uni0F72=0+0|\
         uni0F42=3+680|\
         uni0F0B=4+190"
    );
}

#[test]
fn tibetan_contractions_2_023() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F58}\u{0F74}\u{0F7A}\u{0F42}\u{0F66}\u{0F0B}",
            "",
        ),
        "uni0F580F74=0+680|\
         uni0F7A=0+0|\
         uni0F42=3+680|\
         uni0F66=4+680|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_2_024() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F58}\u{0F74}\u{0F7A}\u{0F53}\u{0F0B}",
            "",
        ),
        "uni0F580F74=0+680|\
         uni0F7A=0+0|\
         uni0F53=3+590|\
         uni0F0B=4@-30,0+160"
    );
}

#[test]
fn tibetan_contractions_2_025() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F58}\u{0F9F}\u{0F7C}\u{0F7A}\u{0F42}\u{0F0B}",
            "",
        ),
        "uni0F580F9F0F7C0F7A=0+660|\
         uni0F42=4+680|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_2_026() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F58}\u{0F7C}\u{0F7A}\u{0F44}\u{0F0B}",
            "",
        ),
        "uni0F58=0+660|\
         uni0F7C0F7A=0+0|\
         uni0F44=3+560|\
         uni0F0B=4@-20,0+110"
    );
}

#[test]
fn tibetan_contractions_2_027() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F42}\u{0F59}\u{0F74}\u{0F7C}\u{0F62}\u{0F0B}",
            "",
        ),
        "uni0F42=0+680|\
         uni0F590F74=1+620|\
         uni0F7C=1+0|\
         uni0F62=4+620|\
         uni0F0B=5@-65,0+130"
    );
}

#[test]
fn tibetan_contractions_2_028() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F58}\u{0F5A}\u{0FAE}\u{0F74}\u{0F7E}\u{0F66}\u{0F0B}",
            "",
        ),
        "uni0F58=0+660|\
         uni0F5A0FAE0F740F7E=1+620|\
         uni0F66=5+680|\
         uni0F0B=6+190"
    );
}

#[test]
fn tibetan_contractions_2_029() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F62}\u{0FAB}\u{0F74}\u{0F7A}\u{0F66}\u{0F0B}",
            "",
        ),
        "uni0F620FAB0F74=0+660|\
         uni0F7A=0+0|\
         uni0F66=4+680|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_2_030() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F62}\u{0FAB}\u{0F74}\u{0F7A}\u{0F53}\u{0F0B}",
            "",
        ),
        "uni0F620FAB0F74=0+660|\
         uni0F7A=0+0|\
         uni0F53=4+590|\
         uni0F0B=5@-30,0+160"
    );
}

#[test]
fn tibetan_contractions_2_031() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F5E}\u{0F74}\u{0F7C}\u{0F63}\u{0F0B}",
            "",
        ),
        "uni0F5E0F74=0+660|\
         uni0F7C=0+0|\
         uni0F63=3+700|\
         uni0F0B=4+190"
    );
}

#[test]
fn tibetan_contractions_2_032() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F42}\u{0F5E}\u{0F74}\u{0F7C}\u{0F42}\u{0F0B}",
            "",
        ),
        "uni0F42=0+680|\
         uni0F5E0F74=1+660|\
         uni0F7C=1+0|\
         uni0F42=4+680|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_2_033() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F42}\u{0F5E}\u{0F74}\u{0F7C}\u{0F58}\u{0F66}\u{0F0B}",
            "",
        ),
        "uni0F42=0+680|\
         uni0F5E0F74=1+660|\
         uni0F7C=1+0|\
         uni0F58=4+660|\
         uni0F66=5+680|\
         uni0F0B=6+190"
    );
}

#[test]
fn tibetan_contractions_2_034() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F42}\u{0F5F}\u{0F74}\u{0F7C}\u{0F0B}",
            "",
        ),
        "uni0F42=0+680|\
         uni0F5F0F74=1+610|\
         uni0F7C=1+0|\
         uni0F0B=4+190"
    );
}

#[test]
fn tibetan_contractions_2_035() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F42}\u{0F5F}\u{0F74}\u{0F72}\u{0F44}\u{0F0B}",
            "",
        ),
        "uni0F42=0+680|\
         uni0F5F0F740F72=1+610|\
         uni0F44=4+560|\
         uni0F0B=5@-20,0+110"
    );
}

#[test]
fn tibetan_contractions_2_036() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F42}\u{0F5F}\u{0F74}\u{0F7A}\u{0F62}\u{0F0B}",
            "",
        ),
        "uni0F42=0+680|\
         uni0F5F0F74=1+610|\
         uni0F7A=1+0|\
         uni0F62=4+620|\
         uni0F0B=5@-65,0+130"
    );
}

#[test]
fn tibetan_contractions_2_037() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F42}\u{0F5F}\u{0F74}\u{0F7A}\u{0F62}\u{0F0B}",
            "",
        ),
        "uni0F42=0+680|\
         uni0F5F0F74=1+610|\
         uni0F7A=1+0|\
         uni0F62=4+620|\
         uni0F0B=5@-65,0+130"
    );
}

#[test]
fn tibetan_contractions_2_038() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F42}\u{0F5F}\u{0F74}\u{0F7A}\u{0F51}\u{0F0B}",
            "",
        ),
        "uni0F42=0+680|\
         uni0F5F0F74=1+610|\
         uni0F7A=1+0|\
         uni0F51=4+600|\
         uni0F0B=5@-70,0+106"
    );
}

#[test]
fn tibetan_contractions_2_039() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F60}\u{0F7C}\u{0F7A}\u{0F62}\u{0F0B}",
            "",
        ),
        "uni0F60=0+600|\
         uni0F7C0F7A=0+0|\
         uni0F62=3+620|\
         uni0F0B=4@-65,0+130"
    );
}

#[test]
fn tibetan_contractions_2_040() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F61}\u{0F72}\u{0F7A}\u{0F0B}",
            "",
        ),
        "uni0F61=0+700|\
         uni0F720F7A=0+0|\
         uni0F0B=3+190"
    );
}

#[test]
fn tibetan_contractions_2_041() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F61}\u{0F7A}\u{0F7A}\u{0F66}\u{0F0B}",
            "",
        ),
        "uni0F61=0+700|\
         uni0F7B=0+0|\
         uni0F66=3+680|\
         uni0F0B=4+190"
    );
}

#[test]
fn tibetan_contractions_2_042() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F62}\u{0F72}\u{0F53}\u{0F7C}\u{0F7A}\u{0F0B}",
            "",
        ),
        "uni0F620F72=0+620|\
         uni0F530F7C0F7A=2+590|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_2_043() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F62}\u{0F74}\u{0F7C}\u{0F63}\u{0F0B}",
            "",
        ),
        "uni0F620F74=0+601|\
         uni0F7C=0+0|\
         uni0F63=3+700|\
         uni0F0B=4+190"
    );
}

#[test]
fn tibetan_contractions_2_044() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F66}\u{0F7A}\u{0F7E}\u{0F53}\u{0F0B}",
            "",
        ),
        "uni0F66=0+680|\
         uni0F7A0F7E=0+0|\
         uni0F53=3+590|\
         uni0F0B=4@-30,0+160"
    );
}

#[test]
fn tibetan_contractions_2_045() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F66}\u{0F7A}\u{0F7E}\u{0F51}\u{0F60}\u{0F0B}",
            "",
        ),
        "uni0F66=0+680|\
         uni0F7A0F7E=0+0|\
         uni0F51=3+600|\
         uni0F60=4+600|\
         uni0F0B=5@-40,0+150"
    );
}

#[test]
fn tibetan_contractions_2_046() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F66}\u{0F7C}\u{0F7C}\u{0F56}\u{0F0B}",
            "",
        ),
        "uni0F660F7D=0+680|\
         uni0F56=3+610|\
         uni0F0B=4+190"
    );
}

#[test]
fn tibetan_contractions_2_047() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F66}\u{0F7C}\u{0F7C}\u{0F62}\u{0F0B}",
            "",
        ),
        "uni0F660F7D=0+680|\
         uni0F62=3+620|\
         uni0F0B=4@-65,0+130"
    );
}

#[test]
fn tibetan_contractions_2_048() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F66}\u{0FB2}\u{0F7C}\u{0F7A}\u{0F66}\u{0F0B}",
            "",
        ),
        "uni0F660FB2=0+680|\
         uni0F7C0F7A=0+0|\
         uni0F66=4+680|\
         uni0F0B=5+190"
    );
}

#[test]
fn tibetan_contractions_2_049() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F66}\u{0FB3}\u{0F7C}\u{0F7C}\u{0F51}\u{0F0B}",
            "",
        ),
        "uni0F660FB3=0+680|\
         uni0F7D=0+0|\
         uni0F51=4+600|\
         uni0F0B=5@-70,0+106"
    );
}

#[test]
fn tibetan_contractions_2_050() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F66}\u{0FB3}\u{0F7C}\u{0F7C}\u{0F53}\u{0F0B}",
            "",
        ),
        "uni0F660FB3=0+680|\
         uni0F7D=0+0|\
         uni0F53=4+590|\
         uni0F0B=5@-30,0+160"
    );
}

#[test]
fn tibetan_contractions_2_051() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F56}\u{0F66}\u{0F99}\u{0F7C}\u{0F7E}\u{0F51}\u{0F66}\u{0F0B}",
            "",
        ),
        "uni0F56=0+610|\
         uni0F660F99=1+670|\
         uni0F7C0F7E=1+0|\
         uni0F51=5+600|\
         uni0F66=6+680|\
         uni0F0B=7+190"
    );
}

#[test]
fn tibetan_contractions_2_052() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F63}\u{0FB7}\u{0FB1}\u{0F7C}\u{0F42}\u{0F66}\u{0F0B}",
            "",
        ),
        "uni0F630FB70FB1=0+680|\
         uni0F7C=0+0|\
         uni0F42=4+680|\
         uni0F66=5+680|\
         uni0F0B=6+190"
    );
}

#[test]
fn tibetan_contractions_2_053() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2de1ab4907ab688c0cfc236b0bf51151db38bf2e.ttf",
            "\u{0F68}\u{0FB1}\u{0F7C}\u{0F53}\u{0F0B}",
            "",
        ),
        "uni0F680FB1=0+740|\
         uni0F7C=0+0|\
         uni0F53=3+590|\
         uni0F0B=4@-30,0+160"
    );
}

#[test]
fn tibetan_vowels_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/82f4f3b57bb55344e72e70231380202a52af5805.ttf",
            "\u{0F68}\u{0F72}",
            "",
        ),
        "uni0F680F72=0+730"
    );
}

#[test]
fn tibetan_vowels_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/82f4f3b57bb55344e72e70231380202a52af5805.ttf",
            "\u{0F68}\u{0F74}",
            "",
        ),
        "uni0F680F74=0+730"
    );
}

#[test]
fn tibetan_vowels_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/82f4f3b57bb55344e72e70231380202a52af5805.ttf",
            "\u{0F68}\u{0F7A}",
            "",
        ),
        "uni0F680F7A=0+730"
    );
}

#[test]
fn tibetan_vowels_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/82f4f3b57bb55344e72e70231380202a52af5805.ttf",
            "\u{0F68}\u{0F7C}",
            "",
        ),
        "uni0F680F7C=0+730"
    );
}

#[test]
fn tibetan_vowels_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/82f4f3b57bb55344e72e70231380202a52af5805.ttf",
            "\u{0F68}\u{0F71}\u{0F72}",
            "",
        ),
        "uni0F680F710F72=0+720"
    );
}

#[test]
fn tibetan_vowels_006() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/82f4f3b57bb55344e72e70231380202a52af5805.ttf",
            "\u{0F68}\u{0F71}\u{0F74}",
            "",
        ),
        "uni0F680F75=0+720"
    );
}

#[test]
fn tibetan_vowels_007() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/82f4f3b57bb55344e72e70231380202a52af5805.ttf",
            "\u{0F68}\u{0F7B}",
            "",
        ),
        "uni0F680F7B=0+720"
    );
}

#[test]
fn tibetan_vowels_008() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/82f4f3b57bb55344e72e70231380202a52af5805.ttf",
            "\u{0F68}\u{0F7D}",
            "",
        ),
        "uni0F680F7D=0+730"
    );
}

#[test]
fn tibetan_vowels_009() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/82f4f3b57bb55344e72e70231380202a52af5805.ttf",
            "\u{0F68}\u{0F7E}",
            "",
        ),
        "uni0F680F7E=0+730"
    );
}

#[test]
fn tibetan_vowels_010() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/82f4f3b57bb55344e72e70231380202a52af5805.ttf",
            "\u{0F68}\u{0F7F}",
            "",
        ),
        "uni0F68=0+730|\
         uni0F7F=0+408"
    );
}

#[test]
fn tibetan_vowels_011() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/82f4f3b57bb55344e72e70231380202a52af5805.ttf",
            "\u{0F00}",
            "",
        ),
        "uni0F00=0+730"
    );
}

#[test]
fn use_indic3_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3c96e7a303c58475a8c750bf4289bbe73784f37d.ttf",
            "\u{0C95}\u{0CCD}\u{0CB0}",
            "",
        ),
        "uni0C95=0+1176|\
         uni0CB0_uni0CCD.blwf=0+275"
    );
}

#[test]
fn use_marchen_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8F}",
            "",
        ),
        "u11C8F=0+3000"
    );
}

#[test]
fn use_marchen_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C71}",
            "",
        ),
        "u11C71=0+1600"
    );
}

#[test]
fn use_marchen_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8A}\u{11CB5}",
            "",
        ),
        "u11C8A=0+2000|\
         u11CB5=0@-2000,0+0"
    );
}

#[test]
fn use_marchen_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C84}\u{11C71}",
            "",
        ),
        "u11C84=0+2200|\
         u11C71=1+1600"
    );
}

#[test]
fn use_marchen_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C7E}\u{11C8A}",
            "",
        ),
        "u11C7E=0+2600|\
         u11C8A=1+2000"
    );
}

#[test]
fn use_marchen_006() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8A}\u{11C92}\u{11CA9}",
            "",
        ),
        "u11C8A.11C92.11CA9=0+2600"
    );
}

#[test]
fn use_marchen_007() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8A}\u{11C94}\u{11CA9}",
            "",
        ),
        "u11C8A.11C94.11CA9=0+2600"
    );
}

#[test]
fn use_marchen_008() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8D}\u{11C92}\u{11CA9}",
            "",
        ),
        "u11C8D.11C92.11CA9=0+2600"
    );
}

#[test]
fn use_marchen_009() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8D}\u{11C94}\u{11CA9}",
            "",
        ),
        "u11C8D.11C94.11CA9=0+2600"
    );
}

#[test]
fn use_marchen_010() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8D}\u{11C9E}\u{11CA9}",
            "",
        ),
        "u11C8D.11C9E.11CA9=0+3200"
    );
}

#[test]
fn use_marchen_011() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8D}\u{11CA0}\u{11CA9}",
            "",
        ),
        "u11C8D.11CA0.11CA9=0+3000"
    );
}

#[test]
fn use_marchen_012() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8D}\u{11C92}\u{11CAA}",
            "",
        ),
        "u11C8D.11C92.11CAA=0+2000"
    );
}

#[test]
fn use_marchen_013() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8D}\u{11C94}\u{11CAA}",
            "",
        ),
        "u11C8D.11C94.11CAA=0+2000"
    );
}

#[test]
fn use_marchen_014() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8D}\u{11C9D}\u{11CAA}",
            "",
        ),
        "u11C8D.11C9D.11CAA=0+2000"
    );
}

#[test]
fn use_marchen_015() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8D}\u{11C9E}\u{11CAA}",
            "",
        ),
        "u11C8D.11C9E.11CAA=0+2600"
    );
}

#[test]
fn use_marchen_016() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8D}\u{11CA0}\u{11CAA}",
            "",
        ),
        "u11C8D.11CA0.11CAA=0+2400"
    );
}

#[test]
fn use_marchen_017() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C80}\u{11C72}\u{11CAA}",
            "",
        ),
        "u11C80=0+2400|\
         u11C72.11CAA=1+2000"
    );
}

#[test]
fn use_marchen_018() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8C}\u{11CB1}\u{11C8D}",
            "",
        ),
        "u11C8C.11CB1=0+2793|\
         u11C8D=2+2000"
    );
}

#[test]
fn use_marchen_019() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C80}\u{11C7C}\u{11CB3}",
            "",
        ),
        "u11C80=0+2400|\
         u11C7C.11CB3=1+2200"
    );
}

#[test]
fn use_marchen_020() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C7F}\u{11CB2}\u{11C7D}",
            "",
        ),
        "u11C7F.11CB2=0+2400|\
         u11C7D=2+2000"
    );
}

#[test]
fn use_marchen_021() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8D}\u{11CB2}\u{11C81}",
            "",
        ),
        "u11C8D.11CB2=0+2000|\
         u11C81=2+2400"
    );
}

#[test]
fn use_marchen_022() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8C}\u{11CB4}\u{11C74}",
            "",
        ),
        "u11C8C.11CB4=0+2800|\
         u11C74=2+2000"
    );
}

#[test]
fn use_marchen_023() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8A}\u{11CA1}\u{11CA9}\u{11C71}",
            "",
        ),
        "u11C8A.11CA1.11CA9=0+3000|\
         u11C71=3+1600"
    );
}

#[test]
fn use_marchen_024() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8D}\u{11CA1}\u{11CA9}\u{11C71}",
            "",
        ),
        "u11C8D.11CA1.11CA9=0+3000|\
         u11C71=3+1600"
    );
}

#[test]
fn use_marchen_025() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8D}\u{11CA1}\u{11CAA}\u{11C71}",
            "",
        ),
        "u11C8D.11CA1.11CAA=0+2400|\
         u11C71=3+1600"
    );
}

#[test]
fn use_marchen_026() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8F}\u{11CB0}\u{11CB4}\u{11CB6}",
            "",
        ),
        "u11C8F.11CB0.11CB4=0+3600|\
         u11CB6=0@-3200,0+0"
    );
}

#[test]
fn use_marchen_027() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8E}\u{11CB0}\u{11CB2}\u{11CB5}",
            "",
        ),
        "u11C8E.11CB0.11CB2=0+2000|\
         u11CB5=0@-2000,0+0"
    );
}

#[test]
fn use_marchen_028() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C74}\u{11C89}\u{11CB2}\u{11C75}",
            "",
        ),
        "u11C74=0+2000|\
         u11C89.11CB2=1+2000|\
         u11C75=3+2000"
    );
}

#[test]
fn use_marchen_029() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C7C}\u{11CAA}\u{11CB2}\u{11C75}",
            "",
        ),
        "u11C7C.11CAA.11CB2=0+2200|\
         u11C75=3+2000"
    );
}

#[test]
fn use_marchen_030() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C81}\u{11C74}\u{11CB2}\u{11C8B}",
            "",
        ),
        "u11C81=0+2400|\
         u11C74.11CB2=1+2000|\
         u11C8B=3+2400"
    );
}

#[test]
fn use_marchen_031() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8B}\u{11CB3}\u{11C74}\u{11C8D}",
            "",
        ),
        "u11C8B.11CB3=0+2400|\
         u11C74=2+2000|\
         u11C8D=3+2000"
    );
}

#[test]
fn use_marchen_032() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C83}\u{11CB4}\u{11C74}\u{11C8D}",
            "",
        ),
        "u11C83.11CB4=0+2800|\
         u11C74=2+2000|\
         u11C8D=3+2000"
    );
}

#[test]
fn use_marchen_033() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C8B}\u{11CB3}\u{11C74}\u{11C8D}\u{11C71}",
            "",
        ),
        "u11C8B.11CB3=0+2400|\
         u11C74=2+2000|\
         u11C8D=3+2000|\
         u11C71=4+1600"
    );
}

#[test]
fn use_marchen_034() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C80}\u{11C76}\u{11CB1}\u{11C75}\u{11C8D}",
            "",
        ),
        "u11C80=0+2400|\
         u11C76.11CB1=1+3200|\
         u11C75=3+2000|\
         u11C8D=4+2000"
    );
}

#[test]
fn use_marchen_035() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/85414f2552b654585b7a8d13dcc3e8fd9f7970a3.ttf",
            "\u{11C80}\u{11C8D}\u{11C94}\u{11CAA}\u{11CB1}\u{11C74}\u{11C8D}",
            "",
        ),
        "u11C80=0+2400|\
         u11C8D.11C94.11CAA.11CB1.shorti=1+2600|\
         u11C74=5+2000|\
         u11C8D=6+2000"
    );
}

#[test]
fn use_syllable_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/96490dd2ff81233b335a650e7eb660e0e7b2eeea.ttf",
            "\u{AA00}\u{AA2D}\u{AA29}",
            "",
        ),
        "a_cham=0+1121|\
         uSign_cham=0@14,0+0|\
         .notdef=0+600"
    );
}

#[test]
fn use_syllable_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/e68a88939e0f06e34d2bc911f09b70890289c8fd.ttf",
            "\u{AA00}\u{AA34}\u{AA36}",
            "",
        ),
        "raMedial_cham_pre=0+400|\
         a_cham=0+1121|\
         waMedial_cham=0@-32,0+0"
    );
}

#[test]
fn use_syllable_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/e68a88939e0f06e34d2bc911f09b70890289c8fd.ttf",
            "\u{AA00}\u{AA35}\u{AA33}",
            "",
        ),
        "a_cham=0+1121|\
         laMedial_cham=0@-32,0+0|\
         yaMedial_cham=0+542"
    );
}

#[test]
fn use_syllable_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/e68a88939e0f06e34d2bc911f09b70890289c8fd.ttf",
            "\u{AA00}\u{AA35}\u{AA36}",
            "",
        ),
        "a_cham=0+1121|\
         laMedial_waMedial_cham=0@43,0+0"
    );
}

#[test]
fn use_syllable_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/074a5ae6b19de8f29772fdd5df2d3d833f81f5e6.ttf",
            "\u{11320}\u{20F0}\u{11367}",
            "--no-glyph-names",
        ),
        "3=0+502|\
         1=0@33,0+0|\
         4=0@300,8+0"
    );
}

#[test]
fn use_syllable_006() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/373e67bf41ca264e260a9716162b71a23549e885.ttf",
            "\u{A8AC}\u{A8B4}\u{A8B5}",
            "--no-glyph-names",
        ),
        "2=0+377|\
         3=0+242|\
         4=0+210"
    );
}

#[test]
fn use_syllable_007() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/59a585a63b3df608fbeef00956c8c108deec7de6.ttf",
            "\u{1BC7}\u{1BEA}\u{1BF3}",
            "--no-glyph-names",
        ),
        "1=0+749|\
         2=0+402|\
         4=0+535|\
         3=0+401"
    );
}

#[test]
fn use_syllable_008() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/1ed7e9064f008f62de6ff0207bb4dd29409597a5.ttf",
            "\u{11064}\u{1107F}\u{11052}\u{11065}\u{1107F}\u{11053}",
            "",
        ),
        "brm_num100.1=0+2224|\
         brm_num1000.2=3+1834"
    );
}

#[test]
fn use_syllable_009() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/28f497629c04ceb15546c9a70e0730125ed6698d.ttf",
            "\u{11013}\u{11042}\u{11046}",
            "",
        ),
        "brm_KA=0+754|\
         brm_vowelEE=0@-383,0+0|\
         brm_virama=0@-524,0+0"
    );
}

#[test]
fn use_syllable_010() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/28f497629c04ceb15546c9a70e0730125ed6698d.ttf",
            "\u{11013}\u{11044}\u{11046}",
            "",
        ),
        "brm_KA=0+754|\
         brm_vowelOO=0@-647,0+0|\
         brm_virama=0@-524,0+0"
    );
}

#[test]
fn use_syllable_011() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/28f497629c04ceb15546c9a70e0730125ed6698d.ttf",
            "\u{11013}\u{1103C}",
            "",
        ),
        "brm_KA=0+754|\
         brm_vowelU=0@-403,0+0"
    );
}

#[test]
fn use_syllable_012() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/86cdd983c4e4c4d7f27dd405d6ceb7d4b9ed3d35.ttf",
            "\u{111C8}\u{111C9}\u{111C9}",
            "",
        ),
        "u111C8=0+500|\
         u111C9=0@-500,0+0|\
         u111C9=0@-500,0+0"
    );
}

#[test]
fn use_syllable_013() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3cc01fede4debd4b7794ccb1b16cdb9987ea7571.ttf",
            "\u{1A3D}\u{1A5A}\u{1A63}",
            "",
        ),
        "uni1A3D=0+250|\
         uni1A5A=0+0|\
         uni1A63=0+250"
    );
}

#[test]
fn use_syllable_014() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3cc01fede4debd4b7794ccb1b16cdb9987ea7571.ttf",
            "\u{1A3D}\u{1A60}\u{1A3D}\u{1A63}\u{1A60}\u{1A3D}\u{1A59}",
            "",
        ),
        "uni1A3D=0+250|\
         uni1A60=0+0|\
         uni1A3D=2+250|\
         uni1A63=2+250|\
         uni1A60=2+0|\
         uni1A3D=5+250|\
         uni1A59=5+0"
    );
}

#[test]
fn use_syllable_015() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3cc01fede4debd4b7794ccb1b16cdb9987ea7571.ttf",
            "\u{1A3D}\u{1A60}\u{1A3D}\u{1A63}\u{1A60}\u{1A3D}\u{1A5A}",
            "",
        ),
        "uni1A3D=0+250|\
         uni1A60=0+0|\
         uni1A3D=2+250|\
         uni1A63=2+250|\
         uni1A60=2+0|\
         uni1A3D=5+250|\
         uni25CC=5+250|\
         uni1A5A=5+0"
    );
}

#[test]
fn use_syllable_016() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/3cc01fede4debd4b7794ccb1b16cdb9987ea7571.ttf",
            "\u{1A3D}\u{1A60}\u{1A3D}\u{1A63}\u{1A60}\u{1A3D}\u{1A60}",
            "",
        ),
        "uni1A3D=0+250|\
         uni1A60=0+0|\
         uni1A3D=2+250|\
         uni1A63=2+250|\
         uni1A60=2+0|\
         uni1A3D=5+250|\
         uni1A60=5+0"
    );
}

#[test]
fn use_vowel_letter_spoofing_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0905}\u{093A}",
            "",
        ),
        "uni0905=0+500|\
         uni25CC=0+500|\
         uni093A=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0905}\u{093B}",
            "",
        ),
        "uni0905=0+500|\
         uni25CC=0+500|\
         uni093B=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0905}\u{093E}",
            "",
        ),
        "uni0905=0+500|\
         uni25CC=0+500|\
         uni093E=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0905}\u{0945}",
            "",
        ),
        "uni0905=0+500|\
         uni25CC=0+500|\
         uni0945=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0905}\u{0946}",
            "",
        ),
        "uni0905=0+500|\
         uni25CC=0+500|\
         uni0946=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_006() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0905}\u{0949}",
            "",
        ),
        "uni0905=0+500|\
         uni25CC=0+500|\
         uni0949=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_007() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0905}\u{094A}",
            "",
        ),
        "uni0905=0+500|\
         uni25CC=0+500|\
         uni094A=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_008() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0905}\u{094B}",
            "",
        ),
        "uni0905=0+500|\
         uni25CC=0+500|\
         uni094B=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_009() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0905}\u{094C}",
            "",
        ),
        "uni0905=0+500|\
         uni25CC=0+500|\
         uni094C=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_010() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0905}\u{094F}",
            "",
        ),
        "uni0905=0+500|\
         uni25CC=0+500|\
         uni094F=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_011() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0905}\u{0956}",
            "",
        ),
        "uni0905=0+500|\
         uni25CC=0+500|\
         uni0956=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_012() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0905}\u{0957}",
            "",
        ),
        "uni0905=0+500|\
         uni25CC=0+500|\
         uni0957=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_013() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0906}\u{093A}",
            "",
        ),
        "uni0906=0+500|\
         uni25CC=0+500|\
         uni093A=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_014() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0906}\u{0945}",
            "",
        ),
        "uni0906=0+500|\
         uni25CC=0+500|\
         uni0945=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_015() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0906}\u{0946}",
            "",
        ),
        "uni0906=0+500|\
         uni25CC=0+500|\
         uni0946=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_016() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0906}\u{0947}",
            "",
        ),
        "uni0906=0+500|\
         uni25CC=0+500|\
         uni0947=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_017() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0906}\u{0948}",
            "",
        ),
        "uni0906=0+500|\
         uni25CC=0+500|\
         uni0948=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_018() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0909}\u{0941}",
            "",
        ),
        "uni0909=0+500|\
         uni25CC=0+500|\
         uni0941=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_019() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{090F}\u{0945}",
            "",
        ),
        "uni090F=0+500|\
         uni25CC=0+500|\
         uni0945=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_020() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{090F}\u{0946}",
            "",
        ),
        "uni090F=0+500|\
         uni25CC=0+500|\
         uni0946=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_021() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{090F}\u{0947}",
            "",
        ),
        "uni090F=0+500|\
         uni25CC=0+500|\
         uni0947=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_022() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0930}\u{094D}\u{0907}",
            "",
        ),
        "uni0930=0+500|\
         uni094D=0+500|\
         uni25CC=2+500|\
         uni0907=2+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_023() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0985}\u{09BE}",
            "",
        ),
        "uni0985=0+500|\
         uni25CC=0+500|\
         .notdef=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_024() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{098B}\u{09C3}",
            "",
        ),
        "uni098B=0+500|\
         uni25CC=0+500|\
         uni09C3=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_025() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{098C}\u{09E2}",
            "",
        ),
        "uni098C=0+500|\
         uni25CC=0+500|\
         uni09E2=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_026() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0A05}\u{0A3E}",
            "",
        ),
        "uni0A05=0+500|\
         uni25CC=0+500|\
         uni0A3E=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_027() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0A05}\u{0A48}",
            "",
        ),
        "uni0A05=0+500|\
         uni25CC=0+500|\
         uni0A48=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_028() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0A05}\u{0A4C}",
            "",
        ),
        "uni0A05=0+500|\
         uni25CC=0+500|\
         uni0A4C=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_029() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0A72}\u{0A3F}",
            "",
        ),
        "uni0A72=0+500|\
         uni0A3F=0+500|\
         uni25CC=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_030() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0A72}\u{0A40}",
            "",
        ),
        "uni0A72=0+500|\
         uni25CC=0+500|\
         uni0A40=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_031() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0A72}\u{0A47}",
            "",
        ),
        "uni0A72=0+500|\
         uni25CC=0+500|\
         uni0A47=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_032() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0A73}\u{0A41}",
            "",
        ),
        "uni0A73=0+500|\
         uni25CC=0+500|\
         uni0A41=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_033() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0A73}\u{0A42}",
            "",
        ),
        "uni0A73=0+500|\
         uni25CC=0+500|\
         uni0A42=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_034() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0A73}\u{0A4B}",
            "",
        ),
        "uni0A73=0+500|\
         uni25CC=0+500|\
         uni0A4B=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_035() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0A85}\u{0ABE}\u{0AC5}",
            "",
        ),
        "uni0A85=0+500|\
         uni25CC=0+500|\
         uni0ABE=0+500|\
         uni25CC=0+500|\
         uni0AC5=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_036() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0A85}\u{0ABE}\u{0AC8}",
            "",
        ),
        "uni0A85=0+500|\
         uni25CC=0+500|\
         uni0ABE=0+500|\
         uni25CC=0+500|\
         uni0AC8=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_037() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0A85}\u{0ABE}",
            "",
        ),
        "uni0A85=0+500|\
         uni25CC=0+500|\
         uni0ABE=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_038() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0A85}\u{0AC5}",
            "",
        ),
        "uni0A85=0+500|\
         uni25CC=0+500|\
         uni0AC5=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_039() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0A85}\u{0AC7}",
            "",
        ),
        "uni0A85=0+500|\
         uni25CC=0+500|\
         uni0AC7=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_040() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0A85}\u{0AC8}",
            "",
        ),
        "uni0A85=0+500|\
         uni25CC=0+500|\
         uni0AC8=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_041() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0A85}\u{0AC9}",
            "",
        ),
        "uni0A85=0+500|\
         uni25CC=0+500|\
         uni0AC9=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_042() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0A85}\u{0ACB}",
            "",
        ),
        "uni0A85=0+500|\
         uni25CC=0+500|\
         uni0ACB=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_043() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0A85}\u{0ACC}",
            "",
        ),
        "uni0A85=0+500|\
         uni25CC=0+500|\
         uni0ACC=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_044() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0AC5}\u{0ABE}",
            "",
        ),
        "uni25CC=0+500|\
         uni0AC5=0+500|\
         uni25CC=0+500|\
         uni0ABE=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_045() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0B05}\u{0B3E}",
            "",
        ),
        "uni0B05=0+500|\
         uni25CC=0+500|\
         uni0B3E=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_046() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0B0F}\u{0B57}",
            "",
        ),
        "uni0B0F=0+500|\
         uni25CC=0+500|\
         uni0B57=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_047() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0B13}\u{0B57}",
            "",
        ),
        "uni0B13=0+500|\
         uni25CC=0+500|\
         uni0B57=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_048() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0C12}\u{0C4C}",
            "",
        ),
        "uni0C12=0+500|\
         uni25CC=0+500|\
         uni0C4C=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_049() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0C12}\u{0C55}",
            "",
        ),
        "uni0C12=0+500|\
         uni25CC=0+500|\
         uni0C55=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_050() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0C3F}\u{0C55}",
            "",
        ),
        "uni25CC=0+500|\
         uni0C3F=0+500|\
         uni25CC=0+500|\
         uni0C55=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_051() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0C46}\u{0C55}",
            "",
        ),
        "uni25CC=0+500|\
         uni0C46=0+500|\
         uni25CC=0+500|\
         uni0C55=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_052() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0C4A}\u{0C55}",
            "",
        ),
        "uni25CC=0+500|\
         uni0C4A=0+500|\
         uni25CC=0+500|\
         uni0C55=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_053() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0C89}\u{0CBE}",
            "",
        ),
        "uni0C89=0+500|\
         uni25CC=0+500|\
         uni0CBE=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_054() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0C8B}\u{0CBE}",
            "",
        ),
        "uni0C8B=0+500|\
         uni25CC=0+500|\
         uni0CBE=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_055() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0C92}\u{0CCC}",
            "",
        ),
        "uni0C92=0+500|\
         uni25CC=0+500|\
         uni0CCC=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_056() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0D07}\u{0D57}",
            "",
        ),
        "uni0D07=0+500|\
         uni25CC=0+500|\
         uni0D57=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_057() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0D09}\u{0D57}",
            "",
        ),
        "uni0D09=0+500|\
         uni25CC=0+500|\
         uni0D57=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_058() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0D0E}\u{0D46}",
            "",
        ),
        "uni0D0E=0+500|\
         uni0D46=0+500|\
         uni25CC=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_059() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0D12}\u{0D3E}",
            "",
        ),
        "uni0D12=0+500|\
         uni25CC=0+500|\
         uni0D3E=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_060() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0D12}\u{0D57}",
            "",
        ),
        "uni0D12=0+500|\
         uni25CC=0+500|\
         uni0D57=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_061() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0D85}\u{0DCF}",
            "",
        ),
        "uni0D85=0+500|\
         uni25CC=0+500|\
         uni0DCF=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_062() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0D85}\u{0DD0}",
            "",
        ),
        "uni0D85=0+500|\
         uni25CC=0+500|\
         uni0DD0=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_063() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0D85}\u{0DD1}",
            "",
        ),
        "uni0D85=0+500|\
         uni25CC=0+500|\
         uni0DD1=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_064() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0D8B}\u{0DDF}",
            "",
        ),
        "uni0D8B=0+500|\
         uni25CC=0+500|\
         uni0DDF=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_065() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0D8D}\u{0DD8}",
            "",
        ),
        "uni0D8D=0+500|\
         uni25CC=0+500|\
         uni0DD8=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_066() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0D8F}\u{0DDF}",
            "",
        ),
        "uni0D8F=0+500|\
         uni25CC=0+500|\
         uni0DDF=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_067() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0D91}\u{0DCA}",
            "",
        ),
        "uni0D91=0+500|\
         uni25CC=0+500|\
         uni0DCA=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_068() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0D91}\u{0DD9}",
            "",
        ),
        "uni0D91=0+500|\
         uni0DD9=0+500|\
         uni25CC=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_069() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0D91}\u{0DDA}",
            "",
        ),
        "uni0D91=0+500|\
         uni0DD9=0+500|\
         uni25CC=0+500|\
         uni0DCA=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_070() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0D91}\u{0DDC}",
            "",
        ),
        "uni0D91=0+500|\
         uni0DD9=0+500|\
         uni25CC=0+500|\
         uni0DCF=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_071() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0D91}\u{0DDD}",
            "",
        ),
        "uni0D91=0+500|\
         uni0DD9=0+500|\
         uni25CC=0+500|\
         uni0DCF=0+500|\
         uni0DCA=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_072() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0D91}\u{0DDD}",
            "",
        ),
        "uni0D91=0+500|\
         uni0DD9=0+500|\
         uni25CC=0+500|\
         uni0DCF=0+500|\
         uni0DCA=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_073() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{0D94}\u{0DDF}",
            "",
        ),
        "uni0D94=0+500|\
         uni25CC=0+500|\
         uni0DDF=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_074() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{11005}\u{11038}",
            "",
        ),
        "u11005=0+500|\
         uni25CC=0+500|\
         u11038=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_075() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{1100B}\u{1103E}",
            "",
        ),
        "u1100B=0+500|\
         uni25CC=0+500|\
         u1103E=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_076() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{1100F}\u{11042}",
            "",
        ),
        "u1100F=0+500|\
         uni25CC=0+500|\
         u11042=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_077() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{112B0}\u{112E0}",
            "",
        ),
        "u112B0=0+500|\
         uni25CC=0+500|\
         u112E0=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_078() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{112B0}\u{112E5}",
            "",
        ),
        "u112B0=0+500|\
         uni25CC=0+500|\
         u112E5=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_079() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{112B0}\u{112E6}",
            "",
        ),
        "u112B0=0+500|\
         uni25CC=0+500|\
         u112E6=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_080() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{112B0}\u{112E7}",
            "",
        ),
        "u112B0=0+500|\
         uni25CC=0+500|\
         u112E7=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_081() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{112B0}\u{112E8}",
            "",
        ),
        "u112B0=0+500|\
         uni25CC=0+500|\
         u112E8=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_082() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{11481}\u{114B0}",
            "",
        ),
        "u11481=0+500|\
         uni25CC=0+500|\
         u114B0=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_083() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{1148B}\u{114BA}",
            "",
        ),
        "u1148B=0+500|\
         uni25CC=0+500|\
         u114BA=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_084() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{1148D}\u{114BA}",
            "",
        ),
        "u1148D=0+500|\
         uni25CC=0+500|\
         u114BA=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_085() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{114AA}\u{114B5}",
            "",
        ),
        "u114AA=0+500|\
         uni25CC=0+500|\
         u114B5=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_086() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{114AA}\u{114B6}",
            "",
        ),
        "u114AA=0+500|\
         uni25CC=0+500|\
         u114B6=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_087() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{11600}\u{11639}",
            "",
        ),
        "u11600=0+500|\
         uni25CC=0+500|\
         u11639=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_088() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{11600}\u{1163A}",
            "",
        ),
        "u11600=0+500|\
         uni25CC=0+500|\
         u1163A=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_089() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{11601}\u{11639}",
            "",
        ),
        "u11601=0+500|\
         uni25CC=0+500|\
         u11639=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_090() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{11601}\u{1163A}",
            "",
        ),
        "u11601=0+500|\
         uni25CC=0+500|\
         u1163A=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_091() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{11680}\u{116AD}",
            "",
        ),
        "u11680=0+500|\
         uni25CC=0+500|\
         u116AD=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_092() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{11680}\u{116B4}",
            "",
        ),
        "u11680=0+500|\
         uni25CC=0+500|\
         u116B4=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_093() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{11680}\u{116B5}",
            "",
        ),
        "u11680=0+500|\
         uni25CC=0+500|\
         u116B5=0+500"
    );
}

#[test]
fn use_vowel_letter_spoofing_094() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/46669c8860cbfea13562a6ca0d83130ee571137b.ttf",
            "\u{11686}\u{116B2}",
            "",
        ),
        "u11686=0+500|\
         uni25CC=0+500|\
         u116B2=0+500"
    );
}

#[test]
fn use_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/fbb6c84c9e1fe0c39e152fbe845e51fd81f6748e.ttf",
            "\u{1B1B}\u{1B44}\u{1B13}\u{1B3E}",
            "",
        ),
        "gid3=0+990|\
         gid7=0+2473|\
         gid5=0@-293,-400+0"
    );
}

#[test]
fn use_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4cce528e99f600ed9c25a2b69e32eb94a03b4ae8.ttf",
            "\u{1A48}\u{1A58}\u{1A25}\u{1A48}\u{1A58}\u{1A25}\u{1A6E}\u{1A63}",
            "",
        ),
        "uni1A48=0+1212|\
         uni1A25=0+1912|\
         uni1A58=0+0|\
         uni1A48=3+1212|\
         uni1A6E=3+0|\
         uni1A25=3+1912|\
         uni1A58=3+0|\
         uni1A63=3+1212"
    );
}

#[test]
fn use_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/f518eb6f6b5eec2946c9fbbbde44e45d46f5e2ac.ttf",
            "\u{1A48}\u{1A58}\u{1A25}\u{1A48}\u{1A58}\u{1A25}\u{1A6E}\u{1A63}",
            "",
        ),
        "uni1A48=0+1212|\
         uni1A25=0+1912|\
         uni1A58=0+0|\
         uni1A48=3+1212|\
         uni1A6E=3+1211|\
         uni1A25=3+1912|\
         uni1A58=3+0|\
         uni1A63=3+1212"
    );
}

#[test]
fn use_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/6ff0fbead4462d9f229167b4e6839eceb8465058.ttf",
            "\u{11103}\u{11128}",
            "",
        ),
        "u11103=0+837|\
         u11128=0+0"
    );
}

#[test]
fn use_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2a670df15b73a5dc75a5cc491bde5ac93c5077dc.ttf",
            "\u{11124}\u{1112E}",
            "",
        ),
        "u11124=0+514|\
         u11131=0+0|\
         u11127=0+0"
    );
}

#[test]
fn use_006() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2a670df15b73a5dc75a5cc491bde5ac93c5077dc.ttf",
            "\u{11124}\u{11131}\u{11127}",
            "",
        ),
        "u11124=0+514|\
         u11131=0+0|\
         u11127=0+0"
    );
}

#[test]
fn use_007() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2a670df15b73a5dc75a5cc491bde5ac93c5077dc.ttf",
            "\u{11124}\u{11127}\u{11131}",
            "",
        ),
        "u11124=0+514|\
         u11127=0+0|\
         uni25CC=0+547|\
         u11131=0+0"
    );
}

#[test]
fn use_008() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2a670df15b73a5dc75a5cc491bde5ac93c5077dc.ttf",
            "\u{11124}\u{11134}\u{11131}",
            "",
        ),
        "u11124=0+514|\
         u11134=0+0|\
         u11131=0+0"
    );
}

#[test]
fn use_009() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/2a670df15b73a5dc75a5cc491bde5ac93c5077dc.ttf",
            "\u{11124}\u{11131}\u{11134}",
            "",
        ),
        "u11124=0+514|\
         u11131=0+0|\
         uni25CC=0+547|\
         u11134=0+0"
    );
}

#[test]
fn use_010() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/573d3a3177c9a8646e94c8a0d7b224334340946a.ttf",
            "\u{11410}\u{11442}\u{11411}\u{11440}\u{11443}\u{11410}\u{11442}\u{11411}\u{11441}\u{11443}",
            "",
        ),
        "E_dv.alt=0+275|\
         Ga.icd=0+367|\
         Gha.diag=0@100,0+386|\
         AA_dv.alt=0+208|\
         Candrabindu=0@17,-8+0|\
         E_dv.alt=5+275|\
         Ga.icd=5+367|\
         Gha.diag=5@100,0+386|\
         AU_dv_part.alt=5+213|\
         Candrabindu.sm=5@-52,179+0"
    );
}

#[test]
fn use_011() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/dcf774ca21062e7439f98658b18974ea8b956d0c.ttf",
            "\u{11328}\u{1134D}\u{1CF4}",
            "",
        ),
        "gid1=0+793|\
         gid2=0+0|\
         gid3=0+0"
    );
}

#[test]
fn use_012() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4afb0e8b9a86bb9bd73a1247de4e33fbe3c1fd93.ttf",
            "\u{1C00}\u{1C27}\u{1C28}\u{1C34}\u{1C35}",
            "",
        ),
        "uni1C35=0+500|\
         uni1C34=0+500|\
         uni1C28=0+500|\
         uni1C27=0+500|\
         uni1C00=0+500"
    );
}

#[test]
fn use_013() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4afb0e8b9a86bb9bd73a1247de4e33fbe3c1fd93.ttf",
            "\u{0D4E}\u{0D15}\u{0D4D}\u{0D15}\u{0D46}",
            "",
        ),
        "uni0D15=0+500|\
         uni0D4E=0+500|\
         uni0D4D=0+500|\
         uni0D46=3+500|\
         uni0D15=3+500"
    );
}

#[test]
fn use_014() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4afb0e8b9a86bb9bd73a1247de4e33fbe3c1fd93.ttf",
            "\u{1102D}\u{11046}\u{11013}\u{11046}\u{11013}\u{11046}",
            "",
        ),
        "u11013=0+500|\
         u11046_u11013=0+500|\
         u1102D_u11046=0+500|\
         u11046=0+500"
    );
}

#[test]
fn variations_rounding_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/HBTest-VF.ttf",
            "\u{0041}",
            "--variations=TEST=491",
        ),
        "A=0+496"
    );
}

#[test]
fn variations_rounding_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/HBTest-VF.ttf",
            "\u{0041}",
            "--variations=TEST=509",
        ),
        "A=0+505"
    );
}

#[test]
fn variations_rvrn_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=1",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=11",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=21",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=31",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=41",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_006() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=51",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_007() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=61",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_008() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=71",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_009() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=81",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_010() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=91",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_011() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=101",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_012() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=111",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_013() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=121",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_014() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=131",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_015() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=141",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_016() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=151",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_017() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=161",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_018() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=171",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_019() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=181",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_020() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=191",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_021() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=201",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_022() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=211",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_023() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=221",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_024() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=231",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_025() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=241",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_026() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=251",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_027() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=261",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_028() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=271",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_029() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=281",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_030() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=291",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_031() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=301",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_032() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=311",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_033() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=321",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_034() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=331",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_035() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=341",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_036() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=351",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_037() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=361",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_038() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=371",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_039() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=381",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_040() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=391",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_041() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=401",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_042() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=411",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_043() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=421",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_044() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=431",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_045() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=441",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_046() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=451",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_047() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=461",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_048() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=471",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_049() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=481",
        ),
        "rvrn_base=0+1529"
    );
}

#[test]
fn variations_rvrn_050() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=491",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_051() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=501",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_052() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=511",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_053() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=521",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_054() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=531",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_055() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=541",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_056() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=551",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_057() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=561",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_058() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=571",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_059() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=581",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_060() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=591",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_061() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=601",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_062() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=611",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_063() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=621",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_064() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=631",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_065() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=641",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_066() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=651",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_067() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=661",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_068() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=671",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_069() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=681",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_070() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=691",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_071() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=701",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_072() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=711",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_073() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=721",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_074() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=731",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_075() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=741",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_076() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=751",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_077() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=761",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_078() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=771",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_079() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=781",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_080() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=791",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_081() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=801",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_082() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=811",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_083() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=821",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_084() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=831",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_085() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=841",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_086() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=851",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_087() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=861",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_088() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=871",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_089() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=881",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_090() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=891",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_091() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=901",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_092() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=911",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_093() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=921",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_094() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=931",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_095() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=941",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_096() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=951",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_097() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=961",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_098() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=971",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_099() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=981",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_rvrn_100() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/d23d76ea0909c14972796937ba072b5a40c1e257.ttf",
            "\u{0072}",
            "--variations=FVTT=991",
        ),
        "rvrn_subst=0+1825"
    );
}

#[test]
fn variations_space_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/ab40c89624a6104e5d0a2308e448a989302f515b.ttf",
            "\u{0020}",
            "--variations=wdth=402",
        ),
        "space=0+639"
    );
}

#[test]
fn vertical_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/191826b9643e3f124d865d617ae609db6a2ce203.ttf",
            "\u{300C}",
            "--direction=t",
        ),
        "uni300C.vert=0@-512,-189+0,-1024"
    );
}

#[test]
fn vertical_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/f9b1dd4dcb515e757789a22cb4241107746fd3d0.ttf",
            "\u{0041}\u{0042}",
            "--direction=t",
        ),
        "gid1=0@-654,-1468+0,-2048|\
         gid2=1@-665,-1462+0,-2048"
    );
}

#[test]
fn vertical_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/f9b1dd4dcb515e757789a22cb4241107746fd3d0.ttf",
            "\u{0041}\u{0042}",
            "--direction=t",
        ),
        "gid1=0@-654,-1468+0,-2048|\
         gid2=1@-665,-1462+0,-2048"
    );
}

#[test]
fn vertical_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/4cbbc461be066fccc611dcc634af6e8cb2705537.ttf",
            "\u{FF38}",
            "--direction=t",
        ),
        "gid2=0@-500,-867+0,-1000"
    );
}

#[test]
fn zero_width_marks_001() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/bb9473d2403488714043bcfb946c9f78b86ad627.ttf",
            "\u{1030}",
            "",
        ),
        "circledash=0+636|\
         u1030.med=0@-162,0+0"
    );
}

#[test]
fn zero_width_marks_002() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/8454d22037f892e76614e1645d066689a0200e61.ttf",
            "\u{05E0}\u{05B8}\u{0591}\u{05DA}\u{05B0}",
            "",
        ),
        "uni05DA05B0=3+991|\
         uni2009=0+200|\
         uni0591=0@75,0+0|\
         uni05B8=0@495,0+0|\
         uni05E0=0+683"
    );
}

#[test]
fn zero_width_marks_003() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/45855bc8d46332b39c4ab9e2ee1a26b1f896da6b.ttf",
            "\u{0E01}\u{0E34}\u{0E01}",
            "",
        ),
        "gid1=0+1264|\
         gid2=0@20,0+0|\
         gid1=2+1264"
    );
}

#[test]
fn zero_width_marks_004() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/7a37dc4d5bf018456aea291cee06daf004c0221c.ttf",
            "\u{0E01}\u{0E34}\u{0E01}",
            "",
        ),
        "gid1=0+1264|\
         gid2=0@20,0+1000|\
         gid1=2+1264"
    );
}

#[test]
fn zero_width_marks_005() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/8099955657a54e9ee38a6ba1d6f950ce58e3cc25.ttf",
            "\u{0E01}\u{0E34}\u{0E01}",
            "",
        ),
        "gid1=0+1264|\
         gid2=0+0|\
         gid1=2+1264"
    );
}

#[test]
fn zero_width_marks_006() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/bb0c53752e85c3d28973ebc913287b8987d3dfe8.ttf",
            "\u{0E01}\u{0E34}\u{0E01}",
            "",
        ),
        "gid1=0+1264|\
         gid2=0+0|\
         gid1=2+1264"
    );
}

#[test]
fn zero_width_marks_007() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/ffa0f5d2d9025486d8469d8b1fdd983e7632499b.ttf",
            "\u{0058}\u{0303}\u{0078}\u{0303}\u{006A}\u{006A}\u{006A}\u{0303}\u{006A}\u{0303}\
             \u{006A}\u{006A}",
            "",
        ),
        "gid1=0+1200|\
         gid6=0@-1029,340+0|\
         gid3=2+1083|\
         gid6=2@-992,0+0|\
         gid2=4+528|\
         gid2=5+528|\
         gid5=6+528|\
         gid6=6@-693,0+0|\
         gid5=8+528|\
         gid6=8@-693,0+0|\
         gid2=10+528|\
         gid2=11+528"
    );
}

#[test]
fn zero_width_marks_008() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/cc5f3d2d717fb6bd4dfae1c16d48a2cb8e12233b.ttf",
            "\u{0058}\u{0303}\u{0078}\u{0303}\u{006A}\u{006A}\u{006A}\u{0303}\u{006A}\u{0303}\
             \u{006A}\u{006A}",
            "",
        ),
        "gid1=0+1200|\
         gid6=0@-1029,340+1200|\
         gid3=2+1083|\
         gid6=2@-992,0+1200|\
         gid2=4+528|\
         gid2=5+528|\
         gid5=6+528|\
         gid6=6@-693,0+1200|\
         gid5=8+528|\
         gid6=8@-693,0+1200|\
         gid2=10+528|\
         gid2=11+528"
    );
}

#[test]
fn zero_width_marks_009() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/fcdcffbdf1c4c97c05308d7600e4c283eb47dbca.ttf",
            "\u{0058}\u{0303}\u{0078}\u{0303}\u{006A}\u{006A}\u{006A}\u{0303}\u{006A}\u{0303}\
             \u{006A}\u{006A}",
            "",
        ),
        "gid1=0+1200|\
         gid6=0+0|\
         gid3=2+1083|\
         gid6=2+0|\
         gid2=4+528|\
         gid2=5+528|\
         gid5=6+528|\
         gid6=6+0|\
         gid5=8+528|\
         gid6=8+0|\
         gid2=10+528|\
         gid2=11+528"
    );
}

#[test]
fn zero_width_marks_010() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/56cfd0e18d07f41c38e9598545a6d369127fc6f9.ttf",
            "\u{0058}\u{0303}\u{0078}\u{0303}\u{006A}\u{006A}\u{006A}\u{0303}\u{006A}\u{0303}\
             \u{006A}\u{006A}",
            "",
        ),
        "gid1=0+1200|\
         gid6=0@-1029,340+0|\
         gid3=2+1083|\
         gid6=2@-992,0+0|\
         gid2=4+528|\
         gid2=5+528|\
         gid5=6+528|\
         gid6=6@-693,0+0|\
         gid5=8+528|\
         gid6=8@-693,0+0|\
         gid2=10+528|\
         gid2=11+528"
    );
}

#[test]
fn zero_width_marks_011() {
    assert_eq!(
        shape(
            "tests/fonts/in-house/a98e908e2ed21b22228ea59ebcc0f05034c86f2e.ttf",
            "\u{0041}\u{0042}\u{0041}",
            "",
        ),
        "A=0+1368|\
         B=1+0|\
         A=2+1368"
    );
}

