// WARNING: this file was generated by ../scripts/gen-shaping-tests.py

mod shaping_impl;
use shaping_impl::shape;

#[test]
fn classdef1_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/classdef1_font4.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         18|\
         19|\
         20|\
         21"
    );
}

#[test]
fn classdef1_empty_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/classdef1_font2.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         23|\
         24|\
         25|\
         21"
    );
}

#[test]
fn classdef1_multiple_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/classdef1_font3.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\
             \u{001B}\u{001C}\u{001D}\u{001E}\u{001F}\u{0020}\u{0021}\u{0022}\u{0023}\u{0024}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "20|\
         23|\
         24|\
         25|\
         24|\
         26|\
         27|\
         28|\
         28|\
         29|\
         30|\
         31|\
         34|\
         33|\
         34|\
         35|\
         37|\
         38|\
         38|\
         39"
    );
}

#[test]
fn classdef1_single_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/classdef2_font1.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         23|\
         24|\
         25|\
         21"
    );
}

#[test]
fn classdef2_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/classdef2_font4.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         18|\
         19|\
         20|\
         21"
    );
}

#[test]
fn classdef2_empty_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/classdef2_font2.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         23|\
         24|\
         25|\
         21"
    );
}

#[test]
fn classdef2_multiple_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/classdef2_font3.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\
             \u{001B}\u{001C}\u{001D}\u{001E}\u{001F}\u{0020}\u{0021}\u{0022}\u{0023}\u{0024}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "20|\
         23|\
         24|\
         25|\
         24|\
         26|\
         27|\
         28|\
         28|\
         29|\
         30|\
         31|\
         34|\
         33|\
         34|\
         35|\
         37|\
         38|\
         38|\
         39"
    );
}

#[test]
fn classdef2_single_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/classdef2_font1.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         23|\
         24|\
         25|\
         21"
    );
}

#[test]
fn gpos1_1_lookupflag_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos1_1_lookupflag_f1.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         18@1500,0|\
         19@3000,0|\
         20@4200,0|\
         21@6000,0"
    );
}

#[test]
fn gpos1_1_simple_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos1_1_simple_f1.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         18@1300,0|\
         19@3000,0|\
         20@4300,0|\
         21@6000,0"
    );
}

#[test]
fn gpos1_1_simple_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos1_1_simple_f2.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         18@1500,-200|\
         19@3000,0|\
         20@4500,-200|\
         21@6000,0"
    );
}

#[test]
fn gpos1_1_simple_003() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos1_1_simple_f3.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         18@1500,0|\
         19@2800,0|\
         20@4300,0|\
         21@5600,0"
    );
}

#[test]
fn gpos1_2_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos1_2_font1.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         18@1300,0|\
         19@3000,0|\
         20@4200,0|\
         21@6000,0"
    );
}

#[test]
fn gpos1_2_lookupflag_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos1_2_font2.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         18@1500,0|\
         19@3000,0|\
         20@4200,0|\
         21@6000,0"
    );
}

#[test]
fn gpos2_1_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos2_1_font6.otf",
            "\u{0011}\u{0012}\u{0013}\u{0011}\u{0012}\u{0014}\u{0011}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         18@1300,0|\
         19@3000,-100|\
         17@4500,0|\
         18@5700,0|\
         20@7500,-400|\
         17@9000,0"
    );
}

#[test]
fn gpos2_1_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos2_1_font7.otf",
            "\u{0011}\u{0012}\u{0013}\u{0011}\u{0012}\u{0014}\u{0011}\u{0015}\u{0016}\u{0011}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         18@1300,0|\
         19@3000,-100|\
         17@4500,0|\
         18@5700,0|\
         20@7500,-400|\
         17@9000,0|\
         21@10000,0|\
         22@12000,-600|\
         17@13500,0"
    );
}

#[test]
fn gpos2_1_lookupflag_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos2_1_lookupflag_f1.otf",
            "\u{0011}\u{0013}\u{0014}\u{0011}\u{0013}\u{0012}\u{0014}\u{0011}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         19@1300,0|\
         20@3000,-100|\
         17@4500,0|\
         19@5800,0|\
         18@7500,0|\
         20@9000,-100|\
         17@10500,0"
    );
}

#[test]
fn gpos2_1_lookupflag_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos2_1_lookupflag_f2.otf",
            "\u{0011}\u{0013}\u{0014}\u{0011}\u{0013}\u{0012}\u{0014}\u{0011}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         19@1500,0|\
         20@2800,-100|\
         17@4300,0|\
         19@5800,0|\
         18@7100,0|\
         20@8600,-100|\
         17@10100,0"
    );
}

#[test]
fn gpos2_1_next_glyph_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos2_1_next_glyph_f1.otf",
            "\u{0012}\u{0012}\u{0012}\u{0012}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "18@-100,0|\
         18@1500,-100|\
         18@2900,0|\
         18@4500,-100"
    );
}

#[test]
fn gpos2_1_next_glyph_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos2_1_next_glyph_f2.otf",
            "\u{0012}\u{0012}\u{0012}\u{0012}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "18@-100,0|\
         18@1400,0|\
         18@2900,0|\
         18@4500,0"
    );
}

#[test]
fn gpos2_1_simple_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos2_1_simple_f1.otf",
            "\u{0011}\u{0012}\u{0013}\u{0011}\u{0012}\u{0014}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         18@1300,0|\
         19@3000,-100|\
         17@4500,0|\
         18@6000,0|\
         20@7500,0"
    );
}

#[test]
fn gpos2_1_simple_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos2_1_simple_f1.otf",
            "\u{0011}\u{0012}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         18@1500,0"
    );
}

#[test]
fn gpos2_2_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos2_2_font1.otf",
            "\u{0011}\u{0012}\u{0013}\u{0011}\u{0012}\u{0014}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         18@1300,0|\
         19@3000,-100|\
         17@4500,0|\
         18@6000,0|\
         20@7500,0"
    );
}

#[test]
fn gpos2_2_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos2_2_font2.otf",
            "\u{0011}\u{0013}\u{0014}\u{0011}\u{0013}\u{0012}\u{0014}\u{0011}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         19@1300,0|\
         20@3000,-100|\
         17@4500,0|\
         19@5800,0|\
         18@7500,0|\
         20@9000,-100|\
         17@10500,0"
    );
}

#[test]
fn gpos2_2_003() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos2_2_font3.otf",
            "\u{0011}\u{0013}\u{0014}\u{0011}\u{0013}\u{0012}\u{0014}\u{0011}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         19@1500,0|\
         20@2800,-100|\
         17@4300,0|\
         19@5800,0|\
         18@7100,0|\
         20@8600,-100|\
         17@10100,0"
    );
}

#[test]
fn gpos2_2_004() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos2_2_font4.otf",
            "\u{0012}\u{0012}\u{0012}\u{0012}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "18@-100,0|\
         18@1500,-100|\
         18@2900,0|\
         18@4500,-100"
    );
}

#[test]
fn gpos2_2_005() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos2_2_font5.otf",
            "\u{0012}\u{0012}\u{0012}\u{0012}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "18@-100,0|\
         18@1400,0|\
         18@2900,0|\
         18@4500,0"
    );
}

#[test]
fn gpos3_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos3_font1.otf",
            "\u{0011}\u{0012}\u{0011}\u{0013}\u{0011}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         18@1500,0|\
         17@3000,0|\
         19@4500,0|\
         17@6000,0"
    );
}

#[test]
fn gpos3_007() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos3_font3.otf",
            "\u{0011}\u{0012}\u{0014}\u{0011}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         18@1500,0|\
         20@3000,0|\
         17@4500,0"
    );
}

#[test]
fn gpos3_008() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos3_font3.otf",
            "\u{0011}\u{0013}\u{0012}\u{0011}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         19@1500,0|\
         18@3000,0|\
         17@4500,0"
    );
}

#[test]
fn gpos3_009() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos3_font3.otf",
            "\u{0011}\u{0013}\u{0014}\u{0011}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         19@1500,0|\
         20@3000,0|\
         17@4500,0"
    );
}

#[test]
fn gpos3_010() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos3_font3.otf",
            "\u{0011}\u{0012}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         18@1500,0"
    );
}

#[test]
fn gpos3_011() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos3_font3.otf",
            "\u{0011}\u{0012}\u{0015}\u{0015}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         18@1500,0|\
         21@3000,0|\
         21@4500,0|\
         21@6000,0"
    );
}

#[test]
fn gpos7_1_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos7_1_font1.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         18@1600,0|\
         19@3200,0|\
         20@4800,0|\
         21@6000,0"
    );
}

#[test]
fn gpos7_1_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos7_1_font1.otf",
            "\u{0011}\u{0012}\u{0011}\u{0012}\u{0013}\u{0011}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         18@1500,0|\
         17@3000,0|\
         18@4500,0|\
         19@6000,0|\
         17@7500,0"
    );
}

#[test]
fn gpos9_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos9_font1.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         18@1300,0|\
         19@3000,0|\
         20@4300,0|\
         21@6000,0"
    );
}

#[test]
fn gpos9_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos9_font2.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}\u{0011}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "17|\
         18@1300,0|\
         19@2700,0|\
         20@4300,0|\
         21@5700,0|\
         17@7500,0"
    );
}

#[test]
fn gpos_chaining1_boundary_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining1_boundary_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0|\
         23@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_chaining1_boundary_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining1_boundary_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3020,0|\
         22@4500,0|\
         23@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_chaining1_boundary_003() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining1_boundary_f3.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3020,0|\
         22@4500,0|\
         23@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_chaining1_boundary_004() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining1_boundary_f4.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4520,0|\
         23@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_chaining1_multiple_subrules_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining1_multiple_subrules_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0000}\u{0014}\u{0015}\u{0016}\
             \u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3020,0|\
         22@4500,0|\
         23@6000,0|\
         24@7500,0|\
         0@9000,0|\
         20@10500,0|\
         21@12000,0|\
         22@13520,0|\
         23@15000,0|\
         0@16500,0"
    );
}

#[test]
fn gpos_chaining1_multiple_subrules_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining1_multiple_subrules_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0000}\u{0014}\u{0015}\u{0016}\
             \u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4520,0|\
         23@6000,0|\
         24@7500,0|\
         0@9000,0|\
         20@10500,0|\
         21@12000,0|\
         22@13520,0|\
         23@15000,0|\
         0@16500,0"
    );
}

#[test]
fn gpos_chaining1_next_glyph_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining1_next_glyph_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3020,0|\
         22@4520,0|\
         23@6020,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_chaining1_simple_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining1_simple_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3020,0|\
         22@4520,0|\
         23@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_chaining1_simple_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining1_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4520,0|\
         23@6000,0|\
         24@7500,0|\
         25@9000,0|\
         26@10500,0|\
         0@12000,0"
    );
}

#[test]
fn gpos_chaining1_simple_003() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining1_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{0000}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0|\
         23@6000,0|\
         24@7500,0|\
         25@9000,0|\
         0@10500,0|\
         0@12000,0"
    );
}

#[test]
fn gpos_chaining1_simple_004() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining1_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0|\
         23@6000,0|\
         24@7500,0|\
         25@9000,0"
    );
}

#[test]
fn gpos_chaining1_simple_005() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining1_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0|\
         23@6000,0|\
         24@7500,0"
    );
}

#[test]
fn gpos_chaining1_simple_006() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining1_simple_f2.otf",
            "\u{0000}\u{0000}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         0@1500,0|\
         21@3000,0|\
         22@4500,0|\
         23@6000,0|\
         24@7500,0|\
         25@9000,0|\
         26@10500,0|\
         0@12000,0"
    );
}

#[test]
fn gpos_chaining1_simple_007() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining1_simple_f2.otf",
            "\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "21|\
         22@1500,0|\
         23@3000,0|\
         24@4500,0|\
         25@6000,0|\
         26@7500,0|\
         0@9000,0"
    );
}

#[test]
fn gpos_chaining1_simple_008() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining1_simple_f2.otf",
            "\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "22|\
         23@1500,0|\
         24@3000,0|\
         25@4500,0|\
         26@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_chaining1_simple_009() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining1_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0|\
         0@6000,0|\
         24@7500,0|\
         25@9000,0|\
         26@10500,0|\
         0@12000,0"
    );
}

#[test]
fn gpos_chaining1_simple_010() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining1_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0|\
         23@6000,0"
    );
}

#[test]
fn gpos_chaining1_simple_011() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining1_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0"
    );
}

#[test]
fn gpos_chaining1_successive_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining1_successive_f1.otf",
            "\u{0000}\u{0019}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         25@1500,0|\
         20@3000,0|\
         21@4520,0|\
         22@6020,0|\
         23@7500,0|\
         24@9000,0|\
         0@10500,0"
    );
}

#[test]
fn gpos_chaining2_boundary_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining2_boundary_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0|\
         23@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_chaining2_boundary_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining2_boundary_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3020,0|\
         22@4500,0|\
         23@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_chaining2_boundary_003() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining2_boundary_f3.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3020,0|\
         22@4500,0|\
         23@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_chaining2_boundary_004() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining2_boundary_f4.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4520,0|\
         23@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_chaining2_multiple_subrules_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining2_multiple_subrules_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0000}\u{0014}\u{0015}\u{0016}\
             \u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3020,0|\
         22@4500,0|\
         23@6000,0|\
         24@7500,0|\
         0@9000,0|\
         20@10500,0|\
         21@12000,0|\
         22@13520,0|\
         23@15000,0|\
         0@16500,0"
    );
}

#[test]
fn gpos_chaining2_multiple_subrules_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining2_multiple_subrules_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0000}\u{0014}\u{0015}\u{0016}\
             \u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4520,0|\
         23@6000,0|\
         24@7500,0|\
         0@9000,0|\
         20@10500,0|\
         21@12000,0|\
         22@13520,0|\
         23@15000,0|\
         0@16500,0"
    );
}

#[test]
fn gpos_chaining2_next_glyph_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining2_next_glyph_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3020,0|\
         22@4520,0|\
         23@6020,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_chaining2_simple_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining2_simple_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3020,0|\
         22@4520,0|\
         23@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_chaining2_simple_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining2_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4520,0|\
         23@6000,0|\
         24@7500,0|\
         25@9000,0|\
         26@10500,0|\
         0@12000,0"
    );
}

#[test]
fn gpos_chaining2_simple_003() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining2_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{0000}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0|\
         23@6000,0|\
         24@7500,0|\
         25@9000,0|\
         0@10500,0|\
         0@12000,0"
    );
}

#[test]
fn gpos_chaining2_simple_004() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining2_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0|\
         23@6000,0|\
         24@7500,0|\
         25@9000,0"
    );
}

#[test]
fn gpos_chaining2_simple_005() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining2_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0|\
         23@6000,0|\
         24@7500,0"
    );
}

#[test]
fn gpos_chaining2_simple_006() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining2_simple_f2.otf",
            "\u{0000}\u{0000}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         0@1500,0|\
         21@3000,0|\
         22@4500,0|\
         23@6000,0|\
         24@7500,0|\
         25@9000,0|\
         26@10500,0|\
         0@12000,0"
    );
}

#[test]
fn gpos_chaining2_simple_007() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining2_simple_f2.otf",
            "\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "21|\
         22@1500,0|\
         23@3000,0|\
         24@4500,0|\
         25@6000,0|\
         26@7500,0|\
         0@9000,0"
    );
}

#[test]
fn gpos_chaining2_simple_008() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining2_simple_f2.otf",
            "\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "22|\
         23@1500,0|\
         24@3000,0|\
         25@4500,0|\
         26@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_chaining2_simple_009() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining2_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0|\
         0@6000,0|\
         24@7500,0|\
         25@9000,0|\
         26@10500,0|\
         0@12000,0"
    );
}

#[test]
fn gpos_chaining2_simple_010() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining2_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0|\
         23@6000,0"
    );
}

#[test]
fn gpos_chaining2_simple_011() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining2_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0"
    );
}

#[test]
fn gpos_chaining2_successive_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining2_successive_f1.otf",
            "\u{0000}\u{0019}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         25@1500,0|\
         20@3000,0|\
         21@4520,0|\
         22@6020,0|\
         23@7500,0|\
         24@9000,0|\
         0@10500,0"
    );
}

#[test]
fn gpos_chaining3_boundary_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining3_boundary_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0|\
         23@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_chaining3_boundary_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining3_boundary_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3020,0|\
         22@4500,0|\
         23@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_chaining3_boundary_003() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining3_boundary_f3.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3020,0|\
         22@4500,0|\
         23@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_chaining3_boundary_004() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining3_boundary_f4.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4520,0|\
         23@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_chaining3_next_glyph_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining3_next_glyph_f1.otf",
            "\u{0000}\u{0016}\u{0015}\u{0016}\u{0015}\u{0016}\u{0015}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         22@1500,0|\
         21@3020,0|\
         22@4500,0|\
         21@6020,0|\
         22@7500,0|\
         21@9000,0|\
         0@10500,0"
    );
}

#[test]
fn gpos_chaining3_simple_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining3_simple_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3020,0|\
         22@4520,0|\
         23@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_chaining3_simple_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining3_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4520,0|\
         23@6000,0|\
         24@7500,0|\
         25@9000,0|\
         26@10500,0|\
         0@12000,0"
    );
}

#[test]
fn gpos_chaining3_simple_003() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining3_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{0000}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0|\
         23@6000,0|\
         24@7500,0|\
         25@9000,0|\
         0@10500,0|\
         0@12000,0"
    );
}

#[test]
fn gpos_chaining3_simple_004() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining3_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0|\
         23@6000,0|\
         24@7500,0|\
         25@9000,0"
    );
}

#[test]
fn gpos_chaining3_simple_005() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining3_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0|\
         23@6000,0|\
         24@7500,0"
    );
}

#[test]
fn gpos_chaining3_simple_006() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining3_simple_f2.otf",
            "\u{0000}\u{0000}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         0@1500,0|\
         21@3000,0|\
         22@4500,0|\
         23@6000,0|\
         24@7500,0|\
         25@9000,0|\
         26@10500,0|\
         0@12000,0"
    );
}

#[test]
fn gpos_chaining3_simple_007() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining3_simple_f2.otf",
            "\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "21|\
         22@1500,0|\
         23@3000,0|\
         24@4500,0|\
         25@6000,0|\
         26@7500,0|\
         0@9000,0"
    );
}

#[test]
fn gpos_chaining3_simple_008() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining3_simple_f2.otf",
            "\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "22|\
         23@1500,0|\
         24@3000,0|\
         25@4500,0|\
         26@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_chaining3_simple_009() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining3_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0|\
         0@6000,0|\
         24@7500,0|\
         25@9000,0|\
         26@10500,0|\
         0@12000,0"
    );
}

#[test]
fn gpos_chaining3_simple_010() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining3_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0|\
         23@6000,0"
    );
}

#[test]
fn gpos_chaining3_simple_011() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining3_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0"
    );
}

#[test]
fn gpos_chaining3_successive_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_chaining3_successive_f1.otf",
            "\u{0000}\u{0019}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         25@1500,0|\
         20@3000,0|\
         21@4520,0|\
         22@6020,0|\
         23@7500,0|\
         24@9000,0|\
         0@10500,0"
    );
}

#[test]
fn gpos_context1_boundary_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context1_boundary_f1.otf",
            "\u{0000}\u{0014}\u{0014}\u{0014}\u{0014}\u{0014}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         20@3000,0|\
         20@4500,0|\
         20@6000,0|\
         20@7500,0|\
         0@9000,0"
    );
}

#[test]
fn gpos_context1_boundary_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context1_boundary_f2.otf",
            "\u{0000}\u{0014}\u{0014}\u{0014}\u{0014}\u{0014}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1520,0|\
         20@3020,0|\
         20@4520,0|\
         20@6020,0|\
         20@7520,0|\
         0@9000,0"
    );
}

#[test]
fn gpos_context1_expansion_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context1_expansion_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0|\
         0@6000,0"
    );
}

#[test]
fn gpos_context1_multiple_subrules_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context1_multiple_subrules_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}\u{0014}\u{0015}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1520,0|\
         21@3000,0|\
         22@4500,0|\
         0@6000,0|\
         20@7500,0|\
         21@9020,0|\
         0@10500,0"
    );
}

#[test]
fn gpos_context1_multiple_subrules_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context1_multiple_subrules_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}\u{0014}\u{0015}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3020,0|\
         22@4500,0|\
         0@6000,0|\
         20@7500,0|\
         21@9020,0|\
         0@10500,0"
    );
}

#[test]
fn gpos_context1_next_glyph_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context1_next_glyph_f1.otf",
            "\u{0000}\u{0014}\u{0014}\u{0014}\u{0014}\u{0014}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1520,0|\
         20@3000,0|\
         20@4520,0|\
         20@6000,0|\
         20@7500,0|\
         0@9000,0"
    );
}

#[test]
fn gpos_context1_simple_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context1_simple_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1520,0|\
         21@3020,0|\
         22@4520,0|\
         0@6000,0"
    );
}

#[test]
fn gpos_context1_simple_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context1_simple_f1.otf",
            "\u{0000}\u{0014}\u{0000}\u{0014}\u{0015}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         0@3000,0|\
         20@4500,0|\
         21@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_context1_simple_003() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context1_simple_f2.otf",
            "\u{0000}\u{0014}\u{0014}\u{0014}\u{0014}\u{0014}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         20@3020,0|\
         20@4500,0|\
         20@6000,0|\
         20@7500,0|\
         0@9000,0"
    );
}

#[test]
fn gpos_context1_successive_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context1_successive_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3020,0|\
         22@4520,0|\
         23@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_context2_boundary_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context2_boundary_f1.otf",
            "\u{0000}\u{0014}\u{0014}\u{0014}\u{0014}\u{0014}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         20@3000,0|\
         20@4500,0|\
         20@6000,0|\
         20@7500,0|\
         0@9000,0"
    );
}

#[test]
fn gpos_context2_boundary_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context2_boundary_f2.otf",
            "\u{0000}\u{0014}\u{0014}\u{0014}\u{0014}\u{0014}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1520,0|\
         20@3020,0|\
         20@4520,0|\
         20@6020,0|\
         20@7520,0|\
         0@9000,0"
    );
}

#[test]
fn gpos_context2_classes_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context2_classes_f1.otf",
            "\u{0000}\u{0014}\u{001A}\u{001C}\u{0018}\u{0000}\u{0015}\u{001B}\u{001A}\u{0018}\
             \u{0000}\u{0016}\u{001B}\u{001A}\u{0018}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         26@3020,0|\
         28@4500,0|\
         24@6000,0|\
         0@7500,0|\
         21@9000,0|\
         27@10520,0|\
         26@12000,0|\
         24@13500,0|\
         0@15000,0|\
         22@16500,0|\
         27@18000,0|\
         26@19500,0|\
         24@21000,0"
    );
}

#[test]
fn gpos_context2_classes_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context2_classes_f2.otf",
            "\u{0000}\u{0016}\u{001B}\u{001A}\u{0018}\u{0000}\u{0018}\u{0018}\u{001D}\u{0016}\
             \u{0000}\u{0016}\u{001B}\u{001A}\u{0018}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         22@1500,0|\
         27@3020,0|\
         26@4500,0|\
         24@6000,0|\
         0@7500,0|\
         24@9000,0|\
         24@10500,0|\
         29@12020,0|\
         22@13500,0|\
         0@15000,0|\
         22@16500,0|\
         27@18020,0|\
         26@19500,0|\
         24@21000,0"
    );
}

#[test]
fn gpos_context2_expansion_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context2_expansion_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3000,0|\
         22@4500,0|\
         0@6000,0"
    );
}

#[test]
fn gpos_context2_multiple_subrules_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context2_multiple_subrules_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}\u{0014}\u{0015}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1520,0|\
         21@3000,0|\
         22@4500,0|\
         0@6000,0|\
         20@7500,0|\
         21@9020,0|\
         0@10500,0"
    );
}

#[test]
fn gpos_context2_multiple_subrules_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context2_multiple_subrules_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}\u{0014}\u{0015}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3020,0|\
         22@4500,0|\
         0@6000,0|\
         20@7500,0|\
         21@9020,0|\
         0@10500,0"
    );
}

#[test]
fn gpos_context2_next_glyph_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context2_next_glyph_f1.otf",
            "\u{0000}\u{0014}\u{0014}\u{0014}\u{0014}\u{0014}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1520,0|\
         20@3000,0|\
         20@4520,0|\
         20@6000,0|\
         20@7500,0|\
         0@9000,0"
    );
}

#[test]
fn gpos_context2_simple_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context2_simple_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1520,0|\
         21@3020,0|\
         22@4520,0|\
         0@6000,0"
    );
}

#[test]
fn gpos_context2_simple_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context2_simple_f1.otf",
            "\u{0000}\u{0014}\u{0000}\u{0014}\u{0015}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         0@3000,0|\
         20@4500,0|\
         21@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_context2_simple_003() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context2_simple_f2.otf",
            "\u{0000}\u{0014}\u{0014}\u{0014}\u{0014}\u{0014}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         20@3020,0|\
         20@4500,0|\
         20@6000,0|\
         20@7500,0|\
         0@9000,0"
    );
}

#[test]
fn gpos_context2_successive_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context2_successive_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3020,0|\
         22@4520,0|\
         23@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gpos_context3_boundary_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context3_boundary_f1.otf",
            "\u{0000}\u{0014}\u{0014}\u{0014}\u{0014}\u{0014}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         20@3000,0|\
         20@4500,0|\
         20@6000,0|\
         20@7500,0|\
         0@9000,0"
    );
}

#[test]
fn gpos_context3_boundary_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context3_boundary_f2.otf",
            "\u{0000}\u{0014}\u{0014}\u{0014}\u{0014}\u{0014}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1520,0|\
         20@3020,0|\
         20@4520,0|\
         20@6020,0|\
         20@7520,0|\
         0@9000,0"
    );
}

#[test]
fn gpos_context3_next_glyph_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context3_next_glyph_f1.otf",
            "\u{0000}\u{0014}\u{0014}\u{0014}\u{0014}\u{0014}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1520,0|\
         20@3000,0|\
         20@4520,0|\
         20@6000,0|\
         20@7500,0|\
         0@9000,0"
    );
}

#[test]
fn gpos_context3_simple_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context3_simple_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1520,0|\
         21@3020,0|\
         22@4520,0|\
         0@6000,0"
    );
}

#[test]
fn gpos_context3_simple_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context3_simple_f1.otf",
            "\u{0000}\u{0014}\u{0000}\u{0014}\u{0015}\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         0@3000,0|\
         20@4500,0|\
         21@6000,0|\
         0@7500,0|\
         20@9020,0|\
         21@10520,0|\
         22@12020,0|\
         0@13500,0"
    );
}

#[test]
fn gpos_context3_successive_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gpos_context3_successive_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --ned",
        ),
        "0|\
         20@1500,0|\
         21@3020,0|\
         22@4520,0|\
         23@6000,0|\
         0@7500,0"
    );
}

#[test]
fn gsub1_1_lookupflag_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub1_1_lookupflag_f1.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         18|\
         24|\
         20|\
         21"
    );
}

#[test]
fn gsub1_1_modulo_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub1_1_modulo_f1.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         18|\
         17|\
         24|\
         23|\
         18|\
         23|\
         24"
    );
}

#[test]
fn gsub1_1_simple_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub1_1_simple_f1.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         23|\
         24|\
         20|\
         21"
    );
}

#[test]
fn gsub1_2_lookupflag_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub1_2_lookupflag_f1.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         18|\
         19|\
         25|\
         21"
    );
}

#[test]
fn gsub1_2_simple_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub1_2_simple_f1.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         22|\
         19|\
         25|\
         21"
    );
}

#[test]
fn gsub2_1_lookupflag_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub2_1_lookupflag_f1.otf",
            "\u{0011}\u{0012}\u{0013}\u{0011}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         18|\
         22|\
         23|\
         17"
    );
}

#[test]
fn gsub2_1_multiple_sequences_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub2_1_multiple_sequences_f1.otf",
            "\u{0011}\u{0012}\u{0013}\u{0011}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         20|\
         21|\
         22|\
         23|\
         17"
    );
}

#[test]
fn gsub2_1_simple_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub2_1_simple_f1.otf",
            "\u{0011}\u{0012}\u{0013}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         20|\
         21|\
         22|\
         19"
    );
}

#[test]
fn gsub2_1_simple_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub2_1_simple_f1.otf",
            "\u{0011}\u{0012}\u{0013}\u{0012}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         20|\
         21|\
         22|\
         19|\
         20|\
         21|\
         22"
    );
}

#[test]
fn gsub3_1_lookupflag_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub3_1_lookupflag_f1.otf",
            "\u{0011}\u{0012}\u{0012}\u{0012}\u{0013}\u{0013}\u{0013}\u{0013}\u{0011}",
            "--features=\"-test[4],test[5],test[6]=2,-test[7]\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         18|\
         18|\
         18|\
         19|\
         22|\
         23|\
         19|\
         17"
    );
}

#[test]
fn gsub3_1_multiple_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub3_1_multiple_f1.otf",
            "\u{0011}\u{0012}\u{0012}\u{0012}\u{0012}\u{0013}\u{0013}\u{0013}\u{0013}\u{0011}",
            "--features=\"-test[1],test[2],test[3]=2,-test[4],-test[5],test[6],test[7]=2,-test[8]\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         18|\
         20|\
         21|\
         18|\
         19|\
         22|\
         23|\
         19|\
         17"
    );
}

#[test]
fn gsub4_1_lookupflag_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub4_1_lookupflag_f1.otf",
            "\u{0011}\u{0018}\u{0012}\u{0018}\u{0013}\u{0018}\u{0018}\u{0014}\u{0018}\u{0011}\
             \u{0012}\u{0013}\u{0016}\u{0014}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         24|\
         23|\
         24|\
         24|\
         24|\
         24|\
         17|\
         18|\
         19|\
         22|\
         20"
    );
}

#[test]
fn gsub4_1_multiple_ligatures_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub4_1_multiple_ligatures_f1.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0011}\u{0012}\u{0013}\u{0016}\u{0014}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         23|\
         17|\
         24|\
         22|\
         20"
    );
}

#[test]
fn gsub4_1_multiple_ligatures_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub4_1_multiple_ligatures_f2.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0011}\u{0012}\u{0013}\u{0016}\u{0014}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         24|\
         20|\
         17|\
         24|\
         22|\
         20"
    );
}

#[test]
fn gsub4_1_multiple_ligsets_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub4_1_multiple_ligsets_f1.otf",
            "\u{0011}\u{0012}\u{0013}\u{0015}\u{0014}\u{0013}\u{0016}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         23|\
         21|\
         24|\
         22"
    );
}

#[test]
fn gsub4_1_simple_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub4_1_simple_f1.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0011}\u{0012}\u{0013}\u{0016}\u{0014}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         23|\
         17|\
         18|\
         19|\
         22|\
         20"
    );
}

#[test]
fn gsub7_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub7_font1.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         23|\
         24|\
         20|\
         21"
    );
}

#[test]
fn gsub7_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub7_font2.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         23|\
         29|\
         20|\
         21"
    );
}

#[test]
fn gsub_chaining1_boundary_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining1_boundary_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         22|\
         23|\
         0"
    );
}

#[test]
fn gsub_chaining1_boundary_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining1_boundary_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         61|\
         22|\
         23|\
         0"
    );
}

#[test]
fn gsub_chaining1_boundary_003() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining1_boundary_f3.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         61|\
         22|\
         23|\
         0"
    );
}

#[test]
fn gsub_chaining1_boundary_004() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining1_boundary_f4.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         62|\
         23|\
         0"
    );
}

#[test]
fn gsub_chaining1_lookupflag_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining1_lookupflag_f1.otf",
            "\u{0000}\u{0014}\u{005A}\u{0015}\u{005B}\u{0016}\u{005C}\u{0017}\u{005D}\u{005E}\
             \u{0018}\u{005A}\u{0019}\u{005B}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         90|\
         21|\
         91|\
         22|\
         92|\
         63|\
         93|\
         94|\
         24|\
         90|\
         25|\
         91|\
         26|\
         0"
    );
}

#[test]
fn gsub_chaining1_multiple_subrules_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining1_multiple_subrules_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0000}\u{0014}\u{0015}\u{0016}\
             \u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         61|\
         22|\
         23|\
         24|\
         0|\
         20|\
         21|\
         62|\
         23|\
         0"
    );
}

#[test]
fn gsub_chaining1_multiple_subrules_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining1_multiple_subrules_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0000}\u{0014}\u{0015}\u{0016}\
             \u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         62|\
         23|\
         24|\
         0|\
         20|\
         21|\
         62|\
         23|\
         0"
    );
}

#[test]
fn gsub_chaining1_next_glyph_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining1_next_glyph_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         61|\
         62|\
         63|\
         0"
    );
}

#[test]
fn gsub_chaining1_simple_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining1_simple_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         61|\
         62|\
         23|\
         0"
    );
}

#[test]
fn gsub_chaining1_simple_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining1_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         62|\
         23|\
         24|\
         25|\
         26|\
         0"
    );
}

#[test]
fn gsub_chaining1_simple_003() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining1_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{0000}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         22|\
         23|\
         24|\
         25|\
         0|\
         0"
    );
}

#[test]
fn gsub_chaining1_simple_004() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining1_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         22|\
         23|\
         24|\
         25"
    );
}

#[test]
fn gsub_chaining1_simple_005() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining1_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         22|\
         23|\
         24"
    );
}

#[test]
fn gsub_chaining1_simple_006() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining1_simple_f2.otf",
            "\u{0000}\u{0000}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         0|\
         21|\
         22|\
         23|\
         24|\
         25|\
         26|\
         0"
    );
}

#[test]
fn gsub_chaining1_simple_007() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining1_simple_f2.otf",
            "\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "21|\
         22|\
         23|\
         24|\
         25|\
         26|\
         0"
    );
}

#[test]
fn gsub_chaining1_simple_008() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining1_simple_f2.otf",
            "\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "22|\
         23|\
         24|\
         25|\
         26|\
         0"
    );
}

#[test]
fn gsub_chaining1_simple_009() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining1_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         22|\
         0|\
         24|\
         25|\
         26|\
         0"
    );
}

#[test]
fn gsub_chaining1_simple_010() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining1_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         22|\
         23"
    );
}

#[test]
fn gsub_chaining1_simple_011() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining1_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         22"
    );
}

#[test]
fn gsub_chaining1_successive_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining1_successive_f1.otf",
            "\u{0000}\u{0019}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         25|\
         20|\
         61|\
         63|\
         24|\
         0"
    );
}

#[test]
fn gsub_chaining2_boundary_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining2_boundary_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         22|\
         23|\
         0"
    );
}

#[test]
fn gsub_chaining2_boundary_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining2_boundary_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         61|\
         22|\
         23|\
         0"
    );
}

#[test]
fn gsub_chaining2_boundary_003() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining2_boundary_f3.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         61|\
         22|\
         23|\
         0"
    );
}

#[test]
fn gsub_chaining2_boundary_004() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining2_boundary_f4.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         62|\
         23|\
         0"
    );
}

#[test]
fn gsub_chaining2_lookupflag_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining2_lookupflag_f1.otf",
            "\u{0000}\u{0014}\u{005A}\u{0015}\u{005B}\u{0016}\u{005C}\u{0017}\u{005D}\u{005E}\
             \u{0018}\u{005A}\u{0019}\u{005B}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         90|\
         21|\
         91|\
         22|\
         92|\
         63|\
         93|\
         94|\
         24|\
         90|\
         25|\
         91|\
         26|\
         0"
    );
}

#[test]
fn gsub_chaining2_multiple_subrules_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining2_multiple_subrules_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0000}\u{0014}\u{0015}\u{0016}\
             \u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         61|\
         22|\
         23|\
         24|\
         0|\
         20|\
         21|\
         62|\
         23|\
         0"
    );
}

#[test]
fn gsub_chaining2_multiple_subrules_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining2_multiple_subrules_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0000}\u{0014}\u{0015}\u{0016}\
             \u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         62|\
         23|\
         24|\
         0|\
         20|\
         21|\
         62|\
         23|\
         0"
    );
}

#[test]
fn gsub_chaining2_next_glyph_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining2_next_glyph_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         61|\
         62|\
         63|\
         0"
    );
}

#[test]
fn gsub_chaining2_simple_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining2_simple_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         61|\
         62|\
         23|\
         0"
    );
}

#[test]
fn gsub_chaining2_simple_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining2_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         62|\
         23|\
         24|\
         25|\
         26|\
         0"
    );
}

#[test]
fn gsub_chaining2_simple_003() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining2_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{0000}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         22|\
         23|\
         24|\
         25|\
         0|\
         0"
    );
}

#[test]
fn gsub_chaining2_simple_004() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining2_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         22|\
         23|\
         24|\
         25"
    );
}

#[test]
fn gsub_chaining2_simple_005() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining2_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         22|\
         23|\
         24"
    );
}

#[test]
fn gsub_chaining2_simple_006() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining2_simple_f2.otf",
            "\u{0000}\u{0000}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         0|\
         21|\
         22|\
         23|\
         24|\
         25|\
         26|\
         0"
    );
}

#[test]
fn gsub_chaining2_simple_007() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining2_simple_f2.otf",
            "\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "21|\
         22|\
         23|\
         24|\
         25|\
         26|\
         0"
    );
}

#[test]
fn gsub_chaining2_simple_008() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining2_simple_f2.otf",
            "\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "22|\
         23|\
         24|\
         25|\
         26|\
         0"
    );
}

#[test]
fn gsub_chaining2_simple_009() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining2_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         22|\
         0|\
         24|\
         25|\
         26|\
         0"
    );
}

#[test]
fn gsub_chaining2_simple_010() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining2_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         22|\
         23"
    );
}

#[test]
fn gsub_chaining2_simple_011() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining2_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         22"
    );
}

#[test]
fn gsub_chaining2_successive_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining2_successive_f1.otf",
            "\u{0000}\u{0019}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         25|\
         20|\
         61|\
         63|\
         24|\
         0"
    );
}

#[test]
fn gsub_chaining3_boundary_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining3_boundary_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         22|\
         23|\
         0"
    );
}

#[test]
fn gsub_chaining3_boundary_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining3_boundary_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         61|\
         22|\
         23|\
         0"
    );
}

#[test]
fn gsub_chaining3_boundary_003() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining3_boundary_f3.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         61|\
         22|\
         23|\
         0"
    );
}

#[test]
fn gsub_chaining3_boundary_004() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining3_boundary_f4.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         62|\
         23|\
         0"
    );
}

#[test]
fn gsub_chaining3_lookupflag_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining3_lookupflag_f1.otf",
            "\u{0000}\u{0014}\u{005A}\u{0015}\u{005B}\u{0016}\u{005C}\u{0017}\u{005D}\u{005E}\
             \u{0018}\u{005A}\u{0019}\u{005B}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         90|\
         21|\
         91|\
         22|\
         92|\
         63|\
         93|\
         94|\
         24|\
         90|\
         25|\
         91|\
         26|\
         0"
    );
}

#[test]
fn gsub_chaining3_next_glyph_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining3_next_glyph_f1.otf",
            "\u{0000}\u{0016}\u{0015}\u{0016}\u{0015}\u{0016}\u{0015}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         22|\
         61|\
         22|\
         61|\
         22|\
         21|\
         0"
    );
}

#[test]
fn gsub_chaining3_simple_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining3_simple_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         61|\
         62|\
         23|\
         0"
    );
}

#[test]
fn gsub_chaining3_simple_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining3_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         62|\
         23|\
         24|\
         25|\
         26|\
         0"
    );
}

#[test]
fn gsub_chaining3_simple_003() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining3_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{0000}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         22|\
         23|\
         24|\
         25|\
         0|\
         0"
    );
}

#[test]
fn gsub_chaining3_simple_004() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining3_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         22|\
         23|\
         24|\
         25"
    );
}

#[test]
fn gsub_chaining3_simple_005() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining3_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         22|\
         23|\
         24"
    );
}

#[test]
fn gsub_chaining3_simple_006() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining3_simple_f2.otf",
            "\u{0000}\u{0000}\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         0|\
         21|\
         22|\
         23|\
         24|\
         25|\
         26|\
         0"
    );
}

#[test]
fn gsub_chaining3_simple_007() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining3_simple_f2.otf",
            "\u{0015}\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "21|\
         22|\
         23|\
         24|\
         25|\
         26|\
         0"
    );
}

#[test]
fn gsub_chaining3_simple_008() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining3_simple_f2.otf",
            "\u{0016}\u{0017}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "22|\
         23|\
         24|\
         25|\
         26|\
         0"
    );
}

#[test]
fn gsub_chaining3_simple_009() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining3_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}\u{0018}\u{0019}\u{001A}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         22|\
         0|\
         24|\
         25|\
         26|\
         0"
    );
}

#[test]
fn gsub_chaining3_simple_010() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining3_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         22|\
         23"
    );
}

#[test]
fn gsub_chaining3_simple_011() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining3_simple_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         21|\
         22"
    );
}

#[test]
fn gsub_chaining3_successive_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_chaining3_successive_f1.otf",
            "\u{0000}\u{0019}\u{0014}\u{0015}\u{0016}\u{0017}\u{0018}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         25|\
         20|\
         61|\
         63|\
         24|\
         0"
    );
}

#[test]
fn gsub_context1_boundary_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context1_boundary_f1.otf",
            "\u{0000}\u{0014}\u{0014}\u{0014}\u{0014}\u{0014}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         20|\
         20|\
         20|\
         20|\
         0"
    );
}

#[test]
fn gsub_context1_boundary_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context1_boundary_f2.otf",
            "\u{0000}\u{0014}\u{0014}\u{0014}\u{0014}\u{0014}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         60|\
         60|\
         60|\
         60|\
         60|\
         0"
    );
}

#[test]
fn gsub_context1_expansion_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context1_expansion_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         61|\
         62|\
         63|\
         22|\
         0"
    );
}

#[test]
fn gsub_context1_lookupflag_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context1_lookupflag_f1.otf",
            "\u{0000}\u{0014}\u{005A}\u{0015}\u{005B}\u{005C}\u{0016}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         60|\
         90|\
         61|\
         91|\
         92|\
         62|\
         0"
    );
}

#[test]
fn gsub_context1_lookupflag_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context1_lookupflag_f2.otf",
            "\u{0000}\u{0014}\u{005A}\u{0015}\u{005B}\u{005C}\u{0016}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         90|\
         61|\
         91|\
         92|\
         0"
    );
}

#[test]
fn gsub_context1_multiple_subrules_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context1_multiple_subrules_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}\u{0014}\u{0015}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         60|\
         21|\
         22|\
         0|\
         20|\
         61|\
         0"
    );
}

#[test]
fn gsub_context1_multiple_subrules_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context1_multiple_subrules_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}\u{0014}\u{0015}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         61|\
         22|\
         0|\
         20|\
         61|\
         0"
    );
}

#[test]
fn gsub_context1_next_glyph_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context1_next_glyph_f1.otf",
            "\u{0000}\u{0014}\u{0014}\u{0014}\u{0014}\u{0014}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         60|\
         20|\
         60|\
         20|\
         20|\
         0"
    );
}

#[test]
fn gsub_context1_simple_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context1_simple_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         60|\
         61|\
         62|\
         0"
    );
}

#[test]
fn gsub_context1_simple_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context1_simple_f1.otf",
            "\u{0000}\u{0014}\u{0000}\u{0014}\u{0015}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         0|\
         20|\
         21|\
         0"
    );
}

#[test]
fn gsub_context1_simple_003() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context1_simple_f2.otf",
            "\u{0000}\u{0014}\u{0014}\u{0014}\u{0014}\u{0014}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         60|\
         20|\
         20|\
         20|\
         0"
    );
}

#[test]
fn gsub_context1_successive_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context1_successive_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         61|\
         63|\
         0"
    );
}

#[test]
fn gsub_context2_boundary_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context2_boundary_f1.otf",
            "\u{0000}\u{0014}\u{0014}\u{0014}\u{0014}\u{0014}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         20|\
         20|\
         20|\
         20|\
         0"
    );
}

#[test]
fn gsub_context2_boundary_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context2_boundary_f2.otf",
            "\u{0000}\u{0014}\u{0014}\u{0014}\u{0014}\u{0014}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         60|\
         60|\
         60|\
         60|\
         60|\
         0"
    );
}

#[test]
fn gsub_context2_classes_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context2_classes_f1.otf",
            "\u{0000}\u{0014}\u{001A}\u{001C}\u{0018}\u{0000}\u{0015}\u{001B}\u{001A}\u{0018}\
             \u{0000}\u{0016}\u{001B}\u{001A}\u{0018}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         66|\
         28|\
         24|\
         0|\
         21|\
         67|\
         26|\
         24|\
         0|\
         22|\
         27|\
         26|\
         24"
    );
}

#[test]
fn gsub_context2_classes_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context2_classes_f2.otf",
            "\u{0000}\u{0016}\u{001B}\u{001A}\u{0018}\u{0000}\u{0018}\u{0018}\u{001D}\u{0016}\
             \u{0000}\u{0016}\u{001B}\u{001A}\u{0018}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         22|\
         67|\
         26|\
         24|\
         0|\
         24|\
         24|\
         69|\
         22|\
         0|\
         22|\
         67|\
         26|\
         24"
    );
}

#[test]
fn gsub_context2_expansion_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context2_expansion_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         61|\
         62|\
         63|\
         22|\
         0"
    );
}

#[test]
fn gsub_context2_lookupflag_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context2_lookupflag_f1.otf",
            "\u{0000}\u{0014}\u{005A}\u{0015}\u{005B}\u{005C}\u{0016}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         60|\
         90|\
         61|\
         91|\
         92|\
         62|\
         0"
    );
}

#[test]
fn gsub_context2_lookupflag_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context2_lookupflag_f2.otf",
            "\u{0000}\u{0014}\u{005A}\u{0015}\u{005B}\u{005C}\u{0016}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         90|\
         61|\
         91|\
         92|\
         0"
    );
}

#[test]
fn gsub_context2_multiple_subrules_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context2_multiple_subrules_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}\u{0014}\u{0015}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         60|\
         21|\
         22|\
         0|\
         20|\
         61|\
         0"
    );
}

#[test]
fn gsub_context2_multiple_subrules_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context2_multiple_subrules_f2.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}\u{0014}\u{0015}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         61|\
         22|\
         0|\
         20|\
         61|\
         0"
    );
}

#[test]
fn gsub_context2_next_glyph_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context2_next_glyph_f1.otf",
            "\u{0000}\u{0014}\u{0014}\u{0014}\u{0014}\u{0014}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         60|\
         20|\
         60|\
         20|\
         20|\
         0"
    );
}

#[test]
fn gsub_context2_simple_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context2_simple_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         60|\
         61|\
         62|\
         0"
    );
}

#[test]
fn gsub_context2_simple_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context2_simple_f1.otf",
            "\u{0000}\u{0014}\u{0000}\u{0014}\u{0015}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         0|\
         20|\
         21|\
         0"
    );
}

#[test]
fn gsub_context2_simple_003() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context2_simple_f2.otf",
            "\u{0000}\u{0014}\u{0014}\u{0014}\u{0014}\u{0014}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         60|\
         20|\
         20|\
         20|\
         0"
    );
}

#[test]
fn gsub_context2_successive_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context2_successive_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         61|\
         63|\
         0"
    );
}

#[test]
fn gsub_context3_boundary_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context3_boundary_f1.otf",
            "\u{0000}\u{0014}\u{0014}\u{0014}\u{0014}\u{0014}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         20|\
         20|\
         20|\
         20|\
         0"
    );
}

#[test]
fn gsub_context3_boundary_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context3_boundary_f2.otf",
            "\u{0000}\u{0014}\u{0014}\u{0014}\u{0014}\u{0014}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         60|\
         60|\
         60|\
         60|\
         60|\
         0"
    );
}

#[test]
fn gsub_context3_lookupflag_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context3_lookupflag_f1.otf",
            "\u{0000}\u{0014}\u{005A}\u{0015}\u{005B}\u{005C}\u{0016}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         60|\
         90|\
         61|\
         91|\
         92|\
         62|\
         0"
    );
}

#[test]
fn gsub_context3_lookupflag_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context3_lookupflag_f2.otf",
            "\u{0000}\u{0014}\u{005A}\u{0015}\u{005B}\u{005C}\u{0016}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         90|\
         61|\
         91|\
         92|\
         0"
    );
}

#[test]
fn gsub_context3_next_glyph_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context3_next_glyph_f1.otf",
            "\u{0000}\u{0014}\u{0014}\u{0014}\u{0014}\u{0014}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         60|\
         20|\
         60|\
         20|\
         20|\
         0"
    );
}

#[test]
fn gsub_context3_simple_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context3_simple_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         60|\
         61|\
         62|\
         0"
    );
}

#[test]
fn gsub_context3_simple_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context3_simple_f1.otf",
            "\u{0000}\u{0014}\u{0000}\u{0014}\u{0015}\u{0000}\u{0014}\u{0015}\u{0016}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         0|\
         20|\
         21|\
         0|\
         60|\
         61|\
         62|\
         0"
    );
}

#[test]
fn gsub_context3_successive_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/gsub_context3_successive_f1.otf",
            "\u{0000}\u{0014}\u{0015}\u{0016}\u{0017}\u{0000}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "0|\
         20|\
         61|\
         63|\
         0"
    );
}

#[test]
fn lookupflag_ignore_base_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/lookupflag_ignore_base_f1.otf",
            "\u{0011}\u{0012}\u{0013}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         23|\
         21"
    );
}

#[test]
fn lookupflag_ignore_base_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/lookupflag_ignore_base_f1.otf",
            "\u{0011}\u{0012}\u{0018}\u{0018}\u{0013}\u{0019}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         23|\
         24|\
         24|\
         25|\
         21"
    );
}

#[test]
fn lookupflag_ignore_combination_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/lookupflag_ignore_combination_f1.otf",
            "\u{0011}\u{0012}\u{001A}\u{0013}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         23|\
         26|\
         21"
    );
}

#[test]
fn lookupflag_ignore_combination_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/lookupflag_ignore_combination_f1.otf",
            "\u{0011}\u{0012}\u{001A}\u{0013}\u{0018}\u{001E}\u{001F}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         23|\
         26|\
         24|\
         30|\
         31|\
         21"
    );
}

#[test]
fn lookupflag_ignore_combination_003() {
    assert_eq!(
        shape(
            "tests/fonts/aots/lookupflag_ignore_combination_f1.otf",
            "\u{0011}\u{0012}\u{001A}\u{0013}\u{0018}\u{001E}\u{0020}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         18|\
         26|\
         19|\
         24|\
         30|\
         32|\
         20|\
         21"
    );
}

#[test]
fn lookupflag_ignore_ligatures_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/lookupflag_ignore_ligatures_f1.otf",
            "\u{0011}\u{0012}\u{001A}\u{001B}\u{0013}\u{001B}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         23|\
         26|\
         27|\
         27|\
         21"
    );
}

#[test]
fn lookupflag_ignore_ligatures_002() {
    assert_eq!(
        shape(
            "tests/fonts/aots/lookupflag_ignore_ligatures_f1.otf",
            "\u{0011}\u{0012}\u{001A}\u{0018}\u{0013}\u{001B}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         18|\
         26|\
         24|\
         19|\
         27|\
         20|\
         21"
    );
}

#[test]
fn lookupflag_ignore_ligatures_003() {
    assert_eq!(
        shape(
            "tests/fonts/aots/lookupflag_ignore_ligatures_f1.otf",
            "\u{0011}\u{0012}\u{001A}\u{002A}\u{0013}\u{001B}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         18|\
         26|\
         42|\
         19|\
         27|\
         20|\
         21"
    );
}

#[test]
fn lookupflag_ignore_marks_001() {
    assert_eq!(
        shape(
            "tests/fonts/aots/lookupflag_ignore_marks_f1.otf",
            "\u{0011}\u{0012}\u{001C}\u{001D}\u{0013}\u{001D}\u{0014}\u{0015}",
            "--features=\"test\" --no-clusters --no-glyph-names --no-positions",
        ),
        "17|\
         23|\
         28|\
         29|\
         29|\
         21"
    );
}

