#![deny(missing_docs)]

//! Rust bindings to QuickJS.

mod call_context;
mod context;
pub mod error;
#[cfg(feature = "local")]
mod local;
mod quickjs_rc;
mod runtime;
mod support;
mod value;

pub use call_context::CallContext;
pub use context::JSContext;
pub use context::OwnedJSContext;
#[cfg(feature = "local")]
pub use local::Local;
pub use quickjs_rc::QuickjsRc;
pub use runtime::JSRuntime;
pub use runtime::OwnedJSRuntime;
pub use value::JSValue;
