/* automatically generated by rust-bindgen 0.58.0 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const _ERRNO_H: u32 = 1;
pub const _FEATURES_H: u32 = 1;
pub const _DEFAULT_SOURCE: u32 = 1;
pub const __GLIBC_USE_ISOC2X: u32 = 0;
pub const __USE_ISOC11: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __USE_MISC: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_GETS: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_SCANF: u32 = 0;
pub const _STDC_PREDEF_H: u32 = 1;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_ISO_10646__: u32 = 201706;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 31;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __glibc_c99_flexarr_available: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
pub const __SYSCALL_WORDSIZE: u32 = 64;
pub const __LONG_DOUBLE_USES_FLOAT128: u32 = 0;
pub const __HAVE_GENERIC_SELECTION: u32 = 1;
pub const _BITS_ERRNO_H: u32 = 1;
pub const EPERM: u32 = 1;
pub const ENOENT: u32 = 2;
pub const ESRCH: u32 = 3;
pub const EINTR: u32 = 4;
pub const EIO: u32 = 5;
pub const ENXIO: u32 = 6;
pub const E2BIG: u32 = 7;
pub const ENOEXEC: u32 = 8;
pub const EBADF: u32 = 9;
pub const ECHILD: u32 = 10;
pub const EAGAIN: u32 = 11;
pub const ENOMEM: u32 = 12;
pub const EACCES: u32 = 13;
pub const EFAULT: u32 = 14;
pub const ENOTBLK: u32 = 15;
pub const EBUSY: u32 = 16;
pub const EEXIST: u32 = 17;
pub const EXDEV: u32 = 18;
pub const ENODEV: u32 = 19;
pub const ENOTDIR: u32 = 20;
pub const EISDIR: u32 = 21;
pub const EINVAL: u32 = 22;
pub const ENFILE: u32 = 23;
pub const EMFILE: u32 = 24;
pub const ENOTTY: u32 = 25;
pub const ETXTBSY: u32 = 26;
pub const EFBIG: u32 = 27;
pub const ENOSPC: u32 = 28;
pub const ESPIPE: u32 = 29;
pub const EROFS: u32 = 30;
pub const EMLINK: u32 = 31;
pub const EPIPE: u32 = 32;
pub const EDOM: u32 = 33;
pub const ERANGE: u32 = 34;
pub const EDEADLK: u32 = 35;
pub const ENAMETOOLONG: u32 = 36;
pub const ENOLCK: u32 = 37;
pub const ENOSYS: u32 = 38;
pub const ENOTEMPTY: u32 = 39;
pub const ELOOP: u32 = 40;
pub const EWOULDBLOCK: u32 = 11;
pub const ENOMSG: u32 = 42;
pub const EIDRM: u32 = 43;
pub const ECHRNG: u32 = 44;
pub const EL2NSYNC: u32 = 45;
pub const EL3HLT: u32 = 46;
pub const EL3RST: u32 = 47;
pub const ELNRNG: u32 = 48;
pub const EUNATCH: u32 = 49;
pub const ENOCSI: u32 = 50;
pub const EL2HLT: u32 = 51;
pub const EBADE: u32 = 52;
pub const EBADR: u32 = 53;
pub const EXFULL: u32 = 54;
pub const ENOANO: u32 = 55;
pub const EBADRQC: u32 = 56;
pub const EBADSLT: u32 = 57;
pub const EDEADLOCK: u32 = 35;
pub const EBFONT: u32 = 59;
pub const ENOSTR: u32 = 60;
pub const ENODATA: u32 = 61;
pub const ETIME: u32 = 62;
pub const ENOSR: u32 = 63;
pub const ENONET: u32 = 64;
pub const ENOPKG: u32 = 65;
pub const EREMOTE: u32 = 66;
pub const ENOLINK: u32 = 67;
pub const EADV: u32 = 68;
pub const ESRMNT: u32 = 69;
pub const ECOMM: u32 = 70;
pub const EPROTO: u32 = 71;
pub const EMULTIHOP: u32 = 72;
pub const EDOTDOT: u32 = 73;
pub const EBADMSG: u32 = 74;
pub const EOVERFLOW: u32 = 75;
pub const ENOTUNIQ: u32 = 76;
pub const EBADFD: u32 = 77;
pub const EREMCHG: u32 = 78;
pub const ELIBACC: u32 = 79;
pub const ELIBBAD: u32 = 80;
pub const ELIBSCN: u32 = 81;
pub const ELIBMAX: u32 = 82;
pub const ELIBEXEC: u32 = 83;
pub const EILSEQ: u32 = 84;
pub const ERESTART: u32 = 85;
pub const ESTRPIPE: u32 = 86;
pub const EUSERS: u32 = 87;
pub const ENOTSOCK: u32 = 88;
pub const EDESTADDRREQ: u32 = 89;
pub const EMSGSIZE: u32 = 90;
pub const EPROTOTYPE: u32 = 91;
pub const ENOPROTOOPT: u32 = 92;
pub const EPROTONOSUPPORT: u32 = 93;
pub const ESOCKTNOSUPPORT: u32 = 94;
pub const EOPNOTSUPP: u32 = 95;
pub const EPFNOSUPPORT: u32 = 96;
pub const EAFNOSUPPORT: u32 = 97;
pub const EADDRINUSE: u32 = 98;
pub const EADDRNOTAVAIL: u32 = 99;
pub const ENETDOWN: u32 = 100;
pub const ENETUNREACH: u32 = 101;
pub const ENETRESET: u32 = 102;
pub const ECONNABORTED: u32 = 103;
pub const ECONNRESET: u32 = 104;
pub const ENOBUFS: u32 = 105;
pub const EISCONN: u32 = 106;
pub const ENOTCONN: u32 = 107;
pub const ESHUTDOWN: u32 = 108;
pub const ETOOMANYREFS: u32 = 109;
pub const ETIMEDOUT: u32 = 110;
pub const ECONNREFUSED: u32 = 111;
pub const EHOSTDOWN: u32 = 112;
pub const EHOSTUNREACH: u32 = 113;
pub const EALREADY: u32 = 114;
pub const EINPROGRESS: u32 = 115;
pub const ESTALE: u32 = 116;
pub const EUCLEAN: u32 = 117;
pub const ENOTNAM: u32 = 118;
pub const ENAVAIL: u32 = 119;
pub const EISNAM: u32 = 120;
pub const EREMOTEIO: u32 = 121;
pub const EDQUOT: u32 = 122;
pub const ENOMEDIUM: u32 = 123;
pub const EMEDIUMTYPE: u32 = 124;
pub const ECANCELED: u32 = 125;
pub const ENOKEY: u32 = 126;
pub const EKEYEXPIRED: u32 = 127;
pub const EKEYREVOKED: u32 = 128;
pub const EKEYREJECTED: u32 = 129;
pub const EOWNERDEAD: u32 = 130;
pub const ENOTRECOVERABLE: u32 = 131;
pub const ERFKILL: u32 = 132;
pub const EHWPOISON: u32 = 133;
pub const ENOTSUP: u32 = 95;
pub const _STDINT_H: u32 = 1;
pub const __GLIBC_USE_LIB_EXT2: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_TYPES_EXT: u32 = 0;
pub const _BITS_TYPES_H: u32 = 1;
pub const __TIMESIZE: u32 = 64;
pub const _BITS_TYPESIZES_H: u32 = 1;
pub const __OFF_T_MATCHES_OFF64_T: u32 = 1;
pub const __INO_T_MATCHES_INO64_T: u32 = 1;
pub const __RLIM_T_MATCHES_RLIM64_T: u32 = 1;
pub const __STATFS_MATCHES_STATFS64: u32 = 1;
pub const __FD_SETSIZE: u32 = 1024;
pub const _BITS_TIME64_H: u32 = 1;
pub const _BITS_WCHAR_H: u32 = 1;
pub const _BITS_STDINT_INTN_H: u32 = 1;
pub const _BITS_STDINT_UINTN_H: u32 = 1;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i64 = -9223372036854775808;
pub const INT_FAST32_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u64 = 9223372036854775807;
pub const INT_FAST32_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: i32 = -1;
pub const UINT_FAST32_MAX: i32 = -1;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const UINTPTR_MAX: i32 = -1;
pub const PTRDIFF_MIN: i64 = -9223372036854775808;
pub const PTRDIFF_MAX: u64 = 9223372036854775807;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIZE_MAX: i32 = -1;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 4294967295;
pub const FF_LAMBDA_SHIFT: u32 = 7;
pub const FF_LAMBDA_SCALE: u32 = 128;
pub const FF_QP2LAMBDA: u32 = 118;
pub const FF_LAMBDA_MAX: u32 = 32767;
pub const FF_QUALITY_SCALE: u32 = 128;
pub const AV_TIME_BASE: u32 = 1000000;
pub const _INTTYPES_H: u32 = 1;
pub const ____gwchar_t_defined: u32 = 1;
pub const __PRI64_PREFIX: &'static [u8; 2usize] = b"l\0";
pub const __PRIPTR_PREFIX: &'static [u8; 2usize] = b"l\0";
pub const PRId8: &'static [u8; 2usize] = b"d\0";
pub const PRId16: &'static [u8; 2usize] = b"d\0";
pub const PRId32: &'static [u8; 2usize] = b"d\0";
pub const PRId64: &'static [u8; 3usize] = b"ld\0";
pub const PRIdLEAST8: &'static [u8; 2usize] = b"d\0";
pub const PRIdLEAST16: &'static [u8; 2usize] = b"d\0";
pub const PRIdLEAST32: &'static [u8; 2usize] = b"d\0";
pub const PRIdLEAST64: &'static [u8; 3usize] = b"ld\0";
pub const PRIdFAST8: &'static [u8; 2usize] = b"d\0";
pub const PRIdFAST16: &'static [u8; 3usize] = b"ld\0";
pub const PRIdFAST32: &'static [u8; 3usize] = b"ld\0";
pub const PRIdFAST64: &'static [u8; 3usize] = b"ld\0";
pub const PRIi8: &'static [u8; 2usize] = b"i\0";
pub const PRIi16: &'static [u8; 2usize] = b"i\0";
pub const PRIi32: &'static [u8; 2usize] = b"i\0";
pub const PRIi64: &'static [u8; 3usize] = b"li\0";
pub const PRIiLEAST8: &'static [u8; 2usize] = b"i\0";
pub const PRIiLEAST16: &'static [u8; 2usize] = b"i\0";
pub const PRIiLEAST32: &'static [u8; 2usize] = b"i\0";
pub const PRIiLEAST64: &'static [u8; 3usize] = b"li\0";
pub const PRIiFAST8: &'static [u8; 2usize] = b"i\0";
pub const PRIiFAST16: &'static [u8; 3usize] = b"li\0";
pub const PRIiFAST32: &'static [u8; 3usize] = b"li\0";
pub const PRIiFAST64: &'static [u8; 3usize] = b"li\0";
pub const PRIo8: &'static [u8; 2usize] = b"o\0";
pub const PRIo16: &'static [u8; 2usize] = b"o\0";
pub const PRIo32: &'static [u8; 2usize] = b"o\0";
pub const PRIo64: &'static [u8; 3usize] = b"lo\0";
pub const PRIoLEAST8: &'static [u8; 2usize] = b"o\0";
pub const PRIoLEAST16: &'static [u8; 2usize] = b"o\0";
pub const PRIoLEAST32: &'static [u8; 2usize] = b"o\0";
pub const PRIoLEAST64: &'static [u8; 3usize] = b"lo\0";
pub const PRIoFAST8: &'static [u8; 2usize] = b"o\0";
pub const PRIoFAST16: &'static [u8; 3usize] = b"lo\0";
pub const PRIoFAST32: &'static [u8; 3usize] = b"lo\0";
pub const PRIoFAST64: &'static [u8; 3usize] = b"lo\0";
pub const PRIu8: &'static [u8; 2usize] = b"u\0";
pub const PRIu16: &'static [u8; 2usize] = b"u\0";
pub const PRIu32: &'static [u8; 2usize] = b"u\0";
pub const PRIu64: &'static [u8; 3usize] = b"lu\0";
pub const PRIuLEAST8: &'static [u8; 2usize] = b"u\0";
pub const PRIuLEAST16: &'static [u8; 2usize] = b"u\0";
pub const PRIuLEAST32: &'static [u8; 2usize] = b"u\0";
pub const PRIuLEAST64: &'static [u8; 3usize] = b"lu\0";
pub const PRIuFAST8: &'static [u8; 2usize] = b"u\0";
pub const PRIuFAST16: &'static [u8; 3usize] = b"lu\0";
pub const PRIuFAST32: &'static [u8; 3usize] = b"lu\0";
pub const PRIuFAST64: &'static [u8; 3usize] = b"lu\0";
pub const PRIx8: &'static [u8; 2usize] = b"x\0";
pub const PRIx16: &'static [u8; 2usize] = b"x\0";
pub const PRIx32: &'static [u8; 2usize] = b"x\0";
pub const PRIx64: &'static [u8; 3usize] = b"lx\0";
pub const PRIxLEAST8: &'static [u8; 2usize] = b"x\0";
pub const PRIxLEAST16: &'static [u8; 2usize] = b"x\0";
pub const PRIxLEAST32: &'static [u8; 2usize] = b"x\0";
pub const PRIxLEAST64: &'static [u8; 3usize] = b"lx\0";
pub const PRIxFAST8: &'static [u8; 2usize] = b"x\0";
pub const PRIxFAST16: &'static [u8; 3usize] = b"lx\0";
pub const PRIxFAST32: &'static [u8; 3usize] = b"lx\0";
pub const PRIxFAST64: &'static [u8; 3usize] = b"lx\0";
pub const PRIX8: &'static [u8; 2usize] = b"X\0";
pub const PRIX16: &'static [u8; 2usize] = b"X\0";
pub const PRIX32: &'static [u8; 2usize] = b"X\0";
pub const PRIX64: &'static [u8; 3usize] = b"lX\0";
pub const PRIXLEAST8: &'static [u8; 2usize] = b"X\0";
pub const PRIXLEAST16: &'static [u8; 2usize] = b"X\0";
pub const PRIXLEAST32: &'static [u8; 2usize] = b"X\0";
pub const PRIXLEAST64: &'static [u8; 3usize] = b"lX\0";
pub const PRIXFAST8: &'static [u8; 2usize] = b"X\0";
pub const PRIXFAST16: &'static [u8; 3usize] = b"lX\0";
pub const PRIXFAST32: &'static [u8; 3usize] = b"lX\0";
pub const PRIXFAST64: &'static [u8; 3usize] = b"lX\0";
pub const PRIdMAX: &'static [u8; 3usize] = b"ld\0";
pub const PRIiMAX: &'static [u8; 3usize] = b"li\0";
pub const PRIoMAX: &'static [u8; 3usize] = b"lo\0";
pub const PRIuMAX: &'static [u8; 3usize] = b"lu\0";
pub const PRIxMAX: &'static [u8; 3usize] = b"lx\0";
pub const PRIXMAX: &'static [u8; 3usize] = b"lX\0";
pub const PRIdPTR: &'static [u8; 3usize] = b"ld\0";
pub const PRIiPTR: &'static [u8; 3usize] = b"li\0";
pub const PRIoPTR: &'static [u8; 3usize] = b"lo\0";
pub const PRIuPTR: &'static [u8; 3usize] = b"lu\0";
pub const PRIxPTR: &'static [u8; 3usize] = b"lx\0";
pub const PRIXPTR: &'static [u8; 3usize] = b"lX\0";
pub const SCNd8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNd16: &'static [u8; 3usize] = b"hd\0";
pub const SCNd32: &'static [u8; 2usize] = b"d\0";
pub const SCNd64: &'static [u8; 3usize] = b"ld\0";
pub const SCNdLEAST8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNdLEAST16: &'static [u8; 3usize] = b"hd\0";
pub const SCNdLEAST32: &'static [u8; 2usize] = b"d\0";
pub const SCNdLEAST64: &'static [u8; 3usize] = b"ld\0";
pub const SCNdFAST8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNdFAST16: &'static [u8; 3usize] = b"ld\0";
pub const SCNdFAST32: &'static [u8; 3usize] = b"ld\0";
pub const SCNdFAST64: &'static [u8; 3usize] = b"ld\0";
pub const SCNi8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNi16: &'static [u8; 3usize] = b"hi\0";
pub const SCNi32: &'static [u8; 2usize] = b"i\0";
pub const SCNi64: &'static [u8; 3usize] = b"li\0";
pub const SCNiLEAST8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNiLEAST16: &'static [u8; 3usize] = b"hi\0";
pub const SCNiLEAST32: &'static [u8; 2usize] = b"i\0";
pub const SCNiLEAST64: &'static [u8; 3usize] = b"li\0";
pub const SCNiFAST8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNiFAST16: &'static [u8; 3usize] = b"li\0";
pub const SCNiFAST32: &'static [u8; 3usize] = b"li\0";
pub const SCNiFAST64: &'static [u8; 3usize] = b"li\0";
pub const SCNu8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNu16: &'static [u8; 3usize] = b"hu\0";
pub const SCNu32: &'static [u8; 2usize] = b"u\0";
pub const SCNu64: &'static [u8; 3usize] = b"lu\0";
pub const SCNuLEAST8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNuLEAST16: &'static [u8; 3usize] = b"hu\0";
pub const SCNuLEAST32: &'static [u8; 2usize] = b"u\0";
pub const SCNuLEAST64: &'static [u8; 3usize] = b"lu\0";
pub const SCNuFAST8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNuFAST16: &'static [u8; 3usize] = b"lu\0";
pub const SCNuFAST32: &'static [u8; 3usize] = b"lu\0";
pub const SCNuFAST64: &'static [u8; 3usize] = b"lu\0";
pub const SCNo8: &'static [u8; 4usize] = b"hho\0";
pub const SCNo16: &'static [u8; 3usize] = b"ho\0";
pub const SCNo32: &'static [u8; 2usize] = b"o\0";
pub const SCNo64: &'static [u8; 3usize] = b"lo\0";
pub const SCNoLEAST8: &'static [u8; 4usize] = b"hho\0";
pub const SCNoLEAST16: &'static [u8; 3usize] = b"ho\0";
pub const SCNoLEAST32: &'static [u8; 2usize] = b"o\0";
pub const SCNoLEAST64: &'static [u8; 3usize] = b"lo\0";
pub const SCNoFAST8: &'static [u8; 4usize] = b"hho\0";
pub const SCNoFAST16: &'static [u8; 3usize] = b"lo\0";
pub const SCNoFAST32: &'static [u8; 3usize] = b"lo\0";
pub const SCNoFAST64: &'static [u8; 3usize] = b"lo\0";
pub const SCNx8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNx16: &'static [u8; 3usize] = b"hx\0";
pub const SCNx32: &'static [u8; 2usize] = b"x\0";
pub const SCNx64: &'static [u8; 3usize] = b"lx\0";
pub const SCNxLEAST8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNxLEAST16: &'static [u8; 3usize] = b"hx\0";
pub const SCNxLEAST32: &'static [u8; 2usize] = b"x\0";
pub const SCNxLEAST64: &'static [u8; 3usize] = b"lx\0";
pub const SCNxFAST8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNxFAST16: &'static [u8; 3usize] = b"lx\0";
pub const SCNxFAST32: &'static [u8; 3usize] = b"lx\0";
pub const SCNxFAST64: &'static [u8; 3usize] = b"lx\0";
pub const SCNdMAX: &'static [u8; 3usize] = b"ld\0";
pub const SCNiMAX: &'static [u8; 3usize] = b"li\0";
pub const SCNoMAX: &'static [u8; 3usize] = b"lo\0";
pub const SCNuMAX: &'static [u8; 3usize] = b"lu\0";
pub const SCNxMAX: &'static [u8; 3usize] = b"lx\0";
pub const SCNdPTR: &'static [u8; 3usize] = b"ld\0";
pub const SCNiPTR: &'static [u8; 3usize] = b"li\0";
pub const SCNoPTR: &'static [u8; 3usize] = b"lo\0";
pub const SCNuPTR: &'static [u8; 3usize] = b"lu\0";
pub const SCNxPTR: &'static [u8; 3usize] = b"lx\0";
pub const _LIBC_LIMITS_H_: u32 = 1;
pub const MB_LEN_MAX: u32 = 16;
pub const _BITS_POSIX1_LIM_H: u32 = 1;
pub const _POSIX_AIO_LISTIO_MAX: u32 = 2;
pub const _POSIX_AIO_MAX: u32 = 1;
pub const _POSIX_ARG_MAX: u32 = 4096;
pub const _POSIX_CHILD_MAX: u32 = 25;
pub const _POSIX_DELAYTIMER_MAX: u32 = 32;
pub const _POSIX_HOST_NAME_MAX: u32 = 255;
pub const _POSIX_LINK_MAX: u32 = 8;
pub const _POSIX_LOGIN_NAME_MAX: u32 = 9;
pub const _POSIX_MAX_CANON: u32 = 255;
pub const _POSIX_MAX_INPUT: u32 = 255;
pub const _POSIX_MQ_OPEN_MAX: u32 = 8;
pub const _POSIX_MQ_PRIO_MAX: u32 = 32;
pub const _POSIX_NAME_MAX: u32 = 14;
pub const _POSIX_NGROUPS_MAX: u32 = 8;
pub const _POSIX_OPEN_MAX: u32 = 20;
pub const _POSIX_PATH_MAX: u32 = 256;
pub const _POSIX_PIPE_BUF: u32 = 512;
pub const _POSIX_RE_DUP_MAX: u32 = 255;
pub const _POSIX_RTSIG_MAX: u32 = 8;
pub const _POSIX_SEM_NSEMS_MAX: u32 = 256;
pub const _POSIX_SEM_VALUE_MAX: u32 = 32767;
pub const _POSIX_SIGQUEUE_MAX: u32 = 32;
pub const _POSIX_SSIZE_MAX: u32 = 32767;
pub const _POSIX_STREAM_MAX: u32 = 8;
pub const _POSIX_SYMLINK_MAX: u32 = 255;
pub const _POSIX_SYMLOOP_MAX: u32 = 8;
pub const _POSIX_TIMER_MAX: u32 = 32;
pub const _POSIX_TTY_NAME_MAX: u32 = 9;
pub const _POSIX_TZNAME_MAX: u32 = 6;
pub const _POSIX_CLOCKRES_MIN: u32 = 20000000;
pub const NR_OPEN: u32 = 1024;
pub const NGROUPS_MAX: u32 = 65536;
pub const ARG_MAX: u32 = 131072;
pub const LINK_MAX: u32 = 127;
pub const MAX_CANON: u32 = 255;
pub const MAX_INPUT: u32 = 255;
pub const NAME_MAX: u32 = 255;
pub const PATH_MAX: u32 = 4096;
pub const PIPE_BUF: u32 = 4096;
pub const XATTR_NAME_MAX: u32 = 255;
pub const XATTR_SIZE_MAX: u32 = 65536;
pub const XATTR_LIST_MAX: u32 = 65536;
pub const RTSIG_MAX: u32 = 32;
pub const _POSIX_THREAD_KEYS_MAX: u32 = 128;
pub const PTHREAD_KEYS_MAX: u32 = 1024;
pub const _POSIX_THREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const PTHREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const _POSIX_THREAD_THREADS_MAX: u32 = 64;
pub const AIO_PRIO_DELTA_MAX: u32 = 20;
pub const PTHREAD_STACK_MIN: u32 = 16384;
pub const DELAYTIMER_MAX: u32 = 2147483647;
pub const TTY_NAME_MAX: u32 = 32;
pub const LOGIN_NAME_MAX: u32 = 256;
pub const HOST_NAME_MAX: u32 = 64;
pub const MQ_PRIO_MAX: u32 = 32768;
pub const SEM_VALUE_MAX: u32 = 2147483647;
pub const _BITS_POSIX2_LIM_H: u32 = 1;
pub const _POSIX2_BC_BASE_MAX: u32 = 99;
pub const _POSIX2_BC_DIM_MAX: u32 = 2048;
pub const _POSIX2_BC_SCALE_MAX: u32 = 99;
pub const _POSIX2_BC_STRING_MAX: u32 = 1000;
pub const _POSIX2_COLL_WEIGHTS_MAX: u32 = 2;
pub const _POSIX2_EXPR_NEST_MAX: u32 = 32;
pub const _POSIX2_LINE_MAX: u32 = 2048;
pub const _POSIX2_RE_DUP_MAX: u32 = 255;
pub const _POSIX2_CHARCLASS_NAME_MAX: u32 = 14;
pub const BC_BASE_MAX: u32 = 99;
pub const BC_DIM_MAX: u32 = 2048;
pub const BC_SCALE_MAX: u32 = 99;
pub const BC_STRING_MAX: u32 = 1000;
pub const COLL_WEIGHTS_MAX: u32 = 255;
pub const EXPR_NEST_MAX: u32 = 32;
pub const LINE_MAX: u32 = 2048;
pub const CHARCLASS_NAME_MAX: u32 = 2048;
pub const RE_DUP_MAX: u32 = 32767;
pub const _MATH_H: u32 = 1;
pub const _BITS_LIBM_SIMD_DECL_STUBS_H: u32 = 1;
pub const __HAVE_FLOAT128: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT128: u32 = 0;
pub const __HAVE_FLOAT64X: u32 = 1;
pub const __HAVE_FLOAT64X_LONG_DOUBLE: u32 = 1;
pub const __HAVE_FLOAT16: u32 = 0;
pub const __HAVE_FLOAT32: u32 = 1;
pub const __HAVE_FLOAT64: u32 = 1;
pub const __HAVE_FLOAT32X: u32 = 1;
pub const __HAVE_FLOAT128X: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT16: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT32: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT64: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT32X: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT64X: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT128X: u32 = 0;
pub const __HAVE_FLOATN_NOT_TYPEDEF: u32 = 0;
pub const __FP_LOGB0_IS_MIN: u32 = 1;
pub const __FP_LOGBNAN_IS_MIN: u32 = 1;
pub const FP_ILOGB0: i32 = -2147483648;
pub const FP_ILOGBNAN: i32 = -2147483648;
pub const __MATH_DECLARING_DOUBLE: u32 = 1;
pub const __MATH_DECLARING_FLOATN: u32 = 0;
pub const __MATH_DECLARE_LDOUBLE: u32 = 1;
pub const MATH_ERRNO: u32 = 1;
pub const MATH_ERREXCEPT: u32 = 2;
pub const math_errhandling: u32 = 3;
pub const M_E: f64 = 2.718281828459045;
pub const M_LOG2E: f64 = 1.4426950408889634;
pub const M_LOG10E: f64 = 0.4342944819032518;
pub const M_LN2: f64 = 0.6931471805599453;
pub const M_LN10: f64 = 2.302585092994046;
pub const M_PI: f64 = 3.141592653589793;
pub const M_PI_2: f64 = 1.5707963267948966;
pub const M_PI_4: f64 = 0.7853981633974483;
pub const M_1_PI: f64 = 0.3183098861837907;
pub const M_2_PI: f64 = 0.6366197723675814;
pub const M_2_SQRTPI: f64 = 1.1283791670955126;
pub const M_SQRT2: f64 = 1.4142135623730951;
pub const M_SQRT1_2: f64 = 0.7071067811865476;
pub const _STDIO_H: u32 = 1;
pub const __GNUC_VA_LIST: u32 = 1;
pub const _____fpos_t_defined: u32 = 1;
pub const ____mbstate_t_defined: u32 = 1;
pub const _____fpos64_t_defined: u32 = 1;
pub const ____FILE_defined: u32 = 1;
pub const __FILE_defined: u32 = 1;
pub const __struct_FILE_defined: u32 = 1;
pub const _IO_EOF_SEEN: u32 = 16;
pub const _IO_ERR_SEEN: u32 = 32;
pub const _IO_USER_LOCK: u32 = 32768;
pub const _IOFBF: u32 = 0;
pub const _IOLBF: u32 = 1;
pub const _IONBF: u32 = 2;
pub const BUFSIZ: u32 = 8192;
pub const EOF: i32 = -1;
pub const SEEK_SET: u32 = 0;
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub const P_tmpdir: &'static [u8; 5usize] = b"/tmp\0";
pub const _BITS_STDIO_LIM_H: u32 = 1;
pub const L_tmpnam: u32 = 20;
pub const TMP_MAX: u32 = 238328;
pub const FILENAME_MAX: u32 = 4096;
pub const L_ctermid: u32 = 9;
pub const FOPEN_MAX: u32 = 16;
pub const _STDLIB_H: u32 = 1;
pub const WNOHANG: u32 = 1;
pub const WUNTRACED: u32 = 2;
pub const WSTOPPED: u32 = 2;
pub const WEXITED: u32 = 4;
pub const WCONTINUED: u32 = 8;
pub const WNOWAIT: u32 = 16777216;
pub const __WNOTHREAD: u32 = 536870912;
pub const __WALL: u32 = 1073741824;
pub const __WCLONE: u32 = 2147483648;
pub const __ENUM_IDTYPE_T: u32 = 1;
pub const __W_CONTINUED: u32 = 65535;
pub const __WCOREFLAG: u32 = 128;
pub const __ldiv_t_defined: u32 = 1;
pub const __lldiv_t_defined: u32 = 1;
pub const RAND_MAX: u32 = 2147483647;
pub const EXIT_FAILURE: u32 = 1;
pub const EXIT_SUCCESS: u32 = 0;
pub const _SYS_TYPES_H: u32 = 1;
pub const __clock_t_defined: u32 = 1;
pub const __clockid_t_defined: u32 = 1;
pub const __time_t_defined: u32 = 1;
pub const __timer_t_defined: u32 = 1;
pub const __BIT_TYPES_DEFINED__: u32 = 1;
pub const _ENDIAN_H: u32 = 1;
pub const _BITS_ENDIAN_H: u32 = 1;
pub const __LITTLE_ENDIAN: u32 = 1234;
pub const __BIG_ENDIAN: u32 = 4321;
pub const __PDP_ENDIAN: u32 = 3412;
pub const _BITS_ENDIANNESS_H: u32 = 1;
pub const __BYTE_ORDER: u32 = 1234;
pub const __FLOAT_WORD_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const _BITS_BYTESWAP_H: u32 = 1;
pub const _BITS_UINTN_IDENTITY_H: u32 = 1;
pub const _SYS_SELECT_H: u32 = 1;
pub const __FD_ZERO_STOS: &'static [u8; 6usize] = b"stosq\0";
pub const __sigset_t_defined: u32 = 1;
pub const __timeval_defined: u32 = 1;
pub const _STRUCT_TIMESPEC: u32 = 1;
pub const FD_SETSIZE: u32 = 1024;
pub const _BITS_PTHREADTYPES_COMMON_H: u32 = 1;
pub const _THREAD_SHARED_TYPES_H: u32 = 1;
pub const _BITS_PTHREADTYPES_ARCH_H: u32 = 1;
pub const __SIZEOF_PTHREAD_MUTEX_T: u32 = 40;
pub const __SIZEOF_PTHREAD_ATTR_T: u32 = 56;
pub const __SIZEOF_PTHREAD_RWLOCK_T: u32 = 56;
pub const __SIZEOF_PTHREAD_BARRIER_T: u32 = 32;
pub const __SIZEOF_PTHREAD_MUTEXATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_COND_T: u32 = 48;
pub const __SIZEOF_PTHREAD_CONDATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_RWLOCKATTR_T: u32 = 8;
pub const __SIZEOF_PTHREAD_BARRIERATTR_T: u32 = 4;
pub const _THREAD_MUTEX_INTERNAL_H: u32 = 1;
pub const __PTHREAD_MUTEX_HAVE_PREV: u32 = 1;
pub const __have_pthread_attr_t: u32 = 1;
pub const _ALLOCA_H: u32 = 1;
pub const _STRING_H: u32 = 1;
pub const _BITS_TYPES_LOCALE_T_H: u32 = 1;
pub const _BITS_TYPES___LOCALE_T_H: u32 = 1;
pub const _STRINGS_H: u32 = 1;
pub const LIBAVUTIL_VERSION_MAJOR: u32 = 57;
pub const LIBAVUTIL_VERSION_MINOR: u32 = 0;
pub const LIBAVUTIL_VERSION_MICRO: u32 = 100;
pub const AV_HAVE_BIGENDIAN: u32 = 0;
pub const AV_HAVE_FAST_UNALIGNED: u32 = 1;
pub const AVERROR_EXPERIMENTAL: i32 = -733130664;
pub const AVERROR_INPUT_CHANGED: i32 = -1668179713;
pub const AVERROR_OUTPUT_CHANGED: i32 = -1668179714;
pub const AV_ERROR_MAX_STRING_SIZE: u32 = 64;
pub const M_LOG2_10: f64 = 3.321928094887362;
pub const M_PHI: f64 = 1.618033988749895;
pub const AV_LOG_QUIET: i32 = -8;
pub const AV_LOG_PANIC: u32 = 0;
pub const AV_LOG_FATAL: u32 = 8;
pub const AV_LOG_ERROR: u32 = 16;
pub const AV_LOG_WARNING: u32 = 24;
pub const AV_LOG_INFO: u32 = 32;
pub const AV_LOG_VERBOSE: u32 = 40;
pub const AV_LOG_DEBUG: u32 = 48;
pub const AV_LOG_TRACE: u32 = 56;
pub const AV_LOG_MAX_OFFSET: u32 = 64;
pub const AV_LOG_SKIP_REPEATED: u32 = 1;
pub const AV_LOG_PRINT_LEVEL: u32 = 2;
pub const AVPALETTE_SIZE: u32 = 1024;
pub const AVPALETTE_COUNT: u32 = 256;
pub const AV_FOURCC_MAX_STRING_SIZE: u32 = 32;
pub const AV_BUFFER_FLAG_READONLY: u32 = 1;
pub const AV_CPU_FLAG_FORCE: u32 = 2147483648;
pub const AV_CPU_FLAG_MMX: u32 = 1;
pub const AV_CPU_FLAG_MMXEXT: u32 = 2;
pub const AV_CPU_FLAG_MMX2: u32 = 2;
pub const AV_CPU_FLAG_3DNOW: u32 = 4;
pub const AV_CPU_FLAG_SSE: u32 = 8;
pub const AV_CPU_FLAG_SSE2: u32 = 16;
pub const AV_CPU_FLAG_SSE2SLOW: u32 = 1073741824;
pub const AV_CPU_FLAG_3DNOWEXT: u32 = 32;
pub const AV_CPU_FLAG_SSE3: u32 = 64;
pub const AV_CPU_FLAG_SSE3SLOW: u32 = 536870912;
pub const AV_CPU_FLAG_SSSE3: u32 = 128;
pub const AV_CPU_FLAG_SSSE3SLOW: u32 = 67108864;
pub const AV_CPU_FLAG_ATOM: u32 = 268435456;
pub const AV_CPU_FLAG_SSE4: u32 = 256;
pub const AV_CPU_FLAG_SSE42: u32 = 512;
pub const AV_CPU_FLAG_AESNI: u32 = 524288;
pub const AV_CPU_FLAG_AVX: u32 = 16384;
pub const AV_CPU_FLAG_AVXSLOW: u32 = 134217728;
pub const AV_CPU_FLAG_XOP: u32 = 1024;
pub const AV_CPU_FLAG_FMA4: u32 = 2048;
pub const AV_CPU_FLAG_CMOV: u32 = 4096;
pub const AV_CPU_FLAG_AVX2: u32 = 32768;
pub const AV_CPU_FLAG_FMA3: u32 = 65536;
pub const AV_CPU_FLAG_BMI1: u32 = 131072;
pub const AV_CPU_FLAG_BMI2: u32 = 262144;
pub const AV_CPU_FLAG_AVX512: u32 = 1048576;
pub const AV_CPU_FLAG_ALTIVEC: u32 = 1;
pub const AV_CPU_FLAG_VSX: u32 = 2;
pub const AV_CPU_FLAG_POWER8: u32 = 4;
pub const AV_CPU_FLAG_ARMV5TE: u32 = 1;
pub const AV_CPU_FLAG_ARMV6: u32 = 2;
pub const AV_CPU_FLAG_ARMV6T2: u32 = 4;
pub const AV_CPU_FLAG_VFP: u32 = 8;
pub const AV_CPU_FLAG_VFPV3: u32 = 16;
pub const AV_CPU_FLAG_NEON: u32 = 32;
pub const AV_CPU_FLAG_ARMV8: u32 = 64;
pub const AV_CPU_FLAG_VFP_VM: u32 = 128;
pub const AV_CPU_FLAG_SETEND: u32 = 65536;
pub const AV_CPU_FLAG_MMI: u32 = 1;
pub const AV_CPU_FLAG_MSA: u32 = 2;
pub const AV_CH_FRONT_LEFT: u32 = 1;
pub const AV_CH_FRONT_RIGHT: u32 = 2;
pub const AV_CH_FRONT_CENTER: u32 = 4;
pub const AV_CH_LOW_FREQUENCY: u32 = 8;
pub const AV_CH_BACK_LEFT: u32 = 16;
pub const AV_CH_BACK_RIGHT: u32 = 32;
pub const AV_CH_FRONT_LEFT_OF_CENTER: u32 = 64;
pub const AV_CH_FRONT_RIGHT_OF_CENTER: u32 = 128;
pub const AV_CH_BACK_CENTER: u32 = 256;
pub const AV_CH_SIDE_LEFT: u32 = 512;
pub const AV_CH_SIDE_RIGHT: u32 = 1024;
pub const AV_CH_TOP_CENTER: u32 = 2048;
pub const AV_CH_TOP_FRONT_LEFT: u32 = 4096;
pub const AV_CH_TOP_FRONT_CENTER: u32 = 8192;
pub const AV_CH_TOP_FRONT_RIGHT: u32 = 16384;
pub const AV_CH_TOP_BACK_LEFT: u32 = 32768;
pub const AV_CH_TOP_BACK_CENTER: u32 = 65536;
pub const AV_CH_TOP_BACK_RIGHT: u32 = 131072;
pub const AV_CH_STEREO_LEFT: u32 = 536870912;
pub const AV_CH_STEREO_RIGHT: u32 = 1073741824;
pub const AV_CH_WIDE_LEFT: u32 = 2147483648;
pub const AV_CH_WIDE_RIGHT: u64 = 4294967296;
pub const AV_CH_SURROUND_DIRECT_LEFT: u64 = 8589934592;
pub const AV_CH_SURROUND_DIRECT_RIGHT: u64 = 17179869184;
pub const AV_CH_LOW_FREQUENCY_2: u64 = 34359738368;
pub const AV_CH_TOP_SIDE_LEFT: u64 = 68719476736;
pub const AV_CH_TOP_SIDE_RIGHT: u64 = 137438953472;
pub const AV_CH_BOTTOM_FRONT_CENTER: u64 = 274877906944;
pub const AV_CH_BOTTOM_FRONT_LEFT: u64 = 549755813888;
pub const AV_CH_BOTTOM_FRONT_RIGHT: u64 = 1099511627776;
pub const AV_CH_LAYOUT_NATIVE: i64 = -9223372036854775808;
pub const AV_CH_LAYOUT_MONO: u32 = 4;
pub const AV_CH_LAYOUT_STEREO: u32 = 3;
pub const AV_CH_LAYOUT_2POINT1: u32 = 11;
pub const AV_CH_LAYOUT_2_1: u32 = 259;
pub const AV_CH_LAYOUT_SURROUND: u32 = 7;
pub const AV_CH_LAYOUT_3POINT1: u32 = 15;
pub const AV_CH_LAYOUT_4POINT0: u32 = 263;
pub const AV_CH_LAYOUT_4POINT1: u32 = 271;
pub const AV_CH_LAYOUT_2_2: u32 = 1539;
pub const AV_CH_LAYOUT_QUAD: u32 = 51;
pub const AV_CH_LAYOUT_5POINT0: u32 = 1543;
pub const AV_CH_LAYOUT_5POINT1: u32 = 1551;
pub const AV_CH_LAYOUT_5POINT0_BACK: u32 = 55;
pub const AV_CH_LAYOUT_5POINT1_BACK: u32 = 63;
pub const AV_CH_LAYOUT_6POINT0: u32 = 1799;
pub const AV_CH_LAYOUT_6POINT0_FRONT: u32 = 1731;
pub const AV_CH_LAYOUT_HEXAGONAL: u32 = 311;
pub const AV_CH_LAYOUT_6POINT1: u32 = 1807;
pub const AV_CH_LAYOUT_6POINT1_BACK: u32 = 319;
pub const AV_CH_LAYOUT_6POINT1_FRONT: u32 = 1739;
pub const AV_CH_LAYOUT_7POINT0: u32 = 1591;
pub const AV_CH_LAYOUT_7POINT0_FRONT: u32 = 1735;
pub const AV_CH_LAYOUT_7POINT1: u32 = 1599;
pub const AV_CH_LAYOUT_7POINT1_WIDE: u32 = 1743;
pub const AV_CH_LAYOUT_7POINT1_WIDE_BACK: u32 = 255;
pub const AV_CH_LAYOUT_OCTAGONAL: u32 = 1847;
pub const AV_CH_LAYOUT_HEXADECAGONAL: u64 = 6442710839;
pub const AV_CH_LAYOUT_STEREO_DOWNMIX: u32 = 1610612736;
pub const AV_CH_LAYOUT_22POINT2: u64 = 2164663779327;
pub const AV_DICT_MATCH_CASE: u32 = 1;
pub const AV_DICT_IGNORE_SUFFIX: u32 = 2;
pub const AV_DICT_DONT_STRDUP_KEY: u32 = 4;
pub const AV_DICT_DONT_STRDUP_VAL: u32 = 8;
pub const AV_DICT_DONT_OVERWRITE: u32 = 16;
pub const AV_DICT_APPEND: u32 = 32;
pub const AV_DICT_MULTIKEY: u32 = 64;
pub const AV_NUM_DATA_POINTERS: u32 = 8;
pub const AV_FRAME_FLAG_CORRUPT: u32 = 1;
pub const AV_FRAME_FLAG_DISCARD: u32 = 4;
pub const FF_DECODE_ERROR_INVALID_BITSTREAM: u32 = 1;
pub const FF_DECODE_ERROR_MISSING_REFERENCE: u32 = 2;
pub const FF_DECODE_ERROR_CONCEALMENT_ACTIVE: u32 = 4;
pub const FF_DECODE_ERROR_DECODE_SLICES: u32 = 8;
pub const LIBAVCODEC_VERSION_MAJOR: u32 = 59;
pub const LIBAVCODEC_VERSION_MINOR: u32 = 1;
pub const LIBAVCODEC_VERSION_MICRO: u32 = 100;
pub const AV_PKT_FLAG_KEY: u32 = 1;
pub const AV_PKT_FLAG_CORRUPT: u32 = 2;
pub const AV_PKT_FLAG_DISCARD: u32 = 4;
pub const AV_PKT_FLAG_TRUSTED: u32 = 8;
pub const AV_PKT_FLAG_DISPOSABLE: u32 = 16;
pub const AV_CODEC_CAP_DRAW_HORIZ_BAND: u32 = 1;
pub const AV_CODEC_CAP_DR1: u32 = 2;
pub const AV_CODEC_CAP_TRUNCATED: u32 = 8;
pub const AV_CODEC_CAP_DELAY: u32 = 32;
pub const AV_CODEC_CAP_SMALL_LAST_FRAME: u32 = 64;
pub const AV_CODEC_CAP_SUBFRAMES: u32 = 256;
pub const AV_CODEC_CAP_EXPERIMENTAL: u32 = 512;
pub const AV_CODEC_CAP_CHANNEL_CONF: u32 = 1024;
pub const AV_CODEC_CAP_FRAME_THREADS: u32 = 4096;
pub const AV_CODEC_CAP_SLICE_THREADS: u32 = 8192;
pub const AV_CODEC_CAP_PARAM_CHANGE: u32 = 16384;
pub const AV_CODEC_CAP_OTHER_THREADS: u32 = 32768;
pub const AV_CODEC_CAP_AUTO_THREADS: u32 = 32768;
pub const AV_CODEC_CAP_VARIABLE_FRAME_SIZE: u32 = 65536;
pub const AV_CODEC_CAP_AVOID_PROBING: u32 = 131072;
pub const AV_CODEC_CAP_INTRA_ONLY: u32 = 1073741824;
pub const AV_CODEC_CAP_LOSSLESS: u32 = 2147483648;
pub const AV_CODEC_CAP_HARDWARE: u32 = 262144;
pub const AV_CODEC_CAP_HYBRID: u32 = 524288;
pub const AV_CODEC_CAP_ENCODER_REORDERED_OPAQUE: u32 = 1048576;
pub const AV_CODEC_CAP_ENCODER_FLUSH: u32 = 2097152;
pub const AV_CODEC_PROP_INTRA_ONLY: u32 = 1;
pub const AV_CODEC_PROP_LOSSY: u32 = 2;
pub const AV_CODEC_PROP_LOSSLESS: u32 = 4;
pub const AV_CODEC_PROP_REORDER: u32 = 8;
pub const AV_CODEC_PROP_BITMAP_SUB: u32 = 65536;
pub const AV_CODEC_PROP_TEXT_SUB: u32 = 131072;
pub const AV_INPUT_BUFFER_PADDING_SIZE: u32 = 64;
pub const AV_INPUT_BUFFER_MIN_SIZE: u32 = 16384;
pub const AV_CODEC_FLAG_UNALIGNED: u32 = 1;
pub const AV_CODEC_FLAG_QSCALE: u32 = 2;
pub const AV_CODEC_FLAG_4MV: u32 = 4;
pub const AV_CODEC_FLAG_OUTPUT_CORRUPT: u32 = 8;
pub const AV_CODEC_FLAG_QPEL: u32 = 16;
pub const AV_CODEC_FLAG_DROPCHANGED: u32 = 32;
pub const AV_CODEC_FLAG_PASS1: u32 = 512;
pub const AV_CODEC_FLAG_PASS2: u32 = 1024;
pub const AV_CODEC_FLAG_LOOP_FILTER: u32 = 2048;
pub const AV_CODEC_FLAG_GRAY: u32 = 8192;
pub const AV_CODEC_FLAG_PSNR: u32 = 32768;
pub const AV_CODEC_FLAG_TRUNCATED: u32 = 65536;
pub const AV_CODEC_FLAG_INTERLACED_DCT: u32 = 262144;
pub const AV_CODEC_FLAG_LOW_DELAY: u32 = 524288;
pub const AV_CODEC_FLAG_GLOBAL_HEADER: u32 = 4194304;
pub const AV_CODEC_FLAG_BITEXACT: u32 = 8388608;
pub const AV_CODEC_FLAG_AC_PRED: u32 = 16777216;
pub const AV_CODEC_FLAG_INTERLACED_ME: u32 = 536870912;
pub const AV_CODEC_FLAG_CLOSED_GOP: u32 = 2147483648;
pub const AV_CODEC_FLAG2_FAST: u32 = 1;
pub const AV_CODEC_FLAG2_NO_OUTPUT: u32 = 4;
pub const AV_CODEC_FLAG2_LOCAL_HEADER: u32 = 8;
pub const AV_CODEC_FLAG2_DROP_FRAME_TIMECODE: u32 = 8192;
pub const AV_CODEC_FLAG2_CHUNKS: u32 = 32768;
pub const AV_CODEC_FLAG2_IGNORE_CROP: u32 = 65536;
pub const AV_CODEC_FLAG2_SHOW_ALL: u32 = 4194304;
pub const AV_CODEC_FLAG2_EXPORT_MVS: u32 = 268435456;
pub const AV_CODEC_FLAG2_SKIP_MANUAL: u32 = 536870912;
pub const AV_CODEC_FLAG2_RO_FLUSH_NOOP: u32 = 1073741824;
pub const AV_CODEC_EXPORT_DATA_MVS: u32 = 1;
pub const AV_CODEC_EXPORT_DATA_PRFT: u32 = 2;
pub const AV_CODEC_EXPORT_DATA_VIDEO_ENC_PARAMS: u32 = 4;
pub const AV_CODEC_EXPORT_DATA_FILM_GRAIN: u32 = 8;
pub const AV_GET_BUFFER_FLAG_REF: u32 = 1;
pub const AV_GET_ENCODE_BUFFER_FLAG_REF: u32 = 1;
pub const FF_COMPRESSION_DEFAULT: i32 = -1;
pub const FF_CMP_SAD: u32 = 0;
pub const FF_CMP_SSE: u32 = 1;
pub const FF_CMP_SATD: u32 = 2;
pub const FF_CMP_DCT: u32 = 3;
pub const FF_CMP_PSNR: u32 = 4;
pub const FF_CMP_BIT: u32 = 5;
pub const FF_CMP_RD: u32 = 6;
pub const FF_CMP_ZERO: u32 = 7;
pub const FF_CMP_VSAD: u32 = 8;
pub const FF_CMP_VSSE: u32 = 9;
pub const FF_CMP_NSSE: u32 = 10;
pub const FF_CMP_W53: u32 = 11;
pub const FF_CMP_W97: u32 = 12;
pub const FF_CMP_DCTMAX: u32 = 13;
pub const FF_CMP_DCT264: u32 = 14;
pub const FF_CMP_MEDIAN_SAD: u32 = 15;
pub const FF_CMP_CHROMA: u32 = 256;
pub const SLICE_FLAG_CODED_ORDER: u32 = 1;
pub const SLICE_FLAG_ALLOW_FIELD: u32 = 2;
pub const SLICE_FLAG_ALLOW_PLANE: u32 = 4;
pub const FF_MB_DECISION_SIMPLE: u32 = 0;
pub const FF_MB_DECISION_BITS: u32 = 1;
pub const FF_MB_DECISION_RD: u32 = 2;
pub const FF_BUG_AUTODETECT: u32 = 1;
pub const FF_BUG_XVID_ILACE: u32 = 4;
pub const FF_BUG_UMP4: u32 = 8;
pub const FF_BUG_NO_PADDING: u32 = 16;
pub const FF_BUG_AMV: u32 = 32;
pub const FF_BUG_QPEL_CHROMA: u32 = 64;
pub const FF_BUG_STD_QPEL: u32 = 128;
pub const FF_BUG_QPEL_CHROMA2: u32 = 256;
pub const FF_BUG_DIRECT_BLOCKSIZE: u32 = 512;
pub const FF_BUG_EDGE: u32 = 1024;
pub const FF_BUG_HPEL_CHROMA: u32 = 2048;
pub const FF_BUG_DC_CLIP: u32 = 4096;
pub const FF_BUG_MS: u32 = 8192;
pub const FF_BUG_TRUNCATED: u32 = 16384;
pub const FF_BUG_IEDGE: u32 = 32768;
pub const FF_COMPLIANCE_VERY_STRICT: u32 = 2;
pub const FF_COMPLIANCE_STRICT: u32 = 1;
pub const FF_COMPLIANCE_NORMAL: u32 = 0;
pub const FF_COMPLIANCE_UNOFFICIAL: i32 = -1;
pub const FF_COMPLIANCE_EXPERIMENTAL: i32 = -2;
pub const FF_EC_GUESS_MVS: u32 = 1;
pub const FF_EC_DEBLOCK: u32 = 2;
pub const FF_EC_FAVOR_INTER: u32 = 256;
pub const FF_DEBUG_PICT_INFO: u32 = 1;
pub const FF_DEBUG_RC: u32 = 2;
pub const FF_DEBUG_BITSTREAM: u32 = 4;
pub const FF_DEBUG_MB_TYPE: u32 = 8;
pub const FF_DEBUG_QP: u32 = 16;
pub const FF_DEBUG_DCT_COEFF: u32 = 64;
pub const FF_DEBUG_SKIP: u32 = 128;
pub const FF_DEBUG_STARTCODE: u32 = 256;
pub const FF_DEBUG_ER: u32 = 1024;
pub const FF_DEBUG_MMCO: u32 = 2048;
pub const FF_DEBUG_BUGS: u32 = 4096;
pub const FF_DEBUG_BUFFERS: u32 = 32768;
pub const FF_DEBUG_THREADS: u32 = 65536;
pub const FF_DEBUG_GREEN_MD: u32 = 8388608;
pub const FF_DEBUG_NOMC: u32 = 16777216;
pub const AV_EF_CRCCHECK: u32 = 1;
pub const AV_EF_BITSTREAM: u32 = 2;
pub const AV_EF_BUFFER: u32 = 4;
pub const AV_EF_EXPLODE: u32 = 8;
pub const AV_EF_IGNORE_ERR: u32 = 32768;
pub const AV_EF_CAREFUL: u32 = 65536;
pub const AV_EF_COMPLIANT: u32 = 131072;
pub const AV_EF_AGGRESSIVE: u32 = 262144;
pub const FF_DCT_AUTO: u32 = 0;
pub const FF_DCT_FASTINT: u32 = 1;
pub const FF_DCT_INT: u32 = 2;
pub const FF_DCT_MMX: u32 = 3;
pub const FF_DCT_ALTIVEC: u32 = 5;
pub const FF_DCT_FAAN: u32 = 6;
pub const FF_IDCT_AUTO: u32 = 0;
pub const FF_IDCT_INT: u32 = 1;
pub const FF_IDCT_SIMPLE: u32 = 2;
pub const FF_IDCT_SIMPLEMMX: u32 = 3;
pub const FF_IDCT_ARM: u32 = 7;
pub const FF_IDCT_ALTIVEC: u32 = 8;
pub const FF_IDCT_SIMPLEARM: u32 = 10;
pub const FF_IDCT_XVID: u32 = 14;
pub const FF_IDCT_SIMPLEARMV5TE: u32 = 16;
pub const FF_IDCT_SIMPLEARMV6: u32 = 17;
pub const FF_IDCT_FAAN: u32 = 20;
pub const FF_IDCT_SIMPLENEON: u32 = 22;
pub const FF_IDCT_NONE: u32 = 24;
pub const FF_IDCT_SIMPLEAUTO: u32 = 128;
pub const FF_THREAD_FRAME: u32 = 1;
pub const FF_THREAD_SLICE: u32 = 2;
pub const FF_PROFILE_UNKNOWN: i32 = -99;
pub const FF_PROFILE_RESERVED: i32 = -100;
pub const FF_PROFILE_AAC_MAIN: u32 = 0;
pub const FF_PROFILE_AAC_LOW: u32 = 1;
pub const FF_PROFILE_AAC_SSR: u32 = 2;
pub const FF_PROFILE_AAC_LTP: u32 = 3;
pub const FF_PROFILE_AAC_HE: u32 = 4;
pub const FF_PROFILE_AAC_HE_V2: u32 = 28;
pub const FF_PROFILE_AAC_LD: u32 = 22;
pub const FF_PROFILE_AAC_ELD: u32 = 38;
pub const FF_PROFILE_MPEG2_AAC_LOW: u32 = 128;
pub const FF_PROFILE_MPEG2_AAC_HE: u32 = 131;
pub const FF_PROFILE_DNXHD: u32 = 0;
pub const FF_PROFILE_DNXHR_LB: u32 = 1;
pub const FF_PROFILE_DNXHR_SQ: u32 = 2;
pub const FF_PROFILE_DNXHR_HQ: u32 = 3;
pub const FF_PROFILE_DNXHR_HQX: u32 = 4;
pub const FF_PROFILE_DNXHR_444: u32 = 5;
pub const FF_PROFILE_DTS: u32 = 20;
pub const FF_PROFILE_DTS_ES: u32 = 30;
pub const FF_PROFILE_DTS_96_24: u32 = 40;
pub const FF_PROFILE_DTS_HD_HRA: u32 = 50;
pub const FF_PROFILE_DTS_HD_MA: u32 = 60;
pub const FF_PROFILE_DTS_EXPRESS: u32 = 70;
pub const FF_PROFILE_MPEG2_422: u32 = 0;
pub const FF_PROFILE_MPEG2_HIGH: u32 = 1;
pub const FF_PROFILE_MPEG2_SS: u32 = 2;
pub const FF_PROFILE_MPEG2_SNR_SCALABLE: u32 = 3;
pub const FF_PROFILE_MPEG2_MAIN: u32 = 4;
pub const FF_PROFILE_MPEG2_SIMPLE: u32 = 5;
pub const FF_PROFILE_H264_CONSTRAINED: u32 = 512;
pub const FF_PROFILE_H264_INTRA: u32 = 2048;
pub const FF_PROFILE_H264_BASELINE: u32 = 66;
pub const FF_PROFILE_H264_CONSTRAINED_BASELINE: u32 = 578;
pub const FF_PROFILE_H264_MAIN: u32 = 77;
pub const FF_PROFILE_H264_EXTENDED: u32 = 88;
pub const FF_PROFILE_H264_HIGH: u32 = 100;
pub const FF_PROFILE_H264_HIGH_10: u32 = 110;
pub const FF_PROFILE_H264_HIGH_10_INTRA: u32 = 2158;
pub const FF_PROFILE_H264_MULTIVIEW_HIGH: u32 = 118;
pub const FF_PROFILE_H264_HIGH_422: u32 = 122;
pub const FF_PROFILE_H264_HIGH_422_INTRA: u32 = 2170;
pub const FF_PROFILE_H264_STEREO_HIGH: u32 = 128;
pub const FF_PROFILE_H264_HIGH_444: u32 = 144;
pub const FF_PROFILE_H264_HIGH_444_PREDICTIVE: u32 = 244;
pub const FF_PROFILE_H264_HIGH_444_INTRA: u32 = 2292;
pub const FF_PROFILE_H264_CAVLC_444: u32 = 44;
pub const FF_PROFILE_VC1_SIMPLE: u32 = 0;
pub const FF_PROFILE_VC1_MAIN: u32 = 1;
pub const FF_PROFILE_VC1_COMPLEX: u32 = 2;
pub const FF_PROFILE_VC1_ADVANCED: u32 = 3;
pub const FF_PROFILE_MPEG4_SIMPLE: u32 = 0;
pub const FF_PROFILE_MPEG4_SIMPLE_SCALABLE: u32 = 1;
pub const FF_PROFILE_MPEG4_CORE: u32 = 2;
pub const FF_PROFILE_MPEG4_MAIN: u32 = 3;
pub const FF_PROFILE_MPEG4_N_BIT: u32 = 4;
pub const FF_PROFILE_MPEG4_SCALABLE_TEXTURE: u32 = 5;
pub const FF_PROFILE_MPEG4_SIMPLE_FACE_ANIMATION: u32 = 6;
pub const FF_PROFILE_MPEG4_BASIC_ANIMATED_TEXTURE: u32 = 7;
pub const FF_PROFILE_MPEG4_HYBRID: u32 = 8;
pub const FF_PROFILE_MPEG4_ADVANCED_REAL_TIME: u32 = 9;
pub const FF_PROFILE_MPEG4_CORE_SCALABLE: u32 = 10;
pub const FF_PROFILE_MPEG4_ADVANCED_CODING: u32 = 11;
pub const FF_PROFILE_MPEG4_ADVANCED_CORE: u32 = 12;
pub const FF_PROFILE_MPEG4_ADVANCED_SCALABLE_TEXTURE: u32 = 13;
pub const FF_PROFILE_MPEG4_SIMPLE_STUDIO: u32 = 14;
pub const FF_PROFILE_MPEG4_ADVANCED_SIMPLE: u32 = 15;
pub const FF_PROFILE_JPEG2000_CSTREAM_RESTRICTION_0: u32 = 1;
pub const FF_PROFILE_JPEG2000_CSTREAM_RESTRICTION_1: u32 = 2;
pub const FF_PROFILE_JPEG2000_CSTREAM_NO_RESTRICTION: u32 = 32768;
pub const FF_PROFILE_JPEG2000_DCINEMA_2K: u32 = 3;
pub const FF_PROFILE_JPEG2000_DCINEMA_4K: u32 = 4;
pub const FF_PROFILE_VP9_0: u32 = 0;
pub const FF_PROFILE_VP9_1: u32 = 1;
pub const FF_PROFILE_VP9_2: u32 = 2;
pub const FF_PROFILE_VP9_3: u32 = 3;
pub const FF_PROFILE_HEVC_MAIN: u32 = 1;
pub const FF_PROFILE_HEVC_MAIN_10: u32 = 2;
pub const FF_PROFILE_HEVC_MAIN_STILL_PICTURE: u32 = 3;
pub const FF_PROFILE_HEVC_REXT: u32 = 4;
pub const FF_PROFILE_VVC_MAIN_10: u32 = 1;
pub const FF_PROFILE_VVC_MAIN_10_444: u32 = 33;
pub const FF_PROFILE_AV1_MAIN: u32 = 0;
pub const FF_PROFILE_AV1_HIGH: u32 = 1;
pub const FF_PROFILE_AV1_PROFESSIONAL: u32 = 2;
pub const FF_PROFILE_MJPEG_HUFFMAN_BASELINE_DCT: u32 = 192;
pub const FF_PROFILE_MJPEG_HUFFMAN_EXTENDED_SEQUENTIAL_DCT: u32 = 193;
pub const FF_PROFILE_MJPEG_HUFFMAN_PROGRESSIVE_DCT: u32 = 194;
pub const FF_PROFILE_MJPEG_HUFFMAN_LOSSLESS: u32 = 195;
pub const FF_PROFILE_MJPEG_JPEG_LS: u32 = 247;
pub const FF_PROFILE_SBC_MSBC: u32 = 1;
pub const FF_PROFILE_PRORES_PROXY: u32 = 0;
pub const FF_PROFILE_PRORES_LT: u32 = 1;
pub const FF_PROFILE_PRORES_STANDARD: u32 = 2;
pub const FF_PROFILE_PRORES_HQ: u32 = 3;
pub const FF_PROFILE_PRORES_4444: u32 = 4;
pub const FF_PROFILE_PRORES_XQ: u32 = 5;
pub const FF_PROFILE_ARIB_PROFILE_A: u32 = 0;
pub const FF_PROFILE_ARIB_PROFILE_C: u32 = 1;
pub const FF_PROFILE_KLVA_SYNC: u32 = 0;
pub const FF_PROFILE_KLVA_ASYNC: u32 = 1;
pub const FF_LEVEL_UNKNOWN: i32 = -99;
pub const FF_SUB_CHARENC_MODE_DO_NOTHING: i32 = -1;
pub const FF_SUB_CHARENC_MODE_AUTOMATIC: u32 = 0;
pub const FF_SUB_CHARENC_MODE_PRE_DECODER: u32 = 1;
pub const FF_SUB_CHARENC_MODE_IGNORE: u32 = 2;
pub const FF_DEBUG_VIS_MV_P_FOR: u32 = 1;
pub const FF_DEBUG_VIS_MV_B_FOR: u32 = 2;
pub const FF_DEBUG_VIS_MV_B_BACK: u32 = 4;
pub const FF_CODEC_PROPERTY_LOSSLESS: u32 = 1;
pub const FF_CODEC_PROPERTY_CLOSED_CAPTIONS: u32 = 2;
pub const FF_SUB_TEXT_FMT_ASS: u32 = 0;
pub const AV_HWACCEL_CODEC_CAP_EXPERIMENTAL: u32 = 512;
pub const AV_HWACCEL_FLAG_IGNORE_LEVEL: u32 = 1;
pub const AV_HWACCEL_FLAG_ALLOW_HIGH_DEPTH: u32 = 2;
pub const AV_HWACCEL_FLAG_ALLOW_PROFILE_MISMATCH: u32 = 4;
pub const AV_SUBTITLE_FLAG_FORCED: u32 = 1;
pub const AV_PARSER_PTS_NB: u32 = 4;
pub const PARSER_FLAG_COMPLETE_FRAMES: u32 = 1;
pub const PARSER_FLAG_ONCE: u32 = 2;
pub const PARSER_FLAG_FETCHED_OFFSET: u32 = 4;
pub const PARSER_FLAG_USE_CODEC_TS: u32 = 4096;
pub const DV_PROFILE_BYTES: u32 = 480;
pub const VORBIS_FLAG_HEADER: u32 = 1;
pub const VORBIS_FLAG_COMMENT: u32 = 2;
pub const VORBIS_FLAG_SETUP: u32 = 4;
pub const LIBAVDEVICE_VERSION_MAJOR: u32 = 59;
pub const LIBAVDEVICE_VERSION_MINOR: u32 = 0;
pub const LIBAVDEVICE_VERSION_MICRO: u32 = 100;
pub const AV_OPT_FLAG_ENCODING_PARAM: u32 = 1;
pub const AV_OPT_FLAG_DECODING_PARAM: u32 = 2;
pub const AV_OPT_FLAG_AUDIO_PARAM: u32 = 8;
pub const AV_OPT_FLAG_VIDEO_PARAM: u32 = 16;
pub const AV_OPT_FLAG_SUBTITLE_PARAM: u32 = 32;
pub const AV_OPT_FLAG_EXPORT: u32 = 64;
pub const AV_OPT_FLAG_READONLY: u32 = 128;
pub const AV_OPT_FLAG_BSF_PARAM: u32 = 256;
pub const AV_OPT_FLAG_RUNTIME_PARAM: u32 = 32768;
pub const AV_OPT_FLAG_FILTERING_PARAM: u32 = 65536;
pub const AV_OPT_FLAG_DEPRECATED: u32 = 131072;
pub const AV_OPT_FLAG_CHILD_CONSTS: u32 = 262144;
pub const AV_OPT_SEARCH_CHILDREN: u32 = 1;
pub const AV_OPT_SEARCH_FAKE_OBJ: u32 = 2;
pub const AV_OPT_ALLOW_NULL: u32 = 4;
pub const AV_OPT_MULTI_COMPONENT_RANGE: u32 = 4096;
pub const AV_OPT_SERIALIZE_SKIP_DEFAULTS: u32 = 1;
pub const AV_OPT_SERIALIZE_OPT_FLAGS_EXACT: u32 = 2;
pub const _TIME_H: u32 = 1;
pub const _BITS_TIME_H: u32 = 1;
pub const CLOCK_REALTIME: u32 = 0;
pub const CLOCK_MONOTONIC: u32 = 1;
pub const CLOCK_PROCESS_CPUTIME_ID: u32 = 2;
pub const CLOCK_THREAD_CPUTIME_ID: u32 = 3;
pub const CLOCK_MONOTONIC_RAW: u32 = 4;
pub const CLOCK_REALTIME_COARSE: u32 = 5;
pub const CLOCK_MONOTONIC_COARSE: u32 = 6;
pub const CLOCK_BOOTTIME: u32 = 7;
pub const CLOCK_REALTIME_ALARM: u32 = 8;
pub const CLOCK_BOOTTIME_ALARM: u32 = 9;
pub const CLOCK_TAI: u32 = 11;
pub const TIMER_ABSTIME: u32 = 1;
pub const __struct_tm_defined: u32 = 1;
pub const __itimerspec_defined: u32 = 1;
pub const TIME_UTC: u32 = 1;
pub const LIBAVFORMAT_VERSION_MAJOR: u32 = 59;
pub const LIBAVFORMAT_VERSION_MINOR: u32 = 0;
pub const LIBAVFORMAT_VERSION_MICRO: u32 = 101;
pub const FF_API_R_FRAME_RATE: u32 = 1;
pub const AVIO_SEEKABLE_NORMAL: u32 = 1;
pub const AVIO_SEEKABLE_TIME: u32 = 2;
pub const AVSEEK_SIZE: u32 = 65536;
pub const AVSEEK_FORCE: u32 = 131072;
pub const AVIO_FLAG_READ: u32 = 1;
pub const AVIO_FLAG_WRITE: u32 = 2;
pub const AVIO_FLAG_READ_WRITE: u32 = 3;
pub const AVIO_FLAG_NONBLOCK: u32 = 8;
pub const AVIO_FLAG_DIRECT: u32 = 32768;
pub const AVPROBE_SCORE_EXTENSION: u32 = 50;
pub const AVPROBE_SCORE_MIME: u32 = 75;
pub const AVPROBE_SCORE_MAX: u32 = 100;
pub const AVPROBE_PADDING_SIZE: u32 = 32;
pub const AVFMT_NOFILE: u32 = 1;
pub const AVFMT_NEEDNUMBER: u32 = 2;
pub const AVFMT_SHOW_IDS: u32 = 8;
pub const AVFMT_GLOBALHEADER: u32 = 64;
pub const AVFMT_NOTIMESTAMPS: u32 = 128;
pub const AVFMT_GENERIC_INDEX: u32 = 256;
pub const AVFMT_TS_DISCONT: u32 = 512;
pub const AVFMT_VARIABLE_FPS: u32 = 1024;
pub const AVFMT_NODIMENSIONS: u32 = 2048;
pub const AVFMT_NOSTREAMS: u32 = 4096;
pub const AVFMT_NOBINSEARCH: u32 = 8192;
pub const AVFMT_NOGENSEARCH: u32 = 16384;
pub const AVFMT_NO_BYTE_SEEK: u32 = 32768;
pub const AVFMT_ALLOW_FLUSH: u32 = 65536;
pub const AVFMT_TS_NONSTRICT: u32 = 131072;
pub const AVFMT_TS_NEGATIVE: u32 = 262144;
pub const AVFMT_SEEK_TO_PTS: u32 = 67108864;
pub const AVINDEX_KEYFRAME: u32 = 1;
pub const AVINDEX_DISCARD_FRAME: u32 = 2;
pub const AV_DISPOSITION_DEFAULT: u32 = 1;
pub const AV_DISPOSITION_DUB: u32 = 2;
pub const AV_DISPOSITION_ORIGINAL: u32 = 4;
pub const AV_DISPOSITION_COMMENT: u32 = 8;
pub const AV_DISPOSITION_LYRICS: u32 = 16;
pub const AV_DISPOSITION_KARAOKE: u32 = 32;
pub const AV_DISPOSITION_FORCED: u32 = 64;
pub const AV_DISPOSITION_HEARING_IMPAIRED: u32 = 128;
pub const AV_DISPOSITION_VISUAL_IMPAIRED: u32 = 256;
pub const AV_DISPOSITION_CLEAN_EFFECTS: u32 = 512;
pub const AV_DISPOSITION_ATTACHED_PIC: u32 = 1024;
pub const AV_DISPOSITION_TIMED_THUMBNAILS: u32 = 2048;
pub const AV_DISPOSITION_CAPTIONS: u32 = 65536;
pub const AV_DISPOSITION_DESCRIPTIONS: u32 = 131072;
pub const AV_DISPOSITION_METADATA: u32 = 262144;
pub const AV_DISPOSITION_DEPENDENT: u32 = 524288;
pub const AV_DISPOSITION_STILL_IMAGE: u32 = 1048576;
pub const AV_PTS_WRAP_IGNORE: u32 = 0;
pub const AV_PTS_WRAP_ADD_OFFSET: u32 = 1;
pub const AV_PTS_WRAP_SUB_OFFSET: i32 = -1;
pub const AVSTREAM_EVENT_FLAG_METADATA_UPDATED: u32 = 1;
pub const AVSTREAM_EVENT_FLAG_NEW_PACKETS: u32 = 2;
pub const AV_PROGRAM_RUNNING: u32 = 1;
pub const AVFMTCTX_NOHEADER: u32 = 1;
pub const AVFMTCTX_UNSEEKABLE: u32 = 2;
pub const AVFMT_FLAG_GENPTS: u32 = 1;
pub const AVFMT_FLAG_IGNIDX: u32 = 2;
pub const AVFMT_FLAG_NONBLOCK: u32 = 4;
pub const AVFMT_FLAG_IGNDTS: u32 = 8;
pub const AVFMT_FLAG_NOFILLIN: u32 = 16;
pub const AVFMT_FLAG_NOPARSE: u32 = 32;
pub const AVFMT_FLAG_NOBUFFER: u32 = 64;
pub const AVFMT_FLAG_CUSTOM_IO: u32 = 128;
pub const AVFMT_FLAG_DISCARD_CORRUPT: u32 = 256;
pub const AVFMT_FLAG_FLUSH_PACKETS: u32 = 512;
pub const AVFMT_FLAG_BITEXACT: u32 = 1024;
pub const AVFMT_FLAG_SORT_DTS: u32 = 65536;
pub const AVFMT_FLAG_PRIV_OPT: u32 = 131072;
pub const AVFMT_FLAG_FAST_SEEK: u32 = 524288;
pub const AVFMT_FLAG_SHORTEST: u32 = 1048576;
pub const AVFMT_FLAG_AUTO_BSF: u32 = 2097152;
pub const FF_FDEBUG_TS: u32 = 1;
pub const AVFMT_EVENT_FLAG_METADATA_UPDATED: u32 = 1;
pub const AVFMT_AVOID_NEG_TS_AUTO: i32 = -1;
pub const AVFMT_AVOID_NEG_TS_MAKE_NON_NEGATIVE: u32 = 1;
pub const AVFMT_AVOID_NEG_TS_MAKE_ZERO: u32 = 2;
pub const AVSEEK_FLAG_BACKWARD: u32 = 1;
pub const AVSEEK_FLAG_BYTE: u32 = 2;
pub const AVSEEK_FLAG_ANY: u32 = 4;
pub const AVSEEK_FLAG_FRAME: u32 = 8;
pub const AVSTREAM_INIT_IN_WRITE_HEADER: u32 = 0;
pub const AVSTREAM_INIT_IN_INIT_OUTPUT: u32 = 1;
pub const AV_FRAME_FILENAME_FLAGS_MULTIPLE: u32 = 1;
pub const LIBAVFILTER_VERSION_MAJOR: u32 = 8;
pub const LIBAVFILTER_VERSION_MINOR: u32 = 0;
pub const LIBAVFILTER_VERSION_MICRO: u32 = 101;
pub const AVFILTER_FLAG_DYNAMIC_INPUTS: u32 = 1;
pub const AVFILTER_FLAG_DYNAMIC_OUTPUTS: u32 = 2;
pub const AVFILTER_FLAG_SLICE_THREADS: u32 = 4;
pub const AVFILTER_FLAG_SUPPORT_TIMELINE_GENERIC: u32 = 65536;
pub const AVFILTER_FLAG_SUPPORT_TIMELINE_INTERNAL: u32 = 131072;
pub const AVFILTER_FLAG_SUPPORT_TIMELINE: u32 = 196608;
pub const AVFILTER_THREAD_SLICE: u32 = 1;
pub const AVFILTER_CMD_FLAG_ONE: u32 = 1;
pub const AVFILTER_CMD_FLAG_FAST: u32 = 2;
pub const AV_BUFFERSINK_FLAG_PEEK: u32 = 1;
pub const AV_BUFFERSINK_FLAG_NO_REQUEST: u32 = 2;
pub const AV_ESCAPE_FLAG_WHITESPACE: u32 = 1;
pub const AV_ESCAPE_FLAG_STRICT: u32 = 2;
pub const AV_ESCAPE_FLAG_XML_SINGLE_QUOTES: u32 = 4;
pub const AV_ESCAPE_FLAG_XML_DOUBLE_QUOTES: u32 = 8;
pub const AV_UTF8_FLAG_ACCEPT_INVALID_BIG_CODES: u32 = 1;
pub const AV_UTF8_FLAG_ACCEPT_NON_CHARACTERS: u32 = 2;
pub const AV_UTF8_FLAG_ACCEPT_SURROGATES: u32 = 4;
pub const AV_UTF8_FLAG_EXCLUDE_XML_INVALID_CONTROL_CODES: u32 = 8;
pub const AV_UTF8_FLAG_ACCEPT_ALL: u32 = 7;
pub const AV_BF_ROUNDS: u32 = 16;
pub const AV_BPRINT_SIZE_AUTOMATIC: u32 = 1;
pub const AV_BPRINT_SIZE_COUNT_ONLY: u32 = 0;
pub const AV_HASH_MAX_SIZE: u32 = 64;
pub const AV_PIX_FMT_FLAG_BE: u32 = 1;
pub const AV_PIX_FMT_FLAG_PAL: u32 = 2;
pub const AV_PIX_FMT_FLAG_BITSTREAM: u32 = 4;
pub const AV_PIX_FMT_FLAG_HWACCEL: u32 = 8;
pub const AV_PIX_FMT_FLAG_PLANAR: u32 = 16;
pub const AV_PIX_FMT_FLAG_RGB: u32 = 32;
pub const AV_PIX_FMT_FLAG_ALPHA: u32 = 128;
pub const AV_PIX_FMT_FLAG_BAYER: u32 = 256;
pub const AV_PIX_FMT_FLAG_FLOAT: u32 = 512;
pub const FF_LOSS_RESOLUTION: u32 = 1;
pub const FF_LOSS_DEPTH: u32 = 2;
pub const FF_LOSS_COLORSPACE: u32 = 4;
pub const FF_LOSS_ALPHA: u32 = 8;
pub const FF_LOSS_COLORQUANT: u32 = 16;
pub const FF_LOSS_CHROMA: u32 = 32;
pub const AV_STEREO3D_FLAG_INVERT: u32 = 1;
pub const AV_TIMECODE_STR_SIZE: u32 = 23;
pub const LIBSWRESAMPLE_VERSION_MAJOR: u32 = 4;
pub const LIBSWRESAMPLE_VERSION_MINOR: u32 = 0;
pub const LIBSWRESAMPLE_VERSION_MICRO: u32 = 100;
pub const SWR_FLAG_RESAMPLE: u32 = 1;
pub const LIBSWSCALE_VERSION_MAJOR: u32 = 6;
pub const LIBSWSCALE_VERSION_MINOR: u32 = 0;
pub const LIBSWSCALE_VERSION_MICRO: u32 = 100;
pub const SWS_FAST_BILINEAR: u32 = 1;
pub const SWS_BILINEAR: u32 = 2;
pub const SWS_BICUBIC: u32 = 4;
pub const SWS_X: u32 = 8;
pub const SWS_POINT: u32 = 16;
pub const SWS_AREA: u32 = 32;
pub const SWS_BICUBLIN: u32 = 64;
pub const SWS_GAUSS: u32 = 128;
pub const SWS_SINC: u32 = 256;
pub const SWS_LANCZOS: u32 = 512;
pub const SWS_SPLINE: u32 = 1024;
pub const SWS_SRC_V_CHR_DROP_MASK: u32 = 196608;
pub const SWS_SRC_V_CHR_DROP_SHIFT: u32 = 16;
pub const SWS_PARAM_DEFAULT: u32 = 123456;
pub const SWS_PRINT_INFO: u32 = 4096;
pub const SWS_FULL_CHR_H_INT: u32 = 8192;
pub const SWS_FULL_CHR_H_INP: u32 = 16384;
pub const SWS_DIRECT_BGR: u32 = 32768;
pub const SWS_ACCURATE_RND: u32 = 262144;
pub const SWS_BITEXACT: u32 = 524288;
pub const SWS_ERROR_DIFFUSION: u32 = 8388608;
pub const SWS_MAX_REDUCE_CUTOFF: f64 = 0.002;
pub const SWS_CS_ITU709: u32 = 1;
pub const SWS_CS_FCC: u32 = 4;
pub const SWS_CS_ITU601: u32 = 5;
pub const SWS_CS_ITU624: u32 = 5;
pub const SWS_CS_SMPTE170M: u32 = 5;
pub const SWS_CS_SMPTE240M: u32 = 7;
pub const SWS_CS_DEFAULT: u32 = 5;
pub const SWS_CS_BT2020: u32 = 9;
extern "C" {
    pub fn __errno_location() -> *mut ::std::os::raw::c_int;
}
pub type __u_char = ::std::os::raw::c_uchar;
pub type __u_short = ::std::os::raw::c_ushort;
pub type __u_int = ::std::os::raw::c_uint;
pub type __u_long = ::std::os::raw::c_ulong;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __int_least8_t = __int8_t;
pub type __uint_least8_t = __uint8_t;
pub type __int_least16_t = __int16_t;
pub type __uint_least16_t = __uint16_t;
pub type __int_least32_t = __int32_t;
pub type __uint_least32_t = __uint32_t;
pub type __int_least64_t = __int64_t;
pub type __uint_least64_t = __uint64_t;
pub type __quad_t = ::std::os::raw::c_long;
pub type __u_quad_t = ::std::os::raw::c_ulong;
pub type __intmax_t = ::std::os::raw::c_long;
pub type __uintmax_t = ::std::os::raw::c_ulong;
pub type __dev_t = ::std::os::raw::c_ulong;
pub type __uid_t = ::std::os::raw::c_uint;
pub type __gid_t = ::std::os::raw::c_uint;
pub type __ino_t = ::std::os::raw::c_ulong;
pub type __ino64_t = ::std::os::raw::c_ulong;
pub type __mode_t = ::std::os::raw::c_uint;
pub type __nlink_t = ::std::os::raw::c_ulong;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type __pid_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __fsid_t {
    pub __val: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout___fsid_t() {
    assert_eq!(
        ::std::mem::size_of::<__fsid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__fsid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__fsid_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__fsid_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__fsid_t>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__fsid_t),
            "::",
            stringify!(__val)
        )
    );
}
pub type __clock_t = ::std::os::raw::c_long;
pub type __rlim_t = ::std::os::raw::c_ulong;
pub type __rlim64_t = ::std::os::raw::c_ulong;
pub type __id_t = ::std::os::raw::c_uint;
pub type __time_t = ::std::os::raw::c_long;
pub type __useconds_t = ::std::os::raw::c_uint;
pub type __suseconds_t = ::std::os::raw::c_long;
pub type __daddr_t = ::std::os::raw::c_int;
pub type __key_t = ::std::os::raw::c_int;
pub type __clockid_t = ::std::os::raw::c_int;
pub type __timer_t = *mut ::std::os::raw::c_void;
pub type __blksize_t = ::std::os::raw::c_long;
pub type __blkcnt_t = ::std::os::raw::c_long;
pub type __blkcnt64_t = ::std::os::raw::c_long;
pub type __fsblkcnt_t = ::std::os::raw::c_ulong;
pub type __fsblkcnt64_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt64_t = ::std::os::raw::c_ulong;
pub type __fsword_t = ::std::os::raw::c_long;
pub type __ssize_t = ::std::os::raw::c_long;
pub type __syscall_slong_t = ::std::os::raw::c_long;
pub type __syscall_ulong_t = ::std::os::raw::c_ulong;
pub type __loff_t = __off64_t;
pub type __caddr_t = *mut ::std::os::raw::c_char;
pub type __intptr_t = ::std::os::raw::c_long;
pub type __socklen_t = ::std::os::raw::c_uint;
pub type __sig_atomic_t = ::std::os::raw::c_int;
pub type int_least8_t = __int_least8_t;
pub type int_least16_t = __int_least16_t;
pub type int_least32_t = __int_least32_t;
pub type int_least64_t = __int_least64_t;
pub type uint_least8_t = __uint_least8_t;
pub type uint_least16_t = __uint_least16_t;
pub type uint_least32_t = __uint_least32_t;
pub type uint_least64_t = __uint_least64_t;
pub type int_fast8_t = ::std::os::raw::c_schar;
pub type int_fast16_t = ::std::os::raw::c_long;
pub type int_fast32_t = ::std::os::raw::c_long;
pub type int_fast64_t = ::std::os::raw::c_long;
pub type uint_fast8_t = ::std::os::raw::c_uchar;
pub type uint_fast16_t = ::std::os::raw::c_ulong;
pub type uint_fast32_t = ::std::os::raw::c_ulong;
pub type uint_fast64_t = ::std::os::raw::c_ulong;
pub type intmax_t = __intmax_t;
pub type uintmax_t = __uintmax_t;
extern "C" {
    #[doc = " Return the LIBAVUTIL_VERSION_INT constant."]
    pub fn avutil_version() -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Return an informative version string. This usually is the actual release"]
    #[doc = " version number or a git commit description. This string has no fixed format"]
    #[doc = " and can change any time. It should never be parsed by code."]
    pub fn av_version_info() -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Return the libavutil build-time configuration."]
    pub fn avutil_configuration() -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Return the libavutil license."]
    pub fn avutil_license() -> *const ::std::os::raw::c_char;
}
#[doc = "< Usually treated as AVMEDIA_TYPE_DATA"]
pub const AVMediaType_AVMEDIA_TYPE_UNKNOWN: AVMediaType = -1;
pub const AVMediaType_AVMEDIA_TYPE_VIDEO: AVMediaType = 0;
pub const AVMediaType_AVMEDIA_TYPE_AUDIO: AVMediaType = 1;
#[doc = "< Opaque data information usually continuous"]
pub const AVMediaType_AVMEDIA_TYPE_DATA: AVMediaType = 2;
pub const AVMediaType_AVMEDIA_TYPE_SUBTITLE: AVMediaType = 3;
#[doc = "< Opaque data information usually sparse"]
pub const AVMediaType_AVMEDIA_TYPE_ATTACHMENT: AVMediaType = 4;
pub const AVMediaType_AVMEDIA_TYPE_NB: AVMediaType = 5;
#[doc = " @addtogroup lavu_media Media Type"]
#[doc = " @brief Media Type"]
pub type AVMediaType = ::std::os::raw::c_int;
extern "C" {
    #[doc = " Return a string describing the media_type enum, NULL if media_type"]
    #[doc = " is unknown."]
    pub fn av_get_media_type_string(media_type: AVMediaType) -> *const ::std::os::raw::c_char;
}
#[doc = "< Undefined"]
pub const AVPictureType_AV_PICTURE_TYPE_NONE: AVPictureType = 0;
#[doc = "< Intra"]
pub const AVPictureType_AV_PICTURE_TYPE_I: AVPictureType = 1;
#[doc = "< Predicted"]
pub const AVPictureType_AV_PICTURE_TYPE_P: AVPictureType = 2;
#[doc = "< Bi-dir predicted"]
pub const AVPictureType_AV_PICTURE_TYPE_B: AVPictureType = 3;
#[doc = "< S(GMC)-VOP MPEG-4"]
pub const AVPictureType_AV_PICTURE_TYPE_S: AVPictureType = 4;
#[doc = "< Switching Intra"]
pub const AVPictureType_AV_PICTURE_TYPE_SI: AVPictureType = 5;
#[doc = "< Switching Predicted"]
pub const AVPictureType_AV_PICTURE_TYPE_SP: AVPictureType = 6;
#[doc = "< BI type"]
pub const AVPictureType_AV_PICTURE_TYPE_BI: AVPictureType = 7;
#[doc = " @}"]
#[doc = " @}"]
#[doc = " @defgroup lavu_picture Image related"]
#[doc = ""]
#[doc = " AVPicture types, pixel formats and basic image planes manipulation."]
#[doc = ""]
#[doc = " @{"]
pub type AVPictureType = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Return a single letter to describe the given picture type"]
    #[doc = " pict_type."]
    #[doc = ""]
    #[doc = " @param[in] pict_type the picture type @return a single character"]
    #[doc = " representing the picture type, '?' if pict_type is unknown"]
    pub fn av_get_picture_type_char(pict_type: AVPictureType) -> ::std::os::raw::c_char;
}
pub type __gwchar_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct imaxdiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_imaxdiv_t() {
    assert_eq!(
        ::std::mem::size_of::<imaxdiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(imaxdiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<imaxdiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(imaxdiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaxdiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(imaxdiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaxdiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(imaxdiv_t),
            "::",
            stringify!(rem)
        )
    );
}
extern "C" {
    pub fn imaxabs(__n: intmax_t) -> intmax_t;
}
extern "C" {
    pub fn imaxdiv(__numer: intmax_t, __denom: intmax_t) -> imaxdiv_t;
}
extern "C" {
    pub fn strtoimax(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> intmax_t;
}
extern "C" {
    pub fn strtoumax(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> uintmax_t;
}
extern "C" {
    pub fn wcstoimax(
        __nptr: *const __gwchar_t,
        __endptr: *mut *mut __gwchar_t,
        __base: ::std::os::raw::c_int,
    ) -> intmax_t;
}
extern "C" {
    pub fn wcstoumax(
        __nptr: *const __gwchar_t,
        __endptr: *mut *mut __gwchar_t,
        __base: ::std::os::raw::c_int,
    ) -> uintmax_t;
}
pub type _Float32 = f32;
pub type _Float64 = f64;
pub type _Float32x = f64;
pub type _Float64x = u128;
pub type float_t = f32;
pub type double_t = f64;
extern "C" {
    pub fn __fpclassify(__value: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __signbit(__value: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __isinf(__value: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __finite(__value: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __isnan(__value: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __iseqsig(__x: f64, __y: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __issignaling(__value: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acos(__x: f64) -> f64;
}
extern "C" {
    pub fn __acos(__x: f64) -> f64;
}
extern "C" {
    pub fn asin(__x: f64) -> f64;
}
extern "C" {
    pub fn __asin(__x: f64) -> f64;
}
extern "C" {
    pub fn atan(__x: f64) -> f64;
}
extern "C" {
    pub fn __atan(__x: f64) -> f64;
}
extern "C" {
    pub fn atan2(__y: f64, __x: f64) -> f64;
}
extern "C" {
    pub fn __atan2(__y: f64, __x: f64) -> f64;
}
extern "C" {
    pub fn cos(__x: f64) -> f64;
}
extern "C" {
    pub fn __cos(__x: f64) -> f64;
}
extern "C" {
    pub fn sin(__x: f64) -> f64;
}
extern "C" {
    pub fn __sin(__x: f64) -> f64;
}
extern "C" {
    pub fn tan(__x: f64) -> f64;
}
extern "C" {
    pub fn __tan(__x: f64) -> f64;
}
extern "C" {
    pub fn cosh(__x: f64) -> f64;
}
extern "C" {
    pub fn __cosh(__x: f64) -> f64;
}
extern "C" {
    pub fn sinh(__x: f64) -> f64;
}
extern "C" {
    pub fn __sinh(__x: f64) -> f64;
}
extern "C" {
    pub fn tanh(__x: f64) -> f64;
}
extern "C" {
    pub fn __tanh(__x: f64) -> f64;
}
extern "C" {
    pub fn acosh(__x: f64) -> f64;
}
extern "C" {
    pub fn __acosh(__x: f64) -> f64;
}
extern "C" {
    pub fn asinh(__x: f64) -> f64;
}
extern "C" {
    pub fn __asinh(__x: f64) -> f64;
}
extern "C" {
    pub fn atanh(__x: f64) -> f64;
}
extern "C" {
    pub fn __atanh(__x: f64) -> f64;
}
extern "C" {
    pub fn exp(__x: f64) -> f64;
}
extern "C" {
    pub fn __exp(__x: f64) -> f64;
}
extern "C" {
    pub fn frexp(__x: f64, __exponent: *mut ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn __frexp(__x: f64, __exponent: *mut ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn ldexp(__x: f64, __exponent: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn __ldexp(__x: f64, __exponent: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn log(__x: f64) -> f64;
}
extern "C" {
    pub fn __log(__x: f64) -> f64;
}
extern "C" {
    pub fn log10(__x: f64) -> f64;
}
extern "C" {
    pub fn __log10(__x: f64) -> f64;
}
extern "C" {
    pub fn modf(__x: f64, __iptr: *mut f64) -> f64;
}
extern "C" {
    pub fn __modf(__x: f64, __iptr: *mut f64) -> f64;
}
extern "C" {
    pub fn expm1(__x: f64) -> f64;
}
extern "C" {
    pub fn __expm1(__x: f64) -> f64;
}
extern "C" {
    pub fn log1p(__x: f64) -> f64;
}
extern "C" {
    pub fn __log1p(__x: f64) -> f64;
}
extern "C" {
    pub fn logb(__x: f64) -> f64;
}
extern "C" {
    pub fn __logb(__x: f64) -> f64;
}
extern "C" {
    pub fn exp2(__x: f64) -> f64;
}
extern "C" {
    pub fn __exp2(__x: f64) -> f64;
}
extern "C" {
    pub fn log2(__x: f64) -> f64;
}
extern "C" {
    pub fn __log2(__x: f64) -> f64;
}
extern "C" {
    pub fn pow(__x: f64, __y: f64) -> f64;
}
extern "C" {
    pub fn __pow(__x: f64, __y: f64) -> f64;
}
extern "C" {
    pub fn sqrt(__x: f64) -> f64;
}
extern "C" {
    pub fn __sqrt(__x: f64) -> f64;
}
extern "C" {
    pub fn hypot(__x: f64, __y: f64) -> f64;
}
extern "C" {
    pub fn __hypot(__x: f64, __y: f64) -> f64;
}
extern "C" {
    pub fn cbrt(__x: f64) -> f64;
}
extern "C" {
    pub fn __cbrt(__x: f64) -> f64;
}
extern "C" {
    pub fn ceil(__x: f64) -> f64;
}
extern "C" {
    pub fn __ceil(__x: f64) -> f64;
}
extern "C" {
    pub fn fabs(__x: f64) -> f64;
}
extern "C" {
    pub fn __fabs(__x: f64) -> f64;
}
extern "C" {
    pub fn floor(__x: f64) -> f64;
}
extern "C" {
    pub fn __floor(__x: f64) -> f64;
}
extern "C" {
    pub fn fmod(__x: f64, __y: f64) -> f64;
}
extern "C" {
    pub fn __fmod(__x: f64, __y: f64) -> f64;
}
extern "C" {
    pub fn isinf(__value: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn finite(__value: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn drem(__x: f64, __y: f64) -> f64;
}
extern "C" {
    pub fn __drem(__x: f64, __y: f64) -> f64;
}
extern "C" {
    pub fn significand(__x: f64) -> f64;
}
extern "C" {
    pub fn __significand(__x: f64) -> f64;
}
extern "C" {
    pub fn copysign(__x: f64, __y: f64) -> f64;
}
extern "C" {
    pub fn __copysign(__x: f64, __y: f64) -> f64;
}
extern "C" {
    pub fn nan(__tagb: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn __nan(__tagb: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn isnan(__value: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn j0(arg1: f64) -> f64;
}
extern "C" {
    pub fn __j0(arg1: f64) -> f64;
}
extern "C" {
    pub fn j1(arg1: f64) -> f64;
}
extern "C" {
    pub fn __j1(arg1: f64) -> f64;
}
extern "C" {
    pub fn jn(arg1: ::std::os::raw::c_int, arg2: f64) -> f64;
}
extern "C" {
    pub fn __jn(arg1: ::std::os::raw::c_int, arg2: f64) -> f64;
}
extern "C" {
    pub fn y0(arg1: f64) -> f64;
}
extern "C" {
    pub fn __y0(arg1: f64) -> f64;
}
extern "C" {
    pub fn y1(arg1: f64) -> f64;
}
extern "C" {
    pub fn __y1(arg1: f64) -> f64;
}
extern "C" {
    pub fn yn(arg1: ::std::os::raw::c_int, arg2: f64) -> f64;
}
extern "C" {
    pub fn __yn(arg1: ::std::os::raw::c_int, arg2: f64) -> f64;
}
extern "C" {
    pub fn erf(arg1: f64) -> f64;
}
extern "C" {
    pub fn __erf(arg1: f64) -> f64;
}
extern "C" {
    pub fn erfc(arg1: f64) -> f64;
}
extern "C" {
    pub fn __erfc(arg1: f64) -> f64;
}
extern "C" {
    pub fn lgamma(arg1: f64) -> f64;
}
extern "C" {
    pub fn __lgamma(arg1: f64) -> f64;
}
extern "C" {
    pub fn tgamma(arg1: f64) -> f64;
}
extern "C" {
    pub fn __tgamma(arg1: f64) -> f64;
}
extern "C" {
    pub fn gamma(arg1: f64) -> f64;
}
extern "C" {
    pub fn __gamma(arg1: f64) -> f64;
}
extern "C" {
    pub fn lgamma_r(arg1: f64, __signgamp: *mut ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn __lgamma_r(arg1: f64, __signgamp: *mut ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn rint(__x: f64) -> f64;
}
extern "C" {
    pub fn __rint(__x: f64) -> f64;
}
extern "C" {
    pub fn nextafter(__x: f64, __y: f64) -> f64;
}
extern "C" {
    pub fn __nextafter(__x: f64, __y: f64) -> f64;
}
extern "C" {
    pub fn nexttoward(__x: f64, __y: u128) -> f64;
}
extern "C" {
    pub fn __nexttoward(__x: f64, __y: u128) -> f64;
}
extern "C" {
    pub fn remainder(__x: f64, __y: f64) -> f64;
}
extern "C" {
    pub fn __remainder(__x: f64, __y: f64) -> f64;
}
extern "C" {
    pub fn scalbn(__x: f64, __n: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn __scalbn(__x: f64, __n: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn ilogb(__x: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __ilogb(__x: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn scalbln(__x: f64, __n: ::std::os::raw::c_long) -> f64;
}
extern "C" {
    pub fn __scalbln(__x: f64, __n: ::std::os::raw::c_long) -> f64;
}
extern "C" {
    pub fn nearbyint(__x: f64) -> f64;
}
extern "C" {
    pub fn __nearbyint(__x: f64) -> f64;
}
extern "C" {
    pub fn round(__x: f64) -> f64;
}
extern "C" {
    pub fn __round(__x: f64) -> f64;
}
extern "C" {
    pub fn trunc(__x: f64) -> f64;
}
extern "C" {
    pub fn __trunc(__x: f64) -> f64;
}
extern "C" {
    pub fn remquo(__x: f64, __y: f64, __quo: *mut ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn __remquo(__x: f64, __y: f64, __quo: *mut ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn lrint(__x: f64) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn __lrint(__x: f64) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn llrint(__x: f64) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn __llrint(__x: f64) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn lround(__x: f64) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn __lround(__x: f64) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn llround(__x: f64) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn __llround(__x: f64) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn fdim(__x: f64, __y: f64) -> f64;
}
extern "C" {
    pub fn __fdim(__x: f64, __y: f64) -> f64;
}
extern "C" {
    pub fn fmax(__x: f64, __y: f64) -> f64;
}
extern "C" {
    pub fn __fmax(__x: f64, __y: f64) -> f64;
}
extern "C" {
    pub fn fmin(__x: f64, __y: f64) -> f64;
}
extern "C" {
    pub fn __fmin(__x: f64, __y: f64) -> f64;
}
extern "C" {
    pub fn fma(__x: f64, __y: f64, __z: f64) -> f64;
}
extern "C" {
    pub fn __fma(__x: f64, __y: f64, __z: f64) -> f64;
}
extern "C" {
    pub fn scalb(__x: f64, __n: f64) -> f64;
}
extern "C" {
    pub fn __scalb(__x: f64, __n: f64) -> f64;
}
extern "C" {
    pub fn __fpclassifyf(__value: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __signbitf(__value: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __isinff(__value: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __finitef(__value: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __isnanf(__value: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __iseqsigf(__x: f32, __y: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __issignalingf(__value: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acosf(__x: f32) -> f32;
}
extern "C" {
    pub fn __acosf(__x: f32) -> f32;
}
extern "C" {
    pub fn asinf(__x: f32) -> f32;
}
extern "C" {
    pub fn __asinf(__x: f32) -> f32;
}
extern "C" {
    pub fn atanf(__x: f32) -> f32;
}
extern "C" {
    pub fn __atanf(__x: f32) -> f32;
}
extern "C" {
    pub fn atan2f(__y: f32, __x: f32) -> f32;
}
extern "C" {
    pub fn __atan2f(__y: f32, __x: f32) -> f32;
}
extern "C" {
    pub fn cosf(__x: f32) -> f32;
}
extern "C" {
    pub fn __cosf(__x: f32) -> f32;
}
extern "C" {
    pub fn sinf(__x: f32) -> f32;
}
extern "C" {
    pub fn __sinf(__x: f32) -> f32;
}
extern "C" {
    pub fn tanf(__x: f32) -> f32;
}
extern "C" {
    pub fn __tanf(__x: f32) -> f32;
}
extern "C" {
    pub fn coshf(__x: f32) -> f32;
}
extern "C" {
    pub fn __coshf(__x: f32) -> f32;
}
extern "C" {
    pub fn sinhf(__x: f32) -> f32;
}
extern "C" {
    pub fn __sinhf(__x: f32) -> f32;
}
extern "C" {
    pub fn tanhf(__x: f32) -> f32;
}
extern "C" {
    pub fn __tanhf(__x: f32) -> f32;
}
extern "C" {
    pub fn acoshf(__x: f32) -> f32;
}
extern "C" {
    pub fn __acoshf(__x: f32) -> f32;
}
extern "C" {
    pub fn asinhf(__x: f32) -> f32;
}
extern "C" {
    pub fn __asinhf(__x: f32) -> f32;
}
extern "C" {
    pub fn atanhf(__x: f32) -> f32;
}
extern "C" {
    pub fn __atanhf(__x: f32) -> f32;
}
extern "C" {
    pub fn expf(__x: f32) -> f32;
}
extern "C" {
    pub fn __expf(__x: f32) -> f32;
}
extern "C" {
    pub fn frexpf(__x: f32, __exponent: *mut ::std::os::raw::c_int) -> f32;
}
extern "C" {
    pub fn __frexpf(__x: f32, __exponent: *mut ::std::os::raw::c_int) -> f32;
}
extern "C" {
    pub fn ldexpf(__x: f32, __exponent: ::std::os::raw::c_int) -> f32;
}
extern "C" {
    pub fn __ldexpf(__x: f32, __exponent: ::std::os::raw::c_int) -> f32;
}
extern "C" {
    pub fn logf(__x: f32) -> f32;
}
extern "C" {
    pub fn __logf(__x: f32) -> f32;
}
extern "C" {
    pub fn log10f(__x: f32) -> f32;
}
extern "C" {
    pub fn __log10f(__x: f32) -> f32;
}
extern "C" {
    pub fn modff(__x: f32, __iptr: *mut f32) -> f32;
}
extern "C" {
    pub fn __modff(__x: f32, __iptr: *mut f32) -> f32;
}
extern "C" {
    pub fn expm1f(__x: f32) -> f32;
}
extern "C" {
    pub fn __expm1f(__x: f32) -> f32;
}
extern "C" {
    pub fn log1pf(__x: f32) -> f32;
}
extern "C" {
    pub fn __log1pf(__x: f32) -> f32;
}
extern "C" {
    pub fn logbf(__x: f32) -> f32;
}
extern "C" {
    pub fn __logbf(__x: f32) -> f32;
}
extern "C" {
    pub fn exp2f(__x: f32) -> f32;
}
extern "C" {
    pub fn __exp2f(__x: f32) -> f32;
}
extern "C" {
    pub fn log2f(__x: f32) -> f32;
}
extern "C" {
    pub fn __log2f(__x: f32) -> f32;
}
extern "C" {
    pub fn powf(__x: f32, __y: f32) -> f32;
}
extern "C" {
    pub fn __powf(__x: f32, __y: f32) -> f32;
}
extern "C" {
    pub fn sqrtf(__x: f32) -> f32;
}
extern "C" {
    pub fn __sqrtf(__x: f32) -> f32;
}
extern "C" {
    pub fn hypotf(__x: f32, __y: f32) -> f32;
}
extern "C" {
    pub fn __hypotf(__x: f32, __y: f32) -> f32;
}
extern "C" {
    pub fn cbrtf(__x: f32) -> f32;
}
extern "C" {
    pub fn __cbrtf(__x: f32) -> f32;
}
extern "C" {
    pub fn ceilf(__x: f32) -> f32;
}
extern "C" {
    pub fn __ceilf(__x: f32) -> f32;
}
extern "C" {
    pub fn fabsf(__x: f32) -> f32;
}
extern "C" {
    pub fn __fabsf(__x: f32) -> f32;
}
extern "C" {
    pub fn floorf(__x: f32) -> f32;
}
extern "C" {
    pub fn __floorf(__x: f32) -> f32;
}
extern "C" {
    pub fn fmodf(__x: f32, __y: f32) -> f32;
}
extern "C" {
    pub fn __fmodf(__x: f32, __y: f32) -> f32;
}
extern "C" {
    pub fn isinff(__value: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn finitef(__value: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dremf(__x: f32, __y: f32) -> f32;
}
extern "C" {
    pub fn __dremf(__x: f32, __y: f32) -> f32;
}
extern "C" {
    pub fn significandf(__x: f32) -> f32;
}
extern "C" {
    pub fn __significandf(__x: f32) -> f32;
}
extern "C" {
    pub fn copysignf(__x: f32, __y: f32) -> f32;
}
extern "C" {
    pub fn __copysignf(__x: f32, __y: f32) -> f32;
}
extern "C" {
    pub fn nanf(__tagb: *const ::std::os::raw::c_char) -> f32;
}
extern "C" {
    pub fn __nanf(__tagb: *const ::std::os::raw::c_char) -> f32;
}
extern "C" {
    pub fn isnanf(__value: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn j0f(arg1: f32) -> f32;
}
extern "C" {
    pub fn __j0f(arg1: f32) -> f32;
}
extern "C" {
    pub fn j1f(arg1: f32) -> f32;
}
extern "C" {
    pub fn __j1f(arg1: f32) -> f32;
}
extern "C" {
    pub fn jnf(arg1: ::std::os::raw::c_int, arg2: f32) -> f32;
}
extern "C" {
    pub fn __jnf(arg1: ::std::os::raw::c_int, arg2: f32) -> f32;
}
extern "C" {
    pub fn y0f(arg1: f32) -> f32;
}
extern "C" {
    pub fn __y0f(arg1: f32) -> f32;
}
extern "C" {
    pub fn y1f(arg1: f32) -> f32;
}
extern "C" {
    pub fn __y1f(arg1: f32) -> f32;
}
extern "C" {
    pub fn ynf(arg1: ::std::os::raw::c_int, arg2: f32) -> f32;
}
extern "C" {
    pub fn __ynf(arg1: ::std::os::raw::c_int, arg2: f32) -> f32;
}
extern "C" {
    pub fn erff(arg1: f32) -> f32;
}
extern "C" {
    pub fn __erff(arg1: f32) -> f32;
}
extern "C" {
    pub fn erfcf(arg1: f32) -> f32;
}
extern "C" {
    pub fn __erfcf(arg1: f32) -> f32;
}
extern "C" {
    pub fn lgammaf(arg1: f32) -> f32;
}
extern "C" {
    pub fn __lgammaf(arg1: f32) -> f32;
}
extern "C" {
    pub fn tgammaf(arg1: f32) -> f32;
}
extern "C" {
    pub fn __tgammaf(arg1: f32) -> f32;
}
extern "C" {
    pub fn gammaf(arg1: f32) -> f32;
}
extern "C" {
    pub fn __gammaf(arg1: f32) -> f32;
}
extern "C" {
    pub fn lgammaf_r(arg1: f32, __signgamp: *mut ::std::os::raw::c_int) -> f32;
}
extern "C" {
    pub fn __lgammaf_r(arg1: f32, __signgamp: *mut ::std::os::raw::c_int) -> f32;
}
extern "C" {
    pub fn rintf(__x: f32) -> f32;
}
extern "C" {
    pub fn __rintf(__x: f32) -> f32;
}
extern "C" {
    pub fn nextafterf(__x: f32, __y: f32) -> f32;
}
extern "C" {
    pub fn __nextafterf(__x: f32, __y: f32) -> f32;
}
extern "C" {
    pub fn nexttowardf(__x: f32, __y: u128) -> f32;
}
extern "C" {
    pub fn __nexttowardf(__x: f32, __y: u128) -> f32;
}
extern "C" {
    pub fn remainderf(__x: f32, __y: f32) -> f32;
}
extern "C" {
    pub fn __remainderf(__x: f32, __y: f32) -> f32;
}
extern "C" {
    pub fn scalbnf(__x: f32, __n: ::std::os::raw::c_int) -> f32;
}
extern "C" {
    pub fn __scalbnf(__x: f32, __n: ::std::os::raw::c_int) -> f32;
}
extern "C" {
    pub fn ilogbf(__x: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __ilogbf(__x: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn scalblnf(__x: f32, __n: ::std::os::raw::c_long) -> f32;
}
extern "C" {
    pub fn __scalblnf(__x: f32, __n: ::std::os::raw::c_long) -> f32;
}
extern "C" {
    pub fn nearbyintf(__x: f32) -> f32;
}
extern "C" {
    pub fn __nearbyintf(__x: f32) -> f32;
}
extern "C" {
    pub fn roundf(__x: f32) -> f32;
}
extern "C" {
    pub fn __roundf(__x: f32) -> f32;
}
extern "C" {
    pub fn truncf(__x: f32) -> f32;
}
extern "C" {
    pub fn __truncf(__x: f32) -> f32;
}
extern "C" {
    pub fn remquof(__x: f32, __y: f32, __quo: *mut ::std::os::raw::c_int) -> f32;
}
extern "C" {
    pub fn __remquof(__x: f32, __y: f32, __quo: *mut ::std::os::raw::c_int) -> f32;
}
extern "C" {
    pub fn lrintf(__x: f32) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn __lrintf(__x: f32) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn llrintf(__x: f32) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn __llrintf(__x: f32) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn lroundf(__x: f32) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn __lroundf(__x: f32) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn llroundf(__x: f32) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn __llroundf(__x: f32) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn fdimf(__x: f32, __y: f32) -> f32;
}
extern "C" {
    pub fn __fdimf(__x: f32, __y: f32) -> f32;
}
extern "C" {
    pub fn fmaxf(__x: f32, __y: f32) -> f32;
}
extern "C" {
    pub fn __fmaxf(__x: f32, __y: f32) -> f32;
}
extern "C" {
    pub fn fminf(__x: f32, __y: f32) -> f32;
}
extern "C" {
    pub fn __fminf(__x: f32, __y: f32) -> f32;
}
extern "C" {
    pub fn fmaf(__x: f32, __y: f32, __z: f32) -> f32;
}
extern "C" {
    pub fn __fmaf(__x: f32, __y: f32, __z: f32) -> f32;
}
extern "C" {
    pub fn scalbf(__x: f32, __n: f32) -> f32;
}
extern "C" {
    pub fn __scalbf(__x: f32, __n: f32) -> f32;
}
extern "C" {
    pub fn __fpclassifyl(__value: u128) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __signbitl(__value: u128) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __isinfl(__value: u128) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __finitel(__value: u128) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __isnanl(__value: u128) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __iseqsigl(__x: u128, __y: u128) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __issignalingl(__value: u128) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acosl(__x: u128) -> u128;
}
extern "C" {
    pub fn __acosl(__x: u128) -> u128;
}
extern "C" {
    pub fn asinl(__x: u128) -> u128;
}
extern "C" {
    pub fn __asinl(__x: u128) -> u128;
}
extern "C" {
    pub fn atanl(__x: u128) -> u128;
}
extern "C" {
    pub fn __atanl(__x: u128) -> u128;
}
extern "C" {
    pub fn atan2l(__y: u128, __x: u128) -> u128;
}
extern "C" {
    pub fn __atan2l(__y: u128, __x: u128) -> u128;
}
extern "C" {
    pub fn cosl(__x: u128) -> u128;
}
extern "C" {
    pub fn __cosl(__x: u128) -> u128;
}
extern "C" {
    pub fn sinl(__x: u128) -> u128;
}
extern "C" {
    pub fn __sinl(__x: u128) -> u128;
}
extern "C" {
    pub fn tanl(__x: u128) -> u128;
}
extern "C" {
    pub fn __tanl(__x: u128) -> u128;
}
extern "C" {
    pub fn coshl(__x: u128) -> u128;
}
extern "C" {
    pub fn __coshl(__x: u128) -> u128;
}
extern "C" {
    pub fn sinhl(__x: u128) -> u128;
}
extern "C" {
    pub fn __sinhl(__x: u128) -> u128;
}
extern "C" {
    pub fn tanhl(__x: u128) -> u128;
}
extern "C" {
    pub fn __tanhl(__x: u128) -> u128;
}
extern "C" {
    pub fn acoshl(__x: u128) -> u128;
}
extern "C" {
    pub fn __acoshl(__x: u128) -> u128;
}
extern "C" {
    pub fn asinhl(__x: u128) -> u128;
}
extern "C" {
    pub fn __asinhl(__x: u128) -> u128;
}
extern "C" {
    pub fn atanhl(__x: u128) -> u128;
}
extern "C" {
    pub fn __atanhl(__x: u128) -> u128;
}
extern "C" {
    pub fn expl(__x: u128) -> u128;
}
extern "C" {
    pub fn __expl(__x: u128) -> u128;
}
extern "C" {
    pub fn frexpl(__x: u128, __exponent: *mut ::std::os::raw::c_int) -> u128;
}
extern "C" {
    pub fn __frexpl(__x: u128, __exponent: *mut ::std::os::raw::c_int) -> u128;
}
extern "C" {
    pub fn ldexpl(__x: u128, __exponent: ::std::os::raw::c_int) -> u128;
}
extern "C" {
    pub fn __ldexpl(__x: u128, __exponent: ::std::os::raw::c_int) -> u128;
}
extern "C" {
    pub fn logl(__x: u128) -> u128;
}
extern "C" {
    pub fn __logl(__x: u128) -> u128;
}
extern "C" {
    pub fn log10l(__x: u128) -> u128;
}
extern "C" {
    pub fn __log10l(__x: u128) -> u128;
}
extern "C" {
    pub fn modfl(__x: u128, __iptr: *mut u128) -> u128;
}
extern "C" {
    pub fn __modfl(__x: u128, __iptr: *mut u128) -> u128;
}
extern "C" {
    pub fn expm1l(__x: u128) -> u128;
}
extern "C" {
    pub fn __expm1l(__x: u128) -> u128;
}
extern "C" {
    pub fn log1pl(__x: u128) -> u128;
}
extern "C" {
    pub fn __log1pl(__x: u128) -> u128;
}
extern "C" {
    pub fn logbl(__x: u128) -> u128;
}
extern "C" {
    pub fn __logbl(__x: u128) -> u128;
}
extern "C" {
    pub fn exp2l(__x: u128) -> u128;
}
extern "C" {
    pub fn __exp2l(__x: u128) -> u128;
}
extern "C" {
    pub fn log2l(__x: u128) -> u128;
}
extern "C" {
    pub fn __log2l(__x: u128) -> u128;
}
extern "C" {
    pub fn powl(__x: u128, __y: u128) -> u128;
}
extern "C" {
    pub fn __powl(__x: u128, __y: u128) -> u128;
}
extern "C" {
    pub fn sqrtl(__x: u128) -> u128;
}
extern "C" {
    pub fn __sqrtl(__x: u128) -> u128;
}
extern "C" {
    pub fn hypotl(__x: u128, __y: u128) -> u128;
}
extern "C" {
    pub fn __hypotl(__x: u128, __y: u128) -> u128;
}
extern "C" {
    pub fn cbrtl(__x: u128) -> u128;
}
extern "C" {
    pub fn __cbrtl(__x: u128) -> u128;
}
extern "C" {
    pub fn ceill(__x: u128) -> u128;
}
extern "C" {
    pub fn __ceill(__x: u128) -> u128;
}
extern "C" {
    pub fn fabsl(__x: u128) -> u128;
}
extern "C" {
    pub fn __fabsl(__x: u128) -> u128;
}
extern "C" {
    pub fn floorl(__x: u128) -> u128;
}
extern "C" {
    pub fn __floorl(__x: u128) -> u128;
}
extern "C" {
    pub fn fmodl(__x: u128, __y: u128) -> u128;
}
extern "C" {
    pub fn __fmodl(__x: u128, __y: u128) -> u128;
}
extern "C" {
    pub fn isinfl(__value: u128) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn finitel(__value: u128) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dreml(__x: u128, __y: u128) -> u128;
}
extern "C" {
    pub fn __dreml(__x: u128, __y: u128) -> u128;
}
extern "C" {
    pub fn significandl(__x: u128) -> u128;
}
extern "C" {
    pub fn __significandl(__x: u128) -> u128;
}
extern "C" {
    pub fn copysignl(__x: u128, __y: u128) -> u128;
}
extern "C" {
    pub fn __copysignl(__x: u128, __y: u128) -> u128;
}
extern "C" {
    pub fn nanl(__tagb: *const ::std::os::raw::c_char) -> u128;
}
extern "C" {
    pub fn __nanl(__tagb: *const ::std::os::raw::c_char) -> u128;
}
extern "C" {
    pub fn isnanl(__value: u128) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn j0l(arg1: u128) -> u128;
}
extern "C" {
    pub fn __j0l(arg1: u128) -> u128;
}
extern "C" {
    pub fn j1l(arg1: u128) -> u128;
}
extern "C" {
    pub fn __j1l(arg1: u128) -> u128;
}
extern "C" {
    pub fn jnl(arg1: ::std::os::raw::c_int, arg2: u128) -> u128;
}
extern "C" {
    pub fn __jnl(arg1: ::std::os::raw::c_int, arg2: u128) -> u128;
}
extern "C" {
    pub fn y0l(arg1: u128) -> u128;
}
extern "C" {
    pub fn __y0l(arg1: u128) -> u128;
}
extern "C" {
    pub fn y1l(arg1: u128) -> u128;
}
extern "C" {
    pub fn __y1l(arg1: u128) -> u128;
}
extern "C" {
    pub fn ynl(arg1: ::std::os::raw::c_int, arg2: u128) -> u128;
}
extern "C" {
    pub fn __ynl(arg1: ::std::os::raw::c_int, arg2: u128) -> u128;
}
extern "C" {
    pub fn erfl(arg1: u128) -> u128;
}
extern "C" {
    pub fn __erfl(arg1: u128) -> u128;
}
extern "C" {
    pub fn erfcl(arg1: u128) -> u128;
}
extern "C" {
    pub fn __erfcl(arg1: u128) -> u128;
}
extern "C" {
    pub fn lgammal(arg1: u128) -> u128;
}
extern "C" {
    pub fn __lgammal(arg1: u128) -> u128;
}
extern "C" {
    pub fn tgammal(arg1: u128) -> u128;
}
extern "C" {
    pub fn __tgammal(arg1: u128) -> u128;
}
extern "C" {
    pub fn gammal(arg1: u128) -> u128;
}
extern "C" {
    pub fn __gammal(arg1: u128) -> u128;
}
extern "C" {
    pub fn lgammal_r(arg1: u128, __signgamp: *mut ::std::os::raw::c_int) -> u128;
}
extern "C" {
    pub fn __lgammal_r(arg1: u128, __signgamp: *mut ::std::os::raw::c_int) -> u128;
}
extern "C" {
    pub fn rintl(__x: u128) -> u128;
}
extern "C" {
    pub fn __rintl(__x: u128) -> u128;
}
extern "C" {
    pub fn nextafterl(__x: u128, __y: u128) -> u128;
}
extern "C" {
    pub fn __nextafterl(__x: u128, __y: u128) -> u128;
}
extern "C" {
    pub fn nexttowardl(__x: u128, __y: u128) -> u128;
}
extern "C" {
    pub fn __nexttowardl(__x: u128, __y: u128) -> u128;
}
extern "C" {
    pub fn remainderl(__x: u128, __y: u128) -> u128;
}
extern "C" {
    pub fn __remainderl(__x: u128, __y: u128) -> u128;
}
extern "C" {
    pub fn scalbnl(__x: u128, __n: ::std::os::raw::c_int) -> u128;
}
extern "C" {
    pub fn __scalbnl(__x: u128, __n: ::std::os::raw::c_int) -> u128;
}
extern "C" {
    pub fn ilogbl(__x: u128) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __ilogbl(__x: u128) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn scalblnl(__x: u128, __n: ::std::os::raw::c_long) -> u128;
}
extern "C" {
    pub fn __scalblnl(__x: u128, __n: ::std::os::raw::c_long) -> u128;
}
extern "C" {
    pub fn nearbyintl(__x: u128) -> u128;
}
extern "C" {
    pub fn __nearbyintl(__x: u128) -> u128;
}
extern "C" {
    pub fn roundl(__x: u128) -> u128;
}
extern "C" {
    pub fn __roundl(__x: u128) -> u128;
}
extern "C" {
    pub fn truncl(__x: u128) -> u128;
}
extern "C" {
    pub fn __truncl(__x: u128) -> u128;
}
extern "C" {
    pub fn remquol(__x: u128, __y: u128, __quo: *mut ::std::os::raw::c_int) -> u128;
}
extern "C" {
    pub fn __remquol(__x: u128, __y: u128, __quo: *mut ::std::os::raw::c_int) -> u128;
}
extern "C" {
    pub fn lrintl(__x: u128) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn __lrintl(__x: u128) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn llrintl(__x: u128) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn __llrintl(__x: u128) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn lroundl(__x: u128) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn __lroundl(__x: u128) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn llroundl(__x: u128) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn __llroundl(__x: u128) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn fdiml(__x: u128, __y: u128) -> u128;
}
extern "C" {
    pub fn __fdiml(__x: u128, __y: u128) -> u128;
}
extern "C" {
    pub fn fmaxl(__x: u128, __y: u128) -> u128;
}
extern "C" {
    pub fn __fmaxl(__x: u128, __y: u128) -> u128;
}
extern "C" {
    pub fn fminl(__x: u128, __y: u128) -> u128;
}
extern "C" {
    pub fn __fminl(__x: u128, __y: u128) -> u128;
}
extern "C" {
    pub fn fmal(__x: u128, __y: u128, __z: u128) -> u128;
}
extern "C" {
    pub fn __fmal(__x: u128, __y: u128, __z: u128) -> u128;
}
extern "C" {
    pub fn scalbl(__x: u128, __n: u128) -> u128;
}
extern "C" {
    pub fn __scalbl(__x: u128, __n: u128) -> u128;
}
extern "C" {
    pub static mut signgam: ::std::os::raw::c_int;
}
pub const FP_NAN: ::std::os::raw::c_uint = 0;
pub const FP_INFINITE: ::std::os::raw::c_uint = 1;
pub const FP_ZERO: ::std::os::raw::c_uint = 2;
pub const FP_SUBNORMAL: ::std::os::raw::c_uint = 3;
pub const FP_NORMAL: ::std::os::raw::c_uint = 4;
pub type _bindgen_ty_1 = ::std::os::raw::c_uint;
pub type size_t = ::std::os::raw::c_ulong;
pub type va_list = __builtin_va_list;
pub type __gnuc_va_list = __builtin_va_list;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __mbstate_t {
    pub __count: ::std::os::raw::c_int,
    pub __value: __mbstate_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t__bindgen_ty_1 {
    pub __wch: ::std::os::raw::c_uint,
    pub __wchb: [::std::os::raw::c_char; 4usize],
}
#[test]
fn bindgen_test_layout___mbstate_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__mbstate_t__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(__mbstate_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<__mbstate_t__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(__mbstate_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t__bindgen_ty_1>())).__wch as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t__bindgen_ty_1),
            "::",
            stringify!(__wch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__mbstate_t__bindgen_ty_1>())).__wchb as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t__bindgen_ty_1),
            "::",
            stringify!(__wchb)
        )
    );
}
#[test]
fn bindgen_test_layout___mbstate_t() {
    assert_eq!(
        ::std::mem::size_of::<__mbstate_t>(),
        8usize,
        concat!("Size of: ", stringify!(__mbstate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__mbstate_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__mbstate_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>())).__count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>())).__value as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _G_fpos_t {
    pub __pos: __off_t,
    pub __state: __mbstate_t,
}
#[test]
fn bindgen_test_layout__G_fpos_t() {
    assert_eq!(
        ::std::mem::size_of::<_G_fpos_t>(),
        16usize,
        concat!("Size of: ", stringify!(_G_fpos_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_G_fpos_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_G_fpos_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos_t>())).__pos as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos_t),
            "::",
            stringify!(__pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos_t>())).__state as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos_t),
            "::",
            stringify!(__state)
        )
    );
}
pub type __fpos_t = _G_fpos_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _G_fpos64_t {
    pub __pos: __off64_t,
    pub __state: __mbstate_t,
}
#[test]
fn bindgen_test_layout__G_fpos64_t() {
    assert_eq!(
        ::std::mem::size_of::<_G_fpos64_t>(),
        16usize,
        concat!("Size of: ", stringify!(_G_fpos64_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_G_fpos64_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_G_fpos64_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos64_t>())).__pos as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos64_t),
            "::",
            stringify!(__pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos64_t>())).__state as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos64_t),
            "::",
            stringify!(__state)
        )
    );
}
pub type __fpos64_t = _G_fpos64_t;
pub type __FILE = _IO_FILE;
pub type FILE = _IO_FILE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_codecvt {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_wide_data {
    _unused: [u8; 0],
}
pub type _IO_lock_t = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_FILE {
    pub _flags: ::std::os::raw::c_int,
    pub _IO_read_ptr: *mut ::std::os::raw::c_char,
    pub _IO_read_end: *mut ::std::os::raw::c_char,
    pub _IO_read_base: *mut ::std::os::raw::c_char,
    pub _IO_write_base: *mut ::std::os::raw::c_char,
    pub _IO_write_ptr: *mut ::std::os::raw::c_char,
    pub _IO_write_end: *mut ::std::os::raw::c_char,
    pub _IO_buf_base: *mut ::std::os::raw::c_char,
    pub _IO_buf_end: *mut ::std::os::raw::c_char,
    pub _IO_save_base: *mut ::std::os::raw::c_char,
    pub _IO_backup_base: *mut ::std::os::raw::c_char,
    pub _IO_save_end: *mut ::std::os::raw::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: ::std::os::raw::c_int,
    pub _flags2: ::std::os::raw::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: ::std::os::raw::c_ushort,
    pub _vtable_offset: ::std::os::raw::c_schar,
    pub _shortbuf: [::std::os::raw::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut ::std::os::raw::c_void,
    pub __pad5: size_t,
    pub _mode: ::std::os::raw::c_int,
    pub _unused2: [::std::os::raw::c_char; 20usize],
}
#[test]
fn bindgen_test_layout__IO_FILE() {
    assert_eq!(
        ::std::mem::size_of::<_IO_FILE>(),
        216usize,
        concat!("Size of: ", stringify!(_IO_FILE))
    );
    assert_eq!(
        ::std::mem::align_of::<_IO_FILE>(),
        8usize,
        concat!("Alignment of ", stringify!(_IO_FILE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_ptr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_end as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_base as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_base as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_ptr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_end as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_buf_base as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_buf_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_buf_end as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_buf_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_save_base as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_save_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_backup_base as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_backup_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_save_end as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_save_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._markers as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_markers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._chain as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_chain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._fileno as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_fileno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._flags2 as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_flags2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._old_offset as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_old_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._cur_column as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_cur_column)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._vtable_offset as *const _ as usize },
        130usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_vtable_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._shortbuf as *const _ as usize },
        131usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_shortbuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._lock as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._offset as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._codecvt as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_codecvt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._wide_data as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_wide_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._freeres_list as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_freeres_list)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._freeres_buf as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_freeres_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>())).__pad5 as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(__pad5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._mode as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._unused2 as *const _ as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_unused2)
        )
    );
}
pub type off_t = __off_t;
pub type ssize_t = __ssize_t;
pub type fpos_t = __fpos_t;
extern "C" {
    pub static mut stdin: *mut FILE;
}
extern "C" {
    pub static mut stdout: *mut FILE;
}
extern "C" {
    pub static mut stderr: *mut FILE;
}
extern "C" {
    pub fn remove(__filename: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rename(
        __old: *const ::std::os::raw::c_char,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn renameat(
        __oldfd: ::std::os::raw::c_int,
        __old: *const ::std::os::raw::c_char,
        __newfd: ::std::os::raw::c_int,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tmpfile() -> *mut FILE;
}
extern "C" {
    pub fn tmpnam(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tmpnam_r(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tempnam(
        __dir: *const ::std::os::raw::c_char,
        __pfx: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fclose(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fopen(
        __filename: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn freopen(
        __filename: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
        __stream: *mut FILE,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fdopen(__fd: ::std::os::raw::c_int, __modes: *const ::std::os::raw::c_char)
        -> *mut FILE;
}
extern "C" {
    pub fn fmemopen(
        __s: *mut ::std::os::raw::c_void,
        __len: size_t,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn open_memstream(
        __bufloc: *mut *mut ::std::os::raw::c_char,
        __sizeloc: *mut size_t,
    ) -> *mut FILE;
}
extern "C" {
    pub fn setbuf(__stream: *mut FILE, __buf: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn setvbuf(
        __stream: *mut FILE,
        __buf: *mut ::std::os::raw::c_char,
        __modes: ::std::os::raw::c_int,
        __n: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setbuffer(__stream: *mut FILE, __buf: *mut ::std::os::raw::c_char, __size: size_t);
}
extern "C" {
    pub fn setlinebuf(__stream: *mut FILE);
}
extern "C" {
    pub fn fprintf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn printf(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sprintf(
        __s: *mut ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfprintf(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vprintf(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsprintf(
        __s: *mut ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snprintf(
        __s: *mut ::std::os::raw::c_char,
        __maxlen: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsnprintf(
        __s: *mut ::std::os::raw::c_char,
        __maxlen: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vdprintf(
        __fd: ::std::os::raw::c_int,
        __fmt: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dprintf(
        __fd: ::std::os::raw::c_int,
        __fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fscanf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn scanf(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sscanf(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_fscanf"]
    pub fn fscanf1(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_scanf"]
    pub fn scanf1(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_sscanf"]
    pub fn sscanf1(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfscanf(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vscanf(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsscanf(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vfscanf"]
    pub fn vfscanf1(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vscanf"]
    pub fn vscanf1(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vsscanf"]
    pub fn vsscanf1(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getc(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getc_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar_unlocked() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar(__c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc_unlocked(__c: ::std::os::raw::c_int, __stream: *mut FILE)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc_unlocked(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar_unlocked(__c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getw(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putw(__w: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgets(
        __s: *mut ::std::os::raw::c_char,
        __n: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __getdelim(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn getdelim(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn getline(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn fputs(__s: *const ::std::os::raw::c_char, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn puts(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ungetc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fread(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __n: ::std::os::raw::c_ulong,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn fwrite(
        __ptr: *const ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __n: ::std::os::raw::c_ulong,
        __s: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn fread_unlocked(
        __ptr: *mut ::std::os::raw::c_void,
        __size: size_t,
        __n: size_t,
        __stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn fwrite_unlocked(
        __ptr: *const ::std::os::raw::c_void,
        __size: size_t,
        __n: size_t,
        __stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn fseek(
        __stream: *mut FILE,
        __off: ::std::os::raw::c_long,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftell(__stream: *mut FILE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rewind(__stream: *mut FILE);
}
extern "C" {
    pub fn fseeko(
        __stream: *mut FILE,
        __off: __off_t,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftello(__stream: *mut FILE) -> __off_t;
}
extern "C" {
    pub fn fgetpos(__stream: *mut FILE, __pos: *mut fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsetpos(__stream: *mut FILE, __pos: *const fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearerr(__stream: *mut FILE);
}
extern "C" {
    pub fn feof(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearerr_unlocked(__stream: *mut FILE);
}
extern "C" {
    pub fn feof_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perror(__s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub static mut sys_nerr: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut sys_errlist: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub fn fileno(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fileno_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn popen(
        __command: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn pclose(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ctermid(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn flockfile(__stream: *mut FILE);
}
extern "C" {
    pub fn ftrylockfile(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn funlockfile(__stream: *mut FILE);
}
extern "C" {
    pub fn __uflow(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __overflow(arg1: *mut FILE, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
pub type wchar_t = ::std::os::raw::c_int;
pub const idtype_t_P_ALL: idtype_t = 0;
pub const idtype_t_P_PID: idtype_t = 1;
pub const idtype_t_P_PGID: idtype_t = 2;
pub type idtype_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct div_t {
    pub quot: ::std::os::raw::c_int,
    pub rem: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_div_t() {
    assert_eq!(
        ::std::mem::size_of::<div_t>(),
        8usize,
        concat!("Size of: ", stringify!(div_t))
    );
    assert_eq!(
        ::std::mem::align_of::<div_t>(),
        4usize,
        concat!("Alignment of ", stringify!(div_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).rem as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ldiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_ldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<ldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(ldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lldiv_t {
    pub quot: ::std::os::raw::c_longlong,
    pub rem: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_lldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<lldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(lldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
extern "C" {
    pub fn __ctype_get_mb_cur_max() -> size_t;
}
extern "C" {
    pub fn atof(__nptr: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn atoi(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atol(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn atoll(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtod(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> f64;
}
extern "C" {
    pub fn strtof(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> f32;
}
extern "C" {
    pub fn strtold(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> u128;
}
extern "C" {
    pub fn strtol(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn strtoul(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strtoq(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtouq(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn strtoll(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtoull(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn l64a(__n: ::std::os::raw::c_long) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn a64l(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
pub type u_char = __u_char;
pub type u_short = __u_short;
pub type u_int = __u_int;
pub type u_long = __u_long;
pub type quad_t = __quad_t;
pub type u_quad_t = __u_quad_t;
pub type fsid_t = __fsid_t;
pub type loff_t = __loff_t;
pub type ino_t = __ino_t;
pub type dev_t = __dev_t;
pub type gid_t = __gid_t;
pub type mode_t = __mode_t;
pub type nlink_t = __nlink_t;
pub type uid_t = __uid_t;
pub type pid_t = __pid_t;
pub type id_t = __id_t;
pub type daddr_t = __daddr_t;
pub type caddr_t = __caddr_t;
pub type key_t = __key_t;
pub type clock_t = __clock_t;
pub type clockid_t = __clockid_t;
pub type time_t = __time_t;
pub type timer_t = __timer_t;
pub type ulong = ::std::os::raw::c_ulong;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type u_int8_t = __uint8_t;
pub type u_int16_t = __uint16_t;
pub type u_int32_t = __uint32_t;
pub type u_int64_t = __uint64_t;
pub type register_t = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sigset_t {
    pub __val: [::std::os::raw::c_ulong; 16usize],
}
#[test]
fn bindgen_test_layout___sigset_t() {
    assert_eq!(
        ::std::mem::size_of::<__sigset_t>(),
        128usize,
        concat!("Size of: ", stringify!(__sigset_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigset_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigset_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigset_t>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigset_t),
            "::",
            stringify!(__val)
        )
    );
}
pub type sigset_t = __sigset_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __time_t,
    pub tv_usec: __suseconds_t,
}
#[test]
fn bindgen_test_layout_timeval() {
    assert_eq!(
        ::std::mem::size_of::<timeval>(),
        16usize,
        concat!("Size of: ", stringify!(timeval))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_usec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_usec)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __time_t,
    pub tv_nsec: __syscall_slong_t,
}
#[test]
fn bindgen_test_layout_timespec() {
    assert_eq!(
        ::std::mem::size_of::<timespec>(),
        16usize,
        concat!("Size of: ", stringify!(timespec))
    );
    assert_eq!(
        ::std::mem::align_of::<timespec>(),
        8usize,
        concat!("Alignment of ", stringify!(timespec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_nsec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_nsec)
        )
    );
}
pub type suseconds_t = __suseconds_t;
pub type __fd_mask = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fd_set {
    pub __fds_bits: [__fd_mask; 16usize],
}
#[test]
fn bindgen_test_layout_fd_set() {
    assert_eq!(
        ::std::mem::size_of::<fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<fd_set>(),
        8usize,
        concat!("Alignment of ", stringify!(fd_set))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fd_set>())).__fds_bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fd_set),
            "::",
            stringify!(__fds_bits)
        )
    );
}
pub type fd_mask = __fd_mask;
extern "C" {
    pub fn select(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *mut timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pselect(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *const timespec,
        __sigmask: *const __sigset_t,
    ) -> ::std::os::raw::c_int;
}
pub type blksize_t = __blksize_t;
pub type blkcnt_t = __blkcnt_t;
pub type fsblkcnt_t = __fsblkcnt_t;
pub type fsfilcnt_t = __fsfilcnt_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
#[test]
fn bindgen_test_layout___pthread_internal_list() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_internal_list>(),
        16usize,
        concat!("Size of: ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_internal_list>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__prev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__prev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__next as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__next)
        )
    );
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_slist {
    pub __next: *mut __pthread_internal_slist,
}
#[test]
fn bindgen_test_layout___pthread_internal_slist() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_internal_slist>(),
        8usize,
        concat!("Size of: ", stringify!(__pthread_internal_slist))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_internal_slist>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_internal_slist))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_slist>())).__next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_slist),
            "::",
            stringify!(__next)
        )
    );
}
pub type __pthread_slist_t = __pthread_internal_slist;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_mutex_s {
    pub __lock: ::std::os::raw::c_int,
    pub __count: ::std::os::raw::c_uint,
    pub __owner: ::std::os::raw::c_int,
    pub __nusers: ::std::os::raw::c_uint,
    pub __kind: ::std::os::raw::c_int,
    pub __spins: ::std::os::raw::c_short,
    pub __elision: ::std::os::raw::c_short,
    pub __list: __pthread_list_t,
}
#[test]
fn bindgen_test_layout___pthread_mutex_s() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_mutex_s>(),
        40usize,
        concat!("Size of: ", stringify!(__pthread_mutex_s))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_mutex_s>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_mutex_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__lock as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__count as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__owner as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__owner)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__nusers as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__nusers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__kind as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__kind)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__spins as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__spins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__elision as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__elision)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__list as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__list)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_rwlock_arch_t {
    pub __readers: ::std::os::raw::c_uint,
    pub __writers: ::std::os::raw::c_uint,
    pub __wrphase_futex: ::std::os::raw::c_uint,
    pub __writers_futex: ::std::os::raw::c_uint,
    pub __pad3: ::std::os::raw::c_uint,
    pub __pad4: ::std::os::raw::c_uint,
    pub __cur_writer: ::std::os::raw::c_int,
    pub __shared: ::std::os::raw::c_int,
    pub __rwelision: ::std::os::raw::c_schar,
    pub __pad1: [::std::os::raw::c_uchar; 7usize],
    pub __pad2: ::std::os::raw::c_ulong,
    pub __flags: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_rwlock_arch_t() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_rwlock_arch_t>(),
        56usize,
        concat!("Size of: ", stringify!(__pthread_rwlock_arch_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_rwlock_arch_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_rwlock_arch_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__readers as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__readers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__writers as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__writers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__wrphase_futex as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__wrphase_futex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__writers_futex as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__writers_futex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad3 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad4 as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__cur_writer as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__cur_writer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__shared as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__shared)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__rwelision as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__rwelision)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad1 as *const _ as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad2 as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__flags as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__flags)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __pthread_cond_s {
    pub __bindgen_anon_1: __pthread_cond_s__bindgen_ty_1,
    pub __bindgen_anon_2: __pthread_cond_s__bindgen_ty_2,
    pub __g_refs: [::std::os::raw::c_uint; 2usize],
    pub __g_size: [::std::os::raw::c_uint; 2usize],
    pub __g1_orig_size: ::std::os::raw::c_uint,
    pub __wrefs: ::std::os::raw::c_uint,
    pub __g_signals: [::std::os::raw::c_uint; 2usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __pthread_cond_s__bindgen_ty_1 {
    pub __wseq: ::std::os::raw::c_ulonglong,
    pub __wseq32: __pthread_cond_s__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_cond_s__bindgen_ty_1__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>())).__low
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(__low)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>())).__high
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(__high)
        )
    );
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(__pthread_cond_s__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1>())).__wseq as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1),
            "::",
            stringify!(__wseq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1>())).__wseq32 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1),
            "::",
            stringify!(__wseq32)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __pthread_cond_s__bindgen_ty_2 {
    pub __g1_start: ::std::os::raw::c_ulonglong,
    pub __g1_start32: __pthread_cond_s__bindgen_ty_2__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_cond_s__bindgen_ty_2__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>())).__low
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(__low)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>())).__high
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(__high)
        )
    );
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(__pthread_cond_s__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s__bindgen_ty_2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2>())).__g1_start as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2),
            "::",
            stringify!(__g1_start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2>())).__g1_start32 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2),
            "::",
            stringify!(__g1_start32)
        )
    );
}
#[test]
fn bindgen_test_layout___pthread_cond_s() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s>(),
        48usize,
        concat!("Size of: ", stringify!(__pthread_cond_s))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g_refs as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_refs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g_size as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g1_orig_size as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g1_orig_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__wrefs as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__wrefs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g_signals as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_signals)
        )
    );
}
pub type pthread_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutexattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pthread_mutexattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutexattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_mutexattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutexattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_mutexattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutexattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutexattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutexattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutexattr_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_condattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pthread_condattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_condattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_condattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_condattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_condattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_condattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_condattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_condattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_condattr_t),
            "::",
            stringify!(__align)
        )
    );
}
pub type pthread_key_t = ::std::os::raw::c_uint;
pub type pthread_once_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_attr_t {
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_attr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_attr_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_attr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_attr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_attr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_attr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_attr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_attr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_attr_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: __pthread_mutex_s,
    pub __size: [::std::os::raw::c_char; 40usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t {
    pub __data: __pthread_cond_s,
    pub __size: [::std::os::raw::c_char; 48usize],
    pub __align: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_pthread_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlock_t {
    pub __data: __pthread_rwlock_arch_t,
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_rwlock_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlock_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlockattr_t {
    pub __size: [::std::os::raw::c_char; 8usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_rwlockattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlockattr_t>(),
        8usize,
        concat!("Size of: ", stringify!(pthread_rwlockattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlockattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlockattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlockattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlockattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlockattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlockattr_t),
            "::",
            stringify!(__align)
        )
    );
}
pub type pthread_spinlock_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrier_t {
    pub __size: [::std::os::raw::c_char; 32usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_barrier_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrier_t>(),
        32usize,
        concat!("Size of: ", stringify!(pthread_barrier_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrier_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_barrier_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrier_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrier_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrier_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrier_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrierattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pthread_barrierattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrierattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_barrierattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrierattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_barrierattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrierattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrierattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrierattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrierattr_t),
            "::",
            stringify!(__align)
        )
    );
}
extern "C" {
    pub fn random() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn srandom(__seed: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn initstate(
        __seed: ::std::os::raw::c_uint,
        __statebuf: *mut ::std::os::raw::c_char,
        __statelen: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn setstate(__statebuf: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct random_data {
    pub fptr: *mut i32,
    pub rptr: *mut i32,
    pub state: *mut i32,
    pub rand_type: ::std::os::raw::c_int,
    pub rand_deg: ::std::os::raw::c_int,
    pub rand_sep: ::std::os::raw::c_int,
    pub end_ptr: *mut i32,
}
#[test]
fn bindgen_test_layout_random_data() {
    assert_eq!(
        ::std::mem::size_of::<random_data>(),
        48usize,
        concat!("Size of: ", stringify!(random_data))
    );
    assert_eq!(
        ::std::mem::align_of::<random_data>(),
        8usize,
        concat!("Alignment of ", stringify!(random_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).fptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(fptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rptr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).state as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rand_type as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rand_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rand_deg as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rand_deg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rand_sep as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rand_sep)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).end_ptr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(end_ptr)
        )
    );
}
extern "C" {
    pub fn random_r(__buf: *mut random_data, __result: *mut i32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srandom_r(
        __seed: ::std::os::raw::c_uint,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn initstate_r(
        __seed: ::std::os::raw::c_uint,
        __statebuf: *mut ::std::os::raw::c_char,
        __statelen: size_t,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setstate_r(
        __statebuf: *mut ::std::os::raw::c_char,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rand() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand(__seed: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn rand_r(__seed: *mut ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn drand48() -> f64;
}
extern "C" {
    pub fn erand48(__xsubi: *mut ::std::os::raw::c_ushort) -> f64;
}
extern "C" {
    pub fn lrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn nrand48(__xsubi: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn mrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn jrand48(__xsubi: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn srand48(__seedval: ::std::os::raw::c_long);
}
extern "C" {
    pub fn seed48(__seed16v: *mut ::std::os::raw::c_ushort) -> *mut ::std::os::raw::c_ushort;
}
extern "C" {
    pub fn lcong48(__param: *mut ::std::os::raw::c_ushort);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drand48_data {
    pub __x: [::std::os::raw::c_ushort; 3usize],
    pub __old_x: [::std::os::raw::c_ushort; 3usize],
    pub __c: ::std::os::raw::c_ushort,
    pub __init: ::std::os::raw::c_ushort,
    pub __a: ::std::os::raw::c_ulonglong,
}
#[test]
fn bindgen_test_layout_drand48_data() {
    assert_eq!(
        ::std::mem::size_of::<drand48_data>(),
        24usize,
        concat!("Size of: ", stringify!(drand48_data))
    );
    assert_eq!(
        ::std::mem::align_of::<drand48_data>(),
        8usize,
        concat!("Alignment of ", stringify!(drand48_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__old_x as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__old_x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__c as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__init as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__a as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__a)
        )
    );
}
extern "C" {
    pub fn drand48_r(__buffer: *mut drand48_data, __result: *mut f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn erand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut f64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lrand48_r(
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nrand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mrand48_r(
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jrand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand48_r(
        __seedval: ::std::os::raw::c_long,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn seed48_r(
        __seed16v: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lcong48_r(
        __param: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn malloc(__size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn calloc(
        __nmemb: ::std::os::raw::c_ulong,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn realloc(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn reallocarray(
        __ptr: *mut ::std::os::raw::c_void,
        __nmemb: size_t,
        __size: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn free(__ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn alloca(__size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn valloc(__size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn posix_memalign(
        __memptr: *mut *mut ::std::os::raw::c_void,
        __alignment: size_t,
        __size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn aligned_alloc(__alignment: size_t, __size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn abort();
}
extern "C" {
    pub fn atexit(__func: ::std::option::Option<unsafe extern "C" fn()>) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn at_quick_exit(
        __func: ::std::option::Option<unsafe extern "C" fn()>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn on_exit(
        __func: ::std::option::Option<
            unsafe extern "C" fn(
                __status: ::std::os::raw::c_int,
                __arg: *mut ::std::os::raw::c_void,
            ),
        >,
        __arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn quick_exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn _Exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn getenv(__name: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn putenv(__string: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setenv(
        __name: *const ::std::os::raw::c_char,
        __value: *const ::std::os::raw::c_char,
        __replace: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unsetenv(__name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearenv() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mktemp(__template: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn mkstemp(__template: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkstemps(
        __template: *mut ::std::os::raw::c_char,
        __suffixlen: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdtemp(__template: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn system(__command: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn realpath(
        __name: *const ::std::os::raw::c_char,
        __resolved: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
pub type __compar_fn_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn bsearch(
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nmemb: size_t,
        __size: size_t,
        __compar: __compar_fn_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn qsort(
        __base: *mut ::std::os::raw::c_void,
        __nmemb: size_t,
        __size: size_t,
        __compar: __compar_fn_t,
    );
}
extern "C" {
    pub fn abs(__x: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn labs(__x: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn llabs(__x: ::std::os::raw::c_longlong) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn div(__numer: ::std::os::raw::c_int, __denom: ::std::os::raw::c_int) -> div_t;
}
extern "C" {
    pub fn ldiv(__numer: ::std::os::raw::c_long, __denom: ::std::os::raw::c_long) -> ldiv_t;
}
extern "C" {
    pub fn lldiv(
        __numer: ::std::os::raw::c_longlong,
        __denom: ::std::os::raw::c_longlong,
    ) -> lldiv_t;
}
extern "C" {
    pub fn ecvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fcvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn gcvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qecvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qfcvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qgcvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ecvt_r(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fcvt_r(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qecvt_r(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qfcvt_r(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mblen(__s: *const ::std::os::raw::c_char, __n: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbtowc(
        __pwc: *mut wchar_t,
        __s: *const ::std::os::raw::c_char,
        __n: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wctomb(__s: *mut ::std::os::raw::c_char, __wchar: wchar_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbstowcs(
        __pwcs: *mut wchar_t,
        __s: *const ::std::os::raw::c_char,
        __n: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn wcstombs(
        __s: *mut ::std::os::raw::c_char,
        __pwcs: *const wchar_t,
        __n: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn rpmatch(__response: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getsubopt(
        __optionp: *mut *mut ::std::os::raw::c_char,
        __tokens: *const *mut ::std::os::raw::c_char,
        __valuep: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getloadavg(__loadavg: *mut f64, __nelem: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn memcpy(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memmove(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memccpy(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memset(
        __s: *mut ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memcmp(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn memchr(
        __s: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn strcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcat(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncat(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcoll(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strxfrm(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __locale_struct {
    pub __locales: [*mut __locale_data; 13usize],
    pub __ctype_b: *const ::std::os::raw::c_ushort,
    pub __ctype_tolower: *const ::std::os::raw::c_int,
    pub __ctype_toupper: *const ::std::os::raw::c_int,
    pub __names: [*const ::std::os::raw::c_char; 13usize],
}
#[test]
fn bindgen_test_layout___locale_struct() {
    assert_eq!(
        ::std::mem::size_of::<__locale_struct>(),
        232usize,
        concat!("Size of: ", stringify!(__locale_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<__locale_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(__locale_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__locales as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__locales)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__ctype_b as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__ctype_b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__ctype_tolower as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__ctype_tolower)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__ctype_toupper as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__ctype_toupper)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__names as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__names)
        )
    );
}
pub type __locale_t = *mut __locale_struct;
pub type locale_t = __locale_t;
extern "C" {
    pub fn strcoll_l(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __l: locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strxfrm_l(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: size_t,
        __l: locale_t,
    ) -> size_t;
}
extern "C" {
    pub fn strdup(__s: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strndup(
        __string: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strrchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcspn(
        __s: *const ::std::os::raw::c_char,
        __reject: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strspn(
        __s: *const ::std::os::raw::c_char,
        __accept: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strpbrk(
        __s: *const ::std::os::raw::c_char,
        __accept: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strstr(
        __haystack: *const ::std::os::raw::c_char,
        __needle: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strtok(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __strtok_r(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
        __save_ptr: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strtok_r(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
        __save_ptr: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strlen(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strnlen(__string: *const ::std::os::raw::c_char, __maxlen: size_t) -> size_t;
}
extern "C" {
    pub fn strerror(__errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}__xpg_strerror_r"]
    pub fn strerror_r(
        __errnum: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strerror_l(
        __errnum: ::std::os::raw::c_int,
        __l: locale_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn bcmp(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcopy(
        __src: *const ::std::os::raw::c_void,
        __dest: *mut ::std::os::raw::c_void,
        __n: size_t,
    );
}
extern "C" {
    pub fn bzero(__s: *mut ::std::os::raw::c_void, __n: ::std::os::raw::c_ulong);
}
extern "C" {
    pub fn index(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rindex(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ffs(__i: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ffsl(__l: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ffsll(__ll: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcasecmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncasecmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcasecmp_l(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __loc: locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncasecmp_l(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: size_t,
        __loc: locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn explicit_bzero(__s: *mut ::std::os::raw::c_void, __n: size_t);
}
extern "C" {
    pub fn strsep(
        __stringp: *mut *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strsignal(__sig: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __stpcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn stpcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __stpncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn stpncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn av_log2(v: ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_log2_16bit(v: ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Copy, Clone)]
pub struct max_align_t {
    pub __clang_max_align_nonce1: ::std::os::raw::c_longlong,
    pub __bindgen_padding_0: u64,
    pub __clang_max_align_nonce2: u128,
}
#[test]
fn bindgen_test_layout_max_align_t() {
    assert_eq!(
        ::std::mem::size_of::<max_align_t>(),
        32usize,
        concat!("Size of: ", stringify!(max_align_t))
    );
    assert_eq!(
        ::std::mem::align_of::<max_align_t>(),
        16usize,
        concat!("Alignment of ", stringify!(max_align_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<max_align_t>())).__clang_max_align_nonce1 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(max_align_t),
            "::",
            stringify!(__clang_max_align_nonce1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<max_align_t>())).__clang_max_align_nonce2 as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(max_align_t),
            "::",
            stringify!(__clang_max_align_nonce2)
        )
    );
}
extern "C" {
    #[doc = " Put a description of the AVERROR code errnum in errbuf."]
    #[doc = " In case of failure the global variable errno is set to indicate the"]
    #[doc = " error. Even in case of failure av_strerror() will print a generic"]
    #[doc = " error message indicating the errnum provided to errbuf."]
    #[doc = ""]
    #[doc = " @param errnum      error code to describe"]
    #[doc = " @param errbuf      buffer to which description is written"]
    #[doc = " @param errbuf_size the size in bytes of errbuf"]
    #[doc = " @return 0 on success, a negative value if a description for errnum"]
    #[doc = " cannot be found"]
    pub fn av_strerror(
        errnum: ::std::os::raw::c_int,
        errbuf: *mut ::std::os::raw::c_char,
        errbuf_size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Allocate a memory block with alignment suitable for all memory accesses"]
    #[doc = " (including vectors if available on the CPU)."]
    #[doc = ""]
    #[doc = " @param size Size in bytes for the memory block to be allocated"]
    #[doc = " @return Pointer to the allocated block, or `NULL` if the block cannot"]
    #[doc = "         be allocated"]
    #[doc = " @see av_mallocz()"]
    pub fn av_malloc(size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Allocate a memory block with alignment suitable for all memory accesses"]
    #[doc = " (including vectors if available on the CPU) and zero all the bytes of the"]
    #[doc = " block."]
    #[doc = ""]
    #[doc = " @param size Size in bytes for the memory block to be allocated"]
    #[doc = " @return Pointer to the allocated block, or `NULL` if it cannot be allocated"]
    #[doc = " @see av_malloc()"]
    pub fn av_mallocz(size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Allocate a memory block for an array with av_malloc()."]
    #[doc = ""]
    #[doc = " The allocated memory will have size `size * nmemb` bytes."]
    #[doc = ""]
    #[doc = " @param nmemb Number of element"]
    #[doc = " @param size  Size of a single element"]
    #[doc = " @return Pointer to the allocated block, or `NULL` if the block cannot"]
    #[doc = "         be allocated"]
    #[doc = " @see av_malloc()"]
    pub fn av_malloc_array(nmemb: size_t, size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Allocate a memory block for an array with av_mallocz()."]
    #[doc = ""]
    #[doc = " The allocated memory will have size `size * nmemb` bytes."]
    #[doc = ""]
    #[doc = " @param nmemb Number of elements"]
    #[doc = " @param size  Size of the single element"]
    #[doc = " @return Pointer to the allocated block, or `NULL` if the block cannot"]
    #[doc = "         be allocated"]
    #[doc = ""]
    #[doc = " @see av_mallocz()"]
    #[doc = " @see av_malloc_array()"]
    pub fn av_mallocz_array(nmemb: size_t, size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Non-inlined equivalent of av_mallocz_array()."]
    #[doc = ""]
    #[doc = " Created for symmetry with the calloc() C function."]
    pub fn av_calloc(nmemb: size_t, size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Allocate, reallocate, or free a block of memory."]
    #[doc = ""]
    #[doc = " If `ptr` is `NULL` and `size` > 0, allocate a new block. If `size` is"]
    #[doc = " zero, free the memory block pointed to by `ptr`. Otherwise, expand or"]
    #[doc = " shrink that block of memory according to `size`."]
    #[doc = ""]
    #[doc = " @param ptr  Pointer to a memory block already allocated with"]
    #[doc = "             av_realloc() or `NULL`"]
    #[doc = " @param size Size in bytes of the memory block to be allocated or"]
    #[doc = "             reallocated"]
    #[doc = ""]
    #[doc = " @return Pointer to a newly-reallocated block or `NULL` if the block"]
    #[doc = "         cannot be reallocated or the function is used to free the memory block"]
    #[doc = ""]
    #[doc = " @warning Unlike av_malloc(), the returned pointer is not guaranteed to be"]
    #[doc = "          correctly aligned."]
    #[doc = " @see av_fast_realloc()"]
    #[doc = " @see av_reallocp()"]
    pub fn av_realloc(
        ptr: *mut ::std::os::raw::c_void,
        size: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Allocate, reallocate, or free a block of memory through a pointer to a"]
    #[doc = " pointer."]
    #[doc = ""]
    #[doc = " If `*ptr` is `NULL` and `size` > 0, allocate a new block. If `size` is"]
    #[doc = " zero, free the memory block pointed to by `*ptr`. Otherwise, expand or"]
    #[doc = " shrink that block of memory according to `size`."]
    #[doc = ""]
    #[doc = " @param[in,out] ptr  Pointer to a pointer to a memory block already allocated"]
    #[doc = "                     with av_realloc(), or a pointer to `NULL`. The pointer"]
    #[doc = "                     is updated on success, or freed on failure."]
    #[doc = " @param[in]     size Size in bytes for the memory block to be allocated or"]
    #[doc = "                     reallocated"]
    #[doc = ""]
    #[doc = " @return Zero on success, an AVERROR error code on failure"]
    #[doc = ""]
    #[doc = " @warning Unlike av_malloc(), the allocated memory is not guaranteed to be"]
    #[doc = "          correctly aligned."]
    pub fn av_reallocp(ptr: *mut ::std::os::raw::c_void, size: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Allocate, reallocate, or free a block of memory."]
    #[doc = ""]
    #[doc = " This function does the same thing as av_realloc(), except:"]
    #[doc = " - It takes two size arguments and allocates `nelem * elsize` bytes,"]
    #[doc = "   after checking the result of the multiplication for integer overflow."]
    #[doc = " - It frees the input block in case of failure, thus avoiding the memory"]
    #[doc = "   leak with the classic"]
    #[doc = "   @code{.c}"]
    #[doc = "   buf = realloc(buf);"]
    #[doc = "   if (!buf)"]
    #[doc = "       return -1;"]
    #[doc = "   @endcode"]
    #[doc = "   pattern."]
    pub fn av_realloc_f(
        ptr: *mut ::std::os::raw::c_void,
        nelem: size_t,
        elsize: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Allocate, reallocate, or free an array."]
    #[doc = ""]
    #[doc = " If `ptr` is `NULL` and `nmemb` > 0, allocate a new block. If"]
    #[doc = " `nmemb` is zero, free the memory block pointed to by `ptr`."]
    #[doc = ""]
    #[doc = " @param ptr   Pointer to a memory block already allocated with"]
    #[doc = "              av_realloc() or `NULL`"]
    #[doc = " @param nmemb Number of elements in the array"]
    #[doc = " @param size  Size of the single element of the array"]
    #[doc = ""]
    #[doc = " @return Pointer to a newly-reallocated block or NULL if the block"]
    #[doc = "         cannot be reallocated or the function is used to free the memory block"]
    #[doc = ""]
    #[doc = " @warning Unlike av_malloc(), the allocated memory is not guaranteed to be"]
    #[doc = "          correctly aligned."]
    #[doc = " @see av_reallocp_array()"]
    pub fn av_realloc_array(
        ptr: *mut ::std::os::raw::c_void,
        nmemb: size_t,
        size: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Allocate, reallocate, or free an array through a pointer to a pointer."]
    #[doc = ""]
    #[doc = " If `*ptr` is `NULL` and `nmemb` > 0, allocate a new block. If `nmemb` is"]
    #[doc = " zero, free the memory block pointed to by `*ptr`."]
    #[doc = ""]
    #[doc = " @param[in,out] ptr   Pointer to a pointer to a memory block already"]
    #[doc = "                      allocated with av_realloc(), or a pointer to `NULL`."]
    #[doc = "                      The pointer is updated on success, or freed on failure."]
    #[doc = " @param[in]     nmemb Number of elements"]
    #[doc = " @param[in]     size  Size of the single element"]
    #[doc = ""]
    #[doc = " @return Zero on success, an AVERROR error code on failure"]
    #[doc = ""]
    #[doc = " @warning Unlike av_malloc(), the allocated memory is not guaranteed to be"]
    #[doc = "          correctly aligned."]
    pub fn av_reallocp_array(
        ptr: *mut ::std::os::raw::c_void,
        nmemb: size_t,
        size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Reallocate the given buffer if it is not large enough, otherwise do nothing."]
    #[doc = ""]
    #[doc = " If the given buffer is `NULL`, then a new uninitialized buffer is allocated."]
    #[doc = ""]
    #[doc = " If the given buffer is not large enough, and reallocation fails, `NULL` is"]
    #[doc = " returned and `*size` is set to 0, but the original buffer is not changed or"]
    #[doc = " freed."]
    #[doc = ""]
    #[doc = " A typical use pattern follows:"]
    #[doc = ""]
    #[doc = " @code{.c}"]
    #[doc = " uint8_t *buf = ...;"]
    #[doc = " uint8_t *new_buf = av_fast_realloc(buf, &current_size, size_needed);"]
    #[doc = " if (!new_buf) {"]
    #[doc = "     // Allocation failed; clean up original buffer"]
    #[doc = "     av_freep(&buf);"]
    #[doc = "     return AVERROR(ENOMEM);"]
    #[doc = " }"]
    #[doc = " @endcode"]
    #[doc = ""]
    #[doc = " @param[in,out] ptr      Already allocated buffer, or `NULL`"]
    #[doc = " @param[in,out] size     Pointer to the size of buffer `ptr`. `*size` is"]
    #[doc = "                         updated to the new allocated size, in particular 0"]
    #[doc = "                         in case of failure."]
    #[doc = " @param[in]     min_size Desired minimal size of buffer `ptr`"]
    #[doc = " @return `ptr` if the buffer is large enough, a pointer to newly reallocated"]
    #[doc = "         buffer if the buffer was not large enough, or `NULL` in case of"]
    #[doc = "         error"]
    #[doc = " @see av_realloc()"]
    #[doc = " @see av_fast_malloc()"]
    pub fn av_fast_realloc(
        ptr: *mut ::std::os::raw::c_void,
        size: *mut ::std::os::raw::c_uint,
        min_size: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Allocate a buffer, reusing the given one if large enough."]
    #[doc = ""]
    #[doc = " Contrary to av_fast_realloc(), the current buffer contents might not be"]
    #[doc = " preserved and on error the old buffer is freed, thus no special handling to"]
    #[doc = " avoid memleaks is necessary."]
    #[doc = ""]
    #[doc = " `*ptr` is allowed to be `NULL`, in which case allocation always happens if"]
    #[doc = " `size_needed` is greater than 0."]
    #[doc = ""]
    #[doc = " @code{.c}"]
    #[doc = " uint8_t *buf = ...;"]
    #[doc = " av_fast_malloc(&buf, &current_size, size_needed);"]
    #[doc = " if (!buf) {"]
    #[doc = "     // Allocation failed; buf already freed"]
    #[doc = "     return AVERROR(ENOMEM);"]
    #[doc = " }"]
    #[doc = " @endcode"]
    #[doc = ""]
    #[doc = " @param[in,out] ptr      Pointer to pointer to an already allocated buffer."]
    #[doc = "                         `*ptr` will be overwritten with pointer to new"]
    #[doc = "                         buffer on success or `NULL` on failure"]
    #[doc = " @param[in,out] size     Pointer to the size of buffer `*ptr`. `*size` is"]
    #[doc = "                         updated to the new allocated size, in particular 0"]
    #[doc = "                         in case of failure."]
    #[doc = " @param[in]     min_size Desired minimal size of buffer `*ptr`"]
    #[doc = " @see av_realloc()"]
    #[doc = " @see av_fast_mallocz()"]
    pub fn av_fast_malloc(
        ptr: *mut ::std::os::raw::c_void,
        size: *mut ::std::os::raw::c_uint,
        min_size: size_t,
    );
}
extern "C" {
    #[doc = " Allocate and clear a buffer, reusing the given one if large enough."]
    #[doc = ""]
    #[doc = " Like av_fast_malloc(), but all newly allocated space is initially cleared."]
    #[doc = " Reused buffer is not cleared."]
    #[doc = ""]
    #[doc = " `*ptr` is allowed to be `NULL`, in which case allocation always happens if"]
    #[doc = " `size_needed` is greater than 0."]
    #[doc = ""]
    #[doc = " @param[in,out] ptr      Pointer to pointer to an already allocated buffer."]
    #[doc = "                         `*ptr` will be overwritten with pointer to new"]
    #[doc = "                         buffer on success or `NULL` on failure"]
    #[doc = " @param[in,out] size     Pointer to the size of buffer `*ptr`. `*size` is"]
    #[doc = "                         updated to the new allocated size, in particular 0"]
    #[doc = "                         in case of failure."]
    #[doc = " @param[in]     min_size Desired minimal size of buffer `*ptr`"]
    #[doc = " @see av_fast_malloc()"]
    pub fn av_fast_mallocz(
        ptr: *mut ::std::os::raw::c_void,
        size: *mut ::std::os::raw::c_uint,
        min_size: size_t,
    );
}
extern "C" {
    #[doc = " Free a memory block which has been allocated with a function of av_malloc()"]
    #[doc = " or av_realloc() family."]
    #[doc = ""]
    #[doc = " @param ptr Pointer to the memory block which should be freed."]
    #[doc = ""]
    #[doc = " @note `ptr = NULL` is explicitly allowed."]
    #[doc = " @note It is recommended that you use av_freep() instead, to prevent leaving"]
    #[doc = "       behind dangling pointers."]
    #[doc = " @see av_freep()"]
    pub fn av_free(ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    #[doc = " Free a memory block which has been allocated with a function of av_malloc()"]
    #[doc = " or av_realloc() family, and set the pointer pointing to it to `NULL`."]
    #[doc = ""]
    #[doc = " @code{.c}"]
    #[doc = " uint8_t *buf = av_malloc(16);"]
    #[doc = " av_free(buf);"]
    #[doc = " // buf now contains a dangling pointer to freed memory, and accidental"]
    #[doc = " // dereference of buf will result in a use-after-free, which may be a"]
    #[doc = " // security risk."]
    #[doc = ""]
    #[doc = " uint8_t *buf = av_malloc(16);"]
    #[doc = " av_freep(&buf);"]
    #[doc = " // buf is now NULL, and accidental dereference will only result in a"]
    #[doc = " // NULL-pointer dereference."]
    #[doc = " @endcode"]
    #[doc = ""]
    #[doc = " @param ptr Pointer to the pointer to the memory block which should be freed"]
    #[doc = " @note `*ptr = NULL` is safe and leads to no action."]
    #[doc = " @see av_free()"]
    pub fn av_freep(ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    #[doc = " Duplicate a string."]
    #[doc = ""]
    #[doc = " @param s String to be duplicated"]
    #[doc = " @return Pointer to a newly-allocated string containing a"]
    #[doc = "         copy of `s` or `NULL` if the string cannot be allocated"]
    #[doc = " @see av_strndup()"]
    pub fn av_strdup(s: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Duplicate a substring of a string."]
    #[doc = ""]
    #[doc = " @param s   String to be duplicated"]
    #[doc = " @param len Maximum length of the resulting string (not counting the"]
    #[doc = "            terminating byte)"]
    #[doc = " @return Pointer to a newly-allocated string containing a"]
    #[doc = "         substring of `s` or `NULL` if the string cannot be allocated"]
    pub fn av_strndup(s: *const ::std::os::raw::c_char, len: size_t)
        -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Duplicate a buffer with av_malloc()."]
    #[doc = ""]
    #[doc = " @param p    Buffer to be duplicated"]
    #[doc = " @param size Size in bytes of the buffer copied"]
    #[doc = " @return Pointer to a newly allocated buffer containing a"]
    #[doc = "         copy of `p` or `NULL` if the buffer cannot be allocated"]
    pub fn av_memdup(p: *const ::std::os::raw::c_void, size: size_t)
        -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Overlapping memcpy() implementation."]
    #[doc = ""]
    #[doc = " @param dst  Destination buffer"]
    #[doc = " @param back Number of bytes back to start copying (i.e. the initial size of"]
    #[doc = "             the overlapping window); must be > 0"]
    #[doc = " @param cnt  Number of bytes to copy; must be >= 0"]
    #[doc = ""]
    #[doc = " @note `cnt > back` is valid, this will copy the bytes we just copied,"]
    #[doc = "       thus creating a repeating pattern with a period length of `back`."]
    pub fn av_memcpy_backptr(dst: *mut u8, back: ::std::os::raw::c_int, cnt: ::std::os::raw::c_int);
}
extern "C" {
    #[doc = " Add the pointer to an element to a dynamic array."]
    #[doc = ""]
    #[doc = " The array to grow is supposed to be an array of pointers to"]
    #[doc = " structures, and the element to add must be a pointer to an already"]
    #[doc = " allocated structure."]
    #[doc = ""]
    #[doc = " The array is reallocated when its size reaches powers of 2."]
    #[doc = " Therefore, the amortized cost of adding an element is constant."]
    #[doc = ""]
    #[doc = " In case of success, the pointer to the array is updated in order to"]
    #[doc = " point to the new grown array, and the number pointed to by `nb_ptr`"]
    #[doc = " is incremented."]
    #[doc = " In case of failure, the array is freed, `*tab_ptr` is set to `NULL` and"]
    #[doc = " `*nb_ptr` is set to 0."]
    #[doc = ""]
    #[doc = " @param[in,out] tab_ptr Pointer to the array to grow"]
    #[doc = " @param[in,out] nb_ptr  Pointer to the number of elements in the array"]
    #[doc = " @param[in]     elem    Element to add"]
    #[doc = " @see av_dynarray_add_nofree(), av_dynarray2_add()"]
    pub fn av_dynarray_add(
        tab_ptr: *mut ::std::os::raw::c_void,
        nb_ptr: *mut ::std::os::raw::c_int,
        elem: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[doc = " Add an element to a dynamic array."]
    #[doc = ""]
    #[doc = " Function has the same functionality as av_dynarray_add(),"]
    #[doc = " but it doesn't free memory on fails. It returns error code"]
    #[doc = " instead and leave current buffer untouched."]
    #[doc = ""]
    #[doc = " @return >=0 on success, negative otherwise"]
    #[doc = " @see av_dynarray_add(), av_dynarray2_add()"]
    pub fn av_dynarray_add_nofree(
        tab_ptr: *mut ::std::os::raw::c_void,
        nb_ptr: *mut ::std::os::raw::c_int,
        elem: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Add an element of size `elem_size` to a dynamic array."]
    #[doc = ""]
    #[doc = " The array is reallocated when its number of elements reaches powers of 2."]
    #[doc = " Therefore, the amortized cost of adding an element is constant."]
    #[doc = ""]
    #[doc = " In case of success, the pointer to the array is updated in order to"]
    #[doc = " point to the new grown array, and the number pointed to by `nb_ptr`"]
    #[doc = " is incremented."]
    #[doc = " In case of failure, the array is freed, `*tab_ptr` is set to `NULL` and"]
    #[doc = " `*nb_ptr` is set to 0."]
    #[doc = ""]
    #[doc = " @param[in,out] tab_ptr   Pointer to the array to grow"]
    #[doc = " @param[in,out] nb_ptr    Pointer to the number of elements in the array"]
    #[doc = " @param[in]     elem_size Size in bytes of an element in the array"]
    #[doc = " @param[in]     elem_data Pointer to the data of the element to add. If"]
    #[doc = "                          `NULL`, the space of the newly added element is"]
    #[doc = "                          allocated but left uninitialized."]
    #[doc = ""]
    #[doc = " @return Pointer to the data of the element to copy in the newly allocated"]
    #[doc = "         space"]
    #[doc = " @see av_dynarray_add(), av_dynarray_add_nofree()"]
    pub fn av_dynarray2_add(
        tab_ptr: *mut *mut ::std::os::raw::c_void,
        nb_ptr: *mut ::std::os::raw::c_int,
        elem_size: size_t,
        elem_data: *const u8,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Set the maximum size that may be allocated in one block."]
    #[doc = ""]
    #[doc = " The value specified with this function is effective for all libavutil's @ref"]
    #[doc = " lavu_mem_funcs \"heap management functions.\""]
    #[doc = ""]
    #[doc = " By default, the max value is defined as `INT_MAX`."]
    #[doc = ""]
    #[doc = " @param max Value to be set as the new maximum size"]
    #[doc = ""]
    #[doc = " @warning Exercise extreme caution when using this function. Don't touch"]
    #[doc = "          this if you do not understand the full consequence of doing so."]
    pub fn av_max_alloc(max: size_t);
}
#[doc = " Rational number (pair of numerator and denominator)."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVRational {
    #[doc = "< Numerator"]
    pub num: ::std::os::raw::c_int,
    #[doc = "< Denominator"]
    pub den: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_AVRational() {
    assert_eq!(
        ::std::mem::size_of::<AVRational>(),
        8usize,
        concat!("Size of: ", stringify!(AVRational))
    );
    assert_eq!(
        ::std::mem::align_of::<AVRational>(),
        4usize,
        concat!("Alignment of ", stringify!(AVRational))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVRational>())).num as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVRational),
            "::",
            stringify!(num)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVRational>())).den as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(AVRational),
            "::",
            stringify!(den)
        )
    );
}
extern "C" {
    #[doc = " Reduce a fraction."]
    #[doc = ""]
    #[doc = " This is useful for framerate calculations."]
    #[doc = ""]
    #[doc = " @param[out] dst_num Destination numerator"]
    #[doc = " @param[out] dst_den Destination denominator"]
    #[doc = " @param[in]      num Source numerator"]
    #[doc = " @param[in]      den Source denominator"]
    #[doc = " @param[in]      max Maximum allowed values for `dst_num` & `dst_den`"]
    #[doc = " @return 1 if the operation is exact, 0 otherwise"]
    pub fn av_reduce(
        dst_num: *mut ::std::os::raw::c_int,
        dst_den: *mut ::std::os::raw::c_int,
        num: i64,
        den: i64,
        max: i64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Multiply two rationals."]
    #[doc = " @param b First rational"]
    #[doc = " @param c Second rational"]
    #[doc = " @return b*c"]
    pub fn av_mul_q(b: AVRational, c: AVRational) -> AVRational;
}
extern "C" {
    #[doc = " Divide one rational by another."]
    #[doc = " @param b First rational"]
    #[doc = " @param c Second rational"]
    #[doc = " @return b/c"]
    pub fn av_div_q(b: AVRational, c: AVRational) -> AVRational;
}
extern "C" {
    #[doc = " Add two rationals."]
    #[doc = " @param b First rational"]
    #[doc = " @param c Second rational"]
    #[doc = " @return b+c"]
    pub fn av_add_q(b: AVRational, c: AVRational) -> AVRational;
}
extern "C" {
    #[doc = " Subtract one rational from another."]
    #[doc = " @param b First rational"]
    #[doc = " @param c Second rational"]
    #[doc = " @return b-c"]
    pub fn av_sub_q(b: AVRational, c: AVRational) -> AVRational;
}
extern "C" {
    #[doc = " Convert a double precision floating point number to a rational."]
    #[doc = ""]
    #[doc = " In case of infinity, the returned value is expressed as `{1, 0}` or"]
    #[doc = " `{-1, 0}` depending on the sign."]
    #[doc = ""]
    #[doc = " @param d   `double` to convert"]
    #[doc = " @param max Maximum allowed numerator and denominator"]
    #[doc = " @return `d` in AVRational form"]
    #[doc = " @see av_q2d()"]
    pub fn av_d2q(d: f64, max: ::std::os::raw::c_int) -> AVRational;
}
extern "C" {
    #[doc = " Find which of the two rationals is closer to another rational."]
    #[doc = ""]
    #[doc = " @param q     Rational to be compared against"]
    #[doc = " @param q1,q2 Rationals to be tested"]
    #[doc = " @return One of the following values:"]
    #[doc = "         - 1 if `q1` is nearer to `q` than `q2`"]
    #[doc = "         - -1 if `q2` is nearer to `q` than `q1`"]
    #[doc = "         - 0 if they have the same distance"]
    pub fn av_nearer_q(q: AVRational, q1: AVRational, q2: AVRational) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Find the value in a list of rationals nearest a given reference rational."]
    #[doc = ""]
    #[doc = " @param q      Reference rational"]
    #[doc = " @param q_list Array of rationals terminated by `{0, 0}`"]
    #[doc = " @return Index of the nearest value found in the array"]
    pub fn av_find_nearest_q_idx(q: AVRational, q_list: *const AVRational)
        -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Convert an AVRational to a IEEE 32-bit `float` expressed in fixed-point"]
    #[doc = " format."]
    #[doc = ""]
    #[doc = " @param q Rational to be converted"]
    #[doc = " @return Equivalent floating-point value, expressed as an unsigned 32-bit"]
    #[doc = "         integer."]
    #[doc = " @note The returned value is platform-indepedant."]
    pub fn av_q2intfloat(q: AVRational) -> u32;
}
extern "C" {
    #[doc = " Return the best rational so that a and b are multiple of it."]
    #[doc = " If the resulting denominator is larger than max_den, return def."]
    pub fn av_gcd_q(
        a: AVRational,
        b: AVRational,
        max_den: ::std::os::raw::c_int,
        def: AVRational,
    ) -> AVRational;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union av_intfloat32 {
    pub i: u32,
    pub f: f32,
}
#[test]
fn bindgen_test_layout_av_intfloat32() {
    assert_eq!(
        ::std::mem::size_of::<av_intfloat32>(),
        4usize,
        concat!("Size of: ", stringify!(av_intfloat32))
    );
    assert_eq!(
        ::std::mem::align_of::<av_intfloat32>(),
        4usize,
        concat!("Alignment of ", stringify!(av_intfloat32))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<av_intfloat32>())).i as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(av_intfloat32),
            "::",
            stringify!(i)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<av_intfloat32>())).f as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(av_intfloat32),
            "::",
            stringify!(f)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union av_intfloat64 {
    pub i: u64,
    pub f: f64,
}
#[test]
fn bindgen_test_layout_av_intfloat64() {
    assert_eq!(
        ::std::mem::size_of::<av_intfloat64>(),
        8usize,
        concat!("Size of: ", stringify!(av_intfloat64))
    );
    assert_eq!(
        ::std::mem::align_of::<av_intfloat64>(),
        8usize,
        concat!("Alignment of ", stringify!(av_intfloat64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<av_intfloat64>())).i as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(av_intfloat64),
            "::",
            stringify!(i)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<av_intfloat64>())).f as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(av_intfloat64),
            "::",
            stringify!(f)
        )
    );
}
#[doc = "< Round toward zero."]
pub const AVRounding_AV_ROUND_ZERO: AVRounding = 0;
#[doc = "< Round away from zero."]
pub const AVRounding_AV_ROUND_INF: AVRounding = 1;
#[doc = "< Round toward -infinity."]
pub const AVRounding_AV_ROUND_DOWN: AVRounding = 2;
#[doc = "< Round toward +infinity."]
pub const AVRounding_AV_ROUND_UP: AVRounding = 3;
#[doc = "< Round to nearest and halfway cases away from zero."]
pub const AVRounding_AV_ROUND_NEAR_INF: AVRounding = 5;
#[doc = " Flag telling rescaling functions to pass `INT64_MIN`/`MAX` through"]
#[doc = " unchanged, avoiding special cases for #AV_NOPTS_VALUE."]
#[doc = ""]
#[doc = " Unlike other values of the enumeration AVRounding, this value is a"]
#[doc = " bitmask that must be used in conjunction with another value of the"]
#[doc = " enumeration through a bitwise OR, in order to set behavior for normal"]
#[doc = " cases."]
#[doc = ""]
#[doc = " @code{.c}"]
#[doc = " av_rescale_rnd(3, 1, 2, AV_ROUND_UP | AV_ROUND_PASS_MINMAX);"]
#[doc = " // Rescaling 3:"]
#[doc = " //     Calculating 3 * 1 / 2"]
#[doc = " //     3 / 2 is rounded up to 2"]
#[doc = " //     => 2"]
#[doc = ""]
#[doc = " av_rescale_rnd(AV_NOPTS_VALUE, 1, 2, AV_ROUND_UP | AV_ROUND_PASS_MINMAX);"]
#[doc = " // Rescaling AV_NOPTS_VALUE:"]
#[doc = " //     AV_NOPTS_VALUE == INT64_MIN"]
#[doc = " //     AV_NOPTS_VALUE is passed through"]
#[doc = " //     => AV_NOPTS_VALUE"]
#[doc = " @endcode"]
pub const AVRounding_AV_ROUND_PASS_MINMAX: AVRounding = 8192;
#[doc = " Rounding methods."]
pub type AVRounding = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Compute the greatest common divisor of two integer operands."]
    #[doc = ""]
    #[doc = " @param a,b Operands"]
    #[doc = " @return GCD of a and b up to sign; if a >= 0 and b >= 0, return value is >= 0;"]
    #[doc = " if a == 0 and b == 0, returns 0."]
    pub fn av_gcd(a: i64, b: i64) -> i64;
}
extern "C" {
    #[doc = " Rescale a 64-bit integer with rounding to nearest."]
    #[doc = ""]
    #[doc = " The operation is mathematically equivalent to `a * b / c`, but writing that"]
    #[doc = " directly can overflow."]
    #[doc = ""]
    #[doc = " This function is equivalent to av_rescale_rnd() with #AV_ROUND_NEAR_INF."]
    #[doc = ""]
    #[doc = " @see av_rescale_rnd(), av_rescale_q(), av_rescale_q_rnd()"]
    pub fn av_rescale(a: i64, b: i64, c: i64) -> i64;
}
extern "C" {
    #[doc = " Rescale a 64-bit integer with specified rounding."]
    #[doc = ""]
    #[doc = " The operation is mathematically equivalent to `a * b / c`, but writing that"]
    #[doc = " directly can overflow, and does not support different rounding methods."]
    #[doc = ""]
    #[doc = " @see av_rescale(), av_rescale_q(), av_rescale_q_rnd()"]
    pub fn av_rescale_rnd(a: i64, b: i64, c: i64, rnd: AVRounding) -> i64;
}
extern "C" {
    #[doc = " Rescale a 64-bit integer by 2 rational numbers."]
    #[doc = ""]
    #[doc = " The operation is mathematically equivalent to `a * bq / cq`."]
    #[doc = ""]
    #[doc = " This function is equivalent to av_rescale_q_rnd() with #AV_ROUND_NEAR_INF."]
    #[doc = ""]
    #[doc = " @see av_rescale(), av_rescale_rnd(), av_rescale_q_rnd()"]
    pub fn av_rescale_q(a: i64, bq: AVRational, cq: AVRational) -> i64;
}
extern "C" {
    #[doc = " Rescale a 64-bit integer by 2 rational numbers with specified rounding."]
    #[doc = ""]
    #[doc = " The operation is mathematically equivalent to `a * bq / cq`."]
    #[doc = ""]
    #[doc = " @see av_rescale(), av_rescale_rnd(), av_rescale_q()"]
    pub fn av_rescale_q_rnd(a: i64, bq: AVRational, cq: AVRational, rnd: AVRounding) -> i64;
}
extern "C" {
    #[doc = " Compare two timestamps each in its own time base."]
    #[doc = ""]
    #[doc = " @return One of the following values:"]
    #[doc = "         - -1 if `ts_a` is before `ts_b`"]
    #[doc = "         - 1 if `ts_a` is after `ts_b`"]
    #[doc = "         - 0 if they represent the same position"]
    #[doc = ""]
    #[doc = " @warning"]
    #[doc = " The result of the function is undefined if one of the timestamps is outside"]
    #[doc = " the `int64_t` range when represented in the other's timebase."]
    pub fn av_compare_ts(
        ts_a: i64,
        tb_a: AVRational,
        ts_b: i64,
        tb_b: AVRational,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Compare the remainders of two integer operands divided by a common divisor."]
    #[doc = ""]
    #[doc = " In other words, compare the least significant `log2(mod)` bits of integers"]
    #[doc = " `a` and `b`."]
    #[doc = ""]
    #[doc = " @code{.c}"]
    #[doc = " av_compare_mod(0x11, 0x02, 0x10) < 0 // since 0x11 % 0x10  (0x1) < 0x02 % 0x10  (0x2)"]
    #[doc = " av_compare_mod(0x11, 0x02, 0x20) > 0 // since 0x11 % 0x20 (0x11) > 0x02 % 0x20 (0x02)"]
    #[doc = " @endcode"]
    #[doc = ""]
    #[doc = " @param a,b Operands"]
    #[doc = " @param mod Divisor; must be a power of 2"]
    #[doc = " @return"]
    #[doc = "         - a negative value if `a % mod < b % mod`"]
    #[doc = "         - a positive value if `a % mod > b % mod`"]
    #[doc = "         - zero             if `a % mod == b % mod`"]
    pub fn av_compare_mod(a: u64, b: u64, mod_: u64) -> i64;
}
extern "C" {
    #[doc = " Rescale a timestamp while preserving known durations."]
    #[doc = ""]
    #[doc = " This function is designed to be called per audio packet to scale the input"]
    #[doc = " timestamp to a different time base. Compared to a simple av_rescale_q()"]
    #[doc = " call, this function is robust against possible inconsistent frame durations."]
    #[doc = ""]
    #[doc = " The `last` parameter is a state variable that must be preserved for all"]
    #[doc = " subsequent calls for the same stream. For the first call, `*last` should be"]
    #[doc = " initialized to #AV_NOPTS_VALUE."]
    #[doc = ""]
    #[doc = " @param[in]     in_tb    Input time base"]
    #[doc = " @param[in]     in_ts    Input timestamp"]
    #[doc = " @param[in]     fs_tb    Duration time base; typically this is finer-grained"]
    #[doc = "                         (greater) than `in_tb` and `out_tb`"]
    #[doc = " @param[in]     duration Duration till the next call to this function (i.e."]
    #[doc = "                         duration of the current packet/frame)"]
    #[doc = " @param[in,out] last     Pointer to a timestamp expressed in terms of"]
    #[doc = "                         `fs_tb`, acting as a state variable"]
    #[doc = " @param[in]     out_tb   Output timebase"]
    #[doc = " @return        Timestamp expressed in terms of `out_tb`"]
    #[doc = ""]
    #[doc = " @note In the context of this function, \"duration\" is in term of samples, not"]
    #[doc = "       seconds."]
    pub fn av_rescale_delta(
        in_tb: AVRational,
        in_ts: i64,
        fs_tb: AVRational,
        duration: ::std::os::raw::c_int,
        last: *mut i64,
        out_tb: AVRational,
    ) -> i64;
}
extern "C" {
    #[doc = " Add a value to a timestamp."]
    #[doc = ""]
    #[doc = " This function guarantees that when the same value is repeatly added that"]
    #[doc = " no accumulation of rounding errors occurs."]
    #[doc = ""]
    #[doc = " @param[in] ts     Input timestamp"]
    #[doc = " @param[in] ts_tb  Input timestamp time base"]
    #[doc = " @param[in] inc    Value to be added"]
    #[doc = " @param[in] inc_tb Time base of `inc`"]
    pub fn av_add_stable(ts_tb: AVRational, ts: i64, inc_tb: AVRational, inc: i64) -> i64;
}
pub const AVClassCategory_AV_CLASS_CATEGORY_NA: AVClassCategory = 0;
pub const AVClassCategory_AV_CLASS_CATEGORY_INPUT: AVClassCategory = 1;
pub const AVClassCategory_AV_CLASS_CATEGORY_OUTPUT: AVClassCategory = 2;
pub const AVClassCategory_AV_CLASS_CATEGORY_MUXER: AVClassCategory = 3;
pub const AVClassCategory_AV_CLASS_CATEGORY_DEMUXER: AVClassCategory = 4;
pub const AVClassCategory_AV_CLASS_CATEGORY_ENCODER: AVClassCategory = 5;
pub const AVClassCategory_AV_CLASS_CATEGORY_DECODER: AVClassCategory = 6;
pub const AVClassCategory_AV_CLASS_CATEGORY_FILTER: AVClassCategory = 7;
pub const AVClassCategory_AV_CLASS_CATEGORY_BITSTREAM_FILTER: AVClassCategory = 8;
pub const AVClassCategory_AV_CLASS_CATEGORY_SWSCALER: AVClassCategory = 9;
pub const AVClassCategory_AV_CLASS_CATEGORY_SWRESAMPLER: AVClassCategory = 10;
pub const AVClassCategory_AV_CLASS_CATEGORY_DEVICE_VIDEO_OUTPUT: AVClassCategory = 40;
pub const AVClassCategory_AV_CLASS_CATEGORY_DEVICE_VIDEO_INPUT: AVClassCategory = 41;
pub const AVClassCategory_AV_CLASS_CATEGORY_DEVICE_AUDIO_OUTPUT: AVClassCategory = 42;
pub const AVClassCategory_AV_CLASS_CATEGORY_DEVICE_AUDIO_INPUT: AVClassCategory = 43;
pub const AVClassCategory_AV_CLASS_CATEGORY_DEVICE_OUTPUT: AVClassCategory = 44;
pub const AVClassCategory_AV_CLASS_CATEGORY_DEVICE_INPUT: AVClassCategory = 45;
#[doc = "< not part of ABI/API"]
pub const AVClassCategory_AV_CLASS_CATEGORY_NB: AVClassCategory = 46;
pub type AVClassCategory = ::std::os::raw::c_uint;
#[doc = " Describe the class of an AVClass context structure. That is an"]
#[doc = " arbitrary struct of which the first field is a pointer to an"]
#[doc = " AVClass struct (e.g. AVCodecContext, AVFormatContext etc.)."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVClass {
    #[doc = " The name of the class; usually it is the same name as the"]
    #[doc = " context structure type to which the AVClass is associated."]
    pub class_name: *const ::std::os::raw::c_char,
    #[doc = " A pointer to a function which returns the name of a context"]
    #[doc = " instance ctx associated with the class."]
    pub item_name: ::std::option::Option<
        unsafe extern "C" fn(ctx: *mut ::std::os::raw::c_void) -> *const ::std::os::raw::c_char,
    >,
    #[doc = " a pointer to the first option specified in the class if any or NULL"]
    #[doc = ""]
    #[doc = " @see av_set_default_options()"]
    pub option: *const AVOption,
    #[doc = " LIBAVUTIL_VERSION with which this structure was created."]
    #[doc = " This is used to allow fields to be added without requiring major"]
    #[doc = " version bumps everywhere."]
    pub version: ::std::os::raw::c_int,
    #[doc = " Offset in the structure where log_level_offset is stored."]
    #[doc = " 0 means there is no such variable"]
    pub log_level_offset_offset: ::std::os::raw::c_int,
    #[doc = " Offset in the structure where a pointer to the parent context for"]
    #[doc = " logging is stored. For example a decoder could pass its AVCodecContext"]
    #[doc = " to eval as such a parent context, which an av_log() implementation"]
    #[doc = " could then leverage to display the parent context."]
    #[doc = " The offset can be NULL."]
    pub parent_log_context_offset: ::std::os::raw::c_int,
    #[doc = " Return next AVOptions-enabled child or NULL"]
    pub child_next: ::std::option::Option<
        unsafe extern "C" fn(
            obj: *mut ::std::os::raw::c_void,
            prev: *mut ::std::os::raw::c_void,
        ) -> *mut ::std::os::raw::c_void,
    >,
    #[doc = " Category used for visualization (like color)"]
    #[doc = " This is only set if the category is equal for all objects using this class."]
    #[doc = " available since version (51 << 16 | 56 << 8 | 100)"]
    pub category: AVClassCategory,
    #[doc = " Callback to return the category."]
    #[doc = " available since version (51 << 16 | 59 << 8 | 100)"]
    pub get_category: ::std::option::Option<
        unsafe extern "C" fn(ctx: *mut ::std::os::raw::c_void) -> AVClassCategory,
    >,
    #[doc = " Callback to return the supported/allowed ranges."]
    #[doc = " available since version (52.12)"]
    pub query_ranges: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut *mut AVOptionRanges,
            obj: *mut ::std::os::raw::c_void,
            key: *const ::std::os::raw::c_char,
            flags: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " Iterate over the AVClasses corresponding to potential AVOptions-enabled"]
    #[doc = " children."]
    #[doc = ""]
    #[doc = " @param iter pointer to opaque iteration state. The caller must initialize"]
    #[doc = "             *iter to NULL before the first call."]
    #[doc = " @return AVClass for the next AVOptions-enabled child or NULL if there are"]
    #[doc = "         no more such children."]
    #[doc = ""]
    #[doc = " @note The difference between child_next and this is that child_next"]
    #[doc = "       iterates over _already existing_ objects, while child_class_iterate"]
    #[doc = "       iterates over _all possible_ children."]
    pub child_class_iterate: ::std::option::Option<
        unsafe extern "C" fn(iter: *mut *mut ::std::os::raw::c_void) -> *const AVClass,
    >,
}
#[test]
fn bindgen_test_layout_AVClass() {
    assert_eq!(
        ::std::mem::size_of::<AVClass>(),
        80usize,
        concat!("Size of: ", stringify!(AVClass))
    );
    assert_eq!(
        ::std::mem::align_of::<AVClass>(),
        8usize,
        concat!("Alignment of ", stringify!(AVClass))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVClass>())).class_name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVClass),
            "::",
            stringify!(class_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVClass>())).item_name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVClass),
            "::",
            stringify!(item_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVClass>())).option as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVClass),
            "::",
            stringify!(option)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVClass>())).version as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVClass),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVClass>())).log_level_offset_offset as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(AVClass),
            "::",
            stringify!(log_level_offset_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVClass>())).parent_log_context_offset as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVClass),
            "::",
            stringify!(parent_log_context_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVClass>())).child_next as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVClass),
            "::",
            stringify!(child_next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVClass>())).category as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(AVClass),
            "::",
            stringify!(category)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVClass>())).get_category as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(AVClass),
            "::",
            stringify!(get_category)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVClass>())).query_ranges as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(AVClass),
            "::",
            stringify!(query_ranges)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVClass>())).child_class_iterate as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(AVClass),
            "::",
            stringify!(child_class_iterate)
        )
    );
}
extern "C" {
    #[doc = " Send the specified message to the log if the level is less than or equal"]
    #[doc = " to the current av_log_level. By default, all logging messages are sent to"]
    #[doc = " stderr. This behavior can be altered by setting a different logging callback"]
    #[doc = " function."]
    #[doc = " @see av_log_set_callback"]
    #[doc = ""]
    #[doc = " @param avcl A pointer to an arbitrary struct of which the first field is a"]
    #[doc = "        pointer to an AVClass struct or NULL if general log."]
    #[doc = " @param level The importance level of the message expressed using a @ref"]
    #[doc = "        lavu_log_constants \"Logging Constant\"."]
    #[doc = " @param fmt The format string (printf-compatible) that specifies how"]
    #[doc = "        subsequent arguments are converted to output."]
    pub fn av_log(
        avcl: *mut ::std::os::raw::c_void,
        level: ::std::os::raw::c_int,
        fmt: *const ::std::os::raw::c_char,
        ...
    );
}
extern "C" {
    #[doc = " Send the specified message to the log once with the initial_level and then with"]
    #[doc = " the subsequent_level. By default, all logging messages are sent to"]
    #[doc = " stderr. This behavior can be altered by setting a different logging callback"]
    #[doc = " function."]
    #[doc = " @see av_log"]
    #[doc = ""]
    #[doc = " @param avcl A pointer to an arbitrary struct of which the first field is a"]
    #[doc = "        pointer to an AVClass struct or NULL if general log."]
    #[doc = " @param initial_level importance level of the message expressed using a @ref"]
    #[doc = "        lavu_log_constants \"Logging Constant\" for the first occurance."]
    #[doc = " @param subsequent_level importance level of the message expressed using a @ref"]
    #[doc = "        lavu_log_constants \"Logging Constant\" after the first occurance."]
    #[doc = " @param fmt The format string (printf-compatible) that specifies how"]
    #[doc = "        subsequent arguments are converted to output."]
    #[doc = " @param state a variable to keep trak of if a message has already been printed"]
    #[doc = "        this must be initialized to 0 before the first use. The same state"]
    #[doc = "        must not be accessed by 2 Threads simultaneously."]
    pub fn av_log_once(
        avcl: *mut ::std::os::raw::c_void,
        initial_level: ::std::os::raw::c_int,
        subsequent_level: ::std::os::raw::c_int,
        state: *mut ::std::os::raw::c_int,
        fmt: *const ::std::os::raw::c_char,
        ...
    );
}
extern "C" {
    #[doc = " Send the specified message to the log if the level is less than or equal"]
    #[doc = " to the current av_log_level. By default, all logging messages are sent to"]
    #[doc = " stderr. This behavior can be altered by setting a different logging callback"]
    #[doc = " function."]
    #[doc = " @see av_log_set_callback"]
    #[doc = ""]
    #[doc = " @param avcl A pointer to an arbitrary struct of which the first field is a"]
    #[doc = "        pointer to an AVClass struct."]
    #[doc = " @param level The importance level of the message expressed using a @ref"]
    #[doc = "        lavu_log_constants \"Logging Constant\"."]
    #[doc = " @param fmt The format string (printf-compatible) that specifies how"]
    #[doc = "        subsequent arguments are converted to output."]
    #[doc = " @param vl The arguments referenced by the format string."]
    pub fn av_vlog(
        avcl: *mut ::std::os::raw::c_void,
        level: ::std::os::raw::c_int,
        fmt: *const ::std::os::raw::c_char,
        vl: *mut __va_list_tag,
    );
}
extern "C" {
    #[doc = " Get the current log level"]
    #[doc = ""]
    #[doc = " @see lavu_log_constants"]
    #[doc = ""]
    #[doc = " @return Current log level"]
    pub fn av_log_get_level() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Set the log level"]
    #[doc = ""]
    #[doc = " @see lavu_log_constants"]
    #[doc = ""]
    #[doc = " @param level Logging level"]
    pub fn av_log_set_level(level: ::std::os::raw::c_int);
}
extern "C" {
    #[doc = " Set the logging callback"]
    #[doc = ""]
    #[doc = " @note The callback must be thread safe, even if the application does not use"]
    #[doc = "       threads itself as some codecs are multithreaded."]
    #[doc = ""]
    #[doc = " @see av_log_default_callback"]
    #[doc = ""]
    #[doc = " @param callback A logging function with a compatible signature."]
    pub fn av_log_set_callback(
        callback: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: ::std::os::raw::c_int,
                arg3: *const ::std::os::raw::c_char,
                arg4: *mut __va_list_tag,
            ),
        >,
    );
}
extern "C" {
    #[doc = " Default logging callback"]
    #[doc = ""]
    #[doc = " It prints the message to stderr, optionally colorizing it."]
    #[doc = ""]
    #[doc = " @param avcl A pointer to an arbitrary struct of which the first field is a"]
    #[doc = "        pointer to an AVClass struct."]
    #[doc = " @param level The importance level of the message expressed using a @ref"]
    #[doc = "        lavu_log_constants \"Logging Constant\"."]
    #[doc = " @param fmt The format string (printf-compatible) that specifies how"]
    #[doc = "        subsequent arguments are converted to output."]
    #[doc = " @param vl The arguments referenced by the format string."]
    pub fn av_log_default_callback(
        avcl: *mut ::std::os::raw::c_void,
        level: ::std::os::raw::c_int,
        fmt: *const ::std::os::raw::c_char,
        vl: *mut __va_list_tag,
    );
}
extern "C" {
    #[doc = " Return the context name"]
    #[doc = ""]
    #[doc = " @param  ctx The AVClass context"]
    #[doc = ""]
    #[doc = " @return The AVClass class_name"]
    pub fn av_default_item_name(ctx: *mut ::std::os::raw::c_void) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn av_default_get_category(ptr: *mut ::std::os::raw::c_void) -> AVClassCategory;
}
extern "C" {
    #[doc = " Format a line of log the same way as the default callback."]
    #[doc = " @param line          buffer to receive the formatted line"]
    #[doc = " @param line_size     size of the buffer"]
    #[doc = " @param print_prefix  used to store whether the prefix must be printed;"]
    #[doc = "                      must point to a persistent integer initially set to 1"]
    pub fn av_log_format_line(
        ptr: *mut ::std::os::raw::c_void,
        level: ::std::os::raw::c_int,
        fmt: *const ::std::os::raw::c_char,
        vl: *mut __va_list_tag,
        line: *mut ::std::os::raw::c_char,
        line_size: ::std::os::raw::c_int,
        print_prefix: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    #[doc = " Format a line of log the same way as the default callback."]
    #[doc = " @param line          buffer to receive the formatted line;"]
    #[doc = "                      may be NULL if line_size is 0"]
    #[doc = " @param line_size     size of the buffer; at most line_size-1 characters will"]
    #[doc = "                      be written to the buffer, plus one null terminator"]
    #[doc = " @param print_prefix  used to store whether the prefix must be printed;"]
    #[doc = "                      must point to a persistent integer initially set to 1"]
    #[doc = " @return Returns a negative value if an error occurred, otherwise returns"]
    #[doc = "         the number of characters that would have been written for a"]
    #[doc = "         sufficiently large buffer, not including the terminating null"]
    #[doc = "         character. If the return value is not less than line_size, it means"]
    #[doc = "         that the log message was truncated to fit the buffer."]
    pub fn av_log_format_line2(
        ptr: *mut ::std::os::raw::c_void,
        level: ::std::os::raw::c_int,
        fmt: *const ::std::os::raw::c_char,
        vl: *mut __va_list_tag,
        line: *mut ::std::os::raw::c_char,
        line_size: ::std::os::raw::c_int,
        print_prefix: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_log_set_flags(arg: ::std::os::raw::c_int);
}
extern "C" {
    pub fn av_log_get_flags() -> ::std::os::raw::c_int;
}
pub const AVPixelFormat_AV_PIX_FMT_NONE: AVPixelFormat = -1;
#[doc = "< planar YUV 4:2:0, 12bpp, (1 Cr & Cb sample per 2x2 Y samples)"]
pub const AVPixelFormat_AV_PIX_FMT_YUV420P: AVPixelFormat = 0;
#[doc = "< packed YUV 4:2:2, 16bpp, Y0 Cb Y1 Cr"]
pub const AVPixelFormat_AV_PIX_FMT_YUYV422: AVPixelFormat = 1;
#[doc = "< packed RGB 8:8:8, 24bpp, RGBRGB..."]
pub const AVPixelFormat_AV_PIX_FMT_RGB24: AVPixelFormat = 2;
#[doc = "< packed RGB 8:8:8, 24bpp, BGRBGR..."]
pub const AVPixelFormat_AV_PIX_FMT_BGR24: AVPixelFormat = 3;
#[doc = "< planar YUV 4:2:2, 16bpp, (1 Cr & Cb sample per 2x1 Y samples)"]
pub const AVPixelFormat_AV_PIX_FMT_YUV422P: AVPixelFormat = 4;
#[doc = "< planar YUV 4:4:4, 24bpp, (1 Cr & Cb sample per 1x1 Y samples)"]
pub const AVPixelFormat_AV_PIX_FMT_YUV444P: AVPixelFormat = 5;
#[doc = "< planar YUV 4:1:0,  9bpp, (1 Cr & Cb sample per 4x4 Y samples)"]
pub const AVPixelFormat_AV_PIX_FMT_YUV410P: AVPixelFormat = 6;
#[doc = "< planar YUV 4:1:1, 12bpp, (1 Cr & Cb sample per 4x1 Y samples)"]
pub const AVPixelFormat_AV_PIX_FMT_YUV411P: AVPixelFormat = 7;
#[doc = "<        Y        ,  8bpp"]
pub const AVPixelFormat_AV_PIX_FMT_GRAY8: AVPixelFormat = 8;
#[doc = "<        Y        ,  1bpp, 0 is white, 1 is black, in each byte pixels are ordered from the msb to the lsb"]
pub const AVPixelFormat_AV_PIX_FMT_MONOWHITE: AVPixelFormat = 9;
#[doc = "<        Y        ,  1bpp, 0 is black, 1 is white, in each byte pixels are ordered from the msb to the lsb"]
pub const AVPixelFormat_AV_PIX_FMT_MONOBLACK: AVPixelFormat = 10;
#[doc = "< 8 bits with AV_PIX_FMT_RGB32 palette"]
pub const AVPixelFormat_AV_PIX_FMT_PAL8: AVPixelFormat = 11;
#[doc = "< planar YUV 4:2:0, 12bpp, full scale (JPEG), deprecated in favor of AV_PIX_FMT_YUV420P and setting color_range"]
pub const AVPixelFormat_AV_PIX_FMT_YUVJ420P: AVPixelFormat = 12;
#[doc = "< planar YUV 4:2:2, 16bpp, full scale (JPEG), deprecated in favor of AV_PIX_FMT_YUV422P and setting color_range"]
pub const AVPixelFormat_AV_PIX_FMT_YUVJ422P: AVPixelFormat = 13;
#[doc = "< planar YUV 4:4:4, 24bpp, full scale (JPEG), deprecated in favor of AV_PIX_FMT_YUV444P and setting color_range"]
pub const AVPixelFormat_AV_PIX_FMT_YUVJ444P: AVPixelFormat = 14;
#[doc = "< packed YUV 4:2:2, 16bpp, Cb Y0 Cr Y1"]
pub const AVPixelFormat_AV_PIX_FMT_UYVY422: AVPixelFormat = 15;
#[doc = "< packed YUV 4:1:1, 12bpp, Cb Y0 Y1 Cr Y2 Y3"]
pub const AVPixelFormat_AV_PIX_FMT_UYYVYY411: AVPixelFormat = 16;
#[doc = "< packed RGB 3:3:2,  8bpp, (msb)2B 3G 3R(lsb)"]
pub const AVPixelFormat_AV_PIX_FMT_BGR8: AVPixelFormat = 17;
#[doc = "< packed RGB 1:2:1 bitstream,  4bpp, (msb)1B 2G 1R(lsb), a byte contains two pixels, the first pixel in the byte is the one composed by the 4 msb bits"]
pub const AVPixelFormat_AV_PIX_FMT_BGR4: AVPixelFormat = 18;
#[doc = "< packed RGB 1:2:1,  8bpp, (msb)1B 2G 1R(lsb)"]
pub const AVPixelFormat_AV_PIX_FMT_BGR4_BYTE: AVPixelFormat = 19;
#[doc = "< packed RGB 3:3:2,  8bpp, (msb)2R 3G 3B(lsb)"]
pub const AVPixelFormat_AV_PIX_FMT_RGB8: AVPixelFormat = 20;
#[doc = "< packed RGB 1:2:1 bitstream,  4bpp, (msb)1R 2G 1B(lsb), a byte contains two pixels, the first pixel in the byte is the one composed by the 4 msb bits"]
pub const AVPixelFormat_AV_PIX_FMT_RGB4: AVPixelFormat = 21;
#[doc = "< packed RGB 1:2:1,  8bpp, (msb)1R 2G 1B(lsb)"]
pub const AVPixelFormat_AV_PIX_FMT_RGB4_BYTE: AVPixelFormat = 22;
#[doc = "< planar YUV 4:2:0, 12bpp, 1 plane for Y and 1 plane for the UV components, which are interleaved (first byte U and the following byte V)"]
pub const AVPixelFormat_AV_PIX_FMT_NV12: AVPixelFormat = 23;
#[doc = "< as above, but U and V bytes are swapped"]
pub const AVPixelFormat_AV_PIX_FMT_NV21: AVPixelFormat = 24;
#[doc = "< packed ARGB 8:8:8:8, 32bpp, ARGBARGB..."]
pub const AVPixelFormat_AV_PIX_FMT_ARGB: AVPixelFormat = 25;
#[doc = "< packed RGBA 8:8:8:8, 32bpp, RGBARGBA..."]
pub const AVPixelFormat_AV_PIX_FMT_RGBA: AVPixelFormat = 26;
#[doc = "< packed ABGR 8:8:8:8, 32bpp, ABGRABGR..."]
pub const AVPixelFormat_AV_PIX_FMT_ABGR: AVPixelFormat = 27;
#[doc = "< packed BGRA 8:8:8:8, 32bpp, BGRABGRA..."]
pub const AVPixelFormat_AV_PIX_FMT_BGRA: AVPixelFormat = 28;
#[doc = "<        Y        , 16bpp, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GRAY16BE: AVPixelFormat = 29;
#[doc = "<        Y        , 16bpp, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GRAY16LE: AVPixelFormat = 30;
#[doc = "< planar YUV 4:4:0 (1 Cr & Cb sample per 1x2 Y samples)"]
pub const AVPixelFormat_AV_PIX_FMT_YUV440P: AVPixelFormat = 31;
#[doc = "< planar YUV 4:4:0 full scale (JPEG), deprecated in favor of AV_PIX_FMT_YUV440P and setting color_range"]
pub const AVPixelFormat_AV_PIX_FMT_YUVJ440P: AVPixelFormat = 32;
#[doc = "< planar YUV 4:2:0, 20bpp, (1 Cr & Cb sample per 2x2 Y & A samples)"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA420P: AVPixelFormat = 33;
#[doc = "< packed RGB 16:16:16, 48bpp, 16R, 16G, 16B, the 2-byte value for each R/G/B component is stored as big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_RGB48BE: AVPixelFormat = 34;
#[doc = "< packed RGB 16:16:16, 48bpp, 16R, 16G, 16B, the 2-byte value for each R/G/B component is stored as little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_RGB48LE: AVPixelFormat = 35;
#[doc = "< packed RGB 5:6:5, 16bpp, (msb)   5R 6G 5B(lsb), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_RGB565BE: AVPixelFormat = 36;
#[doc = "< packed RGB 5:6:5, 16bpp, (msb)   5R 6G 5B(lsb), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_RGB565LE: AVPixelFormat = 37;
#[doc = "< packed RGB 5:5:5, 16bpp, (msb)1X 5R 5G 5B(lsb), big-endian   , X=unused/undefined"]
pub const AVPixelFormat_AV_PIX_FMT_RGB555BE: AVPixelFormat = 38;
#[doc = "< packed RGB 5:5:5, 16bpp, (msb)1X 5R 5G 5B(lsb), little-endian, X=unused/undefined"]
pub const AVPixelFormat_AV_PIX_FMT_RGB555LE: AVPixelFormat = 39;
#[doc = "< packed BGR 5:6:5, 16bpp, (msb)   5B 6G 5R(lsb), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_BGR565BE: AVPixelFormat = 40;
#[doc = "< packed BGR 5:6:5, 16bpp, (msb)   5B 6G 5R(lsb), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_BGR565LE: AVPixelFormat = 41;
#[doc = "< packed BGR 5:5:5, 16bpp, (msb)1X 5B 5G 5R(lsb), big-endian   , X=unused/undefined"]
pub const AVPixelFormat_AV_PIX_FMT_BGR555BE: AVPixelFormat = 42;
#[doc = "< packed BGR 5:5:5, 16bpp, (msb)1X 5B 5G 5R(lsb), little-endian, X=unused/undefined"]
pub const AVPixelFormat_AV_PIX_FMT_BGR555LE: AVPixelFormat = 43;
#[doc = "  Hardware acceleration through VA-API, data[3] contains a"]
#[doc = "  VASurfaceID."]
pub const AVPixelFormat_AV_PIX_FMT_VAAPI: AVPixelFormat = 44;
#[doc = "< planar YUV 4:2:0, 24bpp, (1 Cr & Cb sample per 2x2 Y samples), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV420P16LE: AVPixelFormat = 45;
#[doc = "< planar YUV 4:2:0, 24bpp, (1 Cr & Cb sample per 2x2 Y samples), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV420P16BE: AVPixelFormat = 46;
#[doc = "< planar YUV 4:2:2, 32bpp, (1 Cr & Cb sample per 2x1 Y samples), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV422P16LE: AVPixelFormat = 47;
#[doc = "< planar YUV 4:2:2, 32bpp, (1 Cr & Cb sample per 2x1 Y samples), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV422P16BE: AVPixelFormat = 48;
#[doc = "< planar YUV 4:4:4, 48bpp, (1 Cr & Cb sample per 1x1 Y samples), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV444P16LE: AVPixelFormat = 49;
#[doc = "< planar YUV 4:4:4, 48bpp, (1 Cr & Cb sample per 1x1 Y samples), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV444P16BE: AVPixelFormat = 50;
#[doc = "< HW decoding through DXVA2, Picture.data[3] contains a LPDIRECT3DSURFACE9 pointer"]
pub const AVPixelFormat_AV_PIX_FMT_DXVA2_VLD: AVPixelFormat = 51;
#[doc = "< packed RGB 4:4:4, 16bpp, (msb)4X 4R 4G 4B(lsb), little-endian, X=unused/undefined"]
pub const AVPixelFormat_AV_PIX_FMT_RGB444LE: AVPixelFormat = 52;
#[doc = "< packed RGB 4:4:4, 16bpp, (msb)4X 4R 4G 4B(lsb), big-endian,    X=unused/undefined"]
pub const AVPixelFormat_AV_PIX_FMT_RGB444BE: AVPixelFormat = 53;
#[doc = "< packed BGR 4:4:4, 16bpp, (msb)4X 4B 4G 4R(lsb), little-endian, X=unused/undefined"]
pub const AVPixelFormat_AV_PIX_FMT_BGR444LE: AVPixelFormat = 54;
#[doc = "< packed BGR 4:4:4, 16bpp, (msb)4X 4B 4G 4R(lsb), big-endian,    X=unused/undefined"]
pub const AVPixelFormat_AV_PIX_FMT_BGR444BE: AVPixelFormat = 55;
#[doc = "< 8 bits gray, 8 bits alpha"]
pub const AVPixelFormat_AV_PIX_FMT_YA8: AVPixelFormat = 56;
#[doc = "< alias for AV_PIX_FMT_YA8"]
pub const AVPixelFormat_AV_PIX_FMT_Y400A: AVPixelFormat = 56;
#[doc = "< alias for AV_PIX_FMT_YA8"]
pub const AVPixelFormat_AV_PIX_FMT_GRAY8A: AVPixelFormat = 56;
#[doc = "< packed RGB 16:16:16, 48bpp, 16B, 16G, 16R, the 2-byte value for each R/G/B component is stored as big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_BGR48BE: AVPixelFormat = 57;
#[doc = "< packed RGB 16:16:16, 48bpp, 16B, 16G, 16R, the 2-byte value for each R/G/B component is stored as little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_BGR48LE: AVPixelFormat = 58;
#[doc = "< planar YUV 4:2:0, 13.5bpp, (1 Cr & Cb sample per 2x2 Y samples), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV420P9BE: AVPixelFormat = 59;
#[doc = "< planar YUV 4:2:0, 13.5bpp, (1 Cr & Cb sample per 2x2 Y samples), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV420P9LE: AVPixelFormat = 60;
#[doc = "< planar YUV 4:2:0, 15bpp, (1 Cr & Cb sample per 2x2 Y samples), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV420P10BE: AVPixelFormat = 61;
#[doc = "< planar YUV 4:2:0, 15bpp, (1 Cr & Cb sample per 2x2 Y samples), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV420P10LE: AVPixelFormat = 62;
#[doc = "< planar YUV 4:2:2, 20bpp, (1 Cr & Cb sample per 2x1 Y samples), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV422P10BE: AVPixelFormat = 63;
#[doc = "< planar YUV 4:2:2, 20bpp, (1 Cr & Cb sample per 2x1 Y samples), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV422P10LE: AVPixelFormat = 64;
#[doc = "< planar YUV 4:4:4, 27bpp, (1 Cr & Cb sample per 1x1 Y samples), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV444P9BE: AVPixelFormat = 65;
#[doc = "< planar YUV 4:4:4, 27bpp, (1 Cr & Cb sample per 1x1 Y samples), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV444P9LE: AVPixelFormat = 66;
#[doc = "< planar YUV 4:4:4, 30bpp, (1 Cr & Cb sample per 1x1 Y samples), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV444P10BE: AVPixelFormat = 67;
#[doc = "< planar YUV 4:4:4, 30bpp, (1 Cr & Cb sample per 1x1 Y samples), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV444P10LE: AVPixelFormat = 68;
#[doc = "< planar YUV 4:2:2, 18bpp, (1 Cr & Cb sample per 2x1 Y samples), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV422P9BE: AVPixelFormat = 69;
#[doc = "< planar YUV 4:2:2, 18bpp, (1 Cr & Cb sample per 2x1 Y samples), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV422P9LE: AVPixelFormat = 70;
#[doc = "< planar GBR 4:4:4 24bpp"]
pub const AVPixelFormat_AV_PIX_FMT_GBRP: AVPixelFormat = 71;
pub const AVPixelFormat_AV_PIX_FMT_GBR24P: AVPixelFormat = 71;
#[doc = "< planar GBR 4:4:4 27bpp, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GBRP9BE: AVPixelFormat = 72;
#[doc = "< planar GBR 4:4:4 27bpp, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GBRP9LE: AVPixelFormat = 73;
#[doc = "< planar GBR 4:4:4 30bpp, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GBRP10BE: AVPixelFormat = 74;
#[doc = "< planar GBR 4:4:4 30bpp, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GBRP10LE: AVPixelFormat = 75;
#[doc = "< planar GBR 4:4:4 48bpp, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GBRP16BE: AVPixelFormat = 76;
#[doc = "< planar GBR 4:4:4 48bpp, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GBRP16LE: AVPixelFormat = 77;
#[doc = "< planar YUV 4:2:2 24bpp, (1 Cr & Cb sample per 2x1 Y & A samples)"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA422P: AVPixelFormat = 78;
#[doc = "< planar YUV 4:4:4 32bpp, (1 Cr & Cb sample per 1x1 Y & A samples)"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA444P: AVPixelFormat = 79;
#[doc = "< planar YUV 4:2:0 22.5bpp, (1 Cr & Cb sample per 2x2 Y & A samples), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA420P9BE: AVPixelFormat = 80;
#[doc = "< planar YUV 4:2:0 22.5bpp, (1 Cr & Cb sample per 2x2 Y & A samples), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA420P9LE: AVPixelFormat = 81;
#[doc = "< planar YUV 4:2:2 27bpp, (1 Cr & Cb sample per 2x1 Y & A samples), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA422P9BE: AVPixelFormat = 82;
#[doc = "< planar YUV 4:2:2 27bpp, (1 Cr & Cb sample per 2x1 Y & A samples), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA422P9LE: AVPixelFormat = 83;
#[doc = "< planar YUV 4:4:4 36bpp, (1 Cr & Cb sample per 1x1 Y & A samples), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA444P9BE: AVPixelFormat = 84;
#[doc = "< planar YUV 4:4:4 36bpp, (1 Cr & Cb sample per 1x1 Y & A samples), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA444P9LE: AVPixelFormat = 85;
#[doc = "< planar YUV 4:2:0 25bpp, (1 Cr & Cb sample per 2x2 Y & A samples, big-endian)"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA420P10BE: AVPixelFormat = 86;
#[doc = "< planar YUV 4:2:0 25bpp, (1 Cr & Cb sample per 2x2 Y & A samples, little-endian)"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA420P10LE: AVPixelFormat = 87;
#[doc = "< planar YUV 4:2:2 30bpp, (1 Cr & Cb sample per 2x1 Y & A samples, big-endian)"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA422P10BE: AVPixelFormat = 88;
#[doc = "< planar YUV 4:2:2 30bpp, (1 Cr & Cb sample per 2x1 Y & A samples, little-endian)"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA422P10LE: AVPixelFormat = 89;
#[doc = "< planar YUV 4:4:4 40bpp, (1 Cr & Cb sample per 1x1 Y & A samples, big-endian)"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA444P10BE: AVPixelFormat = 90;
#[doc = "< planar YUV 4:4:4 40bpp, (1 Cr & Cb sample per 1x1 Y & A samples, little-endian)"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA444P10LE: AVPixelFormat = 91;
#[doc = "< planar YUV 4:2:0 40bpp, (1 Cr & Cb sample per 2x2 Y & A samples, big-endian)"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA420P16BE: AVPixelFormat = 92;
#[doc = "< planar YUV 4:2:0 40bpp, (1 Cr & Cb sample per 2x2 Y & A samples, little-endian)"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA420P16LE: AVPixelFormat = 93;
#[doc = "< planar YUV 4:2:2 48bpp, (1 Cr & Cb sample per 2x1 Y & A samples, big-endian)"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA422P16BE: AVPixelFormat = 94;
#[doc = "< planar YUV 4:2:2 48bpp, (1 Cr & Cb sample per 2x1 Y & A samples, little-endian)"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA422P16LE: AVPixelFormat = 95;
#[doc = "< planar YUV 4:4:4 64bpp, (1 Cr & Cb sample per 1x1 Y & A samples, big-endian)"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA444P16BE: AVPixelFormat = 96;
#[doc = "< planar YUV 4:4:4 64bpp, (1 Cr & Cb sample per 1x1 Y & A samples, little-endian)"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA444P16LE: AVPixelFormat = 97;
#[doc = "< HW acceleration through VDPAU, Picture.data[3] contains a VdpVideoSurface"]
pub const AVPixelFormat_AV_PIX_FMT_VDPAU: AVPixelFormat = 98;
#[doc = "< packed XYZ 4:4:4, 36 bpp, (msb) 12X, 12Y, 12Z (lsb), the 2-byte value for each X/Y/Z is stored as little-endian, the 4 lower bits are set to 0"]
pub const AVPixelFormat_AV_PIX_FMT_XYZ12LE: AVPixelFormat = 99;
#[doc = "< packed XYZ 4:4:4, 36 bpp, (msb) 12X, 12Y, 12Z (lsb), the 2-byte value for each X/Y/Z is stored as big-endian, the 4 lower bits are set to 0"]
pub const AVPixelFormat_AV_PIX_FMT_XYZ12BE: AVPixelFormat = 100;
#[doc = "< interleaved chroma YUV 4:2:2, 16bpp, (1 Cr & Cb sample per 2x1 Y samples)"]
pub const AVPixelFormat_AV_PIX_FMT_NV16: AVPixelFormat = 101;
#[doc = "< interleaved chroma YUV 4:2:2, 20bpp, (1 Cr & Cb sample per 2x1 Y samples), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_NV20LE: AVPixelFormat = 102;
#[doc = "< interleaved chroma YUV 4:2:2, 20bpp, (1 Cr & Cb sample per 2x1 Y samples), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_NV20BE: AVPixelFormat = 103;
#[doc = "< packed RGBA 16:16:16:16, 64bpp, 16R, 16G, 16B, 16A, the 2-byte value for each R/G/B/A component is stored as big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_RGBA64BE: AVPixelFormat = 104;
#[doc = "< packed RGBA 16:16:16:16, 64bpp, 16R, 16G, 16B, 16A, the 2-byte value for each R/G/B/A component is stored as little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_RGBA64LE: AVPixelFormat = 105;
#[doc = "< packed RGBA 16:16:16:16, 64bpp, 16B, 16G, 16R, 16A, the 2-byte value for each R/G/B/A component is stored as big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_BGRA64BE: AVPixelFormat = 106;
#[doc = "< packed RGBA 16:16:16:16, 64bpp, 16B, 16G, 16R, 16A, the 2-byte value for each R/G/B/A component is stored as little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_BGRA64LE: AVPixelFormat = 107;
#[doc = "< packed YUV 4:2:2, 16bpp, Y0 Cr Y1 Cb"]
pub const AVPixelFormat_AV_PIX_FMT_YVYU422: AVPixelFormat = 108;
#[doc = "< 16 bits gray, 16 bits alpha (big-endian)"]
pub const AVPixelFormat_AV_PIX_FMT_YA16BE: AVPixelFormat = 109;
#[doc = "< 16 bits gray, 16 bits alpha (little-endian)"]
pub const AVPixelFormat_AV_PIX_FMT_YA16LE: AVPixelFormat = 110;
#[doc = "< planar GBRA 4:4:4:4 32bpp"]
pub const AVPixelFormat_AV_PIX_FMT_GBRAP: AVPixelFormat = 111;
#[doc = "< planar GBRA 4:4:4:4 64bpp, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GBRAP16BE: AVPixelFormat = 112;
#[doc = "< planar GBRA 4:4:4:4 64bpp, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GBRAP16LE: AVPixelFormat = 113;
#[doc = "  HW acceleration through QSV, data[3] contains a pointer to the"]
#[doc = "  mfxFrameSurface1 structure."]
pub const AVPixelFormat_AV_PIX_FMT_QSV: AVPixelFormat = 114;
#[doc = " HW acceleration though MMAL, data[3] contains a pointer to the"]
#[doc = " MMAL_BUFFER_HEADER_T structure."]
pub const AVPixelFormat_AV_PIX_FMT_MMAL: AVPixelFormat = 115;
#[doc = "< HW decoding through Direct3D11 via old API, Picture.data[3] contains a ID3D11VideoDecoderOutputView pointer"]
pub const AVPixelFormat_AV_PIX_FMT_D3D11VA_VLD: AVPixelFormat = 116;
#[doc = " HW acceleration through CUDA. data[i] contain CUdeviceptr pointers"]
#[doc = " exactly as for system memory frames."]
pub const AVPixelFormat_AV_PIX_FMT_CUDA: AVPixelFormat = 117;
#[doc = "< packed RGB 8:8:8, 32bpp, XRGBXRGB...   X=unused/undefined"]
pub const AVPixelFormat_AV_PIX_FMT_0RGB: AVPixelFormat = 118;
#[doc = "< packed RGB 8:8:8, 32bpp, RGBXRGBX...   X=unused/undefined"]
pub const AVPixelFormat_AV_PIX_FMT_RGB0: AVPixelFormat = 119;
#[doc = "< packed BGR 8:8:8, 32bpp, XBGRXBGR...   X=unused/undefined"]
pub const AVPixelFormat_AV_PIX_FMT_0BGR: AVPixelFormat = 120;
#[doc = "< packed BGR 8:8:8, 32bpp, BGRXBGRX...   X=unused/undefined"]
pub const AVPixelFormat_AV_PIX_FMT_BGR0: AVPixelFormat = 121;
#[doc = "< planar YUV 4:2:0,18bpp, (1 Cr & Cb sample per 2x2 Y samples), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV420P12BE: AVPixelFormat = 122;
#[doc = "< planar YUV 4:2:0,18bpp, (1 Cr & Cb sample per 2x2 Y samples), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV420P12LE: AVPixelFormat = 123;
#[doc = "< planar YUV 4:2:0,21bpp, (1 Cr & Cb sample per 2x2 Y samples), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV420P14BE: AVPixelFormat = 124;
#[doc = "< planar YUV 4:2:0,21bpp, (1 Cr & Cb sample per 2x2 Y samples), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV420P14LE: AVPixelFormat = 125;
#[doc = "< planar YUV 4:2:2,24bpp, (1 Cr & Cb sample per 2x1 Y samples), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV422P12BE: AVPixelFormat = 126;
#[doc = "< planar YUV 4:2:2,24bpp, (1 Cr & Cb sample per 2x1 Y samples), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV422P12LE: AVPixelFormat = 127;
#[doc = "< planar YUV 4:2:2,28bpp, (1 Cr & Cb sample per 2x1 Y samples), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV422P14BE: AVPixelFormat = 128;
#[doc = "< planar YUV 4:2:2,28bpp, (1 Cr & Cb sample per 2x1 Y samples), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV422P14LE: AVPixelFormat = 129;
#[doc = "< planar YUV 4:4:4,36bpp, (1 Cr & Cb sample per 1x1 Y samples), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV444P12BE: AVPixelFormat = 130;
#[doc = "< planar YUV 4:4:4,36bpp, (1 Cr & Cb sample per 1x1 Y samples), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV444P12LE: AVPixelFormat = 131;
#[doc = "< planar YUV 4:4:4,42bpp, (1 Cr & Cb sample per 1x1 Y samples), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV444P14BE: AVPixelFormat = 132;
#[doc = "< planar YUV 4:4:4,42bpp, (1 Cr & Cb sample per 1x1 Y samples), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV444P14LE: AVPixelFormat = 133;
#[doc = "< planar GBR 4:4:4 36bpp, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GBRP12BE: AVPixelFormat = 134;
#[doc = "< planar GBR 4:4:4 36bpp, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GBRP12LE: AVPixelFormat = 135;
#[doc = "< planar GBR 4:4:4 42bpp, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GBRP14BE: AVPixelFormat = 136;
#[doc = "< planar GBR 4:4:4 42bpp, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GBRP14LE: AVPixelFormat = 137;
#[doc = "< planar YUV 4:1:1, 12bpp, (1 Cr & Cb sample per 4x1 Y samples) full scale (JPEG), deprecated in favor of AV_PIX_FMT_YUV411P and setting color_range"]
pub const AVPixelFormat_AV_PIX_FMT_YUVJ411P: AVPixelFormat = 138;
#[doc = "< bayer, BGBG..(odd line), GRGR..(even line), 8-bit samples"]
pub const AVPixelFormat_AV_PIX_FMT_BAYER_BGGR8: AVPixelFormat = 139;
#[doc = "< bayer, RGRG..(odd line), GBGB..(even line), 8-bit samples"]
pub const AVPixelFormat_AV_PIX_FMT_BAYER_RGGB8: AVPixelFormat = 140;
#[doc = "< bayer, GBGB..(odd line), RGRG..(even line), 8-bit samples"]
pub const AVPixelFormat_AV_PIX_FMT_BAYER_GBRG8: AVPixelFormat = 141;
#[doc = "< bayer, GRGR..(odd line), BGBG..(even line), 8-bit samples"]
pub const AVPixelFormat_AV_PIX_FMT_BAYER_GRBG8: AVPixelFormat = 142;
#[doc = "< bayer, BGBG..(odd line), GRGR..(even line), 16-bit samples, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_BAYER_BGGR16LE: AVPixelFormat = 143;
#[doc = "< bayer, BGBG..(odd line), GRGR..(even line), 16-bit samples, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_BAYER_BGGR16BE: AVPixelFormat = 144;
#[doc = "< bayer, RGRG..(odd line), GBGB..(even line), 16-bit samples, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_BAYER_RGGB16LE: AVPixelFormat = 145;
#[doc = "< bayer, RGRG..(odd line), GBGB..(even line), 16-bit samples, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_BAYER_RGGB16BE: AVPixelFormat = 146;
#[doc = "< bayer, GBGB..(odd line), RGRG..(even line), 16-bit samples, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_BAYER_GBRG16LE: AVPixelFormat = 147;
#[doc = "< bayer, GBGB..(odd line), RGRG..(even line), 16-bit samples, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_BAYER_GBRG16BE: AVPixelFormat = 148;
#[doc = "< bayer, GRGR..(odd line), BGBG..(even line), 16-bit samples, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_BAYER_GRBG16LE: AVPixelFormat = 149;
#[doc = "< bayer, GRGR..(odd line), BGBG..(even line), 16-bit samples, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_BAYER_GRBG16BE: AVPixelFormat = 150;
#[doc = "< XVideo Motion Acceleration via common packet passing"]
pub const AVPixelFormat_AV_PIX_FMT_XVMC: AVPixelFormat = 151;
#[doc = "< planar YUV 4:4:0,20bpp, (1 Cr & Cb sample per 1x2 Y samples), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV440P10LE: AVPixelFormat = 152;
#[doc = "< planar YUV 4:4:0,20bpp, (1 Cr & Cb sample per 1x2 Y samples), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV440P10BE: AVPixelFormat = 153;
#[doc = "< planar YUV 4:4:0,24bpp, (1 Cr & Cb sample per 1x2 Y samples), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV440P12LE: AVPixelFormat = 154;
#[doc = "< planar YUV 4:4:0,24bpp, (1 Cr & Cb sample per 1x2 Y samples), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUV440P12BE: AVPixelFormat = 155;
#[doc = "< packed AYUV 4:4:4,64bpp (1 Cr & Cb sample per 1x1 Y & A samples), little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_AYUV64LE: AVPixelFormat = 156;
#[doc = "< packed AYUV 4:4:4,64bpp (1 Cr & Cb sample per 1x1 Y & A samples), big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_AYUV64BE: AVPixelFormat = 157;
#[doc = "< hardware decoding through Videotoolbox"]
pub const AVPixelFormat_AV_PIX_FMT_VIDEOTOOLBOX: AVPixelFormat = 158;
#[doc = "< like NV12, with 10bpp per component, data in the high bits, zeros in the low bits, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_P010LE: AVPixelFormat = 159;
#[doc = "< like NV12, with 10bpp per component, data in the high bits, zeros in the low bits, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_P010BE: AVPixelFormat = 160;
#[doc = "< planar GBR 4:4:4:4 48bpp, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GBRAP12BE: AVPixelFormat = 161;
#[doc = "< planar GBR 4:4:4:4 48bpp, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GBRAP12LE: AVPixelFormat = 162;
#[doc = "< planar GBR 4:4:4:4 40bpp, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GBRAP10BE: AVPixelFormat = 163;
#[doc = "< planar GBR 4:4:4:4 40bpp, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GBRAP10LE: AVPixelFormat = 164;
#[doc = "< hardware decoding through MediaCodec"]
pub const AVPixelFormat_AV_PIX_FMT_MEDIACODEC: AVPixelFormat = 165;
#[doc = "<        Y        , 12bpp, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GRAY12BE: AVPixelFormat = 166;
#[doc = "<        Y        , 12bpp, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GRAY12LE: AVPixelFormat = 167;
#[doc = "<        Y        , 10bpp, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GRAY10BE: AVPixelFormat = 168;
#[doc = "<        Y        , 10bpp, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GRAY10LE: AVPixelFormat = 169;
#[doc = "< like NV12, with 16bpp per component, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_P016LE: AVPixelFormat = 170;
#[doc = "< like NV12, with 16bpp per component, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_P016BE: AVPixelFormat = 171;
#[doc = " Hardware surfaces for Direct3D11."]
#[doc = ""]
#[doc = " This is preferred over the legacy AV_PIX_FMT_D3D11VA_VLD. The new D3D11"]
#[doc = " hwaccel API and filtering support AV_PIX_FMT_D3D11 only."]
#[doc = ""]
#[doc = " data[0] contains a ID3D11Texture2D pointer, and data[1] contains the"]
#[doc = " texture array index of the frame as intptr_t if the ID3D11Texture2D is"]
#[doc = " an array texture (or always 0 if it's a normal texture)."]
pub const AVPixelFormat_AV_PIX_FMT_D3D11: AVPixelFormat = 172;
#[doc = "<        Y        , 9bpp, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GRAY9BE: AVPixelFormat = 173;
#[doc = "<        Y        , 9bpp, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GRAY9LE: AVPixelFormat = 174;
#[doc = "< IEEE-754 single precision planar GBR 4:4:4,     96bpp, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GBRPF32BE: AVPixelFormat = 175;
#[doc = "< IEEE-754 single precision planar GBR 4:4:4,     96bpp, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GBRPF32LE: AVPixelFormat = 176;
#[doc = "< IEEE-754 single precision planar GBRA 4:4:4:4, 128bpp, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GBRAPF32BE: AVPixelFormat = 177;
#[doc = "< IEEE-754 single precision planar GBRA 4:4:4:4, 128bpp, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GBRAPF32LE: AVPixelFormat = 178;
#[doc = " DRM-managed buffers exposed through PRIME buffer sharing."]
#[doc = ""]
#[doc = " data[0] points to an AVDRMFrameDescriptor."]
pub const AVPixelFormat_AV_PIX_FMT_DRM_PRIME: AVPixelFormat = 179;
#[doc = " Hardware surfaces for OpenCL."]
#[doc = ""]
#[doc = " data[i] contain 2D image objects (typed in C as cl_mem, used"]
#[doc = " in OpenCL as image2d_t) for each plane of the surface."]
pub const AVPixelFormat_AV_PIX_FMT_OPENCL: AVPixelFormat = 180;
#[doc = "<        Y        , 14bpp, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GRAY14BE: AVPixelFormat = 181;
#[doc = "<        Y        , 14bpp, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GRAY14LE: AVPixelFormat = 182;
#[doc = "< IEEE-754 single precision Y, 32bpp, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GRAYF32BE: AVPixelFormat = 183;
#[doc = "< IEEE-754 single precision Y, 32bpp, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_GRAYF32LE: AVPixelFormat = 184;
#[doc = "< planar YUV 4:2:2,24bpp, (1 Cr & Cb sample per 2x1 Y samples), 12b alpha, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA422P12BE: AVPixelFormat = 185;
#[doc = "< planar YUV 4:2:2,24bpp, (1 Cr & Cb sample per 2x1 Y samples), 12b alpha, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA422P12LE: AVPixelFormat = 186;
#[doc = "< planar YUV 4:4:4,36bpp, (1 Cr & Cb sample per 1x1 Y samples), 12b alpha, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA444P12BE: AVPixelFormat = 187;
#[doc = "< planar YUV 4:4:4,36bpp, (1 Cr & Cb sample per 1x1 Y samples), 12b alpha, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_YUVA444P12LE: AVPixelFormat = 188;
#[doc = "< planar YUV 4:4:4, 24bpp, 1 plane for Y and 1 plane for the UV components, which are interleaved (first byte U and the following byte V)"]
pub const AVPixelFormat_AV_PIX_FMT_NV24: AVPixelFormat = 189;
#[doc = "< as above, but U and V bytes are swapped"]
pub const AVPixelFormat_AV_PIX_FMT_NV42: AVPixelFormat = 190;
#[doc = " Vulkan hardware images."]
#[doc = ""]
#[doc = " data[0] points to an AVVkFrame"]
pub const AVPixelFormat_AV_PIX_FMT_VULKAN: AVPixelFormat = 191;
#[doc = "< packed YUV 4:2:2 like YUYV422, 20bpp, data in the high bits, big-endian"]
pub const AVPixelFormat_AV_PIX_FMT_Y210BE: AVPixelFormat = 192;
#[doc = "< packed YUV 4:2:2 like YUYV422, 20bpp, data in the high bits, little-endian"]
pub const AVPixelFormat_AV_PIX_FMT_Y210LE: AVPixelFormat = 193;
#[doc = "< packed RGB 10:10:10, 30bpp, (msb)2X 10R 10G 10B(lsb), little-endian, X=unused/undefined"]
pub const AVPixelFormat_AV_PIX_FMT_X2RGB10LE: AVPixelFormat = 194;
#[doc = "< packed RGB 10:10:10, 30bpp, (msb)2X 10R 10G 10B(lsb), big-endian, X=unused/undefined"]
pub const AVPixelFormat_AV_PIX_FMT_X2RGB10BE: AVPixelFormat = 195;
#[doc = "< number of pixel formats, DO NOT USE THIS if you want to link with shared libav* because the number of formats might differ between versions"]
pub const AVPixelFormat_AV_PIX_FMT_NB: AVPixelFormat = 196;
#[doc = " Pixel format."]
#[doc = ""]
#[doc = " @note"]
#[doc = " AV_PIX_FMT_RGB32 is handled in an endian-specific manner. An RGBA"]
#[doc = " color is put together as:"]
#[doc = "  (A << 24) | (R << 16) | (G << 8) | B"]
#[doc = " This is stored as BGRA on little-endian CPU architectures and ARGB on"]
#[doc = " big-endian CPUs."]
#[doc = ""]
#[doc = " @note"]
#[doc = " If the resolution is not a multiple of the chroma subsampling factor"]
#[doc = " then the chroma plane resolution must be rounded up."]
#[doc = ""]
#[doc = " @par"]
#[doc = " When the pixel format is palettized RGB32 (AV_PIX_FMT_PAL8), the palettized"]
#[doc = " image data is stored in AVFrame.data[0]. The palette is transported in"]
#[doc = " AVFrame.data[1], is 1024 bytes long (256 4-byte entries) and is"]
#[doc = " formatted the same as in AV_PIX_FMT_RGB32 described above (i.e., it is"]
#[doc = " also endian-specific). Note also that the individual RGB32 palette"]
#[doc = " components stored in AVFrame.data[1] should be in the range 0..255."]
#[doc = " This is important as many custom PAL8 video codecs that were designed"]
#[doc = " to run on the IBM VGA graphics adapter use 6-bit palette components."]
#[doc = ""]
#[doc = " @par"]
#[doc = " For all the 8 bits per pixel formats, an RGB32 palette is in data[1] like"]
#[doc = " for pal8. This palette is filled in automatically by the function"]
#[doc = " allocating the picture."]
pub type AVPixelFormat = ::std::os::raw::c_int;
pub const AVColorPrimaries_AVCOL_PRI_RESERVED0: AVColorPrimaries = 0;
#[doc = "< also ITU-R BT1361 / IEC 61966-2-4 / SMPTE RP177 Annex B"]
pub const AVColorPrimaries_AVCOL_PRI_BT709: AVColorPrimaries = 1;
pub const AVColorPrimaries_AVCOL_PRI_UNSPECIFIED: AVColorPrimaries = 2;
pub const AVColorPrimaries_AVCOL_PRI_RESERVED: AVColorPrimaries = 3;
#[doc = "< also FCC Title 47 Code of Federal Regulations 73.682 (a)(20)"]
pub const AVColorPrimaries_AVCOL_PRI_BT470M: AVColorPrimaries = 4;
#[doc = "< also ITU-R BT601-6 625 / ITU-R BT1358 625 / ITU-R BT1700 625 PAL & SECAM"]
pub const AVColorPrimaries_AVCOL_PRI_BT470BG: AVColorPrimaries = 5;
#[doc = "< also ITU-R BT601-6 525 / ITU-R BT1358 525 / ITU-R BT1700 NTSC"]
pub const AVColorPrimaries_AVCOL_PRI_SMPTE170M: AVColorPrimaries = 6;
#[doc = "< functionally identical to above"]
pub const AVColorPrimaries_AVCOL_PRI_SMPTE240M: AVColorPrimaries = 7;
#[doc = "< colour filters using Illuminant C"]
pub const AVColorPrimaries_AVCOL_PRI_FILM: AVColorPrimaries = 8;
#[doc = "< ITU-R BT2020"]
pub const AVColorPrimaries_AVCOL_PRI_BT2020: AVColorPrimaries = 9;
#[doc = "< SMPTE ST 428-1 (CIE 1931 XYZ)"]
pub const AVColorPrimaries_AVCOL_PRI_SMPTE428: AVColorPrimaries = 10;
pub const AVColorPrimaries_AVCOL_PRI_SMPTEST428_1: AVColorPrimaries = 10;
#[doc = "< SMPTE ST 431-2 (2011) / DCI P3"]
pub const AVColorPrimaries_AVCOL_PRI_SMPTE431: AVColorPrimaries = 11;
#[doc = "< SMPTE ST 432-1 (2010) / P3 D65 / Display P3"]
pub const AVColorPrimaries_AVCOL_PRI_SMPTE432: AVColorPrimaries = 12;
#[doc = "< EBU Tech. 3213-E / JEDEC P22 phosphors"]
pub const AVColorPrimaries_AVCOL_PRI_EBU3213: AVColorPrimaries = 22;
pub const AVColorPrimaries_AVCOL_PRI_JEDEC_P22: AVColorPrimaries = 22;
#[doc = "< Not part of ABI"]
pub const AVColorPrimaries_AVCOL_PRI_NB: AVColorPrimaries = 23;
#[doc = " Chromaticity coordinates of the source primaries."]
#[doc = " These values match the ones defined by ISO/IEC 23001-8_2013 § 7.1."]
pub type AVColorPrimaries = ::std::os::raw::c_uint;
pub const AVColorTransferCharacteristic_AVCOL_TRC_RESERVED0: AVColorTransferCharacteristic = 0;
#[doc = "< also ITU-R BT1361"]
pub const AVColorTransferCharacteristic_AVCOL_TRC_BT709: AVColorTransferCharacteristic = 1;
pub const AVColorTransferCharacteristic_AVCOL_TRC_UNSPECIFIED: AVColorTransferCharacteristic = 2;
pub const AVColorTransferCharacteristic_AVCOL_TRC_RESERVED: AVColorTransferCharacteristic = 3;
#[doc = "< also ITU-R BT470M / ITU-R BT1700 625 PAL & SECAM"]
pub const AVColorTransferCharacteristic_AVCOL_TRC_GAMMA22: AVColorTransferCharacteristic = 4;
#[doc = "< also ITU-R BT470BG"]
pub const AVColorTransferCharacteristic_AVCOL_TRC_GAMMA28: AVColorTransferCharacteristic = 5;
#[doc = "< also ITU-R BT601-6 525 or 625 / ITU-R BT1358 525 or 625 / ITU-R BT1700 NTSC"]
pub const AVColorTransferCharacteristic_AVCOL_TRC_SMPTE170M: AVColorTransferCharacteristic = 6;
pub const AVColorTransferCharacteristic_AVCOL_TRC_SMPTE240M: AVColorTransferCharacteristic = 7;
#[doc = "< \"Linear transfer characteristics\""]
pub const AVColorTransferCharacteristic_AVCOL_TRC_LINEAR: AVColorTransferCharacteristic = 8;
#[doc = "< \"Logarithmic transfer characteristic (100:1 range)\""]
pub const AVColorTransferCharacteristic_AVCOL_TRC_LOG: AVColorTransferCharacteristic = 9;
#[doc = "< \"Logarithmic transfer characteristic (100 * Sqrt(10) : 1 range)\""]
pub const AVColorTransferCharacteristic_AVCOL_TRC_LOG_SQRT: AVColorTransferCharacteristic = 10;
#[doc = "< IEC 61966-2-4"]
pub const AVColorTransferCharacteristic_AVCOL_TRC_IEC61966_2_4: AVColorTransferCharacteristic = 11;
#[doc = "< ITU-R BT1361 Extended Colour Gamut"]
pub const AVColorTransferCharacteristic_AVCOL_TRC_BT1361_ECG: AVColorTransferCharacteristic = 12;
#[doc = "< IEC 61966-2-1 (sRGB or sYCC)"]
pub const AVColorTransferCharacteristic_AVCOL_TRC_IEC61966_2_1: AVColorTransferCharacteristic = 13;
#[doc = "< ITU-R BT2020 for 10-bit system"]
pub const AVColorTransferCharacteristic_AVCOL_TRC_BT2020_10: AVColorTransferCharacteristic = 14;
#[doc = "< ITU-R BT2020 for 12-bit system"]
pub const AVColorTransferCharacteristic_AVCOL_TRC_BT2020_12: AVColorTransferCharacteristic = 15;
#[doc = "< SMPTE ST 2084 for 10-, 12-, 14- and 16-bit systems"]
pub const AVColorTransferCharacteristic_AVCOL_TRC_SMPTE2084: AVColorTransferCharacteristic = 16;
pub const AVColorTransferCharacteristic_AVCOL_TRC_SMPTEST2084: AVColorTransferCharacteristic = 16;
#[doc = "< SMPTE ST 428-1"]
pub const AVColorTransferCharacteristic_AVCOL_TRC_SMPTE428: AVColorTransferCharacteristic = 17;
pub const AVColorTransferCharacteristic_AVCOL_TRC_SMPTEST428_1: AVColorTransferCharacteristic = 17;
#[doc = "< ARIB STD-B67, known as \"Hybrid log-gamma\""]
pub const AVColorTransferCharacteristic_AVCOL_TRC_ARIB_STD_B67: AVColorTransferCharacteristic = 18;
#[doc = "< Not part of ABI"]
pub const AVColorTransferCharacteristic_AVCOL_TRC_NB: AVColorTransferCharacteristic = 19;
#[doc = " Color Transfer Characteristic."]
#[doc = " These values match the ones defined by ISO/IEC 23001-8_2013 § 7.2."]
pub type AVColorTransferCharacteristic = ::std::os::raw::c_uint;
#[doc = "< order of coefficients is actually GBR, also IEC 61966-2-1 (sRGB)"]
pub const AVColorSpace_AVCOL_SPC_RGB: AVColorSpace = 0;
#[doc = "< also ITU-R BT1361 / IEC 61966-2-4 xvYCC709 / SMPTE RP177 Annex B"]
pub const AVColorSpace_AVCOL_SPC_BT709: AVColorSpace = 1;
pub const AVColorSpace_AVCOL_SPC_UNSPECIFIED: AVColorSpace = 2;
pub const AVColorSpace_AVCOL_SPC_RESERVED: AVColorSpace = 3;
#[doc = "< FCC Title 47 Code of Federal Regulations 73.682 (a)(20)"]
pub const AVColorSpace_AVCOL_SPC_FCC: AVColorSpace = 4;
#[doc = "< also ITU-R BT601-6 625 / ITU-R BT1358 625 / ITU-R BT1700 625 PAL & SECAM / IEC 61966-2-4 xvYCC601"]
pub const AVColorSpace_AVCOL_SPC_BT470BG: AVColorSpace = 5;
#[doc = "< also ITU-R BT601-6 525 / ITU-R BT1358 525 / ITU-R BT1700 NTSC"]
pub const AVColorSpace_AVCOL_SPC_SMPTE170M: AVColorSpace = 6;
#[doc = "< functionally identical to above"]
pub const AVColorSpace_AVCOL_SPC_SMPTE240M: AVColorSpace = 7;
#[doc = "< Used by Dirac / VC-2 and H.264 FRext, see ITU-T SG16"]
pub const AVColorSpace_AVCOL_SPC_YCGCO: AVColorSpace = 8;
pub const AVColorSpace_AVCOL_SPC_YCOCG: AVColorSpace = 8;
#[doc = "< ITU-R BT2020 non-constant luminance system"]
pub const AVColorSpace_AVCOL_SPC_BT2020_NCL: AVColorSpace = 9;
#[doc = "< ITU-R BT2020 constant luminance system"]
pub const AVColorSpace_AVCOL_SPC_BT2020_CL: AVColorSpace = 10;
#[doc = "< SMPTE 2085, Y'D'zD'x"]
pub const AVColorSpace_AVCOL_SPC_SMPTE2085: AVColorSpace = 11;
#[doc = "< Chromaticity-derived non-constant luminance system"]
pub const AVColorSpace_AVCOL_SPC_CHROMA_DERIVED_NCL: AVColorSpace = 12;
#[doc = "< Chromaticity-derived constant luminance system"]
pub const AVColorSpace_AVCOL_SPC_CHROMA_DERIVED_CL: AVColorSpace = 13;
#[doc = "< ITU-R BT.2100-0, ICtCp"]
pub const AVColorSpace_AVCOL_SPC_ICTCP: AVColorSpace = 14;
#[doc = "< Not part of ABI"]
pub const AVColorSpace_AVCOL_SPC_NB: AVColorSpace = 15;
#[doc = " YUV colorspace type."]
#[doc = " These values match the ones defined by ISO/IEC 23001-8_2013 § 7.3."]
pub type AVColorSpace = ::std::os::raw::c_uint;
pub const AVColorRange_AVCOL_RANGE_UNSPECIFIED: AVColorRange = 0;
#[doc = " Narrow or limited range content."]
#[doc = ""]
#[doc = " - For luminance planes:"]
#[doc = ""]
#[doc = "       (219 * E + 16) * 2^(n-8)"]
#[doc = ""]
#[doc = "   F.ex. the range of 16-235 for 8 bits"]
#[doc = ""]
#[doc = " - For chrominance planes:"]
#[doc = ""]
#[doc = "       (224 * E + 128) * 2^(n-8)"]
#[doc = ""]
#[doc = "   F.ex. the range of 16-240 for 8 bits"]
pub const AVColorRange_AVCOL_RANGE_MPEG: AVColorRange = 1;
#[doc = " Full range content."]
#[doc = ""]
#[doc = " - For RGB and luminance planes:"]
#[doc = ""]
#[doc = "       (2^n - 1) * E"]
#[doc = ""]
#[doc = "   F.ex. the range of 0-255 for 8 bits"]
#[doc = ""]
#[doc = " - For chrominance planes:"]
#[doc = ""]
#[doc = "       (2^n - 1) * E + 2^(n - 1)"]
#[doc = ""]
#[doc = "   F.ex. the range of 1-255 for 8 bits"]
pub const AVColorRange_AVCOL_RANGE_JPEG: AVColorRange = 2;
#[doc = "< Not part of ABI"]
pub const AVColorRange_AVCOL_RANGE_NB: AVColorRange = 3;
#[doc = " Visual content value range."]
#[doc = ""]
#[doc = " These values are based on definitions that can be found in multiple"]
#[doc = " specifications, such as ITU-T BT.709 (3.4 - Quantization of RGB, luminance"]
#[doc = " and colour-difference signals), ITU-T BT.2020 (Table 5 - Digital"]
#[doc = " Representation) as well as ITU-T BT.2100 (Table 9 - Digital 10- and 12-bit"]
#[doc = " integer representation). At the time of writing, the BT.2100 one is"]
#[doc = " recommended, as it also defines the full range representation."]
#[doc = ""]
#[doc = " Common definitions:"]
#[doc = "   - For RGB and luminance planes such as Y in YCbCr and I in ICtCp,"]
#[doc = "     'E' is the original value in range of 0.0 to 1.0."]
#[doc = "   - For chrominance planes such as Cb,Cr and Ct,Cp, 'E' is the original"]
#[doc = "     value in range of -0.5 to 0.5."]
#[doc = "   - 'n' is the output bit depth."]
#[doc = "   - For additional definitions such as rounding and clipping to valid n"]
#[doc = "     bit unsigned integer range, please refer to BT.2100 (Table 9)."]
pub type AVColorRange = ::std::os::raw::c_uint;
pub const AVChromaLocation_AVCHROMA_LOC_UNSPECIFIED: AVChromaLocation = 0;
#[doc = "< MPEG-2/4 4:2:0, H.264 default for 4:2:0"]
pub const AVChromaLocation_AVCHROMA_LOC_LEFT: AVChromaLocation = 1;
#[doc = "< MPEG-1 4:2:0, JPEG 4:2:0, H.263 4:2:0"]
pub const AVChromaLocation_AVCHROMA_LOC_CENTER: AVChromaLocation = 2;
#[doc = "< ITU-R 601, SMPTE 274M 296M S314M(DV 4:1:1), mpeg2 4:2:2"]
pub const AVChromaLocation_AVCHROMA_LOC_TOPLEFT: AVChromaLocation = 3;
pub const AVChromaLocation_AVCHROMA_LOC_TOP: AVChromaLocation = 4;
pub const AVChromaLocation_AVCHROMA_LOC_BOTTOMLEFT: AVChromaLocation = 5;
pub const AVChromaLocation_AVCHROMA_LOC_BOTTOM: AVChromaLocation = 6;
#[doc = "< Not part of ABI"]
pub const AVChromaLocation_AVCHROMA_LOC_NB: AVChromaLocation = 7;
#[doc = " Location of chroma samples."]
#[doc = ""]
#[doc = " Illustration showing the location of the first (top left) chroma sample of the"]
#[doc = " image, the left shows only luma, the right"]
#[doc = " shows the location of the chroma sample, the 2 could be imagined to overlay"]
#[doc = " each other but are drawn separately due to limitations of ASCII"]
#[doc = ""]
#[doc = "                1st 2nd       1st 2nd horizontal luma sample positions"]
#[doc = "                 v   v         v   v"]
#[doc = "                 ______        ______"]
#[doc = "1st luma line > |X   X ...    |3 4 X ...     X are luma samples,"]
#[doc = "                |             |1 2           1-6 are possible chroma positions"]
#[doc = "2nd luma line > |X   X ...    |5 6 X ...     0 is undefined/unknown position"]
pub type AVChromaLocation = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Compute the length of an integer list."]
    #[doc = ""]
    #[doc = " @param elsize  size in bytes of each list element (only 1, 2, 4 or 8)"]
    #[doc = " @param term    list terminator (usually 0 or -1)"]
    #[doc = " @param list    pointer to the list"]
    #[doc = " @return  length of the list, in elements, not counting the terminator"]
    pub fn av_int_list_length_for_size(
        elsize: ::std::os::raw::c_uint,
        list: *const ::std::os::raw::c_void,
        term: u64,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Open a file using a UTF-8 filename."]
    #[doc = " The API of this function matches POSIX fopen(), errors are returned through"]
    #[doc = " errno."]
    pub fn av_fopen_utf8(
        path: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    #[doc = " Return the fractional representation of the internal time base."]
    pub fn av_get_time_base_q() -> AVRational;
}
extern "C" {
    #[doc = " Fill the provided buffer with a string containing a FourCC (four-character"]
    #[doc = " code) representation."]
    #[doc = ""]
    #[doc = " @param buf    a buffer with size in bytes of at least AV_FOURCC_MAX_STRING_SIZE"]
    #[doc = " @param fourcc the fourcc to represent"]
    #[doc = " @return the buffer in input"]
    pub fn av_fourcc_make_string(
        buf: *mut ::std::os::raw::c_char,
        fourcc: u32,
    ) -> *mut ::std::os::raw::c_char;
}
pub const AVSampleFormat_AV_SAMPLE_FMT_NONE: AVSampleFormat = -1;
#[doc = "< unsigned 8 bits"]
pub const AVSampleFormat_AV_SAMPLE_FMT_U8: AVSampleFormat = 0;
#[doc = "< signed 16 bits"]
pub const AVSampleFormat_AV_SAMPLE_FMT_S16: AVSampleFormat = 1;
#[doc = "< signed 32 bits"]
pub const AVSampleFormat_AV_SAMPLE_FMT_S32: AVSampleFormat = 2;
#[doc = "< float"]
pub const AVSampleFormat_AV_SAMPLE_FMT_FLT: AVSampleFormat = 3;
#[doc = "< double"]
pub const AVSampleFormat_AV_SAMPLE_FMT_DBL: AVSampleFormat = 4;
#[doc = "< unsigned 8 bits, planar"]
pub const AVSampleFormat_AV_SAMPLE_FMT_U8P: AVSampleFormat = 5;
#[doc = "< signed 16 bits, planar"]
pub const AVSampleFormat_AV_SAMPLE_FMT_S16P: AVSampleFormat = 6;
#[doc = "< signed 32 bits, planar"]
pub const AVSampleFormat_AV_SAMPLE_FMT_S32P: AVSampleFormat = 7;
#[doc = "< float, planar"]
pub const AVSampleFormat_AV_SAMPLE_FMT_FLTP: AVSampleFormat = 8;
#[doc = "< double, planar"]
pub const AVSampleFormat_AV_SAMPLE_FMT_DBLP: AVSampleFormat = 9;
#[doc = "< signed 64 bits"]
pub const AVSampleFormat_AV_SAMPLE_FMT_S64: AVSampleFormat = 10;
#[doc = "< signed 64 bits, planar"]
pub const AVSampleFormat_AV_SAMPLE_FMT_S64P: AVSampleFormat = 11;
#[doc = "< Number of sample formats. DO NOT USE if linking dynamically"]
pub const AVSampleFormat_AV_SAMPLE_FMT_NB: AVSampleFormat = 12;
#[doc = " Audio sample formats"]
#[doc = ""]
#[doc = " - The data described by the sample format is always in native-endian order."]
#[doc = "   Sample values can be expressed by native C types, hence the lack of a signed"]
#[doc = "   24-bit sample format even though it is a common raw audio data format."]
#[doc = ""]
#[doc = " - The floating-point formats are based on full volume being in the range"]
#[doc = "   [-1.0, 1.0]. Any values outside this range are beyond full volume level."]
#[doc = ""]
#[doc = " - The data layout as used in av_samples_fill_arrays() and elsewhere in FFmpeg"]
#[doc = "   (such as AVFrame in libavcodec) is as follows:"]
#[doc = ""]
#[doc = " @par"]
#[doc = " For planar sample formats, each audio channel is in a separate data plane,"]
#[doc = " and linesize is the buffer size, in bytes, for a single plane. All data"]
#[doc = " planes must be the same size. For packed sample formats, only the first data"]
#[doc = " plane is used, and samples for each channel are interleaved. In this case,"]
#[doc = " linesize is the buffer size, in bytes, for the 1 plane."]
#[doc = ""]
pub type AVSampleFormat = ::std::os::raw::c_int;
extern "C" {
    #[doc = " Return the name of sample_fmt, or NULL if sample_fmt is not"]
    #[doc = " recognized."]
    pub fn av_get_sample_fmt_name(sample_fmt: AVSampleFormat) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Return a sample format corresponding to name, or AV_SAMPLE_FMT_NONE"]
    #[doc = " on error."]
    pub fn av_get_sample_fmt(name: *const ::std::os::raw::c_char) -> AVSampleFormat;
}
extern "C" {
    #[doc = " Return the planar<->packed alternative form of the given sample format, or"]
    #[doc = " AV_SAMPLE_FMT_NONE on error. If the passed sample_fmt is already in the"]
    #[doc = " requested planar/packed format, the format returned is the same as the"]
    #[doc = " input."]
    pub fn av_get_alt_sample_fmt(
        sample_fmt: AVSampleFormat,
        planar: ::std::os::raw::c_int,
    ) -> AVSampleFormat;
}
extern "C" {
    #[doc = " Get the packed alternative form of the given sample format."]
    #[doc = ""]
    #[doc = " If the passed sample_fmt is already in packed format, the format returned is"]
    #[doc = " the same as the input."]
    #[doc = ""]
    #[doc = " @return  the packed alternative form of the given sample format or"]
    #[doc = "AV_SAMPLE_FMT_NONE on error."]
    pub fn av_get_packed_sample_fmt(sample_fmt: AVSampleFormat) -> AVSampleFormat;
}
extern "C" {
    #[doc = " Get the planar alternative form of the given sample format."]
    #[doc = ""]
    #[doc = " If the passed sample_fmt is already in planar format, the format returned is"]
    #[doc = " the same as the input."]
    #[doc = ""]
    #[doc = " @return  the planar alternative form of the given sample format or"]
    #[doc = "AV_SAMPLE_FMT_NONE on error."]
    pub fn av_get_planar_sample_fmt(sample_fmt: AVSampleFormat) -> AVSampleFormat;
}
extern "C" {
    #[doc = " Generate a string corresponding to the sample format with"]
    #[doc = " sample_fmt, or a header if sample_fmt is negative."]
    #[doc = ""]
    #[doc = " @param buf the buffer where to write the string"]
    #[doc = " @param buf_size the size of buf"]
    #[doc = " @param sample_fmt the number of the sample format to print the"]
    #[doc = " corresponding info string, or a negative value to print the"]
    #[doc = " corresponding header."]
    #[doc = " @return the pointer to the filled buffer or NULL if sample_fmt is"]
    #[doc = " unknown or in case of other errors"]
    pub fn av_get_sample_fmt_string(
        buf: *mut ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_int,
        sample_fmt: AVSampleFormat,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Return number of bytes per sample."]
    #[doc = ""]
    #[doc = " @param sample_fmt the sample format"]
    #[doc = " @return number of bytes per sample or zero if unknown for the given"]
    #[doc = " sample format"]
    pub fn av_get_bytes_per_sample(sample_fmt: AVSampleFormat) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Check if the sample format is planar."]
    #[doc = ""]
    #[doc = " @param sample_fmt the sample format to inspect"]
    #[doc = " @return 1 if the sample format is planar, 0 if it is interleaved"]
    pub fn av_sample_fmt_is_planar(sample_fmt: AVSampleFormat) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get the required buffer size for the given audio parameters."]
    #[doc = ""]
    #[doc = " @param[out] linesize calculated linesize, may be NULL"]
    #[doc = " @param nb_channels   the number of channels"]
    #[doc = " @param nb_samples    the number of samples in a single channel"]
    #[doc = " @param sample_fmt    the sample format"]
    #[doc = " @param align         buffer size alignment (0 = default, 1 = no alignment)"]
    #[doc = " @return              required buffer size, or negative error code on failure"]
    pub fn av_samples_get_buffer_size(
        linesize: *mut ::std::os::raw::c_int,
        nb_channels: ::std::os::raw::c_int,
        nb_samples: ::std::os::raw::c_int,
        sample_fmt: AVSampleFormat,
        align: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Fill plane data pointers and linesize for samples with sample"]
    #[doc = " format sample_fmt."]
    #[doc = ""]
    #[doc = " The audio_data array is filled with the pointers to the samples data planes:"]
    #[doc = " for planar, set the start point of each channel's data within the buffer,"]
    #[doc = " for packed, set the start point of the entire buffer only."]
    #[doc = ""]
    #[doc = " The value pointed to by linesize is set to the aligned size of each"]
    #[doc = " channel's data buffer for planar layout, or to the aligned size of the"]
    #[doc = " buffer for all channels for packed layout."]
    #[doc = ""]
    #[doc = " The buffer in buf must be big enough to contain all the samples"]
    #[doc = " (use av_samples_get_buffer_size() to compute its minimum size),"]
    #[doc = " otherwise the audio_data pointers will point to invalid data."]
    #[doc = ""]
    #[doc = " @see enum AVSampleFormat"]
    #[doc = " The documentation for AVSampleFormat describes the data layout."]
    #[doc = ""]
    #[doc = " @param[out] audio_data  array to be filled with the pointer for each channel"]
    #[doc = " @param[out] linesize    calculated linesize, may be NULL"]
    #[doc = " @param buf              the pointer to a buffer containing the samples"]
    #[doc = " @param nb_channels      the number of channels"]
    #[doc = " @param nb_samples       the number of samples in a single channel"]
    #[doc = " @param sample_fmt       the sample format"]
    #[doc = " @param align            buffer size alignment (0 = default, 1 = no alignment)"]
    #[doc = " @return                 >=0 on success or a negative error code on failure"]
    #[doc = " @todo return minimum size in bytes required for the buffer in case"]
    #[doc = " of success at the next bump"]
    pub fn av_samples_fill_arrays(
        audio_data: *mut *mut u8,
        linesize: *mut ::std::os::raw::c_int,
        buf: *const u8,
        nb_channels: ::std::os::raw::c_int,
        nb_samples: ::std::os::raw::c_int,
        sample_fmt: AVSampleFormat,
        align: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Allocate a samples buffer for nb_samples samples, and fill data pointers and"]
    #[doc = " linesize accordingly."]
    #[doc = " The allocated samples buffer can be freed by using av_freep(&audio_data[0])"]
    #[doc = " Allocated data will be initialized to silence."]
    #[doc = ""]
    #[doc = " @see enum AVSampleFormat"]
    #[doc = " The documentation for AVSampleFormat describes the data layout."]
    #[doc = ""]
    #[doc = " @param[out] audio_data  array to be filled with the pointer for each channel"]
    #[doc = " @param[out] linesize    aligned size for audio buffer(s), may be NULL"]
    #[doc = " @param nb_channels      number of audio channels"]
    #[doc = " @param nb_samples       number of samples per channel"]
    #[doc = " @param align            buffer size alignment (0 = default, 1 = no alignment)"]
    #[doc = " @return                 >=0 on success or a negative error code on failure"]
    #[doc = " @todo return the size of the allocated buffer in case of success at the next bump"]
    #[doc = " @see av_samples_fill_arrays()"]
    #[doc = " @see av_samples_alloc_array_and_samples()"]
    pub fn av_samples_alloc(
        audio_data: *mut *mut u8,
        linesize: *mut ::std::os::raw::c_int,
        nb_channels: ::std::os::raw::c_int,
        nb_samples: ::std::os::raw::c_int,
        sample_fmt: AVSampleFormat,
        align: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Allocate a data pointers array, samples buffer for nb_samples"]
    #[doc = " samples, and fill data pointers and linesize accordingly."]
    #[doc = ""]
    #[doc = " This is the same as av_samples_alloc(), but also allocates the data"]
    #[doc = " pointers array."]
    #[doc = ""]
    #[doc = " @see av_samples_alloc()"]
    pub fn av_samples_alloc_array_and_samples(
        audio_data: *mut *mut *mut u8,
        linesize: *mut ::std::os::raw::c_int,
        nb_channels: ::std::os::raw::c_int,
        nb_samples: ::std::os::raw::c_int,
        sample_fmt: AVSampleFormat,
        align: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Copy samples from src to dst."]
    #[doc = ""]
    #[doc = " @param dst destination array of pointers to data planes"]
    #[doc = " @param src source array of pointers to data planes"]
    #[doc = " @param dst_offset offset in samples at which the data will be written to dst"]
    #[doc = " @param src_offset offset in samples at which the data will be read from src"]
    #[doc = " @param nb_samples number of samples to be copied"]
    #[doc = " @param nb_channels number of audio channels"]
    #[doc = " @param sample_fmt audio sample format"]
    pub fn av_samples_copy(
        dst: *mut *mut u8,
        src: *const *mut u8,
        dst_offset: ::std::os::raw::c_int,
        src_offset: ::std::os::raw::c_int,
        nb_samples: ::std::os::raw::c_int,
        nb_channels: ::std::os::raw::c_int,
        sample_fmt: AVSampleFormat,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Fill an audio buffer with silence."]
    #[doc = ""]
    #[doc = " @param audio_data  array of pointers to data planes"]
    #[doc = " @param offset      offset in samples at which to start filling"]
    #[doc = " @param nb_samples  number of samples to fill"]
    #[doc = " @param nb_channels number of audio channels"]
    #[doc = " @param sample_fmt  audio sample format"]
    pub fn av_samples_set_silence(
        audio_data: *mut *mut u8,
        offset: ::std::os::raw::c_int,
        nb_samples: ::std::os::raw::c_int,
        nb_channels: ::std::os::raw::c_int,
        sample_fmt: AVSampleFormat,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVBuffer {
    _unused: [u8; 0],
}
#[doc = " A reference to a data buffer."]
#[doc = ""]
#[doc = " The size of this struct is not a part of the public ABI and it is not meant"]
#[doc = " to be allocated directly."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVBufferRef {
    pub buffer: *mut AVBuffer,
    #[doc = " The data buffer. It is considered writable if and only if"]
    #[doc = " this is the only reference to the buffer, in which case"]
    #[doc = " av_buffer_is_writable() returns 1."]
    pub data: *mut u8,
    #[doc = " Size of data in bytes."]
    pub size: size_t,
}
#[test]
fn bindgen_test_layout_AVBufferRef() {
    assert_eq!(
        ::std::mem::size_of::<AVBufferRef>(),
        24usize,
        concat!("Size of: ", stringify!(AVBufferRef))
    );
    assert_eq!(
        ::std::mem::align_of::<AVBufferRef>(),
        8usize,
        concat!("Alignment of ", stringify!(AVBufferRef))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVBufferRef>())).buffer as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVBufferRef),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVBufferRef>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVBufferRef),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVBufferRef>())).size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVBufferRef),
            "::",
            stringify!(size)
        )
    );
}
extern "C" {
    #[doc = " Allocate an AVBuffer of the given size using av_malloc()."]
    #[doc = ""]
    #[doc = " @return an AVBufferRef of given size or NULL when out of memory"]
    pub fn av_buffer_alloc(size: size_t) -> *mut AVBufferRef;
}
extern "C" {
    #[doc = " Same as av_buffer_alloc(), except the returned buffer will be initialized"]
    #[doc = " to zero."]
    pub fn av_buffer_allocz(size: size_t) -> *mut AVBufferRef;
}
extern "C" {
    #[doc = " Create an AVBuffer from an existing array."]
    #[doc = ""]
    #[doc = " If this function is successful, data is owned by the AVBuffer. The caller may"]
    #[doc = " only access data through the returned AVBufferRef and references derived from"]
    #[doc = " it."]
    #[doc = " If this function fails, data is left untouched."]
    #[doc = " @param data   data array"]
    #[doc = " @param size   size of data in bytes"]
    #[doc = " @param free   a callback for freeing this buffer's data"]
    #[doc = " @param opaque parameter to be got for processing or passed to free"]
    #[doc = " @param flags  a combination of AV_BUFFER_FLAG_*"]
    #[doc = ""]
    #[doc = " @return an AVBufferRef referring to data on success, NULL on failure."]
    pub fn av_buffer_create(
        data: *mut u8,
        size: size_t,
        free: ::std::option::Option<
            unsafe extern "C" fn(opaque: *mut ::std::os::raw::c_void, data: *mut u8),
        >,
        opaque: *mut ::std::os::raw::c_void,
        flags: ::std::os::raw::c_int,
    ) -> *mut AVBufferRef;
}
extern "C" {
    #[doc = " Default free callback, which calls av_free() on the buffer data."]
    #[doc = " This function is meant to be passed to av_buffer_create(), not called"]
    #[doc = " directly."]
    pub fn av_buffer_default_free(opaque: *mut ::std::os::raw::c_void, data: *mut u8);
}
extern "C" {
    #[doc = " Create a new reference to an AVBuffer."]
    #[doc = ""]
    #[doc = " @return a new AVBufferRef referring to the same AVBuffer as buf or NULL on"]
    #[doc = " failure."]
    pub fn av_buffer_ref(buf: *mut AVBufferRef) -> *mut AVBufferRef;
}
extern "C" {
    #[doc = " Free a given reference and automatically free the buffer if there are no more"]
    #[doc = " references to it."]
    #[doc = ""]
    #[doc = " @param buf the reference to be freed. The pointer is set to NULL on return."]
    pub fn av_buffer_unref(buf: *mut *mut AVBufferRef);
}
extern "C" {
    #[doc = " @return 1 if the caller may write to the data referred to by buf (which is"]
    #[doc = " true if and only if buf is the only reference to the underlying AVBuffer)."]
    #[doc = " Return 0 otherwise."]
    #[doc = " A positive answer is valid until av_buffer_ref() is called on buf."]
    pub fn av_buffer_is_writable(buf: *const AVBufferRef) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @return the opaque parameter set by av_buffer_create."]
    pub fn av_buffer_get_opaque(buf: *const AVBufferRef) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn av_buffer_get_ref_count(buf: *const AVBufferRef) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Create a writable reference from a given buffer reference, avoiding data copy"]
    #[doc = " if possible."]
    #[doc = ""]
    #[doc = " @param buf buffer reference to make writable. On success, buf is either left"]
    #[doc = "            untouched, or it is unreferenced and a new writable AVBufferRef is"]
    #[doc = "            written in its place. On failure, buf is left untouched."]
    #[doc = " @return 0 on success, a negative AVERROR on failure."]
    pub fn av_buffer_make_writable(buf: *mut *mut AVBufferRef) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Reallocate a given buffer."]
    #[doc = ""]
    #[doc = " @param buf  a buffer reference to reallocate. On success, buf will be"]
    #[doc = "             unreferenced and a new reference with the required size will be"]
    #[doc = "             written in its place. On failure buf will be left untouched. *buf"]
    #[doc = "             may be NULL, then a new buffer is allocated."]
    #[doc = " @param size required new buffer size."]
    #[doc = " @return 0 on success, a negative AVERROR on failure."]
    #[doc = ""]
    #[doc = " @note the buffer is actually reallocated with av_realloc() only if it was"]
    #[doc = " initially allocated through av_buffer_realloc(NULL) and there is only one"]
    #[doc = " reference to it (i.e. the one passed to this function). In all other cases"]
    #[doc = " a new buffer is allocated and the data is copied."]
    pub fn av_buffer_realloc(buf: *mut *mut AVBufferRef, size: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Ensure dst refers to the same data as src."]
    #[doc = ""]
    #[doc = " When *dst is already equivalent to src, do nothing. Otherwise unreference dst"]
    #[doc = " and replace it with a new reference to src."]
    #[doc = ""]
    #[doc = " @param dst Pointer to either a valid buffer reference or NULL. On success,"]
    #[doc = "            this will point to a buffer reference equivalent to src. On"]
    #[doc = "            failure, dst will be left untouched."]
    #[doc = " @param src A buffer reference to replace dst with. May be NULL, then this"]
    #[doc = "            function is equivalent to av_buffer_unref(dst)."]
    #[doc = " @return 0 on success"]
    #[doc = "         AVERROR(ENOMEM) on memory allocation failure."]
    pub fn av_buffer_replace(
        dst: *mut *mut AVBufferRef,
        src: *mut AVBufferRef,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVBufferPool {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Allocate and initialize a buffer pool."]
    #[doc = ""]
    #[doc = " @param size size of each buffer in this pool"]
    #[doc = " @param alloc a function that will be used to allocate new buffers when the"]
    #[doc = " pool is empty. May be NULL, then the default allocator will be used"]
    #[doc = " (av_buffer_alloc())."]
    #[doc = " @return newly created buffer pool on success, NULL on error."]
    pub fn av_buffer_pool_init(
        size: size_t,
        alloc: ::std::option::Option<unsafe extern "C" fn(size: size_t) -> *mut AVBufferRef>,
    ) -> *mut AVBufferPool;
}
extern "C" {
    #[doc = " Allocate and initialize a buffer pool with a more complex allocator."]
    #[doc = ""]
    #[doc = " @param size size of each buffer in this pool"]
    #[doc = " @param opaque arbitrary user data used by the allocator"]
    #[doc = " @param alloc a function that will be used to allocate new buffers when the"]
    #[doc = "              pool is empty. May be NULL, then the default allocator will be"]
    #[doc = "              used (av_buffer_alloc())."]
    #[doc = " @param pool_free a function that will be called immediately before the pool"]
    #[doc = "                  is freed. I.e. after av_buffer_pool_uninit() is called"]
    #[doc = "                  by the caller and all the frames are returned to the pool"]
    #[doc = "                  and freed. It is intended to uninitialize the user opaque"]
    #[doc = "                  data. May be NULL."]
    #[doc = " @return newly created buffer pool on success, NULL on error."]
    pub fn av_buffer_pool_init2(
        size: size_t,
        opaque: *mut ::std::os::raw::c_void,
        alloc: ::std::option::Option<
            unsafe extern "C" fn(
                opaque: *mut ::std::os::raw::c_void,
                size: size_t,
            ) -> *mut AVBufferRef,
        >,
        pool_free: ::std::option::Option<unsafe extern "C" fn(opaque: *mut ::std::os::raw::c_void)>,
    ) -> *mut AVBufferPool;
}
extern "C" {
    #[doc = " Mark the pool as being available for freeing. It will actually be freed only"]
    #[doc = " once all the allocated buffers associated with the pool are released. Thus it"]
    #[doc = " is safe to call this function while some of the allocated buffers are still"]
    #[doc = " in use."]
    #[doc = ""]
    #[doc = " @param pool pointer to the pool to be freed. It will be set to NULL."]
    pub fn av_buffer_pool_uninit(pool: *mut *mut AVBufferPool);
}
extern "C" {
    #[doc = " Allocate a new AVBuffer, reusing an old buffer from the pool when available."]
    #[doc = " This function may be called simultaneously from multiple threads."]
    #[doc = ""]
    #[doc = " @return a reference to the new buffer on success, NULL on error."]
    pub fn av_buffer_pool_get(pool: *mut AVBufferPool) -> *mut AVBufferRef;
}
extern "C" {
    #[doc = " Query the original opaque parameter of an allocated buffer in the pool."]
    #[doc = ""]
    #[doc = " @param ref a buffer reference to a buffer returned by av_buffer_pool_get."]
    #[doc = " @return the opaque parameter set by the buffer allocator function of the"]
    #[doc = "         buffer pool."]
    #[doc = ""]
    #[doc = " @note the opaque parameter of ref is used by the buffer pool implementation,"]
    #[doc = " therefore you have to use this function to access the original opaque"]
    #[doc = " parameter of an allocated buffer."]
    pub fn av_buffer_pool_buffer_get_opaque(ref_: *mut AVBufferRef) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Return the flags which specify extensions supported by the CPU."]
    #[doc = " The returned value is affected by av_force_cpu_flags() if that was used"]
    #[doc = " before. So av_get_cpu_flags() can easily be used in an application to"]
    #[doc = " detect the enabled cpu flags."]
    pub fn av_get_cpu_flags() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Disables cpu detection and forces the specified flags."]
    #[doc = " -1 is a special case that disables forcing of specific flags."]
    pub fn av_force_cpu_flags(flags: ::std::os::raw::c_int);
}
extern "C" {
    #[doc = " Parse CPU caps from a string and update the given AV_CPU_* flags based on that."]
    #[doc = ""]
    #[doc = " @return negative on error."]
    pub fn av_parse_cpu_caps(
        flags: *mut ::std::os::raw::c_uint,
        s: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @return the number of logical CPU cores present."]
    pub fn av_cpu_count() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get the maximum data alignment that may be required by FFmpeg."]
    #[doc = ""]
    #[doc = " Note that this is affected by the build configuration and the CPU flags mask,"]
    #[doc = " so e.g. if the CPU supports AVX, but libavutil has been built with"]
    #[doc = " --disable-avx or the AV_CPU_FLAG_AVX flag has been disabled through"]
    #[doc = "  av_set_cpu_flags_mask(), then this function will behave as if AVX is not"]
    #[doc = "  present."]
    pub fn av_cpu_max_align() -> size_t;
}
pub const AVMatrixEncoding_AV_MATRIX_ENCODING_NONE: AVMatrixEncoding = 0;
pub const AVMatrixEncoding_AV_MATRIX_ENCODING_DOLBY: AVMatrixEncoding = 1;
pub const AVMatrixEncoding_AV_MATRIX_ENCODING_DPLII: AVMatrixEncoding = 2;
pub const AVMatrixEncoding_AV_MATRIX_ENCODING_DPLIIX: AVMatrixEncoding = 3;
pub const AVMatrixEncoding_AV_MATRIX_ENCODING_DPLIIZ: AVMatrixEncoding = 4;
pub const AVMatrixEncoding_AV_MATRIX_ENCODING_DOLBYEX: AVMatrixEncoding = 5;
pub const AVMatrixEncoding_AV_MATRIX_ENCODING_DOLBYHEADPHONE: AVMatrixEncoding = 6;
pub const AVMatrixEncoding_AV_MATRIX_ENCODING_NB: AVMatrixEncoding = 7;
pub type AVMatrixEncoding = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Return a channel layout id that matches name, or 0 if no match is found."]
    #[doc = ""]
    #[doc = " name can be one or several of the following notations,"]
    #[doc = " separated by '+' or '|':"]
    #[doc = " - the name of an usual channel layout (mono, stereo, 4.0, quad, 5.0,"]
    #[doc = "   5.0(side), 5.1, 5.1(side), 7.1, 7.1(wide), downmix);"]
    #[doc = " - the name of a single channel (FL, FR, FC, LFE, BL, BR, FLC, FRC, BC,"]
    #[doc = "   SL, SR, TC, TFL, TFC, TFR, TBL, TBC, TBR, DL, DR);"]
    #[doc = " - a number of channels, in decimal, followed by 'c', yielding"]
    #[doc = "   the default channel layout for that number of channels (@see"]
    #[doc = "   av_get_default_channel_layout);"]
    #[doc = " - a channel layout mask, in hexadecimal starting with \"0x\" (see the"]
    #[doc = "   AV_CH_* macros)."]
    #[doc = ""]
    #[doc = " Example: \"stereo+FC\" = \"2c+FC\" = \"2c+1c\" = \"0x7\""]
    pub fn av_get_channel_layout(name: *const ::std::os::raw::c_char) -> u64;
}
extern "C" {
    #[doc = " Return a channel layout and the number of channels based on the specified name."]
    #[doc = ""]
    #[doc = " This function is similar to (@see av_get_channel_layout), but can also parse"]
    #[doc = " unknown channel layout specifications."]
    #[doc = ""]
    #[doc = " @param[in]  name             channel layout specification string"]
    #[doc = " @param[out] channel_layout   parsed channel layout (0 if unknown)"]
    #[doc = " @param[out] nb_channels      number of channels"]
    #[doc = ""]
    #[doc = " @return 0 on success, AVERROR(EINVAL) if the parsing fails."]
    pub fn av_get_extended_channel_layout(
        name: *const ::std::os::raw::c_char,
        channel_layout: *mut u64,
        nb_channels: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Return a description of a channel layout."]
    #[doc = " If nb_channels is <= 0, it is guessed from the channel_layout."]
    #[doc = ""]
    #[doc = " @param buf put here the string containing the channel layout"]
    #[doc = " @param buf_size size in bytes of the buffer"]
    pub fn av_get_channel_layout_string(
        buf: *mut ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_int,
        nb_channels: ::std::os::raw::c_int,
        channel_layout: u64,
    );
}
extern "C" {
    #[doc = " Append a description of a channel layout to a bprint buffer."]
    pub fn av_bprint_channel_layout(
        bp: *mut AVBPrint,
        nb_channels: ::std::os::raw::c_int,
        channel_layout: u64,
    );
}
extern "C" {
    #[doc = " Return the number of channels in the channel layout."]
    pub fn av_get_channel_layout_nb_channels(channel_layout: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Return default channel layout for a given number of channels."]
    pub fn av_get_default_channel_layout(nb_channels: ::std::os::raw::c_int) -> i64;
}
extern "C" {
    #[doc = " Get the index of a channel in channel_layout."]
    #[doc = ""]
    #[doc = " @param channel a channel layout describing exactly one channel which must be"]
    #[doc = "                present in channel_layout."]
    #[doc = ""]
    #[doc = " @return index of channel in channel_layout on success, a negative AVERROR"]
    #[doc = "         on error."]
    pub fn av_get_channel_layout_channel_index(
        channel_layout: u64,
        channel: u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get the channel with the given index in channel_layout."]
    pub fn av_channel_layout_extract_channel(
        channel_layout: u64,
        index: ::std::os::raw::c_int,
    ) -> u64;
}
extern "C" {
    #[doc = " Get the name of a given channel."]
    #[doc = ""]
    #[doc = " @return channel name on success, NULL on error."]
    pub fn av_get_channel_name(channel: u64) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get the description of a given channel."]
    #[doc = ""]
    #[doc = " @param channel  a channel layout with a single channel"]
    #[doc = " @return  channel description on success, NULL on error"]
    pub fn av_get_channel_description(channel: u64) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get the value and name of a standard channel layout."]
    #[doc = ""]
    #[doc = " @param[in]  index   index in an internal list, starting at 0"]
    #[doc = " @param[out] layout  channel layout mask"]
    #[doc = " @param[out] name    name of the layout"]
    #[doc = " @return  0  if the layout exists,"]
    #[doc = "          <0 if index is beyond the limits"]
    pub fn av_get_standard_channel_layout(
        index: ::std::os::raw::c_uint,
        layout: *mut u64,
        name: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVDictionaryEntry {
    pub key: *mut ::std::os::raw::c_char,
    pub value: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_AVDictionaryEntry() {
    assert_eq!(
        ::std::mem::size_of::<AVDictionaryEntry>(),
        16usize,
        concat!("Size of: ", stringify!(AVDictionaryEntry))
    );
    assert_eq!(
        ::std::mem::align_of::<AVDictionaryEntry>(),
        8usize,
        concat!("Alignment of ", stringify!(AVDictionaryEntry))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVDictionaryEntry>())).key as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVDictionaryEntry),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVDictionaryEntry>())).value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVDictionaryEntry),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVDictionary {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Get a dictionary entry with matching key."]
    #[doc = ""]
    #[doc = " The returned entry key or value must not be changed, or it will"]
    #[doc = " cause undefined behavior."]
    #[doc = ""]
    #[doc = " To iterate through all the dictionary entries, you can set the matching key"]
    #[doc = " to the null string \"\" and set the AV_DICT_IGNORE_SUFFIX flag."]
    #[doc = ""]
    #[doc = " @param prev Set to the previous matching element to find the next."]
    #[doc = "             If set to NULL the first matching element is returned."]
    #[doc = " @param key matching key"]
    #[doc = " @param flags a collection of AV_DICT_* flags controlling how the entry is retrieved"]
    #[doc = " @return found entry or NULL in case no matching entry was found in the dictionary"]
    pub fn av_dict_get(
        m: *const AVDictionary,
        key: *const ::std::os::raw::c_char,
        prev: *const AVDictionaryEntry,
        flags: ::std::os::raw::c_int,
    ) -> *mut AVDictionaryEntry;
}
extern "C" {
    #[doc = " Get number of entries in dictionary."]
    #[doc = ""]
    #[doc = " @param m dictionary"]
    #[doc = " @return  number of entries in dictionary"]
    pub fn av_dict_count(m: *const AVDictionary) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Set the given entry in *pm, overwriting an existing entry."]
    #[doc = ""]
    #[doc = " Note: If AV_DICT_DONT_STRDUP_KEY or AV_DICT_DONT_STRDUP_VAL is set,"]
    #[doc = " these arguments will be freed on error."]
    #[doc = ""]
    #[doc = " Warning: Adding a new entry to a dictionary invalidates all existing entries"]
    #[doc = " previously returned with av_dict_get."]
    #[doc = ""]
    #[doc = " @param pm pointer to a pointer to a dictionary struct. If *pm is NULL"]
    #[doc = " a dictionary struct is allocated and put in *pm."]
    #[doc = " @param key entry key to add to *pm (will either be av_strduped or added as a new key depending on flags)"]
    #[doc = " @param value entry value to add to *pm (will be av_strduped or added as a new key depending on flags)."]
    #[doc = "        Passing a NULL value will cause an existing entry to be deleted."]
    #[doc = " @return >= 0 on success otherwise an error code <0"]
    pub fn av_dict_set(
        pm: *mut *mut AVDictionary,
        key: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Convenience wrapper for av_dict_set that converts the value to a string"]
    #[doc = " and stores it."]
    #[doc = ""]
    #[doc = " Note: If AV_DICT_DONT_STRDUP_KEY is set, key will be freed on error."]
    pub fn av_dict_set_int(
        pm: *mut *mut AVDictionary,
        key: *const ::std::os::raw::c_char,
        value: i64,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Parse the key/value pairs list and add the parsed entries to a dictionary."]
    #[doc = ""]
    #[doc = " In case of failure, all the successfully set entries are stored in"]
    #[doc = " *pm. You may need to manually free the created dictionary."]
    #[doc = ""]
    #[doc = " @param key_val_sep  a 0-terminated list of characters used to separate"]
    #[doc = "                     key from value"]
    #[doc = " @param pairs_sep    a 0-terminated list of characters used to separate"]
    #[doc = "                     two pairs from each other"]
    #[doc = " @param flags        flags to use when adding to dictionary."]
    #[doc = "                     AV_DICT_DONT_STRDUP_KEY and AV_DICT_DONT_STRDUP_VAL"]
    #[doc = "                     are ignored since the key/value tokens will always"]
    #[doc = "                     be duplicated."]
    #[doc = " @return             0 on success, negative AVERROR code on failure"]
    pub fn av_dict_parse_string(
        pm: *mut *mut AVDictionary,
        str_: *const ::std::os::raw::c_char,
        key_val_sep: *const ::std::os::raw::c_char,
        pairs_sep: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Copy entries from one AVDictionary struct into another."]
    #[doc = " @param dst pointer to a pointer to a AVDictionary struct. If *dst is NULL,"]
    #[doc = "            this function will allocate a struct for you and put it in *dst"]
    #[doc = " @param src pointer to source AVDictionary struct"]
    #[doc = " @param flags flags to use when setting entries in *dst"]
    #[doc = " @note metadata is read using the AV_DICT_IGNORE_SUFFIX flag"]
    #[doc = " @return 0 on success, negative AVERROR code on failure. If dst was allocated"]
    #[doc = "           by this function, callers should free the associated memory."]
    pub fn av_dict_copy(
        dst: *mut *mut AVDictionary,
        src: *const AVDictionary,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Free all the memory allocated for an AVDictionary struct"]
    #[doc = " and all keys and values."]
    pub fn av_dict_free(m: *mut *mut AVDictionary);
}
extern "C" {
    #[doc = " Get dictionary entries as a string."]
    #[doc = ""]
    #[doc = " Create a string containing dictionary's entries."]
    #[doc = " Such string may be passed back to av_dict_parse_string()."]
    #[doc = " @note String is escaped with backslashes ('\\')."]
    #[doc = ""]
    #[doc = " @param[in]  m             dictionary"]
    #[doc = " @param[out] buffer        Pointer to buffer that will be allocated with string containg entries."]
    #[doc = "                           Buffer must be freed by the caller when is no longer needed."]
    #[doc = " @param[in]  key_val_sep   character used to separate key from value"]
    #[doc = " @param[in]  pairs_sep     character used to separate two pairs from each other"]
    #[doc = " @return                   >= 0 on success, negative on error"]
    #[doc = " @warning Separators cannot be neither '\\\\' nor '\\0'. They also cannot be the same."]
    pub fn av_dict_get_string(
        m: *const AVDictionary,
        buffer: *mut *mut ::std::os::raw::c_char,
        key_val_sep: ::std::os::raw::c_char,
        pairs_sep: ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[doc = " The data is the AVPanScan struct defined in libavcodec."]
pub const AVFrameSideDataType_AV_FRAME_DATA_PANSCAN: AVFrameSideDataType = 0;
#[doc = " ATSC A53 Part 4 Closed Captions."]
#[doc = " A53 CC bitstream is stored as uint8_t in AVFrameSideData.data."]
#[doc = " The number of bytes of CC data is AVFrameSideData.size."]
pub const AVFrameSideDataType_AV_FRAME_DATA_A53_CC: AVFrameSideDataType = 1;
#[doc = " Stereoscopic 3d metadata."]
#[doc = " The data is the AVStereo3D struct defined in libavutil/stereo3d.h."]
pub const AVFrameSideDataType_AV_FRAME_DATA_STEREO3D: AVFrameSideDataType = 2;
#[doc = " The data is the AVMatrixEncoding enum defined in libavutil/channel_layout.h."]
pub const AVFrameSideDataType_AV_FRAME_DATA_MATRIXENCODING: AVFrameSideDataType = 3;
#[doc = " Metadata relevant to a downmix procedure."]
#[doc = " The data is the AVDownmixInfo struct defined in libavutil/downmix_info.h."]
pub const AVFrameSideDataType_AV_FRAME_DATA_DOWNMIX_INFO: AVFrameSideDataType = 4;
#[doc = " ReplayGain information in the form of the AVReplayGain struct."]
pub const AVFrameSideDataType_AV_FRAME_DATA_REPLAYGAIN: AVFrameSideDataType = 5;
#[doc = " This side data contains a 3x3 transformation matrix describing an affine"]
#[doc = " transformation that needs to be applied to the frame for correct"]
#[doc = " presentation."]
#[doc = ""]
#[doc = " See libavutil/display.h for a detailed description of the data."]
pub const AVFrameSideDataType_AV_FRAME_DATA_DISPLAYMATRIX: AVFrameSideDataType = 6;
#[doc = " Active Format Description data consisting of a single byte as specified"]
#[doc = " in ETSI TS 101 154 using AVActiveFormatDescription enum."]
pub const AVFrameSideDataType_AV_FRAME_DATA_AFD: AVFrameSideDataType = 7;
#[doc = " Motion vectors exported by some codecs (on demand through the export_mvs"]
#[doc = " flag set in the libavcodec AVCodecContext flags2 option)."]
#[doc = " The data is the AVMotionVector struct defined in"]
#[doc = " libavutil/motion_vector.h."]
pub const AVFrameSideDataType_AV_FRAME_DATA_MOTION_VECTORS: AVFrameSideDataType = 8;
#[doc = " Recommmends skipping the specified number of samples. This is exported"]
#[doc = " only if the \"skip_manual\" AVOption is set in libavcodec."]
#[doc = " This has the same format as AV_PKT_DATA_SKIP_SAMPLES."]
#[doc = " @code"]
#[doc = " u32le number of samples to skip from start of this packet"]
#[doc = " u32le number of samples to skip from end of this packet"]
#[doc = " u8    reason for start skip"]
#[doc = " u8    reason for end   skip (0=padding silence, 1=convergence)"]
#[doc = " @endcode"]
pub const AVFrameSideDataType_AV_FRAME_DATA_SKIP_SAMPLES: AVFrameSideDataType = 9;
#[doc = " This side data must be associated with an audio frame and corresponds to"]
#[doc = " enum AVAudioServiceType defined in avcodec.h."]
pub const AVFrameSideDataType_AV_FRAME_DATA_AUDIO_SERVICE_TYPE: AVFrameSideDataType = 10;
#[doc = " Mastering display metadata associated with a video frame. The payload is"]
#[doc = " an AVMasteringDisplayMetadata type and contains information about the"]
#[doc = " mastering display color volume."]
pub const AVFrameSideDataType_AV_FRAME_DATA_MASTERING_DISPLAY_METADATA: AVFrameSideDataType = 11;
#[doc = " The GOP timecode in 25 bit timecode format. Data format is 64-bit integer."]
#[doc = " This is set on the first frame of a GOP that has a temporal reference of 0."]
pub const AVFrameSideDataType_AV_FRAME_DATA_GOP_TIMECODE: AVFrameSideDataType = 12;
#[doc = " The data represents the AVSphericalMapping structure defined in"]
#[doc = " libavutil/spherical.h."]
pub const AVFrameSideDataType_AV_FRAME_DATA_SPHERICAL: AVFrameSideDataType = 13;
#[doc = " Content light level (based on CTA-861.3). This payload contains data in"]
#[doc = " the form of the AVContentLightMetadata struct."]
pub const AVFrameSideDataType_AV_FRAME_DATA_CONTENT_LIGHT_LEVEL: AVFrameSideDataType = 14;
#[doc = " The data contains an ICC profile as an opaque octet buffer following the"]
#[doc = " format described by ISO 15076-1 with an optional name defined in the"]
#[doc = " metadata key entry \"name\"."]
pub const AVFrameSideDataType_AV_FRAME_DATA_ICC_PROFILE: AVFrameSideDataType = 15;
#[doc = " Timecode which conforms to SMPTE ST 12-1. The data is an array of 4 uint32_t"]
#[doc = " where the first uint32_t describes how many (1-3) of the other timecodes are used."]
#[doc = " The timecode format is described in the documentation of av_timecode_get_smpte_from_framenum()"]
#[doc = " function in libavutil/timecode.h."]
pub const AVFrameSideDataType_AV_FRAME_DATA_S12M_TIMECODE: AVFrameSideDataType = 16;
#[doc = " HDR dynamic metadata associated with a video frame. The payload is"]
#[doc = " an AVDynamicHDRPlus type and contains information for color"]
#[doc = " volume transform - application 4 of SMPTE 2094-40:2016 standard."]
pub const AVFrameSideDataType_AV_FRAME_DATA_DYNAMIC_HDR_PLUS: AVFrameSideDataType = 17;
#[doc = " Regions Of Interest, the data is an array of AVRegionOfInterest type, the number of"]
#[doc = " array element is implied by AVFrameSideData.size / AVRegionOfInterest.self_size."]
pub const AVFrameSideDataType_AV_FRAME_DATA_REGIONS_OF_INTEREST: AVFrameSideDataType = 18;
#[doc = " Encoding parameters for a video frame, as described by AVVideoEncParams."]
pub const AVFrameSideDataType_AV_FRAME_DATA_VIDEO_ENC_PARAMS: AVFrameSideDataType = 19;
#[doc = " User data unregistered metadata associated with a video frame."]
#[doc = " This is the H.26[45] UDU SEI message, and shouldn't be used for any other purpose"]
#[doc = " The data is stored as uint8_t in AVFrameSideData.data which is 16 bytes of"]
#[doc = " uuid_iso_iec_11578 followed by AVFrameSideData.size - 16 bytes of user_data_payload_byte."]
pub const AVFrameSideDataType_AV_FRAME_DATA_SEI_UNREGISTERED: AVFrameSideDataType = 20;
#[doc = " Film grain parameters for a frame, described by AVFilmGrainParams."]
#[doc = " Must be present for every frame which should have film grain applied."]
pub const AVFrameSideDataType_AV_FRAME_DATA_FILM_GRAIN_PARAMS: AVFrameSideDataType = 21;
#[doc = " Bounding boxes for object detection and classification,"]
#[doc = " as described by AVDetectionBBoxHeader."]
pub const AVFrameSideDataType_AV_FRAME_DATA_DETECTION_BBOXES: AVFrameSideDataType = 22;
#[doc = " @defgroup lavu_frame AVFrame"]
#[doc = " @ingroup lavu_data"]
#[doc = ""]
#[doc = " @{"]
#[doc = " AVFrame is an abstraction for reference-counted raw multimedia data."]
pub type AVFrameSideDataType = ::std::os::raw::c_uint;
pub const AVActiveFormatDescription_AV_AFD_SAME: AVActiveFormatDescription = 8;
pub const AVActiveFormatDescription_AV_AFD_4_3: AVActiveFormatDescription = 9;
pub const AVActiveFormatDescription_AV_AFD_16_9: AVActiveFormatDescription = 10;
pub const AVActiveFormatDescription_AV_AFD_14_9: AVActiveFormatDescription = 11;
pub const AVActiveFormatDescription_AV_AFD_4_3_SP_14_9: AVActiveFormatDescription = 13;
pub const AVActiveFormatDescription_AV_AFD_16_9_SP_14_9: AVActiveFormatDescription = 14;
pub const AVActiveFormatDescription_AV_AFD_SP_4_3: AVActiveFormatDescription = 15;
pub type AVActiveFormatDescription = ::std::os::raw::c_uint;
#[doc = " Structure to hold side data for an AVFrame."]
#[doc = ""]
#[doc = " sizeof(AVFrameSideData) is not a part of the public ABI, so new fields may be added"]
#[doc = " to the end with a minor bump."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVFrameSideData {
    pub type_: AVFrameSideDataType,
    pub data: *mut u8,
    pub size: size_t,
    pub metadata: *mut AVDictionary,
    pub buf: *mut AVBufferRef,
}
#[test]
fn bindgen_test_layout_AVFrameSideData() {
    assert_eq!(
        ::std::mem::size_of::<AVFrameSideData>(),
        40usize,
        concat!("Size of: ", stringify!(AVFrameSideData))
    );
    assert_eq!(
        ::std::mem::align_of::<AVFrameSideData>(),
        8usize,
        concat!("Alignment of ", stringify!(AVFrameSideData))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrameSideData>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrameSideData),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrameSideData>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrameSideData),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrameSideData>())).size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrameSideData),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrameSideData>())).metadata as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrameSideData),
            "::",
            stringify!(metadata)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrameSideData>())).buf as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrameSideData),
            "::",
            stringify!(buf)
        )
    );
}
#[doc = " Structure describing a single Region Of Interest."]
#[doc = ""]
#[doc = " When multiple regions are defined in a single side-data block, they"]
#[doc = " should be ordered from most to least important - some encoders are only"]
#[doc = " capable of supporting a limited number of distinct regions, so will have"]
#[doc = " to truncate the list."]
#[doc = ""]
#[doc = " When overlapping regions are defined, the first region containing a given"]
#[doc = " area of the frame applies."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVRegionOfInterest {
    #[doc = " Must be set to the size of this data structure (that is,"]
    #[doc = " sizeof(AVRegionOfInterest))."]
    pub self_size: u32,
    #[doc = " Distance in pixels from the top edge of the frame to the top and"]
    #[doc = " bottom edges and from the left edge of the frame to the left and"]
    #[doc = " right edges of the rectangle defining this region of interest."]
    #[doc = ""]
    #[doc = " The constraints on a region are encoder dependent, so the region"]
    #[doc = " actually affected may be slightly larger for alignment or other"]
    #[doc = " reasons."]
    pub top: ::std::os::raw::c_int,
    pub bottom: ::std::os::raw::c_int,
    pub left: ::std::os::raw::c_int,
    pub right: ::std::os::raw::c_int,
    #[doc = " Quantisation offset."]
    #[doc = ""]
    #[doc = " Must be in the range -1 to +1.  A value of zero indicates no quality"]
    #[doc = " change.  A negative value asks for better quality (less quantisation),"]
    #[doc = " while a positive value asks for worse quality (greater quantisation)."]
    #[doc = ""]
    #[doc = " The range is calibrated so that the extreme values indicate the"]
    #[doc = " largest possible offset - if the rest of the frame is encoded with the"]
    #[doc = " worst possible quality, an offset of -1 indicates that this region"]
    #[doc = " should be encoded with the best possible quality anyway.  Intermediate"]
    #[doc = " values are then interpolated in some codec-dependent way."]
    #[doc = ""]
    #[doc = " For example, in 10-bit H.264 the quantisation parameter varies between"]
    #[doc = " -12 and 51.  A typical qoffset value of -1/10 therefore indicates that"]
    #[doc = " this region should be encoded with a QP around one-tenth of the full"]
    #[doc = " range better than the rest of the frame.  So, if most of the frame"]
    #[doc = " were to be encoded with a QP of around 30, this region would get a QP"]
    #[doc = " of around 24 (an offset of approximately -1/10 * (51 - -12) = -6.3)."]
    #[doc = " An extreme value of -1 would indicate that this region should be"]
    #[doc = " encoded with the best possible quality regardless of the treatment of"]
    #[doc = " the rest of the frame - that is, should be encoded at a QP of -12."]
    pub qoffset: AVRational,
}
#[test]
fn bindgen_test_layout_AVRegionOfInterest() {
    assert_eq!(
        ::std::mem::size_of::<AVRegionOfInterest>(),
        28usize,
        concat!("Size of: ", stringify!(AVRegionOfInterest))
    );
    assert_eq!(
        ::std::mem::align_of::<AVRegionOfInterest>(),
        4usize,
        concat!("Alignment of ", stringify!(AVRegionOfInterest))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVRegionOfInterest>())).self_size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVRegionOfInterest),
            "::",
            stringify!(self_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVRegionOfInterest>())).top as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(AVRegionOfInterest),
            "::",
            stringify!(top)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVRegionOfInterest>())).bottom as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVRegionOfInterest),
            "::",
            stringify!(bottom)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVRegionOfInterest>())).left as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(AVRegionOfInterest),
            "::",
            stringify!(left)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVRegionOfInterest>())).right as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVRegionOfInterest),
            "::",
            stringify!(right)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVRegionOfInterest>())).qoffset as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(AVRegionOfInterest),
            "::",
            stringify!(qoffset)
        )
    );
}
#[doc = " This structure describes decoded (raw) audio or video data."]
#[doc = ""]
#[doc = " AVFrame must be allocated using av_frame_alloc(). Note that this only"]
#[doc = " allocates the AVFrame itself, the buffers for the data must be managed"]
#[doc = " through other means (see below)."]
#[doc = " AVFrame must be freed with av_frame_free()."]
#[doc = ""]
#[doc = " AVFrame is typically allocated once and then reused multiple times to hold"]
#[doc = " different data (e.g. a single AVFrame to hold frames received from a"]
#[doc = " decoder). In such a case, av_frame_unref() will free any references held by"]
#[doc = " the frame and reset it to its original clean state before it"]
#[doc = " is reused again."]
#[doc = ""]
#[doc = " The data described by an AVFrame is usually reference counted through the"]
#[doc = " AVBuffer API. The underlying buffer references are stored in AVFrame.buf /"]
#[doc = " AVFrame.extended_buf. An AVFrame is considered to be reference counted if at"]
#[doc = " least one reference is set, i.e. if AVFrame.buf[0] != NULL. In such a case,"]
#[doc = " every single data plane must be contained in one of the buffers in"]
#[doc = " AVFrame.buf or AVFrame.extended_buf."]
#[doc = " There may be a single buffer for all the data, or one separate buffer for"]
#[doc = " each plane, or anything in between."]
#[doc = ""]
#[doc = " sizeof(AVFrame) is not a part of the public ABI, so new fields may be added"]
#[doc = " to the end with a minor bump."]
#[doc = ""]
#[doc = " Fields can be accessed through AVOptions, the name string used, matches the"]
#[doc = " C structure field name for fields accessible through AVOptions. The AVClass"]
#[doc = " for AVFrame can be obtained from avcodec_get_frame_class()"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVFrame {
    #[doc = " pointer to the picture/channel planes."]
    #[doc = " This might be different from the first allocated byte"]
    #[doc = ""]
    #[doc = " Some decoders access areas outside 0,0 - width,height, please"]
    #[doc = " see avcodec_align_dimensions2(). Some filters and swscale can read"]
    #[doc = " up to 16 bytes beyond the planes, if these filters are to be used,"]
    #[doc = " then 16 extra bytes must be allocated."]
    #[doc = ""]
    #[doc = " NOTE: Except for hwaccel formats, pointers not needed by the format"]
    #[doc = " MUST be set to NULL."]
    pub data: [*mut u8; 8usize],
    #[doc = " For video, size in bytes of each picture line."]
    #[doc = " For audio, size in bytes of each plane."]
    #[doc = ""]
    #[doc = " For audio, only linesize[0] may be set. For planar audio, each channel"]
    #[doc = " plane must be the same size."]
    #[doc = ""]
    #[doc = " For video the linesizes should be multiples of the CPUs alignment"]
    #[doc = " preference, this is 16 or 32 for modern desktop CPUs."]
    #[doc = " Some code requires such alignment other code can be slower without"]
    #[doc = " correct alignment, for yet other it makes no difference."]
    #[doc = ""]
    #[doc = " @note The linesize may be larger than the size of usable data -- there"]
    #[doc = " may be extra padding present for performance reasons."]
    pub linesize: [::std::os::raw::c_int; 8usize],
    #[doc = " pointers to the data planes/channels."]
    #[doc = ""]
    #[doc = " For video, this should simply point to data[]."]
    #[doc = ""]
    #[doc = " For planar audio, each channel has a separate data pointer, and"]
    #[doc = " linesize[0] contains the size of each channel buffer."]
    #[doc = " For packed audio, there is just one data pointer, and linesize[0]"]
    #[doc = " contains the total size of the buffer for all channels."]
    #[doc = ""]
    #[doc = " Note: Both data and extended_data should always be set in a valid frame,"]
    #[doc = " but for planar audio with more channels that can fit in data,"]
    #[doc = " extended_data must be used in order to access all channels."]
    pub extended_data: *mut *mut u8,
    #[doc = " @name Video dimensions"]
    #[doc = " Video frames only. The coded dimensions (in pixels) of the video frame,"]
    #[doc = " i.e. the size of the rectangle that contains some well-defined values."]
    #[doc = ""]
    #[doc = " @note The part of the frame intended for display/presentation is further"]
    #[doc = " restricted by the @ref cropping \"Cropping rectangle\"."]
    #[doc = " @{"]
    pub width: ::std::os::raw::c_int,
    #[doc = " @name Video dimensions"]
    #[doc = " Video frames only. The coded dimensions (in pixels) of the video frame,"]
    #[doc = " i.e. the size of the rectangle that contains some well-defined values."]
    #[doc = ""]
    #[doc = " @note The part of the frame intended for display/presentation is further"]
    #[doc = " restricted by the @ref cropping \"Cropping rectangle\"."]
    #[doc = " @{"]
    pub height: ::std::os::raw::c_int,
    #[doc = " number of audio samples (per channel) described by this frame"]
    pub nb_samples: ::std::os::raw::c_int,
    #[doc = " format of the frame, -1 if unknown or unset"]
    #[doc = " Values correspond to enum AVPixelFormat for video frames,"]
    #[doc = " enum AVSampleFormat for audio)"]
    pub format: ::std::os::raw::c_int,
    #[doc = " 1 -> keyframe, 0-> not"]
    pub key_frame: ::std::os::raw::c_int,
    #[doc = " Picture type of the frame."]
    pub pict_type: AVPictureType,
    #[doc = " Sample aspect ratio for the video frame, 0/1 if unknown/unspecified."]
    pub sample_aspect_ratio: AVRational,
    #[doc = " Presentation timestamp in time_base units (time when frame should be shown to user)."]
    pub pts: i64,
    #[doc = " DTS copied from the AVPacket that triggered returning this frame. (if frame threading isn't used)"]
    #[doc = " This is also the Presentation time of this AVFrame calculated from"]
    #[doc = " only AVPacket.dts values without pts values."]
    pub pkt_dts: i64,
    #[doc = " picture number in bitstream order"]
    pub coded_picture_number: ::std::os::raw::c_int,
    #[doc = " picture number in display order"]
    pub display_picture_number: ::std::os::raw::c_int,
    #[doc = " quality (between 1 (good) and FF_LAMBDA_MAX (bad))"]
    pub quality: ::std::os::raw::c_int,
    #[doc = " for some private data of the user"]
    pub opaque: *mut ::std::os::raw::c_void,
    #[doc = " When decoding, this signals how much the picture must be delayed."]
    #[doc = " extra_delay = repeat_pict / (2*fps)"]
    pub repeat_pict: ::std::os::raw::c_int,
    #[doc = " The content of the picture is interlaced."]
    pub interlaced_frame: ::std::os::raw::c_int,
    #[doc = " If the content is interlaced, is top field displayed first."]
    pub top_field_first: ::std::os::raw::c_int,
    #[doc = " Tell user application that palette has changed from previous frame."]
    pub palette_has_changed: ::std::os::raw::c_int,
    #[doc = " reordered opaque 64 bits (generally an integer or a double precision float"]
    #[doc = " PTS but can be anything)."]
    #[doc = " The user sets AVCodecContext.reordered_opaque to represent the input at"]
    #[doc = " that time,"]
    #[doc = " the decoder reorders values as needed and sets AVFrame.reordered_opaque"]
    #[doc = " to exactly one of the values provided by the user through AVCodecContext.reordered_opaque"]
    pub reordered_opaque: i64,
    #[doc = " Sample rate of the audio data."]
    pub sample_rate: ::std::os::raw::c_int,
    #[doc = " Channel layout of the audio data."]
    pub channel_layout: u64,
    #[doc = " AVBuffer references backing the data for this frame. If all elements of"]
    #[doc = " this array are NULL, then this frame is not reference counted. This array"]
    #[doc = " must be filled contiguously -- if buf[i] is non-NULL then buf[j] must"]
    #[doc = " also be non-NULL for all j < i."]
    #[doc = ""]
    #[doc = " There may be at most one AVBuffer per data plane, so for video this array"]
    #[doc = " always contains all the references. For planar audio with more than"]
    #[doc = " AV_NUM_DATA_POINTERS channels, there may be more buffers than can fit in"]
    #[doc = " this array. Then the extra AVBufferRef pointers are stored in the"]
    #[doc = " extended_buf array."]
    pub buf: [*mut AVBufferRef; 8usize],
    #[doc = " For planar audio which requires more than AV_NUM_DATA_POINTERS"]
    #[doc = " AVBufferRef pointers, this array will hold all the references which"]
    #[doc = " cannot fit into AVFrame.buf."]
    #[doc = ""]
    #[doc = " Note that this is different from AVFrame.extended_data, which always"]
    #[doc = " contains all the pointers. This array only contains the extra pointers,"]
    #[doc = " which cannot fit into AVFrame.buf."]
    #[doc = ""]
    #[doc = " This array is always allocated using av_malloc() by whoever constructs"]
    #[doc = " the frame. It is freed in av_frame_unref()."]
    pub extended_buf: *mut *mut AVBufferRef,
    #[doc = " Number of elements in extended_buf."]
    pub nb_extended_buf: ::std::os::raw::c_int,
    pub side_data: *mut *mut AVFrameSideData,
    pub nb_side_data: ::std::os::raw::c_int,
    #[doc = " Frame flags, a combination of @ref lavu_frame_flags"]
    pub flags: ::std::os::raw::c_int,
    #[doc = " MPEG vs JPEG YUV range."]
    #[doc = " - encoding: Set by user"]
    #[doc = " - decoding: Set by libavcodec"]
    pub color_range: AVColorRange,
    pub color_primaries: AVColorPrimaries,
    pub color_trc: AVColorTransferCharacteristic,
    #[doc = " YUV colorspace type."]
    #[doc = " - encoding: Set by user"]
    #[doc = " - decoding: Set by libavcodec"]
    pub colorspace: AVColorSpace,
    pub chroma_location: AVChromaLocation,
    #[doc = " frame timestamp estimated using various heuristics, in stream time base"]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: set by libavcodec, read by user."]
    pub best_effort_timestamp: i64,
    #[doc = " reordered pos from the last AVPacket that has been input into the decoder"]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Read by user."]
    pub pkt_pos: i64,
    #[doc = " duration of the corresponding packet, expressed in"]
    #[doc = " AVStream->time_base units, 0 if unknown."]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Read by user."]
    pub pkt_duration: i64,
    #[doc = " metadata."]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by libavcodec."]
    pub metadata: *mut AVDictionary,
    #[doc = " decode error flags of the frame, set to a combination of"]
    #[doc = " FF_DECODE_ERROR_xxx flags if the decoder produced a frame, but there"]
    #[doc = " were errors during the decoding."]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: set by libavcodec, read by user."]
    pub decode_error_flags: ::std::os::raw::c_int,
    #[doc = " number of audio channels, only used for audio."]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Read by user."]
    pub channels: ::std::os::raw::c_int,
    #[doc = " size of the corresponding packet containing the compressed"]
    #[doc = " frame."]
    #[doc = " It is set to a negative value if unknown."]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: set by libavcodec, read by user."]
    pub pkt_size: ::std::os::raw::c_int,
    #[doc = " For hwaccel-format frames, this should be a reference to the"]
    #[doc = " AVHWFramesContext describing the frame."]
    pub hw_frames_ctx: *mut AVBufferRef,
    #[doc = " AVBufferRef for free use by the API user. FFmpeg will never check the"]
    #[doc = " contents of the buffer ref. FFmpeg calls av_buffer_unref() on it when"]
    #[doc = " the frame is unreferenced. av_frame_copy_props() calls create a new"]
    #[doc = " reference with av_buffer_ref() for the target frame's opaque_ref field."]
    #[doc = ""]
    #[doc = " This is unrelated to the opaque field, although it serves a similar"]
    #[doc = " purpose."]
    pub opaque_ref: *mut AVBufferRef,
    #[doc = " @anchor cropping"]
    #[doc = " @name Cropping"]
    #[doc = " Video frames only. The number of pixels to discard from the the"]
    #[doc = " top/bottom/left/right border of the frame to obtain the sub-rectangle of"]
    #[doc = " the frame intended for presentation."]
    #[doc = " @{"]
    pub crop_top: size_t,
    pub crop_bottom: size_t,
    pub crop_left: size_t,
    pub crop_right: size_t,
    #[doc = " AVBufferRef for internal use by a single libav* library."]
    #[doc = " Must not be used to transfer data between libraries."]
    #[doc = " Has to be NULL when ownership of the frame leaves the respective library."]
    #[doc = ""]
    #[doc = " Code outside the FFmpeg libs should never check or change the contents of the buffer ref."]
    #[doc = ""]
    #[doc = " FFmpeg calls av_buffer_unref() on it when the frame is unreferenced."]
    #[doc = " av_frame_copy_props() calls create a new reference with av_buffer_ref()"]
    #[doc = " for the target frame's private_ref field."]
    pub private_ref: *mut AVBufferRef,
}
#[test]
fn bindgen_test_layout_AVFrame() {
    assert_eq!(
        ::std::mem::size_of::<AVFrame>(),
        440usize,
        concat!("Size of: ", stringify!(AVFrame))
    );
    assert_eq!(
        ::std::mem::align_of::<AVFrame>(),
        8usize,
        concat!("Alignment of ", stringify!(AVFrame))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).linesize as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(linesize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).extended_data as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(extended_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).width as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).height as *const _ as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).nb_samples as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(nb_samples)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).format as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).key_frame as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(key_frame)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).pict_type as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(pict_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).sample_aspect_ratio as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(sample_aspect_ratio)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).pts as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(pts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).pkt_dts as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(pkt_dts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).coded_picture_number as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(coded_picture_number)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).display_picture_number as *const _ as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(display_picture_number)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).quality as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(quality)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).opaque as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(opaque)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).repeat_pict as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(repeat_pict)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).interlaced_frame as *const _ as usize },
        180usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(interlaced_frame)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).top_field_first as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(top_field_first)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).palette_has_changed as *const _ as usize },
        188usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(palette_has_changed)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).reordered_opaque as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(reordered_opaque)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).sample_rate as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(sample_rate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).channel_layout as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(channel_layout)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).buf as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).extended_buf as *const _ as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(extended_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).nb_extended_buf as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(nb_extended_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).side_data as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(side_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).nb_side_data as *const _ as usize },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(nb_side_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).flags as *const _ as usize },
        308usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).color_range as *const _ as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(color_range)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).color_primaries as *const _ as usize },
        316usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(color_primaries)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).color_trc as *const _ as usize },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(color_trc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).colorspace as *const _ as usize },
        324usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(colorspace)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).chroma_location as *const _ as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(chroma_location)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).best_effort_timestamp as *const _ as usize },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(best_effort_timestamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).pkt_pos as *const _ as usize },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(pkt_pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).pkt_duration as *const _ as usize },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(pkt_duration)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).metadata as *const _ as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(metadata)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).decode_error_flags as *const _ as usize },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(decode_error_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).channels as *const _ as usize },
        372usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(channels)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).pkt_size as *const _ as usize },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(pkt_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).hw_frames_ctx as *const _ as usize },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(hw_frames_ctx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).opaque_ref as *const _ as usize },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(opaque_ref)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).crop_top as *const _ as usize },
        400usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(crop_top)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).crop_bottom as *const _ as usize },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(crop_bottom)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).crop_left as *const _ as usize },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(crop_left)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).crop_right as *const _ as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(crop_right)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFrame>())).private_ref as *const _ as usize },
        432usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFrame),
            "::",
            stringify!(private_ref)
        )
    );
}
extern "C" {
    #[doc = " Get the name of a colorspace."]
    #[doc = " @return a static string identifying the colorspace; can be NULL."]
    #[doc = " @deprecated use av_color_space_name()"]
    pub fn av_get_colorspace_name(val: AVColorSpace) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Allocate an AVFrame and set its fields to default values.  The resulting"]
    #[doc = " struct must be freed using av_frame_free()."]
    #[doc = ""]
    #[doc = " @return An AVFrame filled with default values or NULL on failure."]
    #[doc = ""]
    #[doc = " @note this only allocates the AVFrame itself, not the data buffers. Those"]
    #[doc = " must be allocated through other means, e.g. with av_frame_get_buffer() or"]
    #[doc = " manually."]
    pub fn av_frame_alloc() -> *mut AVFrame;
}
extern "C" {
    #[doc = " Free the frame and any dynamically allocated objects in it,"]
    #[doc = " e.g. extended_data. If the frame is reference counted, it will be"]
    #[doc = " unreferenced first."]
    #[doc = ""]
    #[doc = " @param frame frame to be freed. The pointer will be set to NULL."]
    pub fn av_frame_free(frame: *mut *mut AVFrame);
}
extern "C" {
    #[doc = " Set up a new reference to the data described by the source frame."]
    #[doc = ""]
    #[doc = " Copy frame properties from src to dst and create a new reference for each"]
    #[doc = " AVBufferRef from src."]
    #[doc = ""]
    #[doc = " If src is not reference counted, new buffers are allocated and the data is"]
    #[doc = " copied."]
    #[doc = ""]
    #[doc = " @warning: dst MUST have been either unreferenced with av_frame_unref(dst),"]
    #[doc = "           or newly allocated with av_frame_alloc() before calling this"]
    #[doc = "           function, or undefined behavior will occur."]
    #[doc = ""]
    #[doc = " @return 0 on success, a negative AVERROR on error"]
    pub fn av_frame_ref(dst: *mut AVFrame, src: *const AVFrame) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Create a new frame that references the same data as src."]
    #[doc = ""]
    #[doc = " This is a shortcut for av_frame_alloc()+av_frame_ref()."]
    #[doc = ""]
    #[doc = " @return newly created AVFrame on success, NULL on error."]
    pub fn av_frame_clone(src: *const AVFrame) -> *mut AVFrame;
}
extern "C" {
    #[doc = " Unreference all the buffers referenced by frame and reset the frame fields."]
    pub fn av_frame_unref(frame: *mut AVFrame);
}
extern "C" {
    #[doc = " Move everything contained in src to dst and reset src."]
    #[doc = ""]
    #[doc = " @warning: dst is not unreferenced, but directly overwritten without reading"]
    #[doc = "           or deallocating its contents. Call av_frame_unref(dst) manually"]
    #[doc = "           before calling this function to ensure that no memory is leaked."]
    pub fn av_frame_move_ref(dst: *mut AVFrame, src: *mut AVFrame);
}
extern "C" {
    #[doc = " Allocate new buffer(s) for audio or video data."]
    #[doc = ""]
    #[doc = " The following fields must be set on frame before calling this function:"]
    #[doc = " - format (pixel format for video, sample format for audio)"]
    #[doc = " - width and height for video"]
    #[doc = " - nb_samples and channel_layout for audio"]
    #[doc = ""]
    #[doc = " This function will fill AVFrame.data and AVFrame.buf arrays and, if"]
    #[doc = " necessary, allocate and fill AVFrame.extended_data and AVFrame.extended_buf."]
    #[doc = " For planar formats, one buffer will be allocated for each plane."]
    #[doc = ""]
    #[doc = " @warning: if frame already has been allocated, calling this function will"]
    #[doc = "           leak memory. In addition, undefined behavior can occur in certain"]
    #[doc = "           cases."]
    #[doc = ""]
    #[doc = " @param frame frame in which to store the new buffers."]
    #[doc = " @param align Required buffer size alignment. If equal to 0, alignment will be"]
    #[doc = "              chosen automatically for the current CPU. It is highly"]
    #[doc = "              recommended to pass 0 here unless you know what you are doing."]
    #[doc = ""]
    #[doc = " @return 0 on success, a negative AVERROR on error."]
    pub fn av_frame_get_buffer(
        frame: *mut AVFrame,
        align: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Check if the frame data is writable."]
    #[doc = ""]
    #[doc = " @return A positive value if the frame data is writable (which is true if and"]
    #[doc = " only if each of the underlying buffers has only one reference, namely the one"]
    #[doc = " stored in this frame). Return 0 otherwise."]
    #[doc = ""]
    #[doc = " If 1 is returned the answer is valid until av_buffer_ref() is called on any"]
    #[doc = " of the underlying AVBufferRefs (e.g. through av_frame_ref() or directly)."]
    #[doc = ""]
    #[doc = " @see av_frame_make_writable(), av_buffer_is_writable()"]
    pub fn av_frame_is_writable(frame: *mut AVFrame) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Ensure that the frame data is writable, avoiding data copy if possible."]
    #[doc = ""]
    #[doc = " Do nothing if the frame is writable, allocate new buffers and copy the data"]
    #[doc = " if it is not."]
    #[doc = ""]
    #[doc = " @return 0 on success, a negative AVERROR on error."]
    #[doc = ""]
    #[doc = " @see av_frame_is_writable(), av_buffer_is_writable(),"]
    #[doc = " av_buffer_make_writable()"]
    pub fn av_frame_make_writable(frame: *mut AVFrame) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Copy the frame data from src to dst."]
    #[doc = ""]
    #[doc = " This function does not allocate anything, dst must be already initialized and"]
    #[doc = " allocated with the same parameters as src."]
    #[doc = ""]
    #[doc = " This function only copies the frame data (i.e. the contents of the data /"]
    #[doc = " extended data arrays), not any other properties."]
    #[doc = ""]
    #[doc = " @return >= 0 on success, a negative AVERROR on error."]
    pub fn av_frame_copy(dst: *mut AVFrame, src: *const AVFrame) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Copy only \"metadata\" fields from src to dst."]
    #[doc = ""]
    #[doc = " Metadata for the purpose of this function are those fields that do not affect"]
    #[doc = " the data layout in the buffers.  E.g. pts, sample rate (for audio) or sample"]
    #[doc = " aspect ratio (for video), but not width/height or channel layout."]
    #[doc = " Side data is also copied."]
    pub fn av_frame_copy_props(dst: *mut AVFrame, src: *const AVFrame) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get the buffer reference a given data plane is stored in."]
    #[doc = ""]
    #[doc = " @param plane index of the data plane of interest in frame->extended_data."]
    #[doc = ""]
    #[doc = " @return the buffer reference that contains the plane or NULL if the input"]
    #[doc = " frame is not valid."]
    pub fn av_frame_get_plane_buffer(
        frame: *mut AVFrame,
        plane: ::std::os::raw::c_int,
    ) -> *mut AVBufferRef;
}
extern "C" {
    #[doc = " Add a new side data to a frame."]
    #[doc = ""]
    #[doc = " @param frame a frame to which the side data should be added"]
    #[doc = " @param type type of the added side data"]
    #[doc = " @param size size of the side data"]
    #[doc = ""]
    #[doc = " @return newly added side data on success, NULL on error"]
    pub fn av_frame_new_side_data(
        frame: *mut AVFrame,
        type_: AVFrameSideDataType,
        size: size_t,
    ) -> *mut AVFrameSideData;
}
extern "C" {
    #[doc = " Add a new side data to a frame from an existing AVBufferRef"]
    #[doc = ""]
    #[doc = " @param frame a frame to which the side data should be added"]
    #[doc = " @param type  the type of the added side data"]
    #[doc = " @param buf   an AVBufferRef to add as side data. The ownership of"]
    #[doc = "              the reference is transferred to the frame."]
    #[doc = ""]
    #[doc = " @return newly added side data on success, NULL on error. On failure"]
    #[doc = "         the frame is unchanged and the AVBufferRef remains owned by"]
    #[doc = "         the caller."]
    pub fn av_frame_new_side_data_from_buf(
        frame: *mut AVFrame,
        type_: AVFrameSideDataType,
        buf: *mut AVBufferRef,
    ) -> *mut AVFrameSideData;
}
extern "C" {
    #[doc = " @return a pointer to the side data of a given type on success, NULL if there"]
    #[doc = " is no side data with such type in this frame."]
    pub fn av_frame_get_side_data(
        frame: *const AVFrame,
        type_: AVFrameSideDataType,
    ) -> *mut AVFrameSideData;
}
extern "C" {
    #[doc = " Remove and free all side data instances of the given type."]
    pub fn av_frame_remove_side_data(frame: *mut AVFrame, type_: AVFrameSideDataType);
}
#[doc = " Apply the maximum possible cropping, even if it requires setting the"]
#[doc = " AVFrame.data[] entries to unaligned pointers. Passing unaligned data"]
#[doc = " to FFmpeg API is generally not allowed, and causes undefined behavior"]
#[doc = " (such as crashes). You can pass unaligned data only to FFmpeg APIs that"]
#[doc = " are explicitly documented to accept it. Use this flag only if you"]
#[doc = " absolutely know what you are doing."]
pub const AV_FRAME_CROP_UNALIGNED: ::std::os::raw::c_uint = 1;
#[doc = " Flags for frame cropping."]
pub type _bindgen_ty_2 = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Crop the given video AVFrame according to its crop_left/crop_top/crop_right/"]
    #[doc = " crop_bottom fields. If cropping is successful, the function will adjust the"]
    #[doc = " data pointers and the width/height fields, and set the crop fields to 0."]
    #[doc = ""]
    #[doc = " In all cases, the cropping boundaries will be rounded to the inherent"]
    #[doc = " alignment of the pixel format. In some cases, such as for opaque hwaccel"]
    #[doc = " formats, the left/top cropping is ignored. The crop fields are set to 0 even"]
    #[doc = " if the cropping was rounded or ignored."]
    #[doc = ""]
    #[doc = " @param frame the frame which should be cropped"]
    #[doc = " @param flags Some combination of AV_FRAME_CROP_* flags, or 0."]
    #[doc = ""]
    #[doc = " @return >= 0 on success, a negative AVERROR on error. If the cropping fields"]
    #[doc = " were invalid, AVERROR(ERANGE) is returned, and nothing is changed."]
    pub fn av_frame_apply_cropping(
        frame: *mut AVFrame,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @return a string identifying the side data type"]
    pub fn av_frame_side_data_name(type_: AVFrameSideDataType) -> *const ::std::os::raw::c_char;
}
pub const AVHWDeviceType_AV_HWDEVICE_TYPE_NONE: AVHWDeviceType = 0;
pub const AVHWDeviceType_AV_HWDEVICE_TYPE_VDPAU: AVHWDeviceType = 1;
pub const AVHWDeviceType_AV_HWDEVICE_TYPE_CUDA: AVHWDeviceType = 2;
pub const AVHWDeviceType_AV_HWDEVICE_TYPE_VAAPI: AVHWDeviceType = 3;
pub const AVHWDeviceType_AV_HWDEVICE_TYPE_DXVA2: AVHWDeviceType = 4;
pub const AVHWDeviceType_AV_HWDEVICE_TYPE_QSV: AVHWDeviceType = 5;
pub const AVHWDeviceType_AV_HWDEVICE_TYPE_VIDEOTOOLBOX: AVHWDeviceType = 6;
pub const AVHWDeviceType_AV_HWDEVICE_TYPE_D3D11VA: AVHWDeviceType = 7;
pub const AVHWDeviceType_AV_HWDEVICE_TYPE_DRM: AVHWDeviceType = 8;
pub const AVHWDeviceType_AV_HWDEVICE_TYPE_OPENCL: AVHWDeviceType = 9;
pub const AVHWDeviceType_AV_HWDEVICE_TYPE_MEDIACODEC: AVHWDeviceType = 10;
pub const AVHWDeviceType_AV_HWDEVICE_TYPE_VULKAN: AVHWDeviceType = 11;
pub type AVHWDeviceType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVHWDeviceInternal {
    _unused: [u8; 0],
}
#[doc = " This struct aggregates all the (hardware/vendor-specific) \"high-level\" state,"]
#[doc = " i.e. state that is not tied to a concrete processing configuration."]
#[doc = " E.g., in an API that supports hardware-accelerated encoding and decoding,"]
#[doc = " this struct will (if possible) wrap the state that is common to both encoding"]
#[doc = " and decoding and from which specific instances of encoders or decoders can be"]
#[doc = " derived."]
#[doc = ""]
#[doc = " This struct is reference-counted with the AVBuffer mechanism. The"]
#[doc = " av_hwdevice_ctx_alloc() constructor yields a reference, whose data field"]
#[doc = " points to the actual AVHWDeviceContext. Further objects derived from"]
#[doc = " AVHWDeviceContext (such as AVHWFramesContext, describing a frame pool with"]
#[doc = " specific properties) will hold an internal reference to it. After all the"]
#[doc = " references are released, the AVHWDeviceContext itself will be freed,"]
#[doc = " optionally invoking a user-specified callback for uninitializing the hardware"]
#[doc = " state."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVHWDeviceContext {
    #[doc = " A class for logging. Set by av_hwdevice_ctx_alloc()."]
    pub av_class: *const AVClass,
    #[doc = " Private data used internally by libavutil. Must not be accessed in any"]
    #[doc = " way by the caller."]
    pub internal: *mut AVHWDeviceInternal,
    #[doc = " This field identifies the underlying API used for hardware access."]
    #[doc = ""]
    #[doc = " This field is set when this struct is allocated and never changed"]
    #[doc = " afterwards."]
    pub type_: AVHWDeviceType,
    #[doc = " The format-specific data, allocated and freed by libavutil along with"]
    #[doc = " this context."]
    #[doc = ""]
    #[doc = " Should be cast by the user to the format-specific context defined in the"]
    #[doc = " corresponding header (hwcontext_*.h) and filled as described in the"]
    #[doc = " documentation before calling av_hwdevice_ctx_init()."]
    #[doc = ""]
    #[doc = " After calling av_hwdevice_ctx_init() this struct should not be modified"]
    #[doc = " by the caller."]
    pub hwctx: *mut ::std::os::raw::c_void,
    #[doc = " This field may be set by the caller before calling av_hwdevice_ctx_init()."]
    #[doc = ""]
    #[doc = " If non-NULL, this callback will be called when the last reference to"]
    #[doc = " this context is unreferenced, immediately before it is freed."]
    #[doc = ""]
    #[doc = " @note when other objects (e.g an AVHWFramesContext) are derived from this"]
    #[doc = "       struct, this callback will be invoked after all such child objects"]
    #[doc = "       are fully uninitialized and their respective destructors invoked."]
    pub free: ::std::option::Option<unsafe extern "C" fn(ctx: *mut AVHWDeviceContext)>,
    #[doc = " Arbitrary user data, to be used e.g. by the free() callback."]
    pub user_opaque: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_AVHWDeviceContext() {
    assert_eq!(
        ::std::mem::size_of::<AVHWDeviceContext>(),
        48usize,
        concat!("Size of: ", stringify!(AVHWDeviceContext))
    );
    assert_eq!(
        ::std::mem::align_of::<AVHWDeviceContext>(),
        8usize,
        concat!("Alignment of ", stringify!(AVHWDeviceContext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWDeviceContext>())).av_class as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWDeviceContext),
            "::",
            stringify!(av_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWDeviceContext>())).internal as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWDeviceContext),
            "::",
            stringify!(internal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWDeviceContext>())).type_ as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWDeviceContext),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWDeviceContext>())).hwctx as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWDeviceContext),
            "::",
            stringify!(hwctx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWDeviceContext>())).free as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWDeviceContext),
            "::",
            stringify!(free)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWDeviceContext>())).user_opaque as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWDeviceContext),
            "::",
            stringify!(user_opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVHWFramesInternal {
    _unused: [u8; 0],
}
#[doc = " This struct describes a set or pool of \"hardware\" frames (i.e. those with"]
#[doc = " data not located in normal system memory). All the frames in the pool are"]
#[doc = " assumed to be allocated in the same way and interchangeable."]
#[doc = ""]
#[doc = " This struct is reference-counted with the AVBuffer mechanism and tied to a"]
#[doc = " given AVHWDeviceContext instance. The av_hwframe_ctx_alloc() constructor"]
#[doc = " yields a reference, whose data field points to the actual AVHWFramesContext"]
#[doc = " struct."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVHWFramesContext {
    #[doc = " A class for logging."]
    pub av_class: *const AVClass,
    #[doc = " Private data used internally by libavutil. Must not be accessed in any"]
    #[doc = " way by the caller."]
    pub internal: *mut AVHWFramesInternal,
    #[doc = " A reference to the parent AVHWDeviceContext. This reference is owned and"]
    #[doc = " managed by the enclosing AVHWFramesContext, but the caller may derive"]
    #[doc = " additional references from it."]
    pub device_ref: *mut AVBufferRef,
    #[doc = " The parent AVHWDeviceContext. This is simply a pointer to"]
    #[doc = " device_ref->data provided for convenience."]
    #[doc = ""]
    #[doc = " Set by libavutil in av_hwframe_ctx_init()."]
    pub device_ctx: *mut AVHWDeviceContext,
    #[doc = " The format-specific data, allocated and freed automatically along with"]
    #[doc = " this context."]
    #[doc = ""]
    #[doc = " Should be cast by the user to the format-specific context defined in the"]
    #[doc = " corresponding header (hwframe_*.h) and filled as described in the"]
    #[doc = " documentation before calling av_hwframe_ctx_init()."]
    #[doc = ""]
    #[doc = " After any frames using this context are created, the contents of this"]
    #[doc = " struct should not be modified by the caller."]
    pub hwctx: *mut ::std::os::raw::c_void,
    #[doc = " This field may be set by the caller before calling av_hwframe_ctx_init()."]
    #[doc = ""]
    #[doc = " If non-NULL, this callback will be called when the last reference to"]
    #[doc = " this context is unreferenced, immediately before it is freed."]
    pub free: ::std::option::Option<unsafe extern "C" fn(ctx: *mut AVHWFramesContext)>,
    #[doc = " Arbitrary user data, to be used e.g. by the free() callback."]
    pub user_opaque: *mut ::std::os::raw::c_void,
    #[doc = " A pool from which the frames are allocated by av_hwframe_get_buffer()."]
    #[doc = " This field may be set by the caller before calling av_hwframe_ctx_init()."]
    #[doc = " The buffers returned by calling av_buffer_pool_get() on this pool must"]
    #[doc = " have the properties described in the documentation in the corresponding hw"]
    #[doc = " type's header (hwcontext_*.h). The pool will be freed strictly before"]
    #[doc = " this struct's free() callback is invoked."]
    #[doc = ""]
    #[doc = " This field may be NULL, then libavutil will attempt to allocate a pool"]
    #[doc = " internally. Note that certain device types enforce pools allocated at"]
    #[doc = " fixed size (frame count), which cannot be extended dynamically. In such a"]
    #[doc = " case, initial_pool_size must be set appropriately."]
    pub pool: *mut AVBufferPool,
    #[doc = " Initial size of the frame pool. If a device type does not support"]
    #[doc = " dynamically resizing the pool, then this is also the maximum pool size."]
    #[doc = ""]
    #[doc = " May be set by the caller before calling av_hwframe_ctx_init(). Must be"]
    #[doc = " set if pool is NULL and the device type does not support dynamic pools."]
    pub initial_pool_size: ::std::os::raw::c_int,
    #[doc = " The pixel format identifying the underlying HW surface type."]
    #[doc = ""]
    #[doc = " Must be a hwaccel format, i.e. the corresponding descriptor must have the"]
    #[doc = " AV_PIX_FMT_FLAG_HWACCEL flag set."]
    #[doc = ""]
    #[doc = " Must be set by the user before calling av_hwframe_ctx_init()."]
    pub format: AVPixelFormat,
    #[doc = " The pixel format identifying the actual data layout of the hardware"]
    #[doc = " frames."]
    #[doc = ""]
    #[doc = " Must be set by the caller before calling av_hwframe_ctx_init()."]
    #[doc = ""]
    #[doc = " @note when the underlying API does not provide the exact data layout, but"]
    #[doc = " only the colorspace/bit depth, this field should be set to the fully"]
    #[doc = " planar version of that format (e.g. for 8-bit 420 YUV it should be"]
    #[doc = " AV_PIX_FMT_YUV420P, not AV_PIX_FMT_NV12 or anything else)."]
    pub sw_format: AVPixelFormat,
    #[doc = " The allocated dimensions of the frames in this pool."]
    #[doc = ""]
    #[doc = " Must be set by the user before calling av_hwframe_ctx_init()."]
    pub width: ::std::os::raw::c_int,
    #[doc = " The allocated dimensions of the frames in this pool."]
    #[doc = ""]
    #[doc = " Must be set by the user before calling av_hwframe_ctx_init()."]
    pub height: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_AVHWFramesContext() {
    assert_eq!(
        ::std::mem::size_of::<AVHWFramesContext>(),
        88usize,
        concat!("Size of: ", stringify!(AVHWFramesContext))
    );
    assert_eq!(
        ::std::mem::align_of::<AVHWFramesContext>(),
        8usize,
        concat!("Alignment of ", stringify!(AVHWFramesContext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWFramesContext>())).av_class as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWFramesContext),
            "::",
            stringify!(av_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWFramesContext>())).internal as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWFramesContext),
            "::",
            stringify!(internal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWFramesContext>())).device_ref as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWFramesContext),
            "::",
            stringify!(device_ref)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWFramesContext>())).device_ctx as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWFramesContext),
            "::",
            stringify!(device_ctx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWFramesContext>())).hwctx as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWFramesContext),
            "::",
            stringify!(hwctx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWFramesContext>())).free as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWFramesContext),
            "::",
            stringify!(free)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWFramesContext>())).user_opaque as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWFramesContext),
            "::",
            stringify!(user_opaque)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWFramesContext>())).pool as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWFramesContext),
            "::",
            stringify!(pool)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVHWFramesContext>())).initial_pool_size as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWFramesContext),
            "::",
            stringify!(initial_pool_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWFramesContext>())).format as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWFramesContext),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWFramesContext>())).sw_format as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWFramesContext),
            "::",
            stringify!(sw_format)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWFramesContext>())).width as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWFramesContext),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWFramesContext>())).height as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWFramesContext),
            "::",
            stringify!(height)
        )
    );
}
extern "C" {
    #[doc = " Look up an AVHWDeviceType by name."]
    #[doc = ""]
    #[doc = " @param name String name of the device type (case-insensitive)."]
    #[doc = " @return The type from enum AVHWDeviceType, or AV_HWDEVICE_TYPE_NONE if"]
    #[doc = "         not found."]
    pub fn av_hwdevice_find_type_by_name(name: *const ::std::os::raw::c_char) -> AVHWDeviceType;
}
extern "C" {
    #[doc = " Get the string name of an AVHWDeviceType."]
    #[doc = ""]
    #[doc = " @param type Type from enum AVHWDeviceType."]
    #[doc = " @return Pointer to a static string containing the name, or NULL if the type"]
    #[doc = "         is not valid."]
    pub fn av_hwdevice_get_type_name(type_: AVHWDeviceType) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Iterate over supported device types."]
    #[doc = ""]
    #[doc = " @param type AV_HWDEVICE_TYPE_NONE initially, then the previous type"]
    #[doc = "             returned by this function in subsequent iterations."]
    #[doc = " @return The next usable device type from enum AVHWDeviceType, or"]
    #[doc = "         AV_HWDEVICE_TYPE_NONE if there are no more."]
    pub fn av_hwdevice_iterate_types(prev: AVHWDeviceType) -> AVHWDeviceType;
}
extern "C" {
    #[doc = " Allocate an AVHWDeviceContext for a given hardware type."]
    #[doc = ""]
    #[doc = " @param type the type of the hardware device to allocate."]
    #[doc = " @return a reference to the newly created AVHWDeviceContext on success or NULL"]
    #[doc = "         on failure."]
    pub fn av_hwdevice_ctx_alloc(type_: AVHWDeviceType) -> *mut AVBufferRef;
}
extern "C" {
    #[doc = " Finalize the device context before use. This function must be called after"]
    #[doc = " the context is filled with all the required information and before it is"]
    #[doc = " used in any way."]
    #[doc = ""]
    #[doc = " @param ref a reference to the AVHWDeviceContext"]
    #[doc = " @return 0 on success, a negative AVERROR code on failure"]
    pub fn av_hwdevice_ctx_init(ref_: *mut AVBufferRef) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Open a device of the specified type and create an AVHWDeviceContext for it."]
    #[doc = ""]
    #[doc = " This is a convenience function intended to cover the simple cases. Callers"]
    #[doc = " who need to fine-tune device creation/management should open the device"]
    #[doc = " manually and then wrap it in an AVHWDeviceContext using"]
    #[doc = " av_hwdevice_ctx_alloc()/av_hwdevice_ctx_init()."]
    #[doc = ""]
    #[doc = " The returned context is already initialized and ready for use, the caller"]
    #[doc = " should not call av_hwdevice_ctx_init() on it. The user_opaque/free fields of"]
    #[doc = " the created AVHWDeviceContext are set by this function and should not be"]
    #[doc = " touched by the caller."]
    #[doc = ""]
    #[doc = " @param device_ctx On success, a reference to the newly-created device context"]
    #[doc = "                   will be written here. The reference is owned by the caller"]
    #[doc = "                   and must be released with av_buffer_unref() when no longer"]
    #[doc = "                   needed. On failure, NULL will be written to this pointer."]
    #[doc = " @param type The type of the device to create."]
    #[doc = " @param device A type-specific string identifying the device to open."]
    #[doc = " @param opts A dictionary of additional (type-specific) options to use in"]
    #[doc = "             opening the device. The dictionary remains owned by the caller."]
    #[doc = " @param flags currently unused"]
    #[doc = ""]
    #[doc = " @return 0 on success, a negative AVERROR code on failure."]
    pub fn av_hwdevice_ctx_create(
        device_ctx: *mut *mut AVBufferRef,
        type_: AVHWDeviceType,
        device: *const ::std::os::raw::c_char,
        opts: *mut AVDictionary,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Create a new device of the specified type from an existing device."]
    #[doc = ""]
    #[doc = " If the source device is a device of the target type or was originally"]
    #[doc = " derived from such a device (possibly through one or more intermediate"]
    #[doc = " devices of other types), then this will return a reference to the"]
    #[doc = " existing device of the same type as is requested."]
    #[doc = ""]
    #[doc = " Otherwise, it will attempt to derive a new device from the given source"]
    #[doc = " device.  If direct derivation to the new type is not implemented, it will"]
    #[doc = " attempt the same derivation from each ancestor of the source device in"]
    #[doc = " turn looking for an implemented derivation method."]
    #[doc = ""]
    #[doc = " @param dst_ctx On success, a reference to the newly-created"]
    #[doc = "                AVHWDeviceContext."]
    #[doc = " @param type    The type of the new device to create."]
    #[doc = " @param src_ctx A reference to an existing AVHWDeviceContext which will be"]
    #[doc = "                used to create the new device."]
    #[doc = " @param flags   Currently unused; should be set to zero."]
    #[doc = " @return        Zero on success, a negative AVERROR code on failure."]
    pub fn av_hwdevice_ctx_create_derived(
        dst_ctx: *mut *mut AVBufferRef,
        type_: AVHWDeviceType,
        src_ctx: *mut AVBufferRef,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Create a new device of the specified type from an existing device."]
    #[doc = ""]
    #[doc = " This function performs the same action as av_hwdevice_ctx_create_derived,"]
    #[doc = " however, it is able to set options for the new device to be derived."]
    #[doc = ""]
    #[doc = " @param dst_ctx On success, a reference to the newly-created"]
    #[doc = "                AVHWDeviceContext."]
    #[doc = " @param type    The type of the new device to create."]
    #[doc = " @param src_ctx A reference to an existing AVHWDeviceContext which will be"]
    #[doc = "                used to create the new device."]
    #[doc = " @param options Options for the new device to create, same format as in"]
    #[doc = "                av_hwdevice_ctx_create."]
    #[doc = " @param flags   Currently unused; should be set to zero."]
    #[doc = " @return        Zero on success, a negative AVERROR code on failure."]
    pub fn av_hwdevice_ctx_create_derived_opts(
        dst_ctx: *mut *mut AVBufferRef,
        type_: AVHWDeviceType,
        src_ctx: *mut AVBufferRef,
        options: *mut AVDictionary,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Allocate an AVHWFramesContext tied to a given device context."]
    #[doc = ""]
    #[doc = " @param device_ctx a reference to a AVHWDeviceContext. This function will make"]
    #[doc = "                   a new reference for internal use, the one passed to the"]
    #[doc = "                   function remains owned by the caller."]
    #[doc = " @return a reference to the newly created AVHWFramesContext on success or NULL"]
    #[doc = "         on failure."]
    pub fn av_hwframe_ctx_alloc(device_ctx: *mut AVBufferRef) -> *mut AVBufferRef;
}
extern "C" {
    #[doc = " Finalize the context before use. This function must be called after the"]
    #[doc = " context is filled with all the required information and before it is attached"]
    #[doc = " to any frames."]
    #[doc = ""]
    #[doc = " @param ref a reference to the AVHWFramesContext"]
    #[doc = " @return 0 on success, a negative AVERROR code on failure"]
    pub fn av_hwframe_ctx_init(ref_: *mut AVBufferRef) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Allocate a new frame attached to the given AVHWFramesContext."]
    #[doc = ""]
    #[doc = " @param hwframe_ctx a reference to an AVHWFramesContext"]
    #[doc = " @param frame an empty (freshly allocated or unreffed) frame to be filled with"]
    #[doc = "              newly allocated buffers."]
    #[doc = " @param flags currently unused, should be set to zero"]
    #[doc = " @return 0 on success, a negative AVERROR code on failure"]
    pub fn av_hwframe_get_buffer(
        hwframe_ctx: *mut AVBufferRef,
        frame: *mut AVFrame,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Copy data to or from a hw surface. At least one of dst/src must have an"]
    #[doc = " AVHWFramesContext attached."]
    #[doc = ""]
    #[doc = " If src has an AVHWFramesContext attached, then the format of dst (if set)"]
    #[doc = " must use one of the formats returned by av_hwframe_transfer_get_formats(src,"]
    #[doc = " AV_HWFRAME_TRANSFER_DIRECTION_FROM)."]
    #[doc = " If dst has an AVHWFramesContext attached, then the format of src must use one"]
    #[doc = " of the formats returned by av_hwframe_transfer_get_formats(dst,"]
    #[doc = " AV_HWFRAME_TRANSFER_DIRECTION_TO)"]
    #[doc = ""]
    #[doc = " dst may be \"clean\" (i.e. with data/buf pointers unset), in which case the"]
    #[doc = " data buffers will be allocated by this function using av_frame_get_buffer()."]
    #[doc = " If dst->format is set, then this format will be used, otherwise (when"]
    #[doc = " dst->format is AV_PIX_FMT_NONE) the first acceptable format will be chosen."]
    #[doc = ""]
    #[doc = " The two frames must have matching allocated dimensions (i.e. equal to"]
    #[doc = " AVHWFramesContext.width/height), since not all device types support"]
    #[doc = " transferring a sub-rectangle of the whole surface. The display dimensions"]
    #[doc = " (i.e. AVFrame.width/height) may be smaller than the allocated dimensions, but"]
    #[doc = " also have to be equal for both frames. When the display dimensions are"]
    #[doc = " smaller than the allocated dimensions, the content of the padding in the"]
    #[doc = " destination frame is unspecified."]
    #[doc = ""]
    #[doc = " @param dst the destination frame. dst is not touched on failure."]
    #[doc = " @param src the source frame."]
    #[doc = " @param flags currently unused, should be set to zero"]
    #[doc = " @return 0 on success, a negative AVERROR error code on failure."]
    pub fn av_hwframe_transfer_data(
        dst: *mut AVFrame,
        src: *const AVFrame,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[doc = " Transfer the data from the queried hw frame."]
pub const AVHWFrameTransferDirection_AV_HWFRAME_TRANSFER_DIRECTION_FROM:
    AVHWFrameTransferDirection = 0;
#[doc = " Transfer the data to the queried hw frame."]
pub const AVHWFrameTransferDirection_AV_HWFRAME_TRANSFER_DIRECTION_TO: AVHWFrameTransferDirection =
    1;
pub type AVHWFrameTransferDirection = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Get a list of possible source or target formats usable in"]
    #[doc = " av_hwframe_transfer_data()."]
    #[doc = ""]
    #[doc = " @param hwframe_ctx the frame context to obtain the information for"]
    #[doc = " @param dir the direction of the transfer"]
    #[doc = " @param formats the pointer to the output format list will be written here."]
    #[doc = "                The list is terminated with AV_PIX_FMT_NONE and must be freed"]
    #[doc = "                by the caller when no longer needed using av_free()."]
    #[doc = "                If this function returns successfully, the format list will"]
    #[doc = "                have at least one item (not counting the terminator)."]
    #[doc = "                On failure, the contents of this pointer are unspecified."]
    #[doc = " @param flags currently unused, should be set to zero"]
    #[doc = " @return 0 on success, a negative AVERROR code on failure."]
    pub fn av_hwframe_transfer_get_formats(
        hwframe_ctx: *mut AVBufferRef,
        dir: AVHWFrameTransferDirection,
        formats: *mut *mut AVPixelFormat,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[doc = " This struct describes the constraints on hardware frames attached to"]
#[doc = " a given device with a hardware-specific configuration.  This is returned"]
#[doc = " by av_hwdevice_get_hwframe_constraints() and must be freed by"]
#[doc = " av_hwframe_constraints_free() after use."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVHWFramesConstraints {
    #[doc = " A list of possible values for format in the hw_frames_ctx,"]
    #[doc = " terminated by AV_PIX_FMT_NONE.  This member will always be filled."]
    pub valid_hw_formats: *mut AVPixelFormat,
    #[doc = " A list of possible values for sw_format in the hw_frames_ctx,"]
    #[doc = " terminated by AV_PIX_FMT_NONE.  Can be NULL if this information is"]
    #[doc = " not known."]
    pub valid_sw_formats: *mut AVPixelFormat,
    #[doc = " The minimum size of frames in this hw_frames_ctx."]
    #[doc = " (Zero if not known.)"]
    pub min_width: ::std::os::raw::c_int,
    pub min_height: ::std::os::raw::c_int,
    #[doc = " The maximum size of frames in this hw_frames_ctx."]
    #[doc = " (INT_MAX if not known / no limit.)"]
    pub max_width: ::std::os::raw::c_int,
    pub max_height: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_AVHWFramesConstraints() {
    assert_eq!(
        ::std::mem::size_of::<AVHWFramesConstraints>(),
        32usize,
        concat!("Size of: ", stringify!(AVHWFramesConstraints))
    );
    assert_eq!(
        ::std::mem::align_of::<AVHWFramesConstraints>(),
        8usize,
        concat!("Alignment of ", stringify!(AVHWFramesConstraints))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVHWFramesConstraints>())).valid_hw_formats as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWFramesConstraints),
            "::",
            stringify!(valid_hw_formats)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVHWFramesConstraints>())).valid_sw_formats as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWFramesConstraints),
            "::",
            stringify!(valid_sw_formats)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWFramesConstraints>())).min_width as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWFramesConstraints),
            "::",
            stringify!(min_width)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVHWFramesConstraints>())).min_height as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWFramesConstraints),
            "::",
            stringify!(min_height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWFramesConstraints>())).max_width as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWFramesConstraints),
            "::",
            stringify!(max_width)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVHWFramesConstraints>())).max_height as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWFramesConstraints),
            "::",
            stringify!(max_height)
        )
    );
}
extern "C" {
    #[doc = " Allocate a HW-specific configuration structure for a given HW device."]
    #[doc = " After use, the user must free all members as required by the specific"]
    #[doc = " hardware structure being used, then free the structure itself with"]
    #[doc = " av_free()."]
    #[doc = ""]
    #[doc = " @param device_ctx a reference to the associated AVHWDeviceContext."]
    #[doc = " @return The newly created HW-specific configuration structure on"]
    #[doc = "         success or NULL on failure."]
    pub fn av_hwdevice_hwconfig_alloc(device_ctx: *mut AVBufferRef) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Get the constraints on HW frames given a device and the HW-specific"]
    #[doc = " configuration to be used with that device.  If no HW-specific"]
    #[doc = " configuration is provided, returns the maximum possible capabilities"]
    #[doc = " of the device."]
    #[doc = ""]
    #[doc = " @param ref a reference to the associated AVHWDeviceContext."]
    #[doc = " @param hwconfig a filled HW-specific configuration structure, or NULL"]
    #[doc = "        to return the maximum possible capabilities of the device."]
    #[doc = " @return AVHWFramesConstraints structure describing the constraints"]
    #[doc = "         on the device, or NULL if not available."]
    pub fn av_hwdevice_get_hwframe_constraints(
        ref_: *mut AVBufferRef,
        hwconfig: *const ::std::os::raw::c_void,
    ) -> *mut AVHWFramesConstraints;
}
extern "C" {
    #[doc = " Free an AVHWFrameConstraints structure."]
    #[doc = ""]
    #[doc = " @param constraints The (filled or unfilled) AVHWFrameConstraints structure."]
    pub fn av_hwframe_constraints_free(constraints: *mut *mut AVHWFramesConstraints);
}
#[doc = " The mapping must be readable."]
pub const AV_HWFRAME_MAP_READ: ::std::os::raw::c_uint = 1;
#[doc = " The mapping must be writeable."]
pub const AV_HWFRAME_MAP_WRITE: ::std::os::raw::c_uint = 2;
#[doc = " The mapped frame will be overwritten completely in subsequent"]
#[doc = " operations, so the current frame data need not be loaded.  Any values"]
#[doc = " which are not overwritten are unspecified."]
pub const AV_HWFRAME_MAP_OVERWRITE: ::std::os::raw::c_uint = 4;
#[doc = " The mapping must be direct.  That is, there must not be any copying in"]
#[doc = " the map or unmap steps.  Note that performance of direct mappings may"]
#[doc = " be much lower than normal memory."]
pub const AV_HWFRAME_MAP_DIRECT: ::std::os::raw::c_uint = 8;
#[doc = " Flags to apply to frame mappings."]
pub type _bindgen_ty_3 = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Map a hardware frame."]
    #[doc = ""]
    #[doc = " This has a number of different possible effects, depending on the format"]
    #[doc = " and origin of the src and dst frames.  On input, src should be a usable"]
    #[doc = " frame with valid buffers and dst should be blank (typically as just created"]
    #[doc = " by av_frame_alloc()).  src should have an associated hwframe context, and"]
    #[doc = " dst may optionally have a format and associated hwframe context."]
    #[doc = ""]
    #[doc = " If src was created by mapping a frame from the hwframe context of dst,"]
    #[doc = " then this function undoes the mapping - dst is replaced by a reference to"]
    #[doc = " the frame that src was originally mapped from."]
    #[doc = ""]
    #[doc = " If both src and dst have an associated hwframe context, then this function"]
    #[doc = " attempts to map the src frame from its hardware context to that of dst and"]
    #[doc = " then fill dst with appropriate data to be usable there.  This will only be"]
    #[doc = " possible if the hwframe contexts and associated devices are compatible -"]
    #[doc = " given compatible devices, av_hwframe_ctx_create_derived() can be used to"]
    #[doc = " create a hwframe context for dst in which mapping should be possible."]
    #[doc = ""]
    #[doc = " If src has a hwframe context but dst does not, then the src frame is"]
    #[doc = " mapped to normal memory and should thereafter be usable as a normal frame."]
    #[doc = " If the format is set on dst, then the mapping will attempt to create dst"]
    #[doc = " with that format and fail if it is not possible.  If format is unset (is"]
    #[doc = " AV_PIX_FMT_NONE) then dst will be mapped with whatever the most appropriate"]
    #[doc = " format to use is (probably the sw_format of the src hwframe context)."]
    #[doc = ""]
    #[doc = " A return value of AVERROR(ENOSYS) indicates that the mapping is not"]
    #[doc = " possible with the given arguments and hwframe setup, while other return"]
    #[doc = " values indicate that it failed somehow."]
    #[doc = ""]
    #[doc = " @param dst Destination frame, to contain the mapping."]
    #[doc = " @param src Source frame, to be mapped."]
    #[doc = " @param flags Some combination of AV_HWFRAME_MAP_* flags."]
    #[doc = " @return Zero on success, negative AVERROR code on failure."]
    pub fn av_hwframe_map(
        dst: *mut AVFrame,
        src: *const AVFrame,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Create and initialise an AVHWFramesContext as a mapping of another existing"]
    #[doc = " AVHWFramesContext on a different device."]
    #[doc = ""]
    #[doc = " av_hwframe_ctx_init() should not be called after this."]
    #[doc = ""]
    #[doc = " @param derived_frame_ctx  On success, a reference to the newly created"]
    #[doc = "                           AVHWFramesContext."]
    #[doc = " @param derived_device_ctx A reference to the device to create the new"]
    #[doc = "                           AVHWFramesContext on."]
    #[doc = " @param source_frame_ctx   A reference to an existing AVHWFramesContext"]
    #[doc = "                           which will be mapped to the derived context."]
    #[doc = " @param flags  Some combination of AV_HWFRAME_MAP_* flags, defining the"]
    #[doc = "               mapping parameters to apply to frames which are allocated"]
    #[doc = "               in the derived device."]
    #[doc = " @return       Zero on success, negative AVERROR code on failure."]
    pub fn av_hwframe_ctx_create_derived(
        derived_frame_ctx: *mut *mut AVBufferRef,
        format: AVPixelFormat,
        derived_device_ctx: *mut AVBufferRef,
        source_frame_ctx: *mut AVBufferRef,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub const AVCodecID_AV_CODEC_ID_NONE: AVCodecID = 0;
pub const AVCodecID_AV_CODEC_ID_MPEG1VIDEO: AVCodecID = 1;
#[doc = "< preferred ID for MPEG-1/2 video decoding"]
pub const AVCodecID_AV_CODEC_ID_MPEG2VIDEO: AVCodecID = 2;
pub const AVCodecID_AV_CODEC_ID_H261: AVCodecID = 3;
pub const AVCodecID_AV_CODEC_ID_H263: AVCodecID = 4;
pub const AVCodecID_AV_CODEC_ID_RV10: AVCodecID = 5;
pub const AVCodecID_AV_CODEC_ID_RV20: AVCodecID = 6;
pub const AVCodecID_AV_CODEC_ID_MJPEG: AVCodecID = 7;
pub const AVCodecID_AV_CODEC_ID_MJPEGB: AVCodecID = 8;
pub const AVCodecID_AV_CODEC_ID_LJPEG: AVCodecID = 9;
pub const AVCodecID_AV_CODEC_ID_SP5X: AVCodecID = 10;
pub const AVCodecID_AV_CODEC_ID_JPEGLS: AVCodecID = 11;
pub const AVCodecID_AV_CODEC_ID_MPEG4: AVCodecID = 12;
pub const AVCodecID_AV_CODEC_ID_RAWVIDEO: AVCodecID = 13;
pub const AVCodecID_AV_CODEC_ID_MSMPEG4V1: AVCodecID = 14;
pub const AVCodecID_AV_CODEC_ID_MSMPEG4V2: AVCodecID = 15;
pub const AVCodecID_AV_CODEC_ID_MSMPEG4V3: AVCodecID = 16;
pub const AVCodecID_AV_CODEC_ID_WMV1: AVCodecID = 17;
pub const AVCodecID_AV_CODEC_ID_WMV2: AVCodecID = 18;
pub const AVCodecID_AV_CODEC_ID_H263P: AVCodecID = 19;
pub const AVCodecID_AV_CODEC_ID_H263I: AVCodecID = 20;
pub const AVCodecID_AV_CODEC_ID_FLV1: AVCodecID = 21;
pub const AVCodecID_AV_CODEC_ID_SVQ1: AVCodecID = 22;
pub const AVCodecID_AV_CODEC_ID_SVQ3: AVCodecID = 23;
pub const AVCodecID_AV_CODEC_ID_DVVIDEO: AVCodecID = 24;
pub const AVCodecID_AV_CODEC_ID_HUFFYUV: AVCodecID = 25;
pub const AVCodecID_AV_CODEC_ID_CYUV: AVCodecID = 26;
pub const AVCodecID_AV_CODEC_ID_H264: AVCodecID = 27;
pub const AVCodecID_AV_CODEC_ID_INDEO3: AVCodecID = 28;
pub const AVCodecID_AV_CODEC_ID_VP3: AVCodecID = 29;
pub const AVCodecID_AV_CODEC_ID_THEORA: AVCodecID = 30;
pub const AVCodecID_AV_CODEC_ID_ASV1: AVCodecID = 31;
pub const AVCodecID_AV_CODEC_ID_ASV2: AVCodecID = 32;
pub const AVCodecID_AV_CODEC_ID_FFV1: AVCodecID = 33;
pub const AVCodecID_AV_CODEC_ID_4XM: AVCodecID = 34;
pub const AVCodecID_AV_CODEC_ID_VCR1: AVCodecID = 35;
pub const AVCodecID_AV_CODEC_ID_CLJR: AVCodecID = 36;
pub const AVCodecID_AV_CODEC_ID_MDEC: AVCodecID = 37;
pub const AVCodecID_AV_CODEC_ID_ROQ: AVCodecID = 38;
pub const AVCodecID_AV_CODEC_ID_INTERPLAY_VIDEO: AVCodecID = 39;
pub const AVCodecID_AV_CODEC_ID_XAN_WC3: AVCodecID = 40;
pub const AVCodecID_AV_CODEC_ID_XAN_WC4: AVCodecID = 41;
pub const AVCodecID_AV_CODEC_ID_RPZA: AVCodecID = 42;
pub const AVCodecID_AV_CODEC_ID_CINEPAK: AVCodecID = 43;
pub const AVCodecID_AV_CODEC_ID_WS_VQA: AVCodecID = 44;
pub const AVCodecID_AV_CODEC_ID_MSRLE: AVCodecID = 45;
pub const AVCodecID_AV_CODEC_ID_MSVIDEO1: AVCodecID = 46;
pub const AVCodecID_AV_CODEC_ID_IDCIN: AVCodecID = 47;
pub const AVCodecID_AV_CODEC_ID_8BPS: AVCodecID = 48;
pub const AVCodecID_AV_CODEC_ID_SMC: AVCodecID = 49;
pub const AVCodecID_AV_CODEC_ID_FLIC: AVCodecID = 50;
pub const AVCodecID_AV_CODEC_ID_TRUEMOTION1: AVCodecID = 51;
pub const AVCodecID_AV_CODEC_ID_VMDVIDEO: AVCodecID = 52;
pub const AVCodecID_AV_CODEC_ID_MSZH: AVCodecID = 53;
pub const AVCodecID_AV_CODEC_ID_ZLIB: AVCodecID = 54;
pub const AVCodecID_AV_CODEC_ID_QTRLE: AVCodecID = 55;
pub const AVCodecID_AV_CODEC_ID_TSCC: AVCodecID = 56;
pub const AVCodecID_AV_CODEC_ID_ULTI: AVCodecID = 57;
pub const AVCodecID_AV_CODEC_ID_QDRAW: AVCodecID = 58;
pub const AVCodecID_AV_CODEC_ID_VIXL: AVCodecID = 59;
pub const AVCodecID_AV_CODEC_ID_QPEG: AVCodecID = 60;
pub const AVCodecID_AV_CODEC_ID_PNG: AVCodecID = 61;
pub const AVCodecID_AV_CODEC_ID_PPM: AVCodecID = 62;
pub const AVCodecID_AV_CODEC_ID_PBM: AVCodecID = 63;
pub const AVCodecID_AV_CODEC_ID_PGM: AVCodecID = 64;
pub const AVCodecID_AV_CODEC_ID_PGMYUV: AVCodecID = 65;
pub const AVCodecID_AV_CODEC_ID_PAM: AVCodecID = 66;
pub const AVCodecID_AV_CODEC_ID_FFVHUFF: AVCodecID = 67;
pub const AVCodecID_AV_CODEC_ID_RV30: AVCodecID = 68;
pub const AVCodecID_AV_CODEC_ID_RV40: AVCodecID = 69;
pub const AVCodecID_AV_CODEC_ID_VC1: AVCodecID = 70;
pub const AVCodecID_AV_CODEC_ID_WMV3: AVCodecID = 71;
pub const AVCodecID_AV_CODEC_ID_LOCO: AVCodecID = 72;
pub const AVCodecID_AV_CODEC_ID_WNV1: AVCodecID = 73;
pub const AVCodecID_AV_CODEC_ID_AASC: AVCodecID = 74;
pub const AVCodecID_AV_CODEC_ID_INDEO2: AVCodecID = 75;
pub const AVCodecID_AV_CODEC_ID_FRAPS: AVCodecID = 76;
pub const AVCodecID_AV_CODEC_ID_TRUEMOTION2: AVCodecID = 77;
pub const AVCodecID_AV_CODEC_ID_BMP: AVCodecID = 78;
pub const AVCodecID_AV_CODEC_ID_CSCD: AVCodecID = 79;
pub const AVCodecID_AV_CODEC_ID_MMVIDEO: AVCodecID = 80;
pub const AVCodecID_AV_CODEC_ID_ZMBV: AVCodecID = 81;
pub const AVCodecID_AV_CODEC_ID_AVS: AVCodecID = 82;
pub const AVCodecID_AV_CODEC_ID_SMACKVIDEO: AVCodecID = 83;
pub const AVCodecID_AV_CODEC_ID_NUV: AVCodecID = 84;
pub const AVCodecID_AV_CODEC_ID_KMVC: AVCodecID = 85;
pub const AVCodecID_AV_CODEC_ID_FLASHSV: AVCodecID = 86;
pub const AVCodecID_AV_CODEC_ID_CAVS: AVCodecID = 87;
pub const AVCodecID_AV_CODEC_ID_JPEG2000: AVCodecID = 88;
pub const AVCodecID_AV_CODEC_ID_VMNC: AVCodecID = 89;
pub const AVCodecID_AV_CODEC_ID_VP5: AVCodecID = 90;
pub const AVCodecID_AV_CODEC_ID_VP6: AVCodecID = 91;
pub const AVCodecID_AV_CODEC_ID_VP6F: AVCodecID = 92;
pub const AVCodecID_AV_CODEC_ID_TARGA: AVCodecID = 93;
pub const AVCodecID_AV_CODEC_ID_DSICINVIDEO: AVCodecID = 94;
pub const AVCodecID_AV_CODEC_ID_TIERTEXSEQVIDEO: AVCodecID = 95;
pub const AVCodecID_AV_CODEC_ID_TIFF: AVCodecID = 96;
pub const AVCodecID_AV_CODEC_ID_GIF: AVCodecID = 97;
pub const AVCodecID_AV_CODEC_ID_DXA: AVCodecID = 98;
pub const AVCodecID_AV_CODEC_ID_DNXHD: AVCodecID = 99;
pub const AVCodecID_AV_CODEC_ID_THP: AVCodecID = 100;
pub const AVCodecID_AV_CODEC_ID_SGI: AVCodecID = 101;
pub const AVCodecID_AV_CODEC_ID_C93: AVCodecID = 102;
pub const AVCodecID_AV_CODEC_ID_BETHSOFTVID: AVCodecID = 103;
pub const AVCodecID_AV_CODEC_ID_PTX: AVCodecID = 104;
pub const AVCodecID_AV_CODEC_ID_TXD: AVCodecID = 105;
pub const AVCodecID_AV_CODEC_ID_VP6A: AVCodecID = 106;
pub const AVCodecID_AV_CODEC_ID_AMV: AVCodecID = 107;
pub const AVCodecID_AV_CODEC_ID_VB: AVCodecID = 108;
pub const AVCodecID_AV_CODEC_ID_PCX: AVCodecID = 109;
pub const AVCodecID_AV_CODEC_ID_SUNRAST: AVCodecID = 110;
pub const AVCodecID_AV_CODEC_ID_INDEO4: AVCodecID = 111;
pub const AVCodecID_AV_CODEC_ID_INDEO5: AVCodecID = 112;
pub const AVCodecID_AV_CODEC_ID_MIMIC: AVCodecID = 113;
pub const AVCodecID_AV_CODEC_ID_RL2: AVCodecID = 114;
pub const AVCodecID_AV_CODEC_ID_ESCAPE124: AVCodecID = 115;
pub const AVCodecID_AV_CODEC_ID_DIRAC: AVCodecID = 116;
pub const AVCodecID_AV_CODEC_ID_BFI: AVCodecID = 117;
pub const AVCodecID_AV_CODEC_ID_CMV: AVCodecID = 118;
pub const AVCodecID_AV_CODEC_ID_MOTIONPIXELS: AVCodecID = 119;
pub const AVCodecID_AV_CODEC_ID_TGV: AVCodecID = 120;
pub const AVCodecID_AV_CODEC_ID_TGQ: AVCodecID = 121;
pub const AVCodecID_AV_CODEC_ID_TQI: AVCodecID = 122;
pub const AVCodecID_AV_CODEC_ID_AURA: AVCodecID = 123;
pub const AVCodecID_AV_CODEC_ID_AURA2: AVCodecID = 124;
pub const AVCodecID_AV_CODEC_ID_V210X: AVCodecID = 125;
pub const AVCodecID_AV_CODEC_ID_TMV: AVCodecID = 126;
pub const AVCodecID_AV_CODEC_ID_V210: AVCodecID = 127;
pub const AVCodecID_AV_CODEC_ID_DPX: AVCodecID = 128;
pub const AVCodecID_AV_CODEC_ID_MAD: AVCodecID = 129;
pub const AVCodecID_AV_CODEC_ID_FRWU: AVCodecID = 130;
pub const AVCodecID_AV_CODEC_ID_FLASHSV2: AVCodecID = 131;
pub const AVCodecID_AV_CODEC_ID_CDGRAPHICS: AVCodecID = 132;
pub const AVCodecID_AV_CODEC_ID_R210: AVCodecID = 133;
pub const AVCodecID_AV_CODEC_ID_ANM: AVCodecID = 134;
pub const AVCodecID_AV_CODEC_ID_BINKVIDEO: AVCodecID = 135;
pub const AVCodecID_AV_CODEC_ID_IFF_ILBM: AVCodecID = 136;
pub const AVCodecID_AV_CODEC_ID_KGV1: AVCodecID = 137;
pub const AVCodecID_AV_CODEC_ID_YOP: AVCodecID = 138;
pub const AVCodecID_AV_CODEC_ID_VP8: AVCodecID = 139;
pub const AVCodecID_AV_CODEC_ID_PICTOR: AVCodecID = 140;
pub const AVCodecID_AV_CODEC_ID_ANSI: AVCodecID = 141;
pub const AVCodecID_AV_CODEC_ID_A64_MULTI: AVCodecID = 142;
pub const AVCodecID_AV_CODEC_ID_A64_MULTI5: AVCodecID = 143;
pub const AVCodecID_AV_CODEC_ID_R10K: AVCodecID = 144;
pub const AVCodecID_AV_CODEC_ID_MXPEG: AVCodecID = 145;
pub const AVCodecID_AV_CODEC_ID_LAGARITH: AVCodecID = 146;
pub const AVCodecID_AV_CODEC_ID_PRORES: AVCodecID = 147;
pub const AVCodecID_AV_CODEC_ID_JV: AVCodecID = 148;
pub const AVCodecID_AV_CODEC_ID_DFA: AVCodecID = 149;
pub const AVCodecID_AV_CODEC_ID_WMV3IMAGE: AVCodecID = 150;
pub const AVCodecID_AV_CODEC_ID_VC1IMAGE: AVCodecID = 151;
pub const AVCodecID_AV_CODEC_ID_UTVIDEO: AVCodecID = 152;
pub const AVCodecID_AV_CODEC_ID_BMV_VIDEO: AVCodecID = 153;
pub const AVCodecID_AV_CODEC_ID_VBLE: AVCodecID = 154;
pub const AVCodecID_AV_CODEC_ID_DXTORY: AVCodecID = 155;
pub const AVCodecID_AV_CODEC_ID_V410: AVCodecID = 156;
pub const AVCodecID_AV_CODEC_ID_XWD: AVCodecID = 157;
pub const AVCodecID_AV_CODEC_ID_CDXL: AVCodecID = 158;
pub const AVCodecID_AV_CODEC_ID_XBM: AVCodecID = 159;
pub const AVCodecID_AV_CODEC_ID_ZEROCODEC: AVCodecID = 160;
pub const AVCodecID_AV_CODEC_ID_MSS1: AVCodecID = 161;
pub const AVCodecID_AV_CODEC_ID_MSA1: AVCodecID = 162;
pub const AVCodecID_AV_CODEC_ID_TSCC2: AVCodecID = 163;
pub const AVCodecID_AV_CODEC_ID_MTS2: AVCodecID = 164;
pub const AVCodecID_AV_CODEC_ID_CLLC: AVCodecID = 165;
pub const AVCodecID_AV_CODEC_ID_MSS2: AVCodecID = 166;
pub const AVCodecID_AV_CODEC_ID_VP9: AVCodecID = 167;
pub const AVCodecID_AV_CODEC_ID_AIC: AVCodecID = 168;
pub const AVCodecID_AV_CODEC_ID_ESCAPE130: AVCodecID = 169;
pub const AVCodecID_AV_CODEC_ID_G2M: AVCodecID = 170;
pub const AVCodecID_AV_CODEC_ID_WEBP: AVCodecID = 171;
pub const AVCodecID_AV_CODEC_ID_HNM4_VIDEO: AVCodecID = 172;
pub const AVCodecID_AV_CODEC_ID_HEVC: AVCodecID = 173;
pub const AVCodecID_AV_CODEC_ID_FIC: AVCodecID = 174;
pub const AVCodecID_AV_CODEC_ID_ALIAS_PIX: AVCodecID = 175;
pub const AVCodecID_AV_CODEC_ID_BRENDER_PIX: AVCodecID = 176;
pub const AVCodecID_AV_CODEC_ID_PAF_VIDEO: AVCodecID = 177;
pub const AVCodecID_AV_CODEC_ID_EXR: AVCodecID = 178;
pub const AVCodecID_AV_CODEC_ID_VP7: AVCodecID = 179;
pub const AVCodecID_AV_CODEC_ID_SANM: AVCodecID = 180;
pub const AVCodecID_AV_CODEC_ID_SGIRLE: AVCodecID = 181;
pub const AVCodecID_AV_CODEC_ID_MVC1: AVCodecID = 182;
pub const AVCodecID_AV_CODEC_ID_MVC2: AVCodecID = 183;
pub const AVCodecID_AV_CODEC_ID_HQX: AVCodecID = 184;
pub const AVCodecID_AV_CODEC_ID_TDSC: AVCodecID = 185;
pub const AVCodecID_AV_CODEC_ID_HQ_HQA: AVCodecID = 186;
pub const AVCodecID_AV_CODEC_ID_HAP: AVCodecID = 187;
pub const AVCodecID_AV_CODEC_ID_DDS: AVCodecID = 188;
pub const AVCodecID_AV_CODEC_ID_DXV: AVCodecID = 189;
pub const AVCodecID_AV_CODEC_ID_SCREENPRESSO: AVCodecID = 190;
pub const AVCodecID_AV_CODEC_ID_RSCC: AVCodecID = 191;
pub const AVCodecID_AV_CODEC_ID_AVS2: AVCodecID = 192;
pub const AVCodecID_AV_CODEC_ID_PGX: AVCodecID = 193;
pub const AVCodecID_AV_CODEC_ID_AVS3: AVCodecID = 194;
pub const AVCodecID_AV_CODEC_ID_MSP2: AVCodecID = 195;
pub const AVCodecID_AV_CODEC_ID_VVC: AVCodecID = 196;
pub const AVCodecID_AV_CODEC_ID_Y41P: AVCodecID = 197;
pub const AVCodecID_AV_CODEC_ID_AVRP: AVCodecID = 198;
pub const AVCodecID_AV_CODEC_ID_012V: AVCodecID = 199;
pub const AVCodecID_AV_CODEC_ID_AVUI: AVCodecID = 200;
pub const AVCodecID_AV_CODEC_ID_AYUV: AVCodecID = 201;
pub const AVCodecID_AV_CODEC_ID_TARGA_Y216: AVCodecID = 202;
pub const AVCodecID_AV_CODEC_ID_V308: AVCodecID = 203;
pub const AVCodecID_AV_CODEC_ID_V408: AVCodecID = 204;
pub const AVCodecID_AV_CODEC_ID_YUV4: AVCodecID = 205;
pub const AVCodecID_AV_CODEC_ID_AVRN: AVCodecID = 206;
pub const AVCodecID_AV_CODEC_ID_CPIA: AVCodecID = 207;
pub const AVCodecID_AV_CODEC_ID_XFACE: AVCodecID = 208;
pub const AVCodecID_AV_CODEC_ID_SNOW: AVCodecID = 209;
pub const AVCodecID_AV_CODEC_ID_SMVJPEG: AVCodecID = 210;
pub const AVCodecID_AV_CODEC_ID_APNG: AVCodecID = 211;
pub const AVCodecID_AV_CODEC_ID_DAALA: AVCodecID = 212;
pub const AVCodecID_AV_CODEC_ID_CFHD: AVCodecID = 213;
pub const AVCodecID_AV_CODEC_ID_TRUEMOTION2RT: AVCodecID = 214;
pub const AVCodecID_AV_CODEC_ID_M101: AVCodecID = 215;
pub const AVCodecID_AV_CODEC_ID_MAGICYUV: AVCodecID = 216;
pub const AVCodecID_AV_CODEC_ID_SHEERVIDEO: AVCodecID = 217;
pub const AVCodecID_AV_CODEC_ID_YLC: AVCodecID = 218;
pub const AVCodecID_AV_CODEC_ID_PSD: AVCodecID = 219;
pub const AVCodecID_AV_CODEC_ID_PIXLET: AVCodecID = 220;
pub const AVCodecID_AV_CODEC_ID_SPEEDHQ: AVCodecID = 221;
pub const AVCodecID_AV_CODEC_ID_FMVC: AVCodecID = 222;
pub const AVCodecID_AV_CODEC_ID_SCPR: AVCodecID = 223;
pub const AVCodecID_AV_CODEC_ID_CLEARVIDEO: AVCodecID = 224;
pub const AVCodecID_AV_CODEC_ID_XPM: AVCodecID = 225;
pub const AVCodecID_AV_CODEC_ID_AV1: AVCodecID = 226;
pub const AVCodecID_AV_CODEC_ID_BITPACKED: AVCodecID = 227;
pub const AVCodecID_AV_CODEC_ID_MSCC: AVCodecID = 228;
pub const AVCodecID_AV_CODEC_ID_SRGC: AVCodecID = 229;
pub const AVCodecID_AV_CODEC_ID_SVG: AVCodecID = 230;
pub const AVCodecID_AV_CODEC_ID_GDV: AVCodecID = 231;
pub const AVCodecID_AV_CODEC_ID_FITS: AVCodecID = 232;
pub const AVCodecID_AV_CODEC_ID_IMM4: AVCodecID = 233;
pub const AVCodecID_AV_CODEC_ID_PROSUMER: AVCodecID = 234;
pub const AVCodecID_AV_CODEC_ID_MWSC: AVCodecID = 235;
pub const AVCodecID_AV_CODEC_ID_WCMV: AVCodecID = 236;
pub const AVCodecID_AV_CODEC_ID_RASC: AVCodecID = 237;
pub const AVCodecID_AV_CODEC_ID_HYMT: AVCodecID = 238;
pub const AVCodecID_AV_CODEC_ID_ARBC: AVCodecID = 239;
pub const AVCodecID_AV_CODEC_ID_AGM: AVCodecID = 240;
pub const AVCodecID_AV_CODEC_ID_LSCR: AVCodecID = 241;
pub const AVCodecID_AV_CODEC_ID_VP4: AVCodecID = 242;
pub const AVCodecID_AV_CODEC_ID_IMM5: AVCodecID = 243;
pub const AVCodecID_AV_CODEC_ID_MVDV: AVCodecID = 244;
pub const AVCodecID_AV_CODEC_ID_MVHA: AVCodecID = 245;
pub const AVCodecID_AV_CODEC_ID_CDTOONS: AVCodecID = 246;
pub const AVCodecID_AV_CODEC_ID_MV30: AVCodecID = 247;
pub const AVCodecID_AV_CODEC_ID_NOTCHLC: AVCodecID = 248;
pub const AVCodecID_AV_CODEC_ID_PFM: AVCodecID = 249;
pub const AVCodecID_AV_CODEC_ID_MOBICLIP: AVCodecID = 250;
pub const AVCodecID_AV_CODEC_ID_PHOTOCD: AVCodecID = 251;
pub const AVCodecID_AV_CODEC_ID_IPU: AVCodecID = 252;
pub const AVCodecID_AV_CODEC_ID_ARGO: AVCodecID = 253;
pub const AVCodecID_AV_CODEC_ID_CRI: AVCodecID = 254;
pub const AVCodecID_AV_CODEC_ID_SIMBIOSIS_IMX: AVCodecID = 255;
pub const AVCodecID_AV_CODEC_ID_SGA_VIDEO: AVCodecID = 256;
#[doc = "< A dummy id pointing at the start of audio codecs"]
pub const AVCodecID_AV_CODEC_ID_FIRST_AUDIO: AVCodecID = 65536;
pub const AVCodecID_AV_CODEC_ID_PCM_S16LE: AVCodecID = 65536;
pub const AVCodecID_AV_CODEC_ID_PCM_S16BE: AVCodecID = 65537;
pub const AVCodecID_AV_CODEC_ID_PCM_U16LE: AVCodecID = 65538;
pub const AVCodecID_AV_CODEC_ID_PCM_U16BE: AVCodecID = 65539;
pub const AVCodecID_AV_CODEC_ID_PCM_S8: AVCodecID = 65540;
pub const AVCodecID_AV_CODEC_ID_PCM_U8: AVCodecID = 65541;
pub const AVCodecID_AV_CODEC_ID_PCM_MULAW: AVCodecID = 65542;
pub const AVCodecID_AV_CODEC_ID_PCM_ALAW: AVCodecID = 65543;
pub const AVCodecID_AV_CODEC_ID_PCM_S32LE: AVCodecID = 65544;
pub const AVCodecID_AV_CODEC_ID_PCM_S32BE: AVCodecID = 65545;
pub const AVCodecID_AV_CODEC_ID_PCM_U32LE: AVCodecID = 65546;
pub const AVCodecID_AV_CODEC_ID_PCM_U32BE: AVCodecID = 65547;
pub const AVCodecID_AV_CODEC_ID_PCM_S24LE: AVCodecID = 65548;
pub const AVCodecID_AV_CODEC_ID_PCM_S24BE: AVCodecID = 65549;
pub const AVCodecID_AV_CODEC_ID_PCM_U24LE: AVCodecID = 65550;
pub const AVCodecID_AV_CODEC_ID_PCM_U24BE: AVCodecID = 65551;
pub const AVCodecID_AV_CODEC_ID_PCM_S24DAUD: AVCodecID = 65552;
pub const AVCodecID_AV_CODEC_ID_PCM_ZORK: AVCodecID = 65553;
pub const AVCodecID_AV_CODEC_ID_PCM_S16LE_PLANAR: AVCodecID = 65554;
pub const AVCodecID_AV_CODEC_ID_PCM_DVD: AVCodecID = 65555;
pub const AVCodecID_AV_CODEC_ID_PCM_F32BE: AVCodecID = 65556;
pub const AVCodecID_AV_CODEC_ID_PCM_F32LE: AVCodecID = 65557;
pub const AVCodecID_AV_CODEC_ID_PCM_F64BE: AVCodecID = 65558;
pub const AVCodecID_AV_CODEC_ID_PCM_F64LE: AVCodecID = 65559;
pub const AVCodecID_AV_CODEC_ID_PCM_BLURAY: AVCodecID = 65560;
pub const AVCodecID_AV_CODEC_ID_PCM_LXF: AVCodecID = 65561;
pub const AVCodecID_AV_CODEC_ID_S302M: AVCodecID = 65562;
pub const AVCodecID_AV_CODEC_ID_PCM_S8_PLANAR: AVCodecID = 65563;
pub const AVCodecID_AV_CODEC_ID_PCM_S24LE_PLANAR: AVCodecID = 65564;
pub const AVCodecID_AV_CODEC_ID_PCM_S32LE_PLANAR: AVCodecID = 65565;
pub const AVCodecID_AV_CODEC_ID_PCM_S16BE_PLANAR: AVCodecID = 65566;
pub const AVCodecID_AV_CODEC_ID_PCM_S64LE: AVCodecID = 65567;
pub const AVCodecID_AV_CODEC_ID_PCM_S64BE: AVCodecID = 65568;
pub const AVCodecID_AV_CODEC_ID_PCM_F16LE: AVCodecID = 65569;
pub const AVCodecID_AV_CODEC_ID_PCM_F24LE: AVCodecID = 65570;
pub const AVCodecID_AV_CODEC_ID_PCM_VIDC: AVCodecID = 65571;
pub const AVCodecID_AV_CODEC_ID_PCM_SGA: AVCodecID = 65572;
pub const AVCodecID_AV_CODEC_ID_ADPCM_IMA_QT: AVCodecID = 69632;
pub const AVCodecID_AV_CODEC_ID_ADPCM_IMA_WAV: AVCodecID = 69633;
pub const AVCodecID_AV_CODEC_ID_ADPCM_IMA_DK3: AVCodecID = 69634;
pub const AVCodecID_AV_CODEC_ID_ADPCM_IMA_DK4: AVCodecID = 69635;
pub const AVCodecID_AV_CODEC_ID_ADPCM_IMA_WS: AVCodecID = 69636;
pub const AVCodecID_AV_CODEC_ID_ADPCM_IMA_SMJPEG: AVCodecID = 69637;
pub const AVCodecID_AV_CODEC_ID_ADPCM_MS: AVCodecID = 69638;
pub const AVCodecID_AV_CODEC_ID_ADPCM_4XM: AVCodecID = 69639;
pub const AVCodecID_AV_CODEC_ID_ADPCM_XA: AVCodecID = 69640;
pub const AVCodecID_AV_CODEC_ID_ADPCM_ADX: AVCodecID = 69641;
pub const AVCodecID_AV_CODEC_ID_ADPCM_EA: AVCodecID = 69642;
pub const AVCodecID_AV_CODEC_ID_ADPCM_G726: AVCodecID = 69643;
pub const AVCodecID_AV_CODEC_ID_ADPCM_CT: AVCodecID = 69644;
pub const AVCodecID_AV_CODEC_ID_ADPCM_SWF: AVCodecID = 69645;
pub const AVCodecID_AV_CODEC_ID_ADPCM_YAMAHA: AVCodecID = 69646;
pub const AVCodecID_AV_CODEC_ID_ADPCM_SBPRO_4: AVCodecID = 69647;
pub const AVCodecID_AV_CODEC_ID_ADPCM_SBPRO_3: AVCodecID = 69648;
pub const AVCodecID_AV_CODEC_ID_ADPCM_SBPRO_2: AVCodecID = 69649;
pub const AVCodecID_AV_CODEC_ID_ADPCM_THP: AVCodecID = 69650;
pub const AVCodecID_AV_CODEC_ID_ADPCM_IMA_AMV: AVCodecID = 69651;
pub const AVCodecID_AV_CODEC_ID_ADPCM_EA_R1: AVCodecID = 69652;
pub const AVCodecID_AV_CODEC_ID_ADPCM_EA_R3: AVCodecID = 69653;
pub const AVCodecID_AV_CODEC_ID_ADPCM_EA_R2: AVCodecID = 69654;
pub const AVCodecID_AV_CODEC_ID_ADPCM_IMA_EA_SEAD: AVCodecID = 69655;
pub const AVCodecID_AV_CODEC_ID_ADPCM_IMA_EA_EACS: AVCodecID = 69656;
pub const AVCodecID_AV_CODEC_ID_ADPCM_EA_XAS: AVCodecID = 69657;
pub const AVCodecID_AV_CODEC_ID_ADPCM_EA_MAXIS_XA: AVCodecID = 69658;
pub const AVCodecID_AV_CODEC_ID_ADPCM_IMA_ISS: AVCodecID = 69659;
pub const AVCodecID_AV_CODEC_ID_ADPCM_G722: AVCodecID = 69660;
pub const AVCodecID_AV_CODEC_ID_ADPCM_IMA_APC: AVCodecID = 69661;
pub const AVCodecID_AV_CODEC_ID_ADPCM_VIMA: AVCodecID = 69662;
pub const AVCodecID_AV_CODEC_ID_ADPCM_AFC: AVCodecID = 69663;
pub const AVCodecID_AV_CODEC_ID_ADPCM_IMA_OKI: AVCodecID = 69664;
pub const AVCodecID_AV_CODEC_ID_ADPCM_DTK: AVCodecID = 69665;
pub const AVCodecID_AV_CODEC_ID_ADPCM_IMA_RAD: AVCodecID = 69666;
pub const AVCodecID_AV_CODEC_ID_ADPCM_G726LE: AVCodecID = 69667;
pub const AVCodecID_AV_CODEC_ID_ADPCM_THP_LE: AVCodecID = 69668;
pub const AVCodecID_AV_CODEC_ID_ADPCM_PSX: AVCodecID = 69669;
pub const AVCodecID_AV_CODEC_ID_ADPCM_AICA: AVCodecID = 69670;
pub const AVCodecID_AV_CODEC_ID_ADPCM_IMA_DAT4: AVCodecID = 69671;
pub const AVCodecID_AV_CODEC_ID_ADPCM_MTAF: AVCodecID = 69672;
pub const AVCodecID_AV_CODEC_ID_ADPCM_AGM: AVCodecID = 69673;
pub const AVCodecID_AV_CODEC_ID_ADPCM_ARGO: AVCodecID = 69674;
pub const AVCodecID_AV_CODEC_ID_ADPCM_IMA_SSI: AVCodecID = 69675;
pub const AVCodecID_AV_CODEC_ID_ADPCM_ZORK: AVCodecID = 69676;
pub const AVCodecID_AV_CODEC_ID_ADPCM_IMA_APM: AVCodecID = 69677;
pub const AVCodecID_AV_CODEC_ID_ADPCM_IMA_ALP: AVCodecID = 69678;
pub const AVCodecID_AV_CODEC_ID_ADPCM_IMA_MTF: AVCodecID = 69679;
pub const AVCodecID_AV_CODEC_ID_ADPCM_IMA_CUNNING: AVCodecID = 69680;
pub const AVCodecID_AV_CODEC_ID_ADPCM_IMA_MOFLEX: AVCodecID = 69681;
pub const AVCodecID_AV_CODEC_ID_ADPCM_IMA_ACORN: AVCodecID = 69682;
pub const AVCodecID_AV_CODEC_ID_AMR_NB: AVCodecID = 73728;
pub const AVCodecID_AV_CODEC_ID_AMR_WB: AVCodecID = 73729;
pub const AVCodecID_AV_CODEC_ID_RA_144: AVCodecID = 77824;
pub const AVCodecID_AV_CODEC_ID_RA_288: AVCodecID = 77825;
pub const AVCodecID_AV_CODEC_ID_ROQ_DPCM: AVCodecID = 81920;
pub const AVCodecID_AV_CODEC_ID_INTERPLAY_DPCM: AVCodecID = 81921;
pub const AVCodecID_AV_CODEC_ID_XAN_DPCM: AVCodecID = 81922;
pub const AVCodecID_AV_CODEC_ID_SOL_DPCM: AVCodecID = 81923;
pub const AVCodecID_AV_CODEC_ID_SDX2_DPCM: AVCodecID = 81924;
pub const AVCodecID_AV_CODEC_ID_GREMLIN_DPCM: AVCodecID = 81925;
pub const AVCodecID_AV_CODEC_ID_DERF_DPCM: AVCodecID = 81926;
pub const AVCodecID_AV_CODEC_ID_MP2: AVCodecID = 86016;
#[doc = "< preferred ID for decoding MPEG audio layer 1, 2 or 3"]
pub const AVCodecID_AV_CODEC_ID_MP3: AVCodecID = 86017;
pub const AVCodecID_AV_CODEC_ID_AAC: AVCodecID = 86018;
pub const AVCodecID_AV_CODEC_ID_AC3: AVCodecID = 86019;
pub const AVCodecID_AV_CODEC_ID_DTS: AVCodecID = 86020;
pub const AVCodecID_AV_CODEC_ID_VORBIS: AVCodecID = 86021;
pub const AVCodecID_AV_CODEC_ID_DVAUDIO: AVCodecID = 86022;
pub const AVCodecID_AV_CODEC_ID_WMAV1: AVCodecID = 86023;
pub const AVCodecID_AV_CODEC_ID_WMAV2: AVCodecID = 86024;
pub const AVCodecID_AV_CODEC_ID_MACE3: AVCodecID = 86025;
pub const AVCodecID_AV_CODEC_ID_MACE6: AVCodecID = 86026;
pub const AVCodecID_AV_CODEC_ID_VMDAUDIO: AVCodecID = 86027;
pub const AVCodecID_AV_CODEC_ID_FLAC: AVCodecID = 86028;
pub const AVCodecID_AV_CODEC_ID_MP3ADU: AVCodecID = 86029;
pub const AVCodecID_AV_CODEC_ID_MP3ON4: AVCodecID = 86030;
pub const AVCodecID_AV_CODEC_ID_SHORTEN: AVCodecID = 86031;
pub const AVCodecID_AV_CODEC_ID_ALAC: AVCodecID = 86032;
pub const AVCodecID_AV_CODEC_ID_WESTWOOD_SND1: AVCodecID = 86033;
#[doc = "< as in Berlin toast format"]
pub const AVCodecID_AV_CODEC_ID_GSM: AVCodecID = 86034;
pub const AVCodecID_AV_CODEC_ID_QDM2: AVCodecID = 86035;
pub const AVCodecID_AV_CODEC_ID_COOK: AVCodecID = 86036;
pub const AVCodecID_AV_CODEC_ID_TRUESPEECH: AVCodecID = 86037;
pub const AVCodecID_AV_CODEC_ID_TTA: AVCodecID = 86038;
pub const AVCodecID_AV_CODEC_ID_SMACKAUDIO: AVCodecID = 86039;
pub const AVCodecID_AV_CODEC_ID_QCELP: AVCodecID = 86040;
pub const AVCodecID_AV_CODEC_ID_WAVPACK: AVCodecID = 86041;
pub const AVCodecID_AV_CODEC_ID_DSICINAUDIO: AVCodecID = 86042;
pub const AVCodecID_AV_CODEC_ID_IMC: AVCodecID = 86043;
pub const AVCodecID_AV_CODEC_ID_MUSEPACK7: AVCodecID = 86044;
pub const AVCodecID_AV_CODEC_ID_MLP: AVCodecID = 86045;
pub const AVCodecID_AV_CODEC_ID_GSM_MS: AVCodecID = 86046;
pub const AVCodecID_AV_CODEC_ID_ATRAC3: AVCodecID = 86047;
pub const AVCodecID_AV_CODEC_ID_APE: AVCodecID = 86048;
pub const AVCodecID_AV_CODEC_ID_NELLYMOSER: AVCodecID = 86049;
pub const AVCodecID_AV_CODEC_ID_MUSEPACK8: AVCodecID = 86050;
pub const AVCodecID_AV_CODEC_ID_SPEEX: AVCodecID = 86051;
pub const AVCodecID_AV_CODEC_ID_WMAVOICE: AVCodecID = 86052;
pub const AVCodecID_AV_CODEC_ID_WMAPRO: AVCodecID = 86053;
pub const AVCodecID_AV_CODEC_ID_WMALOSSLESS: AVCodecID = 86054;
pub const AVCodecID_AV_CODEC_ID_ATRAC3P: AVCodecID = 86055;
pub const AVCodecID_AV_CODEC_ID_EAC3: AVCodecID = 86056;
pub const AVCodecID_AV_CODEC_ID_SIPR: AVCodecID = 86057;
pub const AVCodecID_AV_CODEC_ID_MP1: AVCodecID = 86058;
pub const AVCodecID_AV_CODEC_ID_TWINVQ: AVCodecID = 86059;
pub const AVCodecID_AV_CODEC_ID_TRUEHD: AVCodecID = 86060;
pub const AVCodecID_AV_CODEC_ID_MP4ALS: AVCodecID = 86061;
pub const AVCodecID_AV_CODEC_ID_ATRAC1: AVCodecID = 86062;
pub const AVCodecID_AV_CODEC_ID_BINKAUDIO_RDFT: AVCodecID = 86063;
pub const AVCodecID_AV_CODEC_ID_BINKAUDIO_DCT: AVCodecID = 86064;
pub const AVCodecID_AV_CODEC_ID_AAC_LATM: AVCodecID = 86065;
pub const AVCodecID_AV_CODEC_ID_QDMC: AVCodecID = 86066;
pub const AVCodecID_AV_CODEC_ID_CELT: AVCodecID = 86067;
pub const AVCodecID_AV_CODEC_ID_G723_1: AVCodecID = 86068;
pub const AVCodecID_AV_CODEC_ID_G729: AVCodecID = 86069;
pub const AVCodecID_AV_CODEC_ID_8SVX_EXP: AVCodecID = 86070;
pub const AVCodecID_AV_CODEC_ID_8SVX_FIB: AVCodecID = 86071;
pub const AVCodecID_AV_CODEC_ID_BMV_AUDIO: AVCodecID = 86072;
pub const AVCodecID_AV_CODEC_ID_RALF: AVCodecID = 86073;
pub const AVCodecID_AV_CODEC_ID_IAC: AVCodecID = 86074;
pub const AVCodecID_AV_CODEC_ID_ILBC: AVCodecID = 86075;
pub const AVCodecID_AV_CODEC_ID_OPUS: AVCodecID = 86076;
pub const AVCodecID_AV_CODEC_ID_COMFORT_NOISE: AVCodecID = 86077;
pub const AVCodecID_AV_CODEC_ID_TAK: AVCodecID = 86078;
pub const AVCodecID_AV_CODEC_ID_METASOUND: AVCodecID = 86079;
pub const AVCodecID_AV_CODEC_ID_PAF_AUDIO: AVCodecID = 86080;
pub const AVCodecID_AV_CODEC_ID_ON2AVC: AVCodecID = 86081;
pub const AVCodecID_AV_CODEC_ID_DSS_SP: AVCodecID = 86082;
pub const AVCodecID_AV_CODEC_ID_CODEC2: AVCodecID = 86083;
pub const AVCodecID_AV_CODEC_ID_FFWAVESYNTH: AVCodecID = 86084;
pub const AVCodecID_AV_CODEC_ID_SONIC: AVCodecID = 86085;
pub const AVCodecID_AV_CODEC_ID_SONIC_LS: AVCodecID = 86086;
pub const AVCodecID_AV_CODEC_ID_EVRC: AVCodecID = 86087;
pub const AVCodecID_AV_CODEC_ID_SMV: AVCodecID = 86088;
pub const AVCodecID_AV_CODEC_ID_DSD_LSBF: AVCodecID = 86089;
pub const AVCodecID_AV_CODEC_ID_DSD_MSBF: AVCodecID = 86090;
pub const AVCodecID_AV_CODEC_ID_DSD_LSBF_PLANAR: AVCodecID = 86091;
pub const AVCodecID_AV_CODEC_ID_DSD_MSBF_PLANAR: AVCodecID = 86092;
pub const AVCodecID_AV_CODEC_ID_4GV: AVCodecID = 86093;
pub const AVCodecID_AV_CODEC_ID_INTERPLAY_ACM: AVCodecID = 86094;
pub const AVCodecID_AV_CODEC_ID_XMA1: AVCodecID = 86095;
pub const AVCodecID_AV_CODEC_ID_XMA2: AVCodecID = 86096;
pub const AVCodecID_AV_CODEC_ID_DST: AVCodecID = 86097;
pub const AVCodecID_AV_CODEC_ID_ATRAC3AL: AVCodecID = 86098;
pub const AVCodecID_AV_CODEC_ID_ATRAC3PAL: AVCodecID = 86099;
pub const AVCodecID_AV_CODEC_ID_DOLBY_E: AVCodecID = 86100;
pub const AVCodecID_AV_CODEC_ID_APTX: AVCodecID = 86101;
pub const AVCodecID_AV_CODEC_ID_APTX_HD: AVCodecID = 86102;
pub const AVCodecID_AV_CODEC_ID_SBC: AVCodecID = 86103;
pub const AVCodecID_AV_CODEC_ID_ATRAC9: AVCodecID = 86104;
pub const AVCodecID_AV_CODEC_ID_HCOM: AVCodecID = 86105;
pub const AVCodecID_AV_CODEC_ID_ACELP_KELVIN: AVCodecID = 86106;
pub const AVCodecID_AV_CODEC_ID_MPEGH_3D_AUDIO: AVCodecID = 86107;
pub const AVCodecID_AV_CODEC_ID_SIREN: AVCodecID = 86108;
pub const AVCodecID_AV_CODEC_ID_HCA: AVCodecID = 86109;
pub const AVCodecID_AV_CODEC_ID_FASTAUDIO: AVCodecID = 86110;
#[doc = "< A dummy ID pointing at the start of subtitle codecs."]
pub const AVCodecID_AV_CODEC_ID_FIRST_SUBTITLE: AVCodecID = 94208;
pub const AVCodecID_AV_CODEC_ID_DVD_SUBTITLE: AVCodecID = 94208;
pub const AVCodecID_AV_CODEC_ID_DVB_SUBTITLE: AVCodecID = 94209;
#[doc = "< raw UTF-8 text"]
pub const AVCodecID_AV_CODEC_ID_TEXT: AVCodecID = 94210;
pub const AVCodecID_AV_CODEC_ID_XSUB: AVCodecID = 94211;
pub const AVCodecID_AV_CODEC_ID_SSA: AVCodecID = 94212;
pub const AVCodecID_AV_CODEC_ID_MOV_TEXT: AVCodecID = 94213;
pub const AVCodecID_AV_CODEC_ID_HDMV_PGS_SUBTITLE: AVCodecID = 94214;
pub const AVCodecID_AV_CODEC_ID_DVB_TELETEXT: AVCodecID = 94215;
pub const AVCodecID_AV_CODEC_ID_SRT: AVCodecID = 94216;
pub const AVCodecID_AV_CODEC_ID_MICRODVD: AVCodecID = 94217;
pub const AVCodecID_AV_CODEC_ID_EIA_608: AVCodecID = 94218;
pub const AVCodecID_AV_CODEC_ID_JACOSUB: AVCodecID = 94219;
pub const AVCodecID_AV_CODEC_ID_SAMI: AVCodecID = 94220;
pub const AVCodecID_AV_CODEC_ID_REALTEXT: AVCodecID = 94221;
pub const AVCodecID_AV_CODEC_ID_STL: AVCodecID = 94222;
pub const AVCodecID_AV_CODEC_ID_SUBVIEWER1: AVCodecID = 94223;
pub const AVCodecID_AV_CODEC_ID_SUBVIEWER: AVCodecID = 94224;
pub const AVCodecID_AV_CODEC_ID_SUBRIP: AVCodecID = 94225;
pub const AVCodecID_AV_CODEC_ID_WEBVTT: AVCodecID = 94226;
pub const AVCodecID_AV_CODEC_ID_MPL2: AVCodecID = 94227;
pub const AVCodecID_AV_CODEC_ID_VPLAYER: AVCodecID = 94228;
pub const AVCodecID_AV_CODEC_ID_PJS: AVCodecID = 94229;
pub const AVCodecID_AV_CODEC_ID_ASS: AVCodecID = 94230;
pub const AVCodecID_AV_CODEC_ID_HDMV_TEXT_SUBTITLE: AVCodecID = 94231;
pub const AVCodecID_AV_CODEC_ID_TTML: AVCodecID = 94232;
pub const AVCodecID_AV_CODEC_ID_ARIB_CAPTION: AVCodecID = 94233;
#[doc = "< A dummy ID pointing at the start of various fake codecs."]
pub const AVCodecID_AV_CODEC_ID_FIRST_UNKNOWN: AVCodecID = 98304;
pub const AVCodecID_AV_CODEC_ID_TTF: AVCodecID = 98304;
#[doc = "< Contain timestamp estimated through PCR of program stream."]
pub const AVCodecID_AV_CODEC_ID_SCTE_35: AVCodecID = 98305;
pub const AVCodecID_AV_CODEC_ID_EPG: AVCodecID = 98306;
pub const AVCodecID_AV_CODEC_ID_BINTEXT: AVCodecID = 98307;
pub const AVCodecID_AV_CODEC_ID_XBIN: AVCodecID = 98308;
pub const AVCodecID_AV_CODEC_ID_IDF: AVCodecID = 98309;
pub const AVCodecID_AV_CODEC_ID_OTF: AVCodecID = 98310;
pub const AVCodecID_AV_CODEC_ID_SMPTE_KLV: AVCodecID = 98311;
pub const AVCodecID_AV_CODEC_ID_DVD_NAV: AVCodecID = 98312;
pub const AVCodecID_AV_CODEC_ID_TIMED_ID3: AVCodecID = 98313;
pub const AVCodecID_AV_CODEC_ID_BIN_DATA: AVCodecID = 98314;
#[doc = "< codec_id is not known (like AV_CODEC_ID_NONE) but lavf should attempt to identify it"]
pub const AVCodecID_AV_CODEC_ID_PROBE: AVCodecID = 102400;
#[doc = "< _FAKE_ codec to indicate a raw MPEG-2 TS"]
#[doc = " stream (only used by libavformat)"]
pub const AVCodecID_AV_CODEC_ID_MPEG2TS: AVCodecID = 131072;
#[doc = "< _FAKE_ codec to indicate a MPEG-4 Systems"]
#[doc = " stream (only used by libavformat)"]
pub const AVCodecID_AV_CODEC_ID_MPEG4SYSTEMS: AVCodecID = 131073;
#[doc = "< Dummy codec for streams containing only metadata information."]
pub const AVCodecID_AV_CODEC_ID_FFMETADATA: AVCodecID = 135168;
#[doc = "< Passthrough codec, AVFrames wrapped in AVPacket"]
pub const AVCodecID_AV_CODEC_ID_WRAPPED_AVFRAME: AVCodecID = 135169;
#[doc = " Identify the syntax and semantics of the bitstream."]
#[doc = " The principle is roughly:"]
#[doc = " Two decoders with the same ID can decode the same streams."]
#[doc = " Two encoders with the same ID can encode compatible streams."]
#[doc = " There may be slight deviations from the principle due to implementation"]
#[doc = " details."]
#[doc = ""]
#[doc = " If you add a codec ID to this list, add it so that"]
#[doc = " 1. no value of an existing codec ID changes (that would break ABI),"]
#[doc = " 2. it is as close as possible to similar codecs"]
#[doc = ""]
#[doc = " After adding new codec IDs, do not forget to add an entry to the codec"]
#[doc = " descriptor list and bump libavcodec minor version."]
pub type AVCodecID = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Get the type of the given codec."]
    pub fn avcodec_get_type(codec_id: AVCodecID) -> AVMediaType;
}
extern "C" {
    #[doc = " Get the name of a codec."]
    #[doc = " @return  a static string identifying the codec; never NULL"]
    pub fn avcodec_get_name(id: AVCodecID) -> *const ::std::os::raw::c_char;
}
pub const AVFieldOrder_AV_FIELD_UNKNOWN: AVFieldOrder = 0;
pub const AVFieldOrder_AV_FIELD_PROGRESSIVE: AVFieldOrder = 1;
pub const AVFieldOrder_AV_FIELD_TT: AVFieldOrder = 2;
pub const AVFieldOrder_AV_FIELD_BB: AVFieldOrder = 3;
pub const AVFieldOrder_AV_FIELD_TB: AVFieldOrder = 4;
pub const AVFieldOrder_AV_FIELD_BT: AVFieldOrder = 5;
#[doc = " @addtogroup lavc_core"]
pub type AVFieldOrder = ::std::os::raw::c_uint;
#[doc = " This struct describes the properties of an encoded stream."]
#[doc = ""]
#[doc = " sizeof(AVCodecParameters) is not a part of the public ABI, this struct must"]
#[doc = " be allocated with avcodec_parameters_alloc() and freed with"]
#[doc = " avcodec_parameters_free()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVCodecParameters {
    #[doc = " General type of the encoded data."]
    pub codec_type: AVMediaType,
    #[doc = " Specific type of the encoded data (the codec used)."]
    pub codec_id: AVCodecID,
    #[doc = " Additional information about the codec (corresponds to the AVI FOURCC)."]
    pub codec_tag: u32,
    #[doc = " Extra binary data needed for initializing the decoder, codec-dependent."]
    #[doc = ""]
    #[doc = " Must be allocated with av_malloc() and will be freed by"]
    #[doc = " avcodec_parameters_free(). The allocated size of extradata must be at"]
    #[doc = " least extradata_size + AV_INPUT_BUFFER_PADDING_SIZE, with the padding"]
    #[doc = " bytes zeroed."]
    pub extradata: *mut u8,
    #[doc = " Size of the extradata content in bytes."]
    pub extradata_size: ::std::os::raw::c_int,
    #[doc = " - video: the pixel format, the value corresponds to enum AVPixelFormat."]
    #[doc = " - audio: the sample format, the value corresponds to enum AVSampleFormat."]
    pub format: ::std::os::raw::c_int,
    #[doc = " The average bitrate of the encoded data (in bits per second)."]
    pub bit_rate: i64,
    #[doc = " The number of bits per sample in the codedwords."]
    #[doc = ""]
    #[doc = " This is basically the bitrate per sample. It is mandatory for a bunch of"]
    #[doc = " formats to actually decode them. It's the number of bits for one sample in"]
    #[doc = " the actual coded bitstream."]
    #[doc = ""]
    #[doc = " This could be for example 4 for ADPCM"]
    #[doc = " For PCM formats this matches bits_per_raw_sample"]
    #[doc = " Can be 0"]
    pub bits_per_coded_sample: ::std::os::raw::c_int,
    #[doc = " This is the number of valid bits in each output sample. If the"]
    #[doc = " sample format has more bits, the least significant bits are additional"]
    #[doc = " padding bits, which are always 0. Use right shifts to reduce the sample"]
    #[doc = " to its actual size. For example, audio formats with 24 bit samples will"]
    #[doc = " have bits_per_raw_sample set to 24, and format set to AV_SAMPLE_FMT_S32."]
    #[doc = " To get the original sample use \"(int32_t)sample >> 8\".\""]
    #[doc = ""]
    #[doc = " For ADPCM this might be 12 or 16 or similar"]
    #[doc = " Can be 0"]
    pub bits_per_raw_sample: ::std::os::raw::c_int,
    #[doc = " Codec-specific bitstream restrictions that the stream conforms to."]
    pub profile: ::std::os::raw::c_int,
    pub level: ::std::os::raw::c_int,
    #[doc = " Video only. The dimensions of the video frame in pixels."]
    pub width: ::std::os::raw::c_int,
    pub height: ::std::os::raw::c_int,
    #[doc = " Video only. The aspect ratio (width / height) which a single pixel"]
    #[doc = " should have when displayed."]
    #[doc = ""]
    #[doc = " When the aspect ratio is unknown / undefined, the numerator should be"]
    #[doc = " set to 0 (the denominator may have any value)."]
    pub sample_aspect_ratio: AVRational,
    #[doc = " Video only. The order of the fields in interlaced video."]
    pub field_order: AVFieldOrder,
    #[doc = " Video only. Additional colorspace characteristics."]
    pub color_range: AVColorRange,
    pub color_primaries: AVColorPrimaries,
    pub color_trc: AVColorTransferCharacteristic,
    pub color_space: AVColorSpace,
    pub chroma_location: AVChromaLocation,
    #[doc = " Video only. Number of delayed frames."]
    pub video_delay: ::std::os::raw::c_int,
    #[doc = " Audio only. The channel layout bitmask. May be 0 if the channel layout is"]
    #[doc = " unknown or unspecified, otherwise the number of bits set must be equal to"]
    #[doc = " the channels field."]
    pub channel_layout: u64,
    #[doc = " Audio only. The number of audio channels."]
    pub channels: ::std::os::raw::c_int,
    #[doc = " Audio only. The number of audio samples per second."]
    pub sample_rate: ::std::os::raw::c_int,
    #[doc = " Audio only. The number of bytes per coded audio frame, required by some"]
    #[doc = " formats."]
    #[doc = ""]
    #[doc = " Corresponds to nBlockAlign in WAVEFORMATEX."]
    pub block_align: ::std::os::raw::c_int,
    #[doc = " Audio only. Audio frame size, if known. Required by some formats to be static."]
    pub frame_size: ::std::os::raw::c_int,
    #[doc = " Audio only. The amount of padding (in samples) inserted by the encoder at"]
    #[doc = " the beginning of the audio. I.e. this number of leading decoded samples"]
    #[doc = " must be discarded by the caller to get the original audio without leading"]
    #[doc = " padding."]
    pub initial_padding: ::std::os::raw::c_int,
    #[doc = " Audio only. The amount of padding (in samples) appended by the encoder to"]
    #[doc = " the end of the audio. I.e. this number of decoded samples must be"]
    #[doc = " discarded by the caller from the end of the stream to get the original"]
    #[doc = " audio without any trailing padding."]
    pub trailing_padding: ::std::os::raw::c_int,
    #[doc = " Audio only. Number of samples to skip after a discontinuity."]
    pub seek_preroll: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_AVCodecParameters() {
    assert_eq!(
        ::std::mem::size_of::<AVCodecParameters>(),
        144usize,
        concat!("Size of: ", stringify!(AVCodecParameters))
    );
    assert_eq!(
        ::std::mem::align_of::<AVCodecParameters>(),
        8usize,
        concat!("Alignment of ", stringify!(AVCodecParameters))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParameters>())).codec_type as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(codec_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParameters>())).codec_id as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(codec_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParameters>())).codec_tag as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(codec_tag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParameters>())).extradata as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(extradata)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParameters>())).extradata_size as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(extradata_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParameters>())).format as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParameters>())).bit_rate as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(bit_rate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParameters>())).bits_per_coded_sample as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(bits_per_coded_sample)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParameters>())).bits_per_raw_sample as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(bits_per_raw_sample)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParameters>())).profile as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(profile)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParameters>())).level as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(level)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParameters>())).width as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParameters>())).height as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParameters>())).sample_aspect_ratio as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(sample_aspect_ratio)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParameters>())).field_order as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(field_order)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParameters>())).color_range as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(color_range)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParameters>())).color_primaries as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(color_primaries)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParameters>())).color_trc as *const _ as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(color_trc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParameters>())).color_space as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(color_space)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParameters>())).chroma_location as *const _ as usize
        },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(chroma_location)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParameters>())).video_delay as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(video_delay)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParameters>())).channel_layout as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(channel_layout)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParameters>())).channels as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(channels)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParameters>())).sample_rate as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(sample_rate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParameters>())).block_align as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(block_align)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParameters>())).frame_size as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(frame_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParameters>())).initial_padding as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(initial_padding)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParameters>())).trailing_padding as *const _ as usize
        },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(trailing_padding)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParameters>())).seek_preroll as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParameters),
            "::",
            stringify!(seek_preroll)
        )
    );
}
extern "C" {
    #[doc = " Allocate a new AVCodecParameters and set its fields to default values"]
    #[doc = " (unknown/invalid/0). The returned struct must be freed with"]
    #[doc = " avcodec_parameters_free()."]
    pub fn avcodec_parameters_alloc() -> *mut AVCodecParameters;
}
extern "C" {
    #[doc = " Free an AVCodecParameters instance and everything associated with it and"]
    #[doc = " write NULL to the supplied pointer."]
    pub fn avcodec_parameters_free(par: *mut *mut AVCodecParameters);
}
extern "C" {
    #[doc = " Copy the contents of src to dst. Any allocated fields in dst are freed and"]
    #[doc = " replaced with newly allocated duplicates of the corresponding fields in src."]
    #[doc = ""]
    #[doc = " @return >= 0 on success, a negative AVERROR code on failure."]
    pub fn avcodec_parameters_copy(
        dst: *mut AVCodecParameters,
        src: *const AVCodecParameters,
    ) -> ::std::os::raw::c_int;
}
#[doc = " An AV_PKT_DATA_PALETTE side data packet contains exactly AVPALETTE_SIZE"]
#[doc = " bytes worth of palette. This side data signals that a new palette is"]
#[doc = " present."]
pub const AVPacketSideDataType_AV_PKT_DATA_PALETTE: AVPacketSideDataType = 0;
#[doc = " The AV_PKT_DATA_NEW_EXTRADATA is used to notify the codec or the format"]
#[doc = " that the extradata buffer was changed and the receiving side should"]
#[doc = " act upon it appropriately. The new extradata is embedded in the side"]
#[doc = " data buffer and should be immediately used for processing the current"]
#[doc = " frame or packet."]
pub const AVPacketSideDataType_AV_PKT_DATA_NEW_EXTRADATA: AVPacketSideDataType = 1;
#[doc = " An AV_PKT_DATA_PARAM_CHANGE side data packet is laid out as follows:"]
#[doc = " @code"]
#[doc = " u32le param_flags"]
#[doc = " if (param_flags & AV_SIDE_DATA_PARAM_CHANGE_CHANNEL_COUNT)"]
#[doc = "     s32le channel_count"]
#[doc = " if (param_flags & AV_SIDE_DATA_PARAM_CHANGE_CHANNEL_LAYOUT)"]
#[doc = "     u64le channel_layout"]
#[doc = " if (param_flags & AV_SIDE_DATA_PARAM_CHANGE_SAMPLE_RATE)"]
#[doc = "     s32le sample_rate"]
#[doc = " if (param_flags & AV_SIDE_DATA_PARAM_CHANGE_DIMENSIONS)"]
#[doc = "     s32le width"]
#[doc = "     s32le height"]
#[doc = " @endcode"]
pub const AVPacketSideDataType_AV_PKT_DATA_PARAM_CHANGE: AVPacketSideDataType = 2;
#[doc = " An AV_PKT_DATA_H263_MB_INFO side data packet contains a number of"]
#[doc = " structures with info about macroblocks relevant to splitting the"]
#[doc = " packet into smaller packets on macroblock edges (e.g. as for RFC 2190)."]
#[doc = " That is, it does not necessarily contain info about all macroblocks,"]
#[doc = " as long as the distance between macroblocks in the info is smaller"]
#[doc = " than the target payload size."]
#[doc = " Each MB info structure is 12 bytes, and is laid out as follows:"]
#[doc = " @code"]
#[doc = " u32le bit offset from the start of the packet"]
#[doc = " u8    current quantizer at the start of the macroblock"]
#[doc = " u8    GOB number"]
#[doc = " u16le macroblock address within the GOB"]
#[doc = " u8    horizontal MV predictor"]
#[doc = " u8    vertical MV predictor"]
#[doc = " u8    horizontal MV predictor for block number 3"]
#[doc = " u8    vertical MV predictor for block number 3"]
#[doc = " @endcode"]
pub const AVPacketSideDataType_AV_PKT_DATA_H263_MB_INFO: AVPacketSideDataType = 3;
#[doc = " This side data should be associated with an audio stream and contains"]
#[doc = " ReplayGain information in form of the AVReplayGain struct."]
pub const AVPacketSideDataType_AV_PKT_DATA_REPLAYGAIN: AVPacketSideDataType = 4;
#[doc = " This side data contains a 3x3 transformation matrix describing an affine"]
#[doc = " transformation that needs to be applied to the decoded video frames for"]
#[doc = " correct presentation."]
#[doc = ""]
#[doc = " See libavutil/display.h for a detailed description of the data."]
pub const AVPacketSideDataType_AV_PKT_DATA_DISPLAYMATRIX: AVPacketSideDataType = 5;
#[doc = " This side data should be associated with a video stream and contains"]
#[doc = " Stereoscopic 3D information in form of the AVStereo3D struct."]
pub const AVPacketSideDataType_AV_PKT_DATA_STEREO3D: AVPacketSideDataType = 6;
#[doc = " This side data should be associated with an audio stream and corresponds"]
#[doc = " to enum AVAudioServiceType."]
pub const AVPacketSideDataType_AV_PKT_DATA_AUDIO_SERVICE_TYPE: AVPacketSideDataType = 7;
#[doc = " This side data contains quality related information from the encoder."]
#[doc = " @code"]
#[doc = " u32le quality factor of the compressed frame. Allowed range is between 1 (good) and FF_LAMBDA_MAX (bad)."]
#[doc = " u8    picture type"]
#[doc = " u8    error count"]
#[doc = " u16   reserved"]
#[doc = " u64le[error count] sum of squared differences between encoder in and output"]
#[doc = " @endcode"]
pub const AVPacketSideDataType_AV_PKT_DATA_QUALITY_STATS: AVPacketSideDataType = 8;
#[doc = " This side data contains an integer value representing the stream index"]
#[doc = " of a \"fallback\" track.  A fallback track indicates an alternate"]
#[doc = " track to use when the current track can not be decoded for some reason."]
#[doc = " e.g. no decoder available for codec."]
pub const AVPacketSideDataType_AV_PKT_DATA_FALLBACK_TRACK: AVPacketSideDataType = 9;
#[doc = " This side data corresponds to the AVCPBProperties struct."]
pub const AVPacketSideDataType_AV_PKT_DATA_CPB_PROPERTIES: AVPacketSideDataType = 10;
#[doc = " Recommmends skipping the specified number of samples"]
#[doc = " @code"]
#[doc = " u32le number of samples to skip from start of this packet"]
#[doc = " u32le number of samples to skip from end of this packet"]
#[doc = " u8    reason for start skip"]
#[doc = " u8    reason for end   skip (0=padding silence, 1=convergence)"]
#[doc = " @endcode"]
pub const AVPacketSideDataType_AV_PKT_DATA_SKIP_SAMPLES: AVPacketSideDataType = 11;
#[doc = " An AV_PKT_DATA_JP_DUALMONO side data packet indicates that"]
#[doc = " the packet may contain \"dual mono\" audio specific to Japanese DTV"]
#[doc = " and if it is true, recommends only the selected channel to be used."]
#[doc = " @code"]
#[doc = " u8    selected channels (0=mail/left, 1=sub/right, 2=both)"]
#[doc = " @endcode"]
pub const AVPacketSideDataType_AV_PKT_DATA_JP_DUALMONO: AVPacketSideDataType = 12;
#[doc = " A list of zero terminated key/value strings. There is no end marker for"]
#[doc = " the list, so it is required to rely on the side data size to stop."]
pub const AVPacketSideDataType_AV_PKT_DATA_STRINGS_METADATA: AVPacketSideDataType = 13;
#[doc = " Subtitle event position"]
#[doc = " @code"]
#[doc = " u32le x1"]
#[doc = " u32le y1"]
#[doc = " u32le x2"]
#[doc = " u32le y2"]
#[doc = " @endcode"]
pub const AVPacketSideDataType_AV_PKT_DATA_SUBTITLE_POSITION: AVPacketSideDataType = 14;
#[doc = " Data found in BlockAdditional element of matroska container. There is"]
#[doc = " no end marker for the data, so it is required to rely on the side data"]
#[doc = " size to recognize the end. 8 byte id (as found in BlockAddId) followed"]
#[doc = " by data."]
pub const AVPacketSideDataType_AV_PKT_DATA_MATROSKA_BLOCKADDITIONAL: AVPacketSideDataType = 15;
#[doc = " The optional first identifier line of a WebVTT cue."]
pub const AVPacketSideDataType_AV_PKT_DATA_WEBVTT_IDENTIFIER: AVPacketSideDataType = 16;
#[doc = " The optional settings (rendering instructions) that immediately"]
#[doc = " follow the timestamp specifier of a WebVTT cue."]
pub const AVPacketSideDataType_AV_PKT_DATA_WEBVTT_SETTINGS: AVPacketSideDataType = 17;
#[doc = " A list of zero terminated key/value strings. There is no end marker for"]
#[doc = " the list, so it is required to rely on the side data size to stop. This"]
#[doc = " side data includes updated metadata which appeared in the stream."]
pub const AVPacketSideDataType_AV_PKT_DATA_METADATA_UPDATE: AVPacketSideDataType = 18;
#[doc = " MPEGTS stream ID as uint8_t, this is required to pass the stream ID"]
#[doc = " information from the demuxer to the corresponding muxer."]
pub const AVPacketSideDataType_AV_PKT_DATA_MPEGTS_STREAM_ID: AVPacketSideDataType = 19;
#[doc = " Mastering display metadata (based on SMPTE-2086:2014). This metadata"]
#[doc = " should be associated with a video stream and contains data in the form"]
#[doc = " of the AVMasteringDisplayMetadata struct."]
pub const AVPacketSideDataType_AV_PKT_DATA_MASTERING_DISPLAY_METADATA: AVPacketSideDataType = 20;
#[doc = " This side data should be associated with a video stream and corresponds"]
#[doc = " to the AVSphericalMapping structure."]
pub const AVPacketSideDataType_AV_PKT_DATA_SPHERICAL: AVPacketSideDataType = 21;
#[doc = " Content light level (based on CTA-861.3). This metadata should be"]
#[doc = " associated with a video stream and contains data in the form of the"]
#[doc = " AVContentLightMetadata struct."]
pub const AVPacketSideDataType_AV_PKT_DATA_CONTENT_LIGHT_LEVEL: AVPacketSideDataType = 22;
#[doc = " ATSC A53 Part 4 Closed Captions. This metadata should be associated with"]
#[doc = " a video stream. A53 CC bitstream is stored as uint8_t in AVPacketSideData.data."]
#[doc = " The number of bytes of CC data is AVPacketSideData.size."]
pub const AVPacketSideDataType_AV_PKT_DATA_A53_CC: AVPacketSideDataType = 23;
#[doc = " This side data is encryption initialization data."]
#[doc = " The format is not part of ABI, use av_encryption_init_info_* methods to"]
#[doc = " access."]
pub const AVPacketSideDataType_AV_PKT_DATA_ENCRYPTION_INIT_INFO: AVPacketSideDataType = 24;
#[doc = " This side data contains encryption info for how to decrypt the packet."]
#[doc = " The format is not part of ABI, use av_encryption_info_* methods to access."]
pub const AVPacketSideDataType_AV_PKT_DATA_ENCRYPTION_INFO: AVPacketSideDataType = 25;
#[doc = " Active Format Description data consisting of a single byte as specified"]
#[doc = " in ETSI TS 101 154 using AVActiveFormatDescription enum."]
pub const AVPacketSideDataType_AV_PKT_DATA_AFD: AVPacketSideDataType = 26;
#[doc = " Producer Reference Time data corresponding to the AVProducerReferenceTime struct,"]
#[doc = " usually exported by some encoders (on demand through the prft flag set in the"]
#[doc = " AVCodecContext export_side_data field)."]
pub const AVPacketSideDataType_AV_PKT_DATA_PRFT: AVPacketSideDataType = 27;
#[doc = " ICC profile data consisting of an opaque octet buffer following the"]
#[doc = " format described by ISO 15076-1."]
pub const AVPacketSideDataType_AV_PKT_DATA_ICC_PROFILE: AVPacketSideDataType = 28;
#[doc = " DOVI configuration"]
#[doc = " ref:"]
#[doc = " dolby-vision-bitstreams-within-the-iso-base-media-file-format-v2.1.2, section 2.2"]
#[doc = " dolby-vision-bitstreams-in-mpeg-2-transport-stream-multiplex-v1.2, section 3.3"]
#[doc = " Tags are stored in struct AVDOVIDecoderConfigurationRecord."]
pub const AVPacketSideDataType_AV_PKT_DATA_DOVI_CONF: AVPacketSideDataType = 29;
#[doc = " Timecode which conforms to SMPTE ST 12-1:2014. The data is an array of 4 uint32_t"]
#[doc = " where the first uint32_t describes how many (1-3) of the other timecodes are used."]
#[doc = " The timecode format is described in the documentation of av_timecode_get_smpte_from_framenum()"]
#[doc = " function in libavutil/timecode.h."]
pub const AVPacketSideDataType_AV_PKT_DATA_S12M_TIMECODE: AVPacketSideDataType = 30;
#[doc = " The number of side data types."]
#[doc = " This is not part of the public API/ABI in the sense that it may"]
#[doc = " change when new side data types are added."]
#[doc = " This must stay the last enum value."]
#[doc = " If its value becomes huge, some code using it"]
#[doc = " needs to be updated as it assumes it to be smaller than other limits."]
pub const AVPacketSideDataType_AV_PKT_DATA_NB: AVPacketSideDataType = 31;
#[doc = " @defgroup lavc_packet AVPacket"]
#[doc = ""]
#[doc = " Types and functions for working with AVPacket."]
#[doc = " @{"]
pub type AVPacketSideDataType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVPacketSideData {
    pub data: *mut u8,
    pub size: size_t,
    pub type_: AVPacketSideDataType,
}
#[test]
fn bindgen_test_layout_AVPacketSideData() {
    assert_eq!(
        ::std::mem::size_of::<AVPacketSideData>(),
        24usize,
        concat!("Size of: ", stringify!(AVPacketSideData))
    );
    assert_eq!(
        ::std::mem::align_of::<AVPacketSideData>(),
        8usize,
        concat!("Alignment of ", stringify!(AVPacketSideData))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVPacketSideData>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVPacketSideData),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVPacketSideData>())).size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVPacketSideData),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVPacketSideData>())).type_ as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVPacketSideData),
            "::",
            stringify!(type_)
        )
    );
}
#[doc = " This structure stores compressed data. It is typically exported by demuxers"]
#[doc = " and then passed as input to decoders, or received as output from encoders and"]
#[doc = " then passed to muxers."]
#[doc = ""]
#[doc = " For video, it should typically contain one compressed frame. For audio it may"]
#[doc = " contain several compressed frames. Encoders are allowed to output empty"]
#[doc = " packets, with no compressed data, containing only side data"]
#[doc = " (e.g. to update some stream parameters at the end of encoding)."]
#[doc = ""]
#[doc = " The semantics of data ownership depends on the buf field."]
#[doc = " If it is set, the packet data is dynamically allocated and is"]
#[doc = " valid indefinitely until a call to av_packet_unref() reduces the"]
#[doc = " reference count to 0."]
#[doc = ""]
#[doc = " If the buf field is not set av_packet_ref() would make a copy instead"]
#[doc = " of increasing the reference count."]
#[doc = ""]
#[doc = " The side data is always allocated with av_malloc(), copied by"]
#[doc = " av_packet_ref() and freed by av_packet_unref()."]
#[doc = ""]
#[doc = " sizeof(AVPacket) being a part of the public ABI is deprecated. once"]
#[doc = " av_init_packet() is removed, new packets will only be able to be allocated"]
#[doc = " with av_packet_alloc(), and new fields may be added to the end of the struct"]
#[doc = " with a minor bump."]
#[doc = ""]
#[doc = " @see av_packet_alloc"]
#[doc = " @see av_packet_ref"]
#[doc = " @see av_packet_unref"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVPacket {
    #[doc = " A reference to the reference-counted buffer where the packet data is"]
    #[doc = " stored."]
    #[doc = " May be NULL, then the packet data is not reference-counted."]
    pub buf: *mut AVBufferRef,
    #[doc = " Presentation timestamp in AVStream->time_base units; the time at which"]
    #[doc = " the decompressed packet will be presented to the user."]
    #[doc = " Can be AV_NOPTS_VALUE if it is not stored in the file."]
    #[doc = " pts MUST be larger or equal to dts as presentation cannot happen before"]
    #[doc = " decompression, unless one wants to view hex dumps. Some formats misuse"]
    #[doc = " the terms dts and pts/cts to mean something different. Such timestamps"]
    #[doc = " must be converted to true pts/dts before they are stored in AVPacket."]
    pub pts: i64,
    #[doc = " Decompression timestamp in AVStream->time_base units; the time at which"]
    #[doc = " the packet is decompressed."]
    #[doc = " Can be AV_NOPTS_VALUE if it is not stored in the file."]
    pub dts: i64,
    pub data: *mut u8,
    pub size: ::std::os::raw::c_int,
    pub stream_index: ::std::os::raw::c_int,
    #[doc = " A combination of AV_PKT_FLAG values"]
    pub flags: ::std::os::raw::c_int,
    #[doc = " Additional packet data that can be provided by the container."]
    #[doc = " Packet can contain several types of side information."]
    pub side_data: *mut AVPacketSideData,
    pub side_data_elems: ::std::os::raw::c_int,
    #[doc = " Duration of this packet in AVStream->time_base units, 0 if unknown."]
    #[doc = " Equals next_pts - this_pts in presentation order."]
    pub duration: i64,
    #[doc = "< byte position in stream, -1 if unknown"]
    pub pos: i64,
}
#[test]
fn bindgen_test_layout_AVPacket() {
    assert_eq!(
        ::std::mem::size_of::<AVPacket>(),
        80usize,
        concat!("Size of: ", stringify!(AVPacket))
    );
    assert_eq!(
        ::std::mem::align_of::<AVPacket>(),
        8usize,
        concat!("Alignment of ", stringify!(AVPacket))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVPacket>())).buf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVPacket),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVPacket>())).pts as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVPacket),
            "::",
            stringify!(pts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVPacket>())).dts as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVPacket),
            "::",
            stringify!(dts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVPacket>())).data as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVPacket),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVPacket>())).size as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVPacket),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVPacket>())).stream_index as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(AVPacket),
            "::",
            stringify!(stream_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVPacket>())).flags as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVPacket),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVPacket>())).side_data as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(AVPacket),
            "::",
            stringify!(side_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVPacket>())).side_data_elems as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(AVPacket),
            "::",
            stringify!(side_data_elems)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVPacket>())).duration as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(AVPacket),
            "::",
            stringify!(duration)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVPacket>())).pos as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(AVPacket),
            "::",
            stringify!(pos)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVPacketList {
    pub pkt: AVPacket,
    pub next: *mut AVPacketList,
}
#[test]
fn bindgen_test_layout_AVPacketList() {
    assert_eq!(
        ::std::mem::size_of::<AVPacketList>(),
        88usize,
        concat!("Size of: ", stringify!(AVPacketList))
    );
    assert_eq!(
        ::std::mem::align_of::<AVPacketList>(),
        8usize,
        concat!("Alignment of ", stringify!(AVPacketList))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVPacketList>())).pkt as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVPacketList),
            "::",
            stringify!(pkt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVPacketList>())).next as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(AVPacketList),
            "::",
            stringify!(next)
        )
    );
}
pub const AVSideDataParamChangeFlags_AV_SIDE_DATA_PARAM_CHANGE_CHANNEL_COUNT:
    AVSideDataParamChangeFlags = 1;
pub const AVSideDataParamChangeFlags_AV_SIDE_DATA_PARAM_CHANGE_CHANNEL_LAYOUT:
    AVSideDataParamChangeFlags = 2;
pub const AVSideDataParamChangeFlags_AV_SIDE_DATA_PARAM_CHANGE_SAMPLE_RATE:
    AVSideDataParamChangeFlags = 4;
pub const AVSideDataParamChangeFlags_AV_SIDE_DATA_PARAM_CHANGE_DIMENSIONS:
    AVSideDataParamChangeFlags = 8;
pub type AVSideDataParamChangeFlags = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Allocate an AVPacket and set its fields to default values.  The resulting"]
    #[doc = " struct must be freed using av_packet_free()."]
    #[doc = ""]
    #[doc = " @return An AVPacket filled with default values or NULL on failure."]
    #[doc = ""]
    #[doc = " @note this only allocates the AVPacket itself, not the data buffers. Those"]
    #[doc = " must be allocated through other means such as av_new_packet."]
    #[doc = ""]
    #[doc = " @see av_new_packet"]
    pub fn av_packet_alloc() -> *mut AVPacket;
}
extern "C" {
    #[doc = " Create a new packet that references the same data as src."]
    #[doc = ""]
    #[doc = " This is a shortcut for av_packet_alloc()+av_packet_ref()."]
    #[doc = ""]
    #[doc = " @return newly created AVPacket on success, NULL on error."]
    #[doc = ""]
    #[doc = " @see av_packet_alloc"]
    #[doc = " @see av_packet_ref"]
    pub fn av_packet_clone(src: *const AVPacket) -> *mut AVPacket;
}
extern "C" {
    #[doc = " Free the packet, if the packet is reference counted, it will be"]
    #[doc = " unreferenced first."]
    #[doc = ""]
    #[doc = " @param pkt packet to be freed. The pointer will be set to NULL."]
    #[doc = " @note passing NULL is a no-op."]
    pub fn av_packet_free(pkt: *mut *mut AVPacket);
}
extern "C" {
    #[doc = " Initialize optional fields of a packet with default values."]
    #[doc = ""]
    #[doc = " Note, this does not touch the data and size members, which have to be"]
    #[doc = " initialized separately."]
    #[doc = ""]
    #[doc = " @param pkt packet"]
    #[doc = ""]
    #[doc = " @see av_packet_alloc"]
    #[doc = " @see av_packet_unref"]
    #[doc = ""]
    #[doc = " @deprecated This function is deprecated. Once it's removed,"]
    #[doc = "sizeof(AVPacket) will not be a part of the ABI anymore."]
    pub fn av_init_packet(pkt: *mut AVPacket);
}
extern "C" {
    #[doc = " Allocate the payload of a packet and initialize its fields with"]
    #[doc = " default values."]
    #[doc = ""]
    #[doc = " @param pkt packet"]
    #[doc = " @param size wanted payload size"]
    #[doc = " @return 0 if OK, AVERROR_xxx otherwise"]
    pub fn av_new_packet(pkt: *mut AVPacket, size: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Reduce packet size, correctly zeroing padding"]
    #[doc = ""]
    #[doc = " @param pkt packet"]
    #[doc = " @param size new size"]
    pub fn av_shrink_packet(pkt: *mut AVPacket, size: ::std::os::raw::c_int);
}
extern "C" {
    #[doc = " Increase packet size, correctly zeroing padding"]
    #[doc = ""]
    #[doc = " @param pkt packet"]
    #[doc = " @param grow_by number of bytes by which to increase the size of the packet"]
    pub fn av_grow_packet(
        pkt: *mut AVPacket,
        grow_by: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Initialize a reference-counted packet from av_malloc()ed data."]
    #[doc = ""]
    #[doc = " @param pkt packet to be initialized. This function will set the data, size,"]
    #[doc = "        and buf fields, all others are left untouched."]
    #[doc = " @param data Data allocated by av_malloc() to be used as packet data. If this"]
    #[doc = "        function returns successfully, the data is owned by the underlying AVBuffer."]
    #[doc = "        The caller may not access the data through other means."]
    #[doc = " @param size size of data in bytes, without the padding. I.e. the full buffer"]
    #[doc = "        size is assumed to be size + AV_INPUT_BUFFER_PADDING_SIZE."]
    #[doc = ""]
    #[doc = " @return 0 on success, a negative AVERROR on error"]
    pub fn av_packet_from_data(
        pkt: *mut AVPacket,
        data: *mut u8,
        size: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Allocate new information of a packet."]
    #[doc = ""]
    #[doc = " @param pkt packet"]
    #[doc = " @param type side information type"]
    #[doc = " @param size side information size"]
    #[doc = " @return pointer to fresh allocated data or NULL otherwise"]
    pub fn av_packet_new_side_data(
        pkt: *mut AVPacket,
        type_: AVPacketSideDataType,
        size: size_t,
    ) -> *mut u8;
}
extern "C" {
    #[doc = " Wrap an existing array as a packet side data."]
    #[doc = ""]
    #[doc = " @param pkt packet"]
    #[doc = " @param type side information type"]
    #[doc = " @param data the side data array. It must be allocated with the av_malloc()"]
    #[doc = "             family of functions. The ownership of the data is transferred to"]
    #[doc = "             pkt."]
    #[doc = " @param size side information size"]
    #[doc = " @return a non-negative number on success, a negative AVERROR code on"]
    #[doc = "         failure. On failure, the packet is unchanged and the data remains"]
    #[doc = "         owned by the caller."]
    pub fn av_packet_add_side_data(
        pkt: *mut AVPacket,
        type_: AVPacketSideDataType,
        data: *mut u8,
        size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Shrink the already allocated side data buffer"]
    #[doc = ""]
    #[doc = " @param pkt packet"]
    #[doc = " @param type side information type"]
    #[doc = " @param size new side information size"]
    #[doc = " @return 0 on success, < 0 on failure"]
    pub fn av_packet_shrink_side_data(
        pkt: *mut AVPacket,
        type_: AVPacketSideDataType,
        size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get side information from packet."]
    #[doc = ""]
    #[doc = " @param pkt packet"]
    #[doc = " @param type desired side information type"]
    #[doc = " @param size If supplied, *size will be set to the size of the side data"]
    #[doc = "             or to zero if the desired side data is not present."]
    #[doc = " @return pointer to data if present or NULL otherwise"]
    pub fn av_packet_get_side_data(
        pkt: *const AVPacket,
        type_: AVPacketSideDataType,
        size: *mut size_t,
    ) -> *mut u8;
}
extern "C" {
    pub fn av_packet_side_data_name(type_: AVPacketSideDataType) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Pack a dictionary for use in side_data."]
    #[doc = ""]
    #[doc = " @param dict The dictionary to pack."]
    #[doc = " @param size pointer to store the size of the returned data"]
    #[doc = " @return pointer to data if successful, NULL otherwise"]
    pub fn av_packet_pack_dictionary(dict: *mut AVDictionary, size: *mut size_t) -> *mut u8;
}
extern "C" {
    #[doc = " Unpack a dictionary from side_data."]
    #[doc = ""]
    #[doc = " @param data data from side_data"]
    #[doc = " @param size size of the data"]
    #[doc = " @param dict the metadata storage dictionary"]
    #[doc = " @return 0 on success, < 0 on failure"]
    pub fn av_packet_unpack_dictionary(
        data: *const u8,
        size: size_t,
        dict: *mut *mut AVDictionary,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Convenience function to free all the side data stored."]
    #[doc = " All the other fields stay untouched."]
    #[doc = ""]
    #[doc = " @param pkt packet"]
    pub fn av_packet_free_side_data(pkt: *mut AVPacket);
}
extern "C" {
    #[doc = " Setup a new reference to the data described by a given packet"]
    #[doc = ""]
    #[doc = " If src is reference-counted, setup dst as a new reference to the"]
    #[doc = " buffer in src. Otherwise allocate a new buffer in dst and copy the"]
    #[doc = " data from src into it."]
    #[doc = ""]
    #[doc = " All the other fields are copied from src."]
    #[doc = ""]
    #[doc = " @see av_packet_unref"]
    #[doc = ""]
    #[doc = " @param dst Destination packet. Will be completely overwritten."]
    #[doc = " @param src Source packet"]
    #[doc = ""]
    #[doc = " @return 0 on success, a negative AVERROR on error. On error, dst"]
    #[doc = "         will be blank (as if returned by av_packet_alloc())."]
    pub fn av_packet_ref(dst: *mut AVPacket, src: *const AVPacket) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Wipe the packet."]
    #[doc = ""]
    #[doc = " Unreference the buffer referenced by the packet and reset the"]
    #[doc = " remaining packet fields to their default values."]
    #[doc = ""]
    #[doc = " @param pkt The packet to be unreferenced."]
    pub fn av_packet_unref(pkt: *mut AVPacket);
}
extern "C" {
    #[doc = " Move every field in src to dst and reset src."]
    #[doc = ""]
    #[doc = " @see av_packet_unref"]
    #[doc = ""]
    #[doc = " @param src Source packet, will be reset"]
    #[doc = " @param dst Destination packet"]
    pub fn av_packet_move_ref(dst: *mut AVPacket, src: *mut AVPacket);
}
extern "C" {
    #[doc = " Copy only \"properties\" fields from src to dst."]
    #[doc = ""]
    #[doc = " Properties for the purpose of this function are all the fields"]
    #[doc = " beside those related to the packet data (buf, data, size)"]
    #[doc = ""]
    #[doc = " @param dst Destination packet"]
    #[doc = " @param src Source packet"]
    #[doc = ""]
    #[doc = " @return 0 on success AVERROR on failure."]
    pub fn av_packet_copy_props(dst: *mut AVPacket, src: *const AVPacket) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Ensure the data described by a given packet is reference counted."]
    #[doc = ""]
    #[doc = " @note This function does not ensure that the reference will be writable."]
    #[doc = "       Use av_packet_make_writable instead for that purpose."]
    #[doc = ""]
    #[doc = " @see av_packet_ref"]
    #[doc = " @see av_packet_make_writable"]
    #[doc = ""]
    #[doc = " @param pkt packet whose data should be made reference counted."]
    #[doc = ""]
    #[doc = " @return 0 on success, a negative AVERROR on error. On failure, the"]
    #[doc = "         packet is unchanged."]
    pub fn av_packet_make_refcounted(pkt: *mut AVPacket) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Create a writable reference for the data described by a given packet,"]
    #[doc = " avoiding data copy if possible."]
    #[doc = ""]
    #[doc = " @param pkt Packet whose data should be made writable."]
    #[doc = ""]
    #[doc = " @return 0 on success, a negative AVERROR on failure. On failure, the"]
    #[doc = "         packet is unchanged."]
    pub fn av_packet_make_writable(pkt: *mut AVPacket) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Convert valid timing fields (timestamps / durations) in a packet from one"]
    #[doc = " timebase to another. Timestamps with unknown values (AV_NOPTS_VALUE) will be"]
    #[doc = " ignored."]
    #[doc = ""]
    #[doc = " @param pkt packet on which the conversion will be performed"]
    #[doc = " @param tb_src source timebase, in which the timing fields in pkt are"]
    #[doc = "               expressed"]
    #[doc = " @param tb_dst destination timebase, to which the timing fields will be"]
    #[doc = "               converted"]
    pub fn av_packet_rescale_ts(pkt: *mut AVPacket, tb_src: AVRational, tb_dst: AVRational);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVBSFInternal {
    _unused: [u8; 0],
}
#[doc = " The bitstream filter state."]
#[doc = ""]
#[doc = " This struct must be allocated with av_bsf_alloc() and freed with"]
#[doc = " av_bsf_free()."]
#[doc = ""]
#[doc = " The fields in the struct will only be changed (by the caller or by the"]
#[doc = " filter) as described in their documentation, and are to be considered"]
#[doc = " immutable otherwise."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVBSFContext {
    #[doc = " A class for logging and AVOptions"]
    pub av_class: *const AVClass,
    #[doc = " The bitstream filter this context is an instance of."]
    pub filter: *const AVBitStreamFilter,
    #[doc = " Opaque libavcodec internal data. Must not be touched by the caller in any"]
    #[doc = " way."]
    pub internal: *mut AVBSFInternal,
    #[doc = " Opaque filter-specific private data. If filter->priv_class is non-NULL,"]
    #[doc = " this is an AVOptions-enabled struct."]
    pub priv_data: *mut ::std::os::raw::c_void,
    #[doc = " Parameters of the input stream. This field is allocated in"]
    #[doc = " av_bsf_alloc(), it needs to be filled by the caller before"]
    #[doc = " av_bsf_init()."]
    pub par_in: *mut AVCodecParameters,
    #[doc = " Parameters of the output stream. This field is allocated in"]
    #[doc = " av_bsf_alloc(), it is set by the filter in av_bsf_init()."]
    pub par_out: *mut AVCodecParameters,
    #[doc = " The timebase used for the timestamps of the input packets. Set by the"]
    #[doc = " caller before av_bsf_init()."]
    pub time_base_in: AVRational,
    #[doc = " The timebase used for the timestamps of the output packets. Set by the"]
    #[doc = " filter in av_bsf_init()."]
    pub time_base_out: AVRational,
}
#[test]
fn bindgen_test_layout_AVBSFContext() {
    assert_eq!(
        ::std::mem::size_of::<AVBSFContext>(),
        64usize,
        concat!("Size of: ", stringify!(AVBSFContext))
    );
    assert_eq!(
        ::std::mem::align_of::<AVBSFContext>(),
        8usize,
        concat!("Alignment of ", stringify!(AVBSFContext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVBSFContext>())).av_class as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVBSFContext),
            "::",
            stringify!(av_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVBSFContext>())).filter as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVBSFContext),
            "::",
            stringify!(filter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVBSFContext>())).internal as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVBSFContext),
            "::",
            stringify!(internal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVBSFContext>())).priv_data as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVBSFContext),
            "::",
            stringify!(priv_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVBSFContext>())).par_in as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVBSFContext),
            "::",
            stringify!(par_in)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVBSFContext>())).par_out as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVBSFContext),
            "::",
            stringify!(par_out)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVBSFContext>())).time_base_in as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(AVBSFContext),
            "::",
            stringify!(time_base_in)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVBSFContext>())).time_base_out as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(AVBSFContext),
            "::",
            stringify!(time_base_out)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVBitStreamFilter {
    pub name: *const ::std::os::raw::c_char,
    #[doc = " A list of codec ids supported by the filter, terminated by"]
    #[doc = " AV_CODEC_ID_NONE."]
    #[doc = " May be NULL, in that case the bitstream filter works with any codec id."]
    pub codec_ids: *const AVCodecID,
    #[doc = " A class for the private data, used to declare bitstream filter private"]
    #[doc = " AVOptions. This field is NULL for bitstream filters that do not declare"]
    #[doc = " any options."]
    #[doc = ""]
    #[doc = " If this field is non-NULL, the first member of the filter private data"]
    #[doc = " must be a pointer to AVClass, which will be set by libavcodec generic"]
    #[doc = " code to this class."]
    pub priv_class: *const AVClass,
    #[doc = " No fields below this line are part of the public API. They"]
    #[doc = " may not be used outside of libavcodec and can be changed and"]
    #[doc = " removed at will."]
    #[doc = " New public fields should be added right above."]
    #[doc = ""]
    pub priv_data_size: ::std::os::raw::c_int,
    pub init: ::std::option::Option<
        unsafe extern "C" fn(ctx: *mut AVBSFContext) -> ::std::os::raw::c_int,
    >,
    pub filter: ::std::option::Option<
        unsafe extern "C" fn(ctx: *mut AVBSFContext, pkt: *mut AVPacket) -> ::std::os::raw::c_int,
    >,
    pub close: ::std::option::Option<unsafe extern "C" fn(ctx: *mut AVBSFContext)>,
    pub flush: ::std::option::Option<unsafe extern "C" fn(ctx: *mut AVBSFContext)>,
}
#[test]
fn bindgen_test_layout_AVBitStreamFilter() {
    assert_eq!(
        ::std::mem::size_of::<AVBitStreamFilter>(),
        64usize,
        concat!("Size of: ", stringify!(AVBitStreamFilter))
    );
    assert_eq!(
        ::std::mem::align_of::<AVBitStreamFilter>(),
        8usize,
        concat!("Alignment of ", stringify!(AVBitStreamFilter))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVBitStreamFilter>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVBitStreamFilter),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVBitStreamFilter>())).codec_ids as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVBitStreamFilter),
            "::",
            stringify!(codec_ids)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVBitStreamFilter>())).priv_class as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVBitStreamFilter),
            "::",
            stringify!(priv_class)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVBitStreamFilter>())).priv_data_size as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVBitStreamFilter),
            "::",
            stringify!(priv_data_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVBitStreamFilter>())).init as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVBitStreamFilter),
            "::",
            stringify!(init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVBitStreamFilter>())).filter as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVBitStreamFilter),
            "::",
            stringify!(filter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVBitStreamFilter>())).close as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(AVBitStreamFilter),
            "::",
            stringify!(close)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVBitStreamFilter>())).flush as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(AVBitStreamFilter),
            "::",
            stringify!(flush)
        )
    );
}
extern "C" {
    #[doc = " @return a bitstream filter with the specified name or NULL if no such"]
    #[doc = "         bitstream filter exists."]
    pub fn av_bsf_get_by_name(name: *const ::std::os::raw::c_char) -> *const AVBitStreamFilter;
}
extern "C" {
    #[doc = " Iterate over all registered bitstream filters."]
    #[doc = ""]
    #[doc = " @param opaque a pointer where libavcodec will store the iteration state. Must"]
    #[doc = "               point to NULL to start the iteration."]
    #[doc = ""]
    #[doc = " @return the next registered bitstream filter or NULL when the iteration is"]
    #[doc = "         finished"]
    pub fn av_bsf_iterate(opaque: *mut *mut ::std::os::raw::c_void) -> *const AVBitStreamFilter;
}
extern "C" {
    #[doc = " Allocate a context for a given bitstream filter. The caller must fill in the"]
    #[doc = " context parameters as described in the documentation and then call"]
    #[doc = " av_bsf_init() before sending any data to the filter."]
    #[doc = ""]
    #[doc = " @param filter the filter for which to allocate an instance."]
    #[doc = " @param ctx a pointer into which the pointer to the newly-allocated context"]
    #[doc = "            will be written. It must be freed with av_bsf_free() after the"]
    #[doc = "            filtering is done."]
    #[doc = ""]
    #[doc = " @return 0 on success, a negative AVERROR code on failure"]
    pub fn av_bsf_alloc(
        filter: *const AVBitStreamFilter,
        ctx: *mut *mut AVBSFContext,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Prepare the filter for use, after all the parameters and options have been"]
    #[doc = " set."]
    pub fn av_bsf_init(ctx: *mut AVBSFContext) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Submit a packet for filtering."]
    #[doc = ""]
    #[doc = " After sending each packet, the filter must be completely drained by calling"]
    #[doc = " av_bsf_receive_packet() repeatedly until it returns AVERROR(EAGAIN) or"]
    #[doc = " AVERROR_EOF."]
    #[doc = ""]
    #[doc = " @param pkt the packet to filter. The bitstream filter will take ownership of"]
    #[doc = " the packet and reset the contents of pkt. pkt is not touched if an error occurs."]
    #[doc = " If pkt is empty (i.e. NULL, or pkt->data is NULL and pkt->side_data_elems zero),"]
    #[doc = " it signals the end of the stream (i.e. no more non-empty packets will be sent;"]
    #[doc = " sending more empty packets does nothing) and will cause the filter to output"]
    #[doc = " any packets it may have buffered internally."]
    #[doc = ""]
    #[doc = " @return 0 on success. AVERROR(EAGAIN) if packets need to be retrieved from the"]
    #[doc = " filter (using av_bsf_receive_packet()) before new input can be consumed. Another"]
    #[doc = " negative AVERROR value if an error occurs."]
    pub fn av_bsf_send_packet(ctx: *mut AVBSFContext, pkt: *mut AVPacket) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Retrieve a filtered packet."]
    #[doc = ""]
    #[doc = " @param[out] pkt this struct will be filled with the contents of the filtered"]
    #[doc = "                 packet. It is owned by the caller and must be freed using"]
    #[doc = "                 av_packet_unref() when it is no longer needed."]
    #[doc = "                 This parameter should be \"clean\" (i.e. freshly allocated"]
    #[doc = "                 with av_packet_alloc() or unreffed with av_packet_unref())"]
    #[doc = "                 when this function is called. If this function returns"]
    #[doc = "                 successfully, the contents of pkt will be completely"]
    #[doc = "                 overwritten by the returned data. On failure, pkt is not"]
    #[doc = "                 touched."]
    #[doc = ""]
    #[doc = " @return 0 on success. AVERROR(EAGAIN) if more packets need to be sent to the"]
    #[doc = " filter (using av_bsf_send_packet()) to get more output. AVERROR_EOF if there"]
    #[doc = " will be no further output from the filter. Another negative AVERROR value if"]
    #[doc = " an error occurs."]
    #[doc = ""]
    #[doc = " @note one input packet may result in several output packets, so after sending"]
    #[doc = " a packet with av_bsf_send_packet(), this function needs to be called"]
    #[doc = " repeatedly until it stops returning 0. It is also possible for a filter to"]
    #[doc = " output fewer packets than were sent to it, so this function may return"]
    #[doc = " AVERROR(EAGAIN) immediately after a successful av_bsf_send_packet() call."]
    pub fn av_bsf_receive_packet(
        ctx: *mut AVBSFContext,
        pkt: *mut AVPacket,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Reset the internal bitstream filter state. Should be called e.g. when seeking."]
    pub fn av_bsf_flush(ctx: *mut AVBSFContext);
}
extern "C" {
    #[doc = " Free a bitstream filter context and everything associated with it; write NULL"]
    #[doc = " into the supplied pointer."]
    pub fn av_bsf_free(ctx: *mut *mut AVBSFContext);
}
extern "C" {
    #[doc = " Get the AVClass for AVBSFContext. It can be used in combination with"]
    #[doc = " AV_OPT_SEARCH_FAKE_OBJ for examining options."]
    #[doc = ""]
    #[doc = " @see av_opt_find()."]
    pub fn av_bsf_get_class() -> *const AVClass;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVBSFList {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Allocate empty list of bitstream filters."]
    #[doc = " The list must be later freed by av_bsf_list_free()"]
    #[doc = " or finalized by av_bsf_list_finalize()."]
    #[doc = ""]
    #[doc = " @return Pointer to @ref AVBSFList on success, NULL in case of failure"]
    pub fn av_bsf_list_alloc() -> *mut AVBSFList;
}
extern "C" {
    #[doc = " Free list of bitstream filters."]
    #[doc = ""]
    #[doc = " @param lst Pointer to pointer returned by av_bsf_list_alloc()"]
    pub fn av_bsf_list_free(lst: *mut *mut AVBSFList);
}
extern "C" {
    #[doc = " Append bitstream filter to the list of bitstream filters."]
    #[doc = ""]
    #[doc = " @param lst List to append to"]
    #[doc = " @param bsf Filter context to be appended"]
    #[doc = ""]
    #[doc = " @return >=0 on success, negative AVERROR in case of failure"]
    pub fn av_bsf_list_append(lst: *mut AVBSFList, bsf: *mut AVBSFContext)
        -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Construct new bitstream filter context given it's name and options"]
    #[doc = " and append it to the list of bitstream filters."]
    #[doc = ""]
    #[doc = " @param lst      List to append to"]
    #[doc = " @param bsf_name Name of the bitstream filter"]
    #[doc = " @param options  Options for the bitstream filter, can be set to NULL"]
    #[doc = ""]
    #[doc = " @return >=0 on success, negative AVERROR in case of failure"]
    pub fn av_bsf_list_append2(
        lst: *mut AVBSFList,
        bsf_name: *const ::std::os::raw::c_char,
        options: *mut *mut AVDictionary,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Finalize list of bitstream filters."]
    #[doc = ""]
    #[doc = " This function will transform @ref AVBSFList to single @ref AVBSFContext,"]
    #[doc = " so the whole chain of bitstream filters can be treated as single filter"]
    #[doc = " freshly allocated by av_bsf_alloc()."]
    #[doc = " If the call is successful, @ref AVBSFList structure is freed and lst"]
    #[doc = " will be set to NULL. In case of failure, caller is responsible for"]
    #[doc = " freeing the structure by av_bsf_list_free()"]
    #[doc = ""]
    #[doc = " @param      lst Filter list structure to be transformed"]
    #[doc = " @param[out] bsf Pointer to be set to newly created @ref AVBSFContext structure"]
    #[doc = "                 representing the chain of bitstream filters"]
    #[doc = ""]
    #[doc = " @return >=0 on success, negative AVERROR in case of failure"]
    pub fn av_bsf_list_finalize(
        lst: *mut *mut AVBSFList,
        bsf: *mut *mut AVBSFContext,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Parse string describing list of bitstream filters and create single"]
    #[doc = " @ref AVBSFContext describing the whole chain of bitstream filters."]
    #[doc = " Resulting @ref AVBSFContext can be treated as any other @ref AVBSFContext freshly"]
    #[doc = " allocated by av_bsf_alloc()."]
    #[doc = ""]
    #[doc = " @param      str String describing chain of bitstream filters in format"]
    #[doc = "                 `bsf1[=opt1=val1:opt2=val2][,bsf2]`"]
    #[doc = " @param[out] bsf Pointer to be set to newly created @ref AVBSFContext structure"]
    #[doc = "                 representing the chain of bitstream filters"]
    #[doc = ""]
    #[doc = " @return >=0 on success, negative AVERROR in case of failure"]
    pub fn av_bsf_list_parse_str(
        str_: *const ::std::os::raw::c_char,
        bsf: *mut *mut AVBSFContext,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get null/pass-through bitstream filter."]
    #[doc = ""]
    #[doc = " @param[out] bsf Pointer to be set to new instance of pass-through bitstream filter"]
    #[doc = ""]
    #[doc = " @return"]
    pub fn av_bsf_get_null_filter(bsf: *mut *mut AVBSFContext) -> ::std::os::raw::c_int;
}
#[doc = " AVProfile."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVProfile {
    pub profile: ::std::os::raw::c_int,
    #[doc = "< short name for the profile"]
    pub name: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_AVProfile() {
    assert_eq!(
        ::std::mem::size_of::<AVProfile>(),
        16usize,
        concat!("Size of: ", stringify!(AVProfile))
    );
    assert_eq!(
        ::std::mem::align_of::<AVProfile>(),
        8usize,
        concat!("Alignment of ", stringify!(AVProfile))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVProfile>())).profile as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVProfile),
            "::",
            stringify!(profile)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVProfile>())).name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVProfile),
            "::",
            stringify!(name)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVCodecDefault {
    _unused: [u8; 0],
}
#[doc = " AVCodec."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVCodec {
    #[doc = " Name of the codec implementation."]
    #[doc = " The name is globally unique among encoders and among decoders (but an"]
    #[doc = " encoder and a decoder can share the same name)."]
    #[doc = " This is the primary way to find a codec from the user perspective."]
    pub name: *const ::std::os::raw::c_char,
    #[doc = " Descriptive name for the codec, meant to be more human readable than name."]
    #[doc = " You should use the NULL_IF_CONFIG_SMALL() macro to define it."]
    pub long_name: *const ::std::os::raw::c_char,
    pub type_: AVMediaType,
    pub id: AVCodecID,
    #[doc = " Codec capabilities."]
    #[doc = " see AV_CODEC_CAP_*"]
    pub capabilities: ::std::os::raw::c_int,
    #[doc = "< array of supported framerates, or NULL if any, array is terminated by {0,0}"]
    pub supported_framerates: *const AVRational,
    #[doc = "< array of supported pixel formats, or NULL if unknown, array is terminated by -1"]
    pub pix_fmts: *const AVPixelFormat,
    #[doc = "< array of supported audio samplerates, or NULL if unknown, array is terminated by 0"]
    pub supported_samplerates: *const ::std::os::raw::c_int,
    #[doc = "< array of supported sample formats, or NULL if unknown, array is terminated by -1"]
    pub sample_fmts: *const AVSampleFormat,
    #[doc = "< array of support channel layouts, or NULL if unknown. array is terminated by 0"]
    pub channel_layouts: *const u64,
    #[doc = "< maximum value for lowres supported by the decoder"]
    pub max_lowres: u8,
    #[doc = "< AVClass for the private context"]
    pub priv_class: *const AVClass,
    #[doc = "< array of recognized profiles, or NULL if unknown, array is terminated by {FF_PROFILE_UNKNOWN}"]
    pub profiles: *const AVProfile,
    #[doc = " Group name of the codec implementation."]
    #[doc = " This is a short symbolic name of the wrapper backing this codec. A"]
    #[doc = " wrapper uses some kind of external implementation for the codec, such"]
    #[doc = " as an external library, or a codec implementation provided by the OS or"]
    #[doc = " the hardware."]
    #[doc = " If this field is NULL, this is a builtin, libavcodec native codec."]
    #[doc = " If non-NULL, this will be the suffix in AVCodec.name in most cases"]
    #[doc = " (usually AVCodec.name will be of the form \"<codec_name>_<wrapper_name>\")."]
    pub wrapper_name: *const ::std::os::raw::c_char,
    #[doc = " No fields below this line are part of the public API. They"]
    #[doc = " may not be used outside of libavcodec and can be changed and"]
    #[doc = " removed at will."]
    #[doc = " New public fields should be added right above."]
    #[doc = ""]
    pub priv_data_size: ::std::os::raw::c_int,
    #[doc = " @name Frame-level threading support functions"]
    #[doc = " @{"]
    #[doc = " Copy necessary context variables from a previous thread context to the current one."]
    #[doc = " If not defined, the next thread will start automatically; otherwise, the codec"]
    #[doc = " must call ff_thread_finish_setup()."]
    #[doc = ""]
    #[doc = " dst and src will (rarely) point to the same context, in which case memcpy should be skipped."]
    pub update_thread_context: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut AVCodecContext,
            src: *const AVCodecContext,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " Copy variables back to the user-facing context"]
    pub update_thread_context_for_user: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut AVCodecContext,
            src: *const AVCodecContext,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " Private codec-specific defaults."]
    pub defaults: *const AVCodecDefault,
    #[doc = " Initialize codec static data, called from av_codec_iterate()."]
    #[doc = ""]
    #[doc = " This is not intended for time consuming operations as it is"]
    #[doc = " run for every codec regardless of that codec being used."]
    pub init_static_data: ::std::option::Option<unsafe extern "C" fn(codec: *mut AVCodec)>,
    pub init: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut AVCodecContext) -> ::std::os::raw::c_int,
    >,
    pub encode_sub: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut AVCodecContext,
            buf: *mut u8,
            buf_size: ::std::os::raw::c_int,
            sub: *const AVSubtitle,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " Encode data to an AVPacket."]
    #[doc = ""]
    #[doc = " @param      avctx          codec context"]
    #[doc = " @param      avpkt          output AVPacket"]
    #[doc = " @param[in]  frame          AVFrame containing the raw data to be encoded"]
    #[doc = " @param[out] got_packet_ptr encoder sets to 0 or 1 to indicate that a"]
    #[doc = "                            non-empty packet was returned in avpkt."]
    #[doc = " @return 0 on success, negative error code on failure"]
    pub encode2: ::std::option::Option<
        unsafe extern "C" fn(
            avctx: *mut AVCodecContext,
            avpkt: *mut AVPacket,
            frame: *const AVFrame,
            got_packet_ptr: *mut ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " Decode picture or subtitle data."]
    #[doc = ""]
    #[doc = " @param      avctx          codec context"]
    #[doc = " @param      outdata        codec type dependent output struct"]
    #[doc = " @param[out] got_frame_ptr  decoder sets to 0 or 1 to indicate that a"]
    #[doc = "                            non-empty frame or subtitle was returned in"]
    #[doc = "                            outdata."]
    #[doc = " @param[in]  avpkt          AVPacket containing the data to be decoded"]
    #[doc = " @return amount of bytes read from the packet on success, negative error"]
    #[doc = "         code on failure"]
    pub decode: ::std::option::Option<
        unsafe extern "C" fn(
            avctx: *mut AVCodecContext,
            outdata: *mut ::std::os::raw::c_void,
            got_frame_ptr: *mut ::std::os::raw::c_int,
            avpkt: *mut AVPacket,
        ) -> ::std::os::raw::c_int,
    >,
    pub close: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut AVCodecContext) -> ::std::os::raw::c_int,
    >,
    #[doc = " Encode API with decoupled frame/packet dataflow. This function is called"]
    #[doc = " to get one output packet. It should call ff_encode_get_frame() to obtain"]
    #[doc = " input data."]
    pub receive_packet: ::std::option::Option<
        unsafe extern "C" fn(
            avctx: *mut AVCodecContext,
            avpkt: *mut AVPacket,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " Decode API with decoupled packet/frame dataflow. This function is called"]
    #[doc = " to get one output frame. It should call ff_decode_get_packet() to obtain"]
    #[doc = " input data."]
    pub receive_frame: ::std::option::Option<
        unsafe extern "C" fn(
            avctx: *mut AVCodecContext,
            frame: *mut AVFrame,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " Flush buffers."]
    #[doc = " Will be called when seeking"]
    pub flush: ::std::option::Option<unsafe extern "C" fn(arg1: *mut AVCodecContext)>,
    #[doc = " Internal codec capabilities."]
    #[doc = " See FF_CODEC_CAP_* in internal.h"]
    pub caps_internal: ::std::os::raw::c_int,
    #[doc = " Decoding only, a comma-separated list of bitstream filters to apply to"]
    #[doc = " packets before decoding."]
    pub bsfs: *const ::std::os::raw::c_char,
    #[doc = " Array of pointers to hardware configurations supported by the codec,"]
    #[doc = " or NULL if no hardware supported.  The array is terminated by a NULL"]
    #[doc = " pointer."]
    #[doc = ""]
    #[doc = " The user can only access this field via avcodec_get_hw_config()."]
    pub hw_configs: *const *mut AVCodecHWConfigInternal,
    #[doc = " List of supported codec_tags, terminated by FF_CODEC_TAGS_END."]
    pub codec_tags: *const u32,
}
#[test]
fn bindgen_test_layout_AVCodec() {
    assert_eq!(
        ::std::mem::size_of::<AVCodec>(),
        240usize,
        concat!("Size of: ", stringify!(AVCodec))
    );
    assert_eq!(
        ::std::mem::align_of::<AVCodec>(),
        8usize,
        concat!("Alignment of ", stringify!(AVCodec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).long_name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(long_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).type_ as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).id as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).capabilities as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(capabilities)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).supported_framerates as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(supported_framerates)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).pix_fmts as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(pix_fmts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).supported_samplerates as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(supported_samplerates)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).sample_fmts as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(sample_fmts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).channel_layouts as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(channel_layouts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).max_lowres as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(max_lowres)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).priv_class as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(priv_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).profiles as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(profiles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).wrapper_name as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(wrapper_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).priv_data_size as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(priv_data_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).update_thread_context as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(update_thread_context)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodec>())).update_thread_context_for_user as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(update_thread_context_for_user)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).defaults as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(defaults)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).init_static_data as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(init_static_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).init as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).encode_sub as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(encode_sub)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).encode2 as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(encode2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).decode as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(decode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).close as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(close)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).receive_packet as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(receive_packet)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).receive_frame as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(receive_frame)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).flush as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(flush)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).caps_internal as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(caps_internal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).bsfs as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(bsfs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).hw_configs as *const _ as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(hw_configs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodec>())).codec_tags as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodec),
            "::",
            stringify!(codec_tags)
        )
    );
}
extern "C" {
    #[doc = " Iterate over all registered codecs."]
    #[doc = ""]
    #[doc = " @param opaque a pointer where libavcodec will store the iteration state. Must"]
    #[doc = "               point to NULL to start the iteration."]
    #[doc = ""]
    #[doc = " @return the next registered codec or NULL when the iteration is"]
    #[doc = "         finished"]
    pub fn av_codec_iterate(opaque: *mut *mut ::std::os::raw::c_void) -> *const AVCodec;
}
extern "C" {
    #[doc = " Find a registered decoder with a matching codec ID."]
    #[doc = ""]
    #[doc = " @param id AVCodecID of the requested decoder"]
    #[doc = " @return A decoder if one was found, NULL otherwise."]
    pub fn avcodec_find_decoder(id: AVCodecID) -> *const AVCodec;
}
extern "C" {
    #[doc = " Find a registered decoder with the specified name."]
    #[doc = ""]
    #[doc = " @param name name of the requested decoder"]
    #[doc = " @return A decoder if one was found, NULL otherwise."]
    pub fn avcodec_find_decoder_by_name(name: *const ::std::os::raw::c_char) -> *const AVCodec;
}
extern "C" {
    #[doc = " Find a registered encoder with a matching codec ID."]
    #[doc = ""]
    #[doc = " @param id AVCodecID of the requested encoder"]
    #[doc = " @return An encoder if one was found, NULL otherwise."]
    pub fn avcodec_find_encoder(id: AVCodecID) -> *const AVCodec;
}
extern "C" {
    #[doc = " Find a registered encoder with the specified name."]
    #[doc = ""]
    #[doc = " @param name name of the requested encoder"]
    #[doc = " @return An encoder if one was found, NULL otherwise."]
    pub fn avcodec_find_encoder_by_name(name: *const ::std::os::raw::c_char) -> *const AVCodec;
}
extern "C" {
    #[doc = " @return a non-zero number if codec is an encoder, zero otherwise"]
    pub fn av_codec_is_encoder(codec: *const AVCodec) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @return a non-zero number if codec is a decoder, zero otherwise"]
    pub fn av_codec_is_decoder(codec: *const AVCodec) -> ::std::os::raw::c_int;
}
#[doc = " The codec supports this format via the hw_device_ctx interface."]
#[doc = ""]
#[doc = " When selecting this format, AVCodecContext.hw_device_ctx should"]
#[doc = " have been set to a device of the specified type before calling"]
#[doc = " avcodec_open2()."]
pub const AV_CODEC_HW_CONFIG_METHOD_HW_DEVICE_CTX: ::std::os::raw::c_uint = 1;
#[doc = " The codec supports this format via the hw_frames_ctx interface."]
#[doc = ""]
#[doc = " When selecting this format for a decoder,"]
#[doc = " AVCodecContext.hw_frames_ctx should be set to a suitable frames"]
#[doc = " context inside the get_format() callback.  The frames context"]
#[doc = " must have been created on a device of the specified type."]
#[doc = ""]
#[doc = " When selecting this format for an encoder,"]
#[doc = " AVCodecContext.hw_frames_ctx should be set to the context which"]
#[doc = " will be used for the input frames before calling avcodec_open2()."]
pub const AV_CODEC_HW_CONFIG_METHOD_HW_FRAMES_CTX: ::std::os::raw::c_uint = 2;
#[doc = " The codec supports this format by some internal method."]
#[doc = ""]
#[doc = " This format can be selected without any additional configuration -"]
#[doc = " no device or frames context is required."]
pub const AV_CODEC_HW_CONFIG_METHOD_INTERNAL: ::std::os::raw::c_uint = 4;
#[doc = " The codec supports this format by some ad-hoc method."]
#[doc = ""]
#[doc = " Additional settings and/or function calls are required.  See the"]
#[doc = " codec-specific documentation for details.  (Methods requiring"]
#[doc = " this sort of configuration are deprecated and others should be"]
#[doc = " used in preference.)"]
pub const AV_CODEC_HW_CONFIG_METHOD_AD_HOC: ::std::os::raw::c_uint = 8;
pub type _bindgen_ty_4 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVCodecHWConfig {
    #[doc = " For decoders, a hardware pixel format which that decoder may be"]
    #[doc = " able to decode to if suitable hardware is available."]
    #[doc = ""]
    #[doc = " For encoders, a pixel format which the encoder may be able to"]
    #[doc = " accept.  If set to AV_PIX_FMT_NONE, this applies to all pixel"]
    #[doc = " formats supported by the codec."]
    pub pix_fmt: AVPixelFormat,
    #[doc = " Bit set of AV_CODEC_HW_CONFIG_METHOD_* flags, describing the possible"]
    #[doc = " setup methods which can be used with this configuration."]
    pub methods: ::std::os::raw::c_int,
    #[doc = " The device type associated with the configuration."]
    #[doc = ""]
    #[doc = " Must be set for AV_CODEC_HW_CONFIG_METHOD_HW_DEVICE_CTX and"]
    #[doc = " AV_CODEC_HW_CONFIG_METHOD_HW_FRAMES_CTX, otherwise unused."]
    pub device_type: AVHWDeviceType,
}
#[test]
fn bindgen_test_layout_AVCodecHWConfig() {
    assert_eq!(
        ::std::mem::size_of::<AVCodecHWConfig>(),
        12usize,
        concat!("Size of: ", stringify!(AVCodecHWConfig))
    );
    assert_eq!(
        ::std::mem::align_of::<AVCodecHWConfig>(),
        4usize,
        concat!("Alignment of ", stringify!(AVCodecHWConfig))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecHWConfig>())).pix_fmt as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecHWConfig),
            "::",
            stringify!(pix_fmt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecHWConfig>())).methods as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecHWConfig),
            "::",
            stringify!(methods)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecHWConfig>())).device_type as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecHWConfig),
            "::",
            stringify!(device_type)
        )
    );
}
extern "C" {
    #[doc = " Retrieve supported hardware configurations for a codec."]
    #[doc = ""]
    #[doc = " Values of index from zero to some maximum return the indexed configuration"]
    #[doc = " descriptor; all other values return NULL.  If the codec does not support"]
    #[doc = " any hardware configurations then it will always return NULL."]
    pub fn avcodec_get_hw_config(
        codec: *const AVCodec,
        index: ::std::os::raw::c_int,
    ) -> *const AVCodecHWConfig;
}
#[doc = " This struct describes the properties of a single codec described by an"]
#[doc = " AVCodecID."]
#[doc = " @see avcodec_descriptor_get()"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVCodecDescriptor {
    pub id: AVCodecID,
    pub type_: AVMediaType,
    #[doc = " Name of the codec described by this descriptor. It is non-empty and"]
    #[doc = " unique for each codec descriptor. It should contain alphanumeric"]
    #[doc = " characters and '_' only."]
    pub name: *const ::std::os::raw::c_char,
    #[doc = " A more descriptive name for this codec. May be NULL."]
    pub long_name: *const ::std::os::raw::c_char,
    #[doc = " Codec properties, a combination of AV_CODEC_PROP_* flags."]
    pub props: ::std::os::raw::c_int,
    #[doc = " MIME type(s) associated with the codec."]
    #[doc = " May be NULL; if not, a NULL-terminated array of MIME types."]
    #[doc = " The first item is always non-NULL and is the preferred MIME type."]
    pub mime_types: *const *const ::std::os::raw::c_char,
    #[doc = " If non-NULL, an array of profiles recognized for this codec."]
    #[doc = " Terminated with FF_PROFILE_UNKNOWN."]
    pub profiles: *const AVProfile,
}
#[test]
fn bindgen_test_layout_AVCodecDescriptor() {
    assert_eq!(
        ::std::mem::size_of::<AVCodecDescriptor>(),
        48usize,
        concat!("Size of: ", stringify!(AVCodecDescriptor))
    );
    assert_eq!(
        ::std::mem::align_of::<AVCodecDescriptor>(),
        8usize,
        concat!("Alignment of ", stringify!(AVCodecDescriptor))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecDescriptor>())).id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecDescriptor),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecDescriptor>())).type_ as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecDescriptor),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecDescriptor>())).name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecDescriptor),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecDescriptor>())).long_name as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecDescriptor),
            "::",
            stringify!(long_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecDescriptor>())).props as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecDescriptor),
            "::",
            stringify!(props)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecDescriptor>())).mime_types as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecDescriptor),
            "::",
            stringify!(mime_types)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecDescriptor>())).profiles as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecDescriptor),
            "::",
            stringify!(profiles)
        )
    );
}
extern "C" {
    #[doc = " @return descriptor for given codec ID or NULL if no descriptor exists."]
    pub fn avcodec_descriptor_get(id: AVCodecID) -> *const AVCodecDescriptor;
}
extern "C" {
    #[doc = " Iterate over all codec descriptors known to libavcodec."]
    #[doc = ""]
    #[doc = " @param prev previous descriptor. NULL to get the first descriptor."]
    #[doc = ""]
    #[doc = " @return next descriptor or NULL after the last descriptor"]
    pub fn avcodec_descriptor_next(prev: *const AVCodecDescriptor) -> *const AVCodecDescriptor;
}
extern "C" {
    #[doc = " @return codec descriptor with the given name or NULL if no such descriptor"]
    #[doc = "         exists."]
    pub fn avcodec_descriptor_get_by_name(
        name: *const ::std::os::raw::c_char,
    ) -> *const AVCodecDescriptor;
}
#[doc = "< discard nothing"]
pub const AVDiscard_AVDISCARD_NONE: AVDiscard = -16;
#[doc = "< discard useless packets like 0 size packets in avi"]
pub const AVDiscard_AVDISCARD_DEFAULT: AVDiscard = 0;
#[doc = "< discard all non reference"]
pub const AVDiscard_AVDISCARD_NONREF: AVDiscard = 8;
#[doc = "< discard all bidirectional frames"]
pub const AVDiscard_AVDISCARD_BIDIR: AVDiscard = 16;
#[doc = "< discard all non intra frames"]
pub const AVDiscard_AVDISCARD_NONINTRA: AVDiscard = 24;
#[doc = "< discard all frames except keyframes"]
pub const AVDiscard_AVDISCARD_NONKEY: AVDiscard = 32;
#[doc = "< discard all"]
pub const AVDiscard_AVDISCARD_ALL: AVDiscard = 48;
#[doc = " @ingroup lavc_decoding"]
pub type AVDiscard = ::std::os::raw::c_int;
pub const AVAudioServiceType_AV_AUDIO_SERVICE_TYPE_MAIN: AVAudioServiceType = 0;
pub const AVAudioServiceType_AV_AUDIO_SERVICE_TYPE_EFFECTS: AVAudioServiceType = 1;
pub const AVAudioServiceType_AV_AUDIO_SERVICE_TYPE_VISUALLY_IMPAIRED: AVAudioServiceType = 2;
pub const AVAudioServiceType_AV_AUDIO_SERVICE_TYPE_HEARING_IMPAIRED: AVAudioServiceType = 3;
pub const AVAudioServiceType_AV_AUDIO_SERVICE_TYPE_DIALOGUE: AVAudioServiceType = 4;
pub const AVAudioServiceType_AV_AUDIO_SERVICE_TYPE_COMMENTARY: AVAudioServiceType = 5;
pub const AVAudioServiceType_AV_AUDIO_SERVICE_TYPE_EMERGENCY: AVAudioServiceType = 6;
pub const AVAudioServiceType_AV_AUDIO_SERVICE_TYPE_VOICE_OVER: AVAudioServiceType = 7;
pub const AVAudioServiceType_AV_AUDIO_SERVICE_TYPE_KARAOKE: AVAudioServiceType = 8;
#[doc = "< Not part of ABI"]
pub const AVAudioServiceType_AV_AUDIO_SERVICE_TYPE_NB: AVAudioServiceType = 9;
pub type AVAudioServiceType = ::std::os::raw::c_uint;
#[doc = " @ingroup lavc_encoding"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RcOverride {
    pub start_frame: ::std::os::raw::c_int,
    pub end_frame: ::std::os::raw::c_int,
    pub qscale: ::std::os::raw::c_int,
    pub quality_factor: f32,
}
#[test]
fn bindgen_test_layout_RcOverride() {
    assert_eq!(
        ::std::mem::size_of::<RcOverride>(),
        16usize,
        concat!("Size of: ", stringify!(RcOverride))
    );
    assert_eq!(
        ::std::mem::align_of::<RcOverride>(),
        4usize,
        concat!("Alignment of ", stringify!(RcOverride))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RcOverride>())).start_frame as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RcOverride),
            "::",
            stringify!(start_frame)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RcOverride>())).end_frame as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(RcOverride),
            "::",
            stringify!(end_frame)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RcOverride>())).qscale as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RcOverride),
            "::",
            stringify!(qscale)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<RcOverride>())).quality_factor as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(RcOverride),
            "::",
            stringify!(quality_factor)
        )
    );
}
#[doc = " Pan Scan area."]
#[doc = " This specifies the area which should be displayed."]
#[doc = " Note there may be multiple such areas for one frame."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVPanScan {
    #[doc = " id"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by libavcodec."]
    pub id: ::std::os::raw::c_int,
    #[doc = " width and height in 1/16 pel"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by libavcodec."]
    pub width: ::std::os::raw::c_int,
    pub height: ::std::os::raw::c_int,
    #[doc = " position of the top left corner in 1/16 pel for up to 3 fields/frames"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by libavcodec."]
    pub position: [[i16; 2usize]; 3usize],
}
#[test]
fn bindgen_test_layout_AVPanScan() {
    assert_eq!(
        ::std::mem::size_of::<AVPanScan>(),
        24usize,
        concat!("Size of: ", stringify!(AVPanScan))
    );
    assert_eq!(
        ::std::mem::align_of::<AVPanScan>(),
        4usize,
        concat!("Alignment of ", stringify!(AVPanScan))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVPanScan>())).id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVPanScan),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVPanScan>())).width as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(AVPanScan),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVPanScan>())).height as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVPanScan),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVPanScan>())).position as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(AVPanScan),
            "::",
            stringify!(position)
        )
    );
}
#[doc = " This structure describes the bitrate properties of an encoded bitstream. It"]
#[doc = " roughly corresponds to a subset the VBV parameters for MPEG-2 or HRD"]
#[doc = " parameters for H.264/HEVC."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVCPBProperties {
    #[doc = " Maximum bitrate of the stream, in bits per second."]
    #[doc = " Zero if unknown or unspecified."]
    pub max_bitrate: i64,
    #[doc = " Minimum bitrate of the stream, in bits per second."]
    #[doc = " Zero if unknown or unspecified."]
    pub min_bitrate: i64,
    #[doc = " Average bitrate of the stream, in bits per second."]
    #[doc = " Zero if unknown or unspecified."]
    pub avg_bitrate: i64,
    #[doc = " The size of the buffer to which the ratecontrol is applied, in bits."]
    #[doc = " Zero if unknown or unspecified."]
    pub buffer_size: i64,
    #[doc = " The delay between the time the packet this structure is associated with"]
    #[doc = " is received and the time when it should be decoded, in periods of a 27MHz"]
    #[doc = " clock."]
    #[doc = ""]
    #[doc = " UINT64_MAX when unknown or unspecified."]
    pub vbv_delay: u64,
}
#[test]
fn bindgen_test_layout_AVCPBProperties() {
    assert_eq!(
        ::std::mem::size_of::<AVCPBProperties>(),
        40usize,
        concat!("Size of: ", stringify!(AVCPBProperties))
    );
    assert_eq!(
        ::std::mem::align_of::<AVCPBProperties>(),
        8usize,
        concat!("Alignment of ", stringify!(AVCPBProperties))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCPBProperties>())).max_bitrate as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCPBProperties),
            "::",
            stringify!(max_bitrate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCPBProperties>())).min_bitrate as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCPBProperties),
            "::",
            stringify!(min_bitrate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCPBProperties>())).avg_bitrate as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCPBProperties),
            "::",
            stringify!(avg_bitrate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCPBProperties>())).buffer_size as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCPBProperties),
            "::",
            stringify!(buffer_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCPBProperties>())).vbv_delay as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCPBProperties),
            "::",
            stringify!(vbv_delay)
        )
    );
}
#[doc = " This structure supplies correlation between a packet timestamp and a wall clock"]
#[doc = " production time. The definition follows the Producer Reference Time ('prft')"]
#[doc = " as defined in ISO/IEC 14496-12"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVProducerReferenceTime {
    #[doc = " A UTC timestamp, in microseconds, since Unix epoch (e.g, av_gettime())."]
    pub wallclock: i64,
    pub flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_AVProducerReferenceTime() {
    assert_eq!(
        ::std::mem::size_of::<AVProducerReferenceTime>(),
        16usize,
        concat!("Size of: ", stringify!(AVProducerReferenceTime))
    );
    assert_eq!(
        ::std::mem::align_of::<AVProducerReferenceTime>(),
        8usize,
        concat!("Alignment of ", stringify!(AVProducerReferenceTime))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVProducerReferenceTime>())).wallclock as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVProducerReferenceTime),
            "::",
            stringify!(wallclock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVProducerReferenceTime>())).flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVProducerReferenceTime),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVCodecInternal {
    _unused: [u8; 0],
}
#[doc = " main external API structure."]
#[doc = " New fields can be added to the end with minor version bumps."]
#[doc = " Removal, reordering and changes to existing fields require a major"]
#[doc = " version bump."]
#[doc = " You can use AVOptions (av_opt* / av_set/get*()) to access these fields from user"]
#[doc = " applications."]
#[doc = " The name string for AVOptions options matches the associated command line"]
#[doc = " parameter name and can be found in libavcodec/options_table.h"]
#[doc = " The AVOption/command line parameter names differ in some cases from the C"]
#[doc = " structure field names for historic reasons or brevity."]
#[doc = " sizeof(AVCodecContext) must not be used outside libav*."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVCodecContext {
    #[doc = " information on struct for av_log"]
    #[doc = " - set by avcodec_alloc_context3"]
    pub av_class: *const AVClass,
    pub log_level_offset: ::std::os::raw::c_int,
    pub codec_type: AVMediaType,
    pub codec: *const AVCodec,
    pub codec_id: AVCodecID,
    #[doc = " fourcc (LSB first, so \"ABCD\" -> ('D'<<24) + ('C'<<16) + ('B'<<8) + 'A')."]
    #[doc = " This is used to work around some encoder bugs."]
    #[doc = " A demuxer should set this to what is stored in the field used to identify the codec."]
    #[doc = " If there are multiple such fields in a container then the demuxer should choose the one"]
    #[doc = " which maximizes the information about the used codec."]
    #[doc = " If the codec tag field in a container is larger than 32 bits then the demuxer should"]
    #[doc = " remap the longer ID to 32 bits with a table or other structure. Alternatively a new"]
    #[doc = " extra_codec_tag + size could be added but for this a clear advantage must be demonstrated"]
    #[doc = " first."]
    #[doc = " - encoding: Set by user, if not then the default based on codec_id will be used."]
    #[doc = " - decoding: Set by user, will be converted to uppercase by libavcodec during init."]
    pub codec_tag: ::std::os::raw::c_uint,
    pub priv_data: *mut ::std::os::raw::c_void,
    #[doc = " Private context used for internal data."]
    #[doc = ""]
    #[doc = " Unlike priv_data, this is not codec-specific. It is used in general"]
    #[doc = " libavcodec functions."]
    pub internal: *mut AVCodecInternal,
    #[doc = " Private data of the user, can be used to carry app specific stuff."]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by user."]
    pub opaque: *mut ::std::os::raw::c_void,
    #[doc = " the average bitrate"]
    #[doc = " - encoding: Set by user; unused for constant quantizer encoding."]
    #[doc = " - decoding: Set by user, may be overwritten by libavcodec"]
    #[doc = "             if this info is available in the stream"]
    pub bit_rate: i64,
    #[doc = " number of bits the bitstream is allowed to diverge from the reference."]
    #[doc = "           the reference can be CBR (for CBR pass1) or VBR (for pass2)"]
    #[doc = " - encoding: Set by user; unused for constant quantizer encoding."]
    #[doc = " - decoding: unused"]
    pub bit_rate_tolerance: ::std::os::raw::c_int,
    #[doc = " Global quality for codecs which cannot change it per frame."]
    #[doc = " This should be proportional to MPEG-1/2/4 qscale."]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub global_quality: ::std::os::raw::c_int,
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub compression_level: ::std::os::raw::c_int,
    #[doc = " AV_CODEC_FLAG_*."]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by user."]
    pub flags: ::std::os::raw::c_int,
    #[doc = " AV_CODEC_FLAG2_*"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by user."]
    pub flags2: ::std::os::raw::c_int,
    #[doc = " some codecs need / can use extradata like Huffman tables."]
    #[doc = " MJPEG: Huffman tables"]
    #[doc = " rv10: additional flags"]
    #[doc = " MPEG-4: global headers (they can be in the bitstream or here)"]
    #[doc = " The allocated memory should be AV_INPUT_BUFFER_PADDING_SIZE bytes larger"]
    #[doc = " than extradata_size to avoid problems if it is read with the bitstream reader."]
    #[doc = " The bytewise contents of extradata must not depend on the architecture or CPU endianness."]
    #[doc = " Must be allocated with the av_malloc() family of functions."]
    #[doc = " - encoding: Set/allocated/freed by libavcodec."]
    #[doc = " - decoding: Set/allocated/freed by user."]
    pub extradata: *mut u8,
    pub extradata_size: ::std::os::raw::c_int,
    #[doc = " This is the fundamental unit of time (in seconds) in terms"]
    #[doc = " of which frame timestamps are represented. For fixed-fps content,"]
    #[doc = " timebase should be 1/framerate and timestamp increments should be"]
    #[doc = " identically 1."]
    #[doc = " This often, but not always is the inverse of the frame rate or field rate"]
    #[doc = " for video. 1/time_base is not the average frame rate if the frame rate is not"]
    #[doc = " constant."]
    #[doc = ""]
    #[doc = " Like containers, elementary streams also can store timestamps, 1/time_base"]
    #[doc = " is the unit in which these timestamps are specified."]
    #[doc = " As example of such codec time base see ISO/IEC 14496-2:2001(E)"]
    #[doc = " vop_time_increment_resolution and fixed_vop_rate"]
    #[doc = " (fixed_vop_rate == 0 implies that it is different from the framerate)"]
    #[doc = ""]
    #[doc = " - encoding: MUST be set by user."]
    #[doc = " - decoding: the use of this field for decoding is deprecated."]
    #[doc = "             Use framerate instead."]
    pub time_base: AVRational,
    #[doc = " For some codecs, the time base is closer to the field rate than the frame rate."]
    #[doc = " Most notably, H.264 and MPEG-2 specify time_base as half of frame duration"]
    #[doc = " if no telecine is used ..."]
    #[doc = ""]
    #[doc = " Set to time_base ticks per frame. Default 1, e.g., H.264/MPEG-2 set it to 2."]
    pub ticks_per_frame: ::std::os::raw::c_int,
    #[doc = " Codec delay."]
    #[doc = ""]
    #[doc = " Encoding: Number of frames delay there will be from the encoder input to"]
    #[doc = "           the decoder output. (we assume the decoder matches the spec)"]
    #[doc = " Decoding: Number of frames delay in addition to what a standard decoder"]
    #[doc = "           as specified in the spec would produce."]
    #[doc = ""]
    #[doc = " Video:"]
    #[doc = "   Number of frames the decoded output will be delayed relative to the"]
    #[doc = "   encoded input."]
    #[doc = ""]
    #[doc = " Audio:"]
    #[doc = "   For encoding, this field is unused (see initial_padding)."]
    #[doc = ""]
    #[doc = "   For decoding, this is the number of samples the decoder needs to"]
    #[doc = "   output before the decoder's output is valid. When seeking, you should"]
    #[doc = "   start decoding this many samples prior to your desired seek point."]
    #[doc = ""]
    #[doc = " - encoding: Set by libavcodec."]
    #[doc = " - decoding: Set by libavcodec."]
    pub delay: ::std::os::raw::c_int,
    #[doc = " picture width / height."]
    #[doc = ""]
    #[doc = " @note Those fields may not match the values of the last"]
    #[doc = " AVFrame output by avcodec_receive_frame() due frame"]
    #[doc = " reordering."]
    #[doc = ""]
    #[doc = " - encoding: MUST be set by user."]
    #[doc = " - decoding: May be set by the user before opening the decoder if known e.g."]
    #[doc = "             from the container. Some decoders will require the dimensions"]
    #[doc = "             to be set by the caller. During decoding, the decoder may"]
    #[doc = "             overwrite those values as required while parsing the data."]
    pub width: ::std::os::raw::c_int,
    #[doc = " picture width / height."]
    #[doc = ""]
    #[doc = " @note Those fields may not match the values of the last"]
    #[doc = " AVFrame output by avcodec_receive_frame() due frame"]
    #[doc = " reordering."]
    #[doc = ""]
    #[doc = " - encoding: MUST be set by user."]
    #[doc = " - decoding: May be set by the user before opening the decoder if known e.g."]
    #[doc = "             from the container. Some decoders will require the dimensions"]
    #[doc = "             to be set by the caller. During decoding, the decoder may"]
    #[doc = "             overwrite those values as required while parsing the data."]
    pub height: ::std::os::raw::c_int,
    #[doc = " Bitstream width / height, may be different from width/height e.g. when"]
    #[doc = " the decoded frame is cropped before being output or lowres is enabled."]
    #[doc = ""]
    #[doc = " @note Those field may not match the value of the last"]
    #[doc = " AVFrame output by avcodec_receive_frame() due frame"]
    #[doc = " reordering."]
    #[doc = ""]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: May be set by the user before opening the decoder if known"]
    #[doc = "             e.g. from the container. During decoding, the decoder may"]
    #[doc = "             overwrite those values as required while parsing the data."]
    pub coded_width: ::std::os::raw::c_int,
    #[doc = " Bitstream width / height, may be different from width/height e.g. when"]
    #[doc = " the decoded frame is cropped before being output or lowres is enabled."]
    #[doc = ""]
    #[doc = " @note Those field may not match the value of the last"]
    #[doc = " AVFrame output by avcodec_receive_frame() due frame"]
    #[doc = " reordering."]
    #[doc = ""]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: May be set by the user before opening the decoder if known"]
    #[doc = "             e.g. from the container. During decoding, the decoder may"]
    #[doc = "             overwrite those values as required while parsing the data."]
    pub coded_height: ::std::os::raw::c_int,
    #[doc = " the number of pictures in a group of pictures, or 0 for intra_only"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub gop_size: ::std::os::raw::c_int,
    #[doc = " Pixel format, see AV_PIX_FMT_xxx."]
    #[doc = " May be set by the demuxer if known from headers."]
    #[doc = " May be overridden by the decoder if it knows better."]
    #[doc = ""]
    #[doc = " @note This field may not match the value of the last"]
    #[doc = " AVFrame output by avcodec_receive_frame() due frame"]
    #[doc = " reordering."]
    #[doc = ""]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by user if known, overridden by libavcodec while"]
    #[doc = "             parsing the data."]
    pub pix_fmt: AVPixelFormat,
    #[doc = " If non NULL, 'draw_horiz_band' is called by the libavcodec"]
    #[doc = " decoder to draw a horizontal band. It improves cache usage. Not"]
    #[doc = " all codecs can do that. You must check the codec capabilities"]
    #[doc = " beforehand."]
    #[doc = " When multithreading is used, it may be called from multiple threads"]
    #[doc = " at the same time; threads might draw different parts of the same AVFrame,"]
    #[doc = " or multiple AVFrames, and there is no guarantee that slices will be drawn"]
    #[doc = " in order."]
    #[doc = " The function is also used by hardware acceleration APIs."]
    #[doc = " It is called at least once during frame decoding to pass"]
    #[doc = " the data needed for hardware render."]
    #[doc = " In that mode instead of pixel data, AVFrame points to"]
    #[doc = " a structure specific to the acceleration API. The application"]
    #[doc = " reads the structure and can change some fields to indicate progress"]
    #[doc = " or mark state."]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Set by user."]
    #[doc = " @param height the height of the slice"]
    #[doc = " @param y the y position of the slice"]
    #[doc = " @param type 1->top field, 2->bottom field, 3->frame"]
    #[doc = " @param offset offset into the AVFrame.data from which the slice should be read"]
    pub draw_horiz_band: ::std::option::Option<
        unsafe extern "C" fn(
            s: *mut AVCodecContext,
            src: *const AVFrame,
            offset: *mut ::std::os::raw::c_int,
            y: ::std::os::raw::c_int,
            type_: ::std::os::raw::c_int,
            height: ::std::os::raw::c_int,
        ),
    >,
    #[doc = " callback to negotiate the pixelFormat"]
    #[doc = " @param fmt is the list of formats which are supported by the codec,"]
    #[doc = " it is terminated by -1 as 0 is a valid format, the formats are ordered by quality."]
    #[doc = " The first is always the native one."]
    #[doc = " @note The callback may be called again immediately if initialization for"]
    #[doc = " the selected (hardware-accelerated) pixel format failed."]
    #[doc = " @warning Behavior is undefined if the callback returns a value not"]
    #[doc = " in the fmt list of formats."]
    #[doc = " @return the chosen format"]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Set by user, if not set the native format will be chosen."]
    pub get_format: ::std::option::Option<
        unsafe extern "C" fn(s: *mut AVCodecContext, fmt: *const AVPixelFormat) -> AVPixelFormat,
    >,
    #[doc = " maximum number of B-frames between non-B-frames"]
    #[doc = " Note: The output will be delayed by max_b_frames+1 relative to the input."]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub max_b_frames: ::std::os::raw::c_int,
    #[doc = " qscale factor between IP and B-frames"]
    #[doc = " If > 0 then the last P-frame quantizer will be used (q= lastp_q*factor+offset)."]
    #[doc = " If < 0 then normal ratecontrol will be done (q= -normal_q*factor+offset)."]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub b_quant_factor: f32,
    #[doc = " qscale offset between IP and B-frames"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub b_quant_offset: f32,
    #[doc = " Size of the frame reordering buffer in the decoder."]
    #[doc = " For MPEG-2 it is 1 IPB or 0 low delay IP."]
    #[doc = " - encoding: Set by libavcodec."]
    #[doc = " - decoding: Set by libavcodec."]
    pub has_b_frames: ::std::os::raw::c_int,
    #[doc = " qscale factor between P- and I-frames"]
    #[doc = " If > 0 then the last P-frame quantizer will be used (q = lastp_q * factor + offset)."]
    #[doc = " If < 0 then normal ratecontrol will be done (q= -normal_q*factor+offset)."]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub i_quant_factor: f32,
    #[doc = " qscale offset between P and I-frames"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub i_quant_offset: f32,
    #[doc = " luminance masking (0-> disabled)"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub lumi_masking: f32,
    #[doc = " temporary complexity masking (0-> disabled)"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub temporal_cplx_masking: f32,
    #[doc = " spatial complexity masking (0-> disabled)"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub spatial_cplx_masking: f32,
    #[doc = " p block masking (0-> disabled)"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub p_masking: f32,
    #[doc = " darkness masking (0-> disabled)"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub dark_masking: f32,
    #[doc = " slice count"]
    #[doc = " - encoding: Set by libavcodec."]
    #[doc = " - decoding: Set by user (or 0)."]
    pub slice_count: ::std::os::raw::c_int,
    #[doc = " slice offsets in the frame in bytes"]
    #[doc = " - encoding: Set/allocated by libavcodec."]
    #[doc = " - decoding: Set/allocated by user (or NULL)."]
    pub slice_offset: *mut ::std::os::raw::c_int,
    #[doc = " sample aspect ratio (0 if unknown)"]
    #[doc = " That is the width of a pixel divided by the height of the pixel."]
    #[doc = " Numerator and denominator must be relatively prime and smaller than 256 for some video standards."]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by libavcodec."]
    pub sample_aspect_ratio: AVRational,
    #[doc = " motion estimation comparison function"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub me_cmp: ::std::os::raw::c_int,
    #[doc = " subpixel motion estimation comparison function"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub me_sub_cmp: ::std::os::raw::c_int,
    #[doc = " macroblock comparison function (not supported yet)"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub mb_cmp: ::std::os::raw::c_int,
    #[doc = " interlaced DCT comparison function"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub ildct_cmp: ::std::os::raw::c_int,
    #[doc = " ME diamond size & shape"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub dia_size: ::std::os::raw::c_int,
    #[doc = " amount of previous MV predictors (2a+1 x 2a+1 square)"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub last_predictor_count: ::std::os::raw::c_int,
    #[doc = " motion estimation prepass comparison function"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub me_pre_cmp: ::std::os::raw::c_int,
    #[doc = " ME prepass diamond size & shape"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub pre_dia_size: ::std::os::raw::c_int,
    #[doc = " subpel ME quality"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub me_subpel_quality: ::std::os::raw::c_int,
    #[doc = " maximum motion estimation search range in subpel units"]
    #[doc = " If 0 then no limit."]
    #[doc = ""]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub me_range: ::std::os::raw::c_int,
    #[doc = " slice flags"]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Set by user."]
    pub slice_flags: ::std::os::raw::c_int,
    #[doc = " macroblock decision mode"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub mb_decision: ::std::os::raw::c_int,
    #[doc = " custom intra quantization matrix"]
    #[doc = " Must be allocated with the av_malloc() family of functions, and will be freed in"]
    #[doc = " avcodec_free_context()."]
    #[doc = " - encoding: Set/allocated by user, freed by libavcodec. Can be NULL."]
    #[doc = " - decoding: Set/allocated/freed by libavcodec."]
    pub intra_matrix: *mut u16,
    #[doc = " custom inter quantization matrix"]
    #[doc = " Must be allocated with the av_malloc() family of functions, and will be freed in"]
    #[doc = " avcodec_free_context()."]
    #[doc = " - encoding: Set/allocated by user, freed by libavcodec. Can be NULL."]
    #[doc = " - decoding: Set/allocated/freed by libavcodec."]
    pub inter_matrix: *mut u16,
    #[doc = " precision of the intra DC coefficient - 8"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by libavcodec"]
    pub intra_dc_precision: ::std::os::raw::c_int,
    #[doc = " Number of macroblock rows at the top which are skipped."]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Set by user."]
    pub skip_top: ::std::os::raw::c_int,
    #[doc = " Number of macroblock rows at the bottom which are skipped."]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Set by user."]
    pub skip_bottom: ::std::os::raw::c_int,
    #[doc = " minimum MB Lagrange multiplier"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub mb_lmin: ::std::os::raw::c_int,
    #[doc = " maximum MB Lagrange multiplier"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub mb_lmax: ::std::os::raw::c_int,
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub bidir_refine: ::std::os::raw::c_int,
    #[doc = " minimum GOP size"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub keyint_min: ::std::os::raw::c_int,
    #[doc = " number of reference frames"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by lavc."]
    pub refs: ::std::os::raw::c_int,
    #[doc = " Note: Value depends upon the compare function used for fullpel ME."]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub mv0_threshold: ::std::os::raw::c_int,
    #[doc = " Chromaticity coordinates of the source primaries."]
    #[doc = " - encoding: Set by user"]
    #[doc = " - decoding: Set by libavcodec"]
    pub color_primaries: AVColorPrimaries,
    #[doc = " Color Transfer Characteristic."]
    #[doc = " - encoding: Set by user"]
    #[doc = " - decoding: Set by libavcodec"]
    pub color_trc: AVColorTransferCharacteristic,
    #[doc = " YUV colorspace type."]
    #[doc = " - encoding: Set by user"]
    #[doc = " - decoding: Set by libavcodec"]
    pub colorspace: AVColorSpace,
    #[doc = " MPEG vs JPEG YUV range."]
    #[doc = " - encoding: Set by user"]
    #[doc = " - decoding: Set by libavcodec"]
    pub color_range: AVColorRange,
    #[doc = " This defines the location of chroma samples."]
    #[doc = " - encoding: Set by user"]
    #[doc = " - decoding: Set by libavcodec"]
    pub chroma_sample_location: AVChromaLocation,
    #[doc = " Number of slices."]
    #[doc = " Indicates number of picture subdivisions. Used for parallelized"]
    #[doc = " decoding."]
    #[doc = " - encoding: Set by user"]
    #[doc = " - decoding: unused"]
    pub slices: ::std::os::raw::c_int,
    #[doc = " Field order"]
    #[doc = " - encoding: set by libavcodec"]
    #[doc = " - decoding: Set by user."]
    pub field_order: AVFieldOrder,
    #[doc = "< samples per second"]
    pub sample_rate: ::std::os::raw::c_int,
    #[doc = "< number of audio channels"]
    pub channels: ::std::os::raw::c_int,
    #[doc = "< sample format"]
    pub sample_fmt: AVSampleFormat,
    #[doc = " Number of samples per channel in an audio frame."]
    #[doc = ""]
    #[doc = " - encoding: set by libavcodec in avcodec_open2(). Each submitted frame"]
    #[doc = "   except the last must contain exactly frame_size samples per channel."]
    #[doc = "   May be 0 when the codec has AV_CODEC_CAP_VARIABLE_FRAME_SIZE set, then the"]
    #[doc = "   frame size is not restricted."]
    #[doc = " - decoding: may be set by some decoders to indicate constant frame size"]
    pub frame_size: ::std::os::raw::c_int,
    #[doc = " Frame counter, set by libavcodec."]
    #[doc = ""]
    #[doc = " - decoding: total number of frames returned from the decoder so far."]
    #[doc = " - encoding: total number of frames passed to the encoder so far."]
    #[doc = ""]
    #[doc = "   @note the counter is not incremented if encoding/decoding resulted in"]
    #[doc = "   an error."]
    pub frame_number: ::std::os::raw::c_int,
    #[doc = " number of bytes per packet if constant and known or 0"]
    #[doc = " Used by some WAV based audio codecs."]
    pub block_align: ::std::os::raw::c_int,
    #[doc = " Audio cutoff bandwidth (0 means \"automatic\")"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub cutoff: ::std::os::raw::c_int,
    #[doc = " Audio channel layout."]
    #[doc = " - encoding: set by user."]
    #[doc = " - decoding: set by user, may be overwritten by libavcodec."]
    pub channel_layout: u64,
    #[doc = " Request decoder to use this channel layout if it can (0 for default)"]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Set by user."]
    pub request_channel_layout: u64,
    #[doc = " Type of service that the audio stream conveys."]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by libavcodec."]
    pub audio_service_type: AVAudioServiceType,
    #[doc = " desired sample format"]
    #[doc = " - encoding: Not used."]
    #[doc = " - decoding: Set by user."]
    #[doc = " Decoder will decode to this format if it can."]
    pub request_sample_fmt: AVSampleFormat,
    #[doc = " This callback is called at the beginning of each frame to get data"]
    #[doc = " buffer(s) for it. There may be one contiguous buffer for all the data or"]
    #[doc = " there may be a buffer per each data plane or anything in between. What"]
    #[doc = " this means is, you may set however many entries in buf[] you feel necessary."]
    #[doc = " Each buffer must be reference-counted using the AVBuffer API (see description"]
    #[doc = " of buf[] below)."]
    #[doc = ""]
    #[doc = " The following fields will be set in the frame before this callback is"]
    #[doc = " called:"]
    #[doc = " - format"]
    #[doc = " - width, height (video only)"]
    #[doc = " - sample_rate, channel_layout, nb_samples (audio only)"]
    #[doc = " Their values may differ from the corresponding values in"]
    #[doc = " AVCodecContext. This callback must use the frame values, not the codec"]
    #[doc = " context values, to calculate the required buffer size."]
    #[doc = ""]
    #[doc = " This callback must fill the following fields in the frame:"]
    #[doc = " - data[]"]
    #[doc = " - linesize[]"]
    #[doc = " - extended_data:"]
    #[doc = "   * if the data is planar audio with more than 8 channels, then this"]
    #[doc = "     callback must allocate and fill extended_data to contain all pointers"]
    #[doc = "     to all data planes. data[] must hold as many pointers as it can."]
    #[doc = "     extended_data must be allocated with av_malloc() and will be freed in"]
    #[doc = "     av_frame_unref()."]
    #[doc = "   * otherwise extended_data must point to data"]
    #[doc = " - buf[] must contain one or more pointers to AVBufferRef structures. Each of"]
    #[doc = "   the frame's data and extended_data pointers must be contained in these. That"]
    #[doc = "   is, one AVBufferRef for each allocated chunk of memory, not necessarily one"]
    #[doc = "   AVBufferRef per data[] entry. See: av_buffer_create(), av_buffer_alloc(),"]
    #[doc = "   and av_buffer_ref()."]
    #[doc = " - extended_buf and nb_extended_buf must be allocated with av_malloc() by"]
    #[doc = "   this callback and filled with the extra buffers if there are more"]
    #[doc = "   buffers than buf[] can hold. extended_buf will be freed in"]
    #[doc = "   av_frame_unref()."]
    #[doc = ""]
    #[doc = " If AV_CODEC_CAP_DR1 is not set then get_buffer2() must call"]
    #[doc = " avcodec_default_get_buffer2() instead of providing buffers allocated by"]
    #[doc = " some other means."]
    #[doc = ""]
    #[doc = " Each data plane must be aligned to the maximum required by the target"]
    #[doc = " CPU."]
    #[doc = ""]
    #[doc = " @see avcodec_default_get_buffer2()"]
    #[doc = ""]
    #[doc = " Video:"]
    #[doc = ""]
    #[doc = " If AV_GET_BUFFER_FLAG_REF is set in flags then the frame may be reused"]
    #[doc = " (read and/or written to if it is writable) later by libavcodec."]
    #[doc = ""]
    #[doc = " avcodec_align_dimensions2() should be used to find the required width and"]
    #[doc = " height, as they normally need to be rounded up to the next multiple of 16."]
    #[doc = ""]
    #[doc = " Some decoders do not support linesizes changing between frames."]
    #[doc = ""]
    #[doc = " If frame multithreading is used, this callback may be called from a"]
    #[doc = " different thread, but not from more than one at once. Does not need to be"]
    #[doc = " reentrant."]
    #[doc = ""]
    #[doc = " @see avcodec_align_dimensions2()"]
    #[doc = ""]
    #[doc = " Audio:"]
    #[doc = ""]
    #[doc = " Decoders request a buffer of a particular size by setting"]
    #[doc = " AVFrame.nb_samples prior to calling get_buffer2(). The decoder may,"]
    #[doc = " however, utilize only part of the buffer by setting AVFrame.nb_samples"]
    #[doc = " to a smaller value in the output frame."]
    #[doc = ""]
    #[doc = " As a convenience, av_samples_get_buffer_size() and"]
    #[doc = " av_samples_fill_arrays() in libavutil may be used by custom get_buffer2()"]
    #[doc = " functions to find the required data size and to fill data pointers and"]
    #[doc = " linesize. In AVFrame.linesize, only linesize[0] may be set for audio"]
    #[doc = " since all planes must be the same size."]
    #[doc = ""]
    #[doc = " @see av_samples_get_buffer_size(), av_samples_fill_arrays()"]
    #[doc = ""]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Set by libavcodec, user can override."]
    pub get_buffer2: ::std::option::Option<
        unsafe extern "C" fn(
            s: *mut AVCodecContext,
            frame: *mut AVFrame,
            flags: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "< amount of qscale change between easy & hard scenes (0.0-1.0)"]
    pub qcompress: f32,
    #[doc = "< amount of qscale smoothing over time (0.0-1.0)"]
    pub qblur: f32,
    #[doc = " minimum quantizer"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub qmin: ::std::os::raw::c_int,
    #[doc = " maximum quantizer"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub qmax: ::std::os::raw::c_int,
    #[doc = " maximum quantizer difference between frames"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub max_qdiff: ::std::os::raw::c_int,
    #[doc = " decoder bitstream buffer size"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub rc_buffer_size: ::std::os::raw::c_int,
    #[doc = " ratecontrol override, see RcOverride"]
    #[doc = " - encoding: Allocated/set/freed by user."]
    #[doc = " - decoding: unused"]
    pub rc_override_count: ::std::os::raw::c_int,
    pub rc_override: *mut RcOverride,
    #[doc = " maximum bitrate"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by user, may be overwritten by libavcodec."]
    pub rc_max_rate: i64,
    #[doc = " minimum bitrate"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub rc_min_rate: i64,
    #[doc = " Ratecontrol attempt to use, at maximum, <value> of what can be used without an underflow."]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused."]
    pub rc_max_available_vbv_use: f32,
    #[doc = " Ratecontrol attempt to use, at least, <value> times the amount needed to prevent a vbv overflow."]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused."]
    pub rc_min_vbv_overflow_use: f32,
    #[doc = " Number of bits which should be loaded into the rc buffer before decoding starts."]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub rc_initial_buffer_occupancy: ::std::os::raw::c_int,
    #[doc = " trellis RD quantization"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub trellis: ::std::os::raw::c_int,
    #[doc = " pass1 encoding statistics output buffer"]
    #[doc = " - encoding: Set by libavcodec."]
    #[doc = " - decoding: unused"]
    pub stats_out: *mut ::std::os::raw::c_char,
    #[doc = " pass2 encoding statistics input buffer"]
    #[doc = " Concatenated stuff from stats_out of pass1 should be placed here."]
    #[doc = " - encoding: Allocated/set/freed by user."]
    #[doc = " - decoding: unused"]
    pub stats_in: *mut ::std::os::raw::c_char,
    #[doc = " Work around bugs in encoders which sometimes cannot be detected automatically."]
    #[doc = " - encoding: Set by user"]
    #[doc = " - decoding: Set by user"]
    pub workaround_bugs: ::std::os::raw::c_int,
    #[doc = " strictly follow the standard (MPEG-4, ...)."]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by user."]
    #[doc = " Setting this to STRICT or higher means the encoder and decoder will"]
    #[doc = " generally do stupid things, whereas setting it to unofficial or lower"]
    #[doc = " will mean the encoder might produce output that is not supported by all"]
    #[doc = " spec-compliant decoders. Decoders don't differentiate between normal,"]
    #[doc = " unofficial and experimental (that is, they always try to decode things"]
    #[doc = " when they can) unless they are explicitly asked to behave stupidly"]
    #[doc = " (=strictly conform to the specs)"]
    pub strict_std_compliance: ::std::os::raw::c_int,
    #[doc = " error concealment flags"]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Set by user."]
    pub error_concealment: ::std::os::raw::c_int,
    #[doc = " debug"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by user."]
    pub debug: ::std::os::raw::c_int,
    #[doc = " Error recognition; may misdetect some more or less valid parts as errors."]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by user."]
    pub err_recognition: ::std::os::raw::c_int,
    #[doc = " opaque 64-bit number (generally a PTS) that will be reordered and"]
    #[doc = " output in AVFrame.reordered_opaque"]
    #[doc = " - encoding: Set by libavcodec to the reordered_opaque of the input"]
    #[doc = "             frame corresponding to the last returned packet. Only"]
    #[doc = "             supported by encoders with the"]
    #[doc = "             AV_CODEC_CAP_ENCODER_REORDERED_OPAQUE capability."]
    #[doc = " - decoding: Set by user."]
    pub reordered_opaque: i64,
    #[doc = " Hardware accelerator in use"]
    #[doc = " - encoding: unused."]
    #[doc = " - decoding: Set by libavcodec"]
    pub hwaccel: *const AVHWAccel,
    #[doc = " Hardware accelerator context."]
    #[doc = " For some hardware accelerators, a global context needs to be"]
    #[doc = " provided by the user. In that case, this holds display-dependent"]
    #[doc = " data FFmpeg cannot instantiate itself. Please refer to the"]
    #[doc = " FFmpeg HW accelerator documentation to know how to fill this."]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Set by user"]
    pub hwaccel_context: *mut ::std::os::raw::c_void,
    #[doc = " error"]
    #[doc = " - encoding: Set by libavcodec if flags & AV_CODEC_FLAG_PSNR."]
    #[doc = " - decoding: unused"]
    pub error: [u64; 8usize],
    #[doc = " DCT algorithm, see FF_DCT_* below"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub dct_algo: ::std::os::raw::c_int,
    #[doc = " IDCT algorithm, see FF_IDCT_* below."]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by user."]
    pub idct_algo: ::std::os::raw::c_int,
    #[doc = " bits per sample/pixel from the demuxer (needed for huffyuv)."]
    #[doc = " - encoding: Set by libavcodec."]
    #[doc = " - decoding: Set by user."]
    pub bits_per_coded_sample: ::std::os::raw::c_int,
    #[doc = " Bits per sample/pixel of internal libavcodec pixel/sample format."]
    #[doc = " - encoding: set by user."]
    #[doc = " - decoding: set by libavcodec."]
    pub bits_per_raw_sample: ::std::os::raw::c_int,
    #[doc = " low resolution decoding, 1-> 1/2 size, 2->1/4 size"]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Set by user."]
    pub lowres: ::std::os::raw::c_int,
    #[doc = " thread count"]
    #[doc = " is used to decide how many independent tasks should be passed to execute()"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by user."]
    pub thread_count: ::std::os::raw::c_int,
    #[doc = " Which multithreading methods to use."]
    #[doc = " Use of FF_THREAD_FRAME will increase decoding delay by one frame per thread,"]
    #[doc = " so clients which cannot provide future frames should not use it."]
    #[doc = ""]
    #[doc = " - encoding: Set by user, otherwise the default is used."]
    #[doc = " - decoding: Set by user, otherwise the default is used."]
    pub thread_type: ::std::os::raw::c_int,
    #[doc = " Which multithreading methods are in use by the codec."]
    #[doc = " - encoding: Set by libavcodec."]
    #[doc = " - decoding: Set by libavcodec."]
    pub active_thread_type: ::std::os::raw::c_int,
    #[doc = " Set by the client if its custom get_buffer() callback can be called"]
    #[doc = " synchronously from another thread, which allows faster multithreaded decoding."]
    #[doc = " draw_horiz_band() will be called from other threads regardless of this setting."]
    #[doc = " Ignored if the default get_buffer() is used."]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by user."]
    #[doc = ""]
    #[doc = " @deprecated the custom get_buffer2() callback should always be"]
    #[doc = "   thread-safe. Thread-unsafe get_buffer2() implementations will be"]
    #[doc = "   invalid starting with LIBAVCODEC_VERSION_MAJOR=60; in other words,"]
    #[doc = "   libavcodec will behave as if this field was always set to 1."]
    #[doc = "   Callers that want to be forward compatible with future libavcodec"]
    #[doc = "   versions should wrap access to this field in"]
    #[doc = "     #if LIBAVCODEC_VERSION_MAJOR < 60"]
    pub thread_safe_callbacks: ::std::os::raw::c_int,
    #[doc = " The codec may call this to execute several independent things."]
    #[doc = " It will return only after finishing all tasks."]
    #[doc = " The user may replace this with some multithreaded implementation,"]
    #[doc = " the default implementation will execute the parts serially."]
    #[doc = " @param count the number of things to execute"]
    #[doc = " - encoding: Set by libavcodec, user can override."]
    #[doc = " - decoding: Set by libavcodec, user can override."]
    pub execute: ::std::option::Option<
        unsafe extern "C" fn(
            c: *mut AVCodecContext,
            func: ::std::option::Option<
                unsafe extern "C" fn(
                    c2: *mut AVCodecContext,
                    arg: *mut ::std::os::raw::c_void,
                ) -> ::std::os::raw::c_int,
            >,
            arg2: *mut ::std::os::raw::c_void,
            ret: *mut ::std::os::raw::c_int,
            count: ::std::os::raw::c_int,
            size: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " The codec may call this to execute several independent things."]
    #[doc = " It will return only after finishing all tasks."]
    #[doc = " The user may replace this with some multithreaded implementation,"]
    #[doc = " the default implementation will execute the parts serially."]
    #[doc = " Also see avcodec_thread_init and e.g. the --enable-pthread configure option."]
    #[doc = " @param c context passed also to func"]
    #[doc = " @param count the number of things to execute"]
    #[doc = " @param arg2 argument passed unchanged to func"]
    #[doc = " @param ret return values of executed functions, must have space for \"count\" values. May be NULL."]
    #[doc = " @param func function that will be called count times, with jobnr from 0 to count-1."]
    #[doc = "             threadnr will be in the range 0 to c->thread_count-1 < MAX_THREADS and so that no"]
    #[doc = "             two instances of func executing at the same time will have the same threadnr."]
    #[doc = " @return always 0 currently, but code should handle a future improvement where when any call to func"]
    #[doc = "         returns < 0 no further calls to func may be done and < 0 is returned."]
    #[doc = " - encoding: Set by libavcodec, user can override."]
    #[doc = " - decoding: Set by libavcodec, user can override."]
    pub execute2: ::std::option::Option<
        unsafe extern "C" fn(
            c: *mut AVCodecContext,
            func: ::std::option::Option<
                unsafe extern "C" fn(
                    c2: *mut AVCodecContext,
                    arg: *mut ::std::os::raw::c_void,
                    jobnr: ::std::os::raw::c_int,
                    threadnr: ::std::os::raw::c_int,
                ) -> ::std::os::raw::c_int,
            >,
            arg2: *mut ::std::os::raw::c_void,
            ret: *mut ::std::os::raw::c_int,
            count: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " noise vs. sse weight for the nsse comparison function"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: unused"]
    pub nsse_weight: ::std::os::raw::c_int,
    #[doc = " profile"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by libavcodec."]
    pub profile: ::std::os::raw::c_int,
    #[doc = " level"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by libavcodec."]
    pub level: ::std::os::raw::c_int,
    #[doc = " Skip loop filtering for selected frames."]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Set by user."]
    pub skip_loop_filter: AVDiscard,
    #[doc = " Skip IDCT/dequantization for selected frames."]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Set by user."]
    pub skip_idct: AVDiscard,
    #[doc = " Skip decoding for selected frames."]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Set by user."]
    pub skip_frame: AVDiscard,
    #[doc = " Header containing style information for text subtitles."]
    #[doc = " For SUBTITLE_ASS subtitle type, it should contain the whole ASS"]
    #[doc = " [Script Info] and [V4+ Styles] section, plus the [Events] line and"]
    #[doc = " the Format line following. It shouldn't include any Dialogue line."]
    #[doc = " - encoding: Set/allocated/freed by user (before avcodec_open2())"]
    #[doc = " - decoding: Set/allocated/freed by libavcodec (by avcodec_open2())"]
    pub subtitle_header: *mut u8,
    pub subtitle_header_size: ::std::os::raw::c_int,
    #[doc = " Audio only. The number of \"priming\" samples (padding) inserted by the"]
    #[doc = " encoder at the beginning of the audio. I.e. this number of leading"]
    #[doc = " decoded samples must be discarded by the caller to get the original audio"]
    #[doc = " without leading padding."]
    #[doc = ""]
    #[doc = " - decoding: unused"]
    #[doc = " - encoding: Set by libavcodec. The timestamps on the output packets are"]
    #[doc = "             adjusted by the encoder so that they always refer to the"]
    #[doc = "             first sample of the data actually contained in the packet,"]
    #[doc = "             including any added padding.  E.g. if the timebase is"]
    #[doc = "             1/samplerate and the timestamp of the first input sample is"]
    #[doc = "             0, the timestamp of the first output packet will be"]
    #[doc = "             -initial_padding."]
    pub initial_padding: ::std::os::raw::c_int,
    #[doc = " - decoding: For codecs that store a framerate value in the compressed"]
    #[doc = "             bitstream, the decoder may export it here. { 0, 1} when"]
    #[doc = "             unknown."]
    #[doc = " - encoding: May be used to signal the framerate of CFR content to an"]
    #[doc = "             encoder."]
    pub framerate: AVRational,
    #[doc = " Nominal unaccelerated pixel format, see AV_PIX_FMT_xxx."]
    #[doc = " - encoding: unused."]
    #[doc = " - decoding: Set by libavcodec before calling get_format()"]
    pub sw_pix_fmt: AVPixelFormat,
    #[doc = " Timebase in which pkt_dts/pts and AVPacket.dts/pts are."]
    #[doc = " - encoding unused."]
    #[doc = " - decoding set by user."]
    pub pkt_timebase: AVRational,
    #[doc = " AVCodecDescriptor"]
    #[doc = " - encoding: unused."]
    #[doc = " - decoding: set by libavcodec."]
    pub codec_descriptor: *const AVCodecDescriptor,
    #[doc = " Current statistics for PTS correction."]
    #[doc = " - decoding: maintained and used by libavcodec, not intended to be used by user apps"]
    #[doc = " - encoding: unused"]
    pub pts_correction_num_faulty_pts: i64,
    #[doc = " Number of incorrect PTS values so far"]
    pub pts_correction_num_faulty_dts: i64,
    #[doc = " Number of incorrect DTS values so far"]
    pub pts_correction_last_pts: i64,
    #[doc = " PTS of the last frame"]
    pub pts_correction_last_dts: i64,
    #[doc = " Character encoding of the input subtitles file."]
    #[doc = " - decoding: set by user"]
    #[doc = " - encoding: unused"]
    pub sub_charenc: *mut ::std::os::raw::c_char,
    #[doc = " Subtitles character encoding mode. Formats or codecs might be adjusting"]
    #[doc = " this setting (if they are doing the conversion themselves for instance)."]
    #[doc = " - decoding: set by libavcodec"]
    #[doc = " - encoding: unused"]
    pub sub_charenc_mode: ::std::os::raw::c_int,
    #[doc = " Skip processing alpha if supported by codec."]
    #[doc = " Note that if the format uses pre-multiplied alpha (common with VP6,"]
    #[doc = " and recommended due to better video quality/compression)"]
    #[doc = " the image will look as if alpha-blended onto a black background."]
    #[doc = " However for formats that do not use pre-multiplied alpha"]
    #[doc = " there might be serious artefacts (though e.g. libswscale currently"]
    #[doc = " assumes pre-multiplied alpha anyway)."]
    #[doc = ""]
    #[doc = " - decoding: set by user"]
    #[doc = " - encoding: unused"]
    pub skip_alpha: ::std::os::raw::c_int,
    #[doc = " Number of samples to skip after a discontinuity"]
    #[doc = " - decoding: unused"]
    #[doc = " - encoding: set by libavcodec"]
    pub seek_preroll: ::std::os::raw::c_int,
    #[doc = " @deprecated unused"]
    pub debug_mv: ::std::os::raw::c_int,
    #[doc = " custom intra quantization matrix"]
    #[doc = " - encoding: Set by user, can be NULL."]
    #[doc = " - decoding: unused."]
    pub chroma_intra_matrix: *mut u16,
    #[doc = " dump format separator."]
    #[doc = " can be \", \" or \"\\n      \" or anything else"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by user."]
    pub dump_separator: *mut u8,
    #[doc = " ',' separated list of allowed decoders."]
    #[doc = " If NULL then all are allowed"]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: set by user"]
    pub codec_whitelist: *mut ::std::os::raw::c_char,
    #[doc = " Properties of the stream that gets decoded"]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: set by libavcodec"]
    pub properties: ::std::os::raw::c_uint,
    #[doc = " Additional data associated with the entire coded stream."]
    #[doc = ""]
    #[doc = " - decoding: unused"]
    #[doc = " - encoding: may be set by libavcodec after avcodec_open2()."]
    pub coded_side_data: *mut AVPacketSideData,
    pub nb_coded_side_data: ::std::os::raw::c_int,
    #[doc = " A reference to the AVHWFramesContext describing the input (for encoding)"]
    #[doc = " or output (decoding) frames. The reference is set by the caller and"]
    #[doc = " afterwards owned (and freed) by libavcodec - it should never be read by"]
    #[doc = " the caller after being set."]
    #[doc = ""]
    #[doc = " - decoding: This field should be set by the caller from the get_format()"]
    #[doc = "             callback. The previous reference (if any) will always be"]
    #[doc = "             unreffed by libavcodec before the get_format() call."]
    #[doc = ""]
    #[doc = "             If the default get_buffer2() is used with a hwaccel pixel"]
    #[doc = "             format, then this AVHWFramesContext will be used for"]
    #[doc = "             allocating the frame buffers."]
    #[doc = ""]
    #[doc = " - encoding: For hardware encoders configured to use a hwaccel pixel"]
    #[doc = "             format, this field should be set by the caller to a reference"]
    #[doc = "             to the AVHWFramesContext describing input frames."]
    #[doc = "             AVHWFramesContext.format must be equal to"]
    #[doc = "             AVCodecContext.pix_fmt."]
    #[doc = ""]
    #[doc = "             This field should be set before avcodec_open2() is called."]
    pub hw_frames_ctx: *mut AVBufferRef,
    #[doc = " Control the form of AVSubtitle.rects[N]->ass"]
    #[doc = " - decoding: set by user"]
    #[doc = " - encoding: unused"]
    pub sub_text_format: ::std::os::raw::c_int,
    #[doc = " Audio only. The amount of padding (in samples) appended by the encoder to"]
    #[doc = " the end of the audio. I.e. this number of decoded samples must be"]
    #[doc = " discarded by the caller from the end of the stream to get the original"]
    #[doc = " audio without any trailing padding."]
    #[doc = ""]
    #[doc = " - decoding: unused"]
    #[doc = " - encoding: unused"]
    pub trailing_padding: ::std::os::raw::c_int,
    #[doc = " The number of pixels per image to maximally accept."]
    #[doc = ""]
    #[doc = " - decoding: set by user"]
    #[doc = " - encoding: set by user"]
    pub max_pixels: i64,
    #[doc = " A reference to the AVHWDeviceContext describing the device which will"]
    #[doc = " be used by a hardware encoder/decoder.  The reference is set by the"]
    #[doc = " caller and afterwards owned (and freed) by libavcodec."]
    #[doc = ""]
    #[doc = " This should be used if either the codec device does not require"]
    #[doc = " hardware frames or any that are used are to be allocated internally by"]
    #[doc = " libavcodec.  If the user wishes to supply any of the frames used as"]
    #[doc = " encoder input or decoder output then hw_frames_ctx should be used"]
    #[doc = " instead.  When hw_frames_ctx is set in get_format() for a decoder, this"]
    #[doc = " field will be ignored while decoding the associated stream segment, but"]
    #[doc = " may again be used on a following one after another get_format() call."]
    #[doc = ""]
    #[doc = " For both encoders and decoders this field should be set before"]
    #[doc = " avcodec_open2() is called and must not be written to thereafter."]
    #[doc = ""]
    #[doc = " Note that some decoders may require this field to be set initially in"]
    #[doc = " order to support hw_frames_ctx at all - in that case, all frames"]
    #[doc = " contexts used must be created on the same device."]
    pub hw_device_ctx: *mut AVBufferRef,
    #[doc = " Bit set of AV_HWACCEL_FLAG_* flags, which affect hardware accelerated"]
    #[doc = " decoding (if active)."]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Set by user (either before avcodec_open2(), or in the"]
    #[doc = "             AVCodecContext.get_format callback)"]
    pub hwaccel_flags: ::std::os::raw::c_int,
    #[doc = " Video decoding only. Certain video codecs support cropping, meaning that"]
    #[doc = " only a sub-rectangle of the decoded frame is intended for display.  This"]
    #[doc = " option controls how cropping is handled by libavcodec."]
    #[doc = ""]
    #[doc = " When set to 1 (the default), libavcodec will apply cropping internally."]
    #[doc = " I.e. it will modify the output frame width/height fields and offset the"]
    #[doc = " data pointers (only by as much as possible while preserving alignment, or"]
    #[doc = " by the full amount if the AV_CODEC_FLAG_UNALIGNED flag is set) so that"]
    #[doc = " the frames output by the decoder refer only to the cropped area. The"]
    #[doc = " crop_* fields of the output frames will be zero."]
    #[doc = ""]
    #[doc = " When set to 0, the width/height fields of the output frames will be set"]
    #[doc = " to the coded dimensions and the crop_* fields will describe the cropping"]
    #[doc = " rectangle. Applying the cropping is left to the caller."]
    #[doc = ""]
    #[doc = " @warning When hardware acceleration with opaque output frames is used,"]
    #[doc = " libavcodec is unable to apply cropping from the top/left border."]
    #[doc = ""]
    #[doc = " @note when this option is set to zero, the width/height fields of the"]
    #[doc = " AVCodecContext and output AVFrames have different meanings. The codec"]
    #[doc = " context fields store display dimensions (with the coded dimensions in"]
    #[doc = " coded_width/height), while the frame fields store the coded dimensions"]
    #[doc = " (with the display dimensions being determined by the crop_* fields)."]
    pub apply_cropping: ::std::os::raw::c_int,
    pub extra_hw_frames: ::std::os::raw::c_int,
    #[doc = " The percentage of damaged samples to discard a frame."]
    #[doc = ""]
    #[doc = " - decoding: set by user"]
    #[doc = " - encoding: unused"]
    pub discard_damaged_percentage: ::std::os::raw::c_int,
    #[doc = " The number of samples per frame to maximally accept."]
    #[doc = ""]
    #[doc = " - decoding: set by user"]
    #[doc = " - encoding: set by user"]
    pub max_samples: i64,
    #[doc = " Bit set of AV_CODEC_EXPORT_DATA_* flags, which affects the kind of"]
    #[doc = " metadata exported in frame, packet, or coded stream side data by"]
    #[doc = " decoders and encoders."]
    #[doc = ""]
    #[doc = " - decoding: set by user"]
    #[doc = " - encoding: set by user"]
    pub export_side_data: ::std::os::raw::c_int,
    #[doc = " This callback is called at the beginning of each packet to get a data"]
    #[doc = " buffer for it."]
    #[doc = ""]
    #[doc = " The following field will be set in the packet before this callback is"]
    #[doc = " called:"]
    #[doc = " - size"]
    #[doc = " This callback must use the above value to calculate the required buffer size,"]
    #[doc = " which must padded by at least AV_INPUT_BUFFER_PADDING_SIZE bytes."]
    #[doc = ""]
    #[doc = " In some specific cases, the encoder may not use the entire buffer allocated by this"]
    #[doc = " callback. This will be reflected in the size value in the packet once returned by"]
    #[doc = " avcodec_receive_packet()."]
    #[doc = ""]
    #[doc = " This callback must fill the following fields in the packet:"]
    #[doc = " - data: alignment requirements for AVPacket apply, if any. Some architectures and"]
    #[doc = "   encoders may benefit from having aligned data."]
    #[doc = " - buf: must contain a pointer to an AVBufferRef structure. The packet's"]
    #[doc = "   data pointer must be contained in it. See: av_buffer_create(), av_buffer_alloc(),"]
    #[doc = "   and av_buffer_ref()."]
    #[doc = ""]
    #[doc = " If AV_CODEC_CAP_DR1 is not set then get_encode_buffer() must call"]
    #[doc = " avcodec_default_get_encode_buffer() instead of providing a buffer allocated by"]
    #[doc = " some other means."]
    #[doc = ""]
    #[doc = " The flags field may contain a combination of AV_GET_ENCODE_BUFFER_FLAG_ flags."]
    #[doc = " They may be used for example to hint what use the buffer may get after being"]
    #[doc = " created."]
    #[doc = " Implementations of this callback may ignore flags they don't understand."]
    #[doc = " If AV_GET_ENCODE_BUFFER_FLAG_REF is set in flags then the packet may be reused"]
    #[doc = " (read and/or written to if it is writable) later by libavcodec."]
    #[doc = ""]
    #[doc = " This callback must be thread-safe, as when frame threading is used, it may"]
    #[doc = " be called from multiple threads simultaneously."]
    #[doc = ""]
    #[doc = " @see avcodec_default_get_encode_buffer()"]
    #[doc = ""]
    #[doc = " - encoding: Set by libavcodec, user can override."]
    #[doc = " - decoding: unused"]
    pub get_encode_buffer: ::std::option::Option<
        unsafe extern "C" fn(
            s: *mut AVCodecContext,
            pkt: *mut AVPacket,
            flags: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
}
#[test]
fn bindgen_test_layout_AVCodecContext() {
    assert_eq!(
        ::std::mem::size_of::<AVCodecContext>(),
        920usize,
        concat!("Size of: ", stringify!(AVCodecContext))
    );
    assert_eq!(
        ::std::mem::align_of::<AVCodecContext>(),
        8usize,
        concat!("Alignment of ", stringify!(AVCodecContext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).av_class as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(av_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).log_level_offset as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(log_level_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).codec_type as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(codec_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).codec as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(codec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).codec_id as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(codec_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).codec_tag as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(codec_tag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).priv_data as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(priv_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).internal as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(internal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).opaque as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(opaque)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).bit_rate as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(bit_rate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).bit_rate_tolerance as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(bit_rate_tolerance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).global_quality as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(global_quality)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).compression_level as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(compression_level)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).flags as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).flags2 as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(flags2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).extradata as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(extradata)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).extradata_size as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(extradata_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).time_base as *const _ as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(time_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).ticks_per_frame as *const _ as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(ticks_per_frame)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).delay as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(delay)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).width as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).height as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).coded_width as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(coded_width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).coded_height as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(coded_height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).gop_size as *const _ as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(gop_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).pix_fmt as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(pix_fmt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).draw_horiz_band as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(draw_horiz_band)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).get_format as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(get_format)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).max_b_frames as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(max_b_frames)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).b_quant_factor as *const _ as usize },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(b_quant_factor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).b_quant_offset as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(b_quant_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).has_b_frames as *const _ as usize },
        172usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(has_b_frames)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).i_quant_factor as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(i_quant_factor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).i_quant_offset as *const _ as usize },
        180usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(i_quant_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).lumi_masking as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(lumi_masking)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).temporal_cplx_masking as *const _ as usize
        },
        188usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(temporal_cplx_masking)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).spatial_cplx_masking as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(spatial_cplx_masking)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).p_masking as *const _ as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(p_masking)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).dark_masking as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(dark_masking)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).slice_count as *const _ as usize },
        204usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(slice_count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).slice_offset as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(slice_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).sample_aspect_ratio as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(sample_aspect_ratio)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).me_cmp as *const _ as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(me_cmp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).me_sub_cmp as *const _ as usize },
        228usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(me_sub_cmp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).mb_cmp as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(mb_cmp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).ildct_cmp as *const _ as usize },
        236usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(ildct_cmp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).dia_size as *const _ as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(dia_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).last_predictor_count as *const _ as usize
        },
        244usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(last_predictor_count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).me_pre_cmp as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(me_pre_cmp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).pre_dia_size as *const _ as usize },
        252usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(pre_dia_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).me_subpel_quality as *const _ as usize
        },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(me_subpel_quality)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).me_range as *const _ as usize },
        260usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(me_range)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).slice_flags as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(slice_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).mb_decision as *const _ as usize },
        268usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(mb_decision)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).intra_matrix as *const _ as usize },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(intra_matrix)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).inter_matrix as *const _ as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(inter_matrix)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).intra_dc_precision as *const _ as usize
        },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(intra_dc_precision)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).skip_top as *const _ as usize },
        292usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(skip_top)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).skip_bottom as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(skip_bottom)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).mb_lmin as *const _ as usize },
        300usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(mb_lmin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).mb_lmax as *const _ as usize },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(mb_lmax)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).bidir_refine as *const _ as usize },
        308usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(bidir_refine)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).keyint_min as *const _ as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(keyint_min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).refs as *const _ as usize },
        316usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(refs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).mv0_threshold as *const _ as usize },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(mv0_threshold)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).color_primaries as *const _ as usize },
        324usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(color_primaries)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).color_trc as *const _ as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(color_trc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).colorspace as *const _ as usize },
        332usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(colorspace)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).color_range as *const _ as usize },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(color_range)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).chroma_sample_location as *const _ as usize
        },
        340usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(chroma_sample_location)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).slices as *const _ as usize },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(slices)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).field_order as *const _ as usize },
        348usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(field_order)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).sample_rate as *const _ as usize },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(sample_rate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).channels as *const _ as usize },
        356usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(channels)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).sample_fmt as *const _ as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(sample_fmt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).frame_size as *const _ as usize },
        364usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(frame_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).frame_number as *const _ as usize },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(frame_number)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).block_align as *const _ as usize },
        372usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(block_align)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).cutoff as *const _ as usize },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(cutoff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).channel_layout as *const _ as usize },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(channel_layout)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).request_channel_layout as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(request_channel_layout)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).audio_service_type as *const _ as usize
        },
        400usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(audio_service_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).request_sample_fmt as *const _ as usize
        },
        404usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(request_sample_fmt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).get_buffer2 as *const _ as usize },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(get_buffer2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).qcompress as *const _ as usize },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(qcompress)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).qblur as *const _ as usize },
        420usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(qblur)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).qmin as *const _ as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(qmin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).qmax as *const _ as usize },
        428usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(qmax)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).max_qdiff as *const _ as usize },
        432usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(max_qdiff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).rc_buffer_size as *const _ as usize },
        436usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(rc_buffer_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).rc_override_count as *const _ as usize
        },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(rc_override_count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).rc_override as *const _ as usize },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(rc_override)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).rc_max_rate as *const _ as usize },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(rc_max_rate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).rc_min_rate as *const _ as usize },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(rc_min_rate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).rc_max_available_vbv_use as *const _ as usize
        },
        472usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(rc_max_available_vbv_use)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).rc_min_vbv_overflow_use as *const _ as usize
        },
        476usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(rc_min_vbv_overflow_use)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).rc_initial_buffer_occupancy as *const _
                as usize
        },
        480usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(rc_initial_buffer_occupancy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).trellis as *const _ as usize },
        484usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(trellis)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).stats_out as *const _ as usize },
        488usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(stats_out)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).stats_in as *const _ as usize },
        496usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(stats_in)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).workaround_bugs as *const _ as usize },
        504usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(workaround_bugs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).strict_std_compliance as *const _ as usize
        },
        508usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(strict_std_compliance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).error_concealment as *const _ as usize
        },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(error_concealment)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).debug as *const _ as usize },
        516usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(debug)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).err_recognition as *const _ as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(err_recognition)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).reordered_opaque as *const _ as usize },
        528usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(reordered_opaque)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).hwaccel as *const _ as usize },
        536usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(hwaccel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).hwaccel_context as *const _ as usize },
        544usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(hwaccel_context)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).error as *const _ as usize },
        552usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(error)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).dct_algo as *const _ as usize },
        616usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(dct_algo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).idct_algo as *const _ as usize },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(idct_algo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).bits_per_coded_sample as *const _ as usize
        },
        624usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(bits_per_coded_sample)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).bits_per_raw_sample as *const _ as usize
        },
        628usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(bits_per_raw_sample)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).lowres as *const _ as usize },
        632usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(lowres)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).thread_count as *const _ as usize },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(thread_count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).thread_type as *const _ as usize },
        640usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(thread_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).active_thread_type as *const _ as usize
        },
        644usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(active_thread_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).thread_safe_callbacks as *const _ as usize
        },
        648usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(thread_safe_callbacks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).execute as *const _ as usize },
        656usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(execute)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).execute2 as *const _ as usize },
        664usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(execute2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).nsse_weight as *const _ as usize },
        672usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(nsse_weight)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).profile as *const _ as usize },
        676usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(profile)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).level as *const _ as usize },
        680usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(level)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).skip_loop_filter as *const _ as usize },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(skip_loop_filter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).skip_idct as *const _ as usize },
        688usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(skip_idct)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).skip_frame as *const _ as usize },
        692usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(skip_frame)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).subtitle_header as *const _ as usize },
        696usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(subtitle_header)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).subtitle_header_size as *const _ as usize
        },
        704usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(subtitle_header_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).initial_padding as *const _ as usize },
        708usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(initial_padding)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).framerate as *const _ as usize },
        712usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(framerate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).sw_pix_fmt as *const _ as usize },
        720usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(sw_pix_fmt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).pkt_timebase as *const _ as usize },
        724usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(pkt_timebase)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).codec_descriptor as *const _ as usize },
        736usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(codec_descriptor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).pts_correction_num_faulty_pts as *const _
                as usize
        },
        744usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(pts_correction_num_faulty_pts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).pts_correction_num_faulty_dts as *const _
                as usize
        },
        752usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(pts_correction_num_faulty_dts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).pts_correction_last_pts as *const _ as usize
        },
        760usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(pts_correction_last_pts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).pts_correction_last_dts as *const _ as usize
        },
        768usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(pts_correction_last_dts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).sub_charenc as *const _ as usize },
        776usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(sub_charenc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).sub_charenc_mode as *const _ as usize },
        784usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(sub_charenc_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).skip_alpha as *const _ as usize },
        788usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(skip_alpha)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).seek_preroll as *const _ as usize },
        792usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(seek_preroll)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).debug_mv as *const _ as usize },
        796usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(debug_mv)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).chroma_intra_matrix as *const _ as usize
        },
        800usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(chroma_intra_matrix)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).dump_separator as *const _ as usize },
        808usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(dump_separator)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).codec_whitelist as *const _ as usize },
        816usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(codec_whitelist)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).properties as *const _ as usize },
        824usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(properties)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).coded_side_data as *const _ as usize },
        832usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(coded_side_data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).nb_coded_side_data as *const _ as usize
        },
        840usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(nb_coded_side_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).hw_frames_ctx as *const _ as usize },
        848usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(hw_frames_ctx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).sub_text_format as *const _ as usize },
        856usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(sub_text_format)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).trailing_padding as *const _ as usize },
        860usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(trailing_padding)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).max_pixels as *const _ as usize },
        864usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(max_pixels)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).hw_device_ctx as *const _ as usize },
        872usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(hw_device_ctx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).hwaccel_flags as *const _ as usize },
        880usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(hwaccel_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).apply_cropping as *const _ as usize },
        884usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(apply_cropping)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).extra_hw_frames as *const _ as usize },
        888usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(extra_hw_frames)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).discard_damaged_percentage as *const _
                as usize
        },
        892usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(discard_damaged_percentage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).max_samples as *const _ as usize },
        896usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(max_samples)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecContext>())).export_side_data as *const _ as usize },
        904usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(export_side_data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecContext>())).get_encode_buffer as *const _ as usize
        },
        912usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecContext),
            "::",
            stringify!(get_encode_buffer)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MpegEncContext {
    _unused: [u8; 0],
}
#[doc = " @defgroup lavc_hwaccel AVHWAccel"]
#[doc = ""]
#[doc = " @note  Nothing in this structure should be accessed by the user.  At some"]
#[doc = "        point in future it will not be externally visible at all."]
#[doc = ""]
#[doc = " @{"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVHWAccel {
    #[doc = " Name of the hardware accelerated codec."]
    #[doc = " The name is globally unique among encoders and among decoders (but an"]
    #[doc = " encoder and a decoder can share the same name)."]
    pub name: *const ::std::os::raw::c_char,
    #[doc = " Type of codec implemented by the hardware accelerator."]
    #[doc = ""]
    #[doc = " See AVMEDIA_TYPE_xxx"]
    pub type_: AVMediaType,
    #[doc = " Codec implemented by the hardware accelerator."]
    #[doc = ""]
    #[doc = " See AV_CODEC_ID_xxx"]
    pub id: AVCodecID,
    #[doc = " Supported pixel format."]
    #[doc = ""]
    #[doc = " Only hardware accelerated formats are supported here."]
    pub pix_fmt: AVPixelFormat,
    #[doc = " Hardware accelerated codec capabilities."]
    #[doc = " see AV_HWACCEL_CODEC_CAP_*"]
    pub capabilities: ::std::os::raw::c_int,
    #[doc = " Allocate a custom buffer"]
    pub alloc_frame: ::std::option::Option<
        unsafe extern "C" fn(
            avctx: *mut AVCodecContext,
            frame: *mut AVFrame,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " Called at the beginning of each frame or field picture."]
    #[doc = ""]
    #[doc = " Meaningful frame information (codec specific) is guaranteed to"]
    #[doc = " be parsed at this point. This function is mandatory."]
    #[doc = ""]
    #[doc = " Note that buf can be NULL along with buf_size set to 0."]
    #[doc = " Otherwise, this means the whole frame is available at this point."]
    #[doc = ""]
    #[doc = " @param avctx the codec context"]
    #[doc = " @param buf the frame data buffer base"]
    #[doc = " @param buf_size the size of the frame in bytes"]
    #[doc = " @return zero if successful, a negative value otherwise"]
    pub start_frame: ::std::option::Option<
        unsafe extern "C" fn(
            avctx: *mut AVCodecContext,
            buf: *const u8,
            buf_size: u32,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " Callback for parameter data (SPS/PPS/VPS etc)."]
    #[doc = ""]
    #[doc = " Useful for hardware decoders which keep persistent state about the"]
    #[doc = " video parameters, and need to receive any changes to update that state."]
    #[doc = ""]
    #[doc = " @param avctx the codec context"]
    #[doc = " @param type the nal unit type"]
    #[doc = " @param buf the nal unit data buffer"]
    #[doc = " @param buf_size the size of the nal unit in bytes"]
    #[doc = " @return zero if successful, a negative value otherwise"]
    pub decode_params: ::std::option::Option<
        unsafe extern "C" fn(
            avctx: *mut AVCodecContext,
            type_: ::std::os::raw::c_int,
            buf: *const u8,
            buf_size: u32,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " Callback for each slice."]
    #[doc = ""]
    #[doc = " Meaningful slice information (codec specific) is guaranteed to"]
    #[doc = " be parsed at this point. This function is mandatory."]
    #[doc = " The only exception is XvMC, that works on MB level."]
    #[doc = ""]
    #[doc = " @param avctx the codec context"]
    #[doc = " @param buf the slice data buffer base"]
    #[doc = " @param buf_size the size of the slice in bytes"]
    #[doc = " @return zero if successful, a negative value otherwise"]
    pub decode_slice: ::std::option::Option<
        unsafe extern "C" fn(
            avctx: *mut AVCodecContext,
            buf: *const u8,
            buf_size: u32,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " Called at the end of each frame or field picture."]
    #[doc = ""]
    #[doc = " The whole picture is parsed at this point and can now be sent"]
    #[doc = " to the hardware accelerator. This function is mandatory."]
    #[doc = ""]
    #[doc = " @param avctx the codec context"]
    #[doc = " @return zero if successful, a negative value otherwise"]
    pub end_frame: ::std::option::Option<
        unsafe extern "C" fn(avctx: *mut AVCodecContext) -> ::std::os::raw::c_int,
    >,
    #[doc = " Size of per-frame hardware accelerator private data."]
    #[doc = ""]
    #[doc = " Private data is allocated with av_mallocz() before"]
    #[doc = " AVCodecContext.get_buffer() and deallocated after"]
    #[doc = " AVCodecContext.release_buffer()."]
    pub frame_priv_data_size: ::std::os::raw::c_int,
    #[doc = " Called for every Macroblock in a slice."]
    #[doc = ""]
    #[doc = " XvMC uses it to replace the ff_mpv_reconstruct_mb()."]
    #[doc = " Instead of decoding to raw picture, MB parameters are"]
    #[doc = " stored in an array provided by the video driver."]
    #[doc = ""]
    #[doc = " @param s the mpeg context"]
    pub decode_mb: ::std::option::Option<unsafe extern "C" fn(s: *mut MpegEncContext)>,
    #[doc = " Initialize the hwaccel private data."]
    #[doc = ""]
    #[doc = " This will be called from ff_get_format(), after hwaccel and"]
    #[doc = " hwaccel_context are set and the hwaccel private data in AVCodecInternal"]
    #[doc = " is allocated."]
    pub init: ::std::option::Option<
        unsafe extern "C" fn(avctx: *mut AVCodecContext) -> ::std::os::raw::c_int,
    >,
    #[doc = " Uninitialize the hwaccel private data."]
    #[doc = ""]
    #[doc = " This will be called from get_format() or avcodec_close(), after hwaccel"]
    #[doc = " and hwaccel_context are already uninitialized."]
    pub uninit: ::std::option::Option<
        unsafe extern "C" fn(avctx: *mut AVCodecContext) -> ::std::os::raw::c_int,
    >,
    #[doc = " Size of the private data to allocate in"]
    #[doc = " AVCodecInternal.hwaccel_priv_data."]
    pub priv_data_size: ::std::os::raw::c_int,
    #[doc = " Internal hwaccel capabilities."]
    pub caps_internal: ::std::os::raw::c_int,
    #[doc = " Fill the given hw_frames context with current codec parameters. Called"]
    #[doc = " from get_format. Refer to avcodec_get_hw_frames_parameters() for"]
    #[doc = " details."]
    #[doc = ""]
    #[doc = " This CAN be called before AVHWAccel.init is called, and you must assume"]
    #[doc = " that avctx->hwaccel_priv_data is invalid."]
    pub frame_params: ::std::option::Option<
        unsafe extern "C" fn(
            avctx: *mut AVCodecContext,
            hw_frames_ctx: *mut AVBufferRef,
        ) -> ::std::os::raw::c_int,
    >,
}
#[test]
fn bindgen_test_layout_AVHWAccel() {
    assert_eq!(
        ::std::mem::size_of::<AVHWAccel>(),
        112usize,
        concat!("Size of: ", stringify!(AVHWAccel))
    );
    assert_eq!(
        ::std::mem::align_of::<AVHWAccel>(),
        8usize,
        concat!("Alignment of ", stringify!(AVHWAccel))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWAccel>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWAccel),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWAccel>())).type_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWAccel),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWAccel>())).id as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWAccel),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWAccel>())).pix_fmt as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWAccel),
            "::",
            stringify!(pix_fmt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWAccel>())).capabilities as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWAccel),
            "::",
            stringify!(capabilities)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWAccel>())).alloc_frame as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWAccel),
            "::",
            stringify!(alloc_frame)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWAccel>())).start_frame as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWAccel),
            "::",
            stringify!(start_frame)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWAccel>())).decode_params as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWAccel),
            "::",
            stringify!(decode_params)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWAccel>())).decode_slice as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWAccel),
            "::",
            stringify!(decode_slice)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWAccel>())).end_frame as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWAccel),
            "::",
            stringify!(end_frame)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWAccel>())).frame_priv_data_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWAccel),
            "::",
            stringify!(frame_priv_data_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWAccel>())).decode_mb as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWAccel),
            "::",
            stringify!(decode_mb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWAccel>())).init as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWAccel),
            "::",
            stringify!(init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWAccel>())).uninit as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWAccel),
            "::",
            stringify!(uninit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWAccel>())).priv_data_size as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWAccel),
            "::",
            stringify!(priv_data_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWAccel>())).caps_internal as *const _ as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWAccel),
            "::",
            stringify!(caps_internal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVHWAccel>())).frame_params as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(AVHWAccel),
            "::",
            stringify!(frame_params)
        )
    );
}
pub const AVSubtitleType_SUBTITLE_NONE: AVSubtitleType = 0;
#[doc = "< A bitmap, pict will be set"]
pub const AVSubtitleType_SUBTITLE_BITMAP: AVSubtitleType = 1;
#[doc = " Plain text, the text field must be set by the decoder and is"]
#[doc = " authoritative. ass and pict fields may contain approximations."]
pub const AVSubtitleType_SUBTITLE_TEXT: AVSubtitleType = 2;
#[doc = " Formatted text, the ass field must be set by the decoder and is"]
#[doc = " authoritative. pict and text fields may contain approximations."]
pub const AVSubtitleType_SUBTITLE_ASS: AVSubtitleType = 3;
#[doc = " @}"]
pub type AVSubtitleType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVSubtitleRect {
    #[doc = "< top left corner  of pict, undefined when pict is not set"]
    pub x: ::std::os::raw::c_int,
    #[doc = "< top left corner  of pict, undefined when pict is not set"]
    pub y: ::std::os::raw::c_int,
    #[doc = "< width            of pict, undefined when pict is not set"]
    pub w: ::std::os::raw::c_int,
    #[doc = "< height           of pict, undefined when pict is not set"]
    pub h: ::std::os::raw::c_int,
    #[doc = "< number of colors in pict, undefined when pict is not set"]
    pub nb_colors: ::std::os::raw::c_int,
    #[doc = " data+linesize for the bitmap of this subtitle."]
    #[doc = " Can be set for text/ass as well once they are rendered."]
    pub data: [*mut u8; 4usize],
    pub linesize: [::std::os::raw::c_int; 4usize],
    pub type_: AVSubtitleType,
    #[doc = "< 0 terminated plain UTF-8 text"]
    pub text: *mut ::std::os::raw::c_char,
    #[doc = " 0 terminated ASS/SSA compatible event line."]
    #[doc = " The presentation of this is unaffected by the other values in this"]
    #[doc = " struct."]
    pub ass: *mut ::std::os::raw::c_char,
    pub flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_AVSubtitleRect() {
    assert_eq!(
        ::std::mem::size_of::<AVSubtitleRect>(),
        104usize,
        concat!("Size of: ", stringify!(AVSubtitleRect))
    );
    assert_eq!(
        ::std::mem::align_of::<AVSubtitleRect>(),
        8usize,
        concat!("Alignment of ", stringify!(AVSubtitleRect))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVSubtitleRect>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVSubtitleRect),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVSubtitleRect>())).y as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(AVSubtitleRect),
            "::",
            stringify!(y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVSubtitleRect>())).w as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVSubtitleRect),
            "::",
            stringify!(w)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVSubtitleRect>())).h as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(AVSubtitleRect),
            "::",
            stringify!(h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVSubtitleRect>())).nb_colors as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVSubtitleRect),
            "::",
            stringify!(nb_colors)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVSubtitleRect>())).data as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVSubtitleRect),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVSubtitleRect>())).linesize as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(AVSubtitleRect),
            "::",
            stringify!(linesize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVSubtitleRect>())).type_ as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(AVSubtitleRect),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVSubtitleRect>())).text as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(AVSubtitleRect),
            "::",
            stringify!(text)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVSubtitleRect>())).ass as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(AVSubtitleRect),
            "::",
            stringify!(ass)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVSubtitleRect>())).flags as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(AVSubtitleRect),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVSubtitle {
    pub format: u16,
    pub start_display_time: u32,
    pub end_display_time: u32,
    pub num_rects: ::std::os::raw::c_uint,
    pub rects: *mut *mut AVSubtitleRect,
    #[doc = "< Same as packet pts, in AV_TIME_BASE"]
    pub pts: i64,
}
#[test]
fn bindgen_test_layout_AVSubtitle() {
    assert_eq!(
        ::std::mem::size_of::<AVSubtitle>(),
        32usize,
        concat!("Size of: ", stringify!(AVSubtitle))
    );
    assert_eq!(
        ::std::mem::align_of::<AVSubtitle>(),
        8usize,
        concat!("Alignment of ", stringify!(AVSubtitle))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVSubtitle>())).format as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVSubtitle),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVSubtitle>())).start_display_time as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(AVSubtitle),
            "::",
            stringify!(start_display_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVSubtitle>())).end_display_time as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVSubtitle),
            "::",
            stringify!(end_display_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVSubtitle>())).num_rects as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(AVSubtitle),
            "::",
            stringify!(num_rects)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVSubtitle>())).rects as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVSubtitle),
            "::",
            stringify!(rects)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVSubtitle>())).pts as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVSubtitle),
            "::",
            stringify!(pts)
        )
    );
}
extern "C" {
    #[doc = " Return the LIBAVCODEC_VERSION_INT constant."]
    pub fn avcodec_version() -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Return the libavcodec build-time configuration."]
    pub fn avcodec_configuration() -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Return the libavcodec license."]
    pub fn avcodec_license() -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Allocate an AVCodecContext and set its fields to default values. The"]
    #[doc = " resulting struct should be freed with avcodec_free_context()."]
    #[doc = ""]
    #[doc = " @param codec if non-NULL, allocate private data and initialize defaults"]
    #[doc = "              for the given codec. It is illegal to then call avcodec_open2()"]
    #[doc = "              with a different codec."]
    #[doc = "              If NULL, then the codec-specific defaults won't be initialized,"]
    #[doc = "              which may result in suboptimal default settings (this is"]
    #[doc = "              important mainly for encoders, e.g. libx264)."]
    #[doc = ""]
    #[doc = " @return An AVCodecContext filled with default values or NULL on failure."]
    pub fn avcodec_alloc_context3(codec: *const AVCodec) -> *mut AVCodecContext;
}
extern "C" {
    #[doc = " Free the codec context and everything associated with it and write NULL to"]
    #[doc = " the provided pointer."]
    pub fn avcodec_free_context(avctx: *mut *mut AVCodecContext);
}
extern "C" {
    #[doc = " Get the AVClass for AVCodecContext. It can be used in combination with"]
    #[doc = " AV_OPT_SEARCH_FAKE_OBJ for examining options."]
    #[doc = ""]
    #[doc = " @see av_opt_find()."]
    pub fn avcodec_get_class() -> *const AVClass;
}
extern "C" {
    #[doc = " @deprecated This function should not be used."]
    pub fn avcodec_get_frame_class() -> *const AVClass;
}
extern "C" {
    #[doc = " Get the AVClass for AVSubtitleRect. It can be used in combination with"]
    #[doc = " AV_OPT_SEARCH_FAKE_OBJ for examining options."]
    #[doc = ""]
    #[doc = " @see av_opt_find()."]
    pub fn avcodec_get_subtitle_rect_class() -> *const AVClass;
}
extern "C" {
    #[doc = " Fill the parameters struct based on the values from the supplied codec"]
    #[doc = " context. Any allocated fields in par are freed and replaced with duplicates"]
    #[doc = " of the corresponding fields in codec."]
    #[doc = ""]
    #[doc = " @return >= 0 on success, a negative AVERROR code on failure"]
    pub fn avcodec_parameters_from_context(
        par: *mut AVCodecParameters,
        codec: *const AVCodecContext,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Fill the codec context based on the values from the supplied codec"]
    #[doc = " parameters. Any allocated fields in codec that have a corresponding field in"]
    #[doc = " par are freed and replaced with duplicates of the corresponding field in par."]
    #[doc = " Fields in codec that do not have a counterpart in par are not touched."]
    #[doc = ""]
    #[doc = " @return >= 0 on success, a negative AVERROR code on failure."]
    pub fn avcodec_parameters_to_context(
        codec: *mut AVCodecContext,
        par: *const AVCodecParameters,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Initialize the AVCodecContext to use the given AVCodec. Prior to using this"]
    #[doc = " function the context has to be allocated with avcodec_alloc_context3()."]
    #[doc = ""]
    #[doc = " The functions avcodec_find_decoder_by_name(), avcodec_find_encoder_by_name(),"]
    #[doc = " avcodec_find_decoder() and avcodec_find_encoder() provide an easy way for"]
    #[doc = " retrieving a codec."]
    #[doc = ""]
    #[doc = " @warning This function is not thread safe!"]
    #[doc = ""]
    #[doc = " @note Always call this function before using decoding routines (such as"]
    #[doc = " @ref avcodec_receive_frame())."]
    #[doc = ""]
    #[doc = " @code"]
    #[doc = " av_dict_set(&opts, \"b\", \"2.5M\", 0);"]
    #[doc = " codec = avcodec_find_decoder(AV_CODEC_ID_H264);"]
    #[doc = " if (!codec)"]
    #[doc = "     exit(1);"]
    #[doc = ""]
    #[doc = " context = avcodec_alloc_context3(codec);"]
    #[doc = ""]
    #[doc = " if (avcodec_open2(context, codec, opts) < 0)"]
    #[doc = "     exit(1);"]
    #[doc = " @endcode"]
    #[doc = ""]
    #[doc = " @param avctx The context to initialize."]
    #[doc = " @param codec The codec to open this context for. If a non-NULL codec has been"]
    #[doc = "              previously passed to avcodec_alloc_context3() or"]
    #[doc = "              for this context, then this parameter MUST be either NULL or"]
    #[doc = "              equal to the previously passed codec."]
    #[doc = " @param options A dictionary filled with AVCodecContext and codec-private options."]
    #[doc = "                On return this object will be filled with options that were not found."]
    #[doc = ""]
    #[doc = " @return zero on success, a negative value on error"]
    #[doc = " @see avcodec_alloc_context3(), avcodec_find_decoder(), avcodec_find_encoder(),"]
    #[doc = "      av_dict_set(), av_opt_find()."]
    pub fn avcodec_open2(
        avctx: *mut AVCodecContext,
        codec: *const AVCodec,
        options: *mut *mut AVDictionary,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Close a given AVCodecContext and free all the data associated with it"]
    #[doc = " (but not the AVCodecContext itself)."]
    #[doc = ""]
    #[doc = " Calling this function on an AVCodecContext that hasn't been opened will free"]
    #[doc = " the codec-specific data allocated in avcodec_alloc_context3() with a non-NULL"]
    #[doc = " codec. Subsequent calls will do nothing."]
    #[doc = ""]
    #[doc = " @note Do not use this function. Use avcodec_free_context() to destroy a"]
    #[doc = " codec context (either open or closed). Opening and closing a codec context"]
    #[doc = " multiple times is not supported anymore -- use multiple codec contexts"]
    #[doc = " instead."]
    pub fn avcodec_close(avctx: *mut AVCodecContext) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Free all allocated data in the given subtitle struct."]
    #[doc = ""]
    #[doc = " @param sub AVSubtitle to free."]
    pub fn avsubtitle_free(sub: *mut AVSubtitle);
}
extern "C" {
    #[doc = " The default callback for AVCodecContext.get_buffer2(). It is made public so"]
    #[doc = " it can be called by custom get_buffer2() implementations for decoders without"]
    #[doc = " AV_CODEC_CAP_DR1 set."]
    pub fn avcodec_default_get_buffer2(
        s: *mut AVCodecContext,
        frame: *mut AVFrame,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " The default callback for AVCodecContext.get_encode_buffer(). It is made public so"]
    #[doc = " it can be called by custom get_encode_buffer() implementations for encoders without"]
    #[doc = " AV_CODEC_CAP_DR1 set."]
    pub fn avcodec_default_get_encode_buffer(
        s: *mut AVCodecContext,
        pkt: *mut AVPacket,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Modify width and height values so that they will result in a memory"]
    #[doc = " buffer that is acceptable for the codec if you do not use any horizontal"]
    #[doc = " padding."]
    #[doc = ""]
    #[doc = " May only be used if a codec with AV_CODEC_CAP_DR1 has been opened."]
    pub fn avcodec_align_dimensions(
        s: *mut AVCodecContext,
        width: *mut ::std::os::raw::c_int,
        height: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    #[doc = " Modify width and height values so that they will result in a memory"]
    #[doc = " buffer that is acceptable for the codec if you also ensure that all"]
    #[doc = " line sizes are a multiple of the respective linesize_align[i]."]
    #[doc = ""]
    #[doc = " May only be used if a codec with AV_CODEC_CAP_DR1 has been opened."]
    pub fn avcodec_align_dimensions2(
        s: *mut AVCodecContext,
        width: *mut ::std::os::raw::c_int,
        height: *mut ::std::os::raw::c_int,
        linesize_align: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    #[doc = " Converts AVChromaLocation to swscale x/y chroma position."]
    #[doc = ""]
    #[doc = " The positions represent the chroma (0,0) position in a coordinates system"]
    #[doc = " with luma (0,0) representing the origin and luma(1,1) representing 256,256"]
    #[doc = ""]
    #[doc = " @param xpos  horizontal chroma sample position"]
    #[doc = " @param ypos  vertical   chroma sample position"]
    pub fn avcodec_enum_to_chroma_pos(
        xpos: *mut ::std::os::raw::c_int,
        ypos: *mut ::std::os::raw::c_int,
        pos: AVChromaLocation,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Converts swscale x/y chroma position to AVChromaLocation."]
    #[doc = ""]
    #[doc = " The positions represent the chroma (0,0) position in a coordinates system"]
    #[doc = " with luma (0,0) representing the origin and luma(1,1) representing 256,256"]
    #[doc = ""]
    #[doc = " @param xpos  horizontal chroma sample position"]
    #[doc = " @param ypos  vertical   chroma sample position"]
    pub fn avcodec_chroma_pos_to_enum(
        xpos: ::std::os::raw::c_int,
        ypos: ::std::os::raw::c_int,
    ) -> AVChromaLocation;
}
extern "C" {
    #[doc = " Decode a subtitle message."]
    #[doc = " Return a negative value on error, otherwise return the number of bytes used."]
    #[doc = " If no subtitle could be decompressed, got_sub_ptr is zero."]
    #[doc = " Otherwise, the subtitle is stored in *sub."]
    #[doc = " Note that AV_CODEC_CAP_DR1 is not available for subtitle codecs. This is for"]
    #[doc = " simplicity, because the performance difference is expected to be negligible"]
    #[doc = " and reusing a get_buffer written for video codecs would probably perform badly"]
    #[doc = " due to a potentially very different allocation pattern."]
    #[doc = ""]
    #[doc = " Some decoders (those marked with AV_CODEC_CAP_DELAY) have a delay between input"]
    #[doc = " and output. This means that for some packets they will not immediately"]
    #[doc = " produce decoded output and need to be flushed at the end of decoding to get"]
    #[doc = " all the decoded data. Flushing is done by calling this function with packets"]
    #[doc = " with avpkt->data set to NULL and avpkt->size set to 0 until it stops"]
    #[doc = " returning subtitles. It is safe to flush even those decoders that are not"]
    #[doc = " marked with AV_CODEC_CAP_DELAY, then no subtitles will be returned."]
    #[doc = ""]
    #[doc = " @note The AVCodecContext MUST have been opened with @ref avcodec_open2()"]
    #[doc = " before packets may be fed to the decoder."]
    #[doc = ""]
    #[doc = " @param avctx the codec context"]
    #[doc = " @param[out] sub The preallocated AVSubtitle in which the decoded subtitle will be stored,"]
    #[doc = "                 must be freed with avsubtitle_free if *got_sub_ptr is set."]
    #[doc = " @param[in,out] got_sub_ptr Zero if no subtitle could be decompressed, otherwise, it is nonzero."]
    #[doc = " @param[in] avpkt The input AVPacket containing the input buffer."]
    pub fn avcodec_decode_subtitle2(
        avctx: *mut AVCodecContext,
        sub: *mut AVSubtitle,
        got_sub_ptr: *mut ::std::os::raw::c_int,
        avpkt: *mut AVPacket,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Supply raw packet data as input to a decoder."]
    #[doc = ""]
    #[doc = " Internally, this call will copy relevant AVCodecContext fields, which can"]
    #[doc = " influence decoding per-packet, and apply them when the packet is actually"]
    #[doc = " decoded. (For example AVCodecContext.skip_frame, which might direct the"]
    #[doc = " decoder to drop the frame contained by the packet sent with this function.)"]
    #[doc = ""]
    #[doc = " @warning The input buffer, avpkt->data must be AV_INPUT_BUFFER_PADDING_SIZE"]
    #[doc = "          larger than the actual read bytes because some optimized bitstream"]
    #[doc = "          readers read 32 or 64 bits at once and could read over the end."]
    #[doc = ""]
    #[doc = " @note The AVCodecContext MUST have been opened with @ref avcodec_open2()"]
    #[doc = "       before packets may be fed to the decoder."]
    #[doc = ""]
    #[doc = " @param avctx codec context"]
    #[doc = " @param[in] avpkt The input AVPacket. Usually, this will be a single video"]
    #[doc = "                  frame, or several complete audio frames."]
    #[doc = "                  Ownership of the packet remains with the caller, and the"]
    #[doc = "                  decoder will not write to the packet. The decoder may create"]
    #[doc = "                  a reference to the packet data (or copy it if the packet is"]
    #[doc = "                  not reference-counted)."]
    #[doc = "                  Unlike with older APIs, the packet is always fully consumed,"]
    #[doc = "                  and if it contains multiple frames (e.g. some audio codecs),"]
    #[doc = "                  will require you to call avcodec_receive_frame() multiple"]
    #[doc = "                  times afterwards before you can send a new packet."]
    #[doc = "                  It can be NULL (or an AVPacket with data set to NULL and"]
    #[doc = "                  size set to 0); in this case, it is considered a flush"]
    #[doc = "                  packet, which signals the end of the stream. Sending the"]
    #[doc = "                  first flush packet will return success. Subsequent ones are"]
    #[doc = "                  unnecessary and will return AVERROR_EOF. If the decoder"]
    #[doc = "                  still has frames buffered, it will return them after sending"]
    #[doc = "                  a flush packet."]
    #[doc = ""]
    #[doc = " @return 0 on success, otherwise negative error code:"]
    #[doc = "      AVERROR(EAGAIN):   input is not accepted in the current state - user"]
    #[doc = "                         must read output with avcodec_receive_frame() (once"]
    #[doc = "                         all output is read, the packet should be resent, and"]
    #[doc = "                         the call will not fail with EAGAIN)."]
    #[doc = "      AVERROR_EOF:       the decoder has been flushed, and no new packets can"]
    #[doc = "                         be sent to it (also returned if more than 1 flush"]
    #[doc = "                         packet is sent)"]
    #[doc = "      AVERROR(EINVAL):   codec not opened, it is an encoder, or requires flush"]
    #[doc = "      AVERROR(ENOMEM):   failed to add packet to internal queue, or similar"]
    #[doc = "      other errors: legitimate decoding errors"]
    pub fn avcodec_send_packet(
        avctx: *mut AVCodecContext,
        avpkt: *const AVPacket,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Return decoded output data from a decoder."]
    #[doc = ""]
    #[doc = " @param avctx codec context"]
    #[doc = " @param frame This will be set to a reference-counted video or audio"]
    #[doc = "              frame (depending on the decoder type) allocated by the"]
    #[doc = "              decoder. Note that the function will always call"]
    #[doc = "              av_frame_unref(frame) before doing anything else."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      0:                 success, a frame was returned"]
    #[doc = "      AVERROR(EAGAIN):   output is not available in this state - user must try"]
    #[doc = "                         to send new input"]
    #[doc = "      AVERROR_EOF:       the decoder has been fully flushed, and there will be"]
    #[doc = "                         no more output frames"]
    #[doc = "      AVERROR(EINVAL):   codec not opened, or it is an encoder"]
    #[doc = "      AVERROR_INPUT_CHANGED:   current decoded frame has changed parameters"]
    #[doc = "                               with respect to first decoded frame. Applicable"]
    #[doc = "                               when flag AV_CODEC_FLAG_DROPCHANGED is set."]
    #[doc = "      other negative values: legitimate decoding errors"]
    pub fn avcodec_receive_frame(
        avctx: *mut AVCodecContext,
        frame: *mut AVFrame,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Supply a raw video or audio frame to the encoder. Use avcodec_receive_packet()"]
    #[doc = " to retrieve buffered output packets."]
    #[doc = ""]
    #[doc = " @param avctx     codec context"]
    #[doc = " @param[in] frame AVFrame containing the raw audio or video frame to be encoded."]
    #[doc = "                  Ownership of the frame remains with the caller, and the"]
    #[doc = "                  encoder will not write to the frame. The encoder may create"]
    #[doc = "                  a reference to the frame data (or copy it if the frame is"]
    #[doc = "                  not reference-counted)."]
    #[doc = "                  It can be NULL, in which case it is considered a flush"]
    #[doc = "                  packet.  This signals the end of the stream. If the encoder"]
    #[doc = "                  still has packets buffered, it will return them after this"]
    #[doc = "                  call. Once flushing mode has been entered, additional flush"]
    #[doc = "                  packets are ignored, and sending frames will return"]
    #[doc = "                  AVERROR_EOF."]
    #[doc = ""]
    #[doc = "                  For audio:"]
    #[doc = "                  If AV_CODEC_CAP_VARIABLE_FRAME_SIZE is set, then each frame"]
    #[doc = "                  can have any number of samples."]
    #[doc = "                  If it is not set, frame->nb_samples must be equal to"]
    #[doc = "                  avctx->frame_size for all frames except the last."]
    #[doc = "                  The final frame may be smaller than avctx->frame_size."]
    #[doc = " @return 0 on success, otherwise negative error code:"]
    #[doc = "      AVERROR(EAGAIN):   input is not accepted in the current state - user"]
    #[doc = "                         must read output with avcodec_receive_packet() (once"]
    #[doc = "                         all output is read, the packet should be resent, and"]
    #[doc = "                         the call will not fail with EAGAIN)."]
    #[doc = "      AVERROR_EOF:       the encoder has been flushed, and no new frames can"]
    #[doc = "                         be sent to it"]
    #[doc = "      AVERROR(EINVAL):   codec not opened, refcounted_frames not set, it is a"]
    #[doc = "                         decoder, or requires flush"]
    #[doc = "      AVERROR(ENOMEM):   failed to add packet to internal queue, or similar"]
    #[doc = "      other errors: legitimate encoding errors"]
    pub fn avcodec_send_frame(
        avctx: *mut AVCodecContext,
        frame: *const AVFrame,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Read encoded data from the encoder."]
    #[doc = ""]
    #[doc = " @param avctx codec context"]
    #[doc = " @param avpkt This will be set to a reference-counted packet allocated by the"]
    #[doc = "              encoder. Note that the function will always call"]
    #[doc = "              av_packet_unref(avpkt) before doing anything else."]
    #[doc = " @return 0 on success, otherwise negative error code:"]
    #[doc = "      AVERROR(EAGAIN):   output is not available in the current state - user"]
    #[doc = "                         must try to send input"]
    #[doc = "      AVERROR_EOF:       the encoder has been fully flushed, and there will be"]
    #[doc = "                         no more output packets"]
    #[doc = "      AVERROR(EINVAL):   codec not opened, or it is a decoder"]
    #[doc = "      other errors: legitimate encoding errors"]
    pub fn avcodec_receive_packet(
        avctx: *mut AVCodecContext,
        avpkt: *mut AVPacket,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Create and return a AVHWFramesContext with values adequate for hardware"]
    #[doc = " decoding. This is meant to get called from the get_format callback, and is"]
    #[doc = " a helper for preparing a AVHWFramesContext for AVCodecContext.hw_frames_ctx."]
    #[doc = " This API is for decoding with certain hardware acceleration modes/APIs only."]
    #[doc = ""]
    #[doc = " The returned AVHWFramesContext is not initialized. The caller must do this"]
    #[doc = " with av_hwframe_ctx_init()."]
    #[doc = ""]
    #[doc = " Calling this function is not a requirement, but makes it simpler to avoid"]
    #[doc = " codec or hardware API specific details when manually allocating frames."]
    #[doc = ""]
    #[doc = " Alternatively to this, an API user can set AVCodecContext.hw_device_ctx,"]
    #[doc = " which sets up AVCodecContext.hw_frames_ctx fully automatically, and makes"]
    #[doc = " it unnecessary to call this function or having to care about"]
    #[doc = " AVHWFramesContext initialization at all."]
    #[doc = ""]
    #[doc = " There are a number of requirements for calling this function:"]
    #[doc = ""]
    #[doc = " - It must be called from get_format with the same avctx parameter that was"]
    #[doc = "   passed to get_format. Calling it outside of get_format is not allowed, and"]
    #[doc = "   can trigger undefined behavior."]
    #[doc = " - The function is not always supported (see description of return values)."]
    #[doc = "   Even if this function returns successfully, hwaccel initialization could"]
    #[doc = "   fail later. (The degree to which implementations check whether the stream"]
    #[doc = "   is actually supported varies. Some do this check only after the user's"]
    #[doc = "   get_format callback returns.)"]
    #[doc = " - The hw_pix_fmt must be one of the choices suggested by get_format. If the"]
    #[doc = "   user decides to use a AVHWFramesContext prepared with this API function,"]
    #[doc = "   the user must return the same hw_pix_fmt from get_format."]
    #[doc = " - The device_ref passed to this function must support the given hw_pix_fmt."]
    #[doc = " - After calling this API function, it is the user's responsibility to"]
    #[doc = "   initialize the AVHWFramesContext (returned by the out_frames_ref parameter),"]
    #[doc = "   and to set AVCodecContext.hw_frames_ctx to it. If done, this must be done"]
    #[doc = "   before returning from get_format (this is implied by the normal"]
    #[doc = "   AVCodecContext.hw_frames_ctx API rules)."]
    #[doc = " - The AVHWFramesContext parameters may change every time time get_format is"]
    #[doc = "   called. Also, AVCodecContext.hw_frames_ctx is reset before get_format. So"]
    #[doc = "   you are inherently required to go through this process again on every"]
    #[doc = "   get_format call."]
    #[doc = " - It is perfectly possible to call this function without actually using"]
    #[doc = "   the resulting AVHWFramesContext. One use-case might be trying to reuse a"]
    #[doc = "   previously initialized AVHWFramesContext, and calling this API function"]
    #[doc = "   only to test whether the required frame parameters have changed."]
    #[doc = " - Fields that use dynamically allocated values of any kind must not be set"]
    #[doc = "   by the user unless setting them is explicitly allowed by the documentation."]
    #[doc = "   If the user sets AVHWFramesContext.free and AVHWFramesContext.user_opaque,"]
    #[doc = "   the new free callback must call the potentially set previous free callback."]
    #[doc = "   This API call may set any dynamically allocated fields, including the free"]
    #[doc = "   callback."]
    #[doc = ""]
    #[doc = " The function will set at least the following fields on AVHWFramesContext"]
    #[doc = " (potentially more, depending on hwaccel API):"]
    #[doc = ""]
    #[doc = " - All fields set by av_hwframe_ctx_alloc()."]
    #[doc = " - Set the format field to hw_pix_fmt."]
    #[doc = " - Set the sw_format field to the most suited and most versatile format. (An"]
    #[doc = "   implication is that this will prefer generic formats over opaque formats"]
    #[doc = "   with arbitrary restrictions, if possible.)"]
    #[doc = " - Set the width/height fields to the coded frame size, rounded up to the"]
    #[doc = "   API-specific minimum alignment."]
    #[doc = " - Only _if_ the hwaccel requires a pre-allocated pool: set the initial_pool_size"]
    #[doc = "   field to the number of maximum reference surfaces possible with the codec,"]
    #[doc = "   plus 1 surface for the user to work (meaning the user can safely reference"]
    #[doc = "   at most 1 decoded surface at a time), plus additional buffering introduced"]
    #[doc = "   by frame threading. If the hwaccel does not require pre-allocation, the"]
    #[doc = "   field is left to 0, and the decoder will allocate new surfaces on demand"]
    #[doc = "   during decoding."]
    #[doc = " - Possibly AVHWFramesContext.hwctx fields, depending on the underlying"]
    #[doc = "   hardware API."]
    #[doc = ""]
    #[doc = " Essentially, out_frames_ref returns the same as av_hwframe_ctx_alloc(), but"]
    #[doc = " with basic frame parameters set."]
    #[doc = ""]
    #[doc = " The function is stateless, and does not change the AVCodecContext or the"]
    #[doc = " device_ref AVHWDeviceContext."]
    #[doc = ""]
    #[doc = " @param avctx The context which is currently calling get_format, and which"]
    #[doc = "              implicitly contains all state needed for filling the returned"]
    #[doc = "              AVHWFramesContext properly."]
    #[doc = " @param device_ref A reference to the AVHWDeviceContext describing the device"]
    #[doc = "                   which will be used by the hardware decoder."]
    #[doc = " @param hw_pix_fmt The hwaccel format you are going to return from get_format."]
    #[doc = " @param out_frames_ref On success, set to a reference to an _uninitialized_"]
    #[doc = "                       AVHWFramesContext, created from the given device_ref."]
    #[doc = "                       Fields will be set to values required for decoding."]
    #[doc = "                       Not changed if an error is returned."]
    #[doc = " @return zero on success, a negative value on error. The following error codes"]
    #[doc = "         have special semantics:"]
    #[doc = "      AVERROR(ENOENT): the decoder does not support this functionality. Setup"]
    #[doc = "                       is always manual, or it is a decoder which does not"]
    #[doc = "                       support setting AVCodecContext.hw_frames_ctx at all,"]
    #[doc = "                       or it is a software format."]
    #[doc = "      AVERROR(EINVAL): it is known that hardware decoding is not supported for"]
    #[doc = "                       this configuration, or the device_ref is not supported"]
    #[doc = "                       for the hwaccel referenced by hw_pix_fmt."]
    pub fn avcodec_get_hw_frames_parameters(
        avctx: *mut AVCodecContext,
        device_ref: *mut AVBufferRef,
        hw_pix_fmt: AVPixelFormat,
        out_frames_ref: *mut *mut AVBufferRef,
    ) -> ::std::os::raw::c_int;
}
pub const AVPictureStructure_AV_PICTURE_STRUCTURE_UNKNOWN: AVPictureStructure = 0;
pub const AVPictureStructure_AV_PICTURE_STRUCTURE_TOP_FIELD: AVPictureStructure = 1;
pub const AVPictureStructure_AV_PICTURE_STRUCTURE_BOTTOM_FIELD: AVPictureStructure = 2;
pub const AVPictureStructure_AV_PICTURE_STRUCTURE_FRAME: AVPictureStructure = 3;
#[doc = " @defgroup lavc_parsing Frame parsing"]
#[doc = " @{"]
pub type AVPictureStructure = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVCodecParserContext {
    pub priv_data: *mut ::std::os::raw::c_void,
    pub parser: *const AVCodecParser,
    pub frame_offset: i64,
    pub cur_offset: i64,
    pub next_frame_offset: i64,
    pub pict_type: ::std::os::raw::c_int,
    #[doc = " This field is used for proper frame duration computation in lavf."]
    #[doc = " It signals, how much longer the frame duration of the current frame"]
    #[doc = " is compared to normal frame duration."]
    #[doc = ""]
    #[doc = " frame_duration = (1 + repeat_pict) * time_base"]
    #[doc = ""]
    #[doc = " It is used by codecs like H.264 to display telecined material."]
    pub repeat_pict: ::std::os::raw::c_int,
    pub pts: i64,
    pub dts: i64,
    pub last_pts: i64,
    pub last_dts: i64,
    pub fetch_timestamp: ::std::os::raw::c_int,
    pub cur_frame_start_index: ::std::os::raw::c_int,
    pub cur_frame_offset: [i64; 4usize],
    pub cur_frame_pts: [i64; 4usize],
    pub cur_frame_dts: [i64; 4usize],
    pub flags: ::std::os::raw::c_int,
    #[doc = "< byte offset from starting packet start"]
    pub offset: i64,
    pub cur_frame_end: [i64; 4usize],
    #[doc = " Set by parser to 1 for key frames and 0 for non-key frames."]
    #[doc = " It is initialized to -1, so if the parser doesn't set this flag,"]
    #[doc = " old-style fallback using AV_PICTURE_TYPE_I picture type as key frames"]
    #[doc = " will be used."]
    pub key_frame: ::std::os::raw::c_int,
    #[doc = " Synchronization point for start of timestamp generation."]
    #[doc = ""]
    #[doc = " Set to >0 for sync point, 0 for no sync point and <0 for undefined"]
    #[doc = " (default)."]
    #[doc = ""]
    #[doc = " For example, this corresponds to presence of H.264 buffering period"]
    #[doc = " SEI message."]
    pub dts_sync_point: ::std::os::raw::c_int,
    #[doc = " Offset of the current timestamp against last timestamp sync point in"]
    #[doc = " units of AVCodecContext.time_base."]
    #[doc = ""]
    #[doc = " Set to INT_MIN when dts_sync_point unused. Otherwise, it must"]
    #[doc = " contain a valid timestamp offset."]
    #[doc = ""]
    #[doc = " Note that the timestamp of sync point has usually a nonzero"]
    #[doc = " dts_ref_dts_delta, which refers to the previous sync point. Offset of"]
    #[doc = " the next frame after timestamp sync point will be usually 1."]
    #[doc = ""]
    #[doc = " For example, this corresponds to H.264 cpb_removal_delay."]
    pub dts_ref_dts_delta: ::std::os::raw::c_int,
    #[doc = " Presentation delay of current frame in units of AVCodecContext.time_base."]
    #[doc = ""]
    #[doc = " Set to INT_MIN when dts_sync_point unused. Otherwise, it must"]
    #[doc = " contain valid non-negative timestamp delta (presentation time of a frame"]
    #[doc = " must not lie in the past)."]
    #[doc = ""]
    #[doc = " This delay represents the difference between decoding and presentation"]
    #[doc = " time of the frame."]
    #[doc = ""]
    #[doc = " For example, this corresponds to H.264 dpb_output_delay."]
    pub pts_dts_delta: ::std::os::raw::c_int,
    #[doc = " Position of the packet in file."]
    #[doc = ""]
    #[doc = " Analogous to cur_frame_pts/dts"]
    pub cur_frame_pos: [i64; 4usize],
    #[doc = " Byte position of currently parsed frame in stream."]
    pub pos: i64,
    #[doc = " Previous frame byte position."]
    pub last_pos: i64,
    #[doc = " Duration of the current frame."]
    #[doc = " For audio, this is in units of 1 / AVCodecContext.sample_rate."]
    #[doc = " For all other types, this is in units of AVCodecContext.time_base."]
    pub duration: ::std::os::raw::c_int,
    pub field_order: AVFieldOrder,
    #[doc = " Indicate whether a picture is coded as a frame, top field or bottom field."]
    #[doc = ""]
    #[doc = " For example, H.264 field_pic_flag equal to 0 corresponds to"]
    #[doc = " AV_PICTURE_STRUCTURE_FRAME. An H.264 picture with field_pic_flag"]
    #[doc = " equal to 1 and bottom_field_flag equal to 0 corresponds to"]
    #[doc = " AV_PICTURE_STRUCTURE_TOP_FIELD."]
    pub picture_structure: AVPictureStructure,
    #[doc = " Picture number incremented in presentation or output order."]
    #[doc = " This field may be reinitialized at the first picture of a new sequence."]
    #[doc = ""]
    #[doc = " For example, this corresponds to H.264 PicOrderCnt."]
    pub output_picture_number: ::std::os::raw::c_int,
    #[doc = " Dimensions of the decoded video intended for presentation."]
    pub width: ::std::os::raw::c_int,
    pub height: ::std::os::raw::c_int,
    #[doc = " Dimensions of the coded video."]
    pub coded_width: ::std::os::raw::c_int,
    pub coded_height: ::std::os::raw::c_int,
    #[doc = " The format of the coded data, corresponds to enum AVPixelFormat for video"]
    #[doc = " and for enum AVSampleFormat for audio."]
    #[doc = ""]
    #[doc = " Note that a decoder can have considerable freedom in how exactly it"]
    #[doc = " decodes the data, so the format reported here might be different from the"]
    #[doc = " one returned by a decoder."]
    pub format: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_AVCodecParserContext() {
    assert_eq!(
        ::std::mem::size_of::<AVCodecParserContext>(),
        336usize,
        concat!("Size of: ", stringify!(AVCodecParserContext))
    );
    assert_eq!(
        ::std::mem::align_of::<AVCodecParserContext>(),
        8usize,
        concat!("Alignment of ", stringify!(AVCodecParserContext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParserContext>())).priv_data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(priv_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParserContext>())).parser as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(parser)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParserContext>())).frame_offset as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(frame_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParserContext>())).cur_offset as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(cur_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParserContext>())).next_frame_offset as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(next_frame_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParserContext>())).pict_type as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(pict_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParserContext>())).repeat_pict as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(repeat_pict)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParserContext>())).pts as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(pts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParserContext>())).dts as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(dts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParserContext>())).last_pts as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(last_pts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParserContext>())).last_dts as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(last_dts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParserContext>())).fetch_timestamp as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(fetch_timestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParserContext>())).cur_frame_start_index as *const _
                as usize
        },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(cur_frame_start_index)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParserContext>())).cur_frame_offset as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(cur_frame_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParserContext>())).cur_frame_pts as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(cur_frame_pts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParserContext>())).cur_frame_dts as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(cur_frame_dts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParserContext>())).flags as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParserContext>())).offset as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParserContext>())).cur_frame_end as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(cur_frame_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParserContext>())).key_frame as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(key_frame)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParserContext>())).dts_sync_point as *const _ as usize
        },
        236usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(dts_sync_point)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParserContext>())).dts_ref_dts_delta as *const _ as usize
        },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(dts_ref_dts_delta)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParserContext>())).pts_dts_delta as *const _ as usize
        },
        244usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(pts_dts_delta)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParserContext>())).cur_frame_pos as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(cur_frame_pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParserContext>())).pos as *const _ as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParserContext>())).last_pos as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(last_pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParserContext>())).duration as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(duration)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParserContext>())).field_order as *const _ as usize
        },
        300usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(field_order)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParserContext>())).picture_structure as *const _ as usize
        },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(picture_structure)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParserContext>())).output_picture_number as *const _
                as usize
        },
        308usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(output_picture_number)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParserContext>())).width as *const _ as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParserContext>())).height as *const _ as usize },
        316usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParserContext>())).coded_width as *const _ as usize
        },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(coded_width)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVCodecParserContext>())).coded_height as *const _ as usize
        },
        324usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(coded_height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParserContext>())).format as *const _ as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParserContext),
            "::",
            stringify!(format)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVCodecParser {
    pub codec_ids: [::std::os::raw::c_int; 5usize],
    pub priv_data_size: ::std::os::raw::c_int,
    pub parser_init: ::std::option::Option<
        unsafe extern "C" fn(s: *mut AVCodecParserContext) -> ::std::os::raw::c_int,
    >,
    pub parser_parse: ::std::option::Option<
        unsafe extern "C" fn(
            s: *mut AVCodecParserContext,
            avctx: *mut AVCodecContext,
            poutbuf: *mut *const u8,
            poutbuf_size: *mut ::std::os::raw::c_int,
            buf: *const u8,
            buf_size: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub parser_close: ::std::option::Option<unsafe extern "C" fn(s: *mut AVCodecParserContext)>,
    pub split: ::std::option::Option<
        unsafe extern "C" fn(
            avctx: *mut AVCodecContext,
            buf: *const u8,
            buf_size: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
}
#[test]
fn bindgen_test_layout_AVCodecParser() {
    assert_eq!(
        ::std::mem::size_of::<AVCodecParser>(),
        56usize,
        concat!("Size of: ", stringify!(AVCodecParser))
    );
    assert_eq!(
        ::std::mem::align_of::<AVCodecParser>(),
        8usize,
        concat!("Alignment of ", stringify!(AVCodecParser))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParser>())).codec_ids as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParser),
            "::",
            stringify!(codec_ids)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParser>())).priv_data_size as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParser),
            "::",
            stringify!(priv_data_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParser>())).parser_init as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParser),
            "::",
            stringify!(parser_init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParser>())).parser_parse as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParser),
            "::",
            stringify!(parser_parse)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParser>())).parser_close as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParser),
            "::",
            stringify!(parser_close)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVCodecParser>())).split as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(AVCodecParser),
            "::",
            stringify!(split)
        )
    );
}
extern "C" {
    #[doc = " Iterate over all registered codec parsers."]
    #[doc = ""]
    #[doc = " @param opaque a pointer where libavcodec will store the iteration state. Must"]
    #[doc = "               point to NULL to start the iteration."]
    #[doc = ""]
    #[doc = " @return the next registered codec parser or NULL when the iteration is"]
    #[doc = "         finished"]
    pub fn av_parser_iterate(opaque: *mut *mut ::std::os::raw::c_void) -> *const AVCodecParser;
}
extern "C" {
    pub fn av_parser_init(codec_id: ::std::os::raw::c_int) -> *mut AVCodecParserContext;
}
extern "C" {
    #[doc = " Parse a packet."]
    #[doc = ""]
    #[doc = " @param s             parser context."]
    #[doc = " @param avctx         codec context."]
    #[doc = " @param poutbuf       set to pointer to parsed buffer or NULL if not yet finished."]
    #[doc = " @param poutbuf_size  set to size of parsed buffer or zero if not yet finished."]
    #[doc = " @param buf           input buffer."]
    #[doc = " @param buf_size      buffer size in bytes without the padding. I.e. the full buffer"]
    #[doc = "size is assumed to be buf_size + AV_INPUT_BUFFER_PADDING_SIZE."]
    #[doc = "To signal EOF, this should be 0 (so that the last frame"]
    #[doc = "can be output)."]
    #[doc = " @param pts           input presentation timestamp."]
    #[doc = " @param dts           input decoding timestamp."]
    #[doc = " @param pos           input byte position in stream."]
    #[doc = " @return the number of bytes of the input bitstream used."]
    #[doc = ""]
    #[doc = " Example:"]
    #[doc = " @code"]
    #[doc = "   while(in_len){"]
    #[doc = "       len = av_parser_parse2(myparser, AVCodecContext, &data, &size,"]
    #[doc = "                                        in_data, in_len,"]
    #[doc = "                                        pts, dts, pos);"]
    #[doc = "       in_data += len;"]
    #[doc = "       in_len  -= len;"]
    #[doc = ""]
    #[doc = "       if(size)"]
    #[doc = "          decode_frame(data, size);"]
    #[doc = "   }"]
    #[doc = " @endcode"]
    pub fn av_parser_parse2(
        s: *mut AVCodecParserContext,
        avctx: *mut AVCodecContext,
        poutbuf: *mut *mut u8,
        poutbuf_size: *mut ::std::os::raw::c_int,
        buf: *const u8,
        buf_size: ::std::os::raw::c_int,
        pts: i64,
        dts: i64,
        pos: i64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_parser_close(s: *mut AVCodecParserContext);
}
extern "C" {
    #[doc = " @addtogroup lavc_encoding"]
    #[doc = " @{"]
    pub fn avcodec_encode_subtitle(
        avctx: *mut AVCodecContext,
        buf: *mut u8,
        buf_size: ::std::os::raw::c_int,
        sub: *const AVSubtitle,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Return a value representing the fourCC code associated to the"]
    #[doc = " pixel format pix_fmt, or 0 if no associated fourCC code can be"]
    #[doc = " found."]
    pub fn avcodec_pix_fmt_to_codec_tag(pix_fmt: AVPixelFormat) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Find the best pixel format to convert to given a certain source pixel"]
    #[doc = " format.  When converting from one pixel format to another, information loss"]
    #[doc = " may occur.  For example, when converting from RGB24 to GRAY, the color"]
    #[doc = " information will be lost. Similarly, other losses occur when converting from"]
    #[doc = " some formats to other formats. avcodec_find_best_pix_fmt_of_2() searches which of"]
    #[doc = " the given pixel formats should be used to suffer the least amount of loss."]
    #[doc = " The pixel formats from which it chooses one, are determined by the"]
    #[doc = " pix_fmt_list parameter."]
    #[doc = ""]
    #[doc = ""]
    #[doc = " @param[in] pix_fmt_list AV_PIX_FMT_NONE terminated array of pixel formats to choose from"]
    #[doc = " @param[in] src_pix_fmt source pixel format"]
    #[doc = " @param[in] has_alpha Whether the source pixel format alpha channel is used."]
    #[doc = " @param[out] loss_ptr Combination of flags informing you what kind of losses will occur."]
    #[doc = " @return The best pixel format to convert to or -1 if none was found."]
    pub fn avcodec_find_best_pix_fmt_of_list(
        pix_fmt_list: *const AVPixelFormat,
        src_pix_fmt: AVPixelFormat,
        has_alpha: ::std::os::raw::c_int,
        loss_ptr: *mut ::std::os::raw::c_int,
    ) -> AVPixelFormat;
}
extern "C" {
    pub fn avcodec_default_get_format(
        s: *mut AVCodecContext,
        fmt: *const AVPixelFormat,
    ) -> AVPixelFormat;
}
extern "C" {
    #[doc = " @}"]
    pub fn avcodec_string(
        buf: *mut ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_int,
        enc: *mut AVCodecContext,
        encode: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[doc = " Return a name for the specified profile, if available."]
    #[doc = ""]
    #[doc = " @param codec the codec that is searched for the given profile"]
    #[doc = " @param profile the profile value for which a name is requested"]
    #[doc = " @return A name for the profile if found, NULL otherwise."]
    pub fn av_get_profile_name(
        codec: *const AVCodec,
        profile: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Return a name for the specified profile, if available."]
    #[doc = ""]
    #[doc = " @param codec_id the ID of the codec to which the requested profile belongs"]
    #[doc = " @param profile the profile value for which a name is requested"]
    #[doc = " @return A name for the profile if found, NULL otherwise."]
    #[doc = ""]
    #[doc = " @note unlike av_get_profile_name(), which searches a list of profiles"]
    #[doc = "       supported by a specific decoder or encoder implementation, this"]
    #[doc = "       function searches the list of profiles from the AVCodecDescriptor"]
    pub fn avcodec_profile_name(
        codec_id: AVCodecID,
        profile: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn avcodec_default_execute(
        c: *mut AVCodecContext,
        func: ::std::option::Option<
            unsafe extern "C" fn(
                c2: *mut AVCodecContext,
                arg2: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
        arg: *mut ::std::os::raw::c_void,
        ret: *mut ::std::os::raw::c_int,
        count: ::std::os::raw::c_int,
        size: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn avcodec_default_execute2(
        c: *mut AVCodecContext,
        func: ::std::option::Option<
            unsafe extern "C" fn(
                c2: *mut AVCodecContext,
                arg2: *mut ::std::os::raw::c_void,
                arg1: ::std::os::raw::c_int,
                arg2: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int,
        >,
        arg: *mut ::std::os::raw::c_void,
        ret: *mut ::std::os::raw::c_int,
        count: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Fill AVFrame audio data and linesize pointers."]
    #[doc = ""]
    #[doc = " The buffer buf must be a preallocated buffer with a size big enough"]
    #[doc = " to contain the specified samples amount. The filled AVFrame data"]
    #[doc = " pointers will point to this buffer."]
    #[doc = ""]
    #[doc = " AVFrame extended_data channel pointers are allocated if necessary for"]
    #[doc = " planar audio."]
    #[doc = ""]
    #[doc = " @param frame       the AVFrame"]
    #[doc = "                    frame->nb_samples must be set prior to calling the"]
    #[doc = "                    function. This function fills in frame->data,"]
    #[doc = "                    frame->extended_data, frame->linesize[0]."]
    #[doc = " @param nb_channels channel count"]
    #[doc = " @param sample_fmt  sample format"]
    #[doc = " @param buf         buffer to use for frame data"]
    #[doc = " @param buf_size    size of buffer"]
    #[doc = " @param align       plane size sample alignment (0 = default)"]
    #[doc = " @return            >=0 on success, negative error code on failure"]
    #[doc = " @todo return the size in bytes required to store the samples in"]
    #[doc = " case of success, at the next libavutil bump"]
    pub fn avcodec_fill_audio_frame(
        frame: *mut AVFrame,
        nb_channels: ::std::os::raw::c_int,
        sample_fmt: AVSampleFormat,
        buf: *const u8,
        buf_size: ::std::os::raw::c_int,
        align: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Reset the internal codec state / flush internal buffers. Should be called"]
    #[doc = " e.g. when seeking or when switching to a different stream."]
    #[doc = ""]
    #[doc = " @note for decoders, when refcounted frames are not used"]
    #[doc = " (i.e. avctx->refcounted_frames is 0), this invalidates the frames previously"]
    #[doc = " returned from the decoder. When refcounted frames are used, the decoder just"]
    #[doc = " releases any references it might keep internally, but the caller's reference"]
    #[doc = " remains valid."]
    #[doc = ""]
    #[doc = " @note for encoders, this function will only do something if the encoder"]
    #[doc = " declares support for AV_CODEC_CAP_ENCODER_FLUSH. When called, the encoder"]
    #[doc = " will drain any remaining packets, and can then be re-used for a different"]
    #[doc = " stream (as opposed to sending a null frame which will leave the encoder"]
    #[doc = " in a permanent EOF state after draining). This can be desirable if the"]
    #[doc = " cost of tearing down and replacing the encoder instance is high."]
    pub fn avcodec_flush_buffers(avctx: *mut AVCodecContext);
}
extern "C" {
    #[doc = " Return codec bits per sample."]
    #[doc = ""]
    #[doc = " @param[in] codec_id the codec"]
    #[doc = " @return Number of bits per sample or zero if unknown for the given codec."]
    pub fn av_get_bits_per_sample(codec_id: AVCodecID) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Return the PCM codec associated with a sample format."]
    #[doc = " @param be  endianness, 0 for little, 1 for big,"]
    #[doc = "            -1 (or anything else) for native"]
    #[doc = " @return  AV_CODEC_ID_PCM_* or AV_CODEC_ID_NONE"]
    pub fn av_get_pcm_codec(fmt: AVSampleFormat, be: ::std::os::raw::c_int) -> AVCodecID;
}
extern "C" {
    #[doc = " Return codec bits per sample."]
    #[doc = " Only return non-zero if the bits per sample is exactly correct, not an"]
    #[doc = " approximation."]
    #[doc = ""]
    #[doc = " @param[in] codec_id the codec"]
    #[doc = " @return Number of bits per sample or zero if unknown for the given codec."]
    pub fn av_get_exact_bits_per_sample(codec_id: AVCodecID) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Return audio frame duration."]
    #[doc = ""]
    #[doc = " @param avctx        codec context"]
    #[doc = " @param frame_bytes  size of the frame, or 0 if unknown"]
    #[doc = " @return             frame duration, in samples, if known. 0 if not able to"]
    #[doc = "                     determine."]
    pub fn av_get_audio_frame_duration(
        avctx: *mut AVCodecContext,
        frame_bytes: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " This function is the same as av_get_audio_frame_duration(), except it works"]
    #[doc = " with AVCodecParameters instead of an AVCodecContext."]
    pub fn av_get_audio_frame_duration2(
        par: *mut AVCodecParameters,
        frame_bytes: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Same behaviour av_fast_malloc but the buffer has additional"]
    #[doc = " AV_INPUT_BUFFER_PADDING_SIZE at the end which will always be 0."]
    #[doc = ""]
    #[doc = " In addition the whole buffer will initially and after resizes"]
    #[doc = " be 0-initialized so that no uninitialized data will ever appear."]
    pub fn av_fast_padded_malloc(
        ptr: *mut ::std::os::raw::c_void,
        size: *mut ::std::os::raw::c_uint,
        min_size: size_t,
    );
}
extern "C" {
    #[doc = " Same behaviour av_fast_padded_malloc except that buffer will always"]
    #[doc = " be 0-initialized after call."]
    pub fn av_fast_padded_mallocz(
        ptr: *mut ::std::os::raw::c_void,
        size: *mut ::std::os::raw::c_uint,
        min_size: size_t,
    );
}
extern "C" {
    #[doc = " Encode extradata length to a buffer. Used by xiph codecs."]
    #[doc = ""]
    #[doc = " @param s buffer to write to; must be at least (v/255+1) bytes long"]
    #[doc = " @param v size of extradata in bytes"]
    #[doc = " @return number of bytes written to the buffer."]
    pub fn av_xiphlacing(
        s: *mut ::std::os::raw::c_uchar,
        v: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " @return a positive value if s is open (i.e. avcodec_open2() was called on it"]
    #[doc = " with no corresponding avcodec_close()), 0 otherwise."]
    pub fn avcodec_is_open(s: *mut AVCodecContext) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Allocate a CPB properties structure and initialize its fields to default"]
    #[doc = " values."]
    #[doc = ""]
    #[doc = " @param size if non-NULL, the size of the allocated struct will be written"]
    #[doc = "             here. This is useful for embedding it in side data."]
    #[doc = ""]
    #[doc = " @return the newly allocated struct or NULL on failure"]
    pub fn av_cpb_properties_alloc(size: *mut size_t) -> *mut AVCPBProperties;
}
#[doc = " @defgroup lavc_fft FFT functions"]
#[doc = " @ingroup lavc_misc"]
#[doc = ""]
#[doc = " @{"]
pub type FFTSample = f32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FFTComplex {
    pub re: FFTSample,
    pub im: FFTSample,
}
#[test]
fn bindgen_test_layout_FFTComplex() {
    assert_eq!(
        ::std::mem::size_of::<FFTComplex>(),
        8usize,
        concat!("Size of: ", stringify!(FFTComplex))
    );
    assert_eq!(
        ::std::mem::align_of::<FFTComplex>(),
        4usize,
        concat!("Alignment of ", stringify!(FFTComplex))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<FFTComplex>())).re as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FFTComplex),
            "::",
            stringify!(re)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<FFTComplex>())).im as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(FFTComplex),
            "::",
            stringify!(im)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FFTContext {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Set up a complex FFT."]
    #[doc = " @param nbits           log2 of the length of the input array"]
    #[doc = " @param inverse         if 0 perform the forward transform, if 1 perform the inverse"]
    pub fn av_fft_init(
        nbits: ::std::os::raw::c_int,
        inverse: ::std::os::raw::c_int,
    ) -> *mut FFTContext;
}
extern "C" {
    #[doc = " Do the permutation needed BEFORE calling ff_fft_calc()."]
    pub fn av_fft_permute(s: *mut FFTContext, z: *mut FFTComplex);
}
extern "C" {
    #[doc = " Do a complex FFT with the parameters defined in av_fft_init(). The"]
    #[doc = " input data must be permuted before. No 1.0/sqrt(n) normalization is done."]
    pub fn av_fft_calc(s: *mut FFTContext, z: *mut FFTComplex);
}
extern "C" {
    pub fn av_fft_end(s: *mut FFTContext);
}
extern "C" {
    pub fn av_mdct_init(
        nbits: ::std::os::raw::c_int,
        inverse: ::std::os::raw::c_int,
        scale: f64,
    ) -> *mut FFTContext;
}
extern "C" {
    pub fn av_imdct_calc(s: *mut FFTContext, output: *mut FFTSample, input: *const FFTSample);
}
extern "C" {
    pub fn av_imdct_half(s: *mut FFTContext, output: *mut FFTSample, input: *const FFTSample);
}
extern "C" {
    pub fn av_mdct_calc(s: *mut FFTContext, output: *mut FFTSample, input: *const FFTSample);
}
extern "C" {
    pub fn av_mdct_end(s: *mut FFTContext);
}
pub const RDFTransformType_DFT_R2C: RDFTransformType = 0;
pub const RDFTransformType_IDFT_C2R: RDFTransformType = 1;
pub const RDFTransformType_IDFT_R2C: RDFTransformType = 2;
pub const RDFTransformType_DFT_C2R: RDFTransformType = 3;
pub type RDFTransformType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RDFTContext {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Set up a real FFT."]
    #[doc = " @param nbits           log2 of the length of the input array"]
    #[doc = " @param trans           the type of transform"]
    pub fn av_rdft_init(nbits: ::std::os::raw::c_int, trans: RDFTransformType) -> *mut RDFTContext;
}
extern "C" {
    pub fn av_rdft_calc(s: *mut RDFTContext, data: *mut FFTSample);
}
extern "C" {
    pub fn av_rdft_end(s: *mut RDFTContext);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DCTContext {
    _unused: [u8; 0],
}
pub const DCTTransformType_DCT_II: DCTTransformType = 0;
pub const DCTTransformType_DCT_III: DCTTransformType = 1;
pub const DCTTransformType_DCT_I: DCTTransformType = 2;
pub const DCTTransformType_DST_I: DCTTransformType = 3;
pub type DCTTransformType = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Set up DCT."]
    #[doc = ""]
    #[doc = " @param nbits           size of the input array:"]
    #[doc = "                        (1 << nbits)     for DCT-II, DCT-III and DST-I"]
    #[doc = "                        (1 << nbits) + 1 for DCT-I"]
    #[doc = " @param type            the type of transform"]
    #[doc = ""]
    #[doc = " @note the first element of the input of DST-I is ignored"]
    pub fn av_dct_init(nbits: ::std::os::raw::c_int, type_: DCTTransformType) -> *mut DCTContext;
}
extern "C" {
    pub fn av_dct_calc(s: *mut DCTContext, data: *mut FFTSample);
}
extern "C" {
    pub fn av_dct_end(s: *mut DCTContext);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVDVProfile {
    pub dsf: ::std::os::raw::c_int,
    pub video_stype: ::std::os::raw::c_int,
    pub frame_size: ::std::os::raw::c_int,
    pub difseg_size: ::std::os::raw::c_int,
    pub n_difchan: ::std::os::raw::c_int,
    pub time_base: AVRational,
    pub ltc_divisor: ::std::os::raw::c_int,
    pub height: ::std::os::raw::c_int,
    pub width: ::std::os::raw::c_int,
    pub sar: [AVRational; 2usize],
    pub pix_fmt: AVPixelFormat,
    pub bpm: ::std::os::raw::c_int,
    pub block_sizes: *const u8,
    pub audio_stride: ::std::os::raw::c_int,
    pub audio_min_samples: [::std::os::raw::c_int; 3usize],
    pub audio_samples_dist: [::std::os::raw::c_int; 5usize],
    pub audio_shuffle: *const [u8; 9usize],
}
#[test]
fn bindgen_test_layout_AVDVProfile() {
    assert_eq!(
        ::std::mem::size_of::<AVDVProfile>(),
        120usize,
        concat!("Size of: ", stringify!(AVDVProfile))
    );
    assert_eq!(
        ::std::mem::align_of::<AVDVProfile>(),
        8usize,
        concat!("Alignment of ", stringify!(AVDVProfile))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVDVProfile>())).dsf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVDVProfile),
            "::",
            stringify!(dsf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVDVProfile>())).video_stype as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(AVDVProfile),
            "::",
            stringify!(video_stype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVDVProfile>())).frame_size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVDVProfile),
            "::",
            stringify!(frame_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVDVProfile>())).difseg_size as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(AVDVProfile),
            "::",
            stringify!(difseg_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVDVProfile>())).n_difchan as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVDVProfile),
            "::",
            stringify!(n_difchan)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVDVProfile>())).time_base as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(AVDVProfile),
            "::",
            stringify!(time_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVDVProfile>())).ltc_divisor as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(AVDVProfile),
            "::",
            stringify!(ltc_divisor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVDVProfile>())).height as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVDVProfile),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVDVProfile>())).width as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(AVDVProfile),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVDVProfile>())).sar as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVDVProfile),
            "::",
            stringify!(sar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVDVProfile>())).pix_fmt as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(AVDVProfile),
            "::",
            stringify!(pix_fmt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVDVProfile>())).bpm as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(AVDVProfile),
            "::",
            stringify!(bpm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVDVProfile>())).block_sizes as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(AVDVProfile),
            "::",
            stringify!(block_sizes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVDVProfile>())).audio_stride as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(AVDVProfile),
            "::",
            stringify!(audio_stride)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVDVProfile>())).audio_min_samples as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(AVDVProfile),
            "::",
            stringify!(audio_min_samples)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVDVProfile>())).audio_samples_dist as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(AVDVProfile),
            "::",
            stringify!(audio_samples_dist)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVDVProfile>())).audio_shuffle as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(AVDVProfile),
            "::",
            stringify!(audio_shuffle)
        )
    );
}
extern "C" {
    #[doc = " Get a DV profile for the provided compressed frame."]
    #[doc = ""]
    #[doc = " @param sys the profile used for the previous frame, may be NULL"]
    #[doc = " @param frame the compressed data buffer"]
    #[doc = " @param buf_size size of the buffer in bytes"]
    #[doc = " @return the DV profile for the supplied data or NULL on failure"]
    pub fn av_dv_frame_profile(
        sys: *const AVDVProfile,
        frame: *const u8,
        buf_size: ::std::os::raw::c_uint,
    ) -> *const AVDVProfile;
}
extern "C" {
    #[doc = " Get a DV profile for the provided stream parameters."]
    pub fn av_dv_codec_profile(
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
        pix_fmt: AVPixelFormat,
    ) -> *const AVDVProfile;
}
extern "C" {
    #[doc = " Get a DV profile for the provided stream parameters."]
    #[doc = " The frame rate is used as a best-effort parameter."]
    pub fn av_dv_codec_profile2(
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
        pix_fmt: AVPixelFormat,
        frame_rate: AVRational,
    ) -> *const AVDVProfile;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVVorbisParseContext {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Allocate and initialize the Vorbis parser using headers in the extradata."]
    pub fn av_vorbis_parse_init(
        extradata: *const u8,
        extradata_size: ::std::os::raw::c_int,
    ) -> *mut AVVorbisParseContext;
}
extern "C" {
    #[doc = " Free the parser and everything associated with it."]
    pub fn av_vorbis_parse_free(s: *mut *mut AVVorbisParseContext);
}
extern "C" {
    #[doc = " Get the duration for a Vorbis packet."]
    #[doc = ""]
    #[doc = " If @p flags is @c NULL,"]
    #[doc = " special frames are considered invalid."]
    #[doc = ""]
    #[doc = " @param s        Vorbis parser context"]
    #[doc = " @param buf      buffer containing a Vorbis frame"]
    #[doc = " @param buf_size size of the buffer"]
    #[doc = " @param flags    flags for special frames"]
    pub fn av_vorbis_parse_frame_flags(
        s: *mut AVVorbisParseContext,
        buf: *const u8,
        buf_size: ::std::os::raw::c_int,
        flags: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get the duration for a Vorbis packet."]
    #[doc = ""]
    #[doc = " @param s        Vorbis parser context"]
    #[doc = " @param buf      buffer containing a Vorbis frame"]
    #[doc = " @param buf_size size of the buffer"]
    pub fn av_vorbis_parse_frame(
        s: *mut AVVorbisParseContext,
        buf: *const u8,
        buf_size: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_vorbis_parse_reset(s: *mut AVVorbisParseContext);
}
pub const AVOptionType_AV_OPT_TYPE_FLAGS: AVOptionType = 0;
pub const AVOptionType_AV_OPT_TYPE_INT: AVOptionType = 1;
pub const AVOptionType_AV_OPT_TYPE_INT64: AVOptionType = 2;
pub const AVOptionType_AV_OPT_TYPE_DOUBLE: AVOptionType = 3;
pub const AVOptionType_AV_OPT_TYPE_FLOAT: AVOptionType = 4;
pub const AVOptionType_AV_OPT_TYPE_STRING: AVOptionType = 5;
pub const AVOptionType_AV_OPT_TYPE_RATIONAL: AVOptionType = 6;
#[doc = "< offset must point to a pointer immediately followed by an int for the length"]
pub const AVOptionType_AV_OPT_TYPE_BINARY: AVOptionType = 7;
pub const AVOptionType_AV_OPT_TYPE_DICT: AVOptionType = 8;
pub const AVOptionType_AV_OPT_TYPE_UINT64: AVOptionType = 9;
pub const AVOptionType_AV_OPT_TYPE_CONST: AVOptionType = 10;
#[doc = "< offset must point to two consecutive integers"]
pub const AVOptionType_AV_OPT_TYPE_IMAGE_SIZE: AVOptionType = 11;
pub const AVOptionType_AV_OPT_TYPE_PIXEL_FMT: AVOptionType = 12;
pub const AVOptionType_AV_OPT_TYPE_SAMPLE_FMT: AVOptionType = 13;
#[doc = "< offset must point to AVRational"]
pub const AVOptionType_AV_OPT_TYPE_VIDEO_RATE: AVOptionType = 14;
pub const AVOptionType_AV_OPT_TYPE_DURATION: AVOptionType = 15;
pub const AVOptionType_AV_OPT_TYPE_COLOR: AVOptionType = 16;
pub const AVOptionType_AV_OPT_TYPE_CHANNEL_LAYOUT: AVOptionType = 17;
pub const AVOptionType_AV_OPT_TYPE_BOOL: AVOptionType = 18;
#[doc = " @defgroup avoptions AVOptions"]
#[doc = " @ingroup lavu_data"]
#[doc = " @{"]
#[doc = " AVOptions provide a generic system to declare options on arbitrary structs"]
#[doc = " (\"objects\"). An option can have a help text, a type and a range of possible"]
#[doc = " values. Options may then be enumerated, read and written to."]
#[doc = ""]
#[doc = " @section avoptions_implement Implementing AVOptions"]
#[doc = " This section describes how to add AVOptions capabilities to a struct."]
#[doc = ""]
#[doc = " All AVOptions-related information is stored in an AVClass. Therefore"]
#[doc = " the first member of the struct should be a pointer to an AVClass describing it."]
#[doc = " The option field of the AVClass must be set to a NULL-terminated static array"]
#[doc = " of AVOptions. Each AVOption must have a non-empty name, a type, a default"]
#[doc = " value and for number-type AVOptions also a range of allowed values. It must"]
#[doc = " also declare an offset in bytes from the start of the struct, where the field"]
#[doc = " associated with this AVOption is located. Other fields in the AVOption struct"]
#[doc = " should also be set when applicable, but are not required."]
#[doc = ""]
#[doc = " The following example illustrates an AVOptions-enabled struct:"]
#[doc = " @code"]
#[doc = " typedef struct test_struct {"]
#[doc = "     const AVClass *class;"]
#[doc = "     int      int_opt;"]
#[doc = "     char    *str_opt;"]
#[doc = "     uint8_t *bin_opt;"]
#[doc = "     int      bin_len;"]
#[doc = " } test_struct;"]
#[doc = ""]
#[doc = " static const AVOption test_options[] = {"]
#[doc = "   { \"test_int\", \"This is a test option of int type.\", offsetof(test_struct, int_opt),"]
#[doc = "     AV_OPT_TYPE_INT, { .i64 = -1 }, INT_MIN, INT_MAX },"]
#[doc = "   { \"test_str\", \"This is a test option of string type.\", offsetof(test_struct, str_opt),"]
#[doc = "     AV_OPT_TYPE_STRING },"]
#[doc = "   { \"test_bin\", \"This is a test option of binary type.\", offsetof(test_struct, bin_opt),"]
#[doc = "     AV_OPT_TYPE_BINARY },"]
#[doc = "   { NULL },"]
#[doc = " };"]
#[doc = ""]
#[doc = " static const AVClass test_class = {"]
#[doc = "     .class_name = \"test class\","]
#[doc = "     .item_name  = av_default_item_name,"]
#[doc = "     .option     = test_options,"]
#[doc = "     .version    = LIBAVUTIL_VERSION_INT,"]
#[doc = " };"]
#[doc = " @endcode"]
#[doc = ""]
#[doc = " Next, when allocating your struct, you must ensure that the AVClass pointer"]
#[doc = " is set to the correct value. Then, av_opt_set_defaults() can be called to"]
#[doc = " initialize defaults. After that the struct is ready to be used with the"]
#[doc = " AVOptions API."]
#[doc = ""]
#[doc = " When cleaning up, you may use the av_opt_free() function to automatically"]
#[doc = " free all the allocated string and binary options."]
#[doc = ""]
#[doc = " Continuing with the above example:"]
#[doc = ""]
#[doc = " @code"]
#[doc = " test_struct *alloc_test_struct(void)"]
#[doc = " {"]
#[doc = "     test_struct *ret = av_mallocz(sizeof(*ret));"]
#[doc = "     ret->class = &test_class;"]
#[doc = "     av_opt_set_defaults(ret);"]
#[doc = "     return ret;"]
#[doc = " }"]
#[doc = " void free_test_struct(test_struct **foo)"]
#[doc = " {"]
#[doc = "     av_opt_free(*foo);"]
#[doc = "     av_freep(foo);"]
#[doc = " }"]
#[doc = " @endcode"]
#[doc = ""]
#[doc = " @subsection avoptions_implement_nesting Nesting"]
#[doc = "      It may happen that an AVOptions-enabled struct contains another"]
#[doc = "      AVOptions-enabled struct as a member (e.g. AVCodecContext in"]
#[doc = "      libavcodec exports generic options, while its priv_data field exports"]
#[doc = "      codec-specific options). In such a case, it is possible to set up the"]
#[doc = "      parent struct to export a child's options. To do that, simply"]
#[doc = "      implement AVClass.child_next() and AVClass.child_class_iterate() in the"]
#[doc = "      parent struct's AVClass."]
#[doc = "      Assuming that the test_struct from above now also contains a"]
#[doc = "      child_struct field:"]
#[doc = ""]
#[doc = "      @code"]
#[doc = "      typedef struct child_struct {"]
#[doc = "          AVClass *class;"]
#[doc = "          int flags_opt;"]
#[doc = "      } child_struct;"]
#[doc = "      static const AVOption child_opts[] = {"]
#[doc = "          { \"test_flags\", \"This is a test option of flags type.\","]
#[doc = "            offsetof(child_struct, flags_opt), AV_OPT_TYPE_FLAGS, { .i64 = 0 }, INT_MIN, INT_MAX },"]
#[doc = "          { NULL },"]
#[doc = "      };"]
#[doc = "      static const AVClass child_class = {"]
#[doc = "          .class_name = \"child class\","]
#[doc = "          .item_name  = av_default_item_name,"]
#[doc = "          .option     = child_opts,"]
#[doc = "          .version    = LIBAVUTIL_VERSION_INT,"]
#[doc = "      };"]
#[doc = ""]
#[doc = "      void *child_next(void *obj, void *prev)"]
#[doc = "      {"]
#[doc = "          test_struct *t = obj;"]
#[doc = "          if (!prev && t->child_struct)"]
#[doc = "              return t->child_struct;"]
#[doc = "          return NULL"]
#[doc = "      }"]
#[doc = "      const AVClass child_class_iterate(void **iter)"]
#[doc = "      {"]
#[doc = "          const AVClass *c = *iter ? NULL : &child_class;"]
#[doc = "          *iter = (void*)(uintptr_t)c;"]
#[doc = "          return c;"]
#[doc = "      }"]
#[doc = "      @endcode"]
#[doc = "      Putting child_next() and child_class_iterate() as defined above into"]
#[doc = "      test_class will now make child_struct's options accessible through"]
#[doc = "      test_struct (again, proper setup as described above needs to be done on"]
#[doc = "      child_struct right after it is created)."]
#[doc = ""]
#[doc = "      From the above example it might not be clear why both child_next()"]
#[doc = "      and child_class_iterate() are needed. The distinction is that child_next()"]
#[doc = "      iterates over actually existing objects, while child_class_iterate()"]
#[doc = "      iterates over all possible child classes. E.g. if an AVCodecContext"]
#[doc = "      was initialized to use a codec which has private options, then its"]
#[doc = "      child_next() will return AVCodecContext.priv_data and finish"]
#[doc = "      iterating. OTOH child_class_iterate() on AVCodecContext.av_class will"]
#[doc = "      iterate over all available codecs with private options."]
#[doc = ""]
#[doc = " @subsection avoptions_implement_named_constants Named constants"]
#[doc = "      It is possible to create named constants for options. Simply set the unit"]
#[doc = "      field of the option the constants should apply to a string and"]
#[doc = "      create the constants themselves as options of type AV_OPT_TYPE_CONST"]
#[doc = "      with their unit field set to the same string."]
#[doc = "      Their default_val field should contain the value of the named"]
#[doc = "      constant."]
#[doc = "      For example, to add some named constants for the test_flags option"]
#[doc = "      above, put the following into the child_opts array:"]
#[doc = "      @code"]
#[doc = "      { \"test_flags\", \"This is a test option of flags type.\","]
#[doc = "        offsetof(child_struct, flags_opt), AV_OPT_TYPE_FLAGS, { .i64 = 0 }, INT_MIN, INT_MAX, \"test_unit\" },"]
#[doc = "      { \"flag1\", \"This is a flag with value 16\", 0, AV_OPT_TYPE_CONST, { .i64 = 16 }, 0, 0, \"test_unit\" },"]
#[doc = "      @endcode"]
#[doc = ""]
#[doc = " @section avoptions_use Using AVOptions"]
#[doc = " This section deals with accessing options in an AVOptions-enabled struct."]
#[doc = " Such structs in FFmpeg are e.g. AVCodecContext in libavcodec or"]
#[doc = " AVFormatContext in libavformat."]
#[doc = ""]
#[doc = " @subsection avoptions_use_examine Examining AVOptions"]
#[doc = " The basic functions for examining options are av_opt_next(), which iterates"]
#[doc = " over all options defined for one object, and av_opt_find(), which searches"]
#[doc = " for an option with the given name."]
#[doc = ""]
#[doc = " The situation is more complicated with nesting. An AVOptions-enabled struct"]
#[doc = " may have AVOptions-enabled children. Passing the AV_OPT_SEARCH_CHILDREN flag"]
#[doc = " to av_opt_find() will make the function search children recursively."]
#[doc = ""]
#[doc = " For enumerating there are basically two cases. The first is when you want to"]
#[doc = " get all options that may potentially exist on the struct and its children"]
#[doc = " (e.g.  when constructing documentation). In that case you should call"]
#[doc = " av_opt_child_class_iterate() recursively on the parent struct's AVClass.  The"]
#[doc = " second case is when you have an already initialized struct with all its"]
#[doc = " children and you want to get all options that can be actually written or read"]
#[doc = " from it. In that case you should call av_opt_child_next() recursively (and"]
#[doc = " av_opt_next() on each result)."]
#[doc = ""]
#[doc = " @subsection avoptions_use_get_set Reading and writing AVOptions"]
#[doc = " When setting options, you often have a string read directly from the"]
#[doc = " user. In such a case, simply passing it to av_opt_set() is enough. For"]
#[doc = " non-string type options, av_opt_set() will parse the string according to the"]
#[doc = " option type."]
#[doc = ""]
#[doc = " Similarly av_opt_get() will read any option type and convert it to a string"]
#[doc = " which will be returned. Do not forget that the string is allocated, so you"]
#[doc = " have to free it with av_free()."]
#[doc = ""]
#[doc = " In some cases it may be more convenient to put all options into an"]
#[doc = " AVDictionary and call av_opt_set_dict() on it. A specific case of this"]
#[doc = " are the format/codec open functions in lavf/lavc which take a dictionary"]
#[doc = " filled with option as a parameter. This makes it possible to set some options"]
#[doc = " that cannot be set otherwise, since e.g. the input file format is not known"]
#[doc = " before the file is actually opened."]
pub type AVOptionType = ::std::os::raw::c_uint;
#[doc = " AVOption"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct AVOption {
    pub name: *const ::std::os::raw::c_char,
    #[doc = " short English help text"]
    #[doc = " @todo What about other languages?"]
    pub help: *const ::std::os::raw::c_char,
    #[doc = " The offset relative to the context structure where the option"]
    #[doc = " value is stored. It should be 0 for named constants."]
    pub offset: ::std::os::raw::c_int,
    pub type_: AVOptionType,
    pub default_val: AVOption__bindgen_ty_1,
    #[doc = "< minimum valid value for the option"]
    pub min: f64,
    #[doc = "< maximum valid value for the option"]
    pub max: f64,
    pub flags: ::std::os::raw::c_int,
    #[doc = " The logical unit to which the option belongs. Non-constant"]
    #[doc = " options and corresponding named constants share the same"]
    #[doc = " unit. May be NULL."]
    pub unit: *const ::std::os::raw::c_char,
}
#[doc = " the default value for scalar options"]
#[repr(C)]
#[derive(Copy, Clone)]
pub union AVOption__bindgen_ty_1 {
    pub i64_: i64,
    pub dbl: f64,
    pub str_: *const ::std::os::raw::c_char,
    pub q: AVRational,
}
#[test]
fn bindgen_test_layout_AVOption__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<AVOption__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(AVOption__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<AVOption__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(AVOption__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOption__bindgen_ty_1>())).i64_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOption__bindgen_ty_1),
            "::",
            stringify!(i64_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOption__bindgen_ty_1>())).dbl as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOption__bindgen_ty_1),
            "::",
            stringify!(dbl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOption__bindgen_ty_1>())).str_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOption__bindgen_ty_1),
            "::",
            stringify!(str_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOption__bindgen_ty_1>())).q as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOption__bindgen_ty_1),
            "::",
            stringify!(q)
        )
    );
}
#[test]
fn bindgen_test_layout_AVOption() {
    assert_eq!(
        ::std::mem::size_of::<AVOption>(),
        64usize,
        concat!("Size of: ", stringify!(AVOption))
    );
    assert_eq!(
        ::std::mem::align_of::<AVOption>(),
        8usize,
        concat!("Alignment of ", stringify!(AVOption))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOption>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOption),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOption>())).help as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOption),
            "::",
            stringify!(help)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOption>())).offset as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOption),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOption>())).type_ as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOption),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOption>())).default_val as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOption),
            "::",
            stringify!(default_val)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOption>())).min as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOption),
            "::",
            stringify!(min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOption>())).max as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOption),
            "::",
            stringify!(max)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOption>())).flags as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOption),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOption>())).unit as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOption),
            "::",
            stringify!(unit)
        )
    );
}
#[doc = " A single allowed range of values, or a single allowed value."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVOptionRange {
    pub str_: *const ::std::os::raw::c_char,
    #[doc = " Value range."]
    #[doc = " For string ranges this represents the min/max length."]
    #[doc = " For dimensions this represents the min/max pixel count or width/height in multi-component case."]
    pub value_min: f64,
    #[doc = " Value range."]
    #[doc = " For string ranges this represents the min/max length."]
    #[doc = " For dimensions this represents the min/max pixel count or width/height in multi-component case."]
    pub value_max: f64,
    #[doc = " Value's component range."]
    #[doc = " For string this represents the unicode range for chars, 0-127 limits to ASCII."]
    pub component_min: f64,
    #[doc = " Value's component range."]
    #[doc = " For string this represents the unicode range for chars, 0-127 limits to ASCII."]
    pub component_max: f64,
    #[doc = " Range flag."]
    #[doc = " If set to 1 the struct encodes a range, if set to 0 a single value."]
    pub is_range: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_AVOptionRange() {
    assert_eq!(
        ::std::mem::size_of::<AVOptionRange>(),
        48usize,
        concat!("Size of: ", stringify!(AVOptionRange))
    );
    assert_eq!(
        ::std::mem::align_of::<AVOptionRange>(),
        8usize,
        concat!("Alignment of ", stringify!(AVOptionRange))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOptionRange>())).str_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOptionRange),
            "::",
            stringify!(str_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOptionRange>())).value_min as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOptionRange),
            "::",
            stringify!(value_min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOptionRange>())).value_max as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOptionRange),
            "::",
            stringify!(value_max)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOptionRange>())).component_min as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOptionRange),
            "::",
            stringify!(component_min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOptionRange>())).component_max as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOptionRange),
            "::",
            stringify!(component_max)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOptionRange>())).is_range as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOptionRange),
            "::",
            stringify!(is_range)
        )
    );
}
#[doc = " List of AVOptionRange structs."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVOptionRanges {
    #[doc = " Array of option ranges."]
    #[doc = ""]
    #[doc = " Most of option types use just one component."]
    #[doc = " Following describes multi-component option types:"]
    #[doc = ""]
    #[doc = " AV_OPT_TYPE_IMAGE_SIZE:"]
    #[doc = " component index 0: range of pixel count (width * height)."]
    #[doc = " component index 1: range of width."]
    #[doc = " component index 2: range of height."]
    #[doc = ""]
    #[doc = " @note To obtain multi-component version of this structure, user must"]
    #[doc = "       provide AV_OPT_MULTI_COMPONENT_RANGE to av_opt_query_ranges or"]
    #[doc = "       av_opt_query_ranges_default function."]
    #[doc = ""]
    #[doc = " Multi-component range can be read as in following example:"]
    #[doc = ""]
    #[doc = " @code"]
    #[doc = " int range_index, component_index;"]
    #[doc = " AVOptionRanges *ranges;"]
    #[doc = " AVOptionRange *range[3]; //may require more than 3 in the future."]
    #[doc = " av_opt_query_ranges(&ranges, obj, key, AV_OPT_MULTI_COMPONENT_RANGE);"]
    #[doc = " for (range_index = 0; range_index < ranges->nb_ranges; range_index++) {"]
    #[doc = "     for (component_index = 0; component_index < ranges->nb_components; component_index++)"]
    #[doc = "         range[component_index] = ranges->range[ranges->nb_ranges * component_index + range_index];"]
    #[doc = "     //do something with range here."]
    #[doc = " }"]
    #[doc = " av_opt_freep_ranges(&ranges);"]
    #[doc = " @endcode"]
    pub range: *mut *mut AVOptionRange,
    #[doc = " Number of ranges per component."]
    pub nb_ranges: ::std::os::raw::c_int,
    #[doc = " Number of componentes."]
    pub nb_components: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_AVOptionRanges() {
    assert_eq!(
        ::std::mem::size_of::<AVOptionRanges>(),
        16usize,
        concat!("Size of: ", stringify!(AVOptionRanges))
    );
    assert_eq!(
        ::std::mem::align_of::<AVOptionRanges>(),
        8usize,
        concat!("Alignment of ", stringify!(AVOptionRanges))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOptionRanges>())).range as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOptionRanges),
            "::",
            stringify!(range)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOptionRanges>())).nb_ranges as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOptionRanges),
            "::",
            stringify!(nb_ranges)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOptionRanges>())).nb_components as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOptionRanges),
            "::",
            stringify!(nb_components)
        )
    );
}
extern "C" {
    #[doc = " Show the obj options."]
    #[doc = ""]
    #[doc = " @param req_flags requested flags for the options to show. Show only the"]
    #[doc = " options for which it is opt->flags & req_flags."]
    #[doc = " @param rej_flags rejected flags for the options to show. Show only the"]
    #[doc = " options for which it is !(opt->flags & req_flags)."]
    #[doc = " @param av_log_obj log context to use for showing the options"]
    pub fn av_opt_show2(
        obj: *mut ::std::os::raw::c_void,
        av_log_obj: *mut ::std::os::raw::c_void,
        req_flags: ::std::os::raw::c_int,
        rej_flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Set the values of all AVOption fields to their default values."]
    #[doc = ""]
    #[doc = " @param s an AVOption-enabled struct (its first member must be a pointer to AVClass)"]
    pub fn av_opt_set_defaults(s: *mut ::std::os::raw::c_void);
}
extern "C" {
    #[doc = " Set the values of all AVOption fields to their default values. Only these"]
    #[doc = " AVOption fields for which (opt->flags & mask) == flags will have their"]
    #[doc = " default applied to s."]
    #[doc = ""]
    #[doc = " @param s an AVOption-enabled struct (its first member must be a pointer to AVClass)"]
    #[doc = " @param mask combination of AV_OPT_FLAG_*"]
    #[doc = " @param flags combination of AV_OPT_FLAG_*"]
    pub fn av_opt_set_defaults2(
        s: *mut ::std::os::raw::c_void,
        mask: ::std::os::raw::c_int,
        flags: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[doc = " Parse the key/value pairs list in opts. For each key/value pair"]
    #[doc = " found, stores the value in the field in ctx that is named like the"]
    #[doc = " key. ctx must be an AVClass context, storing is done using"]
    #[doc = " AVOptions."]
    #[doc = ""]
    #[doc = " @param opts options string to parse, may be NULL"]
    #[doc = " @param key_val_sep a 0-terminated list of characters used to"]
    #[doc = " separate key from value"]
    #[doc = " @param pairs_sep a 0-terminated list of characters used to separate"]
    #[doc = " two pairs from each other"]
    #[doc = " @return the number of successfully set key/value pairs, or a negative"]
    #[doc = " value corresponding to an AVERROR code in case of error:"]
    #[doc = " AVERROR(EINVAL) if opts cannot be parsed,"]
    #[doc = " the error code issued by av_opt_set() if a key/value pair"]
    #[doc = " cannot be set"]
    pub fn av_set_options_string(
        ctx: *mut ::std::os::raw::c_void,
        opts: *const ::std::os::raw::c_char,
        key_val_sep: *const ::std::os::raw::c_char,
        pairs_sep: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Parse the key-value pairs list in opts. For each key=value pair found,"]
    #[doc = " set the value of the corresponding option in ctx."]
    #[doc = ""]
    #[doc = " @param ctx          the AVClass object to set options on"]
    #[doc = " @param opts         the options string, key-value pairs separated by a"]
    #[doc = "                     delimiter"]
    #[doc = " @param shorthand    a NULL-terminated array of options names for shorthand"]
    #[doc = "                     notation: if the first field in opts has no key part,"]
    #[doc = "                     the key is taken from the first element of shorthand;"]
    #[doc = "                     then again for the second, etc., until either opts is"]
    #[doc = "                     finished, shorthand is finished or a named option is"]
    #[doc = "                     found; after that, all options must be named"]
    #[doc = " @param key_val_sep  a 0-terminated list of characters used to separate"]
    #[doc = "                     key from value, for example '='"]
    #[doc = " @param pairs_sep    a 0-terminated list of characters used to separate"]
    #[doc = "                     two pairs from each other, for example ':' or ','"]
    #[doc = " @return  the number of successfully set key=value pairs, or a negative"]
    #[doc = "          value corresponding to an AVERROR code in case of error:"]
    #[doc = "          AVERROR(EINVAL) if opts cannot be parsed,"]
    #[doc = "          the error code issued by av_set_string3() if a key/value pair"]
    #[doc = "          cannot be set"]
    #[doc = ""]
    #[doc = " Options names must use only the following characters: a-z A-Z 0-9 - . / _"]
    #[doc = " Separators must use characters distinct from option names and from each"]
    #[doc = " other."]
    pub fn av_opt_set_from_string(
        ctx: *mut ::std::os::raw::c_void,
        opts: *const ::std::os::raw::c_char,
        shorthand: *const *const ::std::os::raw::c_char,
        key_val_sep: *const ::std::os::raw::c_char,
        pairs_sep: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Free all allocated objects in obj."]
    pub fn av_opt_free(obj: *mut ::std::os::raw::c_void);
}
extern "C" {
    #[doc = " Check whether a particular flag is set in a flags field."]
    #[doc = ""]
    #[doc = " @param field_name the name of the flag field option"]
    #[doc = " @param flag_name the name of the flag to check"]
    #[doc = " @return non-zero if the flag is set, zero if the flag isn't set,"]
    #[doc = "         isn't of the right type, or the flags field doesn't exist."]
    pub fn av_opt_flag_is_set(
        obj: *mut ::std::os::raw::c_void,
        field_name: *const ::std::os::raw::c_char,
        flag_name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Set all the options from a given dictionary on an object."]
    #[doc = ""]
    #[doc = " @param obj a struct whose first element is a pointer to AVClass"]
    #[doc = " @param options options to process. This dictionary will be freed and replaced"]
    #[doc = "                by a new one containing all options not found in obj."]
    #[doc = "                Of course this new dictionary needs to be freed by caller"]
    #[doc = "                with av_dict_free()."]
    #[doc = ""]
    #[doc = " @return 0 on success, a negative AVERROR if some option was found in obj,"]
    #[doc = "         but could not be set."]
    #[doc = ""]
    #[doc = " @see av_dict_copy()"]
    pub fn av_opt_set_dict(
        obj: *mut ::std::os::raw::c_void,
        options: *mut *mut AVDictionary,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Set all the options from a given dictionary on an object."]
    #[doc = ""]
    #[doc = " @param obj a struct whose first element is a pointer to AVClass"]
    #[doc = " @param options options to process. This dictionary will be freed and replaced"]
    #[doc = "                by a new one containing all options not found in obj."]
    #[doc = "                Of course this new dictionary needs to be freed by caller"]
    #[doc = "                with av_dict_free()."]
    #[doc = " @param search_flags A combination of AV_OPT_SEARCH_*."]
    #[doc = ""]
    #[doc = " @return 0 on success, a negative AVERROR if some option was found in obj,"]
    #[doc = "         but could not be set."]
    #[doc = ""]
    #[doc = " @see av_dict_copy()"]
    pub fn av_opt_set_dict2(
        obj: *mut ::std::os::raw::c_void,
        options: *mut *mut AVDictionary,
        search_flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Extract a key-value pair from the beginning of a string."]
    #[doc = ""]
    #[doc = " @param ropts        pointer to the options string, will be updated to"]
    #[doc = "                     point to the rest of the string (one of the pairs_sep"]
    #[doc = "                     or the final NUL)"]
    #[doc = " @param key_val_sep  a 0-terminated list of characters used to separate"]
    #[doc = "                     key from value, for example '='"]
    #[doc = " @param pairs_sep    a 0-terminated list of characters used to separate"]
    #[doc = "                     two pairs from each other, for example ':' or ','"]
    #[doc = " @param flags        flags; see the AV_OPT_FLAG_* values below"]
    #[doc = " @param rkey         parsed key; must be freed using av_free()"]
    #[doc = " @param rval         parsed value; must be freed using av_free()"]
    #[doc = ""]
    #[doc = " @return  >=0 for success, or a negative value corresponding to an"]
    #[doc = "          AVERROR code in case of error; in particular:"]
    #[doc = "          AVERROR(EINVAL) if no key is present"]
    #[doc = ""]
    pub fn av_opt_get_key_value(
        ropts: *mut *const ::std::os::raw::c_char,
        key_val_sep: *const ::std::os::raw::c_char,
        pairs_sep: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_uint,
        rkey: *mut *mut ::std::os::raw::c_char,
        rval: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[doc = " Accept to parse a value without a key; the key will then be returned"]
#[doc = " as NULL."]
pub const AV_OPT_FLAG_IMPLICIT_KEY: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_5 = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " @defgroup opt_eval_funcs Evaluating option strings"]
    #[doc = " @{"]
    #[doc = " This group of functions can be used to evaluate option strings"]
    #[doc = " and get numbers out of them. They do the same thing as av_opt_set(),"]
    #[doc = " except the result is written into the caller-supplied pointer."]
    #[doc = ""]
    #[doc = " @param obj a struct whose first element is a pointer to AVClass."]
    #[doc = " @param o an option for which the string is to be evaluated."]
    #[doc = " @param val string to be evaluated."]
    #[doc = " @param *_out value of the string will be written here."]
    #[doc = ""]
    #[doc = " @return 0 on success, a negative number on failure."]
    pub fn av_opt_eval_flags(
        obj: *mut ::std::os::raw::c_void,
        o: *const AVOption,
        val: *const ::std::os::raw::c_char,
        flags_out: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_opt_eval_int(
        obj: *mut ::std::os::raw::c_void,
        o: *const AVOption,
        val: *const ::std::os::raw::c_char,
        int_out: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_opt_eval_int64(
        obj: *mut ::std::os::raw::c_void,
        o: *const AVOption,
        val: *const ::std::os::raw::c_char,
        int64_out: *mut i64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_opt_eval_float(
        obj: *mut ::std::os::raw::c_void,
        o: *const AVOption,
        val: *const ::std::os::raw::c_char,
        float_out: *mut f32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_opt_eval_double(
        obj: *mut ::std::os::raw::c_void,
        o: *const AVOption,
        val: *const ::std::os::raw::c_char,
        double_out: *mut f64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_opt_eval_q(
        obj: *mut ::std::os::raw::c_void,
        o: *const AVOption,
        val: *const ::std::os::raw::c_char,
        q_out: *mut AVRational,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Look for an option in an object. Consider only options which"]
    #[doc = " have all the specified flags set."]
    #[doc = ""]
    #[doc = " @param[in] obj A pointer to a struct whose first element is a"]
    #[doc = "                pointer to an AVClass."]
    #[doc = "                Alternatively a double pointer to an AVClass, if"]
    #[doc = "                AV_OPT_SEARCH_FAKE_OBJ search flag is set."]
    #[doc = " @param[in] name The name of the option to look for."]
    #[doc = " @param[in] unit When searching for named constants, name of the unit"]
    #[doc = "                 it belongs to."]
    #[doc = " @param opt_flags Find only options with all the specified flags set (AV_OPT_FLAG)."]
    #[doc = " @param search_flags A combination of AV_OPT_SEARCH_*."]
    #[doc = ""]
    #[doc = " @return A pointer to the option found, or NULL if no option"]
    #[doc = "         was found."]
    #[doc = ""]
    #[doc = " @note Options found with AV_OPT_SEARCH_CHILDREN flag may not be settable"]
    #[doc = " directly with av_opt_set(). Use special calls which take an options"]
    #[doc = " AVDictionary (e.g. avformat_open_input()) to set options found with this"]
    #[doc = " flag."]
    pub fn av_opt_find(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        unit: *const ::std::os::raw::c_char,
        opt_flags: ::std::os::raw::c_int,
        search_flags: ::std::os::raw::c_int,
    ) -> *const AVOption;
}
extern "C" {
    #[doc = " Look for an option in an object. Consider only options which"]
    #[doc = " have all the specified flags set."]
    #[doc = ""]
    #[doc = " @param[in] obj A pointer to a struct whose first element is a"]
    #[doc = "                pointer to an AVClass."]
    #[doc = "                Alternatively a double pointer to an AVClass, if"]
    #[doc = "                AV_OPT_SEARCH_FAKE_OBJ search flag is set."]
    #[doc = " @param[in] name The name of the option to look for."]
    #[doc = " @param[in] unit When searching for named constants, name of the unit"]
    #[doc = "                 it belongs to."]
    #[doc = " @param opt_flags Find only options with all the specified flags set (AV_OPT_FLAG)."]
    #[doc = " @param search_flags A combination of AV_OPT_SEARCH_*."]
    #[doc = " @param[out] target_obj if non-NULL, an object to which the option belongs will be"]
    #[doc = " written here. It may be different from obj if AV_OPT_SEARCH_CHILDREN is present"]
    #[doc = " in search_flags. This parameter is ignored if search_flags contain"]
    #[doc = " AV_OPT_SEARCH_FAKE_OBJ."]
    #[doc = ""]
    #[doc = " @return A pointer to the option found, or NULL if no option"]
    #[doc = "         was found."]
    pub fn av_opt_find2(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        unit: *const ::std::os::raw::c_char,
        opt_flags: ::std::os::raw::c_int,
        search_flags: ::std::os::raw::c_int,
        target_obj: *mut *mut ::std::os::raw::c_void,
    ) -> *const AVOption;
}
extern "C" {
    #[doc = " Iterate over all AVOptions belonging to obj."]
    #[doc = ""]
    #[doc = " @param obj an AVOptions-enabled struct or a double pointer to an"]
    #[doc = "            AVClass describing it."]
    #[doc = " @param prev result of the previous call to av_opt_next() on this object"]
    #[doc = "             or NULL"]
    #[doc = " @return next AVOption or NULL"]
    pub fn av_opt_next(
        obj: *const ::std::os::raw::c_void,
        prev: *const AVOption,
    ) -> *const AVOption;
}
extern "C" {
    #[doc = " Iterate over AVOptions-enabled children of obj."]
    #[doc = ""]
    #[doc = " @param prev result of a previous call to this function or NULL"]
    #[doc = " @return next AVOptions-enabled child or NULL"]
    pub fn av_opt_child_next(
        obj: *mut ::std::os::raw::c_void,
        prev: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Iterate over potential AVOptions-enabled children of parent."]
    #[doc = ""]
    #[doc = " @param iter a pointer where iteration state is stored."]
    #[doc = " @return AVClass corresponding to next potential child or NULL"]
    pub fn av_opt_child_class_iterate(
        parent: *const AVClass,
        iter: *mut *mut ::std::os::raw::c_void,
    ) -> *const AVClass;
}
extern "C" {
    #[doc = " @defgroup opt_set_funcs Option setting functions"]
    #[doc = " @{"]
    #[doc = " Those functions set the field of obj with the given name to value."]
    #[doc = ""]
    #[doc = " @param[in] obj A struct whose first element is a pointer to an AVClass."]
    #[doc = " @param[in] name the name of the field to set"]
    #[doc = " @param[in] val The value to set. In case of av_opt_set() if the field is not"]
    #[doc = " of a string type, then the given string is parsed."]
    #[doc = " SI postfixes and some named scalars are supported."]
    #[doc = " If the field is of a numeric type, it has to be a numeric or named"]
    #[doc = " scalar. Behavior with more than one scalar and +- infix operators"]
    #[doc = " is undefined."]
    #[doc = " If the field is of a flags type, it has to be a sequence of numeric"]
    #[doc = " scalars or named flags separated by '+' or '-'. Prefixing a flag"]
    #[doc = " with '+' causes it to be set without affecting the other flags;"]
    #[doc = " similarly, '-' unsets a flag."]
    #[doc = " If the field is of a dictionary type, it has to be a ':' separated list of"]
    #[doc = " key=value parameters. Values containing ':' special characters must be"]
    #[doc = " escaped."]
    #[doc = " @param search_flags flags passed to av_opt_find2. I.e. if AV_OPT_SEARCH_CHILDREN"]
    #[doc = " is passed here, then the option may be set on a child of obj."]
    #[doc = ""]
    #[doc = " @return 0 if the value has been set, or an AVERROR code in case of"]
    #[doc = " error:"]
    #[doc = " AVERROR_OPTION_NOT_FOUND if no matching option exists"]
    #[doc = " AVERROR(ERANGE) if the value is out of range"]
    #[doc = " AVERROR(EINVAL) if the value is not valid"]
    pub fn av_opt_set(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
        search_flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_opt_set_int(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        val: i64,
        search_flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_opt_set_double(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        val: f64,
        search_flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_opt_set_q(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        val: AVRational,
        search_flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_opt_set_bin(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        val: *const u8,
        size: ::std::os::raw::c_int,
        search_flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_opt_set_image_size(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        search_flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_opt_set_pixel_fmt(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        fmt: AVPixelFormat,
        search_flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_opt_set_sample_fmt(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        fmt: AVSampleFormat,
        search_flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_opt_set_video_rate(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        val: AVRational,
        search_flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_opt_set_channel_layout(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        ch_layout: i64,
        search_flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @note Any old dictionary present is discarded and replaced with a copy of the new one. The"]
    #[doc = " caller still owns val is and responsible for freeing it."]
    pub fn av_opt_set_dict_val(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        val: *const AVDictionary,
        search_flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @defgroup opt_get_funcs Option getting functions"]
    #[doc = " @{"]
    #[doc = " Those functions get a value of the option with the given name from an object."]
    #[doc = ""]
    #[doc = " @param[in] obj a struct whose first element is a pointer to an AVClass."]
    #[doc = " @param[in] name name of the option to get."]
    #[doc = " @param[in] search_flags flags passed to av_opt_find2. I.e. if AV_OPT_SEARCH_CHILDREN"]
    #[doc = " is passed here, then the option may be found in a child of obj."]
    #[doc = " @param[out] out_val value of the option will be written here"]
    #[doc = " @return >=0 on success, a negative error code otherwise"]
    #[doc = " @note the returned string will be av_malloc()ed and must be av_free()ed by the caller"]
    #[doc = ""]
    #[doc = " @note if AV_OPT_ALLOW_NULL is set in search_flags in av_opt_get, and the"]
    #[doc = " option is of type AV_OPT_TYPE_STRING, AV_OPT_TYPE_BINARY or AV_OPT_TYPE_DICT"]
    #[doc = " and is set to NULL, *out_val will be set to NULL instead of an allocated"]
    #[doc = " empty string."]
    pub fn av_opt_get(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        search_flags: ::std::os::raw::c_int,
        out_val: *mut *mut u8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_opt_get_int(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        search_flags: ::std::os::raw::c_int,
        out_val: *mut i64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_opt_get_double(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        search_flags: ::std::os::raw::c_int,
        out_val: *mut f64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_opt_get_q(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        search_flags: ::std::os::raw::c_int,
        out_val: *mut AVRational,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_opt_get_image_size(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        search_flags: ::std::os::raw::c_int,
        w_out: *mut ::std::os::raw::c_int,
        h_out: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_opt_get_pixel_fmt(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        search_flags: ::std::os::raw::c_int,
        out_fmt: *mut AVPixelFormat,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_opt_get_sample_fmt(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        search_flags: ::std::os::raw::c_int,
        out_fmt: *mut AVSampleFormat,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_opt_get_video_rate(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        search_flags: ::std::os::raw::c_int,
        out_val: *mut AVRational,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_opt_get_channel_layout(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        search_flags: ::std::os::raw::c_int,
        ch_layout: *mut i64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @param[out] out_val The returned dictionary is a copy of the actual value and must"]
    #[doc = " be freed with av_dict_free() by the caller"]
    pub fn av_opt_get_dict_val(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        search_flags: ::std::os::raw::c_int,
        out_val: *mut *mut AVDictionary,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @}"]
    #[doc = " Gets a pointer to the requested field in a struct."]
    #[doc = " This function allows accessing a struct even when its fields are moved or"]
    #[doc = " renamed since the application making the access has been compiled,"]
    #[doc = ""]
    #[doc = " @returns a pointer to the field, it can be cast to the correct type and read"]
    #[doc = "          or written to."]
    pub fn av_opt_ptr(
        avclass: *const AVClass,
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Free an AVOptionRanges struct and set it to NULL."]
    pub fn av_opt_freep_ranges(ranges: *mut *mut AVOptionRanges);
}
extern "C" {
    #[doc = " Get a list of allowed ranges for the given option."]
    #[doc = ""]
    #[doc = " The returned list may depend on other fields in obj like for example profile."]
    #[doc = ""]
    #[doc = " @param flags is a bitmask of flags, undefined flags should not be set and should be ignored"]
    #[doc = "              AV_OPT_SEARCH_FAKE_OBJ indicates that the obj is a double pointer to a AVClass instead of a full instance"]
    #[doc = "              AV_OPT_MULTI_COMPONENT_RANGE indicates that function may return more than one component, @see AVOptionRanges"]
    #[doc = ""]
    #[doc = " The result must be freed with av_opt_freep_ranges."]
    #[doc = ""]
    #[doc = " @return number of compontents returned on success, a negative errro code otherwise"]
    pub fn av_opt_query_ranges(
        arg1: *mut *mut AVOptionRanges,
        obj: *mut ::std::os::raw::c_void,
        key: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Copy options from src object into dest object."]
    #[doc = ""]
    #[doc = " Options that require memory allocation (e.g. string or binary) are malloc'ed in dest object."]
    #[doc = " Original memory allocated for such options is freed unless both src and dest options points to the same memory."]
    #[doc = ""]
    #[doc = " @param dest Object to copy from"]
    #[doc = " @param src  Object to copy into"]
    #[doc = " @return 0 on success, negative on error"]
    pub fn av_opt_copy(
        dest: *mut ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get a default list of allowed ranges for the given option."]
    #[doc = ""]
    #[doc = " This list is constructed without using the AVClass.query_ranges() callback"]
    #[doc = " and can be used as fallback from within the callback."]
    #[doc = ""]
    #[doc = " @param flags is a bitmask of flags, undefined flags should not be set and should be ignored"]
    #[doc = "              AV_OPT_SEARCH_FAKE_OBJ indicates that the obj is a double pointer to a AVClass instead of a full instance"]
    #[doc = "              AV_OPT_MULTI_COMPONENT_RANGE indicates that function may return more than one component, @see AVOptionRanges"]
    #[doc = ""]
    #[doc = " The result must be freed with av_opt_free_ranges."]
    #[doc = ""]
    #[doc = " @return number of compontents returned on success, a negative errro code otherwise"]
    pub fn av_opt_query_ranges_default(
        arg1: *mut *mut AVOptionRanges,
        obj: *mut ::std::os::raw::c_void,
        key: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Check if given option is set to its default value."]
    #[doc = ""]
    #[doc = " Options o must belong to the obj. This function must not be called to check child's options state."]
    #[doc = " @see av_opt_is_set_to_default_by_name()."]
    #[doc = ""]
    #[doc = " @param obj  AVClass object to check option on"]
    #[doc = " @param o    option to be checked"]
    #[doc = " @return     >0 when option is set to its default,"]
    #[doc = "              0 when option is not set its default,"]
    #[doc = "             <0 on error"]
    pub fn av_opt_is_set_to_default(
        obj: *mut ::std::os::raw::c_void,
        o: *const AVOption,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Check if given option is set to its default value."]
    #[doc = ""]
    #[doc = " @param obj          AVClass object to check option on"]
    #[doc = " @param name         option name"]
    #[doc = " @param search_flags combination of AV_OPT_SEARCH_*"]
    #[doc = " @return             >0 when option is set to its default,"]
    #[doc = "                     0 when option is not set its default,"]
    #[doc = "                     <0 on error"]
    pub fn av_opt_is_set_to_default_by_name(
        obj: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        search_flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Serialize object's options."]
    #[doc = ""]
    #[doc = " Create a string containing object's serialized options."]
    #[doc = " Such string may be passed back to av_opt_set_from_string() in order to restore option values."]
    #[doc = " A key/value or pairs separator occurring in the serialized value or"]
    #[doc = " name string are escaped through the av_escape() function."]
    #[doc = ""]
    #[doc = " @param[in]  obj           AVClass object to serialize"]
    #[doc = " @param[in]  opt_flags     serialize options with all the specified flags set (AV_OPT_FLAG)"]
    #[doc = " @param[in]  flags         combination of AV_OPT_SERIALIZE_* flags"]
    #[doc = " @param[out] buffer        Pointer to buffer that will be allocated with string containg serialized options."]
    #[doc = "                           Buffer must be freed by the caller when is no longer needed."]
    #[doc = " @param[in]  key_val_sep   character used to separate key from value"]
    #[doc = " @param[in]  pairs_sep     character used to separate two pairs from each other"]
    #[doc = " @return                   >= 0 on success, negative on error"]
    #[doc = " @warning Separators cannot be neither '\\\\' nor '\\0'. They also cannot be the same."]
    pub fn av_opt_serialize(
        obj: *mut ::std::os::raw::c_void,
        opt_flags: ::std::os::raw::c_int,
        flags: ::std::os::raw::c_int,
        buffer: *mut *mut ::std::os::raw::c_char,
        key_val_sep: ::std::os::raw::c_char,
        pairs_sep: ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tm {
    pub tm_sec: ::std::os::raw::c_int,
    pub tm_min: ::std::os::raw::c_int,
    pub tm_hour: ::std::os::raw::c_int,
    pub tm_mday: ::std::os::raw::c_int,
    pub tm_mon: ::std::os::raw::c_int,
    pub tm_year: ::std::os::raw::c_int,
    pub tm_wday: ::std::os::raw::c_int,
    pub tm_yday: ::std::os::raw::c_int,
    pub tm_isdst: ::std::os::raw::c_int,
    pub tm_gmtoff: ::std::os::raw::c_long,
    pub tm_zone: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_tm() {
    assert_eq!(
        ::std::mem::size_of::<tm>(),
        56usize,
        concat!("Size of: ", stringify!(tm))
    );
    assert_eq!(
        ::std::mem::align_of::<tm>(),
        8usize,
        concat!("Alignment of ", stringify!(tm))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_min as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_hour as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_hour)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_mday as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_mday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_mon as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_mon)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_year as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_year)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_wday as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_wday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_yday as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_yday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_isdst as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_isdst)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_gmtoff as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_gmtoff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_zone as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_zone)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct itimerspec {
    pub it_interval: timespec,
    pub it_value: timespec,
}
#[test]
fn bindgen_test_layout_itimerspec() {
    assert_eq!(
        ::std::mem::size_of::<itimerspec>(),
        32usize,
        concat!("Size of: ", stringify!(itimerspec))
    );
    assert_eq!(
        ::std::mem::align_of::<itimerspec>(),
        8usize,
        concat!("Alignment of ", stringify!(itimerspec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<itimerspec>())).it_interval as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(itimerspec),
            "::",
            stringify!(it_interval)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<itimerspec>())).it_value as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(itimerspec),
            "::",
            stringify!(it_value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigevent {
    _unused: [u8; 0],
}
extern "C" {
    pub fn clock() -> clock_t;
}
extern "C" {
    pub fn time(__timer: *mut time_t) -> time_t;
}
extern "C" {
    pub fn difftime(__time1: time_t, __time0: time_t) -> f64;
}
extern "C" {
    pub fn mktime(__tp: *mut tm) -> time_t;
}
extern "C" {
    pub fn strftime(
        __s: *mut ::std::os::raw::c_char,
        __maxsize: size_t,
        __format: *const ::std::os::raw::c_char,
        __tp: *const tm,
    ) -> size_t;
}
extern "C" {
    pub fn strftime_l(
        __s: *mut ::std::os::raw::c_char,
        __maxsize: size_t,
        __format: *const ::std::os::raw::c_char,
        __tp: *const tm,
        __loc: locale_t,
    ) -> size_t;
}
extern "C" {
    pub fn gmtime(__timer: *const time_t) -> *mut tm;
}
extern "C" {
    pub fn localtime(__timer: *const time_t) -> *mut tm;
}
extern "C" {
    pub fn gmtime_r(__timer: *const time_t, __tp: *mut tm) -> *mut tm;
}
extern "C" {
    pub fn localtime_r(__timer: *const time_t, __tp: *mut tm) -> *mut tm;
}
extern "C" {
    pub fn asctime(__tp: *const tm) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ctime(__timer: *const time_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn asctime_r(
        __tp: *const tm,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ctime_r(
        __timer: *const time_t,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut __tzname: [*mut ::std::os::raw::c_char; 2usize];
}
extern "C" {
    pub static mut __daylight: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut __timezone: ::std::os::raw::c_long;
}
extern "C" {
    pub static mut tzname: [*mut ::std::os::raw::c_char; 2usize];
}
extern "C" {
    pub fn tzset();
}
extern "C" {
    pub static mut daylight: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut timezone: ::std::os::raw::c_long;
}
extern "C" {
    pub fn timegm(__tp: *mut tm) -> time_t;
}
extern "C" {
    pub fn timelocal(__tp: *mut tm) -> time_t;
}
extern "C" {
    pub fn dysize(__year: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nanosleep(
        __requested_time: *const timespec,
        __remaining: *mut timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_getres(__clock_id: clockid_t, __res: *mut timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_gettime(__clock_id: clockid_t, __tp: *mut timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_settime(__clock_id: clockid_t, __tp: *const timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_nanosleep(
        __clock_id: clockid_t,
        __flags: ::std::os::raw::c_int,
        __req: *const timespec,
        __rem: *mut timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_getcpuclockid(__pid: pid_t, __clock_id: *mut clockid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_create(
        __clock_id: clockid_t,
        __evp: *mut sigevent,
        __timerid: *mut timer_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_delete(__timerid: timer_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_settime(
        __timerid: timer_t,
        __flags: ::std::os::raw::c_int,
        __value: *const itimerspec,
        __ovalue: *mut itimerspec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_gettime(__timerid: timer_t, __value: *mut itimerspec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_getoverrun(__timerid: timer_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timespec_get(
        __ts: *mut timespec,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[doc = " Callback for checking whether to abort blocking functions."]
#[doc = " AVERROR_EXIT is returned in this case by the interrupted"]
#[doc = " function. During blocking operations, callback is called with"]
#[doc = " opaque as parameter. If the callback returns 1, the"]
#[doc = " blocking operation will be aborted."]
#[doc = ""]
#[doc = " No members can be added to this struct without a major bump, if"]
#[doc = " new elements have been added after this struct in AVFormatContext"]
#[doc = " or AVIOContext."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVIOInterruptCB {
    pub callback: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub opaque: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_AVIOInterruptCB() {
    assert_eq!(
        ::std::mem::size_of::<AVIOInterruptCB>(),
        16usize,
        concat!("Size of: ", stringify!(AVIOInterruptCB))
    );
    assert_eq!(
        ::std::mem::align_of::<AVIOInterruptCB>(),
        8usize,
        concat!("Alignment of ", stringify!(AVIOInterruptCB))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOInterruptCB>())).callback as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOInterruptCB),
            "::",
            stringify!(callback)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOInterruptCB>())).opaque as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOInterruptCB),
            "::",
            stringify!(opaque)
        )
    );
}
pub const AVIODirEntryType_AVIO_ENTRY_UNKNOWN: AVIODirEntryType = 0;
pub const AVIODirEntryType_AVIO_ENTRY_BLOCK_DEVICE: AVIODirEntryType = 1;
pub const AVIODirEntryType_AVIO_ENTRY_CHARACTER_DEVICE: AVIODirEntryType = 2;
pub const AVIODirEntryType_AVIO_ENTRY_DIRECTORY: AVIODirEntryType = 3;
pub const AVIODirEntryType_AVIO_ENTRY_NAMED_PIPE: AVIODirEntryType = 4;
pub const AVIODirEntryType_AVIO_ENTRY_SYMBOLIC_LINK: AVIODirEntryType = 5;
pub const AVIODirEntryType_AVIO_ENTRY_SOCKET: AVIODirEntryType = 6;
pub const AVIODirEntryType_AVIO_ENTRY_FILE: AVIODirEntryType = 7;
pub const AVIODirEntryType_AVIO_ENTRY_SERVER: AVIODirEntryType = 8;
pub const AVIODirEntryType_AVIO_ENTRY_SHARE: AVIODirEntryType = 9;
pub const AVIODirEntryType_AVIO_ENTRY_WORKGROUP: AVIODirEntryType = 10;
#[doc = " Directory entry types."]
pub type AVIODirEntryType = ::std::os::raw::c_uint;
#[doc = " Describes single entry of the directory."]
#[doc = ""]
#[doc = " Only name and type fields are guaranteed be set."]
#[doc = " Rest of fields are protocol or/and platform dependent and might be unknown."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVIODirEntry {
    #[doc = "< Filename"]
    pub name: *mut ::std::os::raw::c_char,
    #[doc = "< Type of the entry"]
    pub type_: ::std::os::raw::c_int,
    #[doc = "< Set to 1 when name is encoded with UTF-8, 0 otherwise."]
    #[doc = "Name can be encoded with UTF-8 even though 0 is set."]
    pub utf8: ::std::os::raw::c_int,
    #[doc = "< File size in bytes, -1 if unknown."]
    pub size: i64,
    #[doc = "< Time of last modification in microseconds since unix"]
    #[doc = "epoch, -1 if unknown."]
    pub modification_timestamp: i64,
    #[doc = "< Time of last access in microseconds since unix epoch,"]
    #[doc = "-1 if unknown."]
    pub access_timestamp: i64,
    #[doc = "< Time of last status change in microseconds since unix"]
    #[doc = "epoch, -1 if unknown."]
    pub status_change_timestamp: i64,
    #[doc = "< User ID of owner, -1 if unknown."]
    pub user_id: i64,
    #[doc = "< Group ID of owner, -1 if unknown."]
    pub group_id: i64,
    #[doc = "< Unix file mode, -1 if unknown."]
    pub filemode: i64,
}
#[test]
fn bindgen_test_layout_AVIODirEntry() {
    assert_eq!(
        ::std::mem::size_of::<AVIODirEntry>(),
        72usize,
        concat!("Size of: ", stringify!(AVIODirEntry))
    );
    assert_eq!(
        ::std::mem::align_of::<AVIODirEntry>(),
        8usize,
        concat!("Alignment of ", stringify!(AVIODirEntry))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIODirEntry>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIODirEntry),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIODirEntry>())).type_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIODirEntry),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIODirEntry>())).utf8 as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIODirEntry),
            "::",
            stringify!(utf8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIODirEntry>())).size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIODirEntry),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVIODirEntry>())).modification_timestamp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIODirEntry),
            "::",
            stringify!(modification_timestamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIODirEntry>())).access_timestamp as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIODirEntry),
            "::",
            stringify!(access_timestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVIODirEntry>())).status_change_timestamp as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIODirEntry),
            "::",
            stringify!(status_change_timestamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIODirEntry>())).user_id as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIODirEntry),
            "::",
            stringify!(user_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIODirEntry>())).group_id as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIODirEntry),
            "::",
            stringify!(group_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIODirEntry>())).filemode as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIODirEntry),
            "::",
            stringify!(filemode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVIODirContext {
    pub url_context: *mut URLContext,
}
#[test]
fn bindgen_test_layout_AVIODirContext() {
    assert_eq!(
        ::std::mem::size_of::<AVIODirContext>(),
        8usize,
        concat!("Size of: ", stringify!(AVIODirContext))
    );
    assert_eq!(
        ::std::mem::align_of::<AVIODirContext>(),
        8usize,
        concat!("Alignment of ", stringify!(AVIODirContext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIODirContext>())).url_context as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIODirContext),
            "::",
            stringify!(url_context)
        )
    );
}
#[doc = " Header data; this needs to be present for the stream to be decodeable."]
pub const AVIODataMarkerType_AVIO_DATA_MARKER_HEADER: AVIODataMarkerType = 0;
#[doc = " A point in the output bytestream where a decoder can start decoding"]
#[doc = " (i.e. a keyframe). A demuxer/decoder given the data flagged with"]
#[doc = " AVIO_DATA_MARKER_HEADER, followed by any AVIO_DATA_MARKER_SYNC_POINT,"]
#[doc = " should give decodeable results."]
pub const AVIODataMarkerType_AVIO_DATA_MARKER_SYNC_POINT: AVIODataMarkerType = 1;
#[doc = " A point in the output bytestream where a demuxer can start parsing"]
#[doc = " (for non self synchronizing bytestream formats). That is, any"]
#[doc = " non-keyframe packet start point."]
pub const AVIODataMarkerType_AVIO_DATA_MARKER_BOUNDARY_POINT: AVIODataMarkerType = 2;
#[doc = " This is any, unlabelled data. It can either be a muxer not marking"]
#[doc = " any positions at all, it can be an actual boundary/sync point"]
#[doc = " that the muxer chooses not to mark, or a later part of a packet/fragment"]
#[doc = " that is cut into multiple write callbacks due to limited IO buffer size."]
pub const AVIODataMarkerType_AVIO_DATA_MARKER_UNKNOWN: AVIODataMarkerType = 3;
#[doc = " Trailer data, which doesn't contain actual content, but only for"]
#[doc = " finalizing the output file."]
pub const AVIODataMarkerType_AVIO_DATA_MARKER_TRAILER: AVIODataMarkerType = 4;
#[doc = " A point in the output bytestream where the underlying AVIOContext might"]
#[doc = " flush the buffer depending on latency or buffering requirements. Typically"]
#[doc = " means the end of a packet."]
pub const AVIODataMarkerType_AVIO_DATA_MARKER_FLUSH_POINT: AVIODataMarkerType = 5;
#[doc = " Different data types that can be returned via the AVIO"]
#[doc = " write_data_type callback."]
pub type AVIODataMarkerType = ::std::os::raw::c_uint;
#[doc = " Bytestream IO Context."]
#[doc = " New fields can be added to the end with minor version bumps."]
#[doc = " Removal, reordering and changes to existing fields require a major"]
#[doc = " version bump."]
#[doc = " sizeof(AVIOContext) must not be used outside libav*."]
#[doc = ""]
#[doc = " @note None of the function pointers in AVIOContext should be called"]
#[doc = "       directly, they should only be set by the client application"]
#[doc = "       when implementing custom I/O. Normally these are set to the"]
#[doc = "       function pointers specified in avio_alloc_context()"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVIOContext {
    #[doc = " A class for private options."]
    #[doc = ""]
    #[doc = " If this AVIOContext is created by avio_open2(), av_class is set and"]
    #[doc = " passes the options down to protocols."]
    #[doc = ""]
    #[doc = " If this AVIOContext is manually allocated, then av_class may be set by"]
    #[doc = " the caller."]
    #[doc = ""]
    #[doc = " warning -- this field can be NULL, be sure to not pass this AVIOContext"]
    #[doc = " to any av_opt_* functions in that case."]
    pub av_class: *const AVClass,
    #[doc = "< Start of the buffer."]
    pub buffer: *mut ::std::os::raw::c_uchar,
    #[doc = "< Maximum buffer size"]
    pub buffer_size: ::std::os::raw::c_int,
    #[doc = "< Current position in the buffer"]
    pub buf_ptr: *mut ::std::os::raw::c_uchar,
    #[doc = "< End of the data, may be less than"]
    #[doc = "buffer+buffer_size if the read function returned"]
    #[doc = "less data than requested, e.g. for streams where"]
    #[doc = "no more data has been received yet."]
    pub buf_end: *mut ::std::os::raw::c_uchar,
    #[doc = "< A private pointer, passed to the read/write/seek/..."]
    #[doc = "functions."]
    pub opaque: *mut ::std::os::raw::c_void,
    pub read_packet: ::std::option::Option<
        unsafe extern "C" fn(
            opaque: *mut ::std::os::raw::c_void,
            buf: *mut u8,
            buf_size: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub write_packet: ::std::option::Option<
        unsafe extern "C" fn(
            opaque: *mut ::std::os::raw::c_void,
            buf: *mut u8,
            buf_size: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub seek: ::std::option::Option<
        unsafe extern "C" fn(
            opaque: *mut ::std::os::raw::c_void,
            offset: i64,
            whence: ::std::os::raw::c_int,
        ) -> i64,
    >,
    #[doc = "< position in the file of the current buffer"]
    pub pos: i64,
    #[doc = "< true if was unable to read due to error or eof"]
    pub eof_reached: ::std::os::raw::c_int,
    #[doc = "< true if open for writing"]
    pub write_flag: ::std::os::raw::c_int,
    pub max_packet_size: ::std::os::raw::c_int,
    pub checksum: ::std::os::raw::c_ulong,
    pub checksum_ptr: *mut ::std::os::raw::c_uchar,
    pub update_checksum: ::std::option::Option<
        unsafe extern "C" fn(
            checksum: ::std::os::raw::c_ulong,
            buf: *const u8,
            size: ::std::os::raw::c_uint,
        ) -> ::std::os::raw::c_ulong,
    >,
    #[doc = "< contains the error code or 0 if no error happened"]
    pub error: ::std::os::raw::c_int,
    #[doc = " Pause or resume playback for network streaming protocols - e.g. MMS."]
    pub read_pause: ::std::option::Option<
        unsafe extern "C" fn(
            opaque: *mut ::std::os::raw::c_void,
            pause: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " Seek to a given timestamp in stream with the specified stream_index."]
    #[doc = " Needed for some network streaming protocols which don't support seeking"]
    #[doc = " to byte position."]
    pub read_seek: ::std::option::Option<
        unsafe extern "C" fn(
            opaque: *mut ::std::os::raw::c_void,
            stream_index: ::std::os::raw::c_int,
            timestamp: i64,
            flags: ::std::os::raw::c_int,
        ) -> i64,
    >,
    #[doc = " A combination of AVIO_SEEKABLE_ flags or 0 when the stream is not seekable."]
    pub seekable: ::std::os::raw::c_int,
    #[doc = " max filesize, used to limit allocations"]
    #[doc = " This field is internal to libavformat and access from outside is not allowed."]
    pub maxsize: i64,
    #[doc = " avio_read and avio_write should if possible be satisfied directly"]
    #[doc = " instead of going through a buffer, and avio_seek will always"]
    #[doc = " call the underlying seek function directly."]
    pub direct: ::std::os::raw::c_int,
    #[doc = " Bytes read statistic"]
    #[doc = " This field is internal to libavformat and access from outside is not allowed."]
    pub bytes_read: i64,
    #[doc = " seek statistic"]
    #[doc = " This field is internal to libavformat and access from outside is not allowed."]
    pub seek_count: ::std::os::raw::c_int,
    #[doc = " writeout statistic"]
    #[doc = " This field is internal to libavformat and access from outside is not allowed."]
    pub writeout_count: ::std::os::raw::c_int,
    #[doc = " Original buffer size"]
    #[doc = " used internally after probing and ensure seekback to reset the buffer size"]
    #[doc = " This field is internal to libavformat and access from outside is not allowed."]
    pub orig_buffer_size: ::std::os::raw::c_int,
    #[doc = " Threshold to favor readahead over seek."]
    #[doc = " This is current internal only, do not use from outside."]
    pub short_seek_threshold: ::std::os::raw::c_int,
    #[doc = " ',' separated list of allowed protocols."]
    pub protocol_whitelist: *const ::std::os::raw::c_char,
    #[doc = " ',' separated list of disallowed protocols."]
    pub protocol_blacklist: *const ::std::os::raw::c_char,
    #[doc = " A callback that is used instead of write_packet."]
    pub write_data_type: ::std::option::Option<
        unsafe extern "C" fn(
            opaque: *mut ::std::os::raw::c_void,
            buf: *mut u8,
            buf_size: ::std::os::raw::c_int,
            type_: AVIODataMarkerType,
            time: i64,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " If set, don't call write_data_type separately for AVIO_DATA_MARKER_BOUNDARY_POINT,"]
    #[doc = " but ignore them and treat them as AVIO_DATA_MARKER_UNKNOWN (to avoid needlessly"]
    #[doc = " small chunks of data returned from the callback)."]
    pub ignore_boundary_point: ::std::os::raw::c_int,
    #[doc = " Internal, not meant to be used from outside of AVIOContext."]
    pub current_type: AVIODataMarkerType,
    pub last_time: i64,
    #[doc = " A callback that is used instead of short_seek_threshold."]
    #[doc = " This is current internal only, do not use from outside."]
    pub short_seek_get: ::std::option::Option<
        unsafe extern "C" fn(opaque: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub written: i64,
    #[doc = " Maximum reached position before a backward seek in the write buffer,"]
    #[doc = " used keeping track of already written data for a later flush."]
    pub buf_ptr_max: *mut ::std::os::raw::c_uchar,
    #[doc = " Try to buffer at least this amount of data before flushing it"]
    pub min_packet_size: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_AVIOContext() {
    assert_eq!(
        ::std::mem::size_of::<AVIOContext>(),
        264usize,
        concat!("Size of: ", stringify!(AVIOContext))
    );
    assert_eq!(
        ::std::mem::align_of::<AVIOContext>(),
        8usize,
        concat!("Alignment of ", stringify!(AVIOContext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).av_class as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(av_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).buffer as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).buffer_size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(buffer_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).buf_ptr as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(buf_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).buf_end as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(buf_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).opaque as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(opaque)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).read_packet as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(read_packet)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).write_packet as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(write_packet)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).seek as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(seek)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).pos as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).eof_reached as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(eof_reached)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).write_flag as *const _ as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(write_flag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).max_packet_size as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(max_packet_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).checksum as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(checksum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).checksum_ptr as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(checksum_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).update_checksum as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(update_checksum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).error as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(error)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).read_pause as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(read_pause)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).read_seek as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(read_seek)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).seekable as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(seekable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).maxsize as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(maxsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).direct as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(direct)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).bytes_read as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(bytes_read)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).seek_count as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(seek_count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).writeout_count as *const _ as usize },
        180usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(writeout_count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).orig_buffer_size as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(orig_buffer_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVIOContext>())).short_seek_threshold as *const _ as usize
        },
        188usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(short_seek_threshold)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).protocol_whitelist as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(protocol_whitelist)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).protocol_blacklist as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(protocol_blacklist)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).write_data_type as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(write_data_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVIOContext>())).ignore_boundary_point as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(ignore_boundary_point)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).current_type as *const _ as usize },
        220usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(current_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).last_time as *const _ as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(last_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).short_seek_get as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(short_seek_get)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).written as *const _ as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(written)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).buf_ptr_max as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(buf_ptr_max)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIOContext>())).min_packet_size as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIOContext),
            "::",
            stringify!(min_packet_size)
        )
    );
}
extern "C" {
    #[doc = " Return the name of the protocol that will handle the passed URL."]
    #[doc = ""]
    #[doc = " NULL is returned if no protocol could be found for the given URL."]
    #[doc = ""]
    #[doc = " @return Name of the protocol or NULL."]
    pub fn avio_find_protocol_name(
        url: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Return AVIO_FLAG_* access flags corresponding to the access permissions"]
    #[doc = " of the resource in url, or a negative value corresponding to an"]
    #[doc = " AVERROR code in case of failure. The returned access flags are"]
    #[doc = " masked by the value in flags."]
    #[doc = ""]
    #[doc = " @note This function is intrinsically unsafe, in the sense that the"]
    #[doc = " checked resource may change its existence or permission status from"]
    #[doc = " one call to another. Thus you should not trust the returned value,"]
    #[doc = " unless you are sure that no other processes are accessing the"]
    #[doc = " checked resource."]
    pub fn avio_check(
        url: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Move or rename a resource."]
    #[doc = ""]
    #[doc = " @note url_src and url_dst should share the same protocol and authority."]
    #[doc = ""]
    #[doc = " @param url_src url to resource to be moved"]
    #[doc = " @param url_dst new url to resource if the operation succeeded"]
    #[doc = " @return >=0 on success or negative on error."]
    pub fn avpriv_io_move(
        url_src: *const ::std::os::raw::c_char,
        url_dst: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Delete a resource."]
    #[doc = ""]
    #[doc = " @param url resource to be deleted."]
    #[doc = " @return >=0 on success or negative on error."]
    pub fn avpriv_io_delete(url: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Open directory for reading."]
    #[doc = ""]
    #[doc = " @param s       directory read context. Pointer to a NULL pointer must be passed."]
    #[doc = " @param url     directory to be listed."]
    #[doc = " @param options A dictionary filled with protocol-private options. On return"]
    #[doc = "                this parameter will be destroyed and replaced with a dictionary"]
    #[doc = "                containing options that were not found. May be NULL."]
    #[doc = " @return >=0 on success or negative on error."]
    pub fn avio_open_dir(
        s: *mut *mut AVIODirContext,
        url: *const ::std::os::raw::c_char,
        options: *mut *mut AVDictionary,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get next directory entry."]
    #[doc = ""]
    #[doc = " Returned entry must be freed with avio_free_directory_entry(). In particular"]
    #[doc = " it may outlive AVIODirContext."]
    #[doc = ""]
    #[doc = " @param s         directory read context."]
    #[doc = " @param[out] next next entry or NULL when no more entries."]
    #[doc = " @return >=0 on success or negative on error. End of list is not considered an"]
    #[doc = "             error."]
    pub fn avio_read_dir(
        s: *mut AVIODirContext,
        next: *mut *mut AVIODirEntry,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Close directory."]
    #[doc = ""]
    #[doc = " @note Entries created using avio_read_dir() are not deleted and must be"]
    #[doc = " freeded with avio_free_directory_entry()."]
    #[doc = ""]
    #[doc = " @param s         directory read context."]
    #[doc = " @return >=0 on success or negative on error."]
    pub fn avio_close_dir(s: *mut *mut AVIODirContext) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Free entry allocated by avio_read_dir()."]
    #[doc = ""]
    #[doc = " @param entry entry to be freed."]
    pub fn avio_free_directory_entry(entry: *mut *mut AVIODirEntry);
}
extern "C" {
    #[doc = " Allocate and initialize an AVIOContext for buffered I/O. It must be later"]
    #[doc = " freed with avio_context_free()."]
    #[doc = ""]
    #[doc = " @param buffer Memory block for input/output operations via AVIOContext."]
    #[doc = "        The buffer must be allocated with av_malloc() and friends."]
    #[doc = "        It may be freed and replaced with a new buffer by libavformat."]
    #[doc = "        AVIOContext.buffer holds the buffer currently in use,"]
    #[doc = "        which must be later freed with av_free()."]
    #[doc = " @param buffer_size The buffer size is very important for performance."]
    #[doc = "        For protocols with fixed blocksize it should be set to this blocksize."]
    #[doc = "        For others a typical size is a cache page, e.g. 4kb."]
    #[doc = " @param write_flag Set to 1 if the buffer should be writable, 0 otherwise."]
    #[doc = " @param opaque An opaque pointer to user-specific data."]
    #[doc = " @param read_packet  A function for refilling the buffer, may be NULL."]
    #[doc = "                     For stream protocols, must never return 0 but rather"]
    #[doc = "                     a proper AVERROR code."]
    #[doc = " @param write_packet A function for writing the buffer contents, may be NULL."]
    #[doc = "        The function may not change the input buffers content."]
    #[doc = " @param seek A function for seeking to specified byte position, may be NULL."]
    #[doc = ""]
    #[doc = " @return Allocated AVIOContext or NULL on failure."]
    pub fn avio_alloc_context(
        buffer: *mut ::std::os::raw::c_uchar,
        buffer_size: ::std::os::raw::c_int,
        write_flag: ::std::os::raw::c_int,
        opaque: *mut ::std::os::raw::c_void,
        read_packet: ::std::option::Option<
            unsafe extern "C" fn(
                opaque: *mut ::std::os::raw::c_void,
                buf: *mut u8,
                buf_size: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int,
        >,
        write_packet: ::std::option::Option<
            unsafe extern "C" fn(
                opaque: *mut ::std::os::raw::c_void,
                buf: *mut u8,
                buf_size: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int,
        >,
        seek: ::std::option::Option<
            unsafe extern "C" fn(
                opaque: *mut ::std::os::raw::c_void,
                offset: i64,
                whence: ::std::os::raw::c_int,
            ) -> i64,
        >,
    ) -> *mut AVIOContext;
}
extern "C" {
    #[doc = " Free the supplied IO context and everything associated with it."]
    #[doc = ""]
    #[doc = " @param s Double pointer to the IO context. This function will write NULL"]
    #[doc = " into s."]
    pub fn avio_context_free(s: *mut *mut AVIOContext);
}
extern "C" {
    pub fn avio_w8(s: *mut AVIOContext, b: ::std::os::raw::c_int);
}
extern "C" {
    pub fn avio_write(
        s: *mut AVIOContext,
        buf: *const ::std::os::raw::c_uchar,
        size: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn avio_wl64(s: *mut AVIOContext, val: u64);
}
extern "C" {
    pub fn avio_wb64(s: *mut AVIOContext, val: u64);
}
extern "C" {
    pub fn avio_wl32(s: *mut AVIOContext, val: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn avio_wb32(s: *mut AVIOContext, val: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn avio_wl24(s: *mut AVIOContext, val: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn avio_wb24(s: *mut AVIOContext, val: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn avio_wl16(s: *mut AVIOContext, val: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn avio_wb16(s: *mut AVIOContext, val: ::std::os::raw::c_uint);
}
extern "C" {
    #[doc = " Write a NULL-terminated string."]
    #[doc = " @return number of bytes written."]
    pub fn avio_put_str(
        s: *mut AVIOContext,
        str_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Convert an UTF-8 string to UTF-16LE and write it."]
    #[doc = " @param s the AVIOContext"]
    #[doc = " @param str NULL-terminated UTF-8 string"]
    #[doc = ""]
    #[doc = " @return number of bytes written."]
    pub fn avio_put_str16le(
        s: *mut AVIOContext,
        str_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Convert an UTF-8 string to UTF-16BE and write it."]
    #[doc = " @param s the AVIOContext"]
    #[doc = " @param str NULL-terminated UTF-8 string"]
    #[doc = ""]
    #[doc = " @return number of bytes written."]
    pub fn avio_put_str16be(
        s: *mut AVIOContext,
        str_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Mark the written bytestream as a specific type."]
    #[doc = ""]
    #[doc = " Zero-length ranges are omitted from the output."]
    #[doc = ""]
    #[doc = " @param time the stream time the current bytestream pos corresponds to"]
    #[doc = "             (in AV_TIME_BASE units), or AV_NOPTS_VALUE if unknown or not"]
    #[doc = "             applicable"]
    #[doc = " @param type the kind of data written starting at the current pos"]
    pub fn avio_write_marker(s: *mut AVIOContext, time: i64, type_: AVIODataMarkerType);
}
extern "C" {
    #[doc = " fseek() equivalent for AVIOContext."]
    #[doc = " @return new position or AVERROR."]
    pub fn avio_seek(s: *mut AVIOContext, offset: i64, whence: ::std::os::raw::c_int) -> i64;
}
extern "C" {
    #[doc = " Skip given number of bytes forward"]
    #[doc = " @return new position or AVERROR."]
    pub fn avio_skip(s: *mut AVIOContext, offset: i64) -> i64;
}
extern "C" {
    #[doc = " Get the filesize."]
    #[doc = " @return filesize or AVERROR"]
    pub fn avio_size(s: *mut AVIOContext) -> i64;
}
extern "C" {
    #[doc = " Similar to feof() but also returns nonzero on read errors."]
    #[doc = " @return non zero if and only if at end of file or a read error happened when reading."]
    pub fn avio_feof(s: *mut AVIOContext) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Writes a formatted string to the context."]
    #[doc = " @return number of bytes written, < 0 on error."]
    pub fn avio_printf(
        s: *mut AVIOContext,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Write a NULL terminated array of strings to the context."]
    #[doc = " Usually you don't need to use this function directly but its macro wrapper,"]
    #[doc = " avio_print."]
    pub fn avio_print_string_array(
        s: *mut AVIOContext,
        strings: *mut *const ::std::os::raw::c_char,
    );
}
extern "C" {
    #[doc = " Force flushing of buffered data."]
    #[doc = ""]
    #[doc = " For write streams, force the buffered data to be immediately written to the output,"]
    #[doc = " without to wait to fill the internal buffer."]
    #[doc = ""]
    #[doc = " For read streams, discard all currently buffered data, and advance the"]
    #[doc = " reported file position to that of the underlying stream. This does not"]
    #[doc = " read new data, and does not perform any seeks."]
    pub fn avio_flush(s: *mut AVIOContext);
}
extern "C" {
    #[doc = " Read size bytes from AVIOContext into buf."]
    #[doc = " @return number of bytes read or AVERROR"]
    pub fn avio_read(
        s: *mut AVIOContext,
        buf: *mut ::std::os::raw::c_uchar,
        size: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Read size bytes from AVIOContext into buf. Unlike avio_read(), this is allowed"]
    #[doc = " to read fewer bytes than requested. The missing bytes can be read in the next"]
    #[doc = " call. This always tries to read at least 1 byte."]
    #[doc = " Useful to reduce latency in certain cases."]
    #[doc = " @return number of bytes read or AVERROR"]
    pub fn avio_read_partial(
        s: *mut AVIOContext,
        buf: *mut ::std::os::raw::c_uchar,
        size: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @name Functions for reading from AVIOContext"]
    #[doc = " @{"]
    #[doc = ""]
    #[doc = " @note return 0 if EOF, so you cannot use it if EOF handling is"]
    #[doc = "       necessary"]
    pub fn avio_r8(s: *mut AVIOContext) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn avio_rl16(s: *mut AVIOContext) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn avio_rl24(s: *mut AVIOContext) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn avio_rl32(s: *mut AVIOContext) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn avio_rl64(s: *mut AVIOContext) -> u64;
}
extern "C" {
    pub fn avio_rb16(s: *mut AVIOContext) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn avio_rb24(s: *mut AVIOContext) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn avio_rb32(s: *mut AVIOContext) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn avio_rb64(s: *mut AVIOContext) -> u64;
}
extern "C" {
    #[doc = " Read a string from pb into buf. The reading will terminate when either"]
    #[doc = " a NULL character was encountered, maxlen bytes have been read, or nothing"]
    #[doc = " more can be read from pb. The result is guaranteed to be NULL-terminated, it"]
    #[doc = " will be truncated if buf is too small."]
    #[doc = " Note that the string is not interpreted or validated in any way, it"]
    #[doc = " might get truncated in the middle of a sequence for multi-byte encodings."]
    #[doc = ""]
    #[doc = " @return number of bytes read (is always <= maxlen)."]
    #[doc = " If reading ends on EOF or error, the return value will be one more than"]
    #[doc = " bytes actually read."]
    pub fn avio_get_str(
        pb: *mut AVIOContext,
        maxlen: ::std::os::raw::c_int,
        buf: *mut ::std::os::raw::c_char,
        buflen: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Read a UTF-16 string from pb and convert it to UTF-8."]
    #[doc = " The reading will terminate when either a null or invalid character was"]
    #[doc = " encountered or maxlen bytes have been read."]
    #[doc = " @return number of bytes read (is always <= maxlen)"]
    pub fn avio_get_str16le(
        pb: *mut AVIOContext,
        maxlen: ::std::os::raw::c_int,
        buf: *mut ::std::os::raw::c_char,
        buflen: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn avio_get_str16be(
        pb: *mut AVIOContext,
        maxlen: ::std::os::raw::c_int,
        buf: *mut ::std::os::raw::c_char,
        buflen: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Create and initialize a AVIOContext for accessing the"]
    #[doc = " resource indicated by url."]
    #[doc = " @note When the resource indicated by url has been opened in"]
    #[doc = " read+write mode, the AVIOContext can be used only for writing."]
    #[doc = ""]
    #[doc = " @param s Used to return the pointer to the created AVIOContext."]
    #[doc = " In case of failure the pointed to value is set to NULL."]
    #[doc = " @param url resource to access"]
    #[doc = " @param flags flags which control how the resource indicated by url"]
    #[doc = " is to be opened"]
    #[doc = " @return >= 0 in case of success, a negative value corresponding to an"]
    #[doc = " AVERROR code in case of failure"]
    pub fn avio_open(
        s: *mut *mut AVIOContext,
        url: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Create and initialize a AVIOContext for accessing the"]
    #[doc = " resource indicated by url."]
    #[doc = " @note When the resource indicated by url has been opened in"]
    #[doc = " read+write mode, the AVIOContext can be used only for writing."]
    #[doc = ""]
    #[doc = " @param s Used to return the pointer to the created AVIOContext."]
    #[doc = " In case of failure the pointed to value is set to NULL."]
    #[doc = " @param url resource to access"]
    #[doc = " @param flags flags which control how the resource indicated by url"]
    #[doc = " is to be opened"]
    #[doc = " @param int_cb an interrupt callback to be used at the protocols level"]
    #[doc = " @param options  A dictionary filled with protocol-private options. On return"]
    #[doc = " this parameter will be destroyed and replaced with a dict containing options"]
    #[doc = " that were not found. May be NULL."]
    #[doc = " @return >= 0 in case of success, a negative value corresponding to an"]
    #[doc = " AVERROR code in case of failure"]
    pub fn avio_open2(
        s: *mut *mut AVIOContext,
        url: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
        int_cb: *const AVIOInterruptCB,
        options: *mut *mut AVDictionary,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Close the resource accessed by the AVIOContext s and free it."]
    #[doc = " This function can only be used if s was opened by avio_open()."]
    #[doc = ""]
    #[doc = " The internal buffer is automatically flushed before closing the"]
    #[doc = " resource."]
    #[doc = ""]
    #[doc = " @return 0 on success, an AVERROR < 0 on error."]
    #[doc = " @see avio_closep"]
    pub fn avio_close(s: *mut AVIOContext) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Close the resource accessed by the AVIOContext *s, free it"]
    #[doc = " and set the pointer pointing to it to NULL."]
    #[doc = " This function can only be used if s was opened by avio_open()."]
    #[doc = ""]
    #[doc = " The internal buffer is automatically flushed before closing the"]
    #[doc = " resource."]
    #[doc = ""]
    #[doc = " @return 0 on success, an AVERROR < 0 on error."]
    #[doc = " @see avio_close"]
    pub fn avio_closep(s: *mut *mut AVIOContext) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Open a write only memory stream."]
    #[doc = ""]
    #[doc = " @param s new IO context"]
    #[doc = " @return zero if no error."]
    pub fn avio_open_dyn_buf(s: *mut *mut AVIOContext) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Return the written size and a pointer to the buffer."]
    #[doc = " The AVIOContext stream is left intact."]
    #[doc = " The buffer must NOT be freed."]
    #[doc = " No padding is added to the buffer."]
    #[doc = ""]
    #[doc = " @param s IO context"]
    #[doc = " @param pbuffer pointer to a byte buffer"]
    #[doc = " @return the length of the byte buffer"]
    pub fn avio_get_dyn_buf(s: *mut AVIOContext, pbuffer: *mut *mut u8) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Return the written size and a pointer to the buffer. The buffer"]
    #[doc = " must be freed with av_free()."]
    #[doc = " Padding of AV_INPUT_BUFFER_PADDING_SIZE is added to the buffer."]
    #[doc = ""]
    #[doc = " @param s IO context"]
    #[doc = " @param pbuffer pointer to a byte buffer"]
    #[doc = " @return the length of the byte buffer"]
    pub fn avio_close_dyn_buf(s: *mut AVIOContext, pbuffer: *mut *mut u8) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Iterate through names of available protocols."]
    #[doc = ""]
    #[doc = " @param opaque A private pointer representing current protocol."]
    #[doc = "        It must be a pointer to NULL on first iteration and will"]
    #[doc = "        be updated by successive calls to avio_enum_protocols."]
    #[doc = " @param output If set to 1, iterate over output protocols,"]
    #[doc = "               otherwise over input protocols."]
    #[doc = ""]
    #[doc = " @return A static string containing the name of current protocol or NULL"]
    pub fn avio_enum_protocols(
        opaque: *mut *mut ::std::os::raw::c_void,
        output: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get AVClass by names of available protocols."]
    #[doc = ""]
    #[doc = " @return A AVClass of input protocol name or NULL"]
    pub fn avio_protocol_get_class(name: *const ::std::os::raw::c_char) -> *const AVClass;
}
extern "C" {
    #[doc = " Pause and resume playing - only meaningful if using a network streaming"]
    #[doc = " protocol (e.g. MMS)."]
    #[doc = ""]
    #[doc = " @param h     IO context from which to call the read_pause function pointer"]
    #[doc = " @param pause 1 for pause, 0 for resume"]
    pub fn avio_pause(h: *mut AVIOContext, pause: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Seek to a given timestamp relative to some component stream."]
    #[doc = " Only meaningful if using a network streaming protocol (e.g. MMS.)."]
    #[doc = ""]
    #[doc = " @param h IO context from which to call the seek function pointers"]
    #[doc = " @param stream_index The stream index that the timestamp is relative to."]
    #[doc = "        If stream_index is (-1) the timestamp should be in AV_TIME_BASE"]
    #[doc = "        units from the beginning of the presentation."]
    #[doc = "        If a stream_index >= 0 is used and the protocol does not support"]
    #[doc = "        seeking based on component streams, the call will fail."]
    #[doc = " @param timestamp timestamp in AVStream.time_base units"]
    #[doc = "        or if there is no stream specified then in AV_TIME_BASE units."]
    #[doc = " @param flags Optional combination of AVSEEK_FLAG_BACKWARD, AVSEEK_FLAG_BYTE"]
    #[doc = "        and AVSEEK_FLAG_ANY. The protocol may silently ignore"]
    #[doc = "        AVSEEK_FLAG_BACKWARD and AVSEEK_FLAG_ANY, but AVSEEK_FLAG_BYTE will"]
    #[doc = "        fail if used and not supported."]
    #[doc = " @return >= 0 on success"]
    #[doc = " @see AVInputFormat::read_seek"]
    pub fn avio_seek_time(
        h: *mut AVIOContext,
        stream_index: ::std::os::raw::c_int,
        timestamp: i64,
        flags: ::std::os::raw::c_int,
    ) -> i64;
}
extern "C" {
    #[doc = " Read contents of h into print buffer, up to max_size bytes, or up to EOF."]
    #[doc = ""]
    #[doc = " @return 0 for success (max_size bytes read or EOF reached), negative error"]
    #[doc = " code otherwise"]
    pub fn avio_read_to_bprint(
        h: *mut AVIOContext,
        pb: *mut AVBPrint,
        max_size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Accept and allocate a client context on a server context."]
    #[doc = " @param  s the server context"]
    #[doc = " @param  c the client context, must be unallocated"]
    #[doc = " @return   >= 0 on success or a negative value corresponding"]
    #[doc = "           to an AVERROR on failure"]
    pub fn avio_accept(s: *mut AVIOContext, c: *mut *mut AVIOContext) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Perform one step of the protocol handshake to accept a new client."]
    #[doc = " This function must be called on a client returned by avio_accept() before"]
    #[doc = " using it as a read/write context."]
    #[doc = " It is separate from avio_accept() because it may block."]
    #[doc = " A step of the handshake is defined by places where the application may"]
    #[doc = " decide to change the proceedings."]
    #[doc = " For example, on a protocol with a request header and a reply header, each"]
    #[doc = " one can constitute a step because the application may use the parameters"]
    #[doc = " from the request to change parameters in the reply; or each individual"]
    #[doc = " chunk of the request can constitute a step."]
    #[doc = " If the handshake is already finished, avio_handshake() does nothing and"]
    #[doc = " returns 0 immediately."]
    #[doc = ""]
    #[doc = " @param  c the client context to perform the handshake on"]
    #[doc = " @return   0   on a complete and successful handshake"]
    #[doc = "           > 0 if the handshake progressed, but is not complete"]
    #[doc = "           < 0 for an AVERROR code"]
    pub fn avio_handshake(c: *mut AVIOContext) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Allocate and read the payload of a packet and initialize its"]
    #[doc = " fields with default values."]
    #[doc = ""]
    #[doc = " @param s    associated IO context"]
    #[doc = " @param pkt packet"]
    #[doc = " @param size desired payload size"]
    #[doc = " @return >0 (read size) if OK, AVERROR_xxx otherwise"]
    pub fn av_get_packet(
        s: *mut AVIOContext,
        pkt: *mut AVPacket,
        size: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Read data and append it to the current content of the AVPacket."]
    #[doc = " If pkt->size is 0 this is identical to av_get_packet."]
    #[doc = " Note that this uses av_grow_packet and thus involves a realloc"]
    #[doc = " which is inefficient. Thus this function should only be used"]
    #[doc = " when there is no reasonable way to know (an upper bound of)"]
    #[doc = " the final size."]
    #[doc = ""]
    #[doc = " @param s    associated IO context"]
    #[doc = " @param pkt packet"]
    #[doc = " @param size amount of data to read"]
    #[doc = " @return >0 (read size) if OK, AVERROR_xxx otherwise, previous data"]
    #[doc = "         will not be lost even if an error occurs."]
    pub fn av_append_packet(
        s: *mut AVIOContext,
        pkt: *mut AVPacket,
        size: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVCodecTag {
    _unused: [u8; 0],
}
#[doc = " This structure contains the data a format has to probe a file."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVProbeData {
    pub filename: *const ::std::os::raw::c_char,
    #[doc = "< Buffer must have AVPROBE_PADDING_SIZE of extra allocated bytes filled with zero."]
    pub buf: *mut ::std::os::raw::c_uchar,
    #[doc = "< Size of buf except extra allocated bytes"]
    pub buf_size: ::std::os::raw::c_int,
    #[doc = "< mime_type, when known."]
    pub mime_type: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_AVProbeData() {
    assert_eq!(
        ::std::mem::size_of::<AVProbeData>(),
        32usize,
        concat!("Size of: ", stringify!(AVProbeData))
    );
    assert_eq!(
        ::std::mem::align_of::<AVProbeData>(),
        8usize,
        concat!("Alignment of ", stringify!(AVProbeData))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVProbeData>())).filename as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVProbeData),
            "::",
            stringify!(filename)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVProbeData>())).buf as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVProbeData),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVProbeData>())).buf_size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVProbeData),
            "::",
            stringify!(buf_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVProbeData>())).mime_type as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVProbeData),
            "::",
            stringify!(mime_type)
        )
    );
}
#[doc = " @addtogroup lavf_encoding"]
#[doc = " @{"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVOutputFormat {
    pub name: *const ::std::os::raw::c_char,
    #[doc = " Descriptive name for the format, meant to be more human-readable"]
    #[doc = " than name. You should use the NULL_IF_CONFIG_SMALL() macro"]
    #[doc = " to define it."]
    pub long_name: *const ::std::os::raw::c_char,
    pub mime_type: *const ::std::os::raw::c_char,
    #[doc = "< comma-separated filename extensions"]
    pub extensions: *const ::std::os::raw::c_char,
    #[doc = "< default audio codec"]
    pub audio_codec: AVCodecID,
    #[doc = "< default video codec"]
    pub video_codec: AVCodecID,
    #[doc = "< default subtitle codec"]
    pub subtitle_codec: AVCodecID,
    #[doc = " can use flags: AVFMT_NOFILE, AVFMT_NEEDNUMBER,"]
    #[doc = " AVFMT_GLOBALHEADER, AVFMT_NOTIMESTAMPS, AVFMT_VARIABLE_FPS,"]
    #[doc = " AVFMT_NODIMENSIONS, AVFMT_NOSTREAMS, AVFMT_ALLOW_FLUSH,"]
    #[doc = " AVFMT_TS_NONSTRICT, AVFMT_TS_NEGATIVE"]
    pub flags: ::std::os::raw::c_int,
    #[doc = " List of supported codec_id-codec_tag pairs, ordered by \"better"]
    #[doc = " choice first\". The arrays are all terminated by AV_CODEC_ID_NONE."]
    pub codec_tag: *const *const AVCodecTag,
    #[doc = "< AVClass for the private context"]
    pub priv_class: *const AVClass,
    #[doc = " No fields below this line are part of the public API. They"]
    #[doc = " may not be used outside of libavformat and can be changed and"]
    #[doc = " removed at will."]
    #[doc = " New public fields should be added right above."]
    #[doc = ""]
    #[doc = " size of private data so that it can be allocated in the wrapper"]
    pub priv_data_size: ::std::os::raw::c_int,
    pub write_header: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut AVFormatContext) -> ::std::os::raw::c_int,
    >,
    #[doc = " Write a packet. If AVFMT_ALLOW_FLUSH is set in flags,"]
    #[doc = " pkt can be NULL in order to flush data buffered in the muxer."]
    #[doc = " When flushing, return 0 if there still is more data to flush,"]
    #[doc = " or 1 if everything was flushed and there is no more buffered"]
    #[doc = " data."]
    pub write_packet: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut AVFormatContext,
            pkt: *mut AVPacket,
        ) -> ::std::os::raw::c_int,
    >,
    pub write_trailer: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut AVFormatContext) -> ::std::os::raw::c_int,
    >,
    #[doc = " A format-specific function for interleavement."]
    #[doc = " If unset, packets will be interleaved by dts."]
    pub interleave_packet: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut AVFormatContext,
            out: *mut AVPacket,
            in_: *mut AVPacket,
            flush: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " Test if the given codec can be stored in this container."]
    #[doc = ""]
    #[doc = " @return 1 if the codec is supported, 0 if it is not."]
    #[doc = "         A negative number if unknown."]
    #[doc = "         MKTAG('A', 'P', 'I', 'C') if the codec is only supported as AV_DISPOSITION_ATTACHED_PIC"]
    pub query_codec: ::std::option::Option<
        unsafe extern "C" fn(
            id: AVCodecID,
            std_compliance: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub get_output_timestamp: ::std::option::Option<
        unsafe extern "C" fn(
            s: *mut AVFormatContext,
            stream: ::std::os::raw::c_int,
            dts: *mut i64,
            wall: *mut i64,
        ),
    >,
    #[doc = " Allows sending messages from application to device."]
    pub control_message: ::std::option::Option<
        unsafe extern "C" fn(
            s: *mut AVFormatContext,
            type_: ::std::os::raw::c_int,
            data: *mut ::std::os::raw::c_void,
            data_size: size_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " Write an uncoded AVFrame."]
    #[doc = ""]
    #[doc = " See av_write_uncoded_frame() for details."]
    #[doc = ""]
    #[doc = " The library will free *frame afterwards, but the muxer can prevent it"]
    #[doc = " by setting the pointer to NULL."]
    pub write_uncoded_frame: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut AVFormatContext,
            stream_index: ::std::os::raw::c_int,
            frame: *mut *mut AVFrame,
            flags: ::std::os::raw::c_uint,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " Returns device list with it properties."]
    #[doc = " @see avdevice_list_devices() for more details."]
    pub get_device_list: ::std::option::Option<
        unsafe extern "C" fn(
            s: *mut AVFormatContext,
            device_list: *mut AVDeviceInfoList,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "< default data codec"]
    pub data_codec: AVCodecID,
    #[doc = " Initialize format. May allocate data here, and set any AVFormatContext or"]
    #[doc = " AVStream parameters that need to be set before packets are sent."]
    #[doc = " This method must not write output."]
    #[doc = ""]
    #[doc = " Return 0 if streams were fully configured, 1 if not, negative AVERROR on failure"]
    #[doc = ""]
    #[doc = " Any allocations made here must be freed in deinit()."]
    pub init: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut AVFormatContext) -> ::std::os::raw::c_int,
    >,
    #[doc = " Deinitialize format. If present, this is called whenever the muxer is being"]
    #[doc = " destroyed, regardless of whether or not the header has been written."]
    #[doc = ""]
    #[doc = " If a trailer is being written, this is called after write_trailer()."]
    #[doc = ""]
    #[doc = " This is called if init() fails as well."]
    pub deinit: ::std::option::Option<unsafe extern "C" fn(arg1: *mut AVFormatContext)>,
    #[doc = " Set up any necessary bitstream filtering and extract any extra data needed"]
    #[doc = " for the global header."]
    #[doc = " Return 0 if more packets from this stream must be checked; 1 if not."]
    pub check_bitstream: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut AVFormatContext,
            pkt: *const AVPacket,
        ) -> ::std::os::raw::c_int,
    >,
}
#[test]
fn bindgen_test_layout_AVOutputFormat() {
    assert_eq!(
        ::std::mem::size_of::<AVOutputFormat>(),
        176usize,
        concat!("Size of: ", stringify!(AVOutputFormat))
    );
    assert_eq!(
        ::std::mem::align_of::<AVOutputFormat>(),
        8usize,
        concat!("Alignment of ", stringify!(AVOutputFormat))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOutputFormat>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOutputFormat>())).long_name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(long_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOutputFormat>())).mime_type as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(mime_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOutputFormat>())).extensions as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(extensions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOutputFormat>())).audio_codec as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(audio_codec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOutputFormat>())).video_codec as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(video_codec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOutputFormat>())).subtitle_codec as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(subtitle_codec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOutputFormat>())).flags as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOutputFormat>())).codec_tag as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(codec_tag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOutputFormat>())).priv_class as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(priv_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOutputFormat>())).priv_data_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(priv_data_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOutputFormat>())).write_header as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(write_header)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOutputFormat>())).write_packet as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(write_packet)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOutputFormat>())).write_trailer as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(write_trailer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVOutputFormat>())).interleave_packet as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(interleave_packet)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOutputFormat>())).query_codec as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(query_codec)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVOutputFormat>())).get_output_timestamp as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(get_output_timestamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOutputFormat>())).control_message as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(control_message)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVOutputFormat>())).write_uncoded_frame as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(write_uncoded_frame)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOutputFormat>())).get_device_list as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(get_device_list)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOutputFormat>())).data_codec as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(data_codec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOutputFormat>())).init as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOutputFormat>())).deinit as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(deinit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVOutputFormat>())).check_bitstream as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(AVOutputFormat),
            "::",
            stringify!(check_bitstream)
        )
    );
}
#[doc = " @addtogroup lavf_decoding"]
#[doc = " @{"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVInputFormat {
    #[doc = " A comma separated list of short names for the format. New names"]
    #[doc = " may be appended with a minor bump."]
    pub name: *const ::std::os::raw::c_char,
    #[doc = " Descriptive name for the format, meant to be more human-readable"]
    #[doc = " than name. You should use the NULL_IF_CONFIG_SMALL() macro"]
    #[doc = " to define it."]
    pub long_name: *const ::std::os::raw::c_char,
    #[doc = " Can use flags: AVFMT_NOFILE, AVFMT_NEEDNUMBER, AVFMT_SHOW_IDS,"]
    #[doc = " AVFMT_NOTIMESTAMPS, AVFMT_GENERIC_INDEX, AVFMT_TS_DISCONT, AVFMT_NOBINSEARCH,"]
    #[doc = " AVFMT_NOGENSEARCH, AVFMT_NO_BYTE_SEEK, AVFMT_SEEK_TO_PTS."]
    pub flags: ::std::os::raw::c_int,
    #[doc = " If extensions are defined, then no probe is done. You should"]
    #[doc = " usually not use extension format guessing because it is not"]
    #[doc = " reliable enough"]
    pub extensions: *const ::std::os::raw::c_char,
    pub codec_tag: *const *const AVCodecTag,
    #[doc = "< AVClass for the private context"]
    pub priv_class: *const AVClass,
    #[doc = " Comma-separated list of mime types."]
    #[doc = " It is used check for matching mime types while probing."]
    #[doc = " @see av_probe_input_format2"]
    pub mime_type: *const ::std::os::raw::c_char,
    #[doc = " No fields below this line are part of the public API. They"]
    #[doc = " may not be used outside of libavformat and can be changed and"]
    #[doc = " removed at will."]
    #[doc = " New public fields should be added right above."]
    #[doc = ""]
    #[doc = " Raw demuxers store their codec ID here."]
    pub raw_codec_id: ::std::os::raw::c_int,
    #[doc = " Size of private data so that it can be allocated in the wrapper."]
    pub priv_data_size: ::std::os::raw::c_int,
    #[doc = " Tell if a given file has a chance of being parsed as this format."]
    #[doc = " The buffer provided is guaranteed to be AVPROBE_PADDING_SIZE bytes"]
    #[doc = " big so you do not have to check for that unless you need more."]
    pub read_probe: ::std::option::Option<
        unsafe extern "C" fn(arg1: *const AVProbeData) -> ::std::os::raw::c_int,
    >,
    #[doc = " Read the format header and initialize the AVFormatContext"]
    #[doc = " structure. Return 0 if OK. 'avformat_new_stream' should be"]
    #[doc = " called to create new streams."]
    pub read_header: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut AVFormatContext) -> ::std::os::raw::c_int,
    >,
    #[doc = " Read one packet and put it in 'pkt'. pts and flags are also"]
    #[doc = " set. 'avformat_new_stream' can be called only if the flag"]
    #[doc = " AVFMTCTX_NOHEADER is used and only in the calling thread (not in a"]
    #[doc = " background thread)."]
    #[doc = " @return 0 on success, < 0 on error."]
    #[doc = "         Upon returning an error, pkt must be unreferenced by the caller."]
    pub read_packet: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut AVFormatContext,
            pkt: *mut AVPacket,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " Close the stream. The AVFormatContext and AVStreams are not"]
    #[doc = " freed by this function"]
    pub read_close: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut AVFormatContext) -> ::std::os::raw::c_int,
    >,
    #[doc = " Seek to a given timestamp relative to the frames in"]
    #[doc = " stream component stream_index."]
    #[doc = " @param stream_index Must not be -1."]
    #[doc = " @param flags Selects which direction should be preferred if no exact"]
    #[doc = "              match is available."]
    #[doc = " @return >= 0 on success (but not necessarily the new offset)"]
    pub read_seek: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut AVFormatContext,
            stream_index: ::std::os::raw::c_int,
            timestamp: i64,
            flags: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " Get the next timestamp in stream[stream_index].time_base units."]
    #[doc = " @return the timestamp or AV_NOPTS_VALUE if an error occurred"]
    pub read_timestamp: ::std::option::Option<
        unsafe extern "C" fn(
            s: *mut AVFormatContext,
            stream_index: ::std::os::raw::c_int,
            pos: *mut i64,
            pos_limit: i64,
        ) -> i64,
    >,
    #[doc = " Start/resume playing - only meaningful if using a network-based format"]
    #[doc = " (RTSP)."]
    pub read_play: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut AVFormatContext) -> ::std::os::raw::c_int,
    >,
    #[doc = " Pause playing - only meaningful if using a network-based format"]
    #[doc = " (RTSP)."]
    pub read_pause: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut AVFormatContext) -> ::std::os::raw::c_int,
    >,
    #[doc = " Seek to timestamp ts."]
    #[doc = " Seeking will be done so that the point from which all active streams"]
    #[doc = " can be presented successfully will be closest to ts and within min/max_ts."]
    #[doc = " Active streams are all streams that have AVStream.discard < AVDISCARD_ALL."]
    pub read_seek2: ::std::option::Option<
        unsafe extern "C" fn(
            s: *mut AVFormatContext,
            stream_index: ::std::os::raw::c_int,
            min_ts: i64,
            ts: i64,
            max_ts: i64,
            flags: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " Returns device list with it properties."]
    #[doc = " @see avdevice_list_devices() for more details."]
    pub get_device_list: ::std::option::Option<
        unsafe extern "C" fn(
            s: *mut AVFormatContext,
            device_list: *mut AVDeviceInfoList,
        ) -> ::std::os::raw::c_int,
    >,
}
#[test]
fn bindgen_test_layout_AVInputFormat() {
    assert_eq!(
        ::std::mem::size_of::<AVInputFormat>(),
        144usize,
        concat!("Size of: ", stringify!(AVInputFormat))
    );
    assert_eq!(
        ::std::mem::align_of::<AVInputFormat>(),
        8usize,
        concat!("Alignment of ", stringify!(AVInputFormat))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVInputFormat>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVInputFormat),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVInputFormat>())).long_name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVInputFormat),
            "::",
            stringify!(long_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVInputFormat>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVInputFormat),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVInputFormat>())).extensions as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVInputFormat),
            "::",
            stringify!(extensions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVInputFormat>())).codec_tag as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVInputFormat),
            "::",
            stringify!(codec_tag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVInputFormat>())).priv_class as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVInputFormat),
            "::",
            stringify!(priv_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVInputFormat>())).mime_type as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(AVInputFormat),
            "::",
            stringify!(mime_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVInputFormat>())).raw_codec_id as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(AVInputFormat),
            "::",
            stringify!(raw_codec_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVInputFormat>())).priv_data_size as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(AVInputFormat),
            "::",
            stringify!(priv_data_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVInputFormat>())).read_probe as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(AVInputFormat),
            "::",
            stringify!(read_probe)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVInputFormat>())).read_header as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(AVInputFormat),
            "::",
            stringify!(read_header)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVInputFormat>())).read_packet as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(AVInputFormat),
            "::",
            stringify!(read_packet)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVInputFormat>())).read_close as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(AVInputFormat),
            "::",
            stringify!(read_close)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVInputFormat>())).read_seek as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(AVInputFormat),
            "::",
            stringify!(read_seek)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVInputFormat>())).read_timestamp as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(AVInputFormat),
            "::",
            stringify!(read_timestamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVInputFormat>())).read_play as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(AVInputFormat),
            "::",
            stringify!(read_play)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVInputFormat>())).read_pause as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(AVInputFormat),
            "::",
            stringify!(read_pause)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVInputFormat>())).read_seek2 as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(AVInputFormat),
            "::",
            stringify!(read_seek2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVInputFormat>())).get_device_list as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(AVInputFormat),
            "::",
            stringify!(get_device_list)
        )
    );
}
pub const AVStreamParseType_AVSTREAM_PARSE_NONE: AVStreamParseType = 0;
#[doc = "< full parsing and repack"]
pub const AVStreamParseType_AVSTREAM_PARSE_FULL: AVStreamParseType = 1;
#[doc = "< Only parse headers, do not repack."]
pub const AVStreamParseType_AVSTREAM_PARSE_HEADERS: AVStreamParseType = 2;
#[doc = "< full parsing and interpolation of timestamps for frames not starting on a packet boundary"]
pub const AVStreamParseType_AVSTREAM_PARSE_TIMESTAMPS: AVStreamParseType = 3;
#[doc = "< full parsing and repack of the first frame only, only implemented for H.264 currently"]
pub const AVStreamParseType_AVSTREAM_PARSE_FULL_ONCE: AVStreamParseType = 4;
#[doc = "< full parsing and repack with timestamp and position generation by parser for raw"]
#[doc = "this assumes that each packet in the file contains no demuxer level headers and"]
#[doc = "just codec level data, otherwise position generation would fail"]
pub const AVStreamParseType_AVSTREAM_PARSE_FULL_RAW: AVStreamParseType = 5;
#[doc = " @}"]
pub type AVStreamParseType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVIndexEntry {
    pub pos: i64,
    #[doc = "<"]
    #[doc = " Timestamp in AVStream.time_base units, preferably the time from which on correctly decoded frames are available"]
    #[doc = " when seeking to this entry. That means preferable PTS on keyframe based formats."]
    #[doc = " But demuxers can choose to store a different timestamp, if it is more convenient for the implementation or nothing better"]
    #[doc = " is known"]
    pub timestamp: i64,
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    #[doc = "< Minimum distance between this and the previous keyframe, used to avoid unneeded searching."]
    pub min_distance: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_AVIndexEntry() {
    assert_eq!(
        ::std::mem::size_of::<AVIndexEntry>(),
        24usize,
        concat!("Size of: ", stringify!(AVIndexEntry))
    );
    assert_eq!(
        ::std::mem::align_of::<AVIndexEntry>(),
        8usize,
        concat!("Alignment of ", stringify!(AVIndexEntry))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIndexEntry>())).pos as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIndexEntry),
            "::",
            stringify!(pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIndexEntry>())).timestamp as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIndexEntry),
            "::",
            stringify!(timestamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVIndexEntry>())).min_distance as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(AVIndexEntry),
            "::",
            stringify!(min_distance)
        )
    );
}
impl AVIndexEntry {
    #[inline]
    pub fn flags(&self) -> ::std::os::raw::c_int {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_flags(&mut self, val: ::std::os::raw::c_int) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn size(&self) -> ::std::os::raw::c_int {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set_size(&mut self, val: ::std::os::raw::c_int) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        flags: ::std::os::raw::c_int,
        size: ::std::os::raw::c_int,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let flags: u32 = unsafe { ::std::mem::transmute(flags) };
            flags as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let size: u32 = unsafe { ::std::mem::transmute(size) };
            size as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVStreamInternal {
    _unused: [u8; 0],
}
#[doc = " Stream structure."]
#[doc = " New fields can be added to the end with minor version bumps."]
#[doc = " Removal, reordering and changes to existing fields require a major"]
#[doc = " version bump."]
#[doc = " sizeof(AVStream) must not be used outside libav*."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVStream {
    #[doc = "< stream index in AVFormatContext"]
    pub index: ::std::os::raw::c_int,
    #[doc = " Format-specific stream ID."]
    #[doc = " decoding: set by libavformat"]
    #[doc = " encoding: set by the user, replaced by libavformat if left unset"]
    pub id: ::std::os::raw::c_int,
    pub priv_data: *mut ::std::os::raw::c_void,
    #[doc = " This is the fundamental unit of time (in seconds) in terms"]
    #[doc = " of which frame timestamps are represented."]
    #[doc = ""]
    #[doc = " decoding: set by libavformat"]
    #[doc = " encoding: May be set by the caller before avformat_write_header() to"]
    #[doc = "           provide a hint to the muxer about the desired timebase. In"]
    #[doc = "           avformat_write_header(), the muxer will overwrite this field"]
    #[doc = "           with the timebase that will actually be used for the timestamps"]
    #[doc = "           written into the file (which may or may not be related to the"]
    #[doc = "           user-provided one, depending on the format)."]
    pub time_base: AVRational,
    #[doc = " Decoding: pts of the first frame of the stream in presentation order, in stream time base."]
    #[doc = " Only set this if you are absolutely 100% sure that the value you set"]
    #[doc = " it to really is the pts of the first frame."]
    #[doc = " This may be undefined (AV_NOPTS_VALUE)."]
    #[doc = " @note The ASF header does NOT contain a correct start_time the ASF"]
    #[doc = " demuxer must NOT set this."]
    pub start_time: i64,
    #[doc = " Decoding: duration of the stream, in stream time base."]
    #[doc = " If a source file does not specify a duration, but does specify"]
    #[doc = " a bitrate, this value will be estimated from bitrate and file size."]
    #[doc = ""]
    #[doc = " Encoding: May be set by the caller before avformat_write_header() to"]
    #[doc = " provide a hint to the muxer about the estimated duration."]
    pub duration: i64,
    #[doc = "< number of frames in this stream if known or 0"]
    pub nb_frames: i64,
    #[doc = "< AV_DISPOSITION_* bit field"]
    pub disposition: ::std::os::raw::c_int,
    #[doc = "< Selects which packets can be discarded at will and do not need to be demuxed."]
    pub discard: AVDiscard,
    #[doc = " sample aspect ratio (0 if unknown)"]
    #[doc = " - encoding: Set by user."]
    #[doc = " - decoding: Set by libavformat."]
    pub sample_aspect_ratio: AVRational,
    pub metadata: *mut AVDictionary,
    #[doc = " Average framerate"]
    #[doc = ""]
    #[doc = " - demuxing: May be set by libavformat when creating the stream or in"]
    #[doc = "             avformat_find_stream_info()."]
    #[doc = " - muxing: May be set by the caller before avformat_write_header()."]
    pub avg_frame_rate: AVRational,
    #[doc = " For streams with AV_DISPOSITION_ATTACHED_PIC disposition, this packet"]
    #[doc = " will contain the attached picture."]
    #[doc = ""]
    #[doc = " decoding: set by libavformat, must not be modified by the caller."]
    #[doc = " encoding: unused"]
    pub attached_pic: AVPacket,
    #[doc = " An array of side data that applies to the whole stream (i.e. the"]
    #[doc = " container does not allow it to change between packets)."]
    #[doc = ""]
    #[doc = " There may be no overlap between the side data in this array and side data"]
    #[doc = " in the packets. I.e. a given side data is either exported by the muxer"]
    #[doc = " (demuxing) / set by the caller (muxing) in this array, then it never"]
    #[doc = " appears in the packets, or the side data is exported / sent through"]
    #[doc = " the packets (always in the first packet where the value becomes known or"]
    #[doc = " changes), then it does not appear in this array."]
    #[doc = ""]
    #[doc = " - demuxing: Set by libavformat when the stream is created."]
    #[doc = " - muxing: May be set by the caller before avformat_write_header()."]
    #[doc = ""]
    #[doc = " Freed by libavformat in avformat_free_context()."]
    #[doc = ""]
    #[doc = " @see av_format_inject_global_side_data()"]
    pub side_data: *mut AVPacketSideData,
    #[doc = " The number of elements in the AVStream.side_data array."]
    pub nb_side_data: ::std::os::raw::c_int,
    #[doc = " Flags indicating events happening on the stream, a combination of"]
    #[doc = " AVSTREAM_EVENT_FLAG_*."]
    #[doc = ""]
    #[doc = " - demuxing: may be set by the demuxer in avformat_open_input(),"]
    #[doc = "   avformat_find_stream_info() and av_read_frame(). Flags must be cleared"]
    #[doc = "   by the user once the event has been handled."]
    #[doc = " - muxing: may be set by the user after avformat_write_header(). to"]
    #[doc = "   indicate a user-triggered event.  The muxer will clear the flags for"]
    #[doc = "   events it has handled in av_[interleaved]_write_frame()."]
    pub event_flags: ::std::os::raw::c_int,
    #[doc = " Real base framerate of the stream."]
    #[doc = " This is the lowest framerate with which all timestamps can be"]
    #[doc = " represented accurately (it is the least common multiple of all"]
    #[doc = " framerates in the stream). Note, this value is just a guess!"]
    #[doc = " For example, if the time base is 1/90000 and all frames have either"]
    #[doc = " approximately 3600 or 1800 timer ticks, then r_frame_rate will be 50/1."]
    pub r_frame_rate: AVRational,
    #[doc = " Codec parameters associated with this stream. Allocated and freed by"]
    #[doc = " libavformat in avformat_new_stream() and avformat_free_context()"]
    #[doc = " respectively."]
    #[doc = ""]
    #[doc = " - demuxing: filled by libavformat on stream creation or in"]
    #[doc = "             avformat_find_stream_info()"]
    #[doc = " - muxing: filled by the caller before avformat_write_header()"]
    pub codecpar: *mut AVCodecParameters,
    #[doc = "< number of bits in pts (used for wrapping control)"]
    pub pts_wrap_bits: ::std::os::raw::c_int,
    #[doc = " Timestamp corresponding to the last dts sync point."]
    #[doc = ""]
    #[doc = " Initialized when AVCodecParserContext.dts_sync_point >= 0 and"]
    #[doc = " a DTS is received from the underlying container. Otherwise set to"]
    #[doc = " AV_NOPTS_VALUE by default."]
    pub first_dts: i64,
    pub cur_dts: i64,
    #[doc = " An opaque field for libavformat internal usage."]
    #[doc = " Must not be accessed in any way by callers."]
    pub internal: *mut AVStreamInternal,
}
#[test]
fn bindgen_test_layout_AVStream() {
    assert_eq!(
        ::std::mem::size_of::<AVStream>(),
        224usize,
        concat!("Size of: ", stringify!(AVStream))
    );
    assert_eq!(
        ::std::mem::align_of::<AVStream>(),
        8usize,
        concat!("Alignment of ", stringify!(AVStream))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVStream>())).index as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVStream),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVStream>())).id as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(AVStream),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVStream>())).priv_data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVStream),
            "::",
            stringify!(priv_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVStream>())).time_base as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVStream),
            "::",
            stringify!(time_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVStream>())).start_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVStream),
            "::",
            stringify!(start_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVStream>())).duration as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVStream),
            "::",
            stringify!(duration)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVStream>())).nb_frames as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVStream),
            "::",
            stringify!(nb_frames)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVStream>())).disposition as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(AVStream),
            "::",
            stringify!(disposition)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVStream>())).discard as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(AVStream),
            "::",
            stringify!(discard)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVStream>())).sample_aspect_ratio as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(AVStream),
            "::",
            stringify!(sample_aspect_ratio)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVStream>())).metadata as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(AVStream),
            "::",
            stringify!(metadata)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVStream>())).avg_frame_rate as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(AVStream),
            "::",
            stringify!(avg_frame_rate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVStream>())).attached_pic as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(AVStream),
            "::",
            stringify!(attached_pic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVStream>())).side_data as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(AVStream),
            "::",
            stringify!(side_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVStream>())).nb_side_data as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(AVStream),
            "::",
            stringify!(nb_side_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVStream>())).event_flags as *const _ as usize },
        172usize,
        concat!(
            "Offset of field: ",
            stringify!(AVStream),
            "::",
            stringify!(event_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVStream>())).r_frame_rate as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(AVStream),
            "::",
            stringify!(r_frame_rate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVStream>())).codecpar as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(AVStream),
            "::",
            stringify!(codecpar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVStream>())).pts_wrap_bits as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(AVStream),
            "::",
            stringify!(pts_wrap_bits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVStream>())).first_dts as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(AVStream),
            "::",
            stringify!(first_dts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVStream>())).cur_dts as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(AVStream),
            "::",
            stringify!(cur_dts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVStream>())).internal as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(AVStream),
            "::",
            stringify!(internal)
        )
    );
}
extern "C" {
    pub fn av_stream_get_parser(s: *const AVStream) -> *mut AVCodecParserContext;
}
extern "C" {
    #[doc = " Returns the pts of the last muxed packet + its duration"]
    #[doc = ""]
    #[doc = " the retuned value is undefined when used with a demuxer."]
    pub fn av_stream_get_end_pts(st: *const AVStream) -> i64;
}
#[doc = " New fields can be added to the end with minor version bumps."]
#[doc = " Removal, reordering and changes to existing fields require a major"]
#[doc = " version bump."]
#[doc = " sizeof(AVProgram) must not be used outside libav*."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVProgram {
    pub id: ::std::os::raw::c_int,
    pub flags: ::std::os::raw::c_int,
    #[doc = "< selects which program to discard and which to feed to the caller"]
    pub discard: AVDiscard,
    pub stream_index: *mut ::std::os::raw::c_uint,
    pub nb_stream_indexes: ::std::os::raw::c_uint,
    pub metadata: *mut AVDictionary,
    pub program_num: ::std::os::raw::c_int,
    pub pmt_pid: ::std::os::raw::c_int,
    pub pcr_pid: ::std::os::raw::c_int,
    pub pmt_version: ::std::os::raw::c_int,
    #[doc = " All fields below this line are not part of the public API. They"]
    #[doc = " may not be used outside of libavformat and can be changed and"]
    #[doc = " removed at will."]
    #[doc = " New public fields should be added right above."]
    #[doc = ""]
    pub start_time: i64,
    pub end_time: i64,
    #[doc = "< reference dts for wrap detection"]
    pub pts_wrap_reference: i64,
    #[doc = "< behavior on wrap detection"]
    pub pts_wrap_behavior: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_AVProgram() {
    assert_eq!(
        ::std::mem::size_of::<AVProgram>(),
        88usize,
        concat!("Size of: ", stringify!(AVProgram))
    );
    assert_eq!(
        ::std::mem::align_of::<AVProgram>(),
        8usize,
        concat!("Alignment of ", stringify!(AVProgram))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVProgram>())).id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVProgram),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVProgram>())).flags as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(AVProgram),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVProgram>())).discard as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVProgram),
            "::",
            stringify!(discard)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVProgram>())).stream_index as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVProgram),
            "::",
            stringify!(stream_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVProgram>())).nb_stream_indexes as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVProgram),
            "::",
            stringify!(nb_stream_indexes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVProgram>())).metadata as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVProgram),
            "::",
            stringify!(metadata)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVProgram>())).program_num as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVProgram),
            "::",
            stringify!(program_num)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVProgram>())).pmt_pid as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(AVProgram),
            "::",
            stringify!(pmt_pid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVProgram>())).pcr_pid as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(AVProgram),
            "::",
            stringify!(pcr_pid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVProgram>())).pmt_version as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(AVProgram),
            "::",
            stringify!(pmt_version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVProgram>())).start_time as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(AVProgram),
            "::",
            stringify!(start_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVProgram>())).end_time as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(AVProgram),
            "::",
            stringify!(end_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVProgram>())).pts_wrap_reference as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(AVProgram),
            "::",
            stringify!(pts_wrap_reference)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVProgram>())).pts_wrap_behavior as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(AVProgram),
            "::",
            stringify!(pts_wrap_behavior)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVChapter {
    #[doc = "< unique ID to identify the chapter"]
    pub id: i64,
    #[doc = "< time base in which the start/end timestamps are specified"]
    pub time_base: AVRational,
    #[doc = "< chapter start/end time in time_base units"]
    pub start: i64,
    #[doc = "< chapter start/end time in time_base units"]
    pub end: i64,
    pub metadata: *mut AVDictionary,
}
#[test]
fn bindgen_test_layout_AVChapter() {
    assert_eq!(
        ::std::mem::size_of::<AVChapter>(),
        40usize,
        concat!("Size of: ", stringify!(AVChapter))
    );
    assert_eq!(
        ::std::mem::align_of::<AVChapter>(),
        8usize,
        concat!("Alignment of ", stringify!(AVChapter))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVChapter>())).id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVChapter),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVChapter>())).time_base as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVChapter),
            "::",
            stringify!(time_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVChapter>())).start as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVChapter),
            "::",
            stringify!(start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVChapter>())).end as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVChapter),
            "::",
            stringify!(end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVChapter>())).metadata as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVChapter),
            "::",
            stringify!(metadata)
        )
    );
}
#[doc = " Callback used by devices to communicate with application."]
pub type av_format_control_message = ::std::option::Option<
    unsafe extern "C" fn(
        s: *mut AVFormatContext,
        type_: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
        data_size: size_t,
    ) -> ::std::os::raw::c_int,
>;
pub type AVOpenCallback = ::std::option::Option<
    unsafe extern "C" fn(
        s: *mut AVFormatContext,
        pb: *mut *mut AVIOContext,
        url: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
        int_cb: *const AVIOInterruptCB,
        options: *mut *mut AVDictionary,
    ) -> ::std::os::raw::c_int,
>;
#[doc = "< Duration accurately estimated from PTSes"]
pub const AVDurationEstimationMethod_AVFMT_DURATION_FROM_PTS: AVDurationEstimationMethod = 0;
#[doc = "< Duration estimated from a stream with a known duration"]
pub const AVDurationEstimationMethod_AVFMT_DURATION_FROM_STREAM: AVDurationEstimationMethod = 1;
#[doc = "< Duration estimated from bitrate (less accurate)"]
pub const AVDurationEstimationMethod_AVFMT_DURATION_FROM_BITRATE: AVDurationEstimationMethod = 2;
#[doc = " The duration of a video can be estimated through various ways, and this enum can be used"]
#[doc = " to know how the duration was estimated."]
pub type AVDurationEstimationMethod = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVFormatInternal {
    _unused: [u8; 0],
}
#[doc = " Format I/O context."]
#[doc = " New fields can be added to the end with minor version bumps."]
#[doc = " Removal, reordering and changes to existing fields require a major"]
#[doc = " version bump."]
#[doc = " sizeof(AVFormatContext) must not be used outside libav*, use"]
#[doc = " avformat_alloc_context() to create an AVFormatContext."]
#[doc = ""]
#[doc = " Fields can be accessed through AVOptions (av_opt*),"]
#[doc = " the name string used matches the associated command line parameter name and"]
#[doc = " can be found in libavformat/options_table.h."]
#[doc = " The AVOption/command line parameter names differ in some cases from the C"]
#[doc = " structure field names for historic reasons or brevity."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVFormatContext {
    #[doc = " A class for logging and @ref avoptions. Set by avformat_alloc_context()."]
    #[doc = " Exports (de)muxer private options if they exist."]
    pub av_class: *const AVClass,
    #[doc = " The input container format."]
    #[doc = ""]
    #[doc = " Demuxing only, set by avformat_open_input()."]
    pub iformat: *const AVInputFormat,
    #[doc = " The output container format."]
    #[doc = ""]
    #[doc = " Muxing only, must be set by the caller before avformat_write_header()."]
    pub oformat: *const AVOutputFormat,
    #[doc = " Format private data. This is an AVOptions-enabled struct"]
    #[doc = " if and only if iformat/oformat.priv_class is not NULL."]
    #[doc = ""]
    #[doc = " - muxing: set by avformat_write_header()"]
    #[doc = " - demuxing: set by avformat_open_input()"]
    pub priv_data: *mut ::std::os::raw::c_void,
    #[doc = " I/O context."]
    #[doc = ""]
    #[doc = " - demuxing: either set by the user before avformat_open_input() (then"]
    #[doc = "             the user must close it manually) or set by avformat_open_input()."]
    #[doc = " - muxing: set by the user before avformat_write_header(). The caller must"]
    #[doc = "           take care of closing / freeing the IO context."]
    #[doc = ""]
    #[doc = " Do NOT set this field if AVFMT_NOFILE flag is set in"]
    #[doc = " iformat/oformat.flags. In such a case, the (de)muxer will handle"]
    #[doc = " I/O in some other way and this field will be NULL."]
    pub pb: *mut AVIOContext,
    #[doc = " Flags signalling stream properties. A combination of AVFMTCTX_*."]
    #[doc = " Set by libavformat."]
    pub ctx_flags: ::std::os::raw::c_int,
    #[doc = " Number of elements in AVFormatContext.streams."]
    #[doc = ""]
    #[doc = " Set by avformat_new_stream(), must not be modified by any other code."]
    pub nb_streams: ::std::os::raw::c_uint,
    #[doc = " A list of all streams in the file. New streams are created with"]
    #[doc = " avformat_new_stream()."]
    #[doc = ""]
    #[doc = " - demuxing: streams are created by libavformat in avformat_open_input()."]
    #[doc = "             If AVFMTCTX_NOHEADER is set in ctx_flags, then new streams may also"]
    #[doc = "             appear in av_read_frame()."]
    #[doc = " - muxing: streams are created by the user before avformat_write_header()."]
    #[doc = ""]
    #[doc = " Freed by libavformat in avformat_free_context()."]
    pub streams: *mut *mut AVStream,
    #[doc = " input or output URL. Unlike the old filename field, this field has no"]
    #[doc = " length restriction."]
    #[doc = ""]
    #[doc = " - demuxing: set by avformat_open_input(), initialized to an empty"]
    #[doc = "             string if url parameter was NULL in avformat_open_input()."]
    #[doc = " - muxing: may be set by the caller before calling avformat_write_header()"]
    #[doc = "           (or avformat_init_output() if that is called first) to a string"]
    #[doc = "           which is freeable by av_free(). Set to an empty string if it"]
    #[doc = "           was NULL in avformat_init_output()."]
    #[doc = ""]
    #[doc = " Freed by libavformat in avformat_free_context()."]
    pub url: *mut ::std::os::raw::c_char,
    #[doc = " Position of the first frame of the component, in"]
    #[doc = " AV_TIME_BASE fractional seconds. NEVER set this value directly:"]
    #[doc = " It is deduced from the AVStream values."]
    #[doc = ""]
    #[doc = " Demuxing only, set by libavformat."]
    pub start_time: i64,
    #[doc = " Duration of the stream, in AV_TIME_BASE fractional"]
    #[doc = " seconds. Only set this value if you know none of the individual stream"]
    #[doc = " durations and also do not set any of them. This is deduced from the"]
    #[doc = " AVStream values if not set."]
    #[doc = ""]
    #[doc = " Demuxing only, set by libavformat."]
    pub duration: i64,
    #[doc = " Total stream bitrate in bit/s, 0 if not"]
    #[doc = " available. Never set it directly if the file_size and the"]
    #[doc = " duration are known as FFmpeg can compute it automatically."]
    pub bit_rate: i64,
    pub packet_size: ::std::os::raw::c_uint,
    pub max_delay: ::std::os::raw::c_int,
    #[doc = " Flags modifying the (de)muxer behaviour. A combination of AVFMT_FLAG_*."]
    #[doc = " Set by the user before avformat_open_input() / avformat_write_header()."]
    pub flags: ::std::os::raw::c_int,
    #[doc = " Maximum size of the data read from input for determining"]
    #[doc = " the input container format."]
    #[doc = " Demuxing only, set by the caller before avformat_open_input()."]
    pub probesize: i64,
    #[doc = " Maximum duration (in AV_TIME_BASE units) of the data read"]
    #[doc = " from input in avformat_find_stream_info()."]
    #[doc = " Demuxing only, set by the caller before avformat_find_stream_info()."]
    #[doc = " Can be set to 0 to let avformat choose using a heuristic."]
    pub max_analyze_duration: i64,
    pub key: *const u8,
    pub keylen: ::std::os::raw::c_int,
    pub nb_programs: ::std::os::raw::c_uint,
    pub programs: *mut *mut AVProgram,
    #[doc = " Forced video codec_id."]
    #[doc = " Demuxing: Set by user."]
    pub video_codec_id: AVCodecID,
    #[doc = " Forced audio codec_id."]
    #[doc = " Demuxing: Set by user."]
    pub audio_codec_id: AVCodecID,
    #[doc = " Forced subtitle codec_id."]
    #[doc = " Demuxing: Set by user."]
    pub subtitle_codec_id: AVCodecID,
    #[doc = " Maximum amount of memory in bytes to use for the index of each stream."]
    #[doc = " If the index exceeds this size, entries will be discarded as"]
    #[doc = " needed to maintain a smaller size. This can lead to slower or less"]
    #[doc = " accurate seeking (depends on demuxer)."]
    #[doc = " Demuxers for which a full in-memory index is mandatory will ignore"]
    #[doc = " this."]
    #[doc = " - muxing: unused"]
    #[doc = " - demuxing: set by user"]
    pub max_index_size: ::std::os::raw::c_uint,
    #[doc = " Maximum amount of memory in bytes to use for buffering frames"]
    #[doc = " obtained from realtime capture devices."]
    pub max_picture_buffer: ::std::os::raw::c_uint,
    #[doc = " Number of chapters in AVChapter array."]
    #[doc = " When muxing, chapters are normally written in the file header,"]
    #[doc = " so nb_chapters should normally be initialized before write_header"]
    #[doc = " is called. Some muxers (e.g. mov and mkv) can also write chapters"]
    #[doc = " in the trailer.  To write chapters in the trailer, nb_chapters"]
    #[doc = " must be zero when write_header is called and non-zero when"]
    #[doc = " write_trailer is called."]
    #[doc = " - muxing: set by user"]
    #[doc = " - demuxing: set by libavformat"]
    pub nb_chapters: ::std::os::raw::c_uint,
    pub chapters: *mut *mut AVChapter,
    #[doc = " Metadata that applies to the whole file."]
    #[doc = ""]
    #[doc = " - demuxing: set by libavformat in avformat_open_input()"]
    #[doc = " - muxing: may be set by the caller before avformat_write_header()"]
    #[doc = ""]
    #[doc = " Freed by libavformat in avformat_free_context()."]
    pub metadata: *mut AVDictionary,
    #[doc = " Start time of the stream in real world time, in microseconds"]
    #[doc = " since the Unix epoch (00:00 1st January 1970). That is, pts=0 in the"]
    #[doc = " stream was captured at this real world time."]
    #[doc = " - muxing: Set by the caller before avformat_write_header(). If set to"]
    #[doc = "           either 0 or AV_NOPTS_VALUE, then the current wall-time will"]
    #[doc = "           be used."]
    #[doc = " - demuxing: Set by libavformat. AV_NOPTS_VALUE if unknown. Note that"]
    #[doc = "             the value may become known after some number of frames"]
    #[doc = "             have been received."]
    pub start_time_realtime: i64,
    #[doc = " The number of frames used for determining the framerate in"]
    #[doc = " avformat_find_stream_info()."]
    #[doc = " Demuxing only, set by the caller before avformat_find_stream_info()."]
    pub fps_probe_size: ::std::os::raw::c_int,
    #[doc = " Error recognition; higher values will detect more errors but may"]
    #[doc = " misdetect some more or less valid parts as errors."]
    #[doc = " Demuxing only, set by the caller before avformat_open_input()."]
    pub error_recognition: ::std::os::raw::c_int,
    #[doc = " Custom interrupt callbacks for the I/O layer."]
    #[doc = ""]
    #[doc = " demuxing: set by the user before avformat_open_input()."]
    #[doc = " muxing: set by the user before avformat_write_header()"]
    #[doc = " (mainly useful for AVFMT_NOFILE formats). The callback"]
    #[doc = " should also be passed to avio_open2() if it's used to"]
    #[doc = " open the file."]
    pub interrupt_callback: AVIOInterruptCB,
    #[doc = " Flags to enable debugging."]
    pub debug: ::std::os::raw::c_int,
    #[doc = " Maximum buffering duration for interleaving."]
    #[doc = ""]
    #[doc = " To ensure all the streams are interleaved correctly,"]
    #[doc = " av_interleaved_write_frame() will wait until it has at least one packet"]
    #[doc = " for each stream before actually writing any packets to the output file."]
    #[doc = " When some streams are \"sparse\" (i.e. there are large gaps between"]
    #[doc = " successive packets), this can result in excessive buffering."]
    #[doc = ""]
    #[doc = " This field specifies the maximum difference between the timestamps of the"]
    #[doc = " first and the last packet in the muxing queue, above which libavformat"]
    #[doc = " will output a packet regardless of whether it has queued a packet for all"]
    #[doc = " the streams."]
    #[doc = ""]
    #[doc = " Muxing only, set by the caller before avformat_write_header()."]
    pub max_interleave_delta: i64,
    #[doc = " Allow non-standard and experimental extension"]
    #[doc = " @see AVCodecContext.strict_std_compliance"]
    pub strict_std_compliance: ::std::os::raw::c_int,
    #[doc = " Flags indicating events happening on the file, a combination of"]
    #[doc = " AVFMT_EVENT_FLAG_*."]
    #[doc = ""]
    #[doc = " - demuxing: may be set by the demuxer in avformat_open_input(),"]
    #[doc = "   avformat_find_stream_info() and av_read_frame(). Flags must be cleared"]
    #[doc = "   by the user once the event has been handled."]
    #[doc = " - muxing: may be set by the user after avformat_write_header() to"]
    #[doc = "   indicate a user-triggered event.  The muxer will clear the flags for"]
    #[doc = "   events it has handled in av_[interleaved]_write_frame()."]
    pub event_flags: ::std::os::raw::c_int,
    #[doc = " Maximum number of packets to read while waiting for the first timestamp."]
    #[doc = " Decoding only."]
    pub max_ts_probe: ::std::os::raw::c_int,
    #[doc = " Avoid negative timestamps during muxing."]
    #[doc = " Any value of the AVFMT_AVOID_NEG_TS_* constants."]
    #[doc = " Note, this only works when using av_interleaved_write_frame. (interleave_packet_per_dts is in use)"]
    #[doc = " - muxing: Set by user"]
    #[doc = " - demuxing: unused"]
    pub avoid_negative_ts: ::std::os::raw::c_int,
    #[doc = " Transport stream id."]
    #[doc = " This will be moved into demuxer private options. Thus no API/ABI compatibility"]
    pub ts_id: ::std::os::raw::c_int,
    #[doc = " Audio preload in microseconds."]
    #[doc = " Note, not all formats support this and unpredictable things may happen if it is used when not supported."]
    #[doc = " - encoding: Set by user"]
    #[doc = " - decoding: unused"]
    pub audio_preload: ::std::os::raw::c_int,
    #[doc = " Max chunk time in microseconds."]
    #[doc = " Note, not all formats support this and unpredictable things may happen if it is used when not supported."]
    #[doc = " - encoding: Set by user"]
    #[doc = " - decoding: unused"]
    pub max_chunk_duration: ::std::os::raw::c_int,
    #[doc = " Max chunk size in bytes"]
    #[doc = " Note, not all formats support this and unpredictable things may happen if it is used when not supported."]
    #[doc = " - encoding: Set by user"]
    #[doc = " - decoding: unused"]
    pub max_chunk_size: ::std::os::raw::c_int,
    #[doc = " forces the use of wallclock timestamps as pts/dts of packets"]
    #[doc = " This has undefined results in the presence of B frames."]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Set by user"]
    pub use_wallclock_as_timestamps: ::std::os::raw::c_int,
    #[doc = " avio flags, used to force AVIO_FLAG_DIRECT."]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Set by user"]
    pub avio_flags: ::std::os::raw::c_int,
    #[doc = " The duration field can be estimated through various ways, and this field can be used"]
    #[doc = " to know how the duration was estimated."]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Read by user"]
    pub duration_estimation_method: AVDurationEstimationMethod,
    #[doc = " Skip initial bytes when opening stream"]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Set by user"]
    pub skip_initial_bytes: i64,
    #[doc = " Correct single timestamp overflows"]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Set by user"]
    pub correct_ts_overflow: ::std::os::raw::c_uint,
    #[doc = " Force seeking to any (also non key) frames."]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: Set by user"]
    pub seek2any: ::std::os::raw::c_int,
    #[doc = " Flush the I/O context after each packet."]
    #[doc = " - encoding: Set by user"]
    #[doc = " - decoding: unused"]
    pub flush_packets: ::std::os::raw::c_int,
    #[doc = " format probing score."]
    #[doc = " The maximal score is AVPROBE_SCORE_MAX, its set when the demuxer probes"]
    #[doc = " the format."]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: set by avformat, read by user"]
    pub probe_score: ::std::os::raw::c_int,
    #[doc = " number of bytes to read maximally to identify format."]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: set by user"]
    pub format_probesize: ::std::os::raw::c_int,
    #[doc = " ',' separated list of allowed decoders."]
    #[doc = " If NULL then all are allowed"]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: set by user"]
    pub codec_whitelist: *mut ::std::os::raw::c_char,
    #[doc = " ',' separated list of allowed demuxers."]
    #[doc = " If NULL then all are allowed"]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: set by user"]
    pub format_whitelist: *mut ::std::os::raw::c_char,
    #[doc = " An opaque field for libavformat internal usage."]
    #[doc = " Must not be accessed in any way by callers."]
    pub internal: *mut AVFormatInternal,
    #[doc = " IO repositioned flag."]
    #[doc = " This is set by avformat when the underlaying IO context read pointer"]
    #[doc = " is repositioned, for example when doing byte based seeking."]
    #[doc = " Demuxers can use the flag to detect such changes."]
    pub io_repositioned: ::std::os::raw::c_int,
    #[doc = " Forced video codec."]
    #[doc = " This allows forcing a specific decoder, even when there are multiple with"]
    #[doc = " the same codec_id."]
    #[doc = " Demuxing: Set by user"]
    pub video_codec: *const AVCodec,
    #[doc = " Forced audio codec."]
    #[doc = " This allows forcing a specific decoder, even when there are multiple with"]
    #[doc = " the same codec_id."]
    #[doc = " Demuxing: Set by user"]
    pub audio_codec: *const AVCodec,
    #[doc = " Forced subtitle codec."]
    #[doc = " This allows forcing a specific decoder, even when there are multiple with"]
    #[doc = " the same codec_id."]
    #[doc = " Demuxing: Set by user"]
    pub subtitle_codec: *const AVCodec,
    #[doc = " Forced data codec."]
    #[doc = " This allows forcing a specific decoder, even when there are multiple with"]
    #[doc = " the same codec_id."]
    #[doc = " Demuxing: Set by user"]
    pub data_codec: *const AVCodec,
    #[doc = " Number of bytes to be written as padding in a metadata header."]
    #[doc = " Demuxing: Unused."]
    #[doc = " Muxing: Set by user via av_format_set_metadata_header_padding."]
    pub metadata_header_padding: ::std::os::raw::c_int,
    #[doc = " User data."]
    #[doc = " This is a place for some private data of the user."]
    pub opaque: *mut ::std::os::raw::c_void,
    #[doc = " Callback used by devices to communicate with application."]
    pub control_message_cb: av_format_control_message,
    #[doc = " Output timestamp offset, in microseconds."]
    #[doc = " Muxing: set by user"]
    pub output_ts_offset: i64,
    #[doc = " dump format separator."]
    #[doc = " can be \", \" or \"\\n      \" or anything else"]
    #[doc = " - muxing: Set by user."]
    #[doc = " - demuxing: Set by user."]
    pub dump_separator: *mut u8,
    #[doc = " Forced Data codec_id."]
    #[doc = " Demuxing: Set by user."]
    pub data_codec_id: AVCodecID,
    #[doc = " ',' separated list of allowed protocols."]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: set by user"]
    pub protocol_whitelist: *mut ::std::os::raw::c_char,
    #[doc = " A callback for opening new IO streams."]
    #[doc = ""]
    #[doc = " Whenever a muxer or a demuxer needs to open an IO stream (typically from"]
    #[doc = " avformat_open_input() for demuxers, but for certain formats can happen at"]
    #[doc = " other times as well), it will call this callback to obtain an IO context."]
    #[doc = ""]
    #[doc = " @param s the format context"]
    #[doc = " @param pb on success, the newly opened IO context should be returned here"]
    #[doc = " @param url the url to open"]
    #[doc = " @param flags a combination of AVIO_FLAG_*"]
    #[doc = " @param options a dictionary of additional options, with the same"]
    #[doc = "                semantics as in avio_open2()"]
    #[doc = " @return 0 on success, a negative AVERROR code on failure"]
    #[doc = ""]
    #[doc = " @note Certain muxers and demuxers do nesting, i.e. they open one or more"]
    #[doc = " additional internal format contexts. Thus the AVFormatContext pointer"]
    #[doc = " passed to this callback may be different from the one facing the caller."]
    #[doc = " It will, however, have the same 'opaque' field."]
    pub io_open: ::std::option::Option<
        unsafe extern "C" fn(
            s: *mut AVFormatContext,
            pb: *mut *mut AVIOContext,
            url: *const ::std::os::raw::c_char,
            flags: ::std::os::raw::c_int,
            options: *mut *mut AVDictionary,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " A callback for closing the streams opened with AVFormatContext.io_open()."]
    pub io_close:
        ::std::option::Option<unsafe extern "C" fn(s: *mut AVFormatContext, pb: *mut AVIOContext)>,
    #[doc = " ',' separated list of disallowed protocols."]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: set by user"]
    pub protocol_blacklist: *mut ::std::os::raw::c_char,
    #[doc = " The maximum number of streams."]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: set by user"]
    pub max_streams: ::std::os::raw::c_int,
    #[doc = " Skip duration calcuation in estimate_timings_from_pts."]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: set by user"]
    pub skip_estimate_duration_from_pts: ::std::os::raw::c_int,
    #[doc = " Maximum number of packets that can be probed"]
    #[doc = " - encoding: unused"]
    #[doc = " - decoding: set by user"]
    pub max_probe_packets: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_AVFormatContext() {
    assert_eq!(
        ::std::mem::size_of::<AVFormatContext>(),
        472usize,
        concat!("Size of: ", stringify!(AVFormatContext))
    );
    assert_eq!(
        ::std::mem::align_of::<AVFormatContext>(),
        8usize,
        concat!("Alignment of ", stringify!(AVFormatContext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).av_class as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(av_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).iformat as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(iformat)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).oformat as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(oformat)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).priv_data as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(priv_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).pb as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(pb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).ctx_flags as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(ctx_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).nb_streams as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(nb_streams)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).streams as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(streams)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).url as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(url)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).start_time as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(start_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).duration as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(duration)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).bit_rate as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(bit_rate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).packet_size as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(packet_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).max_delay as *const _ as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(max_delay)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).flags as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).probesize as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(probesize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).max_analyze_duration as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(max_analyze_duration)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).key as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).keylen as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(keylen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).nb_programs as *const _ as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(nb_programs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).programs as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(programs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).video_codec_id as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(video_codec_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).audio_codec_id as *const _ as usize },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(audio_codec_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).subtitle_codec_id as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(subtitle_codec_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).max_index_size as *const _ as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(max_index_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).max_picture_buffer as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(max_picture_buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).nb_chapters as *const _ as usize },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(nb_chapters)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).chapters as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(chapters)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).metadata as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(metadata)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).start_time_realtime as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(start_time_realtime)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).fps_probe_size as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(fps_probe_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).error_recognition as *const _ as usize
        },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(error_recognition)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).interrupt_callback as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(interrupt_callback)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).debug as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(debug)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).max_interleave_delta as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(max_interleave_delta)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).strict_std_compliance as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(strict_std_compliance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).event_flags as *const _ as usize },
        236usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(event_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).max_ts_probe as *const _ as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(max_ts_probe)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).avoid_negative_ts as *const _ as usize
        },
        244usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(avoid_negative_ts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).ts_id as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(ts_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).audio_preload as *const _ as usize },
        252usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(audio_preload)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).max_chunk_duration as *const _ as usize
        },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(max_chunk_duration)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).max_chunk_size as *const _ as usize },
        260usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(max_chunk_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).use_wallclock_as_timestamps as *const _
                as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(use_wallclock_as_timestamps)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).avio_flags as *const _ as usize },
        268usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(avio_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).duration_estimation_method as *const _
                as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(duration_estimation_method)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).skip_initial_bytes as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(skip_initial_bytes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).correct_ts_overflow as *const _ as usize
        },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(correct_ts_overflow)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).seek2any as *const _ as usize },
        292usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(seek2any)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).flush_packets as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(flush_packets)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).probe_score as *const _ as usize },
        300usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(probe_score)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).format_probesize as *const _ as usize
        },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(format_probesize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).codec_whitelist as *const _ as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(codec_whitelist)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).format_whitelist as *const _ as usize
        },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(format_whitelist)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).internal as *const _ as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(internal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).io_repositioned as *const _ as usize },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(io_repositioned)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).video_codec as *const _ as usize },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(video_codec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).audio_codec as *const _ as usize },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(audio_codec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).subtitle_codec as *const _ as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(subtitle_codec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).data_codec as *const _ as usize },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(data_codec)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).metadata_header_padding as *const _ as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(metadata_header_padding)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).opaque as *const _ as usize },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(opaque)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).control_message_cb as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(control_message_cb)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).output_ts_offset as *const _ as usize
        },
        400usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(output_ts_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).dump_separator as *const _ as usize },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(dump_separator)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).data_codec_id as *const _ as usize },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(data_codec_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).protocol_whitelist as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(protocol_whitelist)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).io_open as *const _ as usize },
        432usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(io_open)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).io_close as *const _ as usize },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(io_close)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).protocol_blacklist as *const _ as usize
        },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(protocol_blacklist)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AVFormatContext>())).max_streams as *const _ as usize },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(max_streams)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).skip_estimate_duration_from_pts as *const _
                as usize
        },
        460usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(skip_estimate_duration_from_pts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AVFormatContext>())).max_probe_packets as *const _ as usize
        },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(AVFormatContext),
            "::",
            stringify!(max_probe_packets)
        )
    );
}
extern "C" {
    #[doc = " This function will cause global side data to be injected in the next packet"]
    #[doc = " of each stream as well as after any subsequent seek."]
    pub fn av_format_inject_global_side_data(s: *mut AVFormatContext);
}
extern "C" {
    #[doc = " Returns the method used to set ctx->duration."]
    #[doc = ""]
    #[doc = " @return AVFMT_DURATION_FROM_PTS, AVFMT_DURATION_FROM_STREAM, or AVFMT_DURATION_FROM_BITRATE."]
    pub fn av_fmt_ctx_get_duration_estimation_method(
        ctx: *const AVFormatContext,
    ) -> AVDurationEstimationMethod;
}
extern "C" {
    #[doc = " Return the LIBAVFORMAT_VERSION_INT constant."]
    pub fn avformat_version() -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Return the libavformat build-time configuration."]
    pub fn avformat_configuration() -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Return the libavformat license."]
    pub fn avformat_license() -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Do global initialization of network libraries. This is optional,"]
    #[doc = " and not recommended anymore."]
    #[doc = ""]
    #[doc = " This functions only exists to work around thread-safety issues"]
    #[doc = " with older GnuTLS or OpenSSL libraries. If libavformat is linked"]
    #[doc = " to newer versions of those libraries, or if you do not use them,"]
    #[doc = " calling this function is unnecessary. Otherwise, you need to call"]
    #[doc = " this function before any other threads using them are started."]
    #[doc = ""]
    #[doc = " This function will be deprecated once support for older GnuTLS and"]
    #[doc = " OpenSSL libraries is removed, and this function has no purpose"]
    #[doc = " anymore."]
    pub fn avformat_network_init() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Undo the initialization done by avformat_network_init. Call it only"]
    #[doc = " once for each time you called avformat_network_init."]
    pub fn avformat_network_deinit() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Iterate over all registered muxers."]
    #[doc = ""]
    #[doc = " @param opaque a pointer where libavformat will store the iteration state. Must"]
    #[doc = "               point to NULL to start the iteration."]
    #[doc = ""]
    #[doc = " @return the next registered muxer or NULL when the iteration is"]
    #[doc = "         finished"]
    pub fn av_muxer_iterate(opaque: *mut *mut ::std::os::raw::c_void) -> *const AVOutputFormat;
}
extern "C" {
    #[doc = " Iterate over all registered demuxers."]
    #[doc = ""]
    #[doc = " @param opaque a pointer where libavformat will store the iteration state. Must"]
    #[doc = "               point to NULL to start the iteration."]
    #[doc = ""]
    #[doc = " @return the next registered demuxer or NULL when the iteration is"]
    #[doc = "         finished"]
    pub fn av_demuxer_iterate(opaque: *mut *mut ::std::os::raw::c_void) -> *const AVInputFormat;
}
extern "C" {
    #[doc = " Allocate an AVFormatContext."]
    #[doc = " avformat_free_context() can be used to free the context and everything"]
    #[doc = " allocated by the framework within it."]
    pub fn avformat_alloc_context() -> *mut AVFormatContext;
}
extern "C" {
    #[doc = " Free an AVFormatContext and all its streams."]
    #[doc = " @param s context to free"]
    pub fn avformat_free_context(s: *mut AVFormatContext);
}
extern "C" {
    #[doc = " Get the AVClass for AVFormatContext. It can be used in combination with"]
    #[doc = " AV_OPT_SEARCH_FAKE_OBJ for examining options."]
    #[doc = ""]
    #[doc = " @see av_opt_find()."]
    pub fn avformat_get_class() -> *const AVClass;
}
extern "C" {
    #[doc = " Add a new stream to a media file."]
    #[doc = ""]
    #[doc = " When demuxing, it is called by the demuxer in read_header(). If the"]
    #[doc = " flag AVFMTCTX_NOHEADER is set in s.ctx_flags, then it may also"]
    #[doc = " be called in read_packet()."]
    #[doc = ""]
    #[doc = " When muxing, should be called by the user before avformat_write_header()."]
    #[doc = ""]
    #[doc = " User is required to call avformat_free_context() to clean up the allocation"]
    #[doc = " by avformat_new_stream()."]
    #[doc = ""]
    #[doc = " @param s media file handle"]
    #[doc = " @param c unused, does nothing"]
    #[doc = ""]
    #[doc = " @return newly created stream or NULL on error."]
    pub fn avformat_new_stream(s: *mut AVFormatContext, c: *const AVCodec) -> *mut AVStream;
}
extern "C" {
    #[doc = " Wrap an existing array as stream side data."]
    #[doc = ""]
    #[doc = " @param st stream"]
    #[doc = " @param type side information type"]
    #[doc = " @param data the side data array. It must be allocated with the av_malloc()"]
    #[doc = "             family of functions. The ownership of the data is transferred to"]
    #[doc = "             st."]
    #[doc = " @param size side information size"]
    #[doc = " @return zero on success, a negative AVERROR code on failure. On failure,"]
    #[doc = "         the stream is unchanged and the data remains owned by the caller."]
    pub fn av_stream_add_side_data(
        st: *mut AVStream,
        type_: AVPacketSideDataType,
        data: *mut u8,
        size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Allocate new information from stream."]
    #[doc = ""]
    #[doc = " @param stream stream"]
    #[doc = " @param type desired side information type"]
    #[doc = " @param size side information size"]
    #[doc = " @return pointer to fresh allocated data or NULL otherwise"]
    pub fn av_stream_new_side_data(
        stream: *mut AVStream,
        type_: AVPacketSideDataType,
        size: size_t,
    ) -> *mut u8;
}
extern "C" {
    #[doc = " Get side information from stream."]
    #[doc = ""]
    #[doc = " @param stream stream"]
    #[doc = " @param type desired side information type"]
    #[doc = " @param size If supplied, *size will be set to the size of the side data"]
    #[doc = "             or to zero if the desired side data is not present."]
    #[doc = " @return pointer to data if present or NULL otherwise"]
    pub fn av_stream_get_side_data(
        stream: *const AVStream,
        type_: AVPacketSideDataType,
        size: *mut size_t,
    ) -> *mut u8;
}
extern "C" {
    pub fn av_new_program(s: *mut AVFormatContext, id: ::std::os::raw::c_int) -> *mut AVProgram;
}
extern "C" {
    #[doc = " Allocate an AVFormatContext for an output format."]
    #[doc = " avformat_free_context() can be used to free the context and"]
    #[doc = " everything allocated by the framework within it."]
    #[doc = ""]
    #[doc = " @param *ctx is set to the created format context, or to NULL in"]
    #[doc = " case of failure"]
    #[doc = " @param oformat format to use for allocating the context, if NULL"]
    #[doc = " format_name and filename are used instead"]
    #[doc = " @param format_name the name of output format to use for allocating the"]
    #[doc = " context, if NULL filename is used instead"]
    #[doc = " @param filename the name of the filename to use for allocating the"]
    #[doc = " context, may be NULL"]
    #[doc = " @return >= 0 in case of success, a negative AVERROR code in case of"]
    #[doc = " failure"]
    pub fn avformat_alloc_output_context2(
        ctx: *mut *mut AVFormatContext,
        oformat: *const AVOutputFormat,
        format_name: *const ::std::os::raw::c_char,
        filename: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Find AVInputFormat based on the short name of the input format."]
    pub fn av_find_input_format(short_name: *const ::std::os::raw::c_char) -> *const AVInputFormat;
}
extern "C" {
    #[doc = " Guess the file format."]
    #[doc = ""]
    #[doc = " @param pd        data to be probed"]
    #[doc = " @param is_opened Whether the file is already opened; determines whether"]
    #[doc = "                  demuxers with or without AVFMT_NOFILE are probed."]
    pub fn av_probe_input_format(
        pd: *const AVProbeData,
        is_opened: ::std::os::raw::c_int,
    ) -> *const AVInputFormat;
}
extern "C" {
    #[doc = " Guess the file format."]
    #[doc = ""]
    #[doc = " @param pd        data to be probed"]
    #[doc = " @param is_opened Whether the file is already opened; determines whether"]
    #[doc = "                  demuxers with or without AVFMT_NOFILE are probed."]
    #[doc = " @param score_max A probe score larger that this is required to accept a"]
    #[doc = "                  detection, the variable is set to the actual detection"]
    #[doc = "                  score afterwards."]
    #[doc = "                  If the score is <= AVPROBE_SCORE_MAX / 4 it is recommended"]
    #[doc = "                  to retry with a larger probe buffer."]
    pub fn av_probe_input_format2(
        pd: *const AVProbeData,
        is_opened: ::std::os::raw::c_int,
        score_max: *mut ::std::os::raw::c_int,
    ) -> *const AVInputFormat;
}
extern "C" {
    #[doc = " Guess the file format."]
    #[doc = ""]
    #[doc = " @param is_opened Whether the file is already opened; determines whether"]
    #[doc = "                  demuxers with or without AVFMT_NOFILE are probed."]
    #[doc = " @param score_ret The score of the best detection."]
    pub fn av_probe_input_format3(
        pd: *const AVProbeData,
        is_opened: ::std::os::raw::c_int,
        score_ret: *mut ::std::os::raw::c_int,
    ) -> *const AVInputFormat;
}
extern "C" {
    #[doc = " Probe a bytestream to determine the input format. Each time a probe returns"]
    #[doc = " with a score that is too low, the probe buffer size is increased and another"]
    #[doc = " attempt is made. When the maximum probe size is reached, the input format"]
    #[doc = " with the highest score is returned."]
    #[doc = ""]
    #[doc = " @param pb the bytestream to probe"]
    #[doc = " @param fmt the input format is put here"]
    #[doc = " @param url the url of the stream"]
    #[doc = " @param logctx the log context"]
    #[doc = " @param offset the offset within the bytestream to probe from"]
    #[doc = " @param max_probe_size the maximum probe buffer size (zero for default)"]
    #[doc = " @return the score in case of success, a negative value corresponding to an"]
    #[doc = "         the maximal score is AVPROBE_SCORE_MAX"]
    #[doc = " AVERROR code otherwise"]
    pub fn av_probe_input_buffer2(
        pb: *mut AVIOContext,
        fmt: *mut *const AVInputFormat,
        url: *const ::std::os::raw::c_char,
        logctx: *mut ::std::os::raw::c_void,
        offset: ::std::os::raw::c_uint,
        max_probe_size: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Like av_probe_input_buffer2() but returns 0 on success"]
    pub fn av_probe_input_buffer(
        pb: *mut AVIOContext,
        fmt: *mut *const AVInputFormat,
        url: *const ::std::os::raw::c_char,
        logctx: *mut ::std::os::raw::c_void,
        offset: ::std::os::raw::c_uint,
        max_probe_size: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Open an input stream and read the header. The codecs are not opened."]
    #[doc = " The stream must be closed with avformat_close_input()."]
    #[doc = ""]
    #[doc = " @param ps Pointer to user-supplied AVFormatContext (allocated by avformat_alloc_context)."]
    #[doc = "           May be a pointer to NULL, in which case an AVFormatContext is allocated by this"]
    #[doc = "           function and written into ps."]
    #[doc = "           Note that a user-supplied AVFormatContext will be freed on failure."]
    #[doc = " @param url URL of the stream to open."]
    #[doc = " @param fmt If non-NULL, this parameter forces a specific input format."]
    #[doc = "            Otherwise the format is autodetected."]
    #[doc = " @param options  A dictionary filled with AVFormatContext and demuxer-private options."]
    #[doc = "                 On return this parameter will be destroyed and replaced with a dict containing"]
    #[doc = "                 options that were not found. May be NULL."]
    #[doc = ""]
    #[doc = " @return 0 on success, a negative AVERROR on failure."]
    #[doc = ""]
    #[doc = " @note If you want to use custom IO, preallocate the format context and set its pb field."]
    pub fn avformat_open_input(
        ps: *mut *mut AVFormatContext,
        url: *const ::std::os::raw::c_char,
        fmt: *const AVInputFormat,
        options: *mut *mut AVDictionary,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Read packets of a media file to get stream information. This"]
    #[doc = " is useful for file formats with no headers such as MPEG. This"]
    #[doc = " function also computes the real framerate in case of MPEG-2 repeat"]
    #[doc = " frame mode."]
    #[doc = " The logical file position is not changed by this function;"]
    #[doc = " examined packets may be buffered for later processing."]
    #[doc = ""]
    #[doc = " @param ic media file handle"]
    #[doc = " @param options  If non-NULL, an ic.nb_streams long array of pointers to"]
    #[doc = "                 dictionaries, where i-th member contains options for"]
    #[doc = "                 codec corresponding to i-th stream."]
    #[doc = "                 On return each dictionary will be filled with options that were not found."]
    #[doc = " @return >=0 if OK, AVERROR_xxx on error"]
    #[doc = ""]
    #[doc = " @note this function isn't guaranteed to open all the codecs, so"]
    #[doc = "       options being non-empty at return is a perfectly normal behavior."]
    #[doc = ""]
    #[doc = " @todo Let the user decide somehow what information is needed so that"]
    #[doc = "       we do not waste time getting stuff the user does not need."]
    pub fn avformat_find_stream_info(
        ic: *mut AVFormatContext,
        options: *mut *mut AVDictionary,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Find the programs which belong to a given stream."]
    #[doc = ""]
    #[doc = " @param ic    media file handle"]
    #[doc = " @param last  the last found program, the search will start after this"]
    #[doc = "              program, or from the beginning if it is NULL"]
    #[doc = " @param s     stream index"]
    #[doc = " @return the next program which belongs to s, NULL if no program is found or"]
    #[doc = "         the last program is not among the programs of ic."]
    pub fn av_find_program_from_stream(
        ic: *mut AVFormatContext,
        last: *mut AVProgram,
        s: ::std::os::raw::c_int,
    ) -> *mut AVProgram;
}
extern "C" {
    pub fn av_program_add_stream_index(
        ac: *mut AVFormatContext,
        progid: ::std::os::raw::c_int,
        idx: ::std::os::raw::c_uint,
    );
}
extern "C" {
    #[doc = " Find the \"best\" stream in the file."]
    #[doc = " The best stream is determined according to various heuristics as the most"]
    #[doc = " likely to be what the user expects."]
    #[doc = " If the decoder parameter is non-NULL, av_find_best_stream will find the"]
    #[doc = " default decoder for the stream's codec; streams for which no decoder can"]
    #[doc = " be found are ignored."]
    #[doc = ""]
    #[doc = " @param ic                media file handle"]
    #[doc = " @param type              stream type: video, audio, subtitles, etc."]
    #[doc = " @param wanted_stream_nb  user-requested stream number,"]
    #[doc = "                          or -1 for automatic selection"]
    #[doc = " @param related_stream    try to find a stream related (eg. in the same"]
    #[doc = "                          program) to this one, or -1 if none"]
    #[doc = " @param decoder_ret       if non-NULL, returns the decoder for the"]
    #[doc = "                          selected stream"]
    #[doc = " @param flags             flags; none are currently defined"]
    #[doc = " @return  the non-negative stream number in case of success,"]
    #[doc = "          AVERROR_STREAM_NOT_FOUND if no stream with the requested type"]
    #[doc = "          could be found,"]
    #[doc = "          AVERROR_DECODER_NOT_FOUND if streams were found but no decoder"]
    #[doc = " @note  If av_find_best_stream returns successfully and decoder_ret is not"]
    #[doc = "        NULL, then *decoder_ret is guaranteed to be set to a valid AVCodec."]
    pub fn av_find_best_stream(
        ic: *mut AVFormatContext,
        type_: AVMediaType,
        wanted_stream_nb: ::std::os::raw::c_int,
        related_stream: ::std::os::raw::c_int,
        decoder_ret: *mut *const AVCodec,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Return the next frame of a stream."]
    #[doc = " This function returns what is stored in the file, and does not validate"]
    #[doc = " that what is there are valid frames for the decoder. It will split what is"]
    #[doc = " stored in the file into frames and return one for each call. It will not"]
    #[doc = " omit invalid data between valid frames so as to give the decoder the maximum"]
    #[doc = " information possible for decoding."]
    #[doc = ""]
    #[doc = " On success, the returned packet is reference-counted (pkt->buf is set) and"]
    #[doc = " valid indefinitely. The packet must be freed with av_packet_unref() when"]
    #[doc = " it is no longer needed. For video, the packet contains exactly one frame."]
    #[doc = " For audio, it contains an integer number of frames if each frame has"]
    #[doc = " a known fixed size (e.g. PCM or ADPCM data). If the audio frames have"]
    #[doc = " a variable size (e.g. MPEG audio), then it contains one frame."]
    #[doc = ""]
    #[doc = " pkt->pts, pkt->dts and pkt->duration are always set to correct"]
    #[doc = " values in AVStream.time_base units (and guessed if the format cannot"]
    #[doc = " provide them). pkt->pts can be AV_NOPTS_VALUE if the video format"]
    #[doc = " has B-frames, so it is better to rely on pkt->dts if you do not"]
    #[doc = " decompress the payload."]
    #[doc = ""]
    #[doc = " @return 0 if OK, < 0 on error or end of file. On error, pkt will be blank"]
    #[doc = "         (as if it came from av_packet_alloc())."]
    #[doc = ""]
    #[doc = " @note pkt will be initialized, so it may be uninitialized, but it must not"]
    #[doc = "       contain data that needs to be freed."]
    pub fn av_read_frame(s: *mut AVFormatContext, pkt: *mut AVPacket) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Seek to the keyframe at timestamp."]
    #[doc = " 'timestamp' in 'stream_index'."]
    #[doc = ""]
    #[doc = " @param s media file handle"]
    #[doc = " @param stream_index If stream_index is (-1), a default"]
    #[doc = " stream is selected, and timestamp is automatically converted"]
    #[doc = " from AV_TIME_BASE units to the stream specific time_base."]
    #[doc = " @param timestamp Timestamp in AVStream.time_base units"]
    #[doc = "        or, if no stream is specified, in AV_TIME_BASE units."]
    #[doc = " @param flags flags which select direction and seeking mode"]
    #[doc = " @return >= 0 on success"]
    pub fn av_seek_frame(
        s: *mut AVFormatContext,
        stream_index: ::std::os::raw::c_int,
        timestamp: i64,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Seek to timestamp ts."]
    #[doc = " Seeking will be done so that the point from which all active streams"]
    #[doc = " can be presented successfully will be closest to ts and within min/max_ts."]
    #[doc = " Active streams are all streams that have AVStream.discard < AVDISCARD_ALL."]
    #[doc = ""]
    #[doc = " If flags contain AVSEEK_FLAG_BYTE, then all timestamps are in bytes and"]
    #[doc = " are the file position (this may not be supported by all demuxers)."]
    #[doc = " If flags contain AVSEEK_FLAG_FRAME, then all timestamps are in frames"]
    #[doc = " in the stream with stream_index (this may not be supported by all demuxers)."]
    #[doc = " Otherwise all timestamps are in units of the stream selected by stream_index"]
    #[doc = " or if stream_index is -1, in AV_TIME_BASE units."]
    #[doc = " If flags contain AVSEEK_FLAG_ANY, then non-keyframes are treated as"]
    #[doc = " keyframes (this may not be supported by all demuxers)."]
    #[doc = " If flags contain AVSEEK_FLAG_BACKWARD, it is ignored."]
    #[doc = ""]
    #[doc = " @param s media file handle"]
    #[doc = " @param stream_index index of the stream which is used as time base reference"]
    #[doc = " @param min_ts smallest acceptable timestamp"]
    #[doc = " @param ts target timestamp"]
    #[doc = " @param max_ts largest acceptable timestamp"]
    #[doc = " @param flags flags"]
    #[doc = " @return >=0 on success, error code otherwise"]
    #[doc = ""]
    #[doc = " @note This is part of the new seek API which is still under construction."]
    pub fn avformat_seek_file(
        s: *mut AVFormatContext,
        stream_index: ::std::os::raw::c_int,
        min_ts: i64,
        ts: i64,
        max_ts: i64,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Discard all internally buffered data. This can be useful when dealing with"]
    #[doc = " discontinuities in the byte stream. Generally works only with formats that"]
    #[doc = " can resync. This includes headerless formats like MPEG-TS/TS but should also"]
    #[doc = " work with NUT, Ogg and in a limited way AVI for example."]
    #[doc = ""]
    #[doc = " The set of streams, the detected duration, stream parameters and codecs do"]
    #[doc = " not change when calling this function. If you want a complete reset, it's"]
    #[doc = " better to open a new AVFormatContext."]
    #[doc = ""]
    #[doc = " This does not flush the AVIOContext (s->pb). If necessary, call"]
    #[doc = " avio_flush(s->pb) before calling this function."]
    #[doc = ""]
    #[doc = " @param s media file handle"]
    #[doc = " @return >=0 on success, error code otherwise"]
    pub fn avformat_flush(s: *mut AVFormatContext) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Start playing a network-based stream (e.g. RTSP stream) at the"]
    #[doc = " current position."]
    pub fn av_read_play(s: *mut AVFormatContext) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Pause a network-based stream (e.g. RTSP stream)."]
    #[doc = ""]
    #[doc = " Use av_read_play() to resume it."]
    pub fn av_read_pause(s: *mut AVFormatContext) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Close an opened input AVFormatContext. Free it and all its contents"]
    #[doc = " and set *s to NULL."]
    pub fn avformat_close_input(s: *mut *mut AVFormatContext);
}
extern "C" {
    #[doc = " Allocate the stream private data and write the stream header to"]
    #[doc = " an output media file."]
    #[doc = ""]
    #[doc = " @param s Media file handle, must be allocated with avformat_alloc_context()."]
    #[doc = "          Its oformat field must be set to the desired output format;"]
    #[doc = "          Its pb field must be set to an already opened AVIOContext."]
    #[doc = " @param options  An AVDictionary filled with AVFormatContext and muxer-private options."]
    #[doc = "                 On return this parameter will be destroyed and replaced with a dict containing"]
    #[doc = "                 options that were not found. May be NULL."]
    #[doc = ""]
    #[doc = " @return AVSTREAM_INIT_IN_WRITE_HEADER on success if the codec had not already been fully initialized in avformat_init,"]
    #[doc = "         AVSTREAM_INIT_IN_INIT_OUTPUT  on success if the codec had already been fully initialized in avformat_init,"]
    #[doc = "         negative AVERROR on failure."]
    #[doc = ""]
    #[doc = " @see av_opt_find, av_dict_set, avio_open, av_oformat_next, avformat_init_output."]
    pub fn avformat_write_header(
        s: *mut AVFormatContext,
        options: *mut *mut AVDictionary,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Allocate the stream private data and initialize the codec, but do not write the header."]
    #[doc = " May optionally be used before avformat_write_header to initialize stream parameters"]
    #[doc = " before actually writing the header."]
    #[doc = " If using this function, do not pass the same options to avformat_write_header."]
    #[doc = ""]
    #[doc = " @param s Media file handle, must be allocated with avformat_alloc_context()."]
    #[doc = "          Its oformat field must be set to the desired output format;"]
    #[doc = "          Its pb field must be set to an already opened AVIOContext."]
    #[doc = " @param options  An AVDictionary filled with AVFormatContext and muxer-private options."]
    #[doc = "                 On return this parameter will be destroyed and replaced with a dict containing"]
    #[doc = "                 options that were not found. May be NULL."]
    #[doc = ""]
    #[doc = " @return AVSTREAM_INIT_IN_WRITE_HEADER on success if the codec requires avformat_write_header to fully initialize,"]
    #[doc = "         AVSTREAM_INIT_IN_INIT_OUTPUT  on success if the codec has been fully initialized,"]
    #[doc = "         negative AVERROR on failure."]
    #[doc = ""]
    #[doc = " @see av_opt_find, av_dict_set, avio_open, av_oformat_next, avformat_write_header."]
    pub fn avformat_init_output(
        s: *mut AVFormatContext,
        options: *mut *mut AVDictionary,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Write a packet to an output media file."]
    #[doc = ""]
    #[doc = " This function passes the packet directly to the muxer, without any buffering"]
    #[doc = " or reordering. The caller is responsible for correctly interleaving the"]
    #[doc = " packets if the format requires it. Callers that want libavformat to handle"]
    #[doc = " the interleaving should call av_interleaved_write_frame() instead of this"]
    #[doc = " function."]
    #[doc = ""]
    #[doc = " @param s media file handle"]
    #[doc = " @param pkt The packet containing the data to be written. Note that unlike"]
    #[doc = "            av_interleaved_write_frame(), this function does not take"]
    #[doc = "            ownership of the packet passed to it (though some muxers may make"]
    #[doc = "            an internal reference to the input packet)."]
    #[doc = "            <br>"]
    #[doc = "            This parameter can be NULL (at any time, not just at the end), in"]
    #[doc = "            order to immediately flush data buffered within the muxer, for"]
    #[doc = "            muxers that buffer up data internally before writing it to the"]
    #[doc = "            output."]
    #[doc = "            <br>"]
    #[doc = "            Packet's @ref AVPacket.stream_index \"stream_index\" field must be"]
    #[doc = "            set to the index of the corresponding stream in @ref"]
    #[doc = "            AVFormatContext.streams \"s->streams\"."]
    #[doc = "            <br>"]
    #[doc = "            The timestamps (@ref AVPacket.pts \"pts\", @ref AVPacket.dts \"dts\")"]
    #[doc = "            must be set to correct values in the stream's timebase (unless the"]
    #[doc = "            output format is flagged with the AVFMT_NOTIMESTAMPS flag, then"]
    #[doc = "            they can be set to AV_NOPTS_VALUE)."]
    #[doc = "            The dts for subsequent packets passed to this function must be strictly"]
    #[doc = "            increasing when compared in their respective timebases (unless the"]
    #[doc = "            output format is flagged with the AVFMT_TS_NONSTRICT, then they"]
    #[doc = "            merely have to be nondecreasing).  @ref AVPacket.duration"]
    #[doc = "            \"duration\") should also be set if known."]
    #[doc = " @return < 0 on error, = 0 if OK, 1 if flushed and there is no more data to flush"]
    #[doc = ""]
    #[doc = " @see av_interleaved_write_frame()"]
    pub fn av_write_frame(s: *mut AVFormatContext, pkt: *mut AVPacket) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Write a packet to an output media file ensuring correct interleaving."]
    #[doc = ""]
    #[doc = " This function will buffer the packets internally as needed to make sure the"]
    #[doc = " packets in the output file are properly interleaved in the order of"]
    #[doc = " increasing dts. Callers doing their own interleaving should call"]
    #[doc = " av_write_frame() instead of this function."]
    #[doc = ""]
    #[doc = " Using this function instead of av_write_frame() can give muxers advance"]
    #[doc = " knowledge of future packets, improving e.g. the behaviour of the mp4"]
    #[doc = " muxer for VFR content in fragmenting mode."]
    #[doc = ""]
    #[doc = " @param s media file handle"]
    #[doc = " @param pkt The packet containing the data to be written."]
    #[doc = "            <br>"]
    #[doc = "            If the packet is reference-counted, this function will take"]
    #[doc = "            ownership of this reference and unreference it later when it sees"]
    #[doc = "            fit."]
    #[doc = "            The caller must not access the data through this reference after"]
    #[doc = "            this function returns. If the packet is not reference-counted,"]
    #[doc = "            libavformat will make a copy."]
    #[doc = "            <br>"]
    #[doc = "            This parameter can be NULL (at any time, not just at the end), to"]
    #[doc = "            flush the interleaving queues."]
    #[doc = "            <br>"]
    #[doc = "            Packet's @ref AVPacket.stream_index \"stream_index\" field must be"]
    #[doc = "            set to the index of the corresponding stream in @ref"]
    #[doc = "            AVFormatContext.streams \"s->streams\"."]
    #[doc = "            <br>"]
    #[doc = "            The timestamps (@ref AVPacket.pts \"pts\", @ref AVPacket.dts \"dts\")"]
    #[doc = "            must be set to correct values in the stream's timebase (unless the"]
    #[doc = "            output format is flagged with the AVFMT_NOTIMESTAMPS flag, then"]
    #[doc = "            they can be set to AV_NOPTS_VALUE)."]
    #[doc = "            The dts for subsequent packets in one stream must be strictly"]
    #[doc = "            increasing (unless the output format is flagged with the"]
    #[doc = "            AVFMT_TS_NONSTRICT, then they merely have to be nondecreasing)."]
    #[doc = "            @ref AVPacket.duration \"duration\") should also be set if known."]
    #[doc = ""]
    #[doc = " @return 0 on success, a negative AVERROR on error. Libavformat will always"]
    #[doc = "         take care of freeing the packet, even if this function fails."]
    #[doc = ""]
    #[doc = " @see av_write_frame(), AVFormatContext.max_interleave_delta"]
    pub fn av_interleaved_write_frame(
        s: *mut AVFormatContext,
        pkt: *mut AVPacket,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Write an uncoded frame to an output media file."]
    #[doc = ""]
    #[doc = " The frame must be correctly interleaved according to the container"]
    #[doc = " specification; if not, av_interleaved_write_uncoded_frame() must be used."]
    #[doc = ""]
    #[doc = " See av_interleaved_write_uncoded_frame() for details."]
    pub fn av_write_uncoded_frame(
        s: *mut AVFormatContext,
        stream_index: ::std::os::raw::c_int,
        frame: *mut AVFrame,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Write an uncoded frame to an output media file."]
    #[doc = ""]
    #[doc = " If the muxer supports it, this function makes it possible to write an AVFrame"]
    #[doc = " structure directly, without encoding it into a packet."]
    #[doc = " It is mostly useful for devices and similar special muxers that use raw"]
    #[doc = " video or PCM data and will not serialize it into a byte stream."]
    #[doc = ""]
    #[doc = " To test whether it is possible to use it with a given muxer and stream,"]
    #[doc = " use av_write_uncoded_frame_query()."]
    #[doc = ""]
    #[doc = " The caller gives up ownership of the frame and must not access it"]
    #[doc = " afterwards."]
    #[doc = ""]
    #[doc = " @return  >=0 for success, a negative code on error"]
    pub fn av_interleaved_write_uncoded_frame(
        s: *mut AVFormatContext,
        stream_index: ::std::os::raw::c_int,
        frame: *mut AVFrame,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Test whether a muxer supports uncoded frame."]
    #[doc = ""]
    #[doc = " @return  >=0 if an uncoded frame can be written to that muxer and stream,"]
    #[doc = "          <0 if not"]
    pub fn av_write_uncoded_frame_query(
        s: *mut AVFormatContext,
        stream_index: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Write the stream trailer to an output media file and free the"]
    #[doc = " file private data."]
    #[doc = ""]
    #[doc = " May only be called after a successful call to avformat_write_header."]
    #[doc = ""]
    #[doc = " @param s media file handle"]
    #[doc = " @return 0 if OK, AVERROR_xxx on error"]
    pub fn av_write_trailer(s: *mut AVFormatContext) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Return the output format in the list of registered output formats"]
    #[doc = " which best matches the provided parameters, or return NULL if"]
    #[doc = " there is no match."]
    #[doc = ""]
    #[doc = " @param short_name if non-NULL checks if short_name matches with the"]
    #[doc = " names of the registered formats"]
    #[doc = " @param filename if non-NULL checks if filename terminates with the"]
    #[doc = " extensions of the registered formats"]
    #[doc = " @param mime_type if non-NULL checks if mime_type matches with the"]
    #[doc = " MIME type of the registered formats"]
    pub fn av_guess_format(
        short_name: *const ::std::os::raw::c_char,
        filename: *const ::std::os::raw::c_char,
        mime_type: *const ::std::os::raw::c_char,
    ) -> *const AVOutputFormat;
}
extern "C" {
    #[doc = " Guess the codec ID based upon muxer and filename."]
    pub fn av_guess_codec(
        fmt: *const AVOutputFormat,
        short_name: *const ::std::os::raw::c_char,
        filename: *const ::std::os::raw::c_char,
        mime_type: *const ::std::os::raw::c_char,
        type_: AVMediaType,
    ) -> AVCodecID;
}
extern "C" {
    #[doc = " Get timing information for the data currently output."]
    #[doc = " The exact meaning of \"currently output\" depends on the format."]
    #[doc = " It is mostly relevant for devices that have an internal buffer and/or"]
    #[doc = " work in real time."]
    #[doc = " @param s          media file handle"]
    #[doc = " @param stream     stream in the media file"]
    #[doc = " @param[out] dts   DTS of the last packet output for the stream, in stream"]
    #[doc = "                   time_base units"]
    #[doc = " @param[out] wall  absolute time when that packet whas output,"]
    #[doc = "                   in microsecond"]
    #[doc = " @return  0 if OK, AVERROR(ENOSYS) if the format does not support it"]
    #[doc = " Note: some formats or devices may not allow to measure dts and wall"]
    #[doc = " atomically."]
    pub fn av_get_output_timestamp(
        s: *mut AVFormatContext,
        stream: ::std::os::raw::c_int,
        dts: *mut i64,
        wall: *mut i64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Send a nice hexadecimal dump of a buffer to the specified file stream."]
    #[doc = ""]
    #[doc = " @param f The file stream pointer where the dump should be sent to."]
    #[doc = " @param buf buffer"]
    #[doc = " @param size buffer size"]
    #[doc = ""]
    #[doc = " @see av_hex_dump_log, av_pkt_dump2, av_pkt_dump_log2"]
    pub fn av_hex_dump(f: *mut FILE, buf: *const u8, size: ::std::os::raw::c_int);
}
extern "C" {
    #[doc = " Send a nice hexadecimal dump of a buffer to the log."]
    #[doc = ""]
    #[doc = " @param avcl A pointer to an arbitrary struct of which the first field is a"]
    #[doc = " pointer to an AVClass struct."]
    #[doc = " @param level The importance level of the message, lower values signifying"]
    #[doc = " higher importance."]
    #[doc = " @param buf buffer"]
    #[doc = " @param size buffer size"]
    #[doc = ""]
    #[doc = " @see av_hex_dump, av_pkt_dump2, av_pkt_dump_log2"]
    pub fn av_hex_dump_log(
        avcl: *mut ::std::os::raw::c_void,
        level: ::std::os::raw::c_int,
        buf: *const u8,
        size: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[doc = " Send a nice dump of a packet to the specified file stream."]
    #[doc = ""]
    #[doc = " @param f The file stream pointer where the dump should be sent to."]
    #[doc = " @param pkt packet to dump"]
    #[doc = " @param dump_payload True if the payload must be displayed, too."]
    #[doc = " @param st AVStream that the packet belongs to"]
    pub fn av_pkt_dump2(
        f: *mut FILE,
        pkt: *const AVPacket,
        dump_payload: ::std::os::raw::c_int,
        st: *const AVStream,
    );
}
extern "C" {
    #[doc = " Send a nice dump of a packet to the log."]
    #[doc = ""]
    #[doc = " @param avcl A pointer to an arbitrary struct of which the first field is a"]
    #[doc = " pointer to an AVClass struct."]
    #[doc = " @param level The importance level of the message, lower values signifying"]
    #[doc = " higher importance."]
    #[doc = " @param pkt packet to dump"]
    #[doc = " @param dump_payload True if the payload must be displayed, too."]
    #[doc = " @param st AVStream that the packet belongs to"]
    pub fn av_pkt_dump_log2(
        avcl: *mut ::std::os::raw::c_void,
        level: ::std::os::raw::c_int,
        pkt: *const AVPacket,
        dump_payload: ::std::os::raw::c_int,
        st: *const AVStream,
    );
}
extern "C" {
    #[doc = " Get the AVCodecID for the given codec tag tag."]
    #[doc = " If no codec id is found returns AV_CODEC_ID_NONE."]
    #[doc = ""]
    #[doc = " @param tags list of supported codec_id-codec_tag pairs, as stored"]
    #[doc = " in AVInputFormat.codec_tag and AVOutputFormat.codec_tag"]
    #[doc = " @param tag  codec tag to match to a codec ID"]
    pub fn av_codec_get_id(
        tags: *const *const AVCodecTag,
        tag: ::std::os::raw::c_uint,
    ) -> AVCodecID;
}
extern "C" {
    #[doc = " Get the codec tag for the given codec id id."]
    #[doc = " If no codec tag is found returns 0."]
    #[doc = ""]
    #[doc = " @param tags list of supported codec_id-codec_tag pairs, as stored"]
    #[doc = " in AVInputFormat.codec_tag and AVOutputFormat.codec_tag"]
    #[doc = " @param id   codec ID to match to a codec tag"]
    pub fn av_codec_get_tag(
        tags: *const *const AVCodecTag,
        id: AVCodecID,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Get the codec tag for the given codec id."]
    #[doc = ""]
    #[doc = " @param tags list of supported codec_id - codec_tag pairs, as stored"]
    #[doc = " in AVInputFormat.codec_tag and AVOutputFormat.codec_tag"]
    #[doc = " @param id codec id that should be searched for in the list"]
    #[doc = " @param tag A pointer to the found tag"]
    #[doc = " @return 0 if id was not found in tags, > 0 if it was found"]
    pub fn av_codec_get_tag2(
        tags: *const *const AVCodecTag,
        id: AVCodecID,
        tag: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn av_find_default_stream_index(s: *mut AVFormatContext) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get the index for a specific timestamp."]
    #[doc = ""]
    #[doc = " @param st        stream that the timestamp belongs to"]
    #[doc = " @param timestamp timestamp to retrieve the index for"]
    #[doc = " @param flags if AVSEEK_FLAG_BACKWARD then the returned index will correspond"]
    #[doc = "                 to the timestamp which is <= the requested one, if backward"]
    #[doc = "                 is 0, then it will be >="]
    #[doc = "              if AVSEEK_FLAG_ANY seek to any frame, only keyframes otherwise"]
    #[doc = " @return < 0 if no such timestamp could be found"]
    pub fn av_index_search_timestamp(
        st: *mut AVStream,
        timestamp: i64,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get the index entry count for the given AVStream."]
    #[doc = ""]
    #[doc = " @param st stream"]
    #[doc = " @return the number of index entries in the stream"]
    pub fn avformat_index_get_entries_count(st: *const AVStream) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get the AVIndexEntry corresponding to the given index."]
    #[doc = ""]
    #[doc = " @param st          Stream containing the requested AVIndexEntry."]
    #[doc = " @param idx         The desired index."]
    #[doc = " @return A pointer to the requested AVIndexEntry if it exists, NULL otherwise."]
    #[doc = ""]
    #[doc = " @note The pointer returned by this function is only guaranteed to be valid"]
    #[doc = "       until any function that takes the stream or the parent AVFormatContext"]
    #[doc = "       as input argument is called."]
    pub fn avformat_index_get_entry(
        st: *mut AVStream,
        idx: ::std::os::raw::c_int,
    ) -> *const AVIndexEntry;
}
extern "C" {
    #[doc = " Get the AVIndexEntry corresponding to the given timestamp."]
    #[doc = ""]
    #[doc = " @param st          Stream containing the requested AVIndexEntry."]
    #[doc = " @param timestamp   Timestamp to retrieve the index entry for."]
    #[doc = " @param flags       If AVSEEK_FLAG_BACKWARD then the returned entry will correspond"]
    #[doc = "                    to the timestamp which is <= the requested one, if backward"]
    #[doc = "                    is 0, then it will be >="]
    #[doc = "                    if AVSEEK_FLAG_ANY seek to any frame, only keyframes otherwise."]
    #[doc = " @return A pointer to the requested AVIndexEntry if it exists, NULL otherwise."]
    #[doc = ""]
    #[doc = " @note The pointer returned by this function is only guaranteed to be valid"]
    #[doc = "       until any function that takes the stream or the parent AVFormatContext"]
    #[doc = "       as input argument is called."]
    pub fn avformat_index_get_entry_from_timestamp(
        st: *mut AVStream,
        wanted_timestamp: i64,
        flags: ::std::os::raw::c_int,
    ) -> *const AVIndexEntry;
}
extern "C" {
    #[doc = " Add an index entry into a sorted list. Update the entry if the list"]
    #[doc = " already contains it."]
    #[doc = ""]
    #[doc = " @param timestamp timestamp in the time base of the given stream"]
    pub fn av_add_index_entry(
        st: *mut AVStream,
        pos: i64,
        timestamp: i64,
        size: ::std::os::raw::c_int,
        distance: ::std::os::raw::c_int,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Split a URL string into components."]
    #[doc = ""]
    #[doc = " The pointers to buffers for storing individual components may be null,"]
    #[doc = " in order to ignore that component. Buffers for components not found are"]
    #[doc = " set to empty strings. If the port is not found, it is set to a negative"]
    #[doc = " value."]
    #[doc = ""]
    #[doc = " @param proto the buffer for the protocol"]
    #[doc = " @param proto_size the size of the proto buffer"]
    #[doc = " @param authorization the buffer for the authorization"]
    #[doc = " @param authorization_size the size of the authorization buffer"]
    #[doc = " @param hostname the buffer for the host name"]
    #[doc = " @param hostname_size the size of the hostname buffer"]
    #[doc = " @param port_ptr a pointer to store the port number in"]
    #[doc = " @param path the buffer for the path"]
    #[doc = " @param path_size the size of the path buffer"]
    #[doc = " @param url the URL to split"]
    pub fn av_url_split(
        proto: *mut ::std::os::raw::c_char,
        proto_size: ::std::os::raw::c_int,
        authorization: *mut ::std::os::raw::c_char,
        authorization_size: ::std::os::raw::c_int,
        hostname: *mut ::std::os::raw::c_char,
        hostname_size: ::std::os::raw::c_int,
        port_ptr: *mut ::std::os::raw::c_int,
        path: *mut ::std::os::raw::c_char,
        path_size: ::std::os::raw::c_int,
        url: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    #[doc = " Print detailed information about the input or output format, such as"]
    #[doc = " duration, bitrate, streams, container, programs, metadata, side data,"]
    #[doc = " codec and time base."]
    #[doc = ""]
    #[doc = " @param ic        the context to analyze"]
    #[doc = " @param index     index of the stream to dump information about"]
    #[doc = " @param url       the URL to print, such as source or destination file"]
    #[doc = " @param is_output Select whether the specified context is an input(0) or output(1)"]
    pub fn av_dump_format(
        ic: *mut AVFormatContext,
        index: ::std::os::raw::c_int,
        url: *const ::std::os::raw::c_char,
        is_output: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[doc = " Return in 'buf' the path with '%d' replaced by a number."]
    #[doc = ""]
    #[doc = " Also handles the '%0nd' format where 'n' is the total number"]
    #[doc = " of digits and '%%'."]
    #[doc = ""]
    #[doc = " @param buf destination buffer"]
    #[doc = " @param buf_size destination buffer size"]
    #[doc = " @param path numbered sequence string"]
    #[doc = " @param number frame number"]
    #[doc = " @param flags AV_FRAME_FILENAME_FLAGS_*"]
    #[doc = " @return 0 if OK, -1 on format error"]
    pub fn av_get_frame