/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

/// ResponsesUninstallTokenV1 : An uninstall token for a device

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct ResponsesUninstallTokenV1 {
    /// The device the token belongs to
    #[serde(rename = "device_id")]
    pub device_id: String,
    /// The seedID of the uninstall token
    #[serde(rename = "seed_id")]
    pub seed_id: i32,
    /// The uninstall token
    #[serde(rename = "uninstall_token")]
    pub uninstall_token: String,
}

impl ResponsesUninstallTokenV1 {
    /// An uninstall token for a device
    pub fn new(device_id: String, seed_id: i32, uninstall_token: String) -> ResponsesUninstallTokenV1 {
        ResponsesUninstallTokenV1 { device_id, seed_id, uninstall_token }
    }
}
