/*
 * CrowdStrike API Specification
 *
 * Use this API specification as a reference for the API endpoints you can use to interact with your Falcon environment. These endpoints support authentication via OAuth2 and interact with detections and network containment. For detailed usage guides and more information about API endpoints that don't yet support OAuth2, see our [documentation inside the Falcon console](https://falcon.crowdstrike.com/support/documentation). To use the APIs described below, combine the base URL with the path shown for each API endpoint. For commercial cloud customers, your base URL is `https://api.crowdstrike.com`. Each API endpoint requires authorization via an OAuth2 token. Your first API request should retrieve an OAuth2 token using the `oauth2/token` endpoint, such as `https://api.crowdstrike.com/oauth2/token`. For subsequent requests, include the OAuth2 token in an HTTP authorization header. Tokens expire after 30 minutes, after which you should make a new token request to continue making API requests.
 *
 * The version of the OpenAPI document: rolling
 *
 * Generated by: https://openapi-generator.tech
 */

/// ResponsesIoaRuleGroupV1 : An IOA rule group which contains a set of IOA rules

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct ResponsesIoaRuleGroupV1 {
    #[serde(rename = "comment")]
    pub comment: String,
    /// The last attempted time CFS got this data on the rule group
    #[serde(rename = "committed_timestamp")]
    pub committed_timestamp: String,
    /// The email of the user which created the rule group
    #[serde(rename = "created_by")]
    pub created_by: String,
    /// The time at which the policy was created
    #[serde(rename = "created_timestamp")]
    pub created_timestamp: String,
    #[serde(rename = "customer_id")]
    pub customer_id: String,
    #[serde(rename = "deleted")]
    pub deleted: bool,
    /// An additional description of the group or the rules it contains
    #[serde(rename = "description")]
    pub description: String,
    #[serde(rename = "enabled")]
    pub enabled: bool,
    /// The identifier of this IOA rule group
    #[serde(rename = "id")]
    pub id: String,
    /// The email of the user which last modified the rule group
    #[serde(rename = "modified_by")]
    pub modified_by: String,
    /// The time at which the policy was last modified
    #[serde(rename = "modified_timestamp")]
    pub modified_timestamp: String,
    /// The name of the group
    #[serde(rename = "name")]
    pub name: String,
    #[serde(rename = "platform")]
    pub platform: String,
    #[serde(rename = "rule_ids")]
    pub rule_ids: Vec<String>,
    #[serde(rename = "version")]
    pub version: i64,
}

impl ResponsesIoaRuleGroupV1 {
    /// An IOA rule group which contains a set of IOA rules
    pub fn new(
        comment: String,
        committed_timestamp: String,
        created_by: String,
        created_timestamp: String,
        customer_id: String,
        deleted: bool,
        description: String,
        enabled: bool,
        id: String,
        modified_by: String,
        modified_timestamp: String,
        name: String,
        platform: String,
        rule_ids: Vec<String>,
        version: i64,
    ) -> ResponsesIoaRuleGroupV1 {
        ResponsesIoaRuleGroupV1 {
            comment,
            committed_timestamp,
            created_by,
            created_timestamp,
            customer_id,
            deleted,
            description,
            enabled,
            id,
            modified_by,
            modified_timestamp,
            name,
            platform,
            rule_ids,
            version,
        }
    }
}
